/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.awt.PaintUtils;
import com.bric.swing.ColorPicker;
import com.bric.swing.ColorPickerPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JSlider;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;

class ColorPickerSliderUI
extends BasicSliderUI {
    ColorPicker colorPicker;
    int ARROW_HALF = 8;
    int[] intArray;
    BufferedImage bi;
    int lastMode;
    MouseInputAdapter myMouseListener;

    ColorPickerSliderUI(JSlider b, ColorPicker cp) {
        super(b);
        this.intArray = new int[Toolkit.getDefaultToolkit().getScreenSize().height];
        this.bi = new BufferedImage(1, this.intArray.length, 1);
        this.lastMode = -1;
        this.myMouseListener = new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                ColorPickerSliderUI.this.slider.setValueIsAdjusting(true);
                this.updateSliderValue(e);
            }

            private void updateSliderValue(MouseEvent e) {
                int v;
                if (ColorPickerSliderUI.this.slider.getOrientation() == 0) {
                    int x = e.getX();
                    v = ColorPickerSliderUI.this.valueForXPosition(x);
                } else {
                    int y = e.getY();
                    v = ColorPickerSliderUI.this.valueForYPosition(y);
                }
                ColorPickerSliderUI.this.slider.setValue(v);
            }

            public void mouseReleased(MouseEvent e) {
                this.updateSliderValue(e);
                ColorPickerSliderUI.this.slider.setValueIsAdjusting(false);
            }

            public void mouseDragged(MouseEvent e) {
                this.updateSliderValue(e);
            }
        };
        this.colorPicker = cp;
        cp.getColorPanel().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ColorPickerSliderUI.this.calculateGeometry();
                ColorPickerSliderUI.this.slider.repaint();
            }
        });
    }

    public void paintThumb(Graphics g) {
        int y = this.thumbRect.y + this.thumbRect.height / 2;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, y - this.ARROW_HALF);
        polygon.addPoint(this.ARROW_HALF, y);
        polygon.addPoint(0, y + this.ARROW_HALF);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.fill(polygon);
        g2.setColor(Color.white);
        g2.draw(polygon);
    }

    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.thumbRect.height += 4;
        this.thumbRect.y -= 2;
    }

    protected void calculateTrackRect() {
        super.calculateTrackRect();
        ColorPickerPanel cp = this.colorPicker.getColorPanel();
        int size = Math.min(ColorPickerPanel.MAX_SIZE, Math.min(cp.getWidth(), cp.getHeight()));
        int max = this.slider.getHeight() - this.ARROW_HALF * 2 - 2;
        if (size > max) {
            size = max;
        }
        this.trackRect.y = this.slider.getHeight() / 2 - size / 2;
        this.trackRect.height = size;
    }

    public synchronized void paintTrack(Graphics g) {
        int y;
        int mode = this.colorPicker.getMode();
        if (mode == 0 || mode == 1 || mode == 2) {
            float[] hsb = this.colorPicker.getHSB();
            if (mode == 0) {
                y = 0;
                while (y < this.trackRect.height) {
                    float hue = (float)y / (float)this.trackRect.height;
                    this.intArray[y] = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                    ++y;
                }
            } else if (mode == 2) {
                y = 0;
                while (y < this.trackRect.height) {
                    float sat = 1.0f - (float)y / (float)this.trackRect.height;
                    this.intArray[y] = Color.HSBtoRGB(hsb[0], sat, hsb[2]);
                    ++y;
                }
            } else {
                y = 0;
                while (y < this.trackRect.height) {
                    float bri = 1.0f - (float)y / (float)this.trackRect.height;
                    this.intArray[y] = Color.HSBtoRGB(hsb[0], hsb[1], bri);
                    ++y;
                }
            }
        } else {
            int[] rgb = this.colorPicker.getRGB();
            if (mode == 3) {
                y = 0;
                while (y < this.trackRect.height) {
                    int red = 255 - (int)((double)(y * 255 / this.trackRect.height) + 0.49);
                    this.intArray[y] = (red << 16) + (rgb[1] << 8) + rgb[2];
                    ++y;
                }
            } else if (mode == 4) {
                y = 0;
                while (y < this.trackRect.height) {
                    int green = 255 - (int)((double)(y * 255 / this.trackRect.height) + 0.49);
                    this.intArray[y] = (rgb[0] << 16) + (green << 8) + rgb[2];
                    ++y;
                }
            } else if (mode == 5) {
                y = 0;
                while (y < this.trackRect.height) {
                    int blue = 255 - (int)((double)(y * 255 / this.trackRect.height) + 0.49);
                    this.intArray[y] = (rgb[0] << 16) + (rgb[1] << 8) + blue;
                    ++y;
                }
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = new Rectangle(6, this.trackRect.y, 14, this.trackRect.height);
        if (this.slider.hasFocus()) {
            PaintUtils.paintFocus(g2, r, 3);
        }
        this.bi.getRaster().setDataElements(0, 0, 1, this.trackRect.height, this.intArray);
        TexturePaint p = new TexturePaint(this.bi, new Rectangle(0, this.trackRect.y, 1, this.bi.getHeight()));
        g2.setPaint(p);
        g2.fillRect(r.x, r.y, r.width, r.height);
        PaintUtils.drawBevel(g2, r);
    }

    public void paintFocus(Graphics g) {
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        slider.removeMouseListener(this.trackListener);
        slider.removeMouseMotionListener(this.trackListener);
        slider.addMouseListener(this.myMouseListener);
        slider.addMouseMotionListener(this.myMouseListener);
        slider.setOpaque(false);
    }

    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.myMouseListener);
        slider.removeMouseMotionListener(this.myMouseListener);
    }
}

