/*
    This file is part of Repetier-Firmware.

    Repetier-Firmware is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Repetier-Firmware is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Repetier-Firmware.  If not, see <http://www.gnu.org/licenses/>.

    This firmware is a nearly complete rewrite of the sprinter firmware
    by kliment (https://github.com/kliment/Sprinter)
    which based on Tonokip RepRap firmware rewrite based off of Hydra-mmm firmware.
*/

#include "Repetier.h"

#if UI_DISPLAY_TYPE != NO_DISPLAY

#if LANGUAGE_EN_ACTIVE+LANGUAGE_DE_ACTIVE+LANGUAGE_ES_ACTIVE+LANGUAGE_PT_ACTIVE+LANGUAGE_FR_ACTIVE+LANGUAGE_NL_ACTIVE+LANGUAGE_IT_ACTIVE+LANGUAGE_SE_ACTIVE+LANGUAGE_CZ_ACTIVE+LANGUAGE_PL_ACTIVE+LANGUAGE_TR_ACTIVE < 1
#error No language for diplay selected
#endif // LANGUAGE_EN_ACTIVE

#define TRANS(x) UI_STRING(F ## x,x)

// Translations of ui

#if LANGUAGE_EN_ACTIVE
TRANS(UI_TEXT_ON_EN);
TRANS(UI_TEXT_OFF_EN);
TRANS(UI_TEXT_NA_EN);
TRANS(UI_TEXT_YES_EN);
TRANS(UI_TEXT_NO_EN);
TRANS(UI_TEXT_PRINT_POS_EN);
TRANS(UI_TEXT_PRINTING_EN);
TRANS(UI_TEXT_IDLE_EN);
TRANS(UI_TEXT_NOSDCARD_EN);
TRANS(UI_TEXT_ERROR_EN);
TRANS(UI_TEXT_BACK_EN);
TRANS(UI_TEXT_QUICK_SETTINGS_EN);
TRANS(UI_TEXT_ERRORMSG_EN);
TRANS(UI_TEXT_CONFIGURATION_EN);
TRANS(UI_TEXT_POSITION_EN);
TRANS(UI_TEXT_EXTRUDER_EN);
TRANS(UI_TEXT_SD_CARD_EN);
TRANS(UI_TEXT_DEBUGGING_EN);
TRANS(UI_TEXT_HOME_DELTA_EN);
TRANS(UI_TEXT_HOME_ALL_EN);
TRANS(UI_TEXT_HOME_X_EN);
TRANS(UI_TEXT_HOME_Y_EN);
TRANS(UI_TEXT_HOME_Z_EN);
TRANS(UI_TEXT_PREHEAT_PLA_EN);
TRANS(UI_TEXT_PREHEAT_ABS_EN);
TRANS(UI_TEXT_LIGHTS_ONOFF_EN);
TRANS(UI_TEXT_COOLDOWN_EN);
TRANS(UI_TEXT_SET_TO_ORIGIN_EN);
TRANS(UI_TEXT_DISABLE_STEPPER_EN);
TRANS(UI_TEXT_X_POSITION_EN);
TRANS(UI_TEXT_X_POS_FAST_EN);
TRANS(UI_TEXT_Y_POSITION_EN);
TRANS(UI_TEXT_Y_POS_FAST_EN);
TRANS(UI_TEXT_Z_POSITION_EN);
TRANS(UI_TEXT_Z_POS_FAST_EN);
TRANS(UI_TEXT_E_POSITION_EN);
TRANS(UI_TEXT_BED_TEMP_EN);
TRANS(UI_TEXT_EXTR0_TEMP_EN);
TRANS(UI_TEXT_EXTR1_TEMP_EN);
TRANS(UI_TEXT_EXTR2_TEMP_EN);
TRANS(UI_TEXT_EXTR0_OFF_EN);
TRANS(UI_TEXT_EXTR1_OFF_EN);
TRANS(UI_TEXT_EXTR2_OFF_EN);
TRANS(UI_TEXT_EXTR0_SELECT_EN);
TRANS(UI_TEXT_EXTR1_SELECT_EN);
TRANS(UI_TEXT_EXTR2_SELECT_EN);
TRANS(UI_TEXT_EXTR_ORIGIN_EN);
TRANS(UI_TEXT_PRINT_X_EN);
TRANS(UI_TEXT_PRINT_Y_EN);
TRANS(UI_TEXT_PRINT_Z_EN);
TRANS(UI_TEXT_PRINT_Z_DELTA_EN);
TRANS(UI_TEXT_MOVE_X_EN);
TRANS(UI_TEXT_MOVE_Y_EN);
TRANS(UI_TEXT_MOVE_Z_EN);
TRANS(UI_TEXT_MOVE_Z_DELTA_EN);
TRANS(UI_TEXT_JERK_EN);
TRANS(UI_TEXT_ZJERK_EN);
TRANS(UI_TEXT_ACCELERATION_EN);
TRANS(UI_TEXT_STORE_TO_EEPROM_EN);
TRANS(UI_TEXT_LOAD_EEPROM_EN);
TRANS(UI_TEXT_DBG_ECHO_EN);
TRANS(UI_TEXT_DBG_INFO_EN);
TRANS(UI_TEXT_DBG_ERROR_EN);
TRANS(UI_TEXT_DBG_DRYRUN_EN);
TRANS(UI_TEXT_DBG_ENDSTOP_EN);
TRANS(UI_TEXT_OPS_OFF_EN);
TRANS(UI_TEXT_OPS_CLASSIC_EN);
TRANS(UI_TEXT_OPS_FAST_EN);
TRANS(UI_TEXT_OPS_RETRACT_EN);
TRANS(UI_TEXT_OPS_BACKSLASH_EN);
TRANS(UI_TEXT_OPS_MINDIST_EN);
TRANS(UI_TEXT_OPS_MOVE_AFTER_EN);
TRANS(UI_TEXT_ANTI_OOZE_EN);
TRANS(UI_TEXT_PRINT_FILE_EN);
TRANS(UI_TEXT_PAUSE_PRINT_EN);
TRANS(UI_TEXT_CONTINUE_PRINT_EN);
TRANS(UI_TEXT_UNMOUNT_CARD_EN);
TRANS(UI_TEXT_MOUNT_CARD_EN);
TRANS(UI_TEXT_DELETE_FILE_EN);
TRANS(UI_TEXT_FEEDRATE_EN);
TRANS(UI_TEXT_FEED_MAX_X_EN);
TRANS(UI_TEXT_FEED_MAX_Y_EN);
TRANS(UI_TEXT_FEED_MAX_Z_EN);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_EN);
TRANS(UI_TEXT_FEED_HOME_X_EN);
TRANS(UI_TEXT_FEED_HOME_Y_EN);
TRANS(UI_TEXT_FEED_HOME_Z_EN);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_EN);
TRANS(UI_TEXT_ACTION_XPOSITION4A_EN);
TRANS(UI_TEXT_ACTION_XPOSITION4B_EN);
TRANS(UI_TEXT_ACTION_XPOSITION4C_EN);
TRANS(UI_TEXT_ACTION_XPOSITION4D_EN);
TRANS(UI_TEXT_ACTION_YPOSITION4A_EN);
TRANS(UI_TEXT_ACTION_YPOSITION4B_EN);
TRANS(UI_TEXT_ACTION_YPOSITION4C_EN);
TRANS(UI_TEXT_ACTION_YPOSITION4D_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_EN);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_EN);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_EN);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_EN);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_EN);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_EN);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_EN);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_EN);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_EN);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_EN);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_EN);
TRANS(UI_TEXT_ACTION_XPOSITION2A_EN);
TRANS(UI_TEXT_ACTION_XPOSITION2B_EN);
TRANS(UI_TEXT_ACTION_YPOSITION2A_EN);
TRANS(UI_TEXT_ACTION_YPOSITION2B_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_EN);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_EN);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_EN);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_EN);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_EN);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_EN);
TRANS(UI_TEXT_FANSPEED_EN);
TRANS(UI_TEXT_ACTION_FANSPEED_EN);
TRANS(UI_TEXT_FAN_OFF_EN);
TRANS(UI_TEXT_FAN_25_EN);
TRANS(UI_TEXT_FAN_50_EN);
TRANS(UI_TEXT_FAN_75_EN);
TRANS(UI_TEXT_FAN_FULL_EN);
TRANS(UI_TEXT_STEPPER_INACTIVE_EN);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_EN);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_EN);
TRANS(UI_TEXT_POWER_INACTIVE_EN);
TRANS(UI_TEXT_POWER_INACTIVE2A_EN);
TRANS(UI_TEXT_POWER_INACTIVE2B_EN);
TRANS(UI_TEXT_GENERAL_EN);
TRANS(UI_TEXT_BAUDRATE_EN);
TRANS(UI_TEXT_EXTR_STEPS_EN);
TRANS(UI_TEXT_EXTR_START_FEED_EN);
TRANS(UI_TEXT_EXTR_MAX_FEED_EN);
TRANS(UI_TEXT_EXTR_ACCEL_EN);
TRANS(UI_TEXT_EXTR_WATCH_EN);
TRANS(UI_TEXT_EXTR_ADVANCE_L_EN);
TRANS(UI_TEXT_EXTR_ADVANCE_K_EN);
TRANS(UI_TEXT_EXTR_MANAGER_EN);
TRANS(UI_TEXT_EXTR_PGAIN_EN);
TRANS(UI_TEXT_EXTR_DEADTIME_EN);
TRANS(UI_TEXT_EXTR_DMAX_DT_EN);
TRANS(UI_TEXT_EXTR_IGAIN_EN);
TRANS(UI_TEXT_EXTR_DGAIN_EN);
TRANS(UI_TEXT_EXTR_DMIN_EN);
TRANS(UI_TEXT_EXTR_DMAX_EN);
TRANS(UI_TEXT_EXTR_PMAX_EN);
TRANS(UI_TEXT_EXTR_XOFF_EN);
TRANS(UI_TEXT_EXTR_YOFF_EN);
TRANS(UI_TEXT_STRING_HM_BANGBANG_EN);
TRANS(UI_TEXT_STRING_HM_PID_EN);
TRANS(UI_TEXT_STRING_ACTION_EN);
TRANS(UI_TEXT_HEATING_EXTRUDER_EN);
TRANS(UI_TEXT_HEATING_BED_EN);
TRANS(UI_TEXT_KILLED_EN);
TRANS(UI_TEXT_STEPPER_DISABLED_EN);
TRANS(UI_TEXT_EEPROM_STOREDA_EN);
TRANS(UI_TEXT_EEPROM_STOREDB_EN);
TRANS(UI_TEXT_EEPROM_LOADEDA_EN);
TRANS(UI_TEXT_EEPROM_LOADEDB_EN);
TRANS(UI_TEXT_UPLOADING_EN);
TRANS(UI_TEXT_PAGE_BUFFER_EN);
TRANS(UI_TEXT_PAGE_EXTRUDER_EN);
TRANS(UI_TEXT_PAGE_EXTRUDER1_EN);
TRANS(UI_TEXT_PAGE_EXTRUDER2_EN);
TRANS(UI_TEXT_PAGE_EXTRUDER3_EN);
TRANS(UI_TEXT_PAGE_BED_EN);
TRANS(UI_TEXT_SPEED_MULTIPLY_EN);
TRANS(UI_TEXT_FLOW_MULTIPLY_EN);
TRANS(UI_TEXT_SHOW_MEASUREMENT_EN);
TRANS(UI_TEXT_RESET_MEASUREMENT_EN);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_EN);
TRANS(UI_TEXT_ZCALIB_EN);
TRANS(UI_TEXT_SET_P1_EN);
TRANS(UI_TEXT_SET_P2_EN);
TRANS(UI_TEXT_SET_P3_EN);
TRANS(UI_TEXT_CALCULATE_LEVELING_EN);
TRANS(UI_TEXT_LEVEL_EN);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_EN);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_EN);
TRANS(UI_TEXT_SD_REMOVED_EN);
TRANS(UI_TEXT_SD_INSERTED_EN);
TRANS(UI_TEXT_PRINTER_READY_EN);
TRANS(UI_TEXT_PRINTTIME_DAYS_EN);
TRANS(UI_TEXT_PRINTTIME_HOURS_EN);
TRANS(UI_TEXT_PRINTTIME_MINUTES_EN);
TRANS(UI_TEXT_PRINT_TIME_EN);
TRANS(UI_TEXT_PRINT_FILAMENT_EN);
TRANS(UI_TEXT_PRINTED_EN);
TRANS(UI_TEXT_POWER_EN);
TRANS(UI_TEXT_STRING_HM_DEADTIME_EN);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_EN);
TRANS(UI_TEXT_STOP_PRINT_EN);
TRANS(UI_TEXT_Z_BABYSTEPPING_EN);
TRANS(UI_TEXT_CHANGE_FILAMENT_EN);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_EN);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_EN);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_EN);
TRANS(UI_TEXT_CLICK_DONE_EN);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_EN);
TRANS(UI_TEXT_SERVOPOS_EN);
TRANS(UI_TEXT_IGNORE_M106_EN);
TRANS(UI_TEXT_WIZ_REHEAT1_EN);
TRANS(UI_TEXT_WIZ_REHEAT2_EN);
TRANS(UI_TEXT_WIZ_WAITTEMP1_EN);
TRANS(UI_TEXT_WIZ_WAITTEMP2_EN);
TRANS(UI_TEXT_EXTRUDER_JAM_EN);
TRANS(UI_TEXT_STANDBY_EN);
TRANS(UI_TEXT_BED_COATING_EN);
TRANS(UI_TEXT_BED_COATING_SET1_EN);
TRANS(UI_TEXT_BED_COATING_SET2_EN);
TRANS(UI_TEXT_NOCOATING_EN);
TRANS(UI_TEXT_BUILDTAK_EN);
TRANS(UI_TEXT_KAPTON_EN);
TRANS(UI_TEXT_BLUETAPE_EN);
TRANS(UI_TEXT_PETTAPE_EN);
TRANS(UI_TEXT_GLUESTICK_EN);
TRANS(UI_TEXT_CUSTOM_EN);
TRANS(UI_TEXT_COATING_CUSTOM_EN);
TRANS(UI_TEXT_LANGUAGE_EN);
TRANS(UI_TEXT_MAINPAGE6_1_EN);
TRANS(UI_TEXT_MAINPAGE6_2_EN);
TRANS(UI_TEXT_MAINPAGE6_3_EN);
TRANS(UI_TEXT_MAINPAGE6_4_EN);
TRANS(UI_TEXT_MAINPAGE6_5_EN);
TRANS(UI_TEXT_MAINPAGE6_6_EN);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_EN);
TRANS(UI_TEXT_MAINPAGE_BED_EN);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_EN);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_EN);
TRANS(UI_TEXT_MAINPAGE_XY_EN);
TRANS(UI_TEXT_PRINT_TIME_VALUE_EN);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_EN);
TRANS(UI_TEXT_METER_PRINTED_EN);
TRANS(UI_TEXT_STATUS_EN);
TRANS(UI_TEXT_EMPTY_EN);
TRANS(UI_TEXT_TEMP_SET_EN);
TRANS(UI_TEXT_CURRENT_TEMP_EN);
TRANS(UI_TEXT_COATING_THICKNESS_EN);
TRANS(UI_TEXT_EXTR3_TEMP_EN);
TRANS(UI_TEXT_EXTR4_TEMP_EN);
TRANS(UI_TEXT_EXTR5_TEMP_EN);
TRANS(UI_TEXT_EXTR3_OFF_EN);
TRANS(UI_TEXT_EXTR4_OFF_EN);
TRANS(UI_TEXT_EXTR5_OFF_EN);
TRANS(UI_TEXT_EXTR3_SELECT_EN);
TRANS(UI_TEXT_EXTR4_SELECT_EN);
TRANS(UI_TEXT_EXTR5_SELECT_EN);
TRANS(UI_TEXT_DITTO_0_EN);
TRANS(UI_TEXT_DITTO_1_EN);
TRANS(UI_TEXT_DITTO_2_EN);
TRANS(UI_TEXT_DITTO_3_EN);
TRANS(UI_TEXT_ZPROBE_HEIGHT_EN);
TRANS(UI_TEXT_OFFSETS_EN);
TRANS(UI_TEXT_X_OFFSET_EN);
TRANS(UI_TEXT_Y_OFFSET_EN);
TRANS(UI_TEXT_Z_OFFSET_EN);


PGM_P const translations_en[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_EN,
 FUI_TEXT_OFF_EN,
 FUI_TEXT_NA_EN,
 FUI_TEXT_YES_EN,
 FUI_TEXT_NO_EN,
 FUI_TEXT_PRINT_POS_EN,
 FUI_TEXT_PRINTING_EN,
 FUI_TEXT_IDLE_EN,
 FUI_TEXT_NOSDCARD_EN,
 FUI_TEXT_ERROR_EN,
 FUI_TEXT_BACK_EN,
 FUI_TEXT_QUICK_SETTINGS_EN,
 FUI_TEXT_ERRORMSG_EN,
 FUI_TEXT_CONFIGURATION_EN,
 FUI_TEXT_POSITION_EN,
 FUI_TEXT_EXTRUDER_EN,
 FUI_TEXT_SD_CARD_EN,
 FUI_TEXT_DEBUGGING_EN,
 FUI_TEXT_HOME_DELTA_EN,
 FUI_TEXT_HOME_ALL_EN,
 FUI_TEXT_HOME_X_EN,
 FUI_TEXT_HOME_Y_EN,
 FUI_TEXT_HOME_Z_EN,
 FUI_TEXT_PREHEAT_PLA_EN,
 FUI_TEXT_PREHEAT_ABS_EN,
 FUI_TEXT_LIGHTS_ONOFF_EN,
 FUI_TEXT_COOLDOWN_EN,
 FUI_TEXT_SET_TO_ORIGIN_EN,
 FUI_TEXT_DISABLE_STEPPER_EN,
 FUI_TEXT_X_POSITION_EN,
 FUI_TEXT_X_POS_FAST_EN,
 FUI_TEXT_Y_POSITION_EN,
 FUI_TEXT_Y_POS_FAST_EN,
 FUI_TEXT_Z_POSITION_EN,
 FUI_TEXT_Z_POS_FAST_EN,
 FUI_TEXT_E_POSITION_EN,
 FUI_TEXT_BED_TEMP_EN,
 FUI_TEXT_EXTR0_TEMP_EN,
 FUI_TEXT_EXTR1_TEMP_EN,
 FUI_TEXT_EXTR2_TEMP_EN,
 FUI_TEXT_EXTR0_OFF_EN,
 FUI_TEXT_EXTR1_OFF_EN,
 FUI_TEXT_EXTR2_OFF_EN,
 FUI_TEXT_EXTR0_SELECT_EN,
 FUI_TEXT_EXTR1_SELECT_EN,
 FUI_TEXT_EXTR2_SELECT_EN,
 FUI_TEXT_EXTR_ORIGIN_EN,
 FUI_TEXT_PRINT_X_EN,
 FUI_TEXT_PRINT_Y_EN,
 FUI_TEXT_PRINT_Z_EN,
 FUI_TEXT_PRINT_Z_DELTA_EN,
 FUI_TEXT_MOVE_X_EN,
 FUI_TEXT_MOVE_Y_EN,
 FUI_TEXT_MOVE_Z_EN,
 FUI_TEXT_MOVE_Z_DELTA_EN,
 FUI_TEXT_JERK_EN,
 FUI_TEXT_ZJERK_EN,
 FUI_TEXT_ACCELERATION_EN,
 FUI_TEXT_STORE_TO_EEPROM_EN,
 FUI_TEXT_LOAD_EEPROM_EN,
 FUI_TEXT_DBG_ECHO_EN,
 FUI_TEXT_DBG_INFO_EN,
 FUI_TEXT_DBG_ERROR_EN,
 FUI_TEXT_DBG_DRYRUN_EN,
 FUI_TEXT_OPS_OFF_EN,
 FUI_TEXT_OPS_CLASSIC_EN,
 FUI_TEXT_OPS_FAST_EN,
 FUI_TEXT_OPS_RETRACT_EN,
 FUI_TEXT_OPS_BACKSLASH_EN,
 FUI_TEXT_OPS_MINDIST_EN,
 FUI_TEXT_OPS_MOVE_AFTER_EN,
 FUI_TEXT_ANTI_OOZE_EN,
 FUI_TEXT_PRINT_FILE_EN,
 FUI_TEXT_PAUSE_PRINT_EN,
 FUI_TEXT_CONTINUE_PRINT_EN,
 FUI_TEXT_UNMOUNT_CARD_EN,
 FUI_TEXT_MOUNT_CARD_EN,
 FUI_TEXT_DELETE_FILE_EN,
 FUI_TEXT_FEEDRATE_EN,
 FUI_TEXT_FEED_MAX_X_EN,
 FUI_TEXT_FEED_MAX_Y_EN,
 FUI_TEXT_FEED_MAX_Z_EN,
 FUI_TEXT_FEED_MAX_Z_DELTA_EN,
 FUI_TEXT_FEED_HOME_X_EN,
 FUI_TEXT_FEED_HOME_Y_EN,
 FUI_TEXT_FEED_HOME_Z_EN,
 FUI_TEXT_FEED_HOME_Z_DELTA_EN,
 FUI_TEXT_ACTION_XPOSITION4A_EN,
 FUI_TEXT_ACTION_XPOSITION4B_EN,
 FUI_TEXT_ACTION_XPOSITION4C_EN,
 FUI_TEXT_ACTION_XPOSITION4D_EN,
 FUI_TEXT_ACTION_YPOSITION4A_EN,
 FUI_TEXT_ACTION_YPOSITION4B_EN,
 FUI_TEXT_ACTION_YPOSITION4C_EN,
 FUI_TEXT_ACTION_YPOSITION4D_EN,
 FUI_TEXT_ACTION_ZPOSITION4A_EN,
 FUI_TEXT_ACTION_ZPOSITION4B_EN,
 FUI_TEXT_ACTION_ZPOSITION4C_EN,
 FUI_TEXT_ACTION_ZPOSITION4D_EN,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_EN,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_EN,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_EN,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_EN,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_EN,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_EN,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_EN,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_EN,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_EN,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_EN,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_EN,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_EN,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_EN,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_EN,
 FUI_TEXT_ACTION_XPOSITION2A_EN,
 FUI_TEXT_ACTION_XPOSITION2B_EN,
 FUI_TEXT_ACTION_YPOSITION2A_EN,
 FUI_TEXT_ACTION_YPOSITION2B_EN,
 FUI_TEXT_ACTION_ZPOSITION2A_EN,
 FUI_TEXT_ACTION_ZPOSITION2B_EN,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_EN,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_EN,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_EN,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_EN,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_EN,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_EN,
 FUI_TEXT_FANSPEED_EN,
 FUI_TEXT_ACTION_FANSPEED_EN,
 FUI_TEXT_FAN_OFF_EN,
 FUI_TEXT_FAN_25_EN,
 FUI_TEXT_FAN_50_EN,
 FUI_TEXT_FAN_75_EN,
 FUI_TEXT_FAN_FULL_EN,
 FUI_TEXT_STEPPER_INACTIVE_EN,
 FUI_TEXT_STEPPER_INACTIVE2A_EN,
 FUI_TEXT_STEPPER_INACTIVE2B_EN,
 FUI_TEXT_POWER_INACTIVE_EN,
 FUI_TEXT_POWER_INACTIVE2A_EN,
 FUI_TEXT_POWER_INACTIVE2B_EN,
 FUI_TEXT_GENERAL_EN,
 FUI_TEXT_BAUDRATE_EN,
 FUI_TEXT_EXTR_STEPS_EN,
 FUI_TEXT_EXTR_START_FEED_EN,
 FUI_TEXT_EXTR_MAX_FEED_EN,
 FUI_TEXT_EXTR_ACCEL_EN,
 FUI_TEXT_EXTR_WATCH_EN,
 FUI_TEXT_EXTR_ADVANCE_L_EN,
 FUI_TEXT_EXTR_ADVANCE_K_EN,
 FUI_TEXT_EXTR_MANAGER_EN,
 FUI_TEXT_EXTR_PGAIN_EN,
 FUI_TEXT_EXTR_DEADTIME_EN,
 FUI_TEXT_EXTR_DMAX_DT_EN,
 FUI_TEXT_EXTR_IGAIN_EN,
 FUI_TEXT_EXTR_DGAIN_EN,
 FUI_TEXT_EXTR_DMIN_EN,
 FUI_TEXT_EXTR_DMAX_EN,
 FUI_TEXT_EXTR_PMAX_EN,
 FUI_TEXT_EXTR_XOFF_EN,
 FUI_TEXT_EXTR_YOFF_EN,
 FUI_TEXT_STRING_HM_BANGBANG_EN,
 FUI_TEXT_STRING_HM_PID_EN,
 FUI_TEXT_STRING_ACTION_EN,
 FUI_TEXT_HEATING_EXTRUDER_EN,
 FUI_TEXT_HEATING_BED_EN,
 FUI_TEXT_KILLED_EN,
 FUI_TEXT_STEPPER_DISABLED_EN,
 FUI_TEXT_EEPROM_STOREDA_EN,
 FUI_TEXT_EEPROM_STOREDB_EN,
 FUI_TEXT_EEPROM_LOADEDA_EN,
 FUI_TEXT_EEPROM_LOADEDB_EN,
 FUI_TEXT_UPLOADING_EN,
 FUI_TEXT_PAGE_BUFFER_EN,
 FUI_TEXT_PAGE_EXTRUDER_EN,
 FUI_TEXT_PAGE_EXTRUDER1_EN,
 FUI_TEXT_PAGE_EXTRUDER2_EN,
 FUI_TEXT_PAGE_EXTRUDER3_EN,
 FUI_TEXT_PAGE_BED_EN,
 FUI_TEXT_SPEED_MULTIPLY_EN,
 FUI_TEXT_FLOW_MULTIPLY_EN,
 FUI_TEXT_SHOW_MEASUREMENT_EN,
 FUI_TEXT_RESET_MEASUREMENT_EN,
 FUI_TEXT_SET_MEASURED_ORIGIN_EN,
 FUI_TEXT_ZCALIB_EN,
 FUI_TEXT_SET_P1_EN,
 FUI_TEXT_SET_P2_EN,
 FUI_TEXT_SET_P3_EN,
 FUI_TEXT_CALCULATE_LEVELING_EN,
 FUI_TEXT_LEVEL_EN,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_EN,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_EN,
 FUI_TEXT_SD_REMOVED_EN,
 FUI_TEXT_SD_INSERTED_EN,
 FUI_TEXT_PRINTER_READY_EN,
 FUI_TEXT_PRINTTIME_DAYS_EN,
 FUI_TEXT_PRINTTIME_HOURS_EN,
 FUI_TEXT_PRINTTIME_MINUTES_EN,
 FUI_TEXT_PRINT_TIME_EN,
 FUI_TEXT_PRINT_FILAMENT_EN,
 FUI_TEXT_PRINTED_EN,
 FUI_TEXT_POWER_EN,
 FUI_TEXT_STRING_HM_DEADTIME_EN,
 FUI_TEXT_STRING_HM_SLOWBANG_EN,
 FUI_TEXT_STOP_PRINT_EN,
 FUI_TEXT_Z_BABYSTEPPING_EN,
 FUI_TEXT_CHANGE_FILAMENT_EN,
 FUI_TEXT_WIZ_CH_FILAMENT1_EN,
 FUI_TEXT_WIZ_CH_FILAMENT2_EN,
 FUI_TEXT_WIZ_CH_FILAMENT3_EN,
 FUI_TEXT_CLICK_DONE_EN,
 FUI_TEXT_AUTOLEVEL_ONOFF_EN,
 FUI_TEXT_SERVOPOS_EN,
 FUI_TEXT_IGNORE_M106_EN,
 FUI_TEXT_WIZ_REHEAT1_EN,
 FUI_TEXT_WIZ_REHEAT2_EN,
 FUI_TEXT_WIZ_WAITTEMP1_EN,
 FUI_TEXT_WIZ_WAITTEMP2_EN,
 FUI_TEXT_EXTRUDER_JAM_EN,
 FUI_TEXT_STANDBY_EN,
 FUI_TEXT_BED_COATING_EN,
 FUI_TEXT_BED_COATING_SET1_EN,
 FUI_TEXT_BED_COATING_SET2_EN,
 FUI_TEXT_NOCOATING_EN,
 FUI_TEXT_BUILDTAK_EN,
 FUI_TEXT_KAPTON_EN,
 FUI_TEXT_BLUETAPE_EN,
 FUI_TEXT_PETTAPE_EN,
 FUI_TEXT_GLUESTICK_EN,
 FUI_TEXT_CUSTOM_EN,
 FUI_TEXT_COATING_CUSTOM_EN,
 FUI_TEXT_LANGUAGE_EN,
 FUI_TEXT_MAINPAGE6_1_EN,
 FUI_TEXT_MAINPAGE6_2_EN,
 FUI_TEXT_MAINPAGE6_3_EN,
 FUI_TEXT_MAINPAGE6_4_EN,
 FUI_TEXT_MAINPAGE6_5_EN,
 FUI_TEXT_MAINPAGE6_6_EN,
 FUI_TEXT_MAINPAGE_TEMP_BED_EN,
 FUI_TEXT_MAINPAGE_BED_EN,
 FUI_TEXT_MAINPAGE_Z_BUF_EN,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_EN,
 FUI_TEXT_MAINPAGE_XY_EN,
 FUI_TEXT_PRINT_TIME_VALUE_EN,
 FUI_TEXT_PRINT_FILAMENT_VALUE_EN,
 FUI_TEXT_METER_PRINTED_EN,
 FUI_TEXT_STATUS_EN,
 FUI_TEXT_EMPTY_EN,
 FUI_TEXT_TEMP_SET_EN,
 FUI_TEXT_CURRENT_TEMP_EN,
 FUI_TEXT_COATING_THICKNESS_EN,
 FUI_TEXT_EXTR3_TEMP_EN,
 FUI_TEXT_EXTR4_TEMP_EN,
 FUI_TEXT_EXTR5_TEMP_EN,
 FUI_TEXT_EXTR3_OFF_EN,
 FUI_TEXT_EXTR4_OFF_EN,
 FUI_TEXT_EXTR5_OFF_EN,
 FUI_TEXT_EXTR3_SELECT_EN,
 FUI_TEXT_EXTR4_SELECT_EN,
 FUI_TEXT_EXTR5_SELECT_EN,
 FUI_TEXT_DITTO_0_EN,
 FUI_TEXT_DITTO_1_EN,
 FUI_TEXT_DITTO_2_EN,
 FUI_TEXT_DITTO_3_EN,
 FUI_TEXT_ZPROBE_HEIGHT_EN,
 FUI_TEXT_OFFSETS_EN,
 FUI_TEXT_X_OFFSET_EN,
 FUI_TEXT_Y_OFFSET_EN,
 FUI_TEXT_Z_OFFSET_EN,
 FUI_TEXT_DBG_ENDSTOP_EN
};
#define LANG_EN_TABLE translations_en
#else
#define LANG_EN_TABLE NULL
#endif // LANGUAGE_EN_ACTIVE

#if LANGUAGE_DE_ACTIVE
TRANS(UI_TEXT_ON_DE);
TRANS(UI_TEXT_OFF_DE);
TRANS(UI_TEXT_NA_DE);
TRANS(UI_TEXT_YES_DE);
TRANS(UI_TEXT_NO_DE);
TRANS(UI_TEXT_PRINT_POS_DE);
TRANS(UI_TEXT_PRINTING_DE);
TRANS(UI_TEXT_IDLE_DE);
TRANS(UI_TEXT_NOSDCARD_DE);
TRANS(UI_TEXT_ERROR_DE);
TRANS(UI_TEXT_BACK_DE);
TRANS(UI_TEXT_QUICK_SETTINGS_DE);
TRANS(UI_TEXT_ERRORMSG_DE);
TRANS(UI_TEXT_CONFIGURATION_DE);
TRANS(UI_TEXT_POSITION_DE);
TRANS(UI_TEXT_EXTRUDER_DE);
TRANS(UI_TEXT_SD_CARD_DE);
TRANS(UI_TEXT_DEBUGGING_DE);
TRANS(UI_TEXT_HOME_DELTA_DE);
TRANS(UI_TEXT_HOME_ALL_DE);
TRANS(UI_TEXT_HOME_X_DE);
TRANS(UI_TEXT_HOME_Y_DE);
TRANS(UI_TEXT_HOME_Z_DE);
TRANS(UI_TEXT_PREHEAT_PLA_DE);
TRANS(UI_TEXT_PREHEAT_ABS_DE);
TRANS(UI_TEXT_LIGHTS_ONOFF_DE);
TRANS(UI_TEXT_COOLDOWN_DE);
TRANS(UI_TEXT_SET_TO_ORIGIN_DE);
TRANS(UI_TEXT_DISABLE_STEPPER_DE);
TRANS(UI_TEXT_X_POSITION_DE);
TRANS(UI_TEXT_X_POS_FAST_DE);
TRANS(UI_TEXT_Y_POSITION_DE);
TRANS(UI_TEXT_Y_POS_FAST_DE);
TRANS(UI_TEXT_Z_POSITION_DE);
TRANS(UI_TEXT_Z_POS_FAST_DE);
TRANS(UI_TEXT_E_POSITION_DE);
TRANS(UI_TEXT_BED_TEMP_DE);
TRANS(UI_TEXT_EXTR0_TEMP_DE);
TRANS(UI_TEXT_EXTR1_TEMP_DE);
TRANS(UI_TEXT_EXTR2_TEMP_DE);
TRANS(UI_TEXT_EXTR0_OFF_DE);
TRANS(UI_TEXT_EXTR1_OFF_DE);
TRANS(UI_TEXT_EXTR2_OFF_DE);
TRANS(UI_TEXT_EXTR0_SELECT_DE);
TRANS(UI_TEXT_EXTR1_SELECT_DE);
TRANS(UI_TEXT_EXTR2_SELECT_DE);
TRANS(UI_TEXT_EXTR_ORIGIN_DE);
TRANS(UI_TEXT_PRINT_X_DE);
TRANS(UI_TEXT_PRINT_Y_DE);
TRANS(UI_TEXT_PRINT_Z_DE);
TRANS(UI_TEXT_PRINT_Z_DELTA_DE);
TRANS(UI_TEXT_MOVE_X_DE);
TRANS(UI_TEXT_MOVE_Y_DE);
TRANS(UI_TEXT_MOVE_Z_DE);
TRANS(UI_TEXT_MOVE_Z_DELTA_DE);
TRANS(UI_TEXT_JERK_DE);
TRANS(UI_TEXT_ZJERK_DE);
TRANS(UI_TEXT_ACCELERATION_DE);
TRANS(UI_TEXT_STORE_TO_EEPROM_DE);
TRANS(UI_TEXT_LOAD_EEPROM_DE);
TRANS(UI_TEXT_DBG_ECHO_DE);
TRANS(UI_TEXT_DBG_INFO_DE);
TRANS(UI_TEXT_DBG_ERROR_DE);
TRANS(UI_TEXT_DBG_DRYRUN_DE);
TRANS(UI_TEXT_DBG_ENDSTOP_DE);
TRANS(UI_TEXT_OPS_OFF_DE);
TRANS(UI_TEXT_OPS_CLASSIC_DE);
TRANS(UI_TEXT_OPS_FAST_DE);
TRANS(UI_TEXT_OPS_RETRACT_DE);
TRANS(UI_TEXT_OPS_BACKSLASH_DE);
TRANS(UI_TEXT_OPS_MINDIST_DE);
TRANS(UI_TEXT_OPS_MOVE_AFTER_DE);
TRANS(UI_TEXT_ANTI_OOZE_DE);
TRANS(UI_TEXT_PRINT_FILE_DE);
TRANS(UI_TEXT_PAUSE_PRINT_DE);
TRANS(UI_TEXT_CONTINUE_PRINT_DE);
TRANS(UI_TEXT_UNMOUNT_CARD_DE);
TRANS(UI_TEXT_MOUNT_CARD_DE);
TRANS(UI_TEXT_DELETE_FILE_DE);
TRANS(UI_TEXT_FEEDRATE_DE);
TRANS(UI_TEXT_FEED_MAX_X_DE);
TRANS(UI_TEXT_FEED_MAX_Y_DE);
TRANS(UI_TEXT_FEED_MAX_Z_DE);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_DE);
TRANS(UI_TEXT_FEED_HOME_X_DE);
TRANS(UI_TEXT_FEED_HOME_Y_DE);
TRANS(UI_TEXT_FEED_HOME_Z_DE);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_DE);
TRANS(UI_TEXT_ACTION_XPOSITION4A_DE);
TRANS(UI_TEXT_ACTION_XPOSITION4B_DE);
TRANS(UI_TEXT_ACTION_XPOSITION4C_DE);
TRANS(UI_TEXT_ACTION_XPOSITION4D_DE);
TRANS(UI_TEXT_ACTION_YPOSITION4A_DE);
TRANS(UI_TEXT_ACTION_YPOSITION4B_DE);
TRANS(UI_TEXT_ACTION_YPOSITION4C_DE);
TRANS(UI_TEXT_ACTION_YPOSITION4D_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_DE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_DE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_DE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_DE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_DE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_DE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_DE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_DE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_DE);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_DE);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_DE);
TRANS(UI_TEXT_ACTION_XPOSITION2A_DE);
TRANS(UI_TEXT_ACTION_XPOSITION2B_DE);
TRANS(UI_TEXT_ACTION_YPOSITION2A_DE);
TRANS(UI_TEXT_ACTION_YPOSITION2B_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_DE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_DE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_DE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_DE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_DE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_DE);
TRANS(UI_TEXT_FANSPEED_DE);
TRANS(UI_TEXT_ACTION_FANSPEED_DE);
TRANS(UI_TEXT_FAN_OFF_DE);
TRANS(UI_TEXT_FAN_25_DE);
TRANS(UI_TEXT_FAN_50_DE);
TRANS(UI_TEXT_FAN_75_DE);
TRANS(UI_TEXT_FAN_FULL_DE);
TRANS(UI_TEXT_STEPPER_INACTIVE_DE);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_DE);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_DE);
TRANS(UI_TEXT_POWER_INACTIVE_DE);
TRANS(UI_TEXT_POWER_INACTIVE2A_DE);
TRANS(UI_TEXT_POWER_INACTIVE2B_DE);
TRANS(UI_TEXT_GENERAL_DE);
TRANS(UI_TEXT_BAUDRATE_DE);
TRANS(UI_TEXT_EXTR_STEPS_DE);
TRANS(UI_TEXT_EXTR_START_FEED_DE);
TRANS(UI_TEXT_EXTR_MAX_FEED_DE);
TRANS(UI_TEXT_EXTR_ACCEL_DE);
TRANS(UI_TEXT_EXTR_WATCH_DE);
TRANS(UI_TEXT_EXTR_ADVANCE_L_DE);
TRANS(UI_TEXT_EXTR_ADVANCE_K_DE);
TRANS(UI_TEXT_EXTR_MANAGER_DE);
TRANS(UI_TEXT_EXTR_PGAIN_DE);
TRANS(UI_TEXT_EXTR_DEADTIME_DE);
TRANS(UI_TEXT_EXTR_DMAX_DT_DE);
TRANS(UI_TEXT_EXTR_IGAIN_DE);
TRANS(UI_TEXT_EXTR_DGAIN_DE);
TRANS(UI_TEXT_EXTR_DMIN_DE);
TRANS(UI_TEXT_EXTR_DMAX_DE);
TRANS(UI_TEXT_EXTR_PMAX_DE);
TRANS(UI_TEXT_EXTR_XOFF_DE);
TRANS(UI_TEXT_EXTR_YOFF_DE);
TRANS(UI_TEXT_STRING_HM_BANGBANG_DE);
TRANS(UI_TEXT_STRING_HM_PID_DE);
TRANS(UI_TEXT_STRING_ACTION_DE);
TRANS(UI_TEXT_HEATING_EXTRUDER_DE);
TRANS(UI_TEXT_HEATING_BED_DE);
TRANS(UI_TEXT_KILLED_DE);
TRANS(UI_TEXT_STEPPER_DISABLED_DE);
TRANS(UI_TEXT_EEPROM_STOREDA_DE);
TRANS(UI_TEXT_EEPROM_STOREDB_DE);
TRANS(UI_TEXT_EEPROM_LOADEDA_DE);
TRANS(UI_TEXT_EEPROM_LOADEDB_DE);
TRANS(UI_TEXT_UPLOADING_DE);
TRANS(UI_TEXT_PAGE_BUFFER_DE);
TRANS(UI_TEXT_PAGE_EXTRUDER_DE);
TRANS(UI_TEXT_PAGE_EXTRUDER1_DE);
TRANS(UI_TEXT_PAGE_EXTRUDER2_DE);
TRANS(UI_TEXT_PAGE_EXTRUDER3_DE);
TRANS(UI_TEXT_PAGE_BED_DE);
TRANS(UI_TEXT_SPEED_MULTIPLY_DE);
TRANS(UI_TEXT_FLOW_MULTIPLY_DE);
TRANS(UI_TEXT_SHOW_MEASUREMENT_DE);
TRANS(UI_TEXT_RESET_MEASUREMENT_DE);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_DE);
TRANS(UI_TEXT_ZCALIB_DE);
TRANS(UI_TEXT_SET_P1_DE);
TRANS(UI_TEXT_SET_P2_DE);
TRANS(UI_TEXT_SET_P3_DE);
TRANS(UI_TEXT_CALCULATE_LEVELING_DE);
TRANS(UI_TEXT_LEVEL_DE);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_DE);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_DE);
TRANS(UI_TEXT_SD_REMOVED_DE);
TRANS(UI_TEXT_SD_INSERTED_DE);
TRANS(UI_TEXT_PRINTER_READY_DE);
TRANS(UI_TEXT_PRINTTIME_DAYS_DE);
TRANS(UI_TEXT_PRINTTIME_HOURS_DE);
TRANS(UI_TEXT_PRINTTIME_MINUTES_DE);
TRANS(UI_TEXT_PRINT_TIME_DE);
TRANS(UI_TEXT_PRINT_FILAMENT_DE);
TRANS(UI_TEXT_PRINTED_DE);
TRANS(UI_TEXT_POWER_DE);
TRANS(UI_TEXT_STRING_HM_DEADTIME_DE);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_DE);
TRANS(UI_TEXT_STOP_PRINT_DE);
TRANS(UI_TEXT_Z_BABYSTEPPING_DE);
TRANS(UI_TEXT_CHANGE_FILAMENT_DE);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_DE);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_DE);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_DE);
TRANS(UI_TEXT_CLICK_DONE_DE);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_DE);
TRANS(UI_TEXT_SERVOPOS_DE);
TRANS(UI_TEXT_IGNORE_M106_DE);
TRANS(UI_TEXT_WIZ_REHEAT1_DE);
TRANS(UI_TEXT_WIZ_REHEAT2_DE);
TRANS(UI_TEXT_WIZ_WAITTEMP1_DE);
TRANS(UI_TEXT_WIZ_WAITTEMP2_DE);
TRANS(UI_TEXT_EXTRUDER_JAM_DE);
TRANS(UI_TEXT_STANDBY_DE);
TRANS(UI_TEXT_BED_COATING_DE);
TRANS(UI_TEXT_BED_COATING_SET1_DE);
TRANS(UI_TEXT_BED_COATING_SET2_DE);
TRANS(UI_TEXT_NOCOATING_DE);
TRANS(UI_TEXT_BUILDTAK_DE);
TRANS(UI_TEXT_KAPTON_DE);
TRANS(UI_TEXT_BLUETAPE_DE);
TRANS(UI_TEXT_PETTAPE_DE);
TRANS(UI_TEXT_GLUESTICK_DE);
TRANS(UI_TEXT_CUSTOM_DE);
TRANS(UI_TEXT_COATING_CUSTOM_DE);
TRANS(UI_TEXT_LANGUAGE_DE);
TRANS(UI_TEXT_MAINPAGE6_1_DE);
TRANS(UI_TEXT_MAINPAGE6_2_DE);
TRANS(UI_TEXT_MAINPAGE6_3_DE);
TRANS(UI_TEXT_MAINPAGE6_4_DE);
TRANS(UI_TEXT_MAINPAGE6_5_DE);
TRANS(UI_TEXT_MAINPAGE6_6_DE);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_DE);
TRANS(UI_TEXT_MAINPAGE_BED_DE);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_DE);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_DE);
TRANS(UI_TEXT_MAINPAGE_XY_DE);
TRANS(UI_TEXT_PRINT_TIME_VALUE_DE);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_DE);
TRANS(UI_TEXT_METER_PRINTED_DE);
TRANS(UI_TEXT_STATUS_DE);
TRANS(UI_TEXT_EMPTY_DE);
TRANS(UI_TEXT_TEMP_SET_DE);
TRANS(UI_TEXT_CURRENT_TEMP_DE);
TRANS(UI_TEXT_COATING_THICKNESS_DE);
TRANS(UI_TEXT_EXTR3_TEMP_DE);
TRANS(UI_TEXT_EXTR4_TEMP_DE);
TRANS(UI_TEXT_EXTR5_TEMP_DE);
TRANS(UI_TEXT_EXTR3_OFF_DE);
TRANS(UI_TEXT_EXTR4_OFF_DE);
TRANS(UI_TEXT_EXTR5_OFF_DE);
TRANS(UI_TEXT_EXTR3_SELECT_DE);
TRANS(UI_TEXT_EXTR4_SELECT_DE);
TRANS(UI_TEXT_EXTR5_SELECT_DE);
TRANS(UI_TEXT_DITTO_0_DE);
TRANS(UI_TEXT_DITTO_1_DE);
TRANS(UI_TEXT_DITTO_2_DE);
TRANS(UI_TEXT_DITTO_3_DE);
TRANS(UI_TEXT_ZPROBE_HEIGHT_DE);
TRANS(UI_TEXT_OFFSETS_DE);
TRANS(UI_TEXT_X_OFFSET_DE);
TRANS(UI_TEXT_Y_OFFSET_DE);
TRANS(UI_TEXT_Z_OFFSET_DE);

PGM_P const translations_de[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_DE,
 FUI_TEXT_OFF_DE,
 FUI_TEXT_NA_DE,
 FUI_TEXT_YES_DE,
 FUI_TEXT_NO_DE,
 FUI_TEXT_PRINT_POS_DE,
 FUI_TEXT_PRINTING_DE,
 FUI_TEXT_IDLE_DE,
 FUI_TEXT_NOSDCARD_DE,
 FUI_TEXT_ERROR_DE,
 FUI_TEXT_BACK_DE,
 FUI_TEXT_QUICK_SETTINGS_DE,
 FUI_TEXT_ERRORMSG_DE,
 FUI_TEXT_CONFIGURATION_DE,
 FUI_TEXT_POSITION_DE,
 FUI_TEXT_EXTRUDER_DE,
 FUI_TEXT_SD_CARD_DE,
 FUI_TEXT_DEBUGGING_DE,
 FUI_TEXT_HOME_DELTA_DE,
 FUI_TEXT_HOME_ALL_DE,
 FUI_TEXT_HOME_X_DE,
 FUI_TEXT_HOME_Y_DE,
 FUI_TEXT_HOME_Z_DE,
 FUI_TEXT_PREHEAT_PLA_DE,
 FUI_TEXT_PREHEAT_ABS_DE,
 FUI_TEXT_LIGHTS_ONOFF_DE,
 FUI_TEXT_COOLDOWN_DE,
 FUI_TEXT_SET_TO_ORIGIN_DE,
 FUI_TEXT_DISABLE_STEPPER_DE,
 FUI_TEXT_X_POSITION_DE,
 FUI_TEXT_X_POS_FAST_DE,
 FUI_TEXT_Y_POSITION_DE,
 FUI_TEXT_Y_POS_FAST_DE,
 FUI_TEXT_Z_POSITION_DE,
 FUI_TEXT_Z_POS_FAST_DE,
 FUI_TEXT_E_POSITION_DE,
 FUI_TEXT_BED_TEMP_DE,
 FUI_TEXT_EXTR0_TEMP_DE,
 FUI_TEXT_EXTR1_TEMP_DE,
 FUI_TEXT_EXTR2_TEMP_DE,
 FUI_TEXT_EXTR0_OFF_DE,
 FUI_TEXT_EXTR1_OFF_DE,
 FUI_TEXT_EXTR2_OFF_DE,
 FUI_TEXT_EXTR0_SELECT_DE,
 FUI_TEXT_EXTR1_SELECT_DE,
 FUI_TEXT_EXTR2_SELECT_DE,
 FUI_TEXT_EXTR_ORIGIN_DE,
 FUI_TEXT_PRINT_X_DE,
 FUI_TEXT_PRINT_Y_DE,
 FUI_TEXT_PRINT_Z_DE,
 FUI_TEXT_PRINT_Z_DELTA_DE,
 FUI_TEXT_MOVE_X_DE,
 FUI_TEXT_MOVE_Y_DE,
 FUI_TEXT_MOVE_Z_DE,
 FUI_TEXT_MOVE_Z_DELTA_DE,
 FUI_TEXT_JERK_DE,
 FUI_TEXT_ZJERK_DE,
 FUI_TEXT_ACCELERATION_DE,
 FUI_TEXT_STORE_TO_EEPROM_DE,
 FUI_TEXT_LOAD_EEPROM_DE,
 FUI_TEXT_DBG_ECHO_DE,
 FUI_TEXT_DBG_INFO_DE,
 FUI_TEXT_DBG_ERROR_DE,
 FUI_TEXT_DBG_DRYRUN_DE,
 FUI_TEXT_OPS_OFF_DE,
 FUI_TEXT_OPS_CLASSIC_DE,
 FUI_TEXT_OPS_FAST_DE,
 FUI_TEXT_OPS_RETRACT_DE,
 FUI_TEXT_OPS_BACKSLASH_DE,
 FUI_TEXT_OPS_MINDIST_DE,
 FUI_TEXT_OPS_MOVE_AFTER_DE,
 FUI_TEXT_ANTI_OOZE_DE,
 FUI_TEXT_PRINT_FILE_DE,
 FUI_TEXT_PAUSE_PRINT_DE,
 FUI_TEXT_CONTINUE_PRINT_DE,
 FUI_TEXT_UNMOUNT_CARD_DE,
 FUI_TEXT_MOUNT_CARD_DE,
 FUI_TEXT_DELETE_FILE_DE,
 FUI_TEXT_FEEDRATE_DE,
 FUI_TEXT_FEED_MAX_X_DE,
 FUI_TEXT_FEED_MAX_Y_DE,
 FUI_TEXT_FEED_MAX_Z_DE,
 FUI_TEXT_FEED_MAX_Z_DELTA_DE,
 FUI_TEXT_FEED_HOME_X_DE,
 FUI_TEXT_FEED_HOME_Y_DE,
 FUI_TEXT_FEED_HOME_Z_DE,
 FUI_TEXT_FEED_HOME_Z_DELTA_DE,
 FUI_TEXT_ACTION_XPOSITION4A_DE,
 FUI_TEXT_ACTION_XPOSITION4B_DE,
 FUI_TEXT_ACTION_XPOSITION4C_DE,
 FUI_TEXT_ACTION_XPOSITION4D_DE,
 FUI_TEXT_ACTION_YPOSITION4A_DE,
 FUI_TEXT_ACTION_YPOSITION4B_DE,
 FUI_TEXT_ACTION_YPOSITION4C_DE,
 FUI_TEXT_ACTION_YPOSITION4D_DE,
 FUI_TEXT_ACTION_ZPOSITION4A_DE,
 FUI_TEXT_ACTION_ZPOSITION4B_DE,
 FUI_TEXT_ACTION_ZPOSITION4C_DE,
 FUI_TEXT_ACTION_ZPOSITION4D_DE,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_DE,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_DE,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_DE,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_DE,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_DE,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_DE,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_DE,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_DE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_DE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_DE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_DE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_DE,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_DE,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_DE,
 FUI_TEXT_ACTION_XPOSITION2A_DE,
 FUI_TEXT_ACTION_XPOSITION2B_DE,
 FUI_TEXT_ACTION_YPOSITION2A_DE,
 FUI_TEXT_ACTION_YPOSITION2B_DE,
 FUI_TEXT_ACTION_ZPOSITION2A_DE,
 FUI_TEXT_ACTION_ZPOSITION2B_DE,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_DE,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_DE,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_DE,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_DE,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_DE,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_DE,
 FUI_TEXT_FANSPEED_DE,
 FUI_TEXT_ACTION_FANSPEED_DE,
 FUI_TEXT_FAN_OFF_DE,
 FUI_TEXT_FAN_25_DE,
 FUI_TEXT_FAN_50_DE,
 FUI_TEXT_FAN_75_DE,
 FUI_TEXT_FAN_FULL_DE,
 FUI_TEXT_STEPPER_INACTIVE_DE,
 FUI_TEXT_STEPPER_INACTIVE2A_DE,
 FUI_TEXT_STEPPER_INACTIVE2B_DE,
 FUI_TEXT_POWER_INACTIVE_DE,
 FUI_TEXT_POWER_INACTIVE2A_DE,
 FUI_TEXT_POWER_INACTIVE2B_DE,
 FUI_TEXT_GENERAL_DE,
 FUI_TEXT_BAUDRATE_DE,
 FUI_TEXT_EXTR_STEPS_DE,
 FUI_TEXT_EXTR_START_FEED_DE,
 FUI_TEXT_EXTR_MAX_FEED_DE,
 FUI_TEXT_EXTR_ACCEL_DE,
 FUI_TEXT_EXTR_WATCH_DE,
 FUI_TEXT_EXTR_ADVANCE_L_DE,
 FUI_TEXT_EXTR_ADVANCE_K_DE,
 FUI_TEXT_EXTR_MANAGER_DE,
 FUI_TEXT_EXTR_PGAIN_DE,
 FUI_TEXT_EXTR_DEADTIME_DE,
 FUI_TEXT_EXTR_DMAX_DT_DE,
 FUI_TEXT_EXTR_IGAIN_DE,
 FUI_TEXT_EXTR_DGAIN_DE,
 FUI_TEXT_EXTR_DMIN_DE,
 FUI_TEXT_EXTR_DMAX_DE,
 FUI_TEXT_EXTR_PMAX_DE,
 FUI_TEXT_EXTR_XOFF_DE,
 FUI_TEXT_EXTR_YOFF_DE,
 FUI_TEXT_STRING_HM_BANGBANG_DE,
 FUI_TEXT_STRING_HM_PID_DE,
 FUI_TEXT_STRING_ACTION_DE,
 FUI_TEXT_HEATING_EXTRUDER_DE,
 FUI_TEXT_HEATING_BED_DE,
 FUI_TEXT_KILLED_DE,
 FUI_TEXT_STEPPER_DISABLED_DE,
 FUI_TEXT_EEPROM_STOREDA_DE,
 FUI_TEXT_EEPROM_STOREDB_DE,
 FUI_TEXT_EEPROM_LOADEDA_DE,
 FUI_TEXT_EEPROM_LOADEDB_DE,
 FUI_TEXT_UPLOADING_DE,
 FUI_TEXT_PAGE_BUFFER_DE,
 FUI_TEXT_PAGE_EXTRUDER_DE,
 FUI_TEXT_PAGE_EXTRUDER1_DE,
 FUI_TEXT_PAGE_EXTRUDER2_DE,
 FUI_TEXT_PAGE_EXTRUDER3_DE,
 FUI_TEXT_PAGE_BED_DE,
 FUI_TEXT_SPEED_MULTIPLY_DE,
 FUI_TEXT_FLOW_MULTIPLY_DE,
 FUI_TEXT_SHOW_MEASUREMENT_DE,
 FUI_TEXT_RESET_MEASUREMENT_DE,
 FUI_TEXT_SET_MEASURED_ORIGIN_DE,
 FUI_TEXT_ZCALIB_DE,
 FUI_TEXT_SET_P1_DE,
 FUI_TEXT_SET_P2_DE,
 FUI_TEXT_SET_P3_DE,
 FUI_TEXT_CALCULATE_LEVELING_DE,
 FUI_TEXT_LEVEL_DE,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_DE,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_DE,
 FUI_TEXT_SD_REMOVED_DE,
 FUI_TEXT_SD_INSERTED_DE,
 FUI_TEXT_PRINTER_READY_DE,
 FUI_TEXT_PRINTTIME_DAYS_DE,
 FUI_TEXT_PRINTTIME_HOURS_DE,
 FUI_TEXT_PRINTTIME_MINUTES_DE,
 FUI_TEXT_PRINT_TIME_DE,
 FUI_TEXT_PRINT_FILAMENT_DE,
 FUI_TEXT_PRINTED_DE,
 FUI_TEXT_POWER_DE,
 FUI_TEXT_STRING_HM_DEADTIME_DE,
 FUI_TEXT_STRING_HM_SLOWBANG_DE,
 FUI_TEXT_STOP_PRINT_DE,
 FUI_TEXT_Z_BABYSTEPPING_DE,
 FUI_TEXT_CHANGE_FILAMENT_DE,
 FUI_TEXT_WIZ_CH_FILAMENT1_DE,
 FUI_TEXT_WIZ_CH_FILAMENT2_DE,
 FUI_TEXT_WIZ_CH_FILAMENT3_DE,
 FUI_TEXT_CLICK_DONE_DE,
 FUI_TEXT_AUTOLEVEL_ONOFF_DE,
 FUI_TEXT_SERVOPOS_DE,
 FUI_TEXT_IGNORE_M106_DE,
 FUI_TEXT_WIZ_REHEAT1_DE,
 FUI_TEXT_WIZ_REHEAT2_DE,
 FUI_TEXT_WIZ_WAITTEMP1_DE,
 FUI_TEXT_WIZ_WAITTEMP2_DE,
 FUI_TEXT_EXTRUDER_JAM_DE,
 FUI_TEXT_STANDBY_DE,
 FUI_TEXT_BED_COATING_DE,
 FUI_TEXT_BED_COATING_SET1_DE,
 FUI_TEXT_BED_COATING_SET2_DE,
 FUI_TEXT_NOCOATING_DE,
 FUI_TEXT_BUILDTAK_DE,
 FUI_TEXT_KAPTON_DE,
 FUI_TEXT_BLUETAPE_DE,
 FUI_TEXT_PETTAPE_DE,
 FUI_TEXT_GLUESTICK_DE,
 FUI_TEXT_CUSTOM_DE,
 FUI_TEXT_COATING_CUSTOM_DE,
 FUI_TEXT_LANGUAGE_DE,
 FUI_TEXT_MAINPAGE6_1_DE,
 FUI_TEXT_MAINPAGE6_2_DE,
 FUI_TEXT_MAINPAGE6_3_DE,
 FUI_TEXT_MAINPAGE6_4_DE,
 FUI_TEXT_MAINPAGE6_5_DE,
 FUI_TEXT_MAINPAGE6_6_DE,
 FUI_TEXT_MAINPAGE_TEMP_BED_DE,
 FUI_TEXT_MAINPAGE_BED_DE,
 FUI_TEXT_MAINPAGE_Z_BUF_DE,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_DE,
 FUI_TEXT_MAINPAGE_XY_DE,
 FUI_TEXT_PRINT_TIME_VALUE_DE,
 FUI_TEXT_PRINT_FILAMENT_VALUE_DE,
 FUI_TEXT_METER_PRINTED_DE,
 FUI_TEXT_STATUS_DE,
 FUI_TEXT_EMPTY_DE,
 FUI_TEXT_TEMP_SET_DE,
 FUI_TEXT_CURRENT_TEMP_DE,
 FUI_TEXT_COATING_THICKNESS_DE,
 FUI_TEXT_EXTR3_TEMP_DE,
 FUI_TEXT_EXTR4_TEMP_DE,
 FUI_TEXT_EXTR5_TEMP_DE,
 FUI_TEXT_EXTR3_OFF_DE,
 FUI_TEXT_EXTR4_OFF_DE,
 FUI_TEXT_EXTR5_OFF_DE,
 FUI_TEXT_EXTR3_SELECT_DE,
 FUI_TEXT_EXTR4_SELECT_DE,
 FUI_TEXT_EXTR5_SELECT_DE,
 FUI_TEXT_DITTO_0_DE,
 FUI_TEXT_DITTO_1_DE,
 FUI_TEXT_DITTO_2_DE,
 FUI_TEXT_DITTO_3_DE,
 FUI_TEXT_ZPROBE_HEIGHT_DE,
 FUI_TEXT_OFFSETS_DE,
 FUI_TEXT_X_OFFSET_DE,
 FUI_TEXT_Y_OFFSET_DE,
 FUI_TEXT_Z_OFFSET_DE,
 FUI_TEXT_DBG_ENDSTOP_DE
};
#define LANG_DE_TABLE translations_de
#else
#define LANG_DE_TABLE NULL
#endif // LANGUAGE_DE_ACTIVE

#if LANGUAGE_NL_ACTIVE
TRANS(UI_TEXT_ON_NL);
TRANS(UI_TEXT_OFF_NL);
TRANS(UI_TEXT_NA_NL);
TRANS(UI_TEXT_YES_NL);
TRANS(UI_TEXT_NO_NL);
TRANS(UI_TEXT_PRINT_POS_NL);
TRANS(UI_TEXT_PRINTING_NL);
TRANS(UI_TEXT_IDLE_NL);
TRANS(UI_TEXT_NOSDCARD_NL);
TRANS(UI_TEXT_ERROR_NL);
TRANS(UI_TEXT_BACK_NL);
TRANS(UI_TEXT_QUICK_SETTINGS_NL);
TRANS(UI_TEXT_ERRORMSG_NL);
TRANS(UI_TEXT_CONFIGURATION_NL);
TRANS(UI_TEXT_POSITION_NL);
TRANS(UI_TEXT_EXTRUDER_NL);
TRANS(UI_TEXT_SD_CARD_NL);
TRANS(UI_TEXT_DEBUGGING_NL);
TRANS(UI_TEXT_HOME_DELTA_NL);
TRANS(UI_TEXT_HOME_ALL_NL);
TRANS(UI_TEXT_HOME_X_NL);
TRANS(UI_TEXT_HOME_Y_NL);
TRANS(UI_TEXT_HOME_Z_NL);
TRANS(UI_TEXT_PREHEAT_PLA_NL);
TRANS(UI_TEXT_PREHEAT_ABS_NL);
TRANS(UI_TEXT_LIGHTS_ONOFF_NL);
TRANS(UI_TEXT_COOLDOWN_NL);
TRANS(UI_TEXT_SET_TO_ORIGIN_NL);
TRANS(UI_TEXT_DISABLE_STEPPER_NL);
TRANS(UI_TEXT_X_POSITION_NL);
TRANS(UI_TEXT_X_POS_FAST_NL);
TRANS(UI_TEXT_Y_POSITION_NL);
TRANS(UI_TEXT_Y_POS_FAST_NL);
TRANS(UI_TEXT_Z_POSITION_NL);
TRANS(UI_TEXT_Z_POS_FAST_NL);
TRANS(UI_TEXT_E_POSITION_NL);
TRANS(UI_TEXT_BED_TEMP_NL);
TRANS(UI_TEXT_EXTR0_TEMP_NL);
TRANS(UI_TEXT_EXTR1_TEMP_NL);
TRANS(UI_TEXT_EXTR2_TEMP_NL);
TRANS(UI_TEXT_EXTR0_OFF_NL);
TRANS(UI_TEXT_EXTR1_OFF_NL);
TRANS(UI_TEXT_EXTR2_OFF_NL);
TRANS(UI_TEXT_EXTR0_SELECT_NL);
TRANS(UI_TEXT_EXTR1_SELECT_NL);
TRANS(UI_TEXT_EXTR2_SELECT_NL);
TRANS(UI_TEXT_EXTR_ORIGIN_NL);
TRANS(UI_TEXT_PRINT_X_NL);
TRANS(UI_TEXT_PRINT_Y_NL);
TRANS(UI_TEXT_PRINT_Z_NL);
TRANS(UI_TEXT_PRINT_Z_DELTA_NL);
TRANS(UI_TEXT_MOVE_X_NL);
TRANS(UI_TEXT_MOVE_Y_NL);
TRANS(UI_TEXT_MOVE_Z_NL);
TRANS(UI_TEXT_MOVE_Z_DELTA_NL);
TRANS(UI_TEXT_JERK_NL);
TRANS(UI_TEXT_ZJERK_NL);
TRANS(UI_TEXT_ACCELERATION_NL);
TRANS(UI_TEXT_STORE_TO_EEPROM_NL);
TRANS(UI_TEXT_LOAD_EEPROM_NL);
TRANS(UI_TEXT_DBG_ECHO_NL);
TRANS(UI_TEXT_DBG_INFO_NL);
TRANS(UI_TEXT_DBG_ERROR_NL);
TRANS(UI_TEXT_DBG_DRYRUN_NL);
TRANS(UI_TEXT_DBG_ENDSTOP_NL);
TRANS(UI_TEXT_OPS_OFF_NL);
TRANS(UI_TEXT_OPS_CLASSIC_NL);
TRANS(UI_TEXT_OPS_FAST_NL);
TRANS(UI_TEXT_OPS_RETRACT_NL);
TRANS(UI_TEXT_OPS_BACKSLASH_NL);
TRANS(UI_TEXT_OPS_MINDIST_NL);
TRANS(UI_TEXT_OPS_MOVE_AFTER_NL);
TRANS(UI_TEXT_ANTI_OOZE_NL);
TRANS(UI_TEXT_PRINT_FILE_NL);
TRANS(UI_TEXT_PAUSE_PRINT_NL);
TRANS(UI_TEXT_CONTINUE_PRINT_NL);
TRANS(UI_TEXT_UNMOUNT_CARD_NL);
TRANS(UI_TEXT_MOUNT_CARD_NL);
TRANS(UI_TEXT_DELETE_FILE_NL);
TRANS(UI_TEXT_FEEDRATE_NL);
TRANS(UI_TEXT_FEED_MAX_X_NL);
TRANS(UI_TEXT_FEED_MAX_Y_NL);
TRANS(UI_TEXT_FEED_MAX_Z_NL);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_NL);
TRANS(UI_TEXT_FEED_HOME_X_NL);
TRANS(UI_TEXT_FEED_HOME_Y_NL);
TRANS(UI_TEXT_FEED_HOME_Z_NL);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_NL);
TRANS(UI_TEXT_ACTION_XPOSITION4A_NL);
TRANS(UI_TEXT_ACTION_XPOSITION4B_NL);
TRANS(UI_TEXT_ACTION_XPOSITION4C_NL);
TRANS(UI_TEXT_ACTION_XPOSITION4D_NL);
TRANS(UI_TEXT_ACTION_YPOSITION4A_NL);
TRANS(UI_TEXT_ACTION_YPOSITION4B_NL);
TRANS(UI_TEXT_ACTION_YPOSITION4C_NL);
TRANS(UI_TEXT_ACTION_YPOSITION4D_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_NL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_NL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_NL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_NL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_NL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_NL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_NL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_NL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_NL);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_NL);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_NL);
TRANS(UI_TEXT_ACTION_XPOSITION2A_NL);
TRANS(UI_TEXT_ACTION_XPOSITION2B_NL);
TRANS(UI_TEXT_ACTION_YPOSITION2A_NL);
TRANS(UI_TEXT_ACTION_YPOSITION2B_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_NL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_NL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_NL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_NL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_NL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_NL);
TRANS(UI_TEXT_FANSPEED_NL);
TRANS(UI_TEXT_ACTION_FANSPEED_NL);
TRANS(UI_TEXT_FAN_OFF_NL);
TRANS(UI_TEXT_FAN_25_NL);
TRANS(UI_TEXT_FAN_50_NL);
TRANS(UI_TEXT_FAN_75_NL);
TRANS(UI_TEXT_FAN_FULL_NL);
TRANS(UI_TEXT_STEPPER_INACTIVE_NL);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_NL);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_NL);
TRANS(UI_TEXT_POWER_INACTIVE_NL);
TRANS(UI_TEXT_POWER_INACTIVE2A_NL);
TRANS(UI_TEXT_POWER_INACTIVE2B_NL);
TRANS(UI_TEXT_GENERAL_NL);
TRANS(UI_TEXT_BAUDRATE_NL);
TRANS(UI_TEXT_EXTR_STEPS_NL);
TRANS(UI_TEXT_EXTR_START_FEED_NL);
TRANS(UI_TEXT_EXTR_MAX_FEED_NL);
TRANS(UI_TEXT_EXTR_ACCEL_NL);
TRANS(UI_TEXT_EXTR_WATCH_NL);
TRANS(UI_TEXT_EXTR_ADVANCE_L_NL);
TRANS(UI_TEXT_EXTR_ADVANCE_K_NL);
TRANS(UI_TEXT_EXTR_MANAGER_NL);
TRANS(UI_TEXT_EXTR_PGAIN_NL);
TRANS(UI_TEXT_EXTR_DEADTIME_NL);
TRANS(UI_TEXT_EXTR_DMAX_DT_NL);
TRANS(UI_TEXT_EXTR_IGAIN_NL);
TRANS(UI_TEXT_EXTR_DGAIN_NL);
TRANS(UI_TEXT_EXTR_DMIN_NL);
TRANS(UI_TEXT_EXTR_DMAX_NL);
TRANS(UI_TEXT_EXTR_PMAX_NL);
TRANS(UI_TEXT_EXTR_XOFF_NL);
TRANS(UI_TEXT_EXTR_YOFF_NL);
TRANS(UI_TEXT_STRING_HM_BANGBANG_NL);
TRANS(UI_TEXT_STRING_HM_PID_NL);
TRANS(UI_TEXT_STRING_ACTION_NL);
TRANS(UI_TEXT_HEATING_EXTRUDER_NL);
TRANS(UI_TEXT_HEATING_BED_NL);
TRANS(UI_TEXT_KILLED_NL);
TRANS(UI_TEXT_STEPPER_DISABLED_NL);
TRANS(UI_TEXT_EEPROM_STOREDA_NL);
TRANS(UI_TEXT_EEPROM_STOREDB_NL);
TRANS(UI_TEXT_EEPROM_LOADEDA_NL);
TRANS(UI_TEXT_EEPROM_LOADEDB_NL);
TRANS(UI_TEXT_UPLOADING_NL);
TRANS(UI_TEXT_PAGE_BUFFER_NL);
TRANS(UI_TEXT_PAGE_EXTRUDER_NL);
TRANS(UI_TEXT_PAGE_EXTRUDER1_NL);
TRANS(UI_TEXT_PAGE_EXTRUDER2_NL);
TRANS(UI_TEXT_PAGE_EXTRUDER3_NL);
TRANS(UI_TEXT_PAGE_BED_NL);
TRANS(UI_TEXT_SPEED_MULTIPLY_NL);
TRANS(UI_TEXT_FLOW_MULTIPLY_NL);
TRANS(UI_TEXT_SHOW_MEASUREMENT_NL);
TRANS(UI_TEXT_RESET_MEASUREMENT_NL);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_NL);
TRANS(UI_TEXT_ZCALIB_NL);
TRANS(UI_TEXT_SET_P1_NL);
TRANS(UI_TEXT_SET_P2_NL);
TRANS(UI_TEXT_SET_P3_NL);
TRANS(UI_TEXT_CALCULATE_LEVELING_NL);
TRANS(UI_TEXT_LEVEL_NL);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_NL);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_NL);
TRANS(UI_TEXT_SD_REMOVED_NL);
TRANS(UI_TEXT_SD_INSERTED_NL);
TRANS(UI_TEXT_PRINTER_READY_NL);
TRANS(UI_TEXT_PRINTTIME_DAYS_NL);
TRANS(UI_TEXT_PRINTTIME_HOURS_NL);
TRANS(UI_TEXT_PRINTTIME_MINUTES_NL);
TRANS(UI_TEXT_PRINT_TIME_NL);
TRANS(UI_TEXT_PRINT_FILAMENT_NL);
TRANS(UI_TEXT_PRINTED_NL);
TRANS(UI_TEXT_POWER_NL);
TRANS(UI_TEXT_STRING_HM_DEADTIME_NL);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_NL);
TRANS(UI_TEXT_STOP_PRINT_NL);
TRANS(UI_TEXT_Z_BABYSTEPPING_NL);
TRANS(UI_TEXT_CHANGE_FILAMENT_NL);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_NL);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_NL);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_NL);
TRANS(UI_TEXT_CLICK_DONE_NL);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_NL);
TRANS(UI_TEXT_SERVOPOS_NL);
TRANS(UI_TEXT_IGNORE_M106_NL);
TRANS(UI_TEXT_WIZ_REHEAT1_NL);
TRANS(UI_TEXT_WIZ_REHEAT2_NL);
TRANS(UI_TEXT_WIZ_WAITTEMP1_NL);
TRANS(UI_TEXT_WIZ_WAITTEMP2_NL);
TRANS(UI_TEXT_EXTRUDER_JAM_NL);
TRANS(UI_TEXT_STANDBY_NL);
TRANS(UI_TEXT_BED_COATING_NL);
TRANS(UI_TEXT_BED_COATING_SET1_NL);
TRANS(UI_TEXT_BED_COATING_SET2_NL);
TRANS(UI_TEXT_NOCOATING_NL);
TRANS(UI_TEXT_BUILDTAK_NL);
TRANS(UI_TEXT_KAPTON_NL);
TRANS(UI_TEXT_BLUETAPE_NL);
TRANS(UI_TEXT_PETTAPE_NL);
TRANS(UI_TEXT_GLUESTICK_NL);
TRANS(UI_TEXT_CUSTOM_NL);
TRANS(UI_TEXT_COATING_CUSTOM_NL);
TRANS(UI_TEXT_LANGUAGE_NL);
TRANS(UI_TEXT_MAINPAGE6_1_NL);
TRANS(UI_TEXT_MAINPAGE6_2_NL);
TRANS(UI_TEXT_MAINPAGE6_3_NL);
TRANS(UI_TEXT_MAINPAGE6_4_NL);
TRANS(UI_TEXT_MAINPAGE6_5_NL);
TRANS(UI_TEXT_MAINPAGE6_6_NL);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_NL);
TRANS(UI_TEXT_MAINPAGE_BED_NL);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_NL);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_NL);
TRANS(UI_TEXT_MAINPAGE_XY_NL);
TRANS(UI_TEXT_PRINT_TIME_VALUE_NL);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_NL);
TRANS(UI_TEXT_METER_PRINTED_NL);
TRANS(UI_TEXT_STATUS_NL);
TRANS(UI_TEXT_EMPTY_NL);
TRANS(UI_TEXT_TEMP_SET_NL);
TRANS(UI_TEXT_CURRENT_TEMP_NL);
TRANS(UI_TEXT_COATING_THICKNESS_NL);
TRANS(UI_TEXT_EXTR3_TEMP_NL);
TRANS(UI_TEXT_EXTR4_TEMP_NL);
TRANS(UI_TEXT_EXTR5_TEMP_NL);
TRANS(UI_TEXT_EXTR3_OFF_NL);
TRANS(UI_TEXT_EXTR4_OFF_NL);
TRANS(UI_TEXT_EXTR5_OFF_NL);
TRANS(UI_TEXT_EXTR3_SELECT_NL);
TRANS(UI_TEXT_EXTR4_SELECT_NL);
TRANS(UI_TEXT_EXTR5_SELECT_NL);
TRANS(UI_TEXT_DITTO_0_NL);
TRANS(UI_TEXT_DITTO_1_NL);
TRANS(UI_TEXT_DITTO_2_NL);
TRANS(UI_TEXT_DITTO_3_NL);
TRANS(UI_TEXT_ZPROBE_HEIGHT_NL);
TRANS(UI_TEXT_OFFSETS_NL);
TRANS(UI_TEXT_X_OFFSET_NL);
TRANS(UI_TEXT_Y_OFFSET_NL);
TRANS(UI_TEXT_Z_OFFSET_NL);

PGM_P const translations_nl[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_NL,
 FUI_TEXT_OFF_NL,
 FUI_TEXT_NA_NL,
 FUI_TEXT_YES_NL,
 FUI_TEXT_NO_NL,
 FUI_TEXT_PRINT_POS_NL,
 FUI_TEXT_PRINTING_NL,
 FUI_TEXT_IDLE_NL,
 FUI_TEXT_NOSDCARD_NL,
 FUI_TEXT_ERROR_NL,
 FUI_TEXT_BACK_NL,
 FUI_TEXT_QUICK_SETTINGS_NL,
 FUI_TEXT_ERRORMSG_NL,
 FUI_TEXT_CONFIGURATION_NL,
 FUI_TEXT_POSITION_NL,
 FUI_TEXT_EXTRUDER_NL,
 FUI_TEXT_SD_CARD_NL,
 FUI_TEXT_DEBUGGING_NL,
 FUI_TEXT_HOME_DELTA_NL,
 FUI_TEXT_HOME_ALL_NL,
 FUI_TEXT_HOME_X_NL,
 FUI_TEXT_HOME_Y_NL,
 FUI_TEXT_HOME_Z_NL,
 FUI_TEXT_PREHEAT_PLA_NL,
 FUI_TEXT_PREHEAT_ABS_NL,
 FUI_TEXT_LIGHTS_ONOFF_NL,
 FUI_TEXT_COOLDOWN_NL,
 FUI_TEXT_SET_TO_ORIGIN_NL,
 FUI_TEXT_DISABLE_STEPPER_NL,
 FUI_TEXT_X_POSITION_NL,
 FUI_TEXT_X_POS_FAST_NL,
 FUI_TEXT_Y_POSITION_NL,
 FUI_TEXT_Y_POS_FAST_NL,
 FUI_TEXT_Z_POSITION_NL,
 FUI_TEXT_Z_POS_FAST_NL,
 FUI_TEXT_E_POSITION_NL,
 FUI_TEXT_BED_TEMP_NL,
 FUI_TEXT_EXTR0_TEMP_NL,
 FUI_TEXT_EXTR1_TEMP_NL,
 FUI_TEXT_EXTR2_TEMP_NL,
 FUI_TEXT_EXTR0_OFF_NL,
 FUI_TEXT_EXTR1_OFF_NL,
 FUI_TEXT_EXTR2_OFF_NL,
 FUI_TEXT_EXTR0_SELECT_NL,
 FUI_TEXT_EXTR1_SELECT_NL,
 FUI_TEXT_EXTR2_SELECT_NL,
 FUI_TEXT_EXTR_ORIGIN_NL,
 FUI_TEXT_PRINT_X_NL,
 FUI_TEXT_PRINT_Y_NL,
 FUI_TEXT_PRINT_Z_NL,
 FUI_TEXT_PRINT_Z_DELTA_NL,
 FUI_TEXT_MOVE_X_NL,
 FUI_TEXT_MOVE_Y_NL,
 FUI_TEXT_MOVE_Z_NL,
 FUI_TEXT_MOVE_Z_DELTA_NL,
 FUI_TEXT_JERK_NL,
 FUI_TEXT_ZJERK_NL,
 FUI_TEXT_ACCELERATION_NL,
 FUI_TEXT_STORE_TO_EEPROM_NL,
 FUI_TEXT_LOAD_EEPROM_NL,
 FUI_TEXT_DBG_ECHO_NL,
 FUI_TEXT_DBG_INFO_NL,
 FUI_TEXT_DBG_ERROR_NL,
 FUI_TEXT_DBG_DRYRUN_NL,
 FUI_TEXT_OPS_OFF_NL,
 FUI_TEXT_OPS_CLASSIC_NL,
 FUI_TEXT_OPS_FAST_NL,
 FUI_TEXT_OPS_RETRACT_NL,
 FUI_TEXT_OPS_BACKSLASH_NL,
 FUI_TEXT_OPS_MINDIST_NL,
 FUI_TEXT_OPS_MOVE_AFTER_NL,
 FUI_TEXT_ANTI_OOZE_NL,
 FUI_TEXT_PRINT_FILE_NL,
 FUI_TEXT_PAUSE_PRINT_NL,
 FUI_TEXT_CONTINUE_PRINT_NL,
 FUI_TEXT_UNMOUNT_CARD_NL,
 FUI_TEXT_MOUNT_CARD_NL,
 FUI_TEXT_DELETE_FILE_NL,
 FUI_TEXT_FEEDRATE_NL,
 FUI_TEXT_FEED_MAX_X_NL,
 FUI_TEXT_FEED_MAX_Y_NL,
 FUI_TEXT_FEED_MAX_Z_NL,
 FUI_TEXT_FEED_MAX_Z_DELTA_NL,
 FUI_TEXT_FEED_HOME_X_NL,
 FUI_TEXT_FEED_HOME_Y_NL,
 FUI_TEXT_FEED_HOME_Z_NL,
 FUI_TEXT_FEED_HOME_Z_DELTA_NL,
 FUI_TEXT_ACTION_XPOSITION4A_NL,
 FUI_TEXT_ACTION_XPOSITION4B_NL,
 FUI_TEXT_ACTION_XPOSITION4C_NL,
 FUI_TEXT_ACTION_XPOSITION4D_NL,
 FUI_TEXT_ACTION_YPOSITION4A_NL,
 FUI_TEXT_ACTION_YPOSITION4B_NL,
 FUI_TEXT_ACTION_YPOSITION4C_NL,
 FUI_TEXT_ACTION_YPOSITION4D_NL,
 FUI_TEXT_ACTION_ZPOSITION4A_NL,
 FUI_TEXT_ACTION_ZPOSITION4B_NL,
 FUI_TEXT_ACTION_ZPOSITION4C_NL,
 FUI_TEXT_ACTION_ZPOSITION4D_NL,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_NL,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_NL,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_NL,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_NL,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_NL,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_NL,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_NL,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_NL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_NL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_NL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_NL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_NL,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_NL,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_NL,
 FUI_TEXT_ACTION_XPOSITION2A_NL,
 FUI_TEXT_ACTION_XPOSITION2B_NL,
 FUI_TEXT_ACTION_YPOSITION2A_NL,
 FUI_TEXT_ACTION_YPOSITION2B_NL,
 FUI_TEXT_ACTION_ZPOSITION2A_NL,
 FUI_TEXT_ACTION_ZPOSITION2B_NL,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_NL,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_NL,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_NL,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_NL,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_NL,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_NL,
 FUI_TEXT_FANSPEED_NL,
 FUI_TEXT_ACTION_FANSPEED_NL,
 FUI_TEXT_FAN_OFF_NL,
 FUI_TEXT_FAN_25_NL,
 FUI_TEXT_FAN_50_NL,
 FUI_TEXT_FAN_75_NL,
 FUI_TEXT_FAN_FULL_NL,
 FUI_TEXT_STEPPER_INACTIVE_NL,
 FUI_TEXT_STEPPER_INACTIVE2A_NL,
 FUI_TEXT_STEPPER_INACTIVE2B_NL,
 FUI_TEXT_POWER_INACTIVE_NL,
 FUI_TEXT_POWER_INACTIVE2A_NL,
 FUI_TEXT_POWER_INACTIVE2B_NL,
 FUI_TEXT_GENERAL_NL,
 FUI_TEXT_BAUDRATE_NL,
 FUI_TEXT_EXTR_STEPS_NL,
 FUI_TEXT_EXTR_START_FEED_NL,
 FUI_TEXT_EXTR_MAX_FEED_NL,
 FUI_TEXT_EXTR_ACCEL_NL,
 FUI_TEXT_EXTR_WATCH_NL,
 FUI_TEXT_EXTR_ADVANCE_L_NL,
 FUI_TEXT_EXTR_ADVANCE_K_NL,
 FUI_TEXT_EXTR_MANAGER_NL,
 FUI_TEXT_EXTR_PGAIN_NL,
 FUI_TEXT_EXTR_DEADTIME_NL,
 FUI_TEXT_EXTR_DMAX_DT_NL,
 FUI_TEXT_EXTR_IGAIN_NL,
 FUI_TEXT_EXTR_DGAIN_NL,
 FUI_TEXT_EXTR_DMIN_NL,
 FUI_TEXT_EXTR_DMAX_NL,
 FUI_TEXT_EXTR_PMAX_NL,
 FUI_TEXT_EXTR_XOFF_NL,
 FUI_TEXT_EXTR_YOFF_NL,
 FUI_TEXT_STRING_HM_BANGBANG_NL,
 FUI_TEXT_STRING_HM_PID_NL,
 FUI_TEXT_STRING_ACTION_NL,
 FUI_TEXT_HEATING_EXTRUDER_NL,
 FUI_TEXT_HEATING_BED_NL,
 FUI_TEXT_KILLED_NL,
 FUI_TEXT_STEPPER_DISABLED_NL,
 FUI_TEXT_EEPROM_STOREDA_NL,
 FUI_TEXT_EEPROM_STOREDB_NL,
 FUI_TEXT_EEPROM_LOADEDA_NL,
 FUI_TEXT_EEPROM_LOADEDB_NL,
 FUI_TEXT_UPLOADING_NL,
 FUI_TEXT_PAGE_BUFFER_NL,
 FUI_TEXT_PAGE_EXTRUDER_NL,
 FUI_TEXT_PAGE_EXTRUDER1_NL,
 FUI_TEXT_PAGE_EXTRUDER2_NL,
 FUI_TEXT_PAGE_EXTRUDER3_NL,
 FUI_TEXT_PAGE_BED_NL,
 FUI_TEXT_SPEED_MULTIPLY_NL,
 FUI_TEXT_FLOW_MULTIPLY_NL,
 FUI_TEXT_SHOW_MEASUREMENT_NL,
 FUI_TEXT_RESET_MEASUREMENT_NL,
 FUI_TEXT_SET_MEASURED_ORIGIN_NL,
 FUI_TEXT_ZCALIB_NL,
 FUI_TEXT_SET_P1_NL,
 FUI_TEXT_SET_P2_NL,
 FUI_TEXT_SET_P3_NL,
 FUI_TEXT_CALCULATE_LEVELING_NL,
 FUI_TEXT_LEVEL_NL,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_NL,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_NL,
 FUI_TEXT_SD_REMOVED_NL,
 FUI_TEXT_SD_INSERTED_NL,
 FUI_TEXT_PRINTER_READY_NL,
 FUI_TEXT_PRINTTIME_DAYS_NL,
 FUI_TEXT_PRINTTIME_HOURS_NL,
 FUI_TEXT_PRINTTIME_MINUTES_NL,
 FUI_TEXT_PRINT_TIME_NL,
 FUI_TEXT_PRINT_FILAMENT_NL,
 FUI_TEXT_PRINTED_NL,
 FUI_TEXT_POWER_NL,
 FUI_TEXT_STRING_HM_DEADTIME_NL,
 FUI_TEXT_STRING_HM_SLOWBANG_NL,
 FUI_TEXT_STOP_PRINT_NL,
 FUI_TEXT_Z_BABYSTEPPING_NL,
 FUI_TEXT_CHANGE_FILAMENT_NL,
 FUI_TEXT_WIZ_CH_FILAMENT1_NL,
 FUI_TEXT_WIZ_CH_FILAMENT2_NL,
 FUI_TEXT_WIZ_CH_FILAMENT3_NL,
 FUI_TEXT_CLICK_DONE_NL,
 FUI_TEXT_AUTOLEVEL_ONOFF_NL,
 FUI_TEXT_SERVOPOS_NL,
 FUI_TEXT_IGNORE_M106_NL,
 FUI_TEXT_WIZ_REHEAT1_NL,
 FUI_TEXT_WIZ_REHEAT2_NL,
 FUI_TEXT_WIZ_WAITTEMP1_NL,
 FUI_TEXT_WIZ_WAITTEMP2_NL,
 FUI_TEXT_EXTRUDER_JAM_NL,
 FUI_TEXT_STANDBY_NL,
 FUI_TEXT_BED_COATING_NL,
 FUI_TEXT_BED_COATING_SET1_NL,
 FUI_TEXT_BED_COATING_SET2_NL,
 FUI_TEXT_NOCOATING_NL,
 FUI_TEXT_BUILDTAK_NL,
 FUI_TEXT_KAPTON_NL,
 FUI_TEXT_BLUETAPE_NL,
 FUI_TEXT_PETTAPE_NL,
 FUI_TEXT_GLUESTICK_NL,
 FUI_TEXT_CUSTOM_NL,
 FUI_TEXT_COATING_CUSTOM_NL,
 FUI_TEXT_LANGUAGE_NL,
 FUI_TEXT_MAINPAGE6_1_NL,
 FUI_TEXT_MAINPAGE6_2_NL,
 FUI_TEXT_MAINPAGE6_3_NL,
 FUI_TEXT_MAINPAGE6_4_NL,
 FUI_TEXT_MAINPAGE6_5_NL,
 FUI_TEXT_MAINPAGE6_6_NL,
 FUI_TEXT_MAINPAGE_TEMP_BED_NL,
 FUI_TEXT_MAINPAGE_BED_NL,
 FUI_TEXT_MAINPAGE_Z_BUF_NL,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_NL,
 FUI_TEXT_MAINPAGE_XY_NL,
 FUI_TEXT_PRINT_TIME_VALUE_NL,
 FUI_TEXT_PRINT_FILAMENT_VALUE_NL,
 FUI_TEXT_METER_PRINTED_NL,
 FUI_TEXT_STATUS_NL,
 FUI_TEXT_EMPTY_NL,
 FUI_TEXT_TEMP_SET_NL,
 FUI_TEXT_CURRENT_TEMP_NL,
 FUI_TEXT_COATING_THICKNESS_NL,
 FUI_TEXT_EXTR3_TEMP_NL,
 FUI_TEXT_EXTR4_TEMP_NL,
 FUI_TEXT_EXTR5_TEMP_NL,
 FUI_TEXT_EXTR3_OFF_NL,
 FUI_TEXT_EXTR4_OFF_NL,
 FUI_TEXT_EXTR5_OFF_NL,
 FUI_TEXT_EXTR3_SELECT_NL,
 FUI_TEXT_EXTR4_SELECT_NL,
 FUI_TEXT_EXTR5_SELECT_NL,
 FUI_TEXT_DITTO_0_NL,
 FUI_TEXT_DITTO_1_NL,
 FUI_TEXT_DITTO_2_NL,
 FUI_TEXT_DITTO_3_NL,
 FUI_TEXT_ZPROBE_HEIGHT_NL,
 FUI_TEXT_OFFSETS_NL,
 FUI_TEXT_X_OFFSET_NL,
 FUI_TEXT_Y_OFFSET_NL,
 FUI_TEXT_Z_OFFSET_NL,
 FUI_TEXT_DBG_ENDSTOP_NL
};
#define LANG_NL_TABLE translations_nl
#else
#define LANG_NL_TABLE NULL
#endif // LANGUAGE_NL_ACTIVE


#if LANGUAGE_PT_ACTIVE
TRANS(UI_TEXT_ON_PT);
TRANS(UI_TEXT_OFF_PT);
TRANS(UI_TEXT_NA_PT);
TRANS(UI_TEXT_YES_PT);
TRANS(UI_TEXT_NO_PT);
TRANS(UI_TEXT_PRINT_POS_PT);
TRANS(UI_TEXT_PRINTING_PT);
TRANS(UI_TEXT_IDLE_PT);
TRANS(UI_TEXT_NOSDCARD_PT);
TRANS(UI_TEXT_ERROR_PT);
TRANS(UI_TEXT_BACK_PT);
TRANS(UI_TEXT_QUICK_SETTINGS_PT);
TRANS(UI_TEXT_ERRORMSG_PT);
TRANS(UI_TEXT_CONFIGURATION_PT);
TRANS(UI_TEXT_POSITION_PT);
TRANS(UI_TEXT_EXTRUDER_PT);
TRANS(UI_TEXT_SD_CARD_PT);
TRANS(UI_TEXT_DEBUGGING_PT);
TRANS(UI_TEXT_HOME_DELTA_PT);
TRANS(UI_TEXT_HOME_ALL_PT);
TRANS(UI_TEXT_HOME_X_PT);
TRANS(UI_TEXT_HOME_Y_PT);
TRANS(UI_TEXT_HOME_Z_PT);
TRANS(UI_TEXT_PREHEAT_PLA_PT);
TRANS(UI_TEXT_PREHEAT_ABS_PT);
TRANS(UI_TEXT_LIGHTS_ONOFF_PT);
TRANS(UI_TEXT_COOLDOWN_PT);
TRANS(UI_TEXT_SET_TO_ORIGIN_PT);
TRANS(UI_TEXT_DISABLE_STEPPER_PT);
TRANS(UI_TEXT_X_POSITION_PT);
TRANS(UI_TEXT_X_POS_FAST_PT);
TRANS(UI_TEXT_Y_POSITION_PT);
TRANS(UI_TEXT_Y_POS_FAST_PT);
TRANS(UI_TEXT_Z_POSITION_PT);
TRANS(UI_TEXT_Z_POS_FAST_PT);
TRANS(UI_TEXT_E_POSITION_PT);
TRANS(UI_TEXT_BED_TEMP_PT);
TRANS(UI_TEXT_EXTR0_TEMP_PT);
TRANS(UI_TEXT_EXTR1_TEMP_PT);
TRANS(UI_TEXT_EXTR2_TEMP_PT);
TRANS(UI_TEXT_EXTR0_OFF_PT);
TRANS(UI_TEXT_EXTR1_OFF_PT);
TRANS(UI_TEXT_EXTR2_OFF_PT);
TRANS(UI_TEXT_EXTR0_SELECT_PT);
TRANS(UI_TEXT_EXTR1_SELECT_PT);
TRANS(UI_TEXT_EXTR2_SELECT_PT);
TRANS(UI_TEXT_EXTR_ORIGIN_PT);
TRANS(UI_TEXT_PRINT_X_PT);
TRANS(UI_TEXT_PRINT_Y_PT);
TRANS(UI_TEXT_PRINT_Z_PT);
TRANS(UI_TEXT_PRINT_Z_DELTA_PT);
TRANS(UI_TEXT_MOVE_X_PT);
TRANS(UI_TEXT_MOVE_Y_PT);
TRANS(UI_TEXT_MOVE_Z_PT);
TRANS(UI_TEXT_MOVE_Z_DELTA_PT);
TRANS(UI_TEXT_JERK_PT);
TRANS(UI_TEXT_ZJERK_PT);
TRANS(UI_TEXT_ACCELERATION_PT);
TRANS(UI_TEXT_STORE_TO_EEPROM_PT);
TRANS(UI_TEXT_LOAD_EEPROM_PT);
TRANS(UI_TEXT_DBG_ECHO_PT);
TRANS(UI_TEXT_DBG_INFO_PT);
TRANS(UI_TEXT_DBG_ERROR_PT);
TRANS(UI_TEXT_DBG_DRYRUN_PT);
TRANS(UI_TEXT_DBG_ENDSTOP_PT);
TRANS(UI_TEXT_OPS_OFF_PT);
TRANS(UI_TEXT_OPS_CLASSIC_PT);
TRANS(UI_TEXT_OPS_FAST_PT);
TRANS(UI_TEXT_OPS_RETRACT_PT);
TRANS(UI_TEXT_OPS_BACKSLASH_PT);
TRANS(UI_TEXT_OPS_MINDIST_PT);
TRANS(UI_TEXT_OPS_MOVE_AFTER_PT);
TRANS(UI_TEXT_ANTI_OOZE_PT);
TRANS(UI_TEXT_PRINT_FILE_PT);
TRANS(UI_TEXT_PAUSE_PRINT_PT);
TRANS(UI_TEXT_CONTINUE_PRINT_PT);
TRANS(UI_TEXT_UNMOUNT_CARD_PT);
TRANS(UI_TEXT_MOUNT_CARD_PT);
TRANS(UI_TEXT_DELETE_FILE_PT);
TRANS(UI_TEXT_FEEDRATE_PT);
TRANS(UI_TEXT_FEED_MAX_X_PT);
TRANS(UI_TEXT_FEED_MAX_Y_PT);
TRANS(UI_TEXT_FEED_MAX_Z_PT);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_PT);
TRANS(UI_TEXT_FEED_HOME_X_PT);
TRANS(UI_TEXT_FEED_HOME_Y_PT);
TRANS(UI_TEXT_FEED_HOME_Z_PT);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_PT);
TRANS(UI_TEXT_ACTION_XPOSITION4A_PT);
TRANS(UI_TEXT_ACTION_XPOSITION4B_PT);
TRANS(UI_TEXT_ACTION_XPOSITION4C_PT);
TRANS(UI_TEXT_ACTION_XPOSITION4D_PT);
TRANS(UI_TEXT_ACTION_YPOSITION4A_PT);
TRANS(UI_TEXT_ACTION_YPOSITION4B_PT);
TRANS(UI_TEXT_ACTION_YPOSITION4C_PT);
TRANS(UI_TEXT_ACTION_YPOSITION4D_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_PT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_PT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_PT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_PT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_PT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_PT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_PT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_PT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_PT);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_PT);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_PT);
TRANS(UI_TEXT_ACTION_XPOSITION2A_PT);
TRANS(UI_TEXT_ACTION_XPOSITION2B_PT);
TRANS(UI_TEXT_ACTION_YPOSITION2A_PT);
TRANS(UI_TEXT_ACTION_YPOSITION2B_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_PT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_PT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_PT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_PT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_PT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_PT);
TRANS(UI_TEXT_FANSPEED_PT);
TRANS(UI_TEXT_ACTION_FANSPEED_PT);
TRANS(UI_TEXT_FAN_OFF_PT);
TRANS(UI_TEXT_FAN_25_PT);
TRANS(UI_TEXT_FAN_50_PT);
TRANS(UI_TEXT_FAN_75_PT);
TRANS(UI_TEXT_FAN_FULL_PT);
TRANS(UI_TEXT_STEPPER_INACTIVE_PT);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_PT);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_PT);
TRANS(UI_TEXT_POWER_INACTIVE_PT);
TRANS(UI_TEXT_POWER_INACTIVE2A_PT);
TRANS(UI_TEXT_POWER_INACTIVE2B_PT);
TRANS(UI_TEXT_GENERAL_PT);
TRANS(UI_TEXT_BAUDRATE_PT);
TRANS(UI_TEXT_EXTR_STEPS_PT);
TRANS(UI_TEXT_EXTR_START_FEED_PT);
TRANS(UI_TEXT_EXTR_MAX_FEED_PT);
TRANS(UI_TEXT_EXTR_ACCEL_PT);
TRANS(UI_TEXT_EXTR_WATCH_PT);
TRANS(UI_TEXT_EXTR_ADVANCE_L_PT);
TRANS(UI_TEXT_EXTR_ADVANCE_K_PT);
TRANS(UI_TEXT_EXTR_MANAGER_PT);
TRANS(UI_TEXT_EXTR_PGAIN_PT);
TRANS(UI_TEXT_EXTR_DEADTIME_PT);
TRANS(UI_TEXT_EXTR_DMAX_DT_PT);
TRANS(UI_TEXT_EXTR_IGAIN_PT);
TRANS(UI_TEXT_EXTR_DGAIN_PT);
TRANS(UI_TEXT_EXTR_DMIN_PT);
TRANS(UI_TEXT_EXTR_DMAX_PT);
TRANS(UI_TEXT_EXTR_PMAX_PT);
TRANS(UI_TEXT_EXTR_XOFF_PT);
TRANS(UI_TEXT_EXTR_YOFF_PT);
TRANS(UI_TEXT_STRING_HM_BANGBANG_PT);
TRANS(UI_TEXT_STRING_HM_PID_PT);
TRANS(UI_TEXT_STRING_ACTION_PT);
TRANS(UI_TEXT_HEATING_EXTRUDER_PT);
TRANS(UI_TEXT_HEATING_BED_PT);
TRANS(UI_TEXT_KILLED_PT);
TRANS(UI_TEXT_STEPPER_DISABLED_PT);
TRANS(UI_TEXT_EEPROM_STOREDA_PT);
TRANS(UI_TEXT_EEPROM_STOREDB_PT);
TRANS(UI_TEXT_EEPROM_LOADEDA_PT);
TRANS(UI_TEXT_EEPROM_LOADEDB_PT);
TRANS(UI_TEXT_UPLOADING_PT);
TRANS(UI_TEXT_PAGE_BUFFER_PT);
TRANS(UI_TEXT_PAGE_EXTRUDER_PT);
TRANS(UI_TEXT_PAGE_EXTRUDER1_PT);
TRANS(UI_TEXT_PAGE_EXTRUDER2_PT);
TRANS(UI_TEXT_PAGE_EXTRUDER3_PT);
TRANS(UI_TEXT_PAGE_BED_PT);
TRANS(UI_TEXT_SPEED_MULTIPLY_PT);
TRANS(UI_TEXT_FLOW_MULTIPLY_PT);
TRANS(UI_TEXT_SHOW_MEASUREMENT_PT);
TRANS(UI_TEXT_RESET_MEASUREMENT_PT);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_PT);
TRANS(UI_TEXT_ZCALIB_PT);
TRANS(UI_TEXT_SET_P1_PT);
TRANS(UI_TEXT_SET_P2_PT);
TRANS(UI_TEXT_SET_P3_PT);
TRANS(UI_TEXT_CALCULATE_LEVELING_PT);
TRANS(UI_TEXT_LEVEL_PT);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_PT);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_PT);
TRANS(UI_TEXT_SD_REMOVED_PT);
TRANS(UI_TEXT_SD_INSERTED_PT);
TRANS(UI_TEXT_PRINTER_READY_PT);
TRANS(UI_TEXT_PRINTTIME_DAYS_PT);
TRANS(UI_TEXT_PRINTTIME_HOURS_PT);
TRANS(UI_TEXT_PRINTTIME_MINUTES_PT);
TRANS(UI_TEXT_PRINT_TIME_PT);
TRANS(UI_TEXT_PRINT_FILAMENT_PT);
TRANS(UI_TEXT_PRINTED_PT);
TRANS(UI_TEXT_POWER_PT);
TRANS(UI_TEXT_STRING_HM_DEADTIME_PT);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_PT);
TRANS(UI_TEXT_STOP_PRINT_PT);
TRANS(UI_TEXT_Z_BABYSTEPPING_PT);
TRANS(UI_TEXT_CHANGE_FILAMENT_PT);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_PT);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_PT);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_PT);
TRANS(UI_TEXT_CLICK_DONE_PT);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_PT);
TRANS(UI_TEXT_SERVOPOS_PT);
TRANS(UI_TEXT_IGNORE_M106_PT);
TRANS(UI_TEXT_WIZ_REHEAT1_PT);
TRANS(UI_TEXT_WIZ_REHEAT2_PT);
TRANS(UI_TEXT_WIZ_WAITTEMP1_PT);
TRANS(UI_TEXT_WIZ_WAITTEMP2_PT);
TRANS(UI_TEXT_EXTRUDER_JAM_PT);
TRANS(UI_TEXT_STANDBY_PT);
TRANS(UI_TEXT_BED_COATING_PT);
TRANS(UI_TEXT_BED_COATING_SET1_PT);
TRANS(UI_TEXT_BED_COATING_SET2_PT);
TRANS(UI_TEXT_NOCOATING_PT);
TRANS(UI_TEXT_BUILDTAK_PT);
TRANS(UI_TEXT_KAPTON_PT);
TRANS(UI_TEXT_BLUETAPE_PT);
TRANS(UI_TEXT_PETTAPE_PT);
TRANS(UI_TEXT_GLUESTICK_PT);
TRANS(UI_TEXT_CUSTOM_PT);
TRANS(UI_TEXT_COATING_CUSTOM_PT);
TRANS(UI_TEXT_LANGUAGE_PT);
TRANS(UI_TEXT_MAINPAGE6_1_PT);
TRANS(UI_TEXT_MAINPAGE6_2_PT);
TRANS(UI_TEXT_MAINPAGE6_3_PT);
TRANS(UI_TEXT_MAINPAGE6_4_PT);
TRANS(UI_TEXT_MAINPAGE6_5_PT);
TRANS(UI_TEXT_MAINPAGE6_6_PT);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_PT);
TRANS(UI_TEXT_MAINPAGE_BED_PT);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_PT);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_PT);
TRANS(UI_TEXT_MAINPAGE_XY_PT);
TRANS(UI_TEXT_PRINT_TIME_VALUE_PT);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_PT);
TRANS(UI_TEXT_METER_PRINTED_PT);
TRANS(UI_TEXT_STATUS_PT);
TRANS(UI_TEXT_EMPTY_PT);
TRANS(UI_TEXT_TEMP_SET_PT);
TRANS(UI_TEXT_CURRENT_TEMP_PT);
TRANS(UI_TEXT_COATING_THICKNESS_PT);
TRANS(UI_TEXT_EXTR3_TEMP_PT);
TRANS(UI_TEXT_EXTR4_TEMP_PT);
TRANS(UI_TEXT_EXTR5_TEMP_PT);
TRANS(UI_TEXT_EXTR3_OFF_PT);
TRANS(UI_TEXT_EXTR4_OFF_PT);
TRANS(UI_TEXT_EXTR5_OFF_PT);
TRANS(UI_TEXT_EXTR3_SELECT_PT);
TRANS(UI_TEXT_EXTR4_SELECT_PT);
TRANS(UI_TEXT_EXTR5_SELECT_PT);
TRANS(UI_TEXT_DITTO_0_PT);
TRANS(UI_TEXT_DITTO_1_PT);
TRANS(UI_TEXT_DITTO_2_PT);
TRANS(UI_TEXT_DITTO_3_PT);
TRANS(UI_TEXT_ZPROBE_HEIGHT_PT);
TRANS(UI_TEXT_OFFSETS_PT);
TRANS(UI_TEXT_X_OFFSET_PT);
TRANS(UI_TEXT_Y_OFFSET_PT);
TRANS(UI_TEXT_Z_OFFSET_PT);

PGM_P const translations_pt[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_PT,
 FUI_TEXT_OFF_PT,
 FUI_TEXT_NA_PT,
 FUI_TEXT_YES_PT,
 FUI_TEXT_NO_PT,
 FUI_TEXT_PRINT_POS_PT,
 FUI_TEXT_PRINTING_PT,
 FUI_TEXT_IDLE_PT,
 FUI_TEXT_NOSDCARD_PT,
 FUI_TEXT_ERROR_PT,
 FUI_TEXT_BACK_PT,
 FUI_TEXT_QUICK_SETTINGS_PT,
 FUI_TEXT_ERRORMSG_PT,
 FUI_TEXT_CONFIGURATION_PT,
 FUI_TEXT_POSITION_PT,
 FUI_TEXT_EXTRUDER_PT,
 FUI_TEXT_SD_CARD_PT,
 FUI_TEXT_DEBUGGING_PT,
 FUI_TEXT_HOME_DELTA_PT,
 FUI_TEXT_HOME_ALL_PT,
 FUI_TEXT_HOME_X_PT,
 FUI_TEXT_HOME_Y_PT,
 FUI_TEXT_HOME_Z_PT,
 FUI_TEXT_PREHEAT_PLA_PT,
 FUI_TEXT_PREHEAT_ABS_PT,
 FUI_TEXT_LIGHTS_ONOFF_PT,
 FUI_TEXT_COOLDOWN_PT,
 FUI_TEXT_SET_TO_ORIGIN_PT,
 FUI_TEXT_DISABLE_STEPPER_PT,
 FUI_TEXT_X_POSITION_PT,
 FUI_TEXT_X_POS_FAST_PT,
 FUI_TEXT_Y_POSITION_PT,
 FUI_TEXT_Y_POS_FAST_PT,
 FUI_TEXT_Z_POSITION_PT,
 FUI_TEXT_Z_POS_FAST_PT,
 FUI_TEXT_E_POSITION_PT,
 FUI_TEXT_BED_TEMP_PT,
 FUI_TEXT_EXTR0_TEMP_PT,
 FUI_TEXT_EXTR1_TEMP_PT,
 FUI_TEXT_EXTR2_TEMP_PT,
 FUI_TEXT_EXTR0_OFF_PT,
 FUI_TEXT_EXTR1_OFF_PT,
 FUI_TEXT_EXTR2_OFF_PT,
 FUI_TEXT_EXTR0_SELECT_PT,
 FUI_TEXT_EXTR1_SELECT_PT,
 FUI_TEXT_EXTR2_SELECT_PT,
 FUI_TEXT_EXTR_ORIGIN_PT,
 FUI_TEXT_PRINT_X_PT,
 FUI_TEXT_PRINT_Y_PT,
 FUI_TEXT_PRINT_Z_PT,
 FUI_TEXT_PRINT_Z_DELTA_PT,
 FUI_TEXT_MOVE_X_PT,
 FUI_TEXT_MOVE_Y_PT,
 FUI_TEXT_MOVE_Z_PT,
 FUI_TEXT_MOVE_Z_DELTA_PT,
 FUI_TEXT_JERK_PT,
 FUI_TEXT_ZJERK_PT,
 FUI_TEXT_ACCELERATION_PT,
 FUI_TEXT_STORE_TO_EEPROM_PT,
 FUI_TEXT_LOAD_EEPROM_PT,
 FUI_TEXT_DBG_ECHO_PT,
 FUI_TEXT_DBG_INFO_PT,
 FUI_TEXT_DBG_ERROR_PT,
 FUI_TEXT_DBG_DRYRUN_PT,
 FUI_TEXT_OPS_OFF_PT,
 FUI_TEXT_OPS_CLASSIC_PT,
 FUI_TEXT_OPS_FAST_PT,
 FUI_TEXT_OPS_RETRACT_PT,
 FUI_TEXT_OPS_BACKSLASH_PT,
 FUI_TEXT_OPS_MINDIST_PT,
 FUI_TEXT_OPS_MOVE_AFTER_PT,
 FUI_TEXT_ANTI_OOZE_PT,
 FUI_TEXT_PRINT_FILE_PT,
 FUI_TEXT_PAUSE_PRINT_PT,
 FUI_TEXT_CONTINUE_PRINT_PT,
 FUI_TEXT_UNMOUNT_CARD_PT,
 FUI_TEXT_MOUNT_CARD_PT,
 FUI_TEXT_DELETE_FILE_PT,
 FUI_TEXT_FEEDRATE_PT,
 FUI_TEXT_FEED_MAX_X_PT,
 FUI_TEXT_FEED_MAX_Y_PT,
 FUI_TEXT_FEED_MAX_Z_PT,
 FUI_TEXT_FEED_MAX_Z_DELTA_PT,
 FUI_TEXT_FEED_HOME_X_PT,
 FUI_TEXT_FEED_HOME_Y_PT,
 FUI_TEXT_FEED_HOME_Z_PT,
 FUI_TEXT_FEED_HOME_Z_DELTA_PT,
 FUI_TEXT_ACTION_XPOSITION4A_PT,
 FUI_TEXT_ACTION_XPOSITION4B_PT,
 FUI_TEXT_ACTION_XPOSITION4C_PT,
 FUI_TEXT_ACTION_XPOSITION4D_PT,
 FUI_TEXT_ACTION_YPOSITION4A_PT,
 FUI_TEXT_ACTION_YPOSITION4B_PT,
 FUI_TEXT_ACTION_YPOSITION4C_PT,
 FUI_TEXT_ACTION_YPOSITION4D_PT,
 FUI_TEXT_ACTION_ZPOSITION4A_PT,
 FUI_TEXT_ACTION_ZPOSITION4B_PT,
 FUI_TEXT_ACTION_ZPOSITION4C_PT,
 FUI_TEXT_ACTION_ZPOSITION4D_PT,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_PT,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_PT,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_PT,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_PT,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_PT,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_PT,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_PT,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_PT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_PT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_PT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_PT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_PT,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_PT,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_PT,
 FUI_TEXT_ACTION_XPOSITION2A_PT,
 FUI_TEXT_ACTION_XPOSITION2B_PT,
 FUI_TEXT_ACTION_YPOSITION2A_PT,
 FUI_TEXT_ACTION_YPOSITION2B_PT,
 FUI_TEXT_ACTION_ZPOSITION2A_PT,
 FUI_TEXT_ACTION_ZPOSITION2B_PT,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_PT,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_PT,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_PT,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_PT,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_PT,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_PT,
 FUI_TEXT_FANSPEED_PT,
 FUI_TEXT_ACTION_FANSPEED_PT,
 FUI_TEXT_FAN_OFF_PT,
 FUI_TEXT_FAN_25_PT,
 FUI_TEXT_FAN_50_PT,
 FUI_TEXT_FAN_75_PT,
 FUI_TEXT_FAN_FULL_PT,
 FUI_TEXT_STEPPER_INACTIVE_PT,
 FUI_TEXT_STEPPER_INACTIVE2A_PT,
 FUI_TEXT_STEPPER_INACTIVE2B_PT,
 FUI_TEXT_POWER_INACTIVE_PT,
 FUI_TEXT_POWER_INACTIVE2A_PT,
 FUI_TEXT_POWER_INACTIVE2B_PT,
 FUI_TEXT_GENERAL_PT,
 FUI_TEXT_BAUDRATE_PT,
 FUI_TEXT_EXTR_STEPS_PT,
 FUI_TEXT_EXTR_START_FEED_PT,
 FUI_TEXT_EXTR_MAX_FEED_PT,
 FUI_TEXT_EXTR_ACCEL_PT,
 FUI_TEXT_EXTR_WATCH_PT,
 FUI_TEXT_EXTR_ADVANCE_L_PT,
 FUI_TEXT_EXTR_ADVANCE_K_PT,
 FUI_TEXT_EXTR_MANAGER_PT,
 FUI_TEXT_EXTR_PGAIN_PT,
 FUI_TEXT_EXTR_DEADTIME_PT,
 FUI_TEXT_EXTR_DMAX_DT_PT,
 FUI_TEXT_EXTR_IGAIN_PT,
 FUI_TEXT_EXTR_DGAIN_PT,
 FUI_TEXT_EXTR_DMIN_PT,
 FUI_TEXT_EXTR_DMAX_PT,
 FUI_TEXT_EXTR_PMAX_PT,
 FUI_TEXT_EXTR_XOFF_PT,
 FUI_TEXT_EXTR_YOFF_PT,
 FUI_TEXT_STRING_HM_BANGBANG_PT,
 FUI_TEXT_STRING_HM_PID_PT,
 FUI_TEXT_STRING_ACTION_PT,
 FUI_TEXT_HEATING_EXTRUDER_PT,
 FUI_TEXT_HEATING_BED_PT,
 FUI_TEXT_KILLED_PT,
 FUI_TEXT_STEPPER_DISABLED_PT,
 FUI_TEXT_EEPROM_STOREDA_PT,
 FUI_TEXT_EEPROM_STOREDB_PT,
 FUI_TEXT_EEPROM_LOADEDA_PT,
 FUI_TEXT_EEPROM_LOADEDB_PT,
 FUI_TEXT_UPLOADING_PT,
 FUI_TEXT_PAGE_BUFFER_PT,
 FUI_TEXT_PAGE_EXTRUDER_PT,
 FUI_TEXT_PAGE_EXTRUDER1_PT,
 FUI_TEXT_PAGE_EXTRUDER2_PT,
 FUI_TEXT_PAGE_EXTRUDER3_PT,
 FUI_TEXT_PAGE_BED_PT,
 FUI_TEXT_SPEED_MULTIPLY_PT,
 FUI_TEXT_FLOW_MULTIPLY_PT,
 FUI_TEXT_SHOW_MEASUREMENT_PT,
 FUI_TEXT_RESET_MEASUREMENT_PT,
 FUI_TEXT_SET_MEASURED_ORIGIN_PT,
 FUI_TEXT_ZCALIB_PT,
 FUI_TEXT_SET_P1_PT,
 FUI_TEXT_SET_P2_PT,
 FUI_TEXT_SET_P3_PT,
 FUI_TEXT_CALCULATE_LEVELING_PT,
 FUI_TEXT_LEVEL_PT,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_PT,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_PT,
 FUI_TEXT_SD_REMOVED_PT,
 FUI_TEXT_SD_INSERTED_PT,
 FUI_TEXT_PRINTER_READY_PT,
 FUI_TEXT_PRINTTIME_DAYS_PT,
 FUI_TEXT_PRINTTIME_HOURS_PT,
 FUI_TEXT_PRINTTIME_MINUTES_PT,
 FUI_TEXT_PRINT_TIME_PT,
 FUI_TEXT_PRINT_FILAMENT_PT,
 FUI_TEXT_PRINTED_PT,
 FUI_TEXT_POWER_PT,
 FUI_TEXT_STRING_HM_DEADTIME_PT,
 FUI_TEXT_STRING_HM_SLOWBANG_PT,
 FUI_TEXT_STOP_PRINT_PT,
 FUI_TEXT_Z_BABYSTEPPING_PT,
 FUI_TEXT_CHANGE_FILAMENT_PT,
 FUI_TEXT_WIZ_CH_FILAMENT1_PT,
 FUI_TEXT_WIZ_CH_FILAMENT2_PT,
 FUI_TEXT_WIZ_CH_FILAMENT3_PT,
 FUI_TEXT_CLICK_DONE_PT,
 FUI_TEXT_AUTOLEVEL_ONOFF_PT,
 FUI_TEXT_SERVOPOS_PT,
 FUI_TEXT_IGNORE_M106_PT,
 FUI_TEXT_WIZ_REHEAT1_PT,
 FUI_TEXT_WIZ_REHEAT2_PT,
 FUI_TEXT_WIZ_WAITTEMP1_PT,
 FUI_TEXT_WIZ_WAITTEMP2_PT,
 FUI_TEXT_EXTRUDER_JAM_PT,
 FUI_TEXT_STANDBY_PT,
 FUI_TEXT_BED_COATING_PT,
 FUI_TEXT_BED_COATING_SET1_PT,
 FUI_TEXT_BED_COATING_SET2_PT,
 FUI_TEXT_NOCOATING_PT,
 FUI_TEXT_BUILDTAK_PT,
 FUI_TEXT_KAPTON_PT,
 FUI_TEXT_BLUETAPE_PT,
 FUI_TEXT_PETTAPE_PT,
 FUI_TEXT_GLUESTICK_PT,
 FUI_TEXT_CUSTOM_PT,
 FUI_TEXT_COATING_CUSTOM_PT,
 FUI_TEXT_LANGUAGE_PT,
 FUI_TEXT_MAINPAGE6_1_PT,
 FUI_TEXT_MAINPAGE6_2_PT,
 FUI_TEXT_MAINPAGE6_3_PT,
 FUI_TEXT_MAINPAGE6_4_PT,
 FUI_TEXT_MAINPAGE6_5_PT,
 FUI_TEXT_MAINPAGE6_6_PT,
 FUI_TEXT_MAINPAGE_TEMP_BED_PT,
 FUI_TEXT_MAINPAGE_BED_PT,
 FUI_TEXT_MAINPAGE_Z_BUF_PT,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_PT,
 FUI_TEXT_MAINPAGE_XY_PT,
 FUI_TEXT_PRINT_TIME_VALUE_PT,
 FUI_TEXT_PRINT_FILAMENT_VALUE_PT,
 FUI_TEXT_METER_PRINTED_PT,
 FUI_TEXT_STATUS_PT,
 FUI_TEXT_EMPTY_PT,
 FUI_TEXT_TEMP_SET_PT,
 FUI_TEXT_CURRENT_TEMP_PT,
 FUI_TEXT_COATING_THICKNESS_PT,
 FUI_TEXT_EXTR3_TEMP_PT,
 FUI_TEXT_EXTR4_TEMP_PT,
 FUI_TEXT_EXTR5_TEMP_PT,
 FUI_TEXT_EXTR3_OFF_PT,
 FUI_TEXT_EXTR4_OFF_PT,
 FUI_TEXT_EXTR5_OFF_PT,
 FUI_TEXT_EXTR3_SELECT_PT,
 FUI_TEXT_EXTR4_SELECT_PT,
 FUI_TEXT_EXTR5_SELECT_PT,
 FUI_TEXT_DITTO_0_PT,
 FUI_TEXT_DITTO_1_PT,
 FUI_TEXT_DITTO_2_PT,
 FUI_TEXT_DITTO_3_PT,
 FUI_TEXT_ZPROBE_HEIGHT_PT,
 FUI_TEXT_OFFSETS_PT,
 FUI_TEXT_X_OFFSET_PT,
 FUI_TEXT_Y_OFFSET_PT,
 FUI_TEXT_Z_OFFSET_PT,
 FUI_TEXT_DBG_ENDSTOP_PT 
};
#define LANG_PT_TABLE translations_pt
#else
#define LANG_PT_TABLE NULL
#endif // LANGUAGE_PT_ACTIVE


#if LANGUAGE_IT_ACTIVE
TRANS(UI_TEXT_ON_IT);
TRANS(UI_TEXT_OFF_IT);
TRANS(UI_TEXT_NA_IT);
TRANS(UI_TEXT_YES_IT);
TRANS(UI_TEXT_NO_IT);
TRANS(UI_TEXT_PRINT_POS_IT);
TRANS(UI_TEXT_PRINTING_IT);
TRANS(UI_TEXT_IDLE_IT);
TRANS(UI_TEXT_NOSDCARD_IT);
TRANS(UI_TEXT_ERROR_IT);
TRANS(UI_TEXT_BACK_IT);
TRANS(UI_TEXT_QUICK_SETTINGS_IT);
TRANS(UI_TEXT_ERRORMSG_IT);
TRANS(UI_TEXT_CONFIGURATION_IT);
TRANS(UI_TEXT_POSITION_IT);
TRANS(UI_TEXT_EXTRUDER_IT);
TRANS(UI_TEXT_SD_CARD_IT);
TRANS(UI_TEXT_DEBUGGING_IT);
TRANS(UI_TEXT_HOME_DELTA_IT);
TRANS(UI_TEXT_HOME_ALL_IT);
TRANS(UI_TEXT_HOME_X_IT);
TRANS(UI_TEXT_HOME_Y_IT);
TRANS(UI_TEXT_HOME_Z_IT);
TRANS(UI_TEXT_PREHEAT_PLA_IT);
TRANS(UI_TEXT_PREHEAT_ABS_IT);
TRANS(UI_TEXT_LIGHTS_ONOFF_IT);
TRANS(UI_TEXT_COOLDOWN_IT);
TRANS(UI_TEXT_SET_TO_ORIGIN_IT);
TRANS(UI_TEXT_DISABLE_STEPPER_IT);
TRANS(UI_TEXT_X_POSITION_IT);
TRANS(UI_TEXT_X_POS_FAST_IT);
TRANS(UI_TEXT_Y_POSITION_IT);
TRANS(UI_TEXT_Y_POS_FAST_IT);
TRANS(UI_TEXT_Z_POSITION_IT);
TRANS(UI_TEXT_Z_POS_FAST_IT);
TRANS(UI_TEXT_E_POSITION_IT);
TRANS(UI_TEXT_BED_TEMP_IT);
TRANS(UI_TEXT_EXTR0_TEMP_IT);
TRANS(UI_TEXT_EXTR1_TEMP_IT);
TRANS(UI_TEXT_EXTR2_TEMP_IT);
TRANS(UI_TEXT_EXTR0_OFF_IT);
TRANS(UI_TEXT_EXTR1_OFF_IT);
TRANS(UI_TEXT_EXTR2_OFF_IT);
TRANS(UI_TEXT_EXTR0_SELECT_IT);
TRANS(UI_TEXT_EXTR1_SELECT_IT);
TRANS(UI_TEXT_EXTR2_SELECT_IT);
TRANS(UI_TEXT_EXTR_ORIGIN_IT);
TRANS(UI_TEXT_PRINT_X_IT);
TRANS(UI_TEXT_PRINT_Y_IT);
TRANS(UI_TEXT_PRINT_Z_IT);
TRANS(UI_TEXT_PRINT_Z_DELTA_IT);
TRANS(UI_TEXT_MOVE_X_IT);
TRANS(UI_TEXT_MOVE_Y_IT);
TRANS(UI_TEXT_MOVE_Z_IT);
TRANS(UI_TEXT_MOVE_Z_DELTA_IT);
TRANS(UI_TEXT_JERK_IT);
TRANS(UI_TEXT_ZJERK_IT);
TRANS(UI_TEXT_ACCELERATION_IT);
TRANS(UI_TEXT_STORE_TO_EEPROM_IT);
TRANS(UI_TEXT_LOAD_EEPROM_IT);
TRANS(UI_TEXT_DBG_ECHO_IT);
TRANS(UI_TEXT_DBG_INFO_IT);
TRANS(UI_TEXT_DBG_ERROR_IT);
TRANS(UI_TEXT_DBG_DRYRUN_IT);
TRANS(UI_TEXT_DBG_ENDSTOP_IT);
TRANS(UI_TEXT_OPS_OFF_IT);
TRANS(UI_TEXT_OPS_CLASSIC_IT);
TRANS(UI_TEXT_OPS_FAST_IT);
TRANS(UI_TEXT_OPS_RETRACT_IT);
TRANS(UI_TEXT_OPS_BACKSLASH_IT);
TRANS(UI_TEXT_OPS_MINDIST_IT);
TRANS(UI_TEXT_OPS_MOVE_AFTER_IT);
TRANS(UI_TEXT_ANTI_OOZE_IT);
TRANS(UI_TEXT_PRINT_FILE_IT);
TRANS(UI_TEXT_PAUSE_PRINT_IT);
TRANS(UI_TEXT_CONTINUE_PRINT_IT);
TRANS(UI_TEXT_UNMOUNT_CARD_IT);
TRANS(UI_TEXT_MOUNT_CARD_IT);
TRANS(UI_TEXT_DELETE_FILE_IT);
TRANS(UI_TEXT_FEEDRATE_IT);
TRANS(UI_TEXT_FEED_MAX_X_IT);
TRANS(UI_TEXT_FEED_MAX_Y_IT);
TRANS(UI_TEXT_FEED_MAX_Z_IT);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_IT);
TRANS(UI_TEXT_FEED_HOME_X_IT);
TRANS(UI_TEXT_FEED_HOME_Y_IT);
TRANS(UI_TEXT_FEED_HOME_Z_IT);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_IT);
TRANS(UI_TEXT_ACTION_XPOSITION4A_IT);
TRANS(UI_TEXT_ACTION_XPOSITION4B_IT);
TRANS(UI_TEXT_ACTION_XPOSITION4C_IT);
TRANS(UI_TEXT_ACTION_XPOSITION4D_IT);
TRANS(UI_TEXT_ACTION_YPOSITION4A_IT);
TRANS(UI_TEXT_ACTION_YPOSITION4B_IT);
TRANS(UI_TEXT_ACTION_YPOSITION4C_IT);
TRANS(UI_TEXT_ACTION_YPOSITION4D_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_IT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_IT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_IT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_IT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_IT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_IT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_IT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_IT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_IT);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_IT);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_IT);
TRANS(UI_TEXT_ACTION_XPOSITION2A_IT);
TRANS(UI_TEXT_ACTION_XPOSITION2B_IT);
TRANS(UI_TEXT_ACTION_YPOSITION2A_IT);
TRANS(UI_TEXT_ACTION_YPOSITION2B_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_IT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_IT);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_IT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_IT);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_IT);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_IT);
TRANS(UI_TEXT_FANSPEED_IT);
TRANS(UI_TEXT_ACTION_FANSPEED_IT);
TRANS(UI_TEXT_FAN_OFF_IT);
TRANS(UI_TEXT_FAN_25_IT);
TRANS(UI_TEXT_FAN_50_IT);
TRANS(UI_TEXT_FAN_75_IT);
TRANS(UI_TEXT_FAN_FULL_IT);
TRANS(UI_TEXT_STEPPER_INACTIVE_IT);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_IT);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_IT);
TRANS(UI_TEXT_POWER_INACTIVE_IT);
TRANS(UI_TEXT_POWER_INACTIVE2A_IT);
TRANS(UI_TEXT_POWER_INACTIVE2B_IT);
TRANS(UI_TEXT_GENERAL_IT);
TRANS(UI_TEXT_BAUDRATE_IT);
TRANS(UI_TEXT_EXTR_STEPS_IT);
TRANS(UI_TEXT_EXTR_START_FEED_IT);
TRANS(UI_TEXT_EXTR_MAX_FEED_IT);
TRANS(UI_TEXT_EXTR_ACCEL_IT);
TRANS(UI_TEXT_EXTR_WATCH_IT);
TRANS(UI_TEXT_EXTR_ADVANCE_L_IT);
TRANS(UI_TEXT_EXTR_ADVANCE_K_IT);
TRANS(UI_TEXT_EXTR_MANAGER_IT);
TRANS(UI_TEXT_EXTR_PGAIN_IT);
TRANS(UI_TEXT_EXTR_DEADTIME_IT);
TRANS(UI_TEXT_EXTR_DMAX_DT_IT);
TRANS(UI_TEXT_EXTR_IGAIN_IT);
TRANS(UI_TEXT_EXTR_DGAIN_IT);
TRANS(UI_TEXT_EXTR_DMIN_IT);
TRANS(UI_TEXT_EXTR_DMAX_IT);
TRANS(UI_TEXT_EXTR_PMAX_IT);
TRANS(UI_TEXT_EXTR_XOFF_IT);
TRANS(UI_TEXT_EXTR_YOFF_IT);
TRANS(UI_TEXT_STRING_HM_BANGBANG_IT);
TRANS(UI_TEXT_STRING_HM_PID_IT);
TRANS(UI_TEXT_STRING_ACTION_IT);
TRANS(UI_TEXT_HEATING_EXTRUDER_IT);
TRANS(UI_TEXT_HEATING_BED_IT);
TRANS(UI_TEXT_KILLED_IT);
TRANS(UI_TEXT_STEPPER_DISABLED_IT);
TRANS(UI_TEXT_EEPROM_STOREDA_IT);
TRANS(UI_TEXT_EEPROM_STOREDB_IT);
TRANS(UI_TEXT_EEPROM_LOADEDA_IT);
TRANS(UI_TEXT_EEPROM_LOADEDB_IT);
TRANS(UI_TEXT_UPLOADING_IT);
TRANS(UI_TEXT_PAGE_BUFFER_IT);
TRANS(UI_TEXT_PAGE_EXTRUDER_IT);
TRANS(UI_TEXT_PAGE_EXTRUDER1_IT);
TRANS(UI_TEXT_PAGE_EXTRUDER2_IT);
TRANS(UI_TEXT_PAGE_EXTRUDER3_IT);
TRANS(UI_TEXT_PAGE_BED_IT);
TRANS(UI_TEXT_SPEED_MULTIPLY_IT);
TRANS(UI_TEXT_FLOW_MULTIPLY_IT);
TRANS(UI_TEXT_SHOW_MEASUREMENT_IT);
TRANS(UI_TEXT_RESET_MEASUREMENT_IT);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_IT);
TRANS(UI_TEXT_ZCALIB_IT);
TRANS(UI_TEXT_SET_P1_IT);
TRANS(UI_TEXT_SET_P2_IT);
TRANS(UI_TEXT_SET_P3_IT);
TRANS(UI_TEXT_CALCULATE_LEVELING_IT);
TRANS(UI_TEXT_LEVEL_IT);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_IT);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_IT);
TRANS(UI_TEXT_SD_REMOVED_IT);
TRANS(UI_TEXT_SD_INSERTED_IT);
TRANS(UI_TEXT_PRINTER_READY_IT);
TRANS(UI_TEXT_PRINTTIME_DAYS_IT);
TRANS(UI_TEXT_PRINTTIME_HOURS_IT);
TRANS(UI_TEXT_PRINTTIME_MINUTES_IT);
TRANS(UI_TEXT_PRINT_TIME_IT);
TRANS(UI_TEXT_PRINT_FILAMENT_IT);
TRANS(UI_TEXT_PRINTED_IT);
TRANS(UI_TEXT_POWER_IT);
TRANS(UI_TEXT_STRING_HM_DEADTIME_IT);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_IT);
TRANS(UI_TEXT_STOP_PRINT_IT);
TRANS(UI_TEXT_Z_BABYSTEPPING_IT);
TRANS(UI_TEXT_CHANGE_FILAMENT_IT);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_IT);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_IT);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_IT);
TRANS(UI_TEXT_CLICK_DONE_IT);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_IT);
TRANS(UI_TEXT_SERVOPOS_IT);
TRANS(UI_TEXT_IGNORE_M106_IT);
TRANS(UI_TEXT_WIZ_REHEAT1_IT);
TRANS(UI_TEXT_WIZ_REHEAT2_IT);
TRANS(UI_TEXT_WIZ_WAITTEMP1_IT);
TRANS(UI_TEXT_WIZ_WAITTEMP2_IT);
TRANS(UI_TEXT_EXTRUDER_JAM_IT);
TRANS(UI_TEXT_STANDBY_IT);
TRANS(UI_TEXT_BED_COATING_IT);
TRANS(UI_TEXT_BED_COATING_SET1_IT);
TRANS(UI_TEXT_BED_COATING_SET2_IT);
TRANS(UI_TEXT_NOCOATING_IT);
TRANS(UI_TEXT_BUILDTAK_IT);
TRANS(UI_TEXT_KAPTON_IT);
TRANS(UI_TEXT_BLUETAPE_IT);
TRANS(UI_TEXT_PETTAPE_IT);
TRANS(UI_TEXT_GLUESTICK_IT);
TRANS(UI_TEXT_CUSTOM_IT);
TRANS(UI_TEXT_COATING_CUSTOM_IT);
TRANS(UI_TEXT_LANGUAGE_IT);
TRANS(UI_TEXT_MAINPAGE6_1_IT);
TRANS(UI_TEXT_MAINPAGE6_2_IT);
TRANS(UI_TEXT_MAINPAGE6_3_IT);
TRANS(UI_TEXT_MAINPAGE6_4_IT);
TRANS(UI_TEXT_MAINPAGE6_5_IT);
TRANS(UI_TEXT_MAINPAGE6_6_IT);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_IT);
TRANS(UI_TEXT_MAINPAGE_BED_IT);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_IT);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_IT);
TRANS(UI_TEXT_MAINPAGE_XY_IT);
TRANS(UI_TEXT_PRINT_TIME_VALUE_IT);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_IT);
TRANS(UI_TEXT_METER_PRINTED_IT);
TRANS(UI_TEXT_STATUS_IT);
TRANS(UI_TEXT_EMPTY_IT);
TRANS(UI_TEXT_TEMP_SET_IT);
TRANS(UI_TEXT_CURRENT_TEMP_IT);
TRANS(UI_TEXT_COATING_THICKNESS_IT);
TRANS(UI_TEXT_EXTR3_TEMP_IT);
TRANS(UI_TEXT_EXTR4_TEMP_IT);
TRANS(UI_TEXT_EXTR5_TEMP_IT);
TRANS(UI_TEXT_EXTR3_OFF_IT);
TRANS(UI_TEXT_EXTR4_OFF_IT);
TRANS(UI_TEXT_EXTR5_OFF_IT);
TRANS(UI_TEXT_EXTR3_SELECT_IT);
TRANS(UI_TEXT_EXTR4_SELECT_IT);
TRANS(UI_TEXT_EXTR5_SELECT_IT);
TRANS(UI_TEXT_DITTO_0_IT);
TRANS(UI_TEXT_DITTO_1_IT);
TRANS(UI_TEXT_DITTO_2_IT);
TRANS(UI_TEXT_DITTO_3_IT);
TRANS(UI_TEXT_ZPROBE_HEIGHT_IT);
TRANS(UI_TEXT_OFFSETS_IT);
TRANS(UI_TEXT_X_OFFSET_IT);
TRANS(UI_TEXT_Y_OFFSET_IT);
TRANS(UI_TEXT_Z_OFFSET_IT);

PGM_P const translations_it[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_IT,
 FUI_TEXT_OFF_IT,
 FUI_TEXT_NA_IT,
 FUI_TEXT_YES_IT,
 FUI_TEXT_NO_IT,
 FUI_TEXT_PRINT_POS_IT,
 FUI_TEXT_PRINTING_IT,
 FUI_TEXT_IDLE_IT,
 FUI_TEXT_NOSDCARD_IT,
 FUI_TEXT_ERROR_IT,
 FUI_TEXT_BACK_IT,
 FUI_TEXT_QUICK_SETTINGS_IT,
 FUI_TEXT_ERRORMSG_IT,
 FUI_TEXT_CONFIGURATION_IT,
 FUI_TEXT_POSITION_IT,
 FUI_TEXT_EXTRUDER_IT,
 FUI_TEXT_SD_CARD_IT,
 FUI_TEXT_DEBUGGING_IT,
 FUI_TEXT_HOME_DELTA_IT,
 FUI_TEXT_HOME_ALL_IT,
 FUI_TEXT_HOME_X_IT,
 FUI_TEXT_HOME_Y_IT,
 FUI_TEXT_HOME_Z_IT,
 FUI_TEXT_PREHEAT_PLA_IT,
 FUI_TEXT_PREHEAT_ABS_IT,
 FUI_TEXT_LIGHTS_ONOFF_IT,
 FUI_TEXT_COOLDOWN_IT,
 FUI_TEXT_SET_TO_ORIGIN_IT,
 FUI_TEXT_DISABLE_STEPPER_IT,
 FUI_TEXT_X_POSITION_IT,
 FUI_TEXT_X_POS_FAST_IT,
 FUI_TEXT_Y_POSITION_IT,
 FUI_TEXT_Y_POS_FAST_IT,
 FUI_TEXT_Z_POSITION_IT,
 FUI_TEXT_Z_POS_FAST_IT,
 FUI_TEXT_E_POSITION_IT,
 FUI_TEXT_BED_TEMP_IT,
 FUI_TEXT_EXTR0_TEMP_IT,
 FUI_TEXT_EXTR1_TEMP_IT,
 FUI_TEXT_EXTR2_TEMP_IT,
 FUI_TEXT_EXTR0_OFF_IT,
 FUI_TEXT_EXTR1_OFF_IT,
 FUI_TEXT_EXTR2_OFF_IT,
 FUI_TEXT_EXTR0_SELECT_IT,
 FUI_TEXT_EXTR1_SELECT_IT,
 FUI_TEXT_EXTR2_SELECT_IT,
 FUI_TEXT_EXTR_ORIGIN_IT,
 FUI_TEXT_PRINT_X_IT,
 FUI_TEXT_PRINT_Y_IT,
 FUI_TEXT_PRINT_Z_IT,
 FUI_TEXT_PRINT_Z_DELTA_IT,
 FUI_TEXT_MOVE_X_IT,
 FUI_TEXT_MOVE_Y_IT,
 FUI_TEXT_MOVE_Z_IT,
 FUI_TEXT_MOVE_Z_DELTA_IT,
 FUI_TEXT_JERK_IT,
 FUI_TEXT_ZJERK_IT,
 FUI_TEXT_ACCELERATION_IT,
 FUI_TEXT_STORE_TO_EEPROM_IT,
 FUI_TEXT_LOAD_EEPROM_IT,
 FUI_TEXT_DBG_ECHO_IT,
 FUI_TEXT_DBG_INFO_IT,
 FUI_TEXT_DBG_ERROR_IT,
 FUI_TEXT_DBG_DRYRUN_IT,
 FUI_TEXT_OPS_OFF_IT,
 FUI_TEXT_OPS_CLASSIC_IT,
 FUI_TEXT_OPS_FAST_IT,
 FUI_TEXT_OPS_RETRACT_IT,
 FUI_TEXT_OPS_BACKSLASH_IT,
 FUI_TEXT_OPS_MINDIST_IT,
 FUI_TEXT_OPS_MOVE_AFTER_IT,
 FUI_TEXT_ANTI_OOZE_IT,
 FUI_TEXT_PRINT_FILE_IT,
 FUI_TEXT_PAUSE_PRINT_IT,
 FUI_TEXT_CONTINUE_PRINT_IT,
 FUI_TEXT_UNMOUNT_CARD_IT,
 FUI_TEXT_MOUNT_CARD_IT,
 FUI_TEXT_DELETE_FILE_IT,
 FUI_TEXT_FEEDRATE_IT,
 FUI_TEXT_FEED_MAX_X_IT,
 FUI_TEXT_FEED_MAX_Y_IT,
 FUI_TEXT_FEED_MAX_Z_IT,
 FUI_TEXT_FEED_MAX_Z_DELTA_IT,
 FUI_TEXT_FEED_HOME_X_IT,
 FUI_TEXT_FEED_HOME_Y_IT,
 FUI_TEXT_FEED_HOME_Z_IT,
 FUI_TEXT_FEED_HOME_Z_DELTA_IT,
 FUI_TEXT_ACTION_XPOSITION4A_IT,
 FUI_TEXT_ACTION_XPOSITION4B_IT,
 FUI_TEXT_ACTION_XPOSITION4C_IT,
 FUI_TEXT_ACTION_XPOSITION4D_IT,
 FUI_TEXT_ACTION_YPOSITION4A_IT,
 FUI_TEXT_ACTION_YPOSITION4B_IT,
 FUI_TEXT_ACTION_YPOSITION4C_IT,
 FUI_TEXT_ACTION_YPOSITION4D_IT,
 FUI_TEXT_ACTION_ZPOSITION4A_IT,
 FUI_TEXT_ACTION_ZPOSITION4B_IT,
 FUI_TEXT_ACTION_ZPOSITION4C_IT,
 FUI_TEXT_ACTION_ZPOSITION4D_IT,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_IT,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_IT,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_IT,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_IT,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_IT,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_IT,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_IT,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_IT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_IT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_IT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_IT,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_IT,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_IT,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_IT,
 FUI_TEXT_ACTION_XPOSITION2A_IT,
 FUI_TEXT_ACTION_XPOSITION2B_IT,
 FUI_TEXT_ACTION_YPOSITION2A_IT,
 FUI_TEXT_ACTION_YPOSITION2B_IT,
 FUI_TEXT_ACTION_ZPOSITION2A_IT,
 FUI_TEXT_ACTION_ZPOSITION2B_IT,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_IT,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_IT,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_IT,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_IT,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_IT,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_IT,
 FUI_TEXT_FANSPEED_IT,
 FUI_TEXT_ACTION_FANSPEED_IT,
 FUI_TEXT_FAN_OFF_IT,
 FUI_TEXT_FAN_25_IT,
 FUI_TEXT_FAN_50_IT,
 FUI_TEXT_FAN_75_IT,
 FUI_TEXT_FAN_FULL_IT,
 FUI_TEXT_STEPPER_INACTIVE_IT,
 FUI_TEXT_STEPPER_INACTIVE2A_IT,
 FUI_TEXT_STEPPER_INACTIVE2B_IT,
 FUI_TEXT_POWER_INACTIVE_IT,
 FUI_TEXT_POWER_INACTIVE2A_IT,
 FUI_TEXT_POWER_INACTIVE2B_IT,
 FUI_TEXT_GENERAL_IT,
 FUI_TEXT_BAUDRATE_IT,
 FUI_TEXT_EXTR_STEPS_IT,
 FUI_TEXT_EXTR_START_FEED_IT,
 FUI_TEXT_EXTR_MAX_FEED_IT,
 FUI_TEXT_EXTR_ACCEL_IT,
 FUI_TEXT_EXTR_WATCH_IT,
 FUI_TEXT_EXTR_ADVANCE_L_IT,
 FUI_TEXT_EXTR_ADVANCE_K_IT,
 FUI_TEXT_EXTR_MANAGER_IT,
 FUI_TEXT_EXTR_PGAIN_IT,
 FUI_TEXT_EXTR_DEADTIME_IT,
 FUI_TEXT_EXTR_DMAX_DT_IT,
 FUI_TEXT_EXTR_IGAIN_IT,
 FUI_TEXT_EXTR_DGAIN_IT,
 FUI_TEXT_EXTR_DMIN_IT,
 FUI_TEXT_EXTR_DMAX_IT,
 FUI_TEXT_EXTR_PMAX_IT,
 FUI_TEXT_EXTR_XOFF_IT,
 FUI_TEXT_EXTR_YOFF_IT,
 FUI_TEXT_STRING_HM_BANGBANG_IT,
 FUI_TEXT_STRING_HM_PID_IT,
 FUI_TEXT_STRING_ACTION_IT,
 FUI_TEXT_HEATING_EXTRUDER_IT,
 FUI_TEXT_HEATING_BED_IT,
 FUI_TEXT_KILLED_IT,
 FUI_TEXT_STEPPER_DISABLED_IT,
 FUI_TEXT_EEPROM_STOREDA_IT,
 FUI_TEXT_EEPROM_STOREDB_IT,
 FUI_TEXT_EEPROM_LOADEDA_IT,
 FUI_TEXT_EEPROM_LOADEDB_IT,
 FUI_TEXT_UPLOADING_IT,
 FUI_TEXT_PAGE_BUFFER_IT,
 FUI_TEXT_PAGE_EXTRUDER_IT,
 FUI_TEXT_PAGE_EXTRUDER1_IT,
 FUI_TEXT_PAGE_EXTRUDER2_IT,
 FUI_TEXT_PAGE_EXTRUDER3_IT,
 FUI_TEXT_PAGE_BED_IT,
 FUI_TEXT_SPEED_MULTIPLY_IT,
 FUI_TEXT_FLOW_MULTIPLY_IT,
 FUI_TEXT_SHOW_MEASUREMENT_IT,
 FUI_TEXT_RESET_MEASUREMENT_IT,
 FUI_TEXT_SET_MEASURED_ORIGIN_IT,
 FUI_TEXT_ZCALIB_IT,
 FUI_TEXT_SET_P1_IT,
 FUI_TEXT_SET_P2_IT,
 FUI_TEXT_SET_P3_IT,
 FUI_TEXT_CALCULATE_LEVELING_IT,
 FUI_TEXT_LEVEL_IT,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_IT,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_IT,
 FUI_TEXT_SD_REMOVED_IT,
 FUI_TEXT_SD_INSERTED_IT,
 FUI_TEXT_PRINTER_READY_IT,
 FUI_TEXT_PRINTTIME_DAYS_IT,
 FUI_TEXT_PRINTTIME_HOURS_IT,
 FUI_TEXT_PRINTTIME_MINUTES_IT,
 FUI_TEXT_PRINT_TIME_IT,
 FUI_TEXT_PRINT_FILAMENT_IT,
 FUI_TEXT_PRINTED_IT,
 FUI_TEXT_POWER_IT,
 FUI_TEXT_STRING_HM_DEADTIME_IT,
 FUI_TEXT_STRING_HM_SLOWBANG_IT,
 FUI_TEXT_STOP_PRINT_IT,
 FUI_TEXT_Z_BABYSTEPPING_IT,
 FUI_TEXT_CHANGE_FILAMENT_IT,
 FUI_TEXT_WIZ_CH_FILAMENT1_IT,
 FUI_TEXT_WIZ_CH_FILAMENT2_IT,
 FUI_TEXT_WIZ_CH_FILAMENT3_IT,
 FUI_TEXT_CLICK_DONE_IT,
 FUI_TEXT_AUTOLEVEL_ONOFF_IT,
 FUI_TEXT_SERVOPOS_IT,
 FUI_TEXT_IGNORE_M106_IT,
 FUI_TEXT_WIZ_REHEAT1_IT,
 FUI_TEXT_WIZ_REHEAT2_IT,
 FUI_TEXT_WIZ_WAITTEMP1_IT,
 FUI_TEXT_WIZ_WAITTEMP2_IT,
 FUI_TEXT_EXTRUDER_JAM_IT,
 FUI_TEXT_STANDBY_IT,
 FUI_TEXT_BED_COATING_IT,
 FUI_TEXT_BED_COATING_SET1_IT,
 FUI_TEXT_BED_COATING_SET2_IT,
 FUI_TEXT_NOCOATING_IT,
 FUI_TEXT_BUILDTAK_IT,
 FUI_TEXT_KAPTON_IT,
 FUI_TEXT_BLUETAPE_IT,
 FUI_TEXT_PETTAPE_IT,
 FUI_TEXT_GLUESTICK_IT,
 FUI_TEXT_CUSTOM_IT,
 FUI_TEXT_COATING_CUSTOM_IT,
 FUI_TEXT_LANGUAGE_IT,
 FUI_TEXT_MAINPAGE6_1_IT,
 FUI_TEXT_MAINPAGE6_2_IT,
 FUI_TEXT_MAINPAGE6_3_IT,
 FUI_TEXT_MAINPAGE6_4_IT,
 FUI_TEXT_MAINPAGE6_5_IT,
 FUI_TEXT_MAINPAGE6_6_IT,
 FUI_TEXT_MAINPAGE_TEMP_BED_IT,
 FUI_TEXT_MAINPAGE_BED_IT,
 FUI_TEXT_MAINPAGE_Z_BUF_IT,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_IT,
 FUI_TEXT_MAINPAGE_XY_IT,
 FUI_TEXT_PRINT_TIME_VALUE_IT,
 FUI_TEXT_PRINT_FILAMENT_VALUE_IT,
 FUI_TEXT_METER_PRINTED_IT,
 FUI_TEXT_STATUS_IT,
 FUI_TEXT_EMPTY_IT,
 FUI_TEXT_TEMP_SET_IT,
 FUI_TEXT_CURRENT_TEMP_IT,
 FUI_TEXT_COATING_THICKNESS_IT,
 FUI_TEXT_EXTR3_TEMP_IT,
 FUI_TEXT_EXTR4_TEMP_IT,
 FUI_TEXT_EXTR5_TEMP_IT,
 FUI_TEXT_EXTR3_OFF_IT,
 FUI_TEXT_EXTR4_OFF_IT,
 FUI_TEXT_EXTR5_OFF_IT,
 FUI_TEXT_EXTR3_SELECT_IT,
 FUI_TEXT_EXTR4_SELECT_IT,
 FUI_TEXT_EXTR5_SELECT_IT,
 FUI_TEXT_DITTO_0_IT,
 FUI_TEXT_DITTO_1_IT,
 FUI_TEXT_DITTO_2_IT,
 FUI_TEXT_DITTO_3_IT,
 FUI_TEXT_ZPROBE_HEIGHT_IT,
 FUI_TEXT_OFFSETS_IT,
 FUI_TEXT_X_OFFSET_IT,
 FUI_TEXT_Y_OFFSET_IT,
 FUI_TEXT_Z_OFFSET_IT,
 FUI_TEXT_DBG_ENDSTOP_IT
};
#define LANG_IT_TABLE translations_it
#else
#define LANG_IT_TABLE NULL
#endif // LANGUAGE_IT_ACTIVE


#if LANGUAGE_ES_ACTIVE
TRANS(UI_TEXT_ON_ES);
TRANS(UI_TEXT_OFF_ES);
TRANS(UI_TEXT_NA_ES);
TRANS(UI_TEXT_YES_ES);
TRANS(UI_TEXT_NO_ES);
TRANS(UI_TEXT_PRINT_POS_ES);
TRANS(UI_TEXT_PRINTING_ES);
TRANS(UI_TEXT_IDLE_ES);
TRANS(UI_TEXT_NOSDCARD_ES);
TRANS(UI_TEXT_ERROR_ES);
TRANS(UI_TEXT_BACK_ES);
TRANS(UI_TEXT_QUICK_SETTINGS_ES);
TRANS(UI_TEXT_ERRORMSG_ES);
TRANS(UI_TEXT_CONFIGURATION_ES);
TRANS(UI_TEXT_POSITION_ES);
TRANS(UI_TEXT_EXTRUDER_ES);
TRANS(UI_TEXT_SD_CARD_ES);
TRANS(UI_TEXT_DEBUGGING_ES);
TRANS(UI_TEXT_HOME_DELTA_ES);
TRANS(UI_TEXT_HOME_ALL_ES);
TRANS(UI_TEXT_HOME_X_ES);
TRANS(UI_TEXT_HOME_Y_ES);
TRANS(UI_TEXT_HOME_Z_ES);
TRANS(UI_TEXT_PREHEAT_PLA_ES);
TRANS(UI_TEXT_PREHEAT_ABS_ES);
TRANS(UI_TEXT_LIGHTS_ONOFF_ES);
TRANS(UI_TEXT_COOLDOWN_ES);
TRANS(UI_TEXT_SET_TO_ORIGIN_ES);
TRANS(UI_TEXT_DISABLE_STEPPER_ES);
TRANS(UI_TEXT_X_POSITION_ES);
TRANS(UI_TEXT_X_POS_FAST_ES);
TRANS(UI_TEXT_Y_POSITION_ES);
TRANS(UI_TEXT_Y_POS_FAST_ES);
TRANS(UI_TEXT_Z_POSITION_ES);
TRANS(UI_TEXT_Z_POS_FAST_ES);
TRANS(UI_TEXT_E_POSITION_ES);
TRANS(UI_TEXT_BED_TEMP_ES);
TRANS(UI_TEXT_EXTR0_TEMP_ES);
TRANS(UI_TEXT_EXTR1_TEMP_ES);
TRANS(UI_TEXT_EXTR2_TEMP_ES);
TRANS(UI_TEXT_EXTR0_OFF_ES);
TRANS(UI_TEXT_EXTR1_OFF_ES);
TRANS(UI_TEXT_EXTR2_OFF_ES);
TRANS(UI_TEXT_EXTR0_SELECT_ES);
TRANS(UI_TEXT_EXTR1_SELECT_ES);
TRANS(UI_TEXT_EXTR2_SELECT_ES);
TRANS(UI_TEXT_EXTR_ORIGIN_ES);
TRANS(UI_TEXT_PRINT_X_ES);
TRANS(UI_TEXT_PRINT_Y_ES);
TRANS(UI_TEXT_PRINT_Z_ES);
TRANS(UI_TEXT_PRINT_Z_DELTA_ES);
TRANS(UI_TEXT_MOVE_X_ES);
TRANS(UI_TEXT_MOVE_Y_ES);
TRANS(UI_TEXT_MOVE_Z_ES);
TRANS(UI_TEXT_MOVE_Z_DELTA_ES);
TRANS(UI_TEXT_JERK_ES);
TRANS(UI_TEXT_ZJERK_ES);
TRANS(UI_TEXT_ACCELERATION_ES);
TRANS(UI_TEXT_STORE_TO_EEPROM_ES);
TRANS(UI_TEXT_LOAD_EEPROM_ES);
TRANS(UI_TEXT_DBG_ECHO_ES);
TRANS(UI_TEXT_DBG_INFO_ES);
TRANS(UI_TEXT_DBG_ERROR_ES);
TRANS(UI_TEXT_DBG_DRYRUN_ES);
TRANS(UI_TEXT_DBG_ENDSTOP_ES);
TRANS(UI_TEXT_OPS_OFF_ES);
TRANS(UI_TEXT_OPS_CLASSIC_ES);
TRANS(UI_TEXT_OPS_FAST_ES);
TRANS(UI_TEXT_OPS_RETRACT_ES);
TRANS(UI_TEXT_OPS_BACKSLASH_ES);
TRANS(UI_TEXT_OPS_MINDIST_ES);
TRANS(UI_TEXT_OPS_MOVE_AFTER_ES);
TRANS(UI_TEXT_ANTI_OOZE_ES);
TRANS(UI_TEXT_PRINT_FILE_ES);
TRANS(UI_TEXT_PAUSE_PRINT_ES);
TRANS(UI_TEXT_CONTINUE_PRINT_ES);
TRANS(UI_TEXT_UNMOUNT_CARD_ES);
TRANS(UI_TEXT_MOUNT_CARD_ES);
TRANS(UI_TEXT_DELETE_FILE_ES);
TRANS(UI_TEXT_FEEDRATE_ES);
TRANS(UI_TEXT_FEED_MAX_X_ES);
TRANS(UI_TEXT_FEED_MAX_Y_ES);
TRANS(UI_TEXT_FEED_MAX_Z_ES);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_ES);
TRANS(UI_TEXT_FEED_HOME_X_ES);
TRANS(UI_TEXT_FEED_HOME_Y_ES);
TRANS(UI_TEXT_FEED_HOME_Z_ES);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_ES);
TRANS(UI_TEXT_ACTION_XPOSITION4A_ES);
TRANS(UI_TEXT_ACTION_XPOSITION4B_ES);
TRANS(UI_TEXT_ACTION_XPOSITION4C_ES);
TRANS(UI_TEXT_ACTION_XPOSITION4D_ES);
TRANS(UI_TEXT_ACTION_YPOSITION4A_ES);
TRANS(UI_TEXT_ACTION_YPOSITION4B_ES);
TRANS(UI_TEXT_ACTION_YPOSITION4C_ES);
TRANS(UI_TEXT_ACTION_YPOSITION4D_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_ES);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_ES);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_ES);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_ES);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_ES);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_ES);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_ES);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_ES);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_ES);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_ES);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_ES);
TRANS(UI_TEXT_ACTION_XPOSITION2A_ES);
TRANS(UI_TEXT_ACTION_XPOSITION2B_ES);
TRANS(UI_TEXT_ACTION_YPOSITION2A_ES);
TRANS(UI_TEXT_ACTION_YPOSITION2B_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_ES);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_ES);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_ES);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_ES);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_ES);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_ES);
TRANS(UI_TEXT_FANSPEED_ES);
TRANS(UI_TEXT_ACTION_FANSPEED_ES);
TRANS(UI_TEXT_FAN_OFF_ES);
TRANS(UI_TEXT_FAN_25_ES);
TRANS(UI_TEXT_FAN_50_ES);
TRANS(UI_TEXT_FAN_75_ES);
TRANS(UI_TEXT_FAN_FULL_ES);
TRANS(UI_TEXT_STEPPER_INACTIVE_ES);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_ES);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_ES);
TRANS(UI_TEXT_POWER_INACTIVE_ES);
TRANS(UI_TEXT_POWER_INACTIVE2A_ES);
TRANS(UI_TEXT_POWER_INACTIVE2B_ES);
TRANS(UI_TEXT_GENERAL_ES);
TRANS(UI_TEXT_BAUDRATE_ES);
TRANS(UI_TEXT_EXTR_STEPS_ES);
TRANS(UI_TEXT_EXTR_START_FEED_ES);
TRANS(UI_TEXT_EXTR_MAX_FEED_ES);
TRANS(UI_TEXT_EXTR_ACCEL_ES);
TRANS(UI_TEXT_EXTR_WATCH_ES);
TRANS(UI_TEXT_EXTR_ADVANCE_L_ES);
TRANS(UI_TEXT_EXTR_ADVANCE_K_ES);
TRANS(UI_TEXT_EXTR_MANAGER_ES);
TRANS(UI_TEXT_EXTR_PGAIN_ES);
TRANS(UI_TEXT_EXTR_DEADTIME_ES);
TRANS(UI_TEXT_EXTR_DMAX_DT_ES);
TRANS(UI_TEXT_EXTR_IGAIN_ES);
TRANS(UI_TEXT_EXTR_DGAIN_ES);
TRANS(UI_TEXT_EXTR_DMIN_ES);
TRANS(UI_TEXT_EXTR_DMAX_ES);
TRANS(UI_TEXT_EXTR_PMAX_ES);
TRANS(UI_TEXT_EXTR_XOFF_ES);
TRANS(UI_TEXT_EXTR_YOFF_ES);
TRANS(UI_TEXT_STRING_HM_BANGBANG_ES);
TRANS(UI_TEXT_STRING_HM_PID_ES);
TRANS(UI_TEXT_STRING_ACTION_ES);
TRANS(UI_TEXT_HEATING_EXTRUDER_ES);
TRANS(UI_TEXT_HEATING_BED_ES);
TRANS(UI_TEXT_KILLED_ES);
TRANS(UI_TEXT_STEPPER_DISABLED_ES);
TRANS(UI_TEXT_EEPROM_STOREDA_ES);
TRANS(UI_TEXT_EEPROM_STOREDB_ES);
TRANS(UI_TEXT_EEPROM_LOADEDA_ES);
TRANS(UI_TEXT_EEPROM_LOADEDB_ES);
TRANS(UI_TEXT_UPLOADING_ES);
TRANS(UI_TEXT_PAGE_BUFFER_ES);
TRANS(UI_TEXT_PAGE_EXTRUDER_ES);
TRANS(UI_TEXT_PAGE_EXTRUDER1_ES);
TRANS(UI_TEXT_PAGE_EXTRUDER2_ES);
TRANS(UI_TEXT_PAGE_EXTRUDER3_ES);
TRANS(UI_TEXT_PAGE_BED_ES);
TRANS(UI_TEXT_SPEED_MULTIPLY_ES);
TRANS(UI_TEXT_FLOW_MULTIPLY_ES);
TRANS(UI_TEXT_SHOW_MEASUREMENT_ES);
TRANS(UI_TEXT_RESET_MEASUREMENT_ES);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_ES);
TRANS(UI_TEXT_ZCALIB_ES);
TRANS(UI_TEXT_SET_P1_ES);
TRANS(UI_TEXT_SET_P2_ES);
TRANS(UI_TEXT_SET_P3_ES);
TRANS(UI_TEXT_CALCULATE_LEVELING_ES);
TRANS(UI_TEXT_LEVEL_ES);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_ES);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_ES);
TRANS(UI_TEXT_SD_REMOVED_ES);
TRANS(UI_TEXT_SD_INSERTED_ES);
TRANS(UI_TEXT_PRINTER_READY_ES);
TRANS(UI_TEXT_PRINTTIME_DAYS_ES);
TRANS(UI_TEXT_PRINTTIME_HOURS_ES);
TRANS(UI_TEXT_PRINTTIME_MINUTES_ES);
TRANS(UI_TEXT_PRINT_TIME_ES);
TRANS(UI_TEXT_PRINT_FILAMENT_ES);
TRANS(UI_TEXT_PRINTED_ES);
TRANS(UI_TEXT_POWER_ES);
TRANS(UI_TEXT_STRING_HM_DEADTIME_ES);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_ES);
TRANS(UI_TEXT_STOP_PRINT_ES);
TRANS(UI_TEXT_Z_BABYSTEPPING_ES);
TRANS(UI_TEXT_CHANGE_FILAMENT_ES);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_ES);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_ES);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_ES);
TRANS(UI_TEXT_CLICK_DONE_ES);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_ES);
TRANS(UI_TEXT_SERVOPOS_ES);
TRANS(UI_TEXT_IGNORE_M106_ES);
TRANS(UI_TEXT_WIZ_REHEAT1_ES);
TRANS(UI_TEXT_WIZ_REHEAT2_ES);
TRANS(UI_TEXT_WIZ_WAITTEMP1_ES);
TRANS(UI_TEXT_WIZ_WAITTEMP2_ES);
TRANS(UI_TEXT_EXTRUDER_JAM_ES);
TRANS(UI_TEXT_STANDBY_ES);
TRANS(UI_TEXT_BED_COATING_ES);
TRANS(UI_TEXT_BED_COATING_SET1_ES);
TRANS(UI_TEXT_BED_COATING_SET2_ES);
TRANS(UI_TEXT_NOCOATING_ES);
TRANS(UI_TEXT_BUILDTAK_ES);
TRANS(UI_TEXT_KAPTON_ES);
TRANS(UI_TEXT_BLUETAPE_ES);
TRANS(UI_TEXT_PETTAPE_ES);
TRANS(UI_TEXT_GLUESTICK_ES);
TRANS(UI_TEXT_CUSTOM_ES);
TRANS(UI_TEXT_COATING_CUSTOM_ES);
TRANS(UI_TEXT_LANGUAGE_ES);
TRANS(UI_TEXT_MAINPAGE6_1_ES);
TRANS(UI_TEXT_MAINPAGE6_2_ES);
TRANS(UI_TEXT_MAINPAGE6_3_ES);
TRANS(UI_TEXT_MAINPAGE6_4_ES);
TRANS(UI_TEXT_MAINPAGE6_5_ES);
TRANS(UI_TEXT_MAINPAGE6_6_ES);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_ES);
TRANS(UI_TEXT_MAINPAGE_BED_ES);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_ES);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_ES);
TRANS(UI_TEXT_MAINPAGE_XY_ES);
TRANS(UI_TEXT_PRINT_TIME_VALUE_ES);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_ES);
TRANS(UI_TEXT_METER_PRINTED_ES);
TRANS(UI_TEXT_STATUS_ES);
TRANS(UI_TEXT_EMPTY_ES);
TRANS(UI_TEXT_TEMP_SET_ES);
TRANS(UI_TEXT_CURRENT_TEMP_ES);
TRANS(UI_TEXT_COATING_THICKNESS_ES);
TRANS(UI_TEXT_EXTR3_TEMP_ES);
TRANS(UI_TEXT_EXTR4_TEMP_ES);
TRANS(UI_TEXT_EXTR5_TEMP_ES);
TRANS(UI_TEXT_EXTR3_OFF_ES);
TRANS(UI_TEXT_EXTR4_OFF_ES);
TRANS(UI_TEXT_EXTR5_OFF_ES);
TRANS(UI_TEXT_EXTR3_SELECT_ES);
TRANS(UI_TEXT_EXTR4_SELECT_ES);
TRANS(UI_TEXT_EXTR5_SELECT_ES);
TRANS(UI_TEXT_DITTO_0_ES);
TRANS(UI_TEXT_DITTO_1_ES);
TRANS(UI_TEXT_DITTO_2_ES);
TRANS(UI_TEXT_DITTO_3_ES);
TRANS(UI_TEXT_ZPROBE_HEIGHT_ES);
TRANS(UI_TEXT_OFFSETS_ES);
TRANS(UI_TEXT_X_OFFSET_ES);
TRANS(UI_TEXT_Y_OFFSET_ES);
TRANS(UI_TEXT_Z_OFFSET_ES);

PGM_P const translations_es[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_ES,
 FUI_TEXT_OFF_ES,
 FUI_TEXT_NA_ES,
 FUI_TEXT_YES_ES,
 FUI_TEXT_NO_ES,
 FUI_TEXT_PRINT_POS_ES,
 FUI_TEXT_PRINTING_ES,
 FUI_TEXT_IDLE_ES,
 FUI_TEXT_NOSDCARD_ES,
 FUI_TEXT_ERROR_ES,
 FUI_TEXT_BACK_ES,
 FUI_TEXT_QUICK_SETTINGS_ES,
 FUI_TEXT_ERRORMSG_ES,
 FUI_TEXT_CONFIGURATION_ES,
 FUI_TEXT_POSITION_ES,
 FUI_TEXT_EXTRUDER_ES,
 FUI_TEXT_SD_CARD_ES,
 FUI_TEXT_DEBUGGING_ES,
 FUI_TEXT_HOME_DELTA_ES,
 FUI_TEXT_HOME_ALL_ES,
 FUI_TEXT_HOME_X_ES,
 FUI_TEXT_HOME_Y_ES,
 FUI_TEXT_HOME_Z_ES,
 FUI_TEXT_PREHEAT_PLA_ES,
 FUI_TEXT_PREHEAT_ABS_ES,
 FUI_TEXT_LIGHTS_ONOFF_ES,
 FUI_TEXT_COOLDOWN_ES,
 FUI_TEXT_SET_TO_ORIGIN_ES,
 FUI_TEXT_DISABLE_STEPPER_ES,
 FUI_TEXT_X_POSITION_ES,
 FUI_TEXT_X_POS_FAST_ES,
 FUI_TEXT_Y_POSITION_ES,
 FUI_TEXT_Y_POS_FAST_ES,
 FUI_TEXT_Z_POSITION_ES,
 FUI_TEXT_Z_POS_FAST_ES,
 FUI_TEXT_E_POSITION_ES,
 FUI_TEXT_BED_TEMP_ES,
 FUI_TEXT_EXTR0_TEMP_ES,
 FUI_TEXT_EXTR1_TEMP_ES,
 FUI_TEXT_EXTR2_TEMP_ES,
 FUI_TEXT_EXTR0_OFF_ES,
 FUI_TEXT_EXTR1_OFF_ES,
 FUI_TEXT_EXTR2_OFF_ES,
 FUI_TEXT_EXTR0_SELECT_ES,
 FUI_TEXT_EXTR1_SELECT_ES,
 FUI_TEXT_EXTR2_SELECT_ES,
 FUI_TEXT_EXTR_ORIGIN_ES,
 FUI_TEXT_PRINT_X_ES,
 FUI_TEXT_PRINT_Y_ES,
 FUI_TEXT_PRINT_Z_ES,
 FUI_TEXT_PRINT_Z_DELTA_ES,
 FUI_TEXT_MOVE_X_ES,
 FUI_TEXT_MOVE_Y_ES,
 FUI_TEXT_MOVE_Z_ES,
 FUI_TEXT_MOVE_Z_DELTA_ES,
 FUI_TEXT_JERK_ES,
 FUI_TEXT_ZJERK_ES,
 FUI_TEXT_ACCELERATION_ES,
 FUI_TEXT_STORE_TO_EEPROM_ES,
 FUI_TEXT_LOAD_EEPROM_ES,
 FUI_TEXT_DBG_ECHO_ES,
 FUI_TEXT_DBG_INFO_ES,
 FUI_TEXT_DBG_ERROR_ES,
 FUI_TEXT_DBG_DRYRUN_ES,
 FUI_TEXT_OPS_OFF_ES,
 FUI_TEXT_OPS_CLASSIC_ES,
 FUI_TEXT_OPS_FAST_ES,
 FUI_TEXT_OPS_RETRACT_ES,
 FUI_TEXT_OPS_BACKSLASH_ES,
 FUI_TEXT_OPS_MINDIST_ES,
 FUI_TEXT_OPS_MOVE_AFTER_ES,
 FUI_TEXT_ANTI_OOZE_ES,
 FUI_TEXT_PRINT_FILE_ES,
 FUI_TEXT_PAUSE_PRINT_ES,
 FUI_TEXT_CONTINUE_PRINT_ES,
 FUI_TEXT_UNMOUNT_CARD_ES,
 FUI_TEXT_MOUNT_CARD_ES,
 FUI_TEXT_DELETE_FILE_ES,
 FUI_TEXT_FEEDRATE_ES,
 FUI_TEXT_FEED_MAX_X_ES,
 FUI_TEXT_FEED_MAX_Y_ES,
 FUI_TEXT_FEED_MAX_Z_ES,
 FUI_TEXT_FEED_MAX_Z_DELTA_ES,
 FUI_TEXT_FEED_HOME_X_ES,
 FUI_TEXT_FEED_HOME_Y_ES,
 FUI_TEXT_FEED_HOME_Z_ES,
 FUI_TEXT_FEED_HOME_Z_DELTA_ES,
 FUI_TEXT_ACTION_XPOSITION4A_ES,
 FUI_TEXT_ACTION_XPOSITION4B_ES,
 FUI_TEXT_ACTION_XPOSITION4C_ES,
 FUI_TEXT_ACTION_XPOSITION4D_ES,
 FUI_TEXT_ACTION_YPOSITION4A_ES,
 FUI_TEXT_ACTION_YPOSITION4B_ES,
 FUI_TEXT_ACTION_YPOSITION4C_ES,
 FUI_TEXT_ACTION_YPOSITION4D_ES,
 FUI_TEXT_ACTION_ZPOSITION4A_ES,
 FUI_TEXT_ACTION_ZPOSITION4B_ES,
 FUI_TEXT_ACTION_ZPOSITION4C_ES,
 FUI_TEXT_ACTION_ZPOSITION4D_ES,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_ES,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_ES,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_ES,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_ES,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_ES,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_ES,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_ES,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_ES,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_ES,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_ES,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_ES,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_ES,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_ES,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_ES,
 FUI_TEXT_ACTION_XPOSITION2A_ES,
 FUI_TEXT_ACTION_XPOSITION2B_ES,
 FUI_TEXT_ACTION_YPOSITION2A_ES,
 FUI_TEXT_ACTION_YPOSITION2B_ES,
 FUI_TEXT_ACTION_ZPOSITION2A_ES,
 FUI_TEXT_ACTION_ZPOSITION2B_ES,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_ES,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_ES,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_ES,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_ES,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_ES,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_ES,
 FUI_TEXT_FANSPEED_ES,
 FUI_TEXT_ACTION_FANSPEED_ES,
 FUI_TEXT_FAN_OFF_ES,
 FUI_TEXT_FAN_25_ES,
 FUI_TEXT_FAN_50_ES,
 FUI_TEXT_FAN_75_ES,
 FUI_TEXT_FAN_FULL_ES,
 FUI_TEXT_STEPPER_INACTIVE_ES,
 FUI_TEXT_STEPPER_INACTIVE2A_ES,
 FUI_TEXT_STEPPER_INACTIVE2B_ES,
 FUI_TEXT_POWER_INACTIVE_ES,
 FUI_TEXT_POWER_INACTIVE2A_ES,
 FUI_TEXT_POWER_INACTIVE2B_ES,
 FUI_TEXT_GENERAL_ES,
 FUI_TEXT_BAUDRATE_ES,
 FUI_TEXT_EXTR_STEPS_ES,
 FUI_TEXT_EXTR_START_FEED_ES,
 FUI_TEXT_EXTR_MAX_FEED_ES,
 FUI_TEXT_EXTR_ACCEL_ES,
 FUI_TEXT_EXTR_WATCH_ES,
 FUI_TEXT_EXTR_ADVANCE_L_ES,
 FUI_TEXT_EXTR_ADVANCE_K_ES,
 FUI_TEXT_EXTR_MANAGER_ES,
 FUI_TEXT_EXTR_PGAIN_ES,
 FUI_TEXT_EXTR_DEADTIME_ES,
 FUI_TEXT_EXTR_DMAX_DT_ES,
 FUI_TEXT_EXTR_IGAIN_ES,
 FUI_TEXT_EXTR_DGAIN_ES,
 FUI_TEXT_EXTR_DMIN_ES,
 FUI_TEXT_EXTR_DMAX_ES,
 FUI_TEXT_EXTR_PMAX_ES,
 FUI_TEXT_EXTR_XOFF_ES,
 FUI_TEXT_EXTR_YOFF_ES,
 FUI_TEXT_STRING_HM_BANGBANG_ES,
 FUI_TEXT_STRING_HM_PID_ES,
 FUI_TEXT_STRING_ACTION_ES,
 FUI_TEXT_HEATING_EXTRUDER_ES,
 FUI_TEXT_HEATING_BED_ES,
 FUI_TEXT_KILLED_ES,
 FUI_TEXT_STEPPER_DISABLED_ES,
 FUI_TEXT_EEPROM_STOREDA_ES,
 FUI_TEXT_EEPROM_STOREDB_ES,
 FUI_TEXT_EEPROM_LOADEDA_ES,
 FUI_TEXT_EEPROM_LOADEDB_ES,
 FUI_TEXT_UPLOADING_ES,
 FUI_TEXT_PAGE_BUFFER_ES,
 FUI_TEXT_PAGE_EXTRUDER_ES,
 FUI_TEXT_PAGE_EXTRUDER1_ES,
 FUI_TEXT_PAGE_EXTRUDER2_ES,
 FUI_TEXT_PAGE_EXTRUDER3_ES,
 FUI_TEXT_PAGE_BED_ES,
 FUI_TEXT_SPEED_MULTIPLY_ES,
 FUI_TEXT_FLOW_MULTIPLY_ES,
 FUI_TEXT_SHOW_MEASUREMENT_ES,
 FUI_TEXT_RESET_MEASUREMENT_ES,
 FUI_TEXT_SET_MEASURED_ORIGIN_ES,
 FUI_TEXT_ZCALIB_ES,
 FUI_TEXT_SET_P1_ES,
 FUI_TEXT_SET_P2_ES,
 FUI_TEXT_SET_P3_ES,
 FUI_TEXT_CALCULATE_LEVELING_ES,
 FUI_TEXT_LEVEL_ES,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_ES,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_ES,
 FUI_TEXT_SD_REMOVED_ES,
 FUI_TEXT_SD_INSERTED_ES,
 FUI_TEXT_PRINTER_READY_ES,
 FUI_TEXT_PRINTTIME_DAYS_ES,
 FUI_TEXT_PRINTTIME_HOURS_ES,
 FUI_TEXT_PRINTTIME_MINUTES_ES,
 FUI_TEXT_PRINT_TIME_ES,
 FUI_TEXT_PRINT_FILAMENT_ES,
 FUI_TEXT_PRINTED_ES,
 FUI_TEXT_POWER_ES,
 FUI_TEXT_STRING_HM_DEADTIME_ES,
 FUI_TEXT_STRING_HM_SLOWBANG_ES,
 FUI_TEXT_STOP_PRINT_ES,
 FUI_TEXT_Z_BABYSTEPPING_ES,
 FUI_TEXT_CHANGE_FILAMENT_ES,
 FUI_TEXT_WIZ_CH_FILAMENT1_ES,
 FUI_TEXT_WIZ_CH_FILAMENT2_ES,
 FUI_TEXT_WIZ_CH_FILAMENT3_ES,
 FUI_TEXT_CLICK_DONE_ES,
 FUI_TEXT_AUTOLEVEL_ONOFF_ES,
 FUI_TEXT_SERVOPOS_ES,
 FUI_TEXT_IGNORE_M106_ES,
 FUI_TEXT_WIZ_REHEAT1_ES,
 FUI_TEXT_WIZ_REHEAT2_ES,
 FUI_TEXT_WIZ_WAITTEMP1_ES,
 FUI_TEXT_WIZ_WAITTEMP2_ES,
 FUI_TEXT_EXTRUDER_JAM_ES,
 FUI_TEXT_STANDBY_ES,
 FUI_TEXT_BED_COATING_ES,
 FUI_TEXT_BED_COATING_SET1_ES,
 FUI_TEXT_BED_COATING_SET2_ES,
 FUI_TEXT_NOCOATING_ES,
 FUI_TEXT_BUILDTAK_ES,
 FUI_TEXT_KAPTON_ES,
 FUI_TEXT_BLUETAPE_ES,
 FUI_TEXT_PETTAPE_ES,
 FUI_TEXT_GLUESTICK_ES,
 FUI_TEXT_CUSTOM_ES,
 FUI_TEXT_COATING_CUSTOM_ES,
 FUI_TEXT_LANGUAGE_ES,
 FUI_TEXT_MAINPAGE6_1_ES,
 FUI_TEXT_MAINPAGE6_2_ES,
 FUI_TEXT_MAINPAGE6_3_ES,
 FUI_TEXT_MAINPAGE6_4_ES,
 FUI_TEXT_MAINPAGE6_5_ES,
 FUI_TEXT_MAINPAGE6_6_ES,
 FUI_TEXT_MAINPAGE_TEMP_BED_ES,
 FUI_TEXT_MAINPAGE_BED_ES,
 FUI_TEXT_MAINPAGE_Z_BUF_ES,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_ES,
 FUI_TEXT_MAINPAGE_XY_ES,
 FUI_TEXT_PRINT_TIME_VALUE_ES,
 FUI_TEXT_PRINT_FILAMENT_VALUE_ES,
 FUI_TEXT_METER_PRINTED_ES,
 FUI_TEXT_STATUS_ES,
 FUI_TEXT_EMPTY_ES,
 FUI_TEXT_TEMP_SET_ES,
 FUI_TEXT_CURRENT_TEMP_ES,
 FUI_TEXT_COATING_THICKNESS_ES,
 FUI_TEXT_EXTR3_TEMP_ES,
 FUI_TEXT_EXTR4_TEMP_ES,
 FUI_TEXT_EXTR5_TEMP_ES,
 FUI_TEXT_EXTR3_OFF_ES,
 FUI_TEXT_EXTR4_OFF_ES,
 FUI_TEXT_EXTR5_OFF_ES,
 FUI_TEXT_EXTR3_SELECT_ES,
 FUI_TEXT_EXTR4_SELECT_ES,
 FUI_TEXT_EXTR5_SELECT_ES,
 FUI_TEXT_DITTO_0_ES,
 FUI_TEXT_DITTO_1_ES,
 FUI_TEXT_DITTO_2_ES,
 FUI_TEXT_DITTO_3_ES,
 FUI_TEXT_ZPROBE_HEIGHT_ES,
 FUI_TEXT_OFFSETS_ES,
 FUI_TEXT_X_OFFSET_ES,
 FUI_TEXT_Y_OFFSET_ES,
 FUI_TEXT_Z_OFFSET_ES,
 FUI_TEXT_DBG_ENDSTOP_ES
};
#define LANG_ES_TABLE translations_es
#else
#define LANG_ES_TABLE NULL
#endif // LANGUAGE_ES_ACTIVE


#if LANGUAGE_SE_ACTIVE
TRANS(UI_TEXT_ON_SE);
TRANS(UI_TEXT_OFF_SE);
TRANS(UI_TEXT_NA_SE);
TRANS(UI_TEXT_YES_SE);
TRANS(UI_TEXT_NO_SE);
TRANS(UI_TEXT_PRINT_POS_SE);
TRANS(UI_TEXT_PRINTING_SE);
TRANS(UI_TEXT_IDLE_SE);
TRANS(UI_TEXT_NOSDCARD_SE);
TRANS(UI_TEXT_ERROR_SE);
TRANS(UI_TEXT_BACK_SE);
TRANS(UI_TEXT_QUICK_SETTINGS_SE);
TRANS(UI_TEXT_ERRORMSG_SE);
TRANS(UI_TEXT_CONFIGURATION_SE);
TRANS(UI_TEXT_POSITION_SE);
TRANS(UI_TEXT_EXTRUDER_SE);
TRANS(UI_TEXT_SD_CARD_SE);
TRANS(UI_TEXT_DEBUGGING_SE);
TRANS(UI_TEXT_HOME_DELTA_SE);
TRANS(UI_TEXT_HOME_ALL_SE);
TRANS(UI_TEXT_HOME_X_SE);
TRANS(UI_TEXT_HOME_Y_SE);
TRANS(UI_TEXT_HOME_Z_SE);
TRANS(UI_TEXT_PREHEAT_PLA_SE);
TRANS(UI_TEXT_PREHEAT_ABS_SE);
TRANS(UI_TEXT_LIGHTS_ONOFF_SE);
TRANS(UI_TEXT_COOLDOWN_SE);
TRANS(UI_TEXT_SET_TO_ORIGIN_SE);
TRANS(UI_TEXT_DISABLE_STEPPER_SE);
TRANS(UI_TEXT_X_POSITION_SE);
TRANS(UI_TEXT_X_POS_FAST_SE);
TRANS(UI_TEXT_Y_POSITION_SE);
TRANS(UI_TEXT_Y_POS_FAST_SE);
TRANS(UI_TEXT_Z_POSITION_SE);
TRANS(UI_TEXT_Z_POS_FAST_SE);
TRANS(UI_TEXT_E_POSITION_SE);
TRANS(UI_TEXT_BED_TEMP_SE);
TRANS(UI_TEXT_EXTR0_TEMP_SE);
TRANS(UI_TEXT_EXTR1_TEMP_SE);
TRANS(UI_TEXT_EXTR2_TEMP_SE);
TRANS(UI_TEXT_EXTR0_OFF_SE);
TRANS(UI_TEXT_EXTR1_OFF_SE);
TRANS(UI_TEXT_EXTR2_OFF_SE);
TRANS(UI_TEXT_EXTR0_SELECT_SE);
TRANS(UI_TEXT_EXTR1_SELECT_SE);
TRANS(UI_TEXT_EXTR2_SELECT_SE);
TRANS(UI_TEXT_EXTR_ORIGIN_SE);
TRANS(UI_TEXT_PRINT_X_SE);
TRANS(UI_TEXT_PRINT_Y_SE);
TRANS(UI_TEXT_PRINT_Z_SE);
TRANS(UI_TEXT_PRINT_Z_DELTA_SE);
TRANS(UI_TEXT_MOVE_X_SE);
TRANS(UI_TEXT_MOVE_Y_SE);
TRANS(UI_TEXT_MOVE_Z_SE);
TRANS(UI_TEXT_MOVE_Z_DELTA_SE);
TRANS(UI_TEXT_JERK_SE);
TRANS(UI_TEXT_ZJERK_SE);
TRANS(UI_TEXT_ACCELERATION_SE);
TRANS(UI_TEXT_STORE_TO_EEPROM_SE);
TRANS(UI_TEXT_LOAD_EEPROM_SE);
TRANS(UI_TEXT_DBG_ECHO_SE);
TRANS(UI_TEXT_DBG_INFO_SE);
TRANS(UI_TEXT_DBG_ERROR_SE);
TRANS(UI_TEXT_DBG_DRYRUN_SE);
TRANS(UI_TEXT_DBG_ENDSTOP_SE);
TRANS(UI_TEXT_OPS_OFF_SE);
TRANS(UI_TEXT_OPS_CLASSIC_SE);
TRANS(UI_TEXT_OPS_FAST_SE);
TRANS(UI_TEXT_OPS_RETRACT_SE);
TRANS(UI_TEXT_OPS_BACKSLASH_SE);
TRANS(UI_TEXT_OPS_MINDIST_SE);
TRANS(UI_TEXT_OPS_MOVE_AFTER_SE);
TRANS(UI_TEXT_ANTI_OOZE_SE);
TRANS(UI_TEXT_PRINT_FILE_SE);
TRANS(UI_TEXT_PAUSE_PRINT_SE);
TRANS(UI_TEXT_CONTINUE_PRINT_SE);
TRANS(UI_TEXT_UNMOUNT_CARD_SE);
TRANS(UI_TEXT_MOUNT_CARD_SE);
TRANS(UI_TEXT_DELETE_FILE_SE);
TRANS(UI_TEXT_FEEDRATE_SE);
TRANS(UI_TEXT_FEED_MAX_X_SE);
TRANS(UI_TEXT_FEED_MAX_Y_SE);
TRANS(UI_TEXT_FEED_MAX_Z_SE);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_SE);
TRANS(UI_TEXT_FEED_HOME_X_SE);
TRANS(UI_TEXT_FEED_HOME_Y_SE);
TRANS(UI_TEXT_FEED_HOME_Z_SE);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_SE);
TRANS(UI_TEXT_ACTION_XPOSITION4A_SE);
TRANS(UI_TEXT_ACTION_XPOSITION4B_SE);
TRANS(UI_TEXT_ACTION_XPOSITION4C_SE);
TRANS(UI_TEXT_ACTION_XPOSITION4D_SE);
TRANS(UI_TEXT_ACTION_YPOSITION4A_SE);
TRANS(UI_TEXT_ACTION_YPOSITION4B_SE);
TRANS(UI_TEXT_ACTION_YPOSITION4C_SE);
TRANS(UI_TEXT_ACTION_YPOSITION4D_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_SE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_SE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_SE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_SE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_SE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_SE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_SE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_SE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_SE);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_SE);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_SE);
TRANS(UI_TEXT_ACTION_XPOSITION2A_SE);
TRANS(UI_TEXT_ACTION_XPOSITION2B_SE);
TRANS(UI_TEXT_ACTION_YPOSITION2A_SE);
TRANS(UI_TEXT_ACTION_YPOSITION2B_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_SE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_SE);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_SE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_SE);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_SE);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_SE);
TRANS(UI_TEXT_FANSPEED_SE);
TRANS(UI_TEXT_ACTION_FANSPEED_SE);
TRANS(UI_TEXT_FAN_OFF_SE);
TRANS(UI_TEXT_FAN_25_SE);
TRANS(UI_TEXT_FAN_50_SE);
TRANS(UI_TEXT_FAN_75_SE);
TRANS(UI_TEXT_FAN_FULL_SE);
TRANS(UI_TEXT_STEPPER_INACTIVE_SE);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_SE);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_SE);
TRANS(UI_TEXT_POWER_INACTIVE_SE);
TRANS(UI_TEXT_POWER_INACTIVE2A_SE);
TRANS(UI_TEXT_POWER_INACTIVE2B_SE);
TRANS(UI_TEXT_GENERAL_SE);
TRANS(UI_TEXT_BAUDRATE_SE);
TRANS(UI_TEXT_EXTR_STEPS_SE);
TRANS(UI_TEXT_EXTR_START_FEED_SE);
TRANS(UI_TEXT_EXTR_MAX_FEED_SE);
TRANS(UI_TEXT_EXTR_ACCEL_SE);
TRANS(UI_TEXT_EXTR_WATCH_SE);
TRANS(UI_TEXT_EXTR_ADVANCE_L_SE);
TRANS(UI_TEXT_EXTR_ADVANCE_K_SE);
TRANS(UI_TEXT_EXTR_MANAGER_SE);
TRANS(UI_TEXT_EXTR_PGAIN_SE);
TRANS(UI_TEXT_EXTR_DEADTIME_SE);
TRANS(UI_TEXT_EXTR_DMAX_DT_SE);
TRANS(UI_TEXT_EXTR_IGAIN_SE);
TRANS(UI_TEXT_EXTR_DGAIN_SE);
TRANS(UI_TEXT_EXTR_DMIN_SE);
TRANS(UI_TEXT_EXTR_DMAX_SE);
TRANS(UI_TEXT_EXTR_PMAX_SE);
TRANS(UI_TEXT_EXTR_XOFF_SE);
TRANS(UI_TEXT_EXTR_YOFF_SE);
TRANS(UI_TEXT_STRING_HM_BANGBANG_SE);
TRANS(UI_TEXT_STRING_HM_PID_SE);
TRANS(UI_TEXT_STRING_ACTION_SE);
TRANS(UI_TEXT_HEATING_EXTRUDER_SE);
TRANS(UI_TEXT_HEATING_BED_SE);
TRANS(UI_TEXT_KILLED_SE);
TRANS(UI_TEXT_STEPPER_DISABLED_SE);
TRANS(UI_TEXT_EEPROM_STOREDA_SE);
TRANS(UI_TEXT_EEPROM_STOREDB_SE);
TRANS(UI_TEXT_EEPROM_LOADEDA_SE);
TRANS(UI_TEXT_EEPROM_LOADEDB_SE);
TRANS(UI_TEXT_UPLOADING_SE);
TRANS(UI_TEXT_PAGE_BUFFER_SE);
TRANS(UI_TEXT_PAGE_EXTRUDER_SE);
TRANS(UI_TEXT_PAGE_EXTRUDER1_SE);
TRANS(UI_TEXT_PAGE_EXTRUDER2_SE);
TRANS(UI_TEXT_PAGE_EXTRUDER3_SE);
TRANS(UI_TEXT_PAGE_BED_SE);
TRANS(UI_TEXT_SPEED_MULTIPLY_SE);
TRANS(UI_TEXT_FLOW_MULTIPLY_SE);
TRANS(UI_TEXT_SHOW_MEASUREMENT_SE);
TRANS(UI_TEXT_RESET_MEASUREMENT_SE);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_SE);
TRANS(UI_TEXT_ZCALIB_SE);
TRANS(UI_TEXT_SET_P1_SE);
TRANS(UI_TEXT_SET_P2_SE);
TRANS(UI_TEXT_SET_P3_SE);
TRANS(UI_TEXT_CALCULATE_LEVELING_SE);
TRANS(UI_TEXT_LEVEL_SE);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_SE);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_SE);
TRANS(UI_TEXT_SD_REMOVED_SE);
TRANS(UI_TEXT_SD_INSERTED_SE);
TRANS(UI_TEXT_PRINTER_READY_SE);
TRANS(UI_TEXT_PRINTTIME_DAYS_SE);
TRANS(UI_TEXT_PRINTTIME_HOURS_SE);
TRANS(UI_TEXT_PRINTTIME_MINUTES_SE);
TRANS(UI_TEXT_PRINT_TIME_SE);
TRANS(UI_TEXT_PRINT_FILAMENT_SE);
TRANS(UI_TEXT_PRINTED_SE);
TRANS(UI_TEXT_POWER_SE);
TRANS(UI_TEXT_STRING_HM_DEADTIME_SE);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_SE);
TRANS(UI_TEXT_STOP_PRINT_SE);
TRANS(UI_TEXT_Z_BABYSTEPPING_SE);
TRANS(UI_TEXT_CHANGE_FILAMENT_SE);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_SE);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_SE);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_SE);
TRANS(UI_TEXT_CLICK_DONE_SE);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_SE);
TRANS(UI_TEXT_SERVOPOS_SE);
TRANS(UI_TEXT_IGNORE_M106_SE);
TRANS(UI_TEXT_WIZ_REHEAT1_SE);
TRANS(UI_TEXT_WIZ_REHEAT2_SE);
TRANS(UI_TEXT_WIZ_WAITTEMP1_SE);
TRANS(UI_TEXT_WIZ_WAITTEMP2_SE);
TRANS(UI_TEXT_EXTRUDER_JAM_SE);
TRANS(UI_TEXT_STANDBY_SE);
TRANS(UI_TEXT_BED_COATING_SE);
TRANS(UI_TEXT_BED_COATING_SET1_SE);
TRANS(UI_TEXT_BED_COATING_SET2_SE);
TRANS(UI_TEXT_NOCOATING_SE);
TRANS(UI_TEXT_BUILDTAK_SE);
TRANS(UI_TEXT_KAPTON_SE);
TRANS(UI_TEXT_BLUETAPE_SE);
TRANS(UI_TEXT_PETTAPE_SE);
TRANS(UI_TEXT_GLUESTICK_SE);
TRANS(UI_TEXT_CUSTOM_SE);
TRANS(UI_TEXT_COATING_CUSTOM_SE);
TRANS(UI_TEXT_LANGUAGE_SE);
TRANS(UI_TEXT_MAINPAGE6_1_SE);
TRANS(UI_TEXT_MAINPAGE6_2_SE);
TRANS(UI_TEXT_MAINPAGE6_3_SE);
TRANS(UI_TEXT_MAINPAGE6_4_SE);
TRANS(UI_TEXT_MAINPAGE6_5_SE);
TRANS(UI_TEXT_MAINPAGE6_6_SE);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_SE);
TRANS(UI_TEXT_MAINPAGE_BED_SE);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_SE);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_SE);
TRANS(UI_TEXT_MAINPAGE_XY_SE);
TRANS(UI_TEXT_PRINT_TIME_VALUE_SE);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_SE);
TRANS(UI_TEXT_METER_PRINTED_SE);
TRANS(UI_TEXT_STATUS_SE);
TRANS(UI_TEXT_EMPTY_SE);
TRANS(UI_TEXT_TEMP_SET_SE);
TRANS(UI_TEXT_CURRENT_TEMP_SE);
TRANS(UI_TEXT_COATING_THICKNESS_SE);
TRANS(UI_TEXT_EXTR3_TEMP_SE);
TRANS(UI_TEXT_EXTR4_TEMP_SE);
TRANS(UI_TEXT_EXTR5_TEMP_SE);
TRANS(UI_TEXT_EXTR3_OFF_SE);
TRANS(UI_TEXT_EXTR4_OFF_SE);
TRANS(UI_TEXT_EXTR5_OFF_SE);
TRANS(UI_TEXT_EXTR3_SELECT_SE);
TRANS(UI_TEXT_EXTR4_SELECT_SE);
TRANS(UI_TEXT_EXTR5_SELECT_SE);
TRANS(UI_TEXT_DITTO_0_SE);
TRANS(UI_TEXT_DITTO_1_SE);
TRANS(UI_TEXT_DITTO_2_SE);
TRANS(UI_TEXT_DITTO_3_SE);
TRANS(UI_TEXT_ZPROBE_HEIGHT_SE);
TRANS(UI_TEXT_OFFSETS_SE);
TRANS(UI_TEXT_X_OFFSET_SE);
TRANS(UI_TEXT_Y_OFFSET_SE);
TRANS(UI_TEXT_Z_OFFSET_SE);

PGM_P const translations_se[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_SE,
 FUI_TEXT_OFF_SE,
 FUI_TEXT_NA_SE,
 FUI_TEXT_YES_SE,
 FUI_TEXT_NO_SE,
 FUI_TEXT_PRINT_POS_SE,
 FUI_TEXT_PRINTING_SE,
 FUI_TEXT_IDLE_SE,
 FUI_TEXT_NOSDCARD_SE,
 FUI_TEXT_ERROR_SE,
 FUI_TEXT_BACK_SE,
 FUI_TEXT_QUICK_SETTINGS_SE,
 FUI_TEXT_ERRORMSG_SE,
 FUI_TEXT_CONFIGURATION_SE,
 FUI_TEXT_POSITION_SE,
 FUI_TEXT_EXTRUDER_SE,
 FUI_TEXT_SD_CARD_SE,
 FUI_TEXT_DEBUGGING_SE,
 FUI_TEXT_HOME_DELTA_SE,
 FUI_TEXT_HOME_ALL_SE,
 FUI_TEXT_HOME_X_SE,
 FUI_TEXT_HOME_Y_SE,
 FUI_TEXT_HOME_Z_SE,
 FUI_TEXT_PREHEAT_PLA_SE,
 FUI_TEXT_PREHEAT_ABS_SE,
 FUI_TEXT_LIGHTS_ONOFF_SE,
 FUI_TEXT_COOLDOWN_SE,
 FUI_TEXT_SET_TO_ORIGIN_SE,
 FUI_TEXT_DISABLE_STEPPER_SE,
 FUI_TEXT_X_POSITION_SE,
 FUI_TEXT_X_POS_FAST_SE,
 FUI_TEXT_Y_POSITION_SE,
 FUI_TEXT_Y_POS_FAST_SE,
 FUI_TEXT_Z_POSITION_SE,
 FUI_TEXT_Z_POS_FAST_SE,
 FUI_TEXT_E_POSITION_SE,
 FUI_TEXT_BED_TEMP_SE,
 FUI_TEXT_EXTR0_TEMP_SE,
 FUI_TEXT_EXTR1_TEMP_SE,
 FUI_TEXT_EXTR2_TEMP_SE,
 FUI_TEXT_EXTR0_OFF_SE,
 FUI_TEXT_EXTR1_OFF_SE,
 FUI_TEXT_EXTR2_OFF_SE,
 FUI_TEXT_EXTR0_SELECT_SE,
 FUI_TEXT_EXTR1_SELECT_SE,
 FUI_TEXT_EXTR2_SELECT_SE,
 FUI_TEXT_EXTR_ORIGIN_SE,
 FUI_TEXT_PRINT_X_SE,
 FUI_TEXT_PRINT_Y_SE,
 FUI_TEXT_PRINT_Z_SE,
 FUI_TEXT_PRINT_Z_DELTA_SE,
 FUI_TEXT_MOVE_X_SE,
 FUI_TEXT_MOVE_Y_SE,
 FUI_TEXT_MOVE_Z_SE,
 FUI_TEXT_MOVE_Z_DELTA_SE,
 FUI_TEXT_JERK_SE,
 FUI_TEXT_ZJERK_SE,
 FUI_TEXT_ACCELERATION_SE,
 FUI_TEXT_STORE_TO_EEPROM_SE,
 FUI_TEXT_LOAD_EEPROM_SE,
 FUI_TEXT_DBG_ECHO_SE,
 FUI_TEXT_DBG_INFO_SE,
 FUI_TEXT_DBG_ERROR_SE,
 FUI_TEXT_DBG_DRYRUN_SE,
 FUI_TEXT_OPS_OFF_SE,
 FUI_TEXT_OPS_CLASSIC_SE,
 FUI_TEXT_OPS_FAST_SE,
 FUI_TEXT_OPS_RETRACT_SE,
 FUI_TEXT_OPS_BACKSLASH_SE,
 FUI_TEXT_OPS_MINDIST_SE,
 FUI_TEXT_OPS_MOVE_AFTER_SE,
 FUI_TEXT_ANTI_OOZE_SE,
 FUI_TEXT_PRINT_FILE_SE,
 FUI_TEXT_PAUSE_PRINT_SE,
 FUI_TEXT_CONTINUE_PRINT_SE,
 FUI_TEXT_UNMOUNT_CARD_SE,
 FUI_TEXT_MOUNT_CARD_SE,
 FUI_TEXT_DELETE_FILE_SE,
 FUI_TEXT_FEEDRATE_SE,
 FUI_TEXT_FEED_MAX_X_SE,
 FUI_TEXT_FEED_MAX_Y_SE,
 FUI_TEXT_FEED_MAX_Z_SE,
 FUI_TEXT_FEED_MAX_Z_DELTA_SE,
 FUI_TEXT_FEED_HOME_X_SE,
 FUI_TEXT_FEED_HOME_Y_SE,
 FUI_TEXT_FEED_HOME_Z_SE,
 FUI_TEXT_FEED_HOME_Z_DELTA_SE,
 FUI_TEXT_ACTION_XPOSITION4A_SE,
 FUI_TEXT_ACTION_XPOSITION4B_SE,
 FUI_TEXT_ACTION_XPOSITION4C_SE,
 FUI_TEXT_ACTION_XPOSITION4D_SE,
 FUI_TEXT_ACTION_YPOSITION4A_SE,
 FUI_TEXT_ACTION_YPOSITION4B_SE,
 FUI_TEXT_ACTION_YPOSITION4C_SE,
 FUI_TEXT_ACTION_YPOSITION4D_SE,
 FUI_TEXT_ACTION_ZPOSITION4A_SE,
 FUI_TEXT_ACTION_ZPOSITION4B_SE,
 FUI_TEXT_ACTION_ZPOSITION4C_SE,
 FUI_TEXT_ACTION_ZPOSITION4D_SE,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_SE,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_SE,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_SE,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_SE,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_SE,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_SE,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_SE,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_SE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_SE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_SE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_SE,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_SE,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_SE,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_SE,
 FUI_TEXT_ACTION_XPOSITION2A_SE,
 FUI_TEXT_ACTION_XPOSITION2B_SE,
 FUI_TEXT_ACTION_YPOSITION2A_SE,
 FUI_TEXT_ACTION_YPOSITION2B_SE,
 FUI_TEXT_ACTION_ZPOSITION2A_SE,
 FUI_TEXT_ACTION_ZPOSITION2B_SE,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_SE,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_SE,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_SE,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_SE,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_SE,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_SE,
 FUI_TEXT_FANSPEED_SE,
 FUI_TEXT_ACTION_FANSPEED_SE,
 FUI_TEXT_FAN_OFF_SE,
 FUI_TEXT_FAN_25_SE,
 FUI_TEXT_FAN_50_SE,
 FUI_TEXT_FAN_75_SE,
 FUI_TEXT_FAN_FULL_SE,
 FUI_TEXT_STEPPER_INACTIVE_SE,
 FUI_TEXT_STEPPER_INACTIVE2A_SE,
 FUI_TEXT_STEPPER_INACTIVE2B_SE,
 FUI_TEXT_POWER_INACTIVE_SE,
 FUI_TEXT_POWER_INACTIVE2A_SE,
 FUI_TEXT_POWER_INACTIVE2B_SE,
 FUI_TEXT_GENERAL_SE,
 FUI_TEXT_BAUDRATE_SE,
 FUI_TEXT_EXTR_STEPS_SE,
 FUI_TEXT_EXTR_START_FEED_SE,
 FUI_TEXT_EXTR_MAX_FEED_SE,
 FUI_TEXT_EXTR_ACCEL_SE,
 FUI_TEXT_EXTR_WATCH_SE,
 FUI_TEXT_EXTR_ADVANCE_L_SE,
 FUI_TEXT_EXTR_ADVANCE_K_SE,
 FUI_TEXT_EXTR_MANAGER_SE,
 FUI_TEXT_EXTR_PGAIN_SE,
 FUI_TEXT_EXTR_DEADTIME_SE,
 FUI_TEXT_EXTR_DMAX_DT_SE,
 FUI_TEXT_EXTR_IGAIN_SE,
 FUI_TEXT_EXTR_DGAIN_SE,
 FUI_TEXT_EXTR_DMIN_SE,
 FUI_TEXT_EXTR_DMAX_SE,
 FUI_TEXT_EXTR_PMAX_SE,
 FUI_TEXT_EXTR_XOFF_SE,
 FUI_TEXT_EXTR_YOFF_SE,
 FUI_TEXT_STRING_HM_BANGBANG_SE,
 FUI_TEXT_STRING_HM_PID_SE,
 FUI_TEXT_STRING_ACTION_SE,
 FUI_TEXT_HEATING_EXTRUDER_SE,
 FUI_TEXT_HEATING_BED_SE,
 FUI_TEXT_KILLED_SE,
 FUI_TEXT_STEPPER_DISABLED_SE,
 FUI_TEXT_EEPROM_STOREDA_SE,
 FUI_TEXT_EEPROM_STOREDB_SE,
 FUI_TEXT_EEPROM_LOADEDA_SE,
 FUI_TEXT_EEPROM_LOADEDB_SE,
 FUI_TEXT_UPLOADING_SE,
 FUI_TEXT_PAGE_BUFFER_SE,
 FUI_TEXT_PAGE_EXTRUDER_SE,
 FUI_TEXT_PAGE_EXTRUDER1_SE,
 FUI_TEXT_PAGE_EXTRUDER2_SE,
 FUI_TEXT_PAGE_EXTRUDER3_SE,
 FUI_TEXT_PAGE_BED_SE,
 FUI_TEXT_SPEED_MULTIPLY_SE,
 FUI_TEXT_FLOW_MULTIPLY_SE,
 FUI_TEXT_SHOW_MEASUREMENT_SE,
 FUI_TEXT_RESET_MEASUREMENT_SE,
 FUI_TEXT_SET_MEASURED_ORIGIN_SE,
 FUI_TEXT_ZCALIB_SE,
 FUI_TEXT_SET_P1_SE,
 FUI_TEXT_SET_P2_SE,
 FUI_TEXT_SET_P3_SE,
 FUI_TEXT_CALCULATE_LEVELING_SE,
 FUI_TEXT_LEVEL_SE,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_SE,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_SE,
 FUI_TEXT_SD_REMOVED_SE,
 FUI_TEXT_SD_INSERTED_SE,
 FUI_TEXT_PRINTER_READY_SE,
 FUI_TEXT_PRINTTIME_DAYS_SE,
 FUI_TEXT_PRINTTIME_HOURS_SE,
 FUI_TEXT_PRINTTIME_MINUTES_SE,
 FUI_TEXT_PRINT_TIME_SE,
 FUI_TEXT_PRINT_FILAMENT_SE,
 FUI_TEXT_PRINTED_SE,
 FUI_TEXT_POWER_SE,
 FUI_TEXT_STRING_HM_DEADTIME_SE,
 FUI_TEXT_STRING_HM_SLOWBANG_SE,
 FUI_TEXT_STOP_PRINT_SE,
 FUI_TEXT_Z_BABYSTEPPING_SE,
 FUI_TEXT_CHANGE_FILAMENT_SE,
 FUI_TEXT_WIZ_CH_FILAMENT1_SE,
 FUI_TEXT_WIZ_CH_FILAMENT2_SE,
 FUI_TEXT_WIZ_CH_FILAMENT3_SE,
 FUI_TEXT_CLICK_DONE_SE,
 FUI_TEXT_AUTOLEVEL_ONOFF_SE,
 FUI_TEXT_SERVOPOS_SE,
 FUI_TEXT_IGNORE_M106_SE,
 FUI_TEXT_WIZ_REHEAT1_SE,
 FUI_TEXT_WIZ_REHEAT2_SE,
 FUI_TEXT_WIZ_WAITTEMP1_SE,
 FUI_TEXT_WIZ_WAITTEMP2_SE,
 FUI_TEXT_EXTRUDER_JAM_SE,
 FUI_TEXT_STANDBY_SE,
 FUI_TEXT_BED_COATING_SE,
 FUI_TEXT_BED_COATING_SET1_SE,
 FUI_TEXT_BED_COATING_SET2_SE,
 FUI_TEXT_NOCOATING_SE,
 FUI_TEXT_BUILDTAK_SE,
 FUI_TEXT_KAPTON_SE,
 FUI_TEXT_BLUETAPE_SE,
 FUI_TEXT_PETTAPE_SE,
 FUI_TEXT_GLUESTICK_SE,
 FUI_TEXT_CUSTOM_SE,
 FUI_TEXT_COATING_CUSTOM_SE,
 FUI_TEXT_LANGUAGE_SE,
 FUI_TEXT_MAINPAGE6_1_SE,
 FUI_TEXT_MAINPAGE6_2_SE,
 FUI_TEXT_MAINPAGE6_3_SE,
 FUI_TEXT_MAINPAGE6_4_SE,
 FUI_TEXT_MAINPAGE6_5_SE,
 FUI_TEXT_MAINPAGE6_6_SE,
 FUI_TEXT_MAINPAGE_TEMP_BED_SE,
 FUI_TEXT_MAINPAGE_BED_SE,
 FUI_TEXT_MAINPAGE_Z_BUF_SE,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_SE,
 FUI_TEXT_MAINPAGE_XY_SE,
 FUI_TEXT_PRINT_TIME_VALUE_SE,
 FUI_TEXT_PRINT_FILAMENT_VALUE_SE,
 FUI_TEXT_METER_PRINTED_SE,
 FUI_TEXT_STATUS_SE,
 FUI_TEXT_EMPTY_SE,
 FUI_TEXT_TEMP_SET_SE,
 FUI_TEXT_CURRENT_TEMP_SE,
 FUI_TEXT_COATING_THICKNESS_SE,
 FUI_TEXT_EXTR3_TEMP_SE,
 FUI_TEXT_EXTR4_TEMP_SE,
 FUI_TEXT_EXTR5_TEMP_SE,
 FUI_TEXT_EXTR3_OFF_SE,
 FUI_TEXT_EXTR4_OFF_SE,
 FUI_TEXT_EXTR5_OFF_SE,
 FUI_TEXT_EXTR3_SELECT_SE,
 FUI_TEXT_EXTR4_SELECT_SE,
 FUI_TEXT_EXTR5_SELECT_SE,
 FUI_TEXT_DITTO_0_SE,
 FUI_TEXT_DITTO_1_SE,
 FUI_TEXT_DITTO_2_SE,
 FUI_TEXT_DITTO_3_SE,
 FUI_TEXT_ZPROBE_HEIGHT_SE,
 FUI_TEXT_OFFSETS_SE,
 FUI_TEXT_X_OFFSET_SE,
 FUI_TEXT_Y_OFFSET_SE,
 FUI_TEXT_Z_OFFSET_SE,
 FUI_TEXT_DBG_ENDSTOP_SE
};
#define LANG_SE_TABLE translations_se
#else
#define LANG_SE_TABLE NULL
#endif // LANGUAGE_SE_ACTIVE


#if LANGUAGE_FR_ACTIVE
TRANS(UI_TEXT_ON_FR);
TRANS(UI_TEXT_OFF_FR);
TRANS(UI_TEXT_NA_FR);
TRANS(UI_TEXT_YES_FR);
TRANS(UI_TEXT_NO_FR);
TRANS(UI_TEXT_PRINT_POS_FR);
TRANS(UI_TEXT_PRINTING_FR);
TRANS(UI_TEXT_IDLE_FR);
TRANS(UI_TEXT_NOSDCARD_FR);
TRANS(UI_TEXT_ERROR_FR);
TRANS(UI_TEXT_BACK_FR);
TRANS(UI_TEXT_QUICK_SETTINGS_FR);
TRANS(UI_TEXT_ERRORMSG_FR);
TRANS(UI_TEXT_CONFIGURATION_FR);
TRANS(UI_TEXT_POSITION_FR);
TRANS(UI_TEXT_EXTRUDER_FR);
TRANS(UI_TEXT_SD_CARD_FR);
TRANS(UI_TEXT_DEBUGGING_FR);
TRANS(UI_TEXT_HOME_DELTA_FR);
TRANS(UI_TEXT_HOME_ALL_FR);
TRANS(UI_TEXT_HOME_X_FR);
TRANS(UI_TEXT_HOME_Y_FR);
TRANS(UI_TEXT_HOME_Z_FR);
TRANS(UI_TEXT_PREHEAT_PLA_FR);
TRANS(UI_TEXT_PREHEAT_ABS_FR);
TRANS(UI_TEXT_LIGHTS_ONOFF_FR);
TRANS(UI_TEXT_COOLDOWN_FR);
TRANS(UI_TEXT_SET_TO_ORIGIN_FR);
TRANS(UI_TEXT_DISABLE_STEPPER_FR);
TRANS(UI_TEXT_X_POSITION_FR);
TRANS(UI_TEXT_X_POS_FAST_FR);
TRANS(UI_TEXT_Y_POSITION_FR);
TRANS(UI_TEXT_Y_POS_FAST_FR);
TRANS(UI_TEXT_Z_POSITION_FR);
TRANS(UI_TEXT_Z_POS_FAST_FR);
TRANS(UI_TEXT_E_POSITION_FR);
TRANS(UI_TEXT_BED_TEMP_FR);
TRANS(UI_TEXT_EXTR0_TEMP_FR);
TRANS(UI_TEXT_EXTR1_TEMP_FR);
TRANS(UI_TEXT_EXTR2_TEMP_FR);
TRANS(UI_TEXT_EXTR0_OFF_FR);
TRANS(UI_TEXT_EXTR1_OFF_FR);
TRANS(UI_TEXT_EXTR2_OFF_FR);
TRANS(UI_TEXT_EXTR0_SELECT_FR);
TRANS(UI_TEXT_EXTR1_SELECT_FR);
TRANS(UI_TEXT_EXTR2_SELECT_FR);
TRANS(UI_TEXT_EXTR_ORIGIN_FR);
TRANS(UI_TEXT_PRINT_X_FR);
TRANS(UI_TEXT_PRINT_Y_FR);
TRANS(UI_TEXT_PRINT_Z_FR);
TRANS(UI_TEXT_PRINT_Z_DELTA_FR);
TRANS(UI_TEXT_MOVE_X_FR);
TRANS(UI_TEXT_MOVE_Y_FR);
TRANS(UI_TEXT_MOVE_Z_FR);
TRANS(UI_TEXT_MOVE_Z_DELTA_FR);
TRANS(UI_TEXT_JERK_FR);
TRANS(UI_TEXT_ZJERK_FR);
TRANS(UI_TEXT_ACCELERATION_FR);
TRANS(UI_TEXT_STORE_TO_EEPROM_FR);
TRANS(UI_TEXT_LOAD_EEPROM_FR);
TRANS(UI_TEXT_DBG_ECHO_FR);
TRANS(UI_TEXT_DBG_INFO_FR);
TRANS(UI_TEXT_DBG_ERROR_FR);
TRANS(UI_TEXT_DBG_DRYRUN_FR);
TRANS(UI_TEXT_DBG_ENDSTOP_FR);
TRANS(UI_TEXT_OPS_OFF_FR);
TRANS(UI_TEXT_OPS_CLASSIC_FR);
TRANS(UI_TEXT_OPS_FAST_FR);
TRANS(UI_TEXT_OPS_RETRACT_FR);
TRANS(UI_TEXT_OPS_BACKSLASH_FR);
TRANS(UI_TEXT_OPS_MINDIST_FR);
TRANS(UI_TEXT_OPS_MOVE_AFTER_FR);
TRANS(UI_TEXT_ANTI_OOZE_FR);
TRANS(UI_TEXT_PRINT_FILE_FR);
TRANS(UI_TEXT_PAUSE_PRINT_FR);
TRANS(UI_TEXT_CONTINUE_PRINT_FR);
TRANS(UI_TEXT_UNMOUNT_CARD_FR);
TRANS(UI_TEXT_MOUNT_CARD_FR);
TRANS(UI_TEXT_DELETE_FILE_FR);
TRANS(UI_TEXT_FEEDRATE_FR);
TRANS(UI_TEXT_FEED_MAX_X_FR);
TRANS(UI_TEXT_FEED_MAX_Y_FR);
TRANS(UI_TEXT_FEED_MAX_Z_FR);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_FR);
TRANS(UI_TEXT_FEED_HOME_X_FR);
TRANS(UI_TEXT_FEED_HOME_Y_FR);
TRANS(UI_TEXT_FEED_HOME_Z_FR);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_FR);
TRANS(UI_TEXT_ACTION_XPOSITION4A_FR);
TRANS(UI_TEXT_ACTION_XPOSITION4B_FR);
TRANS(UI_TEXT_ACTION_XPOSITION4C_FR);
TRANS(UI_TEXT_ACTION_XPOSITION4D_FR);
TRANS(UI_TEXT_ACTION_YPOSITION4A_FR);
TRANS(UI_TEXT_ACTION_YPOSITION4B_FR);
TRANS(UI_TEXT_ACTION_YPOSITION4C_FR);
TRANS(UI_TEXT_ACTION_YPOSITION4D_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_FR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_FR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_FR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_FR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_FR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_FR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_FR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_FR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_FR);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_FR);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_FR);
TRANS(UI_TEXT_ACTION_XPOSITION2A_FR);
TRANS(UI_TEXT_ACTION_XPOSITION2B_FR);
TRANS(UI_TEXT_ACTION_YPOSITION2A_FR);
TRANS(UI_TEXT_ACTION_YPOSITION2B_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_FR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_FR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_FR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_FR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_FR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_FR);
TRANS(UI_TEXT_FANSPEED_FR);
TRANS(UI_TEXT_ACTION_FANSPEED_FR);
TRANS(UI_TEXT_FAN_OFF_FR);
TRANS(UI_TEXT_FAN_25_FR);
TRANS(UI_TEXT_FAN_50_FR);
TRANS(UI_TEXT_FAN_75_FR);
TRANS(UI_TEXT_FAN_FULL_FR);
TRANS(UI_TEXT_STEPPER_INACTIVE_FR);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_FR);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_FR);
TRANS(UI_TEXT_POWER_INACTIVE_FR);
TRANS(UI_TEXT_POWER_INACTIVE2A_FR);
TRANS(UI_TEXT_POWER_INACTIVE2B_FR);
TRANS(UI_TEXT_GENERAL_FR);
TRANS(UI_TEXT_BAUDRATE_FR);
TRANS(UI_TEXT_EXTR_STEPS_FR);
TRANS(UI_TEXT_EXTR_START_FEED_FR);
TRANS(UI_TEXT_EXTR_MAX_FEED_FR);
TRANS(UI_TEXT_EXTR_ACCEL_FR);
TRANS(UI_TEXT_EXTR_WATCH_FR);
TRANS(UI_TEXT_EXTR_ADVANCE_L_FR);
TRANS(UI_TEXT_EXTR_ADVANCE_K_FR);
TRANS(UI_TEXT_EXTR_MANAGER_FR);
TRANS(UI_TEXT_EXTR_PGAIN_FR);
TRANS(UI_TEXT_EXTR_DEADTIME_FR);
TRANS(UI_TEXT_EXTR_DMAX_DT_FR);
TRANS(UI_TEXT_EXTR_IGAIN_FR);
TRANS(UI_TEXT_EXTR_DGAIN_FR);
TRANS(UI_TEXT_EXTR_DMIN_FR);
TRANS(UI_TEXT_EXTR_DMAX_FR);
TRANS(UI_TEXT_EXTR_PMAX_FR);
TRANS(UI_TEXT_EXTR_XOFF_FR);
TRANS(UI_TEXT_EXTR_YOFF_FR);
TRANS(UI_TEXT_STRING_HM_BANGBANG_FR);
TRANS(UI_TEXT_STRING_HM_PID_FR);
TRANS(UI_TEXT_STRING_ACTION_FR);
TRANS(UI_TEXT_HEATING_EXTRUDER_FR);
TRANS(UI_TEXT_HEATING_BED_FR);
TRANS(UI_TEXT_KILLED_FR);
TRANS(UI_TEXT_STEPPER_DISABLED_FR);
TRANS(UI_TEXT_EEPROM_STOREDA_FR);
TRANS(UI_TEXT_EEPROM_STOREDB_FR);
TRANS(UI_TEXT_EEPROM_LOADEDA_FR);
TRANS(UI_TEXT_EEPROM_LOADEDB_FR);
TRANS(UI_TEXT_UPLOADING_FR);
TRANS(UI_TEXT_PAGE_BUFFER_FR);
TRANS(UI_TEXT_PAGE_EXTRUDER_FR);
TRANS(UI_TEXT_PAGE_EXTRUDER1_FR);
TRANS(UI_TEXT_PAGE_EXTRUDER2_FR);
TRANS(UI_TEXT_PAGE_EXTRUDER3_FR);
TRANS(UI_TEXT_PAGE_BED_FR);
TRANS(UI_TEXT_SPEED_MULTIPLY_FR);
TRANS(UI_TEXT_FLOW_MULTIPLY_FR);
TRANS(UI_TEXT_SHOW_MEASUREMENT_FR);
TRANS(UI_TEXT_RESET_MEASUREMENT_FR);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_FR);
TRANS(UI_TEXT_ZCALIB_FR);
TRANS(UI_TEXT_SET_P1_FR);
TRANS(UI_TEXT_SET_P2_FR);
TRANS(UI_TEXT_SET_P3_FR);
TRANS(UI_TEXT_CALCULATE_LEVELING_FR);
TRANS(UI_TEXT_LEVEL_FR);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_FR);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_FR);
TRANS(UI_TEXT_SD_REMOVED_FR);
TRANS(UI_TEXT_SD_INSERTED_FR);
TRANS(UI_TEXT_PRINTER_READY_FR);
TRANS(UI_TEXT_PRINTTIME_DAYS_FR);
TRANS(UI_TEXT_PRINTTIME_HOURS_FR);
TRANS(UI_TEXT_PRINTTIME_MINUTES_FR);
TRANS(UI_TEXT_PRINT_TIME_FR);
TRANS(UI_TEXT_PRINT_FILAMENT_FR);
TRANS(UI_TEXT_PRINTED_FR);
TRANS(UI_TEXT_POWER_FR);
TRANS(UI_TEXT_STRING_HM_DEADTIME_FR);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_FR);
TRANS(UI_TEXT_STOP_PRINT_FR);
TRANS(UI_TEXT_Z_BABYSTEPPING_FR);
TRANS(UI_TEXT_CHANGE_FILAMENT_FR);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_FR);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_FR);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_FR);
TRANS(UI_TEXT_CLICK_DONE_FR);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_FR);
TRANS(UI_TEXT_SERVOPOS_FR);
TRANS(UI_TEXT_IGNORE_M106_FR);
TRANS(UI_TEXT_WIZ_REHEAT1_FR);
TRANS(UI_TEXT_WIZ_REHEAT2_FR);
TRANS(UI_TEXT_WIZ_WAITTEMP1_FR);
TRANS(UI_TEXT_WIZ_WAITTEMP2_FR);
TRANS(UI_TEXT_EXTRUDER_JAM_FR);
TRANS(UI_TEXT_STANDBY_FR);
TRANS(UI_TEXT_BED_COATING_FR);
TRANS(UI_TEXT_BED_COATING_SET1_FR);
TRANS(UI_TEXT_BED_COATING_SET2_FR);
TRANS(UI_TEXT_NOCOATING_FR);
TRANS(UI_TEXT_BUILDTAK_FR);
TRANS(UI_TEXT_KAPTON_FR);
TRANS(UI_TEXT_BLUETAPE_FR);
TRANS(UI_TEXT_PETTAPE_FR);
TRANS(UI_TEXT_GLUESTICK_FR);
TRANS(UI_TEXT_CUSTOM_FR);
TRANS(UI_TEXT_COATING_CUSTOM_FR);
TRANS(UI_TEXT_LANGUAGE_FR);
TRANS(UI_TEXT_MAINPAGE6_1_FR);
TRANS(UI_TEXT_MAINPAGE6_2_FR);
TRANS(UI_TEXT_MAINPAGE6_3_FR);
TRANS(UI_TEXT_MAINPAGE6_4_FR);
TRANS(UI_TEXT_MAINPAGE6_5_FR);
TRANS(UI_TEXT_MAINPAGE6_6_FR);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_FR);
TRANS(UI_TEXT_MAINPAGE_BED_FR);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_FR);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_FR);
TRANS(UI_TEXT_MAINPAGE_XY_FR);
TRANS(UI_TEXT_PRINT_TIME_VALUE_FR);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_FR);
TRANS(UI_TEXT_METER_PRINTED_FR);
TRANS(UI_TEXT_STATUS_FR);
TRANS(UI_TEXT_EMPTY_FR);
TRANS(UI_TEXT_TEMP_SET_FR);
TRANS(UI_TEXT_CURRENT_TEMP_FR);
TRANS(UI_TEXT_COATING_THICKNESS_FR);
TRANS(UI_TEXT_EXTR3_TEMP_FR);
TRANS(UI_TEXT_EXTR4_TEMP_FR);
TRANS(UI_TEXT_EXTR5_TEMP_FR);
TRANS(UI_TEXT_EXTR3_OFF_FR);
TRANS(UI_TEXT_EXTR4_OFF_FR);
TRANS(UI_TEXT_EXTR5_OFF_FR);
TRANS(UI_TEXT_EXTR3_SELECT_FR);
TRANS(UI_TEXT_EXTR4_SELECT_FR);
TRANS(UI_TEXT_EXTR5_SELECT_FR);
TRANS(UI_TEXT_DITTO_0_FR);
TRANS(UI_TEXT_DITTO_1_FR);
TRANS(UI_TEXT_DITTO_2_FR);
TRANS(UI_TEXT_DITTO_3_FR);
TRANS(UI_TEXT_ZPROBE_HEIGHT_FR);
TRANS(UI_TEXT_OFFSETS_FR);
TRANS(UI_TEXT_X_OFFSET_FR);
TRANS(UI_TEXT_Y_OFFSET_FR);
TRANS(UI_TEXT_Z_OFFSET_FR);

PGM_P const translations_fr[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_FR,
 FUI_TEXT_OFF_FR,
 FUI_TEXT_NA_FR,
 FUI_TEXT_YES_FR,
 FUI_TEXT_NO_FR,
 FUI_TEXT_PRINT_POS_FR,
 FUI_TEXT_PRINTING_FR,
 FUI_TEXT_IDLE_FR,
 FUI_TEXT_NOSDCARD_FR,
 FUI_TEXT_ERROR_FR,
 FUI_TEXT_BACK_FR,
 FUI_TEXT_QUICK_SETTINGS_FR,
 FUI_TEXT_ERRORMSG_FR,
 FUI_TEXT_CONFIGURATION_FR,
 FUI_TEXT_POSITION_FR,
 FUI_TEXT_EXTRUDER_FR,
 FUI_TEXT_SD_CARD_FR,
 FUI_TEXT_DEBUGGING_FR,
 FUI_TEXT_HOME_DELTA_FR,
 FUI_TEXT_HOME_ALL_FR,
 FUI_TEXT_HOME_X_FR,
 FUI_TEXT_HOME_Y_FR,
 FUI_TEXT_HOME_Z_FR,
 FUI_TEXT_PREHEAT_PLA_FR,
 FUI_TEXT_PREHEAT_ABS_FR,
 FUI_TEXT_LIGHTS_ONOFF_FR,
 FUI_TEXT_COOLDOWN_FR,
 FUI_TEXT_SET_TO_ORIGIN_FR,
 FUI_TEXT_DISABLE_STEPPER_FR,
 FUI_TEXT_X_POSITION_FR,
 FUI_TEXT_X_POS_FAST_FR,
 FUI_TEXT_Y_POSITION_FR,
 FUI_TEXT_Y_POS_FAST_FR,
 FUI_TEXT_Z_POSITION_FR,
 FUI_TEXT_Z_POS_FAST_FR,
 FUI_TEXT_E_POSITION_FR,
 FUI_TEXT_BED_TEMP_FR,
 FUI_TEXT_EXTR0_TEMP_FR,
 FUI_TEXT_EXTR1_TEMP_FR,
 FUI_TEXT_EXTR2_TEMP_FR,
 FUI_TEXT_EXTR0_OFF_FR,
 FUI_TEXT_EXTR1_OFF_FR,
 FUI_TEXT_EXTR2_OFF_FR,
 FUI_TEXT_EXTR0_SELECT_FR,
 FUI_TEXT_EXTR1_SELECT_FR,
 FUI_TEXT_EXTR2_SELECT_FR,
 FUI_TEXT_EXTR_ORIGIN_FR,
 FUI_TEXT_PRINT_X_FR,
 FUI_TEXT_PRINT_Y_FR,
 FUI_TEXT_PRINT_Z_FR,
 FUI_TEXT_PRINT_Z_DELTA_FR,
 FUI_TEXT_MOVE_X_FR,
 FUI_TEXT_MOVE_Y_FR,
 FUI_TEXT_MOVE_Z_FR,
 FUI_TEXT_MOVE_Z_DELTA_FR,
 FUI_TEXT_JERK_FR,
 FUI_TEXT_ZJERK_FR,
 FUI_TEXT_ACCELERATION_FR,
 FUI_TEXT_STORE_TO_EEPROM_FR,
 FUI_TEXT_LOAD_EEPROM_FR,
 FUI_TEXT_DBG_ECHO_FR,
 FUI_TEXT_DBG_INFO_FR,
 FUI_TEXT_DBG_ERROR_FR,
 FUI_TEXT_DBG_DRYRUN_FR,
 FUI_TEXT_OPS_OFF_FR,
 FUI_TEXT_OPS_CLASSIC_FR,
 FUI_TEXT_OPS_FAST_FR,
 FUI_TEXT_OPS_RETRACT_FR,
 FUI_TEXT_OPS_BACKSLASH_FR,
 FUI_TEXT_OPS_MINDIST_FR,
 FUI_TEXT_OPS_MOVE_AFTER_FR,
 FUI_TEXT_ANTI_OOZE_FR,
 FUI_TEXT_PRINT_FILE_FR,
 FUI_TEXT_PAUSE_PRINT_FR,
 FUI_TEXT_CONTINUE_PRINT_FR,
 FUI_TEXT_UNMOUNT_CARD_FR,
 FUI_TEXT_MOUNT_CARD_FR,
 FUI_TEXT_DELETE_FILE_FR,
 FUI_TEXT_FEEDRATE_FR,
 FUI_TEXT_FEED_MAX_X_FR,
 FUI_TEXT_FEED_MAX_Y_FR,
 FUI_TEXT_FEED_MAX_Z_FR,
 FUI_TEXT_FEED_MAX_Z_DELTA_FR,
 FUI_TEXT_FEED_HOME_X_FR,
 FUI_TEXT_FEED_HOME_Y_FR,
 FUI_TEXT_FEED_HOME_Z_FR,
 FUI_TEXT_FEED_HOME_Z_DELTA_FR,
 FUI_TEXT_ACTION_XPOSITION4A_FR,
 FUI_TEXT_ACTION_XPOSITION4B_FR,
 FUI_TEXT_ACTION_XPOSITION4C_FR,
 FUI_TEXT_ACTION_XPOSITION4D_FR,
 FUI_TEXT_ACTION_YPOSITION4A_FR,
 FUI_TEXT_ACTION_YPOSITION4B_FR,
 FUI_TEXT_ACTION_YPOSITION4C_FR,
 FUI_TEXT_ACTION_YPOSITION4D_FR,
 FUI_TEXT_ACTION_ZPOSITION4A_FR,
 FUI_TEXT_ACTION_ZPOSITION4B_FR,
 FUI_TEXT_ACTION_ZPOSITION4C_FR,
 FUI_TEXT_ACTION_ZPOSITION4D_FR,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_FR,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_FR,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_FR,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_FR,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_FR,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_FR,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_FR,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_FR,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_FR,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_FR,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_FR,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_FR,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_FR,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_FR,
 FUI_TEXT_ACTION_XPOSITION2A_FR,
 FUI_TEXT_ACTION_XPOSITION2B_FR,
 FUI_TEXT_ACTION_YPOSITION2A_FR,
 FUI_TEXT_ACTION_YPOSITION2B_FR,
 FUI_TEXT_ACTION_ZPOSITION2A_FR,
 FUI_TEXT_ACTION_ZPOSITION2B_FR,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_FR,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_FR,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_FR,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_FR,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_FR,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_FR,
 FUI_TEXT_FANSPEED_FR,
 FUI_TEXT_ACTION_FANSPEED_FR,
 FUI_TEXT_FAN_OFF_FR,
 FUI_TEXT_FAN_25_FR,
 FUI_TEXT_FAN_50_FR,
 FUI_TEXT_FAN_75_FR,
 FUI_TEXT_FAN_FULL_FR,
 FUI_TEXT_STEPPER_INACTIVE_FR,
 FUI_TEXT_STEPPER_INACTIVE2A_FR,
 FUI_TEXT_STEPPER_INACTIVE2B_FR,
 FUI_TEXT_POWER_INACTIVE_FR,
 FUI_TEXT_POWER_INACTIVE2A_FR,
 FUI_TEXT_POWER_INACTIVE2B_FR,
 FUI_TEXT_GENERAL_FR,
 FUI_TEXT_BAUDRATE_FR,
 FUI_TEXT_EXTR_STEPS_FR,
 FUI_TEXT_EXTR_START_FEED_FR,
 FUI_TEXT_EXTR_MAX_FEED_FR,
 FUI_TEXT_EXTR_ACCEL_FR,
 FUI_TEXT_EXTR_WATCH_FR,
 FUI_TEXT_EXTR_ADVANCE_L_FR,
 FUI_TEXT_EXTR_ADVANCE_K_FR,
 FUI_TEXT_EXTR_MANAGER_FR,
 FUI_TEXT_EXTR_PGAIN_FR,
 FUI_TEXT_EXTR_DEADTIME_FR,
 FUI_TEXT_EXTR_DMAX_DT_FR,
 FUI_TEXT_EXTR_IGAIN_FR,
 FUI_TEXT_EXTR_DGAIN_FR,
 FUI_TEXT_EXTR_DMIN_FR,
 FUI_TEXT_EXTR_DMAX_FR,
 FUI_TEXT_EXTR_PMAX_FR,
 FUI_TEXT_EXTR_XOFF_FR,
 FUI_TEXT_EXTR_YOFF_FR,
 FUI_TEXT_STRING_HM_BANGBANG_FR,
 FUI_TEXT_STRING_HM_PID_FR,
 FUI_TEXT_STRING_ACTION_FR,
 FUI_TEXT_HEATING_EXTRUDER_FR,
 FUI_TEXT_HEATING_BED_FR,
 FUI_TEXT_KILLED_FR,
 FUI_TEXT_STEPPER_DISABLED_FR,
 FUI_TEXT_EEPROM_STOREDA_FR,
 FUI_TEXT_EEPROM_STOREDB_FR,
 FUI_TEXT_EEPROM_LOADEDA_FR,
 FUI_TEXT_EEPROM_LOADEDB_FR,
 FUI_TEXT_UPLOADING_FR,
 FUI_TEXT_PAGE_BUFFER_FR,
 FUI_TEXT_PAGE_EXTRUDER_FR,
 FUI_TEXT_PAGE_EXTRUDER1_FR,
 FUI_TEXT_PAGE_EXTRUDER2_FR,
 FUI_TEXT_PAGE_EXTRUDER3_FR,
 FUI_TEXT_PAGE_BED_FR,
 FUI_TEXT_SPEED_MULTIPLY_FR,
 FUI_TEXT_FLOW_MULTIPLY_FR,
 FUI_TEXT_SHOW_MEASUREMENT_FR,
 FUI_TEXT_RESET_MEASUREMENT_FR,
 FUI_TEXT_SET_MEASURED_ORIGIN_FR,
 FUI_TEXT_ZCALIB_FR,
 FUI_TEXT_SET_P1_FR,
 FUI_TEXT_SET_P2_FR,
 FUI_TEXT_SET_P3_FR,
 FUI_TEXT_CALCULATE_LEVELING_FR,
 FUI_TEXT_LEVEL_FR,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_FR,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_FR,
 FUI_TEXT_SD_REMOVED_FR,
 FUI_TEXT_SD_INSERTED_FR,
 FUI_TEXT_PRINTER_READY_FR,
 FUI_TEXT_PRINTTIME_DAYS_FR,
 FUI_TEXT_PRINTTIME_HOURS_FR,
 FUI_TEXT_PRINTTIME_MINUTES_FR,
 FUI_TEXT_PRINT_TIME_FR,
 FUI_TEXT_PRINT_FILAMENT_FR,
 FUI_TEXT_PRINTED_FR,
 FUI_TEXT_POWER_FR,
 FUI_TEXT_STRING_HM_DEADTIME_FR,
 FUI_TEXT_STRING_HM_SLOWBANG_FR,
 FUI_TEXT_STOP_PRINT_FR,
 FUI_TEXT_Z_BABYSTEPPING_FR,
 FUI_TEXT_CHANGE_FILAMENT_FR,
 FUI_TEXT_WIZ_CH_FILAMENT1_FR,
 FUI_TEXT_WIZ_CH_FILAMENT2_FR,
 FUI_TEXT_WIZ_CH_FILAMENT3_FR,
 FUI_TEXT_CLICK_DONE_FR,
 FUI_TEXT_AUTOLEVEL_ONOFF_FR,
 FUI_TEXT_SERVOPOS_FR,
 FUI_TEXT_IGNORE_M106_FR,
 FUI_TEXT_WIZ_REHEAT1_FR,
 FUI_TEXT_WIZ_REHEAT2_FR,
 FUI_TEXT_WIZ_WAITTEMP1_FR,
 FUI_TEXT_WIZ_WAITTEMP2_FR,
 FUI_TEXT_EXTRUDER_JAM_FR,
 FUI_TEXT_STANDBY_FR,
 FUI_TEXT_BED_COATING_FR,
 FUI_TEXT_BED_COATING_SET1_FR,
 FUI_TEXT_BED_COATING_SET2_FR,
 FUI_TEXT_NOCOATING_FR,
 FUI_TEXT_BUILDTAK_FR,
 FUI_TEXT_KAPTON_FR,
 FUI_TEXT_BLUETAPE_FR,
 FUI_TEXT_PETTAPE_FR,
 FUI_TEXT_GLUESTICK_FR,
 FUI_TEXT_CUSTOM_FR,
 FUI_TEXT_COATING_CUSTOM_FR,
 FUI_TEXT_LANGUAGE_FR,
 FUI_TEXT_MAINPAGE6_1_FR,
 FUI_TEXT_MAINPAGE6_2_FR,
 FUI_TEXT_MAINPAGE6_3_FR,
 FUI_TEXT_MAINPAGE6_4_FR,
 FUI_TEXT_MAINPAGE6_5_FR,
 FUI_TEXT_MAINPAGE6_6_FR,
 FUI_TEXT_MAINPAGE_TEMP_BED_FR,
 FUI_TEXT_MAINPAGE_BED_FR,
 FUI_TEXT_MAINPAGE_Z_BUF_FR,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_FR,
 FUI_TEXT_MAINPAGE_XY_FR,
 FUI_TEXT_PRINT_TIME_VALUE_FR,
 FUI_TEXT_PRINT_FILAMENT_VALUE_FR,
 FUI_TEXT_METER_PRINTED_FR,
 FUI_TEXT_STATUS_FR,
 FUI_TEXT_EMPTY_FR,
 FUI_TEXT_TEMP_SET_FR,
 FUI_TEXT_CURRENT_TEMP_FR,
 FUI_TEXT_COATING_THICKNESS_FR,
 FUI_TEXT_EXTR3_TEMP_FR,
 FUI_TEXT_EXTR4_TEMP_FR,
 FUI_TEXT_EXTR5_TEMP_FR,
 FUI_TEXT_EXTR3_OFF_FR,
 FUI_TEXT_EXTR4_OFF_FR,
 FUI_TEXT_EXTR5_OFF_FR,
 FUI_TEXT_EXTR3_SELECT_FR,
 FUI_TEXT_EXTR4_SELECT_FR,
 FUI_TEXT_EXTR5_SELECT_FR,
 FUI_TEXT_DITTO_0_FR,
 FUI_TEXT_DITTO_1_FR,
 FUI_TEXT_DITTO_2_FR,
 FUI_TEXT_DITTO_3_FR,
 FUI_TEXT_ZPROBE_HEIGHT_FR,
 FUI_TEXT_OFFSETS_FR,
 FUI_TEXT_X_OFFSET_FR,
 FUI_TEXT_Y_OFFSET_FR,
 FUI_TEXT_Z_OFFSET_FR,
 FUI_TEXT_DBG_ENDSTOP_FR
};
#define LANG_FR_TABLE translations_fr
#else
#define LANG_FR_TABLE NULL
#endif // LANGUAGE_FR_ACTIVE


#if LANGUAGE_CZ_ACTIVE
TRANS(UI_TEXT_ON_CZ);
TRANS(UI_TEXT_OFF_CZ);
TRANS(UI_TEXT_NA_CZ);
TRANS(UI_TEXT_YES_CZ);
TRANS(UI_TEXT_NO_CZ);
TRANS(UI_TEXT_PRINT_POS_CZ);
TRANS(UI_TEXT_PRINTING_CZ);
TRANS(UI_TEXT_IDLE_CZ);
TRANS(UI_TEXT_NOSDCARD_CZ);
TRANS(UI_TEXT_ERROR_CZ);
TRANS(UI_TEXT_BACK_CZ);
TRANS(UI_TEXT_QUICK_SETTINGS_CZ);
TRANS(UI_TEXT_ERRORMSG_CZ);
TRANS(UI_TEXT_CONFIGURATION_CZ);
TRANS(UI_TEXT_POSITION_CZ);
TRANS(UI_TEXT_EXTRUDER_CZ);
TRANS(UI_TEXT_SD_CARD_CZ);
TRANS(UI_TEXT_DEBUGGING_CZ);
TRANS(UI_TEXT_HOME_DELTA_CZ);
TRANS(UI_TEXT_HOME_ALL_CZ);
TRANS(UI_TEXT_HOME_X_CZ);
TRANS(UI_TEXT_HOME_Y_CZ);
TRANS(UI_TEXT_HOME_Z_CZ);
TRANS(UI_TEXT_PREHEAT_PLA_CZ);
TRANS(UI_TEXT_PREHEAT_ABS_CZ);
TRANS(UI_TEXT_LIGHTS_ONOFF_CZ);
TRANS(UI_TEXT_COOLDOWN_CZ);
TRANS(UI_TEXT_SET_TO_ORIGIN_CZ);
TRANS(UI_TEXT_DISABLE_STEPPER_CZ);
TRANS(UI_TEXT_X_POSITION_CZ);
TRANS(UI_TEXT_X_POS_FAST_CZ);
TRANS(UI_TEXT_Y_POSITION_CZ);
TRANS(UI_TEXT_Y_POS_FAST_CZ);
TRANS(UI_TEXT_Z_POSITION_CZ);
TRANS(UI_TEXT_Z_POS_FAST_CZ);
TRANS(UI_TEXT_E_POSITION_CZ);
TRANS(UI_TEXT_BED_TEMP_CZ);
TRANS(UI_TEXT_EXTR0_TEMP_CZ);
TRANS(UI_TEXT_EXTR1_TEMP_CZ);
TRANS(UI_TEXT_EXTR2_TEMP_CZ);
TRANS(UI_TEXT_EXTR0_OFF_CZ);
TRANS(UI_TEXT_EXTR1_OFF_CZ);
TRANS(UI_TEXT_EXTR2_OFF_CZ);
TRANS(UI_TEXT_EXTR0_SELECT_CZ);
TRANS(UI_TEXT_EXTR1_SELECT_CZ);
TRANS(UI_TEXT_EXTR2_SELECT_CZ);
TRANS(UI_TEXT_EXTR_ORIGIN_CZ);
TRANS(UI_TEXT_PRINT_X_CZ);
TRANS(UI_TEXT_PRINT_Y_CZ);
TRANS(UI_TEXT_PRINT_Z_CZ);
TRANS(UI_TEXT_PRINT_Z_DELTA_CZ);
TRANS(UI_TEXT_MOVE_X_CZ);
TRANS(UI_TEXT_MOVE_Y_CZ);
TRANS(UI_TEXT_MOVE_Z_CZ);
TRANS(UI_TEXT_MOVE_Z_DELTA_CZ);
TRANS(UI_TEXT_JERK_CZ);
TRANS(UI_TEXT_ZJERK_CZ);
TRANS(UI_TEXT_ACCELERATION_CZ);
TRANS(UI_TEXT_STORE_TO_EEPROM_CZ);
TRANS(UI_TEXT_LOAD_EEPROM_CZ);
TRANS(UI_TEXT_DBG_ECHO_CZ);
TRANS(UI_TEXT_DBG_INFO_CZ);
TRANS(UI_TEXT_DBG_ERROR_CZ);
TRANS(UI_TEXT_DBG_DRYRUN_CZ);
TRANS(UI_TEXT_DBG_ENDSTOP_CZ);
TRANS(UI_TEXT_OPS_OFF_CZ);
TRANS(UI_TEXT_OPS_CLASSIC_CZ);
TRANS(UI_TEXT_OPS_FAST_CZ);
TRANS(UI_TEXT_OPS_RETRACT_CZ);
TRANS(UI_TEXT_OPS_BACKSLASH_CZ);
TRANS(UI_TEXT_OPS_MINDIST_CZ);
TRANS(UI_TEXT_OPS_MOVE_AFTER_CZ);
TRANS(UI_TEXT_ANTI_OOZE_CZ);
TRANS(UI_TEXT_PRINT_FILE_CZ);
TRANS(UI_TEXT_PAUSE_PRINT_CZ);
TRANS(UI_TEXT_CONTINUE_PRINT_CZ);
TRANS(UI_TEXT_UNMOUNT_CARD_CZ);
TRANS(UI_TEXT_MOUNT_CARD_CZ);
TRANS(UI_TEXT_DELETE_FILE_CZ);
TRANS(UI_TEXT_FEEDRATE_CZ);
TRANS(UI_TEXT_FEED_MAX_X_CZ);
TRANS(UI_TEXT_FEED_MAX_Y_CZ);
TRANS(UI_TEXT_FEED_MAX_Z_CZ);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_CZ);
TRANS(UI_TEXT_FEED_HOME_X_CZ);
TRANS(UI_TEXT_FEED_HOME_Y_CZ);
TRANS(UI_TEXT_FEED_HOME_Z_CZ);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION4A_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION4B_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION4C_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION4D_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION4A_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION4B_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION4C_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION4D_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_CZ);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_CZ);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION2A_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION2B_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION2A_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION2B_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_CZ);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_CZ);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_CZ);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_CZ);
TRANS(UI_TEXT_FANSPEED_CZ);
TRANS(UI_TEXT_ACTION_FANSPEED_CZ);
TRANS(UI_TEXT_FAN_OFF_CZ);
TRANS(UI_TEXT_FAN_25_CZ);
TRANS(UI_TEXT_FAN_50_CZ);
TRANS(UI_TEXT_FAN_75_CZ);
TRANS(UI_TEXT_FAN_FULL_CZ);
TRANS(UI_TEXT_STEPPER_INACTIVE_CZ);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_CZ);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_CZ);
TRANS(UI_TEXT_POWER_INACTIVE_CZ);
TRANS(UI_TEXT_POWER_INACTIVE2A_CZ);
TRANS(UI_TEXT_POWER_INACTIVE2B_CZ);
TRANS(UI_TEXT_GENERAL_CZ);
TRANS(UI_TEXT_BAUDRATE_CZ);
TRANS(UI_TEXT_EXTR_STEPS_CZ);
TRANS(UI_TEXT_EXTR_START_FEED_CZ);
TRANS(UI_TEXT_EXTR_MAX_FEED_CZ);
TRANS(UI_TEXT_EXTR_ACCEL_CZ);
TRANS(UI_TEXT_EXTR_WATCH_CZ);
TRANS(UI_TEXT_EXTR_ADVANCE_L_CZ);
TRANS(UI_TEXT_EXTR_ADVANCE_K_CZ);
TRANS(UI_TEXT_EXTR_MANAGER_CZ);
TRANS(UI_TEXT_EXTR_PGAIN_CZ);
TRANS(UI_TEXT_EXTR_DEADTIME_CZ);
TRANS(UI_TEXT_EXTR_DMAX_DT_CZ);
TRANS(UI_TEXT_EXTR_IGAIN_CZ);
TRANS(UI_TEXT_EXTR_DGAIN_CZ);
TRANS(UI_TEXT_EXTR_DMIN_CZ);
TRANS(UI_TEXT_EXTR_DMAX_CZ);
TRANS(UI_TEXT_EXTR_PMAX_CZ);
TRANS(UI_TEXT_EXTR_XOFF_CZ);
TRANS(UI_TEXT_EXTR_YOFF_CZ);
TRANS(UI_TEXT_STRING_HM_BANGBANG_CZ);
TRANS(UI_TEXT_STRING_HM_PID_CZ);
TRANS(UI_TEXT_STRING_ACTION_CZ);
TRANS(UI_TEXT_HEATING_EXTRUDER_CZ);
TRANS(UI_TEXT_HEATING_BED_CZ);
TRANS(UI_TEXT_KILLED_CZ);
TRANS(UI_TEXT_STEPPER_DISABLED_CZ);
TRANS(UI_TEXT_EEPROM_STOREDA_CZ);
TRANS(UI_TEXT_EEPROM_STOREDB_CZ);
TRANS(UI_TEXT_EEPROM_LOADEDA_CZ);
TRANS(UI_TEXT_EEPROM_LOADEDB_CZ);
TRANS(UI_TEXT_UPLOADING_CZ);
TRANS(UI_TEXT_PAGE_BUFFER_CZ);
TRANS(UI_TEXT_PAGE_EXTRUDER_CZ);
TRANS(UI_TEXT_PAGE_EXTRUDER1_CZ);
TRANS(UI_TEXT_PAGE_EXTRUDER2_CZ);
TRANS(UI_TEXT_PAGE_EXTRUDER3_CZ);
TRANS(UI_TEXT_PAGE_BED_CZ);
TRANS(UI_TEXT_SPEED_MULTIPLY_CZ);
TRANS(UI_TEXT_FLOW_MULTIPLY_CZ);
TRANS(UI_TEXT_SHOW_MEASUREMENT_CZ);
TRANS(UI_TEXT_RESET_MEASUREMENT_CZ);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_CZ);
TRANS(UI_TEXT_ZCALIB_CZ);
TRANS(UI_TEXT_SET_P1_CZ);
TRANS(UI_TEXT_SET_P2_CZ);
TRANS(UI_TEXT_SET_P3_CZ);
TRANS(UI_TEXT_CALCULATE_LEVELING_CZ);
TRANS(UI_TEXT_LEVEL_CZ);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_CZ);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_CZ);
TRANS(UI_TEXT_SD_REMOVED_CZ);
TRANS(UI_TEXT_SD_INSERTED_CZ);
TRANS(UI_TEXT_PRINTER_READY_CZ);
TRANS(UI_TEXT_PRINTTIME_DAYS_CZ);
TRANS(UI_TEXT_PRINTTIME_HOURS_CZ);
TRANS(UI_TEXT_PRINTTIME_MINUTES_CZ);
TRANS(UI_TEXT_PRINT_TIME_CZ);
TRANS(UI_TEXT_PRINT_FILAMENT_CZ);
TRANS(UI_TEXT_PRINTED_CZ);
TRANS(UI_TEXT_POWER_CZ);
TRANS(UI_TEXT_STRING_HM_DEADTIME_CZ);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_CZ);
TRANS(UI_TEXT_STOP_PRINT_CZ);
TRANS(UI_TEXT_Z_BABYSTEPPING_CZ);
TRANS(UI_TEXT_CHANGE_FILAMENT_CZ);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_CZ);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_CZ);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_CZ);
TRANS(UI_TEXT_CLICK_DONE_CZ);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_CZ);
TRANS(UI_TEXT_SERVOPOS_CZ);
TRANS(UI_TEXT_IGNORE_M106_CZ);
TRANS(UI_TEXT_WIZ_REHEAT1_CZ);
TRANS(UI_TEXT_WIZ_REHEAT2_CZ);
TRANS(UI_TEXT_WIZ_WAITTEMP1_CZ);
TRANS(UI_TEXT_WIZ_WAITTEMP2_CZ);
TRANS(UI_TEXT_EXTRUDER_JAM_CZ);
TRANS(UI_TEXT_STANDBY_CZ);
TRANS(UI_TEXT_BED_COATING_CZ);
TRANS(UI_TEXT_BED_COATING_SET1_CZ);
TRANS(UI_TEXT_BED_COATING_SET2_CZ);
TRANS(UI_TEXT_NOCOATING_CZ);
TRANS(UI_TEXT_BUILDTAK_CZ);
TRANS(UI_TEXT_KAPTON_CZ);
TRANS(UI_TEXT_BLUETAPE_CZ);
TRANS(UI_TEXT_PETTAPE_CZ);
TRANS(UI_TEXT_GLUESTICK_CZ);
TRANS(UI_TEXT_CUSTOM_CZ);
TRANS(UI_TEXT_COATING_CUSTOM_CZ);
TRANS(UI_TEXT_LANGUAGE_CZ);
TRANS(UI_TEXT_MAINPAGE6_1_CZ);
TRANS(UI_TEXT_MAINPAGE6_2_CZ);
TRANS(UI_TEXT_MAINPAGE6_3_CZ);
TRANS(UI_TEXT_MAINPAGE6_4_CZ);
TRANS(UI_TEXT_MAINPAGE6_5_CZ);
TRANS(UI_TEXT_MAINPAGE6_6_CZ);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_CZ);
TRANS(UI_TEXT_MAINPAGE_BED_CZ);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_CZ);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_CZ);
TRANS(UI_TEXT_MAINPAGE_XY_CZ);
TRANS(UI_TEXT_PRINT_TIME_VALUE_CZ);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_CZ);
TRANS(UI_TEXT_METER_PRINTED_CZ);
TRANS(UI_TEXT_STATUS_CZ);
TRANS(UI_TEXT_EMPTY_CZ);
TRANS(UI_TEXT_TEMP_SET_CZ);
TRANS(UI_TEXT_CURRENT_TEMP_CZ);
TRANS(UI_TEXT_COATING_THICKNESS_CZ);
TRANS(UI_TEXT_EXTR3_TEMP_CZ);
TRANS(UI_TEXT_EXTR4_TEMP_CZ);
TRANS(UI_TEXT_EXTR5_TEMP_CZ);
TRANS(UI_TEXT_EXTR3_OFF_CZ);
TRANS(UI_TEXT_EXTR4_OFF_CZ);
TRANS(UI_TEXT_EXTR5_OFF_CZ);
TRANS(UI_TEXT_EXTR3_SELECT_CZ);
TRANS(UI_TEXT_EXTR4_SELECT_CZ);
TRANS(UI_TEXT_EXTR5_SELECT_CZ);
TRANS(UI_TEXT_DITTO_0_CZ);
TRANS(UI_TEXT_DITTO_1_CZ);
TRANS(UI_TEXT_DITTO_2_CZ);
TRANS(UI_TEXT_DITTO_3_CZ);
TRANS(UI_TEXT_ZPROBE_HEIGHT_CZ);
TRANS(UI_TEXT_OFFSETS_CZ);
TRANS(UI_TEXT_X_OFFSET_CZ);
TRANS(UI_TEXT_Y_OFFSET_CZ);
TRANS(UI_TEXT_Z_OFFSET_CZ);

PGM_P const translations_cz[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_CZ,
 FUI_TEXT_OFF_CZ,
 FUI_TEXT_NA_CZ,
 FUI_TEXT_YES_CZ,
 FUI_TEXT_NO_CZ,
 FUI_TEXT_PRINT_POS_CZ,
 FUI_TEXT_PRINTING_CZ,
 FUI_TEXT_IDLE_CZ,
 FUI_TEXT_NOSDCARD_CZ,
 FUI_TEXT_ERROR_CZ,
 FUI_TEXT_BACK_CZ,
 FUI_TEXT_QUICK_SETTINGS_CZ,
 FUI_TEXT_ERRORMSG_CZ,
 FUI_TEXT_CONFIGURATION_CZ,
 FUI_TEXT_POSITION_CZ,
 FUI_TEXT_EXTRUDER_CZ,
 FUI_TEXT_SD_CARD_CZ,
 FUI_TEXT_DEBUGGING_CZ,
 FUI_TEXT_HOME_DELTA_CZ,
 FUI_TEXT_HOME_ALL_CZ,
 FUI_TEXT_HOME_X_CZ,
 FUI_TEXT_HOME_Y_CZ,
 FUI_TEXT_HOME_Z_CZ,
 FUI_TEXT_PREHEAT_PLA_CZ,
 FUI_TEXT_PREHEAT_ABS_CZ,
 FUI_TEXT_LIGHTS_ONOFF_CZ,
 FUI_TEXT_COOLDOWN_CZ,
 FUI_TEXT_SET_TO_ORIGIN_CZ,
 FUI_TEXT_DISABLE_STEPPER_CZ,
 FUI_TEXT_X_POSITION_CZ,
 FUI_TEXT_X_POS_FAST_CZ,
 FUI_TEXT_Y_POSITION_CZ,
 FUI_TEXT_Y_POS_FAST_CZ,
 FUI_TEXT_Z_POSITION_CZ,
 FUI_TEXT_Z_POS_FAST_CZ,
 FUI_TEXT_E_POSITION_CZ,
 FUI_TEXT_BED_TEMP_CZ,
 FUI_TEXT_EXTR0_TEMP_CZ,
 FUI_TEXT_EXTR1_TEMP_CZ,
 FUI_TEXT_EXTR2_TEMP_CZ,
 FUI_TEXT_EXTR0_OFF_CZ,
 FUI_TEXT_EXTR1_OFF_CZ,
 FUI_TEXT_EXTR2_OFF_CZ,
 FUI_TEXT_EXTR0_SELECT_CZ,
 FUI_TEXT_EXTR1_SELECT_CZ,
 FUI_TEXT_EXTR2_SELECT_CZ,
 FUI_TEXT_EXTR_ORIGIN_CZ,
 FUI_TEXT_PRINT_X_CZ,
 FUI_TEXT_PRINT_Y_CZ,
 FUI_TEXT_PRINT_Z_CZ,
 FUI_TEXT_PRINT_Z_DELTA_CZ,
 FUI_TEXT_MOVE_X_CZ,
 FUI_TEXT_MOVE_Y_CZ,
 FUI_TEXT_MOVE_Z_CZ,
 FUI_TEXT_MOVE_Z_DELTA_CZ,
 FUI_TEXT_JERK_CZ,
 FUI_TEXT_ZJERK_CZ,
 FUI_TEXT_ACCELERATION_CZ,
 FUI_TEXT_STORE_TO_EEPROM_CZ,
 FUI_TEXT_LOAD_EEPROM_CZ,
 FUI_TEXT_DBG_ECHO_CZ,
 FUI_TEXT_DBG_INFO_CZ,
 FUI_TEXT_DBG_ERROR_CZ,
 FUI_TEXT_DBG_DRYRUN_CZ,
 FUI_TEXT_OPS_OFF_CZ,
 FUI_TEXT_OPS_CLASSIC_CZ,
 FUI_TEXT_OPS_FAST_CZ,
 FUI_TEXT_OPS_RETRACT_CZ,
 FUI_TEXT_OPS_BACKSLASH_CZ,
 FUI_TEXT_OPS_MINDIST_CZ,
 FUI_TEXT_OPS_MOVE_AFTER_CZ,
 FUI_TEXT_ANTI_OOZE_CZ,
 FUI_TEXT_PRINT_FILE_CZ,
 FUI_TEXT_PAUSE_PRINT_CZ,
 FUI_TEXT_CONTINUE_PRINT_CZ,
 FUI_TEXT_UNMOUNT_CARD_CZ,
 FUI_TEXT_MOUNT_CARD_CZ,
 FUI_TEXT_DELETE_FILE_CZ,
 FUI_TEXT_FEEDRATE_CZ,
 FUI_TEXT_FEED_MAX_X_CZ,
 FUI_TEXT_FEED_MAX_Y_CZ,
 FUI_TEXT_FEED_MAX_Z_CZ,
 FUI_TEXT_FEED_MAX_Z_DELTA_CZ,
 FUI_TEXT_FEED_HOME_X_CZ,
 FUI_TEXT_FEED_HOME_Y_CZ,
 FUI_TEXT_FEED_HOME_Z_CZ,
 FUI_TEXT_FEED_HOME_Z_DELTA_CZ,
 FUI_TEXT_ACTION_XPOSITION4A_CZ,
 FUI_TEXT_ACTION_XPOSITION4B_CZ,
 FUI_TEXT_ACTION_XPOSITION4C_CZ,
 FUI_TEXT_ACTION_XPOSITION4D_CZ,
 FUI_TEXT_ACTION_YPOSITION4A_CZ,
 FUI_TEXT_ACTION_YPOSITION4B_CZ,
 FUI_TEXT_ACTION_YPOSITION4C_CZ,
 FUI_TEXT_ACTION_YPOSITION4D_CZ,
 FUI_TEXT_ACTION_ZPOSITION4A_CZ,
 FUI_TEXT_ACTION_ZPOSITION4B_CZ,
 FUI_TEXT_ACTION_ZPOSITION4C_CZ,
 FUI_TEXT_ACTION_ZPOSITION4D_CZ,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_CZ,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_CZ,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_CZ,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_CZ,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_CZ,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_CZ,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_CZ,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_CZ,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_CZ,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_CZ,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_CZ,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_CZ,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_CZ,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_CZ,
 FUI_TEXT_ACTION_XPOSITION2A_CZ,
 FUI_TEXT_ACTION_XPOSITION2B_CZ,
 FUI_TEXT_ACTION_YPOSITION2A_CZ,
 FUI_TEXT_ACTION_YPOSITION2B_CZ,
 FUI_TEXT_ACTION_ZPOSITION2A_CZ,
 FUI_TEXT_ACTION_ZPOSITION2B_CZ,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_CZ,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_CZ,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_CZ,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_CZ,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_CZ,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_CZ,
 FUI_TEXT_FANSPEED_CZ,
 FUI_TEXT_ACTION_FANSPEED_CZ,
 FUI_TEXT_FAN_OFF_CZ,
 FUI_TEXT_FAN_25_CZ,
 FUI_TEXT_FAN_50_CZ,
 FUI_TEXT_FAN_75_CZ,
 FUI_TEXT_FAN_FULL_CZ,
 FUI_TEXT_STEPPER_INACTIVE_CZ,
 FUI_TEXT_STEPPER_INACTIVE2A_CZ,
 FUI_TEXT_STEPPER_INACTIVE2B_CZ,
 FUI_TEXT_POWER_INACTIVE_CZ,
 FUI_TEXT_POWER_INACTIVE2A_CZ,
 FUI_TEXT_POWER_INACTIVE2B_CZ,
 FUI_TEXT_GENERAL_CZ,
 FUI_TEXT_BAUDRATE_CZ,
 FUI_TEXT_EXTR_STEPS_CZ,
 FUI_TEXT_EXTR_START_FEED_CZ,
 FUI_TEXT_EXTR_MAX_FEED_CZ,
 FUI_TEXT_EXTR_ACCEL_CZ,
 FUI_TEXT_EXTR_WATCH_CZ,
 FUI_TEXT_EXTR_ADVANCE_L_CZ,
 FUI_TEXT_EXTR_ADVANCE_K_CZ,
 FUI_TEXT_EXTR_MANAGER_CZ,
 FUI_TEXT_EXTR_PGAIN_CZ,
 FUI_TEXT_EXTR_DEADTIME_CZ,
 FUI_TEXT_EXTR_DMAX_DT_CZ,
 FUI_TEXT_EXTR_IGAIN_CZ,
 FUI_TEXT_EXTR_DGAIN_CZ,
 FUI_TEXT_EXTR_DMIN_CZ,
 FUI_TEXT_EXTR_DMAX_CZ,
 FUI_TEXT_EXTR_PMAX_CZ,
 FUI_TEXT_EXTR_XOFF_CZ,
 FUI_TEXT_EXTR_YOFF_CZ,
 FUI_TEXT_STRING_HM_BANGBANG_CZ,
 FUI_TEXT_STRING_HM_PID_CZ,
 FUI_TEXT_STRING_ACTION_CZ,
 FUI_TEXT_HEATING_EXTRUDER_CZ,
 FUI_TEXT_HEATING_BED_CZ,
 FUI_TEXT_KILLED_CZ,
 FUI_TEXT_STEPPER_DISABLED_CZ,
 FUI_TEXT_EEPROM_STOREDA_CZ,
 FUI_TEXT_EEPROM_STOREDB_CZ,
 FUI_TEXT_EEPROM_LOADEDA_CZ,
 FUI_TEXT_EEPROM_LOADEDB_CZ,
 FUI_TEXT_UPLOADING_CZ,
 FUI_TEXT_PAGE_BUFFER_CZ,
 FUI_TEXT_PAGE_EXTRUDER_CZ,
 FUI_TEXT_PAGE_EXTRUDER1_CZ,
 FUI_TEXT_PAGE_EXTRUDER2_CZ,
 FUI_TEXT_PAGE_EXTRUDER3_CZ,
 FUI_TEXT_PAGE_BED_CZ,
 FUI_TEXT_SPEED_MULTIPLY_CZ,
 FUI_TEXT_FLOW_MULTIPLY_CZ,
 FUI_TEXT_SHOW_MEASUREMENT_CZ,
 FUI_TEXT_RESET_MEASUREMENT_CZ,
 FUI_TEXT_SET_MEASURED_ORIGIN_CZ,
 FUI_TEXT_ZCALIB_CZ,
 FUI_TEXT_SET_P1_CZ,
 FUI_TEXT_SET_P2_CZ,
 FUI_TEXT_SET_P3_CZ,
 FUI_TEXT_CALCULATE_LEVELING_CZ,
 FUI_TEXT_LEVEL_CZ,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_CZ,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_CZ,
 FUI_TEXT_SD_REMOVED_CZ,
 FUI_TEXT_SD_INSERTED_CZ,
 FUI_TEXT_PRINTER_READY_CZ,
 FUI_TEXT_PRINTTIME_DAYS_CZ,
 FUI_TEXT_PRINTTIME_HOURS_CZ,
 FUI_TEXT_PRINTTIME_MINUTES_CZ,
 FUI_TEXT_PRINT_TIME_CZ,
 FUI_TEXT_PRINT_FILAMENT_CZ,
 FUI_TEXT_PRINTED_CZ,
 FUI_TEXT_POWER_CZ,
 FUI_TEXT_STRING_HM_DEADTIME_CZ,
 FUI_TEXT_STRING_HM_SLOWBANG_CZ,
 FUI_TEXT_STOP_PRINT_CZ,
 FUI_TEXT_Z_BABYSTEPPING_CZ,
 FUI_TEXT_CHANGE_FILAMENT_CZ,
 FUI_TEXT_WIZ_CH_FILAMENT1_CZ,
 FUI_TEXT_WIZ_CH_FILAMENT2_CZ,
 FUI_TEXT_WIZ_CH_FILAMENT3_CZ,
 FUI_TEXT_CLICK_DONE_CZ,
 FUI_TEXT_AUTOLEVEL_ONOFF_CZ,
 FUI_TEXT_SERVOPOS_CZ,
 FUI_TEXT_IGNORE_M106_CZ,
 FUI_TEXT_WIZ_REHEAT1_CZ,
 FUI_TEXT_WIZ_REHEAT2_CZ,
 FUI_TEXT_WIZ_WAITTEMP1_CZ,
 FUI_TEXT_WIZ_WAITTEMP2_CZ,
 FUI_TEXT_EXTRUDER_JAM_CZ,
 FUI_TEXT_STANDBY_CZ,
 FUI_TEXT_BED_COATING_CZ,
 FUI_TEXT_BED_COATING_SET1_CZ,
 FUI_TEXT_BED_COATING_SET2_CZ,
 FUI_TEXT_NOCOATING_CZ,
 FUI_TEXT_BUILDTAK_CZ,
 FUI_TEXT_KAPTON_CZ,
 FUI_TEXT_BLUETAPE_CZ,
 FUI_TEXT_PETTAPE_CZ,
 FUI_TEXT_GLUESTICK_CZ,
 FUI_TEXT_CUSTOM_CZ,
 FUI_TEXT_COATING_CUSTOM_CZ,
 FUI_TEXT_LANGUAGE_CZ,
 FUI_TEXT_MAINPAGE6_1_CZ,
 FUI_TEXT_MAINPAGE6_2_CZ,
 FUI_TEXT_MAINPAGE6_3_CZ,
 FUI_TEXT_MAINPAGE6_4_CZ,
 FUI_TEXT_MAINPAGE6_5_CZ,
 FUI_TEXT_MAINPAGE6_6_CZ,
 FUI_TEXT_MAINPAGE_TEMP_BED_CZ,
 FUI_TEXT_MAINPAGE_BED_CZ,
 FUI_TEXT_MAINPAGE_Z_BUF_CZ,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_CZ,
 FUI_TEXT_MAINPAGE_XY_CZ,
 FUI_TEXT_PRINT_TIME_VALUE_CZ,
 FUI_TEXT_PRINT_FILAMENT_VALUE_CZ,
 FUI_TEXT_METER_PRINTED_CZ,
 FUI_TEXT_STATUS_CZ,
 FUI_TEXT_EMPTY_CZ,
 FUI_TEXT_TEMP_SET_CZ,
 FUI_TEXT_CURRENT_TEMP_CZ,
 FUI_TEXT_COATING_THICKNESS_CZ,
 FUI_TEXT_EXTR3_TEMP_CZ,
 FUI_TEXT_EXTR4_TEMP_CZ,
 FUI_TEXT_EXTR5_TEMP_CZ,
 FUI_TEXT_EXTR3_OFF_CZ,
 FUI_TEXT_EXTR4_OFF_CZ,
 FUI_TEXT_EXTR5_OFF_CZ,
 FUI_TEXT_EXTR3_SELECT_CZ,
 FUI_TEXT_EXTR4_SELECT_CZ,
 FUI_TEXT_EXTR5_SELECT_CZ,
 FUI_TEXT_DITTO_0_CZ,
 FUI_TEXT_DITTO_1_CZ,
 FUI_TEXT_DITTO_2_CZ,
 FUI_TEXT_DITTO_3_CZ,
 FUI_TEXT_ZPROBE_HEIGHT_CZ,
 FUI_TEXT_OFFSETS_CZ,
 FUI_TEXT_X_OFFSET_CZ,
 FUI_TEXT_Y_OFFSET_CZ,
 FUI_TEXT_Z_OFFSET_CZ,
 FUI_TEXT_DBG_ENDSTOP_CZ
};
#define LANG_CZ_TABLE translations_cz
#else
#define LANG_CZ_TABLE NULL
#endif // LANGUAGE_CZ_ACTIVE


#if LANGUAGE_PL_ACTIVE
TRANS(UI_TEXT_ON_PL);
TRANS(UI_TEXT_OFF_PL);
TRANS(UI_TEXT_NA_PL);
TRANS(UI_TEXT_YES_PL);
TRANS(UI_TEXT_NO_PL);
TRANS(UI_TEXT_PRINT_POS_PL);
TRANS(UI_TEXT_PRINTING_PL);
TRANS(UI_TEXT_IDLE_PL);
TRANS(UI_TEXT_NOSDCARD_PL);
TRANS(UI_TEXT_ERROR_PL);
TRANS(UI_TEXT_BACK_PL);
TRANS(UI_TEXT_QUICK_SETTINGS_PL);
TRANS(UI_TEXT_ERRORMSG_PL);
TRANS(UI_TEXT_CONFIGURATION_PL);
TRANS(UI_TEXT_POSITION_PL);
TRANS(UI_TEXT_EXTRUDER_PL);
TRANS(UI_TEXT_SD_CARD_PL);
TRANS(UI_TEXT_DEBUGGING_PL);
TRANS(UI_TEXT_HOME_DELTA_PL);
TRANS(UI_TEXT_HOME_ALL_PL);
TRANS(UI_TEXT_HOME_X_PL);
TRANS(UI_TEXT_HOME_Y_PL);
TRANS(UI_TEXT_HOME_Z_PL);
TRANS(UI_TEXT_PREHEAT_PLA_PL);
TRANS(UI_TEXT_PREHEAT_ABS_PL);
TRANS(UI_TEXT_LIGHTS_ONOFF_PL);
TRANS(UI_TEXT_COOLDOWN_PL);
TRANS(UI_TEXT_SET_TO_ORIGIN_PL);
TRANS(UI_TEXT_DISABLE_STEPPER_PL);
TRANS(UI_TEXT_X_POSITION_PL);
TRANS(UI_TEXT_X_POS_FAST_PL);
TRANS(UI_TEXT_Y_POSITION_PL);
TRANS(UI_TEXT_Y_POS_FAST_PL);
TRANS(UI_TEXT_Z_POSITION_PL);
TRANS(UI_TEXT_Z_POS_FAST_PL);
TRANS(UI_TEXT_E_POSITION_PL);
TRANS(UI_TEXT_BED_TEMP_PL);
TRANS(UI_TEXT_EXTR0_TEMP_PL);
TRANS(UI_TEXT_EXTR1_TEMP_PL);
TRANS(UI_TEXT_EXTR2_TEMP_PL);
TRANS(UI_TEXT_EXTR0_OFF_PL);
TRANS(UI_TEXT_EXTR1_OFF_PL);
TRANS(UI_TEXT_EXTR2_OFF_PL);
TRANS(UI_TEXT_EXTR0_SELECT_PL);
TRANS(UI_TEXT_EXTR1_SELECT_PL);
TRANS(UI_TEXT_EXTR2_SELECT_PL);
TRANS(UI_TEXT_EXTR_ORIGIN_PL);
TRANS(UI_TEXT_PRINT_X_PL);
TRANS(UI_TEXT_PRINT_Y_PL);
TRANS(UI_TEXT_PRINT_Z_PL);
TRANS(UI_TEXT_PRINT_Z_DELTA_PL);
TRANS(UI_TEXT_MOVE_X_PL);
TRANS(UI_TEXT_MOVE_Y_PL);
TRANS(UI_TEXT_MOVE_Z_PL);
TRANS(UI_TEXT_MOVE_Z_DELTA_PL);
TRANS(UI_TEXT_JERK_PL);
TRANS(UI_TEXT_ZJERK_PL);
TRANS(UI_TEXT_ACCELERATION_PL);
TRANS(UI_TEXT_STORE_TO_EEPROM_PL);
TRANS(UI_TEXT_LOAD_EEPROM_PL);
TRANS(UI_TEXT_DBG_ECHO_PL);
TRANS(UI_TEXT_DBG_INFO_PL);
TRANS(UI_TEXT_DBG_ERROR_PL);
TRANS(UI_TEXT_DBG_DRYRUN_PL);
TRANS(UI_TEXT_DBG_ENDSTOP_PL);
TRANS(UI_TEXT_OPS_OFF_PL);
TRANS(UI_TEXT_OPS_CLASSIC_PL);
TRANS(UI_TEXT_OPS_FAST_PL);
TRANS(UI_TEXT_OPS_RETRACT_PL);
TRANS(UI_TEXT_OPS_BACKSLASH_PL);
TRANS(UI_TEXT_OPS_MINDIST_PL);
TRANS(UI_TEXT_OPS_MOVE_AFTER_PL);
TRANS(UI_TEXT_ANTI_OOZE_PL);
TRANS(UI_TEXT_PRINT_FILE_PL);
TRANS(UI_TEXT_PAUSE_PRINT_PL);
TRANS(UI_TEXT_CONTINUE_PRINT_PL);
TRANS(UI_TEXT_UNMOUNT_CARD_PL);
TRANS(UI_TEXT_MOUNT_CARD_PL);
TRANS(UI_TEXT_DELETE_FILE_PL);
TRANS(UI_TEXT_FEEDRATE_PL);
TRANS(UI_TEXT_FEED_MAX_X_PL);
TRANS(UI_TEXT_FEED_MAX_Y_PL);
TRANS(UI_TEXT_FEED_MAX_Z_PL);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_PL);
TRANS(UI_TEXT_FEED_HOME_X_PL);
TRANS(UI_TEXT_FEED_HOME_Y_PL);
TRANS(UI_TEXT_FEED_HOME_Z_PL);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_PL);
TRANS(UI_TEXT_ACTION_XPOSITION4A_PL);
TRANS(UI_TEXT_ACTION_XPOSITION4B_PL);
TRANS(UI_TEXT_ACTION_XPOSITION4C_PL);
TRANS(UI_TEXT_ACTION_XPOSITION4D_PL);
TRANS(UI_TEXT_ACTION_YPOSITION4A_PL);
TRANS(UI_TEXT_ACTION_YPOSITION4B_PL);
TRANS(UI_TEXT_ACTION_YPOSITION4C_PL);
TRANS(UI_TEXT_ACTION_YPOSITION4D_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_PL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_PL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_PL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_PL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_PL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_PL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_PL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_PL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_PL);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_PL);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_PL);
TRANS(UI_TEXT_ACTION_XPOSITION2A_PL);
TRANS(UI_TEXT_ACTION_XPOSITION2B_PL);
TRANS(UI_TEXT_ACTION_YPOSITION2A_PL);
TRANS(UI_TEXT_ACTION_YPOSITION2B_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_PL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_PL);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_PL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_PL);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_PL);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_PL);
TRANS(UI_TEXT_FANSPEED_PL);
TRANS(UI_TEXT_ACTION_FANSPEED_PL);
TRANS(UI_TEXT_FAN_OFF_PL);
TRANS(UI_TEXT_FAN_25_PL);
TRANS(UI_TEXT_FAN_50_PL);
TRANS(UI_TEXT_FAN_75_PL);
TRANS(UI_TEXT_FAN_FULL_PL);
TRANS(UI_TEXT_STEPPER_INACTIVE_PL);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_PL);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_PL);
TRANS(UI_TEXT_POWER_INACTIVE_PL);
TRANS(UI_TEXT_POWER_INACTIVE2A_PL);
TRANS(UI_TEXT_POWER_INACTIVE2B_PL);
TRANS(UI_TEXT_GENERAL_PL);
TRANS(UI_TEXT_BAUDRATE_PL);
TRANS(UI_TEXT_EXTR_STEPS_PL);
TRANS(UI_TEXT_EXTR_START_FEED_PL);
TRANS(UI_TEXT_EXTR_MAX_FEED_PL);
TRANS(UI_TEXT_EXTR_ACCEL_PL);
TRANS(UI_TEXT_EXTR_WATCH_PL);
TRANS(UI_TEXT_EXTR_ADVANCE_L_PL);
TRANS(UI_TEXT_EXTR_ADVANCE_K_PL);
TRANS(UI_TEXT_EXTR_MANAGER_PL);
TRANS(UI_TEXT_EXTR_PGAIN_PL);
TRANS(UI_TEXT_EXTR_DEADTIME_PL);
TRANS(UI_TEXT_EXTR_DMAX_DT_PL);
TRANS(UI_TEXT_EXTR_IGAIN_PL);
TRANS(UI_TEXT_EXTR_DGAIN_PL);
TRANS(UI_TEXT_EXTR_DMIN_PL);
TRANS(UI_TEXT_EXTR_DMAX_PL);
TRANS(UI_TEXT_EXTR_PMAX_PL);
TRANS(UI_TEXT_EXTR_XOFF_PL);
TRANS(UI_TEXT_EXTR_YOFF_PL);
TRANS(UI_TEXT_STRING_HM_BANGBANG_PL);
TRANS(UI_TEXT_STRING_HM_PID_PL);
TRANS(UI_TEXT_STRING_ACTION_PL);
TRANS(UI_TEXT_HEATING_EXTRUDER_PL);
TRANS(UI_TEXT_HEATING_BED_PL);
TRANS(UI_TEXT_KILLED_PL);
TRANS(UI_TEXT_STEPPER_DISABLED_PL);
TRANS(UI_TEXT_EEPROM_STOREDA_PL);
TRANS(UI_TEXT_EEPROM_STOREDB_PL);
TRANS(UI_TEXT_EEPROM_LOADEDA_PL);
TRANS(UI_TEXT_EEPROM_LOADEDB_PL);
TRANS(UI_TEXT_UPLOADING_PL);
TRANS(UI_TEXT_PAGE_BUFFER_PL);
TRANS(UI_TEXT_PAGE_EXTRUDER_PL);
TRANS(UI_TEXT_PAGE_EXTRUDER1_PL);
TRANS(UI_TEXT_PAGE_EXTRUDER2_PL);
TRANS(UI_TEXT_PAGE_EXTRUDER3_PL);
TRANS(UI_TEXT_PAGE_BED_PL);
TRANS(UI_TEXT_SPEED_MULTIPLY_PL);
TRANS(UI_TEXT_FLOW_MULTIPLY_PL);
TRANS(UI_TEXT_SHOW_MEASUREMENT_PL);
TRANS(UI_TEXT_RESET_MEASUREMENT_PL);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_PL);
TRANS(UI_TEXT_ZCALIB_PL);
TRANS(UI_TEXT_SET_P1_PL);
TRANS(UI_TEXT_SET_P2_PL);
TRANS(UI_TEXT_SET_P3_PL);
TRANS(UI_TEXT_CALCULATE_LEVELING_PL);
TRANS(UI_TEXT_LEVEL_PL);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_PL);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_PL);
TRANS(UI_TEXT_SD_REMOVED_PL);
TRANS(UI_TEXT_SD_INSERTED_PL);
TRANS(UI_TEXT_PRINTER_READY_PL);
TRANS(UI_TEXT_PRINTTIME_DAYS_PL);
TRANS(UI_TEXT_PRINTTIME_HOURS_PL);
TRANS(UI_TEXT_PRINTTIME_MINUTES_PL);
TRANS(UI_TEXT_PRINT_TIME_PL);
TRANS(UI_TEXT_PRINT_FILAMENT_PL);
TRANS(UI_TEXT_PRINTED_PL);
TRANS(UI_TEXT_POWER_PL);
TRANS(UI_TEXT_STRING_HM_DEADTIME_PL);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_PL);
TRANS(UI_TEXT_STOP_PRINT_PL);
TRANS(UI_TEXT_Z_BABYSTEPPING_PL);
TRANS(UI_TEXT_CHANGE_FILAMENT_PL);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_PL);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_PL);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_PL);
TRANS(UI_TEXT_CLICK_DONE_PL);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_PL);
TRANS(UI_TEXT_SERVOPOS_PL);
TRANS(UI_TEXT_IGNORE_M106_PL);
TRANS(UI_TEXT_WIZ_REHEAT1_PL);
TRANS(UI_TEXT_WIZ_REHEAT2_PL);
TRANS(UI_TEXT_WIZ_WAITTEMP1_PL);
TRANS(UI_TEXT_WIZ_WAITTEMP2_PL);
TRANS(UI_TEXT_EXTRUDER_JAM_PL);
TRANS(UI_TEXT_STANDBY_PL);
TRANS(UI_TEXT_BED_COATING_PL);
TRANS(UI_TEXT_BED_COATING_SET1_PL);
TRANS(UI_TEXT_BED_COATING_SET2_PL);
TRANS(UI_TEXT_NOCOATING_PL);
TRANS(UI_TEXT_BUILDTAK_PL);
TRANS(UI_TEXT_KAPTON_PL);
TRANS(UI_TEXT_BLUETAPE_PL);
TRANS(UI_TEXT_PETTAPE_PL);
TRANS(UI_TEXT_GLUESTICK_PL);
TRANS(UI_TEXT_CUSTOM_PL);
TRANS(UI_TEXT_COATING_CUSTOM_PL);
TRANS(UI_TEXT_LANGUAGE_PL);
TRANS(UI_TEXT_MAINPAGE6_1_PL);
TRANS(UI_TEXT_MAINPAGE6_2_PL);
TRANS(UI_TEXT_MAINPAGE6_3_PL);
TRANS(UI_TEXT_MAINPAGE6_4_PL);
TRANS(UI_TEXT_MAINPAGE6_5_PL);
TRANS(UI_TEXT_MAINPAGE6_6_PL);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_PL);
TRANS(UI_TEXT_MAINPAGE_BED_PL);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_PL);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_PL);
TRANS(UI_TEXT_MAINPAGE_XY_PL);
TRANS(UI_TEXT_PRINT_TIME_VALUE_PL);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_PL);
TRANS(UI_TEXT_METER_PRINTED_PL);
TRANS(UI_TEXT_STATUS_PL);
TRANS(UI_TEXT_EMPTY_PL);
TRANS(UI_TEXT_TEMP_SET_PL);
TRANS(UI_TEXT_CURRENT_TEMP_PL);
TRANS(UI_TEXT_COATING_THICKNESS_PL);
TRANS(UI_TEXT_EXTR3_TEMP_PL);
TRANS(UI_TEXT_EXTR4_TEMP_PL);
TRANS(UI_TEXT_EXTR5_TEMP_PL);
TRANS(UI_TEXT_EXTR3_OFF_PL);
TRANS(UI_TEXT_EXTR4_OFF_PL);
TRANS(UI_TEXT_EXTR5_OFF_PL);
TRANS(UI_TEXT_EXTR3_SELECT_PL);
TRANS(UI_TEXT_EXTR4_SELECT_PL);
TRANS(UI_TEXT_EXTR5_SELECT_PL);
TRANS(UI_TEXT_DITTO_0_PL);
TRANS(UI_TEXT_DITTO_1_PL);
TRANS(UI_TEXT_DITTO_2_PL);
TRANS(UI_TEXT_DITTO_3_PL);
TRANS(UI_TEXT_ZPROBE_HEIGHT_PL);
TRANS(UI_TEXT_OFFSETS_PL);
TRANS(UI_TEXT_X_OFFSET_PL);
TRANS(UI_TEXT_Y_OFFSET_PL);
TRANS(UI_TEXT_Z_OFFSET_PL);

PGM_P const translations_pl[NUM_TRANSLATED_WORDS] PROGMEM = {
 FUI_TEXT_ON_PL,
 FUI_TEXT_OFF_PL,
 FUI_TEXT_NA_PL,
 FUI_TEXT_YES_PL,
 FUI_TEXT_NO_PL,
 FUI_TEXT_PRINT_POS_PL,
 FUI_TEXT_PRINTING_PL,
 FUI_TEXT_IDLE_PL,
 FUI_TEXT_NOSDCARD_PL,
 FUI_TEXT_ERROR_PL,
 FUI_TEXT_BACK_PL,
 FUI_TEXT_QUICK_SETTINGS_PL,
 FUI_TEXT_ERRORMSG_PL,
 FUI_TEXT_CONFIGURATION_PL,
 FUI_TEXT_POSITION_PL,
 FUI_TEXT_EXTRUDER_PL,
 FUI_TEXT_SD_CARD_PL,
 FUI_TEXT_DEBUGGING_PL,
 FUI_TEXT_HOME_DELTA_PL,
 FUI_TEXT_HOME_ALL_PL,
 FUI_TEXT_HOME_X_PL,
 FUI_TEXT_HOME_Y_PL,
 FUI_TEXT_HOME_Z_PL,
 FUI_TEXT_PREHEAT_PLA_PL,
 FUI_TEXT_PREHEAT_ABS_PL,
 FUI_TEXT_LIGHTS_ONOFF_PL,
 FUI_TEXT_COOLDOWN_PL,
 FUI_TEXT_SET_TO_ORIGIN_PL,
 FUI_TEXT_DISABLE_STEPPER_PL,
 FUI_TEXT_X_POSITION_PL,
 FUI_TEXT_X_POS_FAST_PL,
 FUI_TEXT_Y_POSITION_PL,
 FUI_TEXT_Y_POS_FAST_PL,
 FUI_TEXT_Z_POSITION_PL,
 FUI_TEXT_Z_POS_FAST_PL,
 FUI_TEXT_E_POSITION_PL,
 FUI_TEXT_BED_TEMP_PL,
 FUI_TEXT_EXTR0_TEMP_PL,
 FUI_TEXT_EXTR1_TEMP_PL,
 FUI_TEXT_EXTR2_TEMP_PL,
 FUI_TEXT_EXTR0_OFF_PL,
 FUI_TEXT_EXTR1_OFF_PL,
 FUI_TEXT_EXTR2_OFF_PL,
 FUI_TEXT_EXTR0_SELECT_PL,
 FUI_TEXT_EXTR1_SELECT_PL,
 FUI_TEXT_EXTR2_SELECT_PL,
 FUI_TEXT_EXTR_ORIGIN_PL,
 FUI_TEXT_PRINT_X_PL,
 FUI_TEXT_PRINT_Y_PL,
 FUI_TEXT_PRINT_Z_PL,
 FUI_TEXT_PRINT_Z_DELTA_PL,
 FUI_TEXT_MOVE_X_PL,
 FUI_TEXT_MOVE_Y_PL,
 FUI_TEXT_MOVE_Z_PL,
 FUI_TEXT_MOVE_Z_DELTA_PL,
 FUI_TEXT_JERK_PL,
 FUI_TEXT_ZJERK_PL,
 FUI_TEXT_ACCELERATION_PL,
 FUI_TEXT_STORE_TO_EEPROM_PL,
 FUI_TEXT_LOAD_EEPROM_PL,
 FUI_TEXT_DBG_ECHO_PL,
 FUI_TEXT_DBG_INFO_PL,
 FUI_TEXT_DBG_ERROR_PL,
 FUI_TEXT_DBG_DRYRUN_PL,
 FUI_TEXT_OPS_OFF_PL,
 FUI_TEXT_OPS_CLASSIC_PL,
 FUI_TEXT_OPS_FAST_PL,
 FUI_TEXT_OPS_RETRACT_PL,
 FUI_TEXT_OPS_BACKSLASH_PL,
 FUI_TEXT_OPS_MINDIST_PL,
 FUI_TEXT_OPS_MOVE_AFTER_PL,
 FUI_TEXT_ANTI_OOZE_PL,
 FUI_TEXT_PRINT_FILE_PL,
 FUI_TEXT_PAUSE_PRINT_PL,
 FUI_TEXT_CONTINUE_PRINT_PL,
 FUI_TEXT_UNMOUNT_CARD_PL,
 FUI_TEXT_MOUNT_CARD_PL,
 FUI_TEXT_DELETE_FILE_PL,
 FUI_TEXT_FEEDRATE_PL,
 FUI_TEXT_FEED_MAX_X_PL,
 FUI_TEXT_FEED_MAX_Y_PL,
 FUI_TEXT_FEED_MAX_Z_PL,
 FUI_TEXT_FEED_MAX_Z_DELTA_PL,
 FUI_TEXT_FEED_HOME_X_PL,
 FUI_TEXT_FEED_HOME_Y_PL,
 FUI_TEXT_FEED_HOME_Z_PL,
 FUI_TEXT_FEED_HOME_Z_DELTA_PL,
 FUI_TEXT_ACTION_XPOSITION4A_PL,
 FUI_TEXT_ACTION_XPOSITION4B_PL,
 FUI_TEXT_ACTION_XPOSITION4C_PL,
 FUI_TEXT_ACTION_XPOSITION4D_PL,
 FUI_TEXT_ACTION_YPOSITION4A_PL,
 FUI_TEXT_ACTION_YPOSITION4B_PL,
 FUI_TEXT_ACTION_YPOSITION4C_PL,
 FUI_TEXT_ACTION_YPOSITION4D_PL,
 FUI_TEXT_ACTION_ZPOSITION4A_PL,
 FUI_TEXT_ACTION_ZPOSITION4B_PL,
 FUI_TEXT_ACTION_ZPOSITION4C_PL,
 FUI_TEXT_ACTION_ZPOSITION4D_PL,
 FUI_TEXT_ACTION_XPOSITION_FAST4A_PL,
 FUI_TEXT_ACTION_XPOSITION_FAST4B_PL,
 FUI_TEXT_ACTION_XPOSITION_FAST4C_PL,
 FUI_TEXT_ACTION_XPOSITION_FAST4D_PL,
 FUI_TEXT_ACTION_YPOSITION_FAST4A_PL,
 FUI_TEXT_ACTION_YPOSITION_FAST4B_PL,
 FUI_TEXT_ACTION_YPOSITION_FAST4C_PL,
 FUI_TEXT_ACTION_YPOSITION_FAST4D_PL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4A_PL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4B_PL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4C_PL,
 FUI_TEXT_ACTION_ZPOSITION_FAST4D_PL,
 FUI_TEXT_ACTION_EPOSITION_FAST2A_PL,
 FUI_TEXT_ACTION_EPOSITION_FAST2B_PL,
 FUI_TEXT_ACTION_XPOSITION2A_PL,
 FUI_TEXT_ACTION_XPOSITION2B_PL,
 FUI_TEXT_ACTION_YPOSITION2A_PL,
 FUI_TEXT_ACTION_YPOSITION2B_PL,
 FUI_TEXT_ACTION_ZPOSITION2A_PL,
 FUI_TEXT_ACTION_ZPOSITION2B_PL,
 FUI_TEXT_ACTION_XPOSITION_FAST2A_PL,
 FUI_TEXT_ACTION_XPOSITION_FAST2B_PL,
 FUI_TEXT_ACTION_YPOSITION_FAST2A_PL,
 FUI_TEXT_ACTION_YPOSITION_FAST2B_PL,
 FUI_TEXT_ACTION_ZPOSITION_FAST2A_PL,
 FUI_TEXT_ACTION_ZPOSITION_FAST2B_PL,
 FUI_TEXT_FANSPEED_PL,
 FUI_TEXT_ACTION_FANSPEED_PL,
 FUI_TEXT_FAN_OFF_PL,
 FUI_TEXT_FAN_25_PL,
 FUI_TEXT_FAN_50_PL,
 FUI_TEXT_FAN_75_PL,
 FUI_TEXT_FAN_FULL_PL,
 FUI_TEXT_STEPPER_INACTIVE_PL,
 FUI_TEXT_STEPPER_INACTIVE2A_PL,
 FUI_TEXT_STEPPER_INACTIVE2B_PL,
 FUI_TEXT_POWER_INACTIVE_PL,
 FUI_TEXT_POWER_INACTIVE2A_PL,
 FUI_TEXT_POWER_INACTIVE2B_PL,
 FUI_TEXT_GENERAL_PL,
 FUI_TEXT_BAUDRATE_PL,
 FUI_TEXT_EXTR_STEPS_PL,
 FUI_TEXT_EXTR_START_FEED_PL,
 FUI_TEXT_EXTR_MAX_FEED_PL,
 FUI_TEXT_EXTR_ACCEL_PL,
 FUI_TEXT_EXTR_WATCH_PL,
 FUI_TEXT_EXTR_ADVANCE_L_PL,
 FUI_TEXT_EXTR_ADVANCE_K_PL,
 FUI_TEXT_EXTR_MANAGER_PL,
 FUI_TEXT_EXTR_PGAIN_PL,
 FUI_TEXT_EXTR_DEADTIME_PL,
 FUI_TEXT_EXTR_DMAX_DT_PL,
 FUI_TEXT_EXTR_IGAIN_PL,
 FUI_TEXT_EXTR_DGAIN_PL,
 FUI_TEXT_EXTR_DMIN_PL,
 FUI_TEXT_EXTR_DMAX_PL,
 FUI_TEXT_EXTR_PMAX_PL,
 FUI_TEXT_EXTR_XOFF_PL,
 FUI_TEXT_EXTR_YOFF_PL,
 FUI_TEXT_STRING_HM_BANGBANG_PL,
 FUI_TEXT_STRING_HM_PID_PL,
 FUI_TEXT_STRING_ACTION_PL,
 FUI_TEXT_HEATING_EXTRUDER_PL,
 FUI_TEXT_HEATING_BED_PL,
 FUI_TEXT_KILLED_PL,
 FUI_TEXT_STEPPER_DISABLED_PL,
 FUI_TEXT_EEPROM_STOREDA_PL,
 FUI_TEXT_EEPROM_STOREDB_PL,
 FUI_TEXT_EEPROM_LOADEDA_PL,
 FUI_TEXT_EEPROM_LOADEDB_PL,
 FUI_TEXT_UPLOADING_PL,
 FUI_TEXT_PAGE_BUFFER_PL,
 FUI_TEXT_PAGE_EXTRUDER_PL,
 FUI_TEXT_PAGE_EXTRUDER1_PL,
 FUI_TEXT_PAGE_EXTRUDER2_PL,
 FUI_TEXT_PAGE_EXTRUDER3_PL,
 FUI_TEXT_PAGE_BED_PL,
 FUI_TEXT_SPEED_MULTIPLY_PL,
 FUI_TEXT_FLOW_MULTIPLY_PL,
 FUI_TEXT_SHOW_MEASUREMENT_PL,
 FUI_TEXT_RESET_MEASUREMENT_PL,
 FUI_TEXT_SET_MEASURED_ORIGIN_PL,
 FUI_TEXT_ZCALIB_PL,
 FUI_TEXT_SET_P1_PL,
 FUI_TEXT_SET_P2_PL,
 FUI_TEXT_SET_P3_PL,
 FUI_TEXT_CALCULATE_LEVELING_PL,
 FUI_TEXT_LEVEL_PL,
 FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_PL,
 FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_PL,
 FUI_TEXT_SD_REMOVED_PL,
 FUI_TEXT_SD_INSERTED_PL,
 FUI_TEXT_PRINTER_READY_PL,
 FUI_TEXT_PRINTTIME_DAYS_PL,
 FUI_TEXT_PRINTTIME_HOURS_PL,
 FUI_TEXT_PRINTTIME_MINUTES_PL,
 FUI_TEXT_PRINT_TIME_PL,
 FUI_TEXT_PRINT_FILAMENT_PL,
 FUI_TEXT_PRINTED_PL,
 FUI_TEXT_POWER_PL,
 FUI_TEXT_STRING_HM_DEADTIME_PL,
 FUI_TEXT_STRING_HM_SLOWBANG_PL,
 FUI_TEXT_STOP_PRINT_PL,
 FUI_TEXT_Z_BABYSTEPPING_PL,
 FUI_TEXT_CHANGE_FILAMENT_PL,
 FUI_TEXT_WIZ_CH_FILAMENT1_PL,
 FUI_TEXT_WIZ_CH_FILAMENT2_PL,
 FUI_TEXT_WIZ_CH_FILAMENT3_PL,
 FUI_TEXT_CLICK_DONE_PL,
 FUI_TEXT_AUTOLEVEL_ONOFF_PL,
 FUI_TEXT_SERVOPOS_PL,
 FUI_TEXT_IGNORE_M106_PL,
 FUI_TEXT_WIZ_REHEAT1_PL,
 FUI_TEXT_WIZ_REHEAT2_PL,
 FUI_TEXT_WIZ_WAITTEMP1_PL,
 FUI_TEXT_WIZ_WAITTEMP2_PL,
 FUI_TEXT_EXTRUDER_JAM_PL,
 FUI_TEXT_STANDBY_PL,
 FUI_TEXT_BED_COATING_PL,
 FUI_TEXT_BED_COATING_SET1_PL,
 FUI_TEXT_BED_COATING_SET2_PL,
 FUI_TEXT_NOCOATING_PL,
 FUI_TEXT_BUILDTAK_PL,
 FUI_TEXT_KAPTON_PL,
 FUI_TEXT_BLUETAPE_PL,
 FUI_TEXT_PETTAPE_PL,
 FUI_TEXT_GLUESTICK_PL,
 FUI_TEXT_CUSTOM_PL,
 FUI_TEXT_COATING_CUSTOM_PL,
 FUI_TEXT_LANGUAGE_PL,
 FUI_TEXT_MAINPAGE6_1_PL,
 FUI_TEXT_MAINPAGE6_2_PL,
 FUI_TEXT_MAINPAGE6_3_PL,
 FUI_TEXT_MAINPAGE6_4_PL,
 FUI_TEXT_MAINPAGE6_5_PL,
 FUI_TEXT_MAINPAGE6_6_PL,
 FUI_TEXT_MAINPAGE_TEMP_BED_PL,
 FUI_TEXT_MAINPAGE_BED_PL,
 FUI_TEXT_MAINPAGE_Z_BUF_PL,
 FUI_TEXT_MAINPAGE_MUL_EUSAGE_PL,
 FUI_TEXT_MAINPAGE_XY_PL,
 FUI_TEXT_PRINT_TIME_VALUE_PL,
 FUI_TEXT_PRINT_FILAMENT_VALUE_PL,
 FUI_TEXT_METER_PRINTED_PL,
 FUI_TEXT_STATUS_PL,
 FUI_TEXT_EMPTY_PL,
 FUI_TEXT_TEMP_SET_PL,
 FUI_TEXT_CURRENT_TEMP_PL,
 FUI_TEXT_COATING_THICKNESS_PL,
 FUI_TEXT_EXTR3_TEMP_PL,
 FUI_TEXT_EXTR4_TEMP_PL,
 FUI_TEXT_EXTR5_TEMP_PL,
 FUI_TEXT_EXTR3_OFF_PL,
 FUI_TEXT_EXTR4_OFF_PL,
 FUI_TEXT_EXTR5_OFF_PL,
 FUI_TEXT_EXTR3_SELECT_PL,
 FUI_TEXT_EXTR4_SELECT_PL,
 FUI_TEXT_EXTR5_SELECT_PL,
 FUI_TEXT_DITTO_0_PL,
 FUI_TEXT_DITTO_1_PL,
 FUI_TEXT_DITTO_2_PL,
 FUI_TEXT_DITTO_3_PL,
 FUI_TEXT_ZPROBE_HEIGHT_PL,
 FUI_TEXT_OFFSETS_PL,
 FUI_TEXT_X_OFFSET_PL,
 FUI_TEXT_Y_OFFSET_PL,
 FUI_TEXT_Z_OFFSET_PL,
 FUI_TEXT_DBG_ENDSTOP_PL
};
#define LANG_PL_TABLE translations_pl
#else
#define LANG_PL_TABLE NULL
#endif // LANGUAGE_PL_ACTIVE

#if LANGUAGE_TR_ACTIVE
TRANS(UI_TEXT_ON_TR);
TRANS(UI_TEXT_OFF_TR);
TRANS(UI_TEXT_NA_TR);
TRANS(UI_TEXT_YES_TR);
TRANS(UI_TEXT_NO_TR);
TRANS(UI_TEXT_PRINT_POS_TR);
TRANS(UI_TEXT_PRINTING_TR);
TRANS(UI_TEXT_IDLE_TR);
TRANS(UI_TEXT_NOSDCARD_TR);
TRANS(UI_TEXT_ERROR_TR);
TRANS(UI_TEXT_BACK_TR);
TRANS(UI_TEXT_QUICK_SETTINGS_TR);
TRANS(UI_TEXT_ERRORMSG_TR);
TRANS(UI_TEXT_CONFIGURATION_TR);
TRANS(UI_TEXT_POSITION_TR);
TRANS(UI_TEXT_EXTRUDER_TR);
TRANS(UI_TEXT_SD_CARD_TR);
TRANS(UI_TEXT_DEBUGGING_TR);
TRANS(UI_TEXT_HOME_DELTA_TR);
TRANS(UI_TEXT_HOME_ALL_TR);
TRANS(UI_TEXT_HOME_X_TR);
TRANS(UI_TEXT_HOME_Y_TR);
TRANS(UI_TEXT_HOME_Z_TR);
TRANS(UI_TEXT_PREHEAT_PLA_TR);
TRANS(UI_TEXT_PREHEAT_ABS_TR);
TRANS(UI_TEXT_LIGHTS_ONOFF_TR);
TRANS(UI_TEXT_COOLDOWN_TR);
TRANS(UI_TEXT_SET_TO_ORIGIN_TR);
TRANS(UI_TEXT_DISABLE_STEPPER_TR);
TRANS(UI_TEXT_X_POSITION_TR);
TRANS(UI_TEXT_X_POS_FAST_TR);
TRANS(UI_TEXT_Y_POSITION_TR);
TRANS(UI_TEXT_Y_POS_FAST_TR);
TRANS(UI_TEXT_Z_POSITION_TR);
TRANS(UI_TEXT_Z_POS_FAST_TR);
TRANS(UI_TEXT_E_POSITION_TR);
TRANS(UI_TEXT_BED_TEMP_TR);
TRANS(UI_TEXT_EXTR0_TEMP_TR);
TRANS(UI_TEXT_EXTR1_TEMP_TR);
TRANS(UI_TEXT_EXTR2_TEMP_TR);
TRANS(UI_TEXT_EXTR0_OFF_TR);
TRANS(UI_TEXT_EXTR1_OFF_TR);
TRANS(UI_TEXT_EXTR2_OFF_TR);
TRANS(UI_TEXT_EXTR0_SELECT_TR);
TRANS(UI_TEXT_EXTR1_SELECT_TR);
TRANS(UI_TEXT_EXTR2_SELECT_TR);
TRANS(UI_TEXT_EXTR_ORIGIN_TR);
TRANS(UI_TEXT_PRINT_X_TR);
TRANS(UI_TEXT_PRINT_Y_TR);
TRANS(UI_TEXT_PRINT_Z_TR);
TRANS(UI_TEXT_PRINT_Z_DELTA_TR);
TRANS(UI_TEXT_MOVE_X_TR);
TRANS(UI_TEXT_MOVE_Y_TR);
TRANS(UI_TEXT_MOVE_Z_TR);
TRANS(UI_TEXT_MOVE_Z_DELTA_TR);
TRANS(UI_TEXT_JERK_TR);
TRANS(UI_TEXT_ZJERK_TR);
TRANS(UI_TEXT_ACCELERATION_TR);
TRANS(UI_TEXT_STORE_TO_EEPROM_TR);
TRANS(UI_TEXT_LOAD_EEPROM_TR);
TRANS(UI_TEXT_DBG_ECHO_TR);
TRANS(UI_TEXT_DBG_INFO_TR);
TRANS(UI_TEXT_DBG_ERROR_TR);
TRANS(UI_TEXT_DBG_DRYRUN_TR);
TRANS(UI_TEXT_DBG_ENDSTOP_TR);
TRANS(UI_TEXT_OPS_OFF_TR);
TRANS(UI_TEXT_OPS_CLASSIC_TR);
TRANS(UI_TEXT_OPS_FAST_TR);
TRANS(UI_TEXT_OPS_RETRACT_TR);
TRANS(UI_TEXT_OPS_BACKSLASH_TR);
TRANS(UI_TEXT_OPS_MINDIST_TR);
TRANS(UI_TEXT_OPS_MOVE_AFTER_TR);
TRANS(UI_TEXT_ANTI_OOZE_TR);
TRANS(UI_TEXT_PRINT_FILE_TR);
TRANS(UI_TEXT_PAUSE_PRINT_TR);
TRANS(UI_TEXT_CONTINUE_PRINT_TR);
TRANS(UI_TEXT_UNMOUNT_CARD_TR);
TRANS(UI_TEXT_MOUNT_CARD_TR);
TRANS(UI_TEXT_DELETE_FILE_TR);
TRANS(UI_TEXT_FEEDRATE_TR);
TRANS(UI_TEXT_FEED_MAX_X_TR);
TRANS(UI_TEXT_FEED_MAX_Y_TR);
TRANS(UI_TEXT_FEED_MAX_Z_TR);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_TR);
TRANS(UI_TEXT_FEED_HOME_X_TR);
TRANS(UI_TEXT_FEED_HOME_Y_TR);
TRANS(UI_TEXT_FEED_HOME_Z_TR);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_TR);
TRANS(UI_TEXT_ACTION_XPOSITION4A_TR);
TRANS(UI_TEXT_ACTION_XPOSITION4B_TR);
TRANS(UI_TEXT_ACTION_XPOSITION4C_TR);
TRANS(UI_TEXT_ACTION_XPOSITION4D_TR);
TRANS(UI_TEXT_ACTION_YPOSITION4A_TR);
TRANS(UI_TEXT_ACTION_YPOSITION4B_TR);
TRANS(UI_TEXT_ACTION_YPOSITION4C_TR);
TRANS(UI_TEXT_ACTION_YPOSITION4D_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_TR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_TR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_TR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_TR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_TR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_TR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_TR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_TR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_TR);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_TR);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_TR);
TRANS(UI_TEXT_ACTION_XPOSITION2A_TR);
TRANS(UI_TEXT_ACTION_XPOSITION2B_TR);
TRANS(UI_TEXT_ACTION_YPOSITION2A_TR);
TRANS(UI_TEXT_ACTION_YPOSITION2B_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_TR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_TR);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_TR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_TR);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_TR);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_TR);
TRANS(UI_TEXT_FANSPEED_TR);
TRANS(UI_TEXT_ACTION_FANSPEED_TR);
TRANS(UI_TEXT_FAN_OFF_TR);
TRANS(UI_TEXT_FAN_25_TR);
TRANS(UI_TEXT_FAN_50_TR);
TRANS(UI_TEXT_FAN_75_TR);
TRANS(UI_TEXT_FAN_FULL_TR);
TRANS(UI_TEXT_STEPPER_INACTIVE_TR);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_TR);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_TR);
TRANS(UI_TEXT_POWER_INACTIVE_TR);
TRANS(UI_TEXT_POWER_INACTIVE2A_TR);
TRANS(UI_TEXT_POWER_INACTIVE2B_TR);
TRANS(UI_TEXT_GENERAL_TR);
TRANS(UI_TEXT_BAUDRATE_TR);
TRANS(UI_TEXT_EXTR_STEPS_TR);
TRANS(UI_TEXT_EXTR_START_FEED_TR);
TRANS(UI_TEXT_EXTR_MAX_FEED_TR);
TRANS(UI_TEXT_EXTR_ACCEL_TR);
TRANS(UI_TEXT_EXTR_WATCH_TR);
TRANS(UI_TEXT_EXTR_ADVANCE_L_TR);
TRANS(UI_TEXT_EXTR_ADVANCE_K_TR);
TRANS(UI_TEXT_EXTR_MANAGER_TR);
TRANS(UI_TEXT_EXTR_PGAIN_TR);
TRANS(UI_TEXT_EXTR_DEADTIME_TR);
TRANS(UI_TEXT_EXTR_DMAX_DT_TR);
TRANS(UI_TEXT_EXTR_IGAIN_TR);
TRANS(UI_TEXT_EXTR_DGAIN_TR);
TRANS(UI_TEXT_EXTR_DMIN_TR);
TRANS(UI_TEXT_EXTR_DMAX_TR);
TRANS(UI_TEXT_EXTR_PMAX_TR);
TRANS(UI_TEXT_EXTR_XOFF_TR);
TRANS(UI_TEXT_EXTR_YOFF_TR);
TRANS(UI_TEXT_STRING_HM_BANGBANG_TR);
TRANS(UI_TEXT_STRING_HM_PID_TR);
TRANS(UI_TEXT_STRING_ACTION_TR);
TRANS(UI_TEXT_HEATING_EXTRUDER_TR);
TRANS(UI_TEXT_HEATING_BED_TR);
TRANS(UI_TEXT_KILLED_TR);
TRANS(UI_TEXT_STEPPER_DISABLED_TR);
TRANS(UI_TEXT_EEPROM_STOREDA_TR);
TRANS(UI_TEXT_EEPROM_STOREDB_TR);
TRANS(UI_TEXT_EEPROM_LOADEDA_TR);
TRANS(UI_TEXT_EEPROM_LOADEDB_TR);
TRANS(UI_TEXT_UPLOADING_TR);
TRANS(UI_TEXT_PAGE_BUFFER_TR);
TRANS(UI_TEXT_PAGE_EXTRUDER_TR);
TRANS(UI_TEXT_PAGE_EXTRUDER1_TR);
TRANS(UI_TEXT_PAGE_EXTRUDER2_TR);
TRANS(UI_TEXT_PAGE_EXTRUDER3_TR);
TRANS(UI_TEXT_PAGE_BED_TR);
TRANS(UI_TEXT_SPEED_MULTIPLY_TR);
TRANS(UI_TEXT_FLOW_MULTIPLY_TR);
TRANS(UI_TEXT_SHOW_MEASUREMENT_TR);
TRANS(UI_TEXT_RESET_MEASUREMENT_TR);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_TR);
TRANS(UI_TEXT_ZCALIB_TR);
TRANS(UI_TEXT_SET_P1_TR);
TRANS(UI_TEXT_SET_P2_TR);
TRANS(UI_TEXT_SET_P3_TR);
TRANS(UI_TEXT_CALCULATE_LEVELING_TR);
TRANS(UI_TEXT_LEVEL_TR);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_TR);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_TR);
TRANS(UI_TEXT_SD_REMOVED_TR);
TRANS(UI_TEXT_SD_INSERTED_TR);
TRANS(UI_TEXT_PRINTER_READY_TR);
TRANS(UI_TEXT_PRINTTIME_DAYS_TR);
TRANS(UI_TEXT_PRINTTIME_HOURS_TR);
TRANS(UI_TEXT_PRINTTIME_MINUTES_TR);
TRANS(UI_TEXT_PRINT_TIME_TR);
TRANS(UI_TEXT_PRINT_FILAMENT_TR);
TRANS(UI_TEXT_PRINTED_TR);
TRANS(UI_TEXT_POWER_TR);
TRANS(UI_TEXT_STRING_HM_DEADTIME_TR);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_TR);
TRANS(UI_TEXT_STOP_PRINT_TR);
TRANS(UI_TEXT_Z_BABYSTEPPING_TR);
TRANS(UI_TEXT_CHANGE_FILAMENT_TR);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_TR);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_TR);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_TR);
TRANS(UI_TEXT_CLICK_DONE_TR);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_TR);
TRANS(UI_TEXT_SERVOPOS_TR);
TRANS(UI_TEXT_IGNORE_M106_TR);
TRANS(UI_TEXT_WIZ_REHEAT1_TR);
TRANS(UI_TEXT_WIZ_REHEAT2_TR);
TRANS(UI_TEXT_WIZ_WAITTEMP1_TR);
TRANS(UI_TEXT_WIZ_WAITTEMP2_TR);
TRANS(UI_TEXT_EXTRUDER_JAM_TR);
TRANS(UI_TEXT_STANDBY_TR);
TRANS(UI_TEXT_BED_COATING_TR);
TRANS(UI_TEXT_BED_COATING_SET1_TR);
TRANS(UI_TEXT_BED_COATING_SET2_TR);
TRANS(UI_TEXT_NOCOATING_TR);
TRANS(UI_TEXT_BUILDTAK_TR);
TRANS(UI_TEXT_KAPTON_TR);
TRANS(UI_TEXT_BLUETAPE_TR);
TRANS(UI_TEXT_PETTAPE_TR);
TRANS(UI_TEXT_GLUESTICK_TR);
TRANS(UI_TEXT_CUSTOM_TR);
TRANS(UI_TEXT_COATING_CUSTOM_TR);
TRANS(UI_TEXT_LANGUAGE_TR);
TRANS(UI_TEXT_MAINPAGE6_1_TR);
TRANS(UI_TEXT_MAINPAGE6_2_TR);
TRANS(UI_TEXT_MAINPAGE6_3_TR);
TRANS(UI_TEXT_MAINPAGE6_4_TR);
TRANS(UI_TEXT_MAINPAGE6_5_TR);
TRANS(UI_TEXT_MAINPAGE6_6_TR);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_TR);
TRANS(UI_TEXT_MAINPAGE_BED_TR);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_TR);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_TR);
TRANS(UI_TEXT_MAINPAGE_XY_TR);
TRANS(UI_TEXT_PRINT_TIME_VALUE_TR);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_TR);
TRANS(UI_TEXT_METER_PRINTED_TR);
TRANS(UI_TEXT_STATUS_TR);
TRANS(UI_TEXT_EMPTY_TR);
TRANS(UI_TEXT_TEMP_SET_TR);
TRANS(UI_TEXT_CURRENT_TEMP_TR);
TRANS(UI_TEXT_COATING_THICKNESS_TR);
TRANS(UI_TEXT_EXTR3_TEMP_TR);
TRANS(UI_TEXT_EXTR4_TEMP_TR);
TRANS(UI_TEXT_EXTR5_TEMP_TR);
TRANS(UI_TEXT_EXTR3_OFF_TR);
TRANS(UI_TEXT_EXTR4_OFF_TR);
TRANS(UI_TEXT_EXTR5_OFF_TR);
TRANS(UI_TEXT_EXTR3_SELECT_TR);
TRANS(UI_TEXT_EXTR4_SELECT_TR);
TRANS(UI_TEXT_EXTR5_SELECT_TR);
TRANS(UI_TEXT_DITTO_0_TR);
TRANS(UI_TEXT_DITTO_1_TR);
TRANS(UI_TEXT_DITTO_2_TR);
TRANS(UI_TEXT_DITTO_3_TR);
TRANS(UI_TEXT_ZPROBE_HEIGHT_TR);
TRANS(UI_TEXT_OFFSETS_TR);
TRANS(UI_TEXT_X_OFFSET_TR);
TRANS(UI_TEXT_Y_OFFSET_TR);
TRANS(UI_TEXT_Z_OFFSET_TR);


PGM_P const translations_TR[NUM_TRANSLATED_WORDS] PROGMEM = {
	FUI_TEXT_ON_TR,
	FUI_TEXT_OFF_TR,
	FUI_TEXT_NA_TR,
	FUI_TEXT_YES_TR,
	FUI_TEXT_NO_TR,
	FUI_TEXT_PRINT_POS_TR,
	FUI_TEXT_PRINTING_TR,
	FUI_TEXT_IDLE_TR,
	FUI_TEXT_NOSDCARD_TR,
	FUI_TEXT_ERROR_TR,
	FUI_TEXT_BACK_TR,
	FUI_TEXT_QUICK_SETTINGS_TR,
	FUI_TEXT_ERRORMSG_TR,
	FUI_TEXT_CONFIGURATION_TR,
	FUI_TEXT_POSITION_TR,
	FUI_TEXT_EXTRUDER_TR,
	FUI_TEXT_SD_CARD_TR,
	FUI_TEXT_DEBUGGING_TR,
	FUI_TEXT_HOME_DELTA_TR,
	FUI_TEXT_HOME_ALL_TR,
	FUI_TEXT_HOME_X_TR,
	FUI_TEXT_HOME_Y_TR,
	FUI_TEXT_HOME_Z_TR,
	FUI_TEXT_PREHEAT_PLA_TR,
	FUI_TEXT_PREHEAT_ABS_TR,
	FUI_TEXT_LIGHTS_ONOFF_TR,
	FUI_TEXT_COOLDOWN_TR,
	FUI_TEXT_SET_TO_ORIGIN_TR,
	FUI_TEXT_DISABLE_STEPPER_TR,
	FUI_TEXT_X_POSITION_TR,
	FUI_TEXT_X_POS_FAST_TR,
	FUI_TEXT_Y_POSITION_TR,
	FUI_TEXT_Y_POS_FAST_TR,
	FUI_TEXT_Z_POSITION_TR,
	FUI_TEXT_Z_POS_FAST_TR,
	FUI_TEXT_E_POSITION_TR,
	FUI_TEXT_BED_TEMP_TR,
	FUI_TEXT_EXTR0_TEMP_TR,
	FUI_TEXT_EXTR1_TEMP_TR,
	FUI_TEXT_EXTR2_TEMP_TR,
	FUI_TEXT_EXTR0_OFF_TR,
	FUI_TEXT_EXTR1_OFF_TR,
	FUI_TEXT_EXTR2_OFF_TR,
	FUI_TEXT_EXTR0_SELECT_TR,
	FUI_TEXT_EXTR1_SELECT_TR,
	FUI_TEXT_EXTR2_SELECT_TR,
	FUI_TEXT_EXTR_ORIGIN_TR,
	FUI_TEXT_PRINT_X_TR,
	FUI_TEXT_PRINT_Y_TR,
	FUI_TEXT_PRINT_Z_TR,
	FUI_TEXT_PRINT_Z_DELTA_TR,
	FUI_TEXT_MOVE_X_TR,
	FUI_TEXT_MOVE_Y_TR,
	FUI_TEXT_MOVE_Z_TR,
	FUI_TEXT_MOVE_Z_DELTA_TR,
	FUI_TEXT_JERK_TR,
	FUI_TEXT_ZJERK_TR,
	FUI_TEXT_ACCELERATION_TR,
	FUI_TEXT_STORE_TO_EEPROM_TR,
	FUI_TEXT_LOAD_EEPROM_TR,
	FUI_TEXT_DBG_ECHO_TR,
	FUI_TEXT_DBG_INFO_TR,
	FUI_TEXT_DBG_ERROR_TR,
	FUI_TEXT_DBG_DRYRUN_TR,
	FUI_TEXT_OPS_OFF_TR,
	FUI_TEXT_OPS_CLASSIC_TR,
	FUI_TEXT_OPS_FAST_TR,
	FUI_TEXT_OPS_RETRACT_TR,
	FUI_TEXT_OPS_BACKSLASH_TR,
	FUI_TEXT_OPS_MINDIST_TR,
	FUI_TEXT_OPS_MOVE_AFTER_TR,
	FUI_TEXT_ANTI_OOZE_TR,
	FUI_TEXT_PRINT_FILE_TR,
	FUI_TEXT_PAUSE_PRINT_TR,
	FUI_TEXT_CONTINUE_PRINT_TR,
	FUI_TEXT_UNMOUNT_CARD_TR,
	FUI_TEXT_MOUNT_CARD_TR,
	FUI_TEXT_DELETE_FILE_TR,
	FUI_TEXT_FEEDRATE_TR,
	FUI_TEXT_FEED_MAX_X_TR,
	FUI_TEXT_FEED_MAX_Y_TR,
	FUI_TEXT_FEED_MAX_Z_TR,
	FUI_TEXT_FEED_MAX_Z_DELTA_TR,
	FUI_TEXT_FEED_HOME_X_TR,
	FUI_TEXT_FEED_HOME_Y_TR,
	FUI_TEXT_FEED_HOME_Z_TR,
	FUI_TEXT_FEED_HOME_Z_DELTA_TR,
	FUI_TEXT_ACTION_XPOSITION4A_TR,
	FUI_TEXT_ACTION_XPOSITION4B_TR,
	FUI_TEXT_ACTION_XPOSITION4C_TR,
	FUI_TEXT_ACTION_XPOSITION4D_TR,
	FUI_TEXT_ACTION_YPOSITION4A_TR,
	FUI_TEXT_ACTION_YPOSITION4B_TR,
	FUI_TEXT_ACTION_YPOSITION4C_TR,
	FUI_TEXT_ACTION_YPOSITION4D_TR,
	FUI_TEXT_ACTION_ZPOSITION4A_TR,
	FUI_TEXT_ACTION_ZPOSITION4B_TR,
	FUI_TEXT_ACTION_ZPOSITION4C_TR,
	FUI_TEXT_ACTION_ZPOSITION4D_TR,
	FUI_TEXT_ACTION_XPOSITION_FAST4A_TR,
	FUI_TEXT_ACTION_XPOSITION_FAST4B_TR,
	FUI_TEXT_ACTION_XPOSITION_FAST4C_TR,
	FUI_TEXT_ACTION_XPOSITION_FAST4D_TR,
	FUI_TEXT_ACTION_YPOSITION_FAST4A_TR,
	FUI_TEXT_ACTION_YPOSITION_FAST4B_TR,
	FUI_TEXT_ACTION_YPOSITION_FAST4C_TR,
	FUI_TEXT_ACTION_YPOSITION_FAST4D_TR,
	FUI_TEXT_ACTION_ZPOSITION_FAST4A_TR,
	FUI_TEXT_ACTION_ZPOSITION_FAST4B_TR,
	FUI_TEXT_ACTION_ZPOSITION_FAST4C_TR,
	FUI_TEXT_ACTION_ZPOSITION_FAST4D_TR,
	FUI_TEXT_ACTION_EPOSITION_FAST2A_TR,
	FUI_TEXT_ACTION_EPOSITION_FAST2B_TR,
	FUI_TEXT_ACTION_XPOSITION2A_TR,
	FUI_TEXT_ACTION_XPOSITION2B_TR,
	FUI_TEXT_ACTION_YPOSITION2A_TR,
	FUI_TEXT_ACTION_YPOSITION2B_TR,
	FUI_TEXT_ACTION_ZPOSITION2A_TR,
	FUI_TEXT_ACTION_ZPOSITION2B_TR,
	FUI_TEXT_ACTION_XPOSITION_FAST2A_TR,
	FUI_TEXT_ACTION_XPOSITION_FAST2B_TR,
	FUI_TEXT_ACTION_YPOSITION_FAST2A_TR,
	FUI_TEXT_ACTION_YPOSITION_FAST2B_TR,
	FUI_TEXT_ACTION_ZPOSITION_FAST2A_TR,
	FUI_TEXT_ACTION_ZPOSITION_FAST2B_TR,
	FUI_TEXT_FANSPEED_TR,
	FUI_TEXT_ACTION_FANSPEED_TR,
	FUI_TEXT_FAN_OFF_TR,
	FUI_TEXT_FAN_25_TR,
	FUI_TEXT_FAN_50_TR,
	FUI_TEXT_FAN_75_TR,
	FUI_TEXT_FAN_FULL_TR,
	FUI_TEXT_STEPPER_INACTIVE_TR,
	FUI_TEXT_STEPPER_INACTIVE2A_TR,
	FUI_TEXT_STEPPER_INACTIVE2B_TR,
	FUI_TEXT_POWER_INACTIVE_TR,
	FUI_TEXT_POWER_INACTIVE2A_TR,
	FUI_TEXT_POWER_INACTIVE2B_TR,
	FUI_TEXT_GENERAL_TR,
	FUI_TEXT_BAUDRATE_TR,
	FUI_TEXT_EXTR_STEPS_TR,
	FUI_TEXT_EXTR_START_FEED_TR,
	FUI_TEXT_EXTR_MAX_FEED_TR,
	FUI_TEXT_EXTR_ACCEL_TR,
	FUI_TEXT_EXTR_WATCH_TR,
	FUI_TEXT_EXTR_ADVANCE_L_TR,
	FUI_TEXT_EXTR_ADVANCE_K_TR,
	FUI_TEXT_EXTR_MANAGER_TR,
	FUI_TEXT_EXTR_PGAIN_TR,
	FUI_TEXT_EXTR_DEADTIME_TR,
	FUI_TEXT_EXTR_DMAX_DT_TR,
	FUI_TEXT_EXTR_IGAIN_TR,
	FUI_TEXT_EXTR_DGAIN_TR,
	FUI_TEXT_EXTR_DMIN_TR,
	FUI_TEXT_EXTR_DMAX_TR,
	FUI_TEXT_EXTR_PMAX_TR,
	FUI_TEXT_EXTR_XOFF_TR,
	FUI_TEXT_EXTR_YOFF_TR,
	FUI_TEXT_STRING_HM_BANGBANG_TR,
	FUI_TEXT_STRING_HM_PID_TR,
	FUI_TEXT_STRING_ACTION_TR,
	FUI_TEXT_HEATING_EXTRUDER_TR,
	FUI_TEXT_HEATING_BED_TR,
	FUI_TEXT_KILLED_TR,
	FUI_TEXT_STEPPER_DISABLED_TR,
	FUI_TEXT_EEPROM_STOREDA_TR,
	FUI_TEXT_EEPROM_STOREDB_TR,
	FUI_TEXT_EEPROM_LOADEDA_TR,
	FUI_TEXT_EEPROM_LOADEDB_TR,
	FUI_TEXT_UPLOADING_TR,
	FUI_TEXT_PAGE_BUFFER_TR,
	FUI_TEXT_PAGE_EXTRUDER_TR,
	FUI_TEXT_PAGE_EXTRUDER1_TR,
	FUI_TEXT_PAGE_EXTRUDER2_TR,
	FUI_TEXT_PAGE_EXTRUDER3_TR,
	FUI_TEXT_PAGE_BED_TR,
	FUI_TEXT_SPEED_MULTIPLY_TR,
	FUI_TEXT_FLOW_MULTIPLY_TR,
	FUI_TEXT_SHOW_MEASUREMENT_TR,
	FUI_TEXT_RESET_MEASUREMENT_TR,
	FUI_TEXT_SET_MEASURED_ORIGIN_TR,
	FUI_TEXT_ZCALIB_TR,
	FUI_TEXT_SET_P1_TR,
	FUI_TEXT_SET_P2_TR,
	FUI_TEXT_SET_P3_TR,
	FUI_TEXT_CALCULATE_LEVELING_TR,
	FUI_TEXT_LEVEL_TR,
	FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_TR,
	FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_TR,
	FUI_TEXT_SD_REMOVED_TR,
	FUI_TEXT_SD_INSERTED_TR,
	FUI_TEXT_PRINTER_READY_TR,
	FUI_TEXT_PRINTTIME_DAYS_TR,
	FUI_TEXT_PRINTTIME_HOURS_TR,
	FUI_TEXT_PRINTTIME_MINUTES_TR,
	FUI_TEXT_PRINT_TIME_TR,
	FUI_TEXT_PRINT_FILAMENT_TR,
	FUI_TEXT_PRINTED_TR,
	FUI_TEXT_POWER_TR,
	FUI_TEXT_STRING_HM_DEADTIME_TR,
	FUI_TEXT_STRING_HM_SLOWBANG_TR,
	FUI_TEXT_STOP_PRINT_TR,
	FUI_TEXT_Z_BABYSTEPPING_TR,
	FUI_TEXT_CHANGE_FILAMENT_TR,
	FUI_TEXT_WIZ_CH_FILAMENT1_TR,
	FUI_TEXT_WIZ_CH_FILAMENT2_TR,
	FUI_TEXT_WIZ_CH_FILAMENT3_TR,
	FUI_TEXT_CLICK_DONE_TR,
	FUI_TEXT_AUTOLEVEL_ONOFF_TR,
	FUI_TEXT_SERVOPOS_TR,
	FUI_TEXT_IGNORE_M106_TR,
	FUI_TEXT_WIZ_REHEAT1_TR,
	FUI_TEXT_WIZ_REHEAT2_TR,
	FUI_TEXT_WIZ_WAITTEMP1_TR,
	FUI_TEXT_WIZ_WAITTEMP2_TR,
	FUI_TEXT_EXTRUDER_JAM_TR,
	FUI_TEXT_STANDBY_TR,
	FUI_TEXT_BED_COATING_TR,
	FUI_TEXT_BED_COATING_SET1_TR,
	FUI_TEXT_BED_COATING_SET2_TR,
	FUI_TEXT_NOCOATING_TR,
	FUI_TEXT_BUILDTAK_TR,
	FUI_TEXT_KAPTON_TR,
	FUI_TEXT_BLUETAPE_TR,
	FUI_TEXT_PETTAPE_TR,
	FUI_TEXT_GLUESTICK_TR,
	FUI_TEXT_CUSTOM_TR,
	FUI_TEXT_COATING_CUSTOM_TR,
	FUI_TEXT_LANGUAGE_TR,
	FUI_TEXT_MAINPAGE6_1_TR,
	FUI_TEXT_MAINPAGE6_2_TR,
	FUI_TEXT_MAINPAGE6_3_TR,
	FUI_TEXT_MAINPAGE6_4_TR,
	FUI_TEXT_MAINPAGE6_5_TR,
	FUI_TEXT_MAINPAGE6_6_TR,
	FUI_TEXT_MAINPAGE_TEMP_BED_TR,
	FUI_TEXT_MAINPAGE_BED_TR,
	FUI_TEXT_MAINPAGE_Z_BUF_TR,
	FUI_TEXT_MAINPAGE_MUL_EUSAGE_TR,
	FUI_TEXT_MAINPAGE_XY_TR,
	FUI_TEXT_PRINT_TIME_VALUE_TR,
	FUI_TEXT_PRINT_FILAMENT_VALUE_TR,
	FUI_TEXT_METER_PRINTED_TR,
	FUI_TEXT_STATUS_TR,
	FUI_TEXT_EMPTY_TR,
	FUI_TEXT_TEMP_SET_TR,
	FUI_TEXT_CURRENT_TEMP_TR,
	FUI_TEXT_COATING_THICKNESS_TR,
	FUI_TEXT_EXTR3_TEMP_TR,
	FUI_TEXT_EXTR4_TEMP_TR,
	FUI_TEXT_EXTR5_TEMP_TR,
	FUI_TEXT_EXTR3_OFF_TR,
	FUI_TEXT_EXTR4_OFF_TR,
	FUI_TEXT_EXTR5_OFF_TR,
	FUI_TEXT_EXTR3_SELECT_TR,
	FUI_TEXT_EXTR4_SELECT_TR,
	FUI_TEXT_EXTR5_SELECT_TR,
	FUI_TEXT_DITTO_0_TR,
	FUI_TEXT_DITTO_1_TR,
	FUI_TEXT_DITTO_2_TR,
	FUI_TEXT_DITTO_3_TR,
	FUI_TEXT_ZPROBE_HEIGHT_TR,
	FUI_TEXT_OFFSETS_TR,
	FUI_TEXT_X_OFFSET_TR,
	FUI_TEXT_Y_OFFSET_TR,
	FUI_TEXT_Z_OFFSET_TR,
  FUI_TEXT_DBG_ENDSTOP_TR
};
#define LANG_TR_TABLE translations_TR
#else
#define LANG_TR_TABLE NULL
#endif // LANGUAGE_TR_ACTIVE

#if LANGUAGE_TR_ACTIVE
TRANS(UI_TEXT_ON_FI);
TRANS(UI_TEXT_OFF_FI);
TRANS(UI_TEXT_NA_FI);
TRANS(UI_TEXT_YES_FI);
TRANS(UI_TEXT_NO_FI);
TRANS(UI_TEXT_PRINT_POS_FI);
TRANS(UI_TEXT_PRINTING_FI);
TRANS(UI_TEXT_IDLE_FI);
TRANS(UI_TEXT_NOSDCARD_FI);
TRANS(UI_TEXT_ERROR_FI);
TRANS(UI_TEXT_BACK_FI);
TRANS(UI_TEXT_QUICK_SETTINGS_FI);
TRANS(UI_TEXT_ERRORMSG_FI);
TRANS(UI_TEXT_CONFIGURATION_FI);
TRANS(UI_TEXT_POSITION_FI);
TRANS(UI_TEXT_EXTRUDER_FI);
TRANS(UI_TEXT_SD_CARD_FI);
TRANS(UI_TEXT_DEBUGGING_FI);
TRANS(UI_TEXT_HOME_DELTA_FI);
TRANS(UI_TEXT_HOME_ALL_FI);
TRANS(UI_TEXT_HOME_X_FI);
TRANS(UI_TEXT_HOME_Y_FI);
TRANS(UI_TEXT_HOME_Z_FI);
TRANS(UI_TEXT_PREHEAT_PLA_FI);
TRANS(UI_TEXT_PREHEAT_ABS_FI);
TRANS(UI_TEXT_LIGHTS_ONOFF_FI);
TRANS(UI_TEXT_COOLDOWN_FI);
TRANS(UI_TEXT_SET_TO_ORIGIN_FI);
TRANS(UI_TEXT_DISABLE_STEPPER_FI);
TRANS(UI_TEXT_X_POSITION_FI);
TRANS(UI_TEXT_X_POS_FAST_FI);
TRANS(UI_TEXT_Y_POSITION_FI);
TRANS(UI_TEXT_Y_POS_FAST_FI);
TRANS(UI_TEXT_Z_POSITION_FI);
TRANS(UI_TEXT_Z_POS_FAST_FI);
TRANS(UI_TEXT_E_POSITION_FI);
TRANS(UI_TEXT_BED_TEMP_FI);
TRANS(UI_TEXT_EXTR0_TEMP_FI);
TRANS(UI_TEXT_EXTR1_TEMP_FI);
TRANS(UI_TEXT_EXTR2_TEMP_FI);
TRANS(UI_TEXT_EXTR0_OFF_FI);
TRANS(UI_TEXT_EXTR1_OFF_FI);
TRANS(UI_TEXT_EXTR2_OFF_FI);
TRANS(UI_TEXT_EXTR0_SELECT_FI);
TRANS(UI_TEXT_EXTR1_SELECT_FI);
TRANS(UI_TEXT_EXTR2_SELECT_FI);
TRANS(UI_TEXT_EXTR_ORIGIN_FI);
TRANS(UI_TEXT_PRINT_X_FI);
TRANS(UI_TEXT_PRINT_Y_FI);
TRANS(UI_TEXT_PRINT_Z_FI);
TRANS(UI_TEXT_PRINT_Z_DELTA_FI);
TRANS(UI_TEXT_MOVE_X_FI);
TRANS(UI_TEXT_MOVE_Y_FI);
TRANS(UI_TEXT_MOVE_Z_FI);
TRANS(UI_TEXT_MOVE_Z_DELTA_FI);
TRANS(UI_TEXT_JERK_FI);
TRANS(UI_TEXT_ZJERK_FI);
TRANS(UI_TEXT_ACCELERATION_FI);
TRANS(UI_TEXT_STORE_TO_EEPROM_FI);
TRANS(UI_TEXT_LOAD_EEPROM_FI);
TRANS(UI_TEXT_DBG_ECHO_FI);
TRANS(UI_TEXT_DBG_INFO_FI);
TRANS(UI_TEXT_DBG_ERROR_FI);
TRANS(UI_TEXT_DBG_DRYRUN_FI);
TRANS(UI_TEXT_DBG_ENDSTOP_FI);
TRANS(UI_TEXT_OPS_OFF_FI);
TRANS(UI_TEXT_OPS_CLASSIC_FI);
TRANS(UI_TEXT_OPS_FAST_FI);
TRANS(UI_TEXT_OPS_RETRACT_FI);
TRANS(UI_TEXT_OPS_BACKSLASH_FI);
TRANS(UI_TEXT_OPS_MINDIST_FI);
TRANS(UI_TEXT_OPS_MOVE_AFTER_FI);
TRANS(UI_TEXT_ANTI_OOZE_FI);
TRANS(UI_TEXT_PRINT_FILE_FI);
TRANS(UI_TEXT_PAUSE_PRINT_FI);
TRANS(UI_TEXT_CONTINUE_PRINT_FI);
TRANS(UI_TEXT_UNMOUNT_CARD_FI);
TRANS(UI_TEXT_MOUNT_CARD_FI);
TRANS(UI_TEXT_DELETE_FILE_FI);
TRANS(UI_TEXT_FEEDRATE_FI);
TRANS(UI_TEXT_FEED_MAX_X_FI);
TRANS(UI_TEXT_FEED_MAX_Y_FI);
TRANS(UI_TEXT_FEED_MAX_Z_FI);
TRANS(UI_TEXT_FEED_MAX_Z_DELTA_FI);
TRANS(UI_TEXT_FEED_HOME_X_FI);
TRANS(UI_TEXT_FEED_HOME_Y_FI);
TRANS(UI_TEXT_FEED_HOME_Z_FI);
TRANS(UI_TEXT_FEED_HOME_Z_DELTA_FI);
TRANS(UI_TEXT_ACTION_XPOSITION4A_FI);
TRANS(UI_TEXT_ACTION_XPOSITION4B_FI);
TRANS(UI_TEXT_ACTION_XPOSITION4C_FI);
TRANS(UI_TEXT_ACTION_XPOSITION4D_FI);
TRANS(UI_TEXT_ACTION_YPOSITION4A_FI);
TRANS(UI_TEXT_ACTION_YPOSITION4B_FI);
TRANS(UI_TEXT_ACTION_YPOSITION4C_FI);
TRANS(UI_TEXT_ACTION_YPOSITION4D_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION4A_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION4B_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION4C_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION4D_FI);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4A_FI);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4B_FI);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4C_FI);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST4D_FI);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4A_FI);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4B_FI);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4C_FI);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST4D_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4A_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4B_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4C_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST4D_FI);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2A_FI);
TRANS(UI_TEXT_ACTION_EPOSITION_FAST2B_FI);
TRANS(UI_TEXT_ACTION_XPOSITION2A_FI);
TRANS(UI_TEXT_ACTION_XPOSITION2B_FI);
TRANS(UI_TEXT_ACTION_YPOSITION2A_FI);
TRANS(UI_TEXT_ACTION_YPOSITION2B_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION2A_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION2B_FI);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2A_FI);
TRANS(UI_TEXT_ACTION_XPOSITION_FAST2B_FI);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2A_FI);
TRANS(UI_TEXT_ACTION_YPOSITION_FAST2B_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2A_FI);
TRANS(UI_TEXT_ACTION_ZPOSITION_FAST2B_FI);
TRANS(UI_TEXT_FANSPEED_FI);
TRANS(UI_TEXT_ACTION_FANSPEED_FI);
TRANS(UI_TEXT_FAN_OFF_FI);
TRANS(UI_TEXT_FAN_25_FI);
TRANS(UI_TEXT_FAN_50_FI);
TRANS(UI_TEXT_FAN_75_FI);
TRANS(UI_TEXT_FAN_FULL_FI);
TRANS(UI_TEXT_STEPPER_INACTIVE_FI);
TRANS(UI_TEXT_STEPPER_INACTIVE2A_FI);
TRANS(UI_TEXT_STEPPER_INACTIVE2B_FI);
TRANS(UI_TEXT_POWER_INACTIVE_FI);
TRANS(UI_TEXT_POWER_INACTIVE2A_FI);
TRANS(UI_TEXT_POWER_INACTIVE2B_FI);
TRANS(UI_TEXT_GENERAL_FI);
TRANS(UI_TEXT_BAUDRATE_FI);
TRANS(UI_TEXT_EXTR_STEPS_FI);
TRANS(UI_TEXT_EXTR_START_FEED_FI);
TRANS(UI_TEXT_EXTR_MAX_FEED_FI);
TRANS(UI_TEXT_EXTR_ACCEL_FI);
TRANS(UI_TEXT_EXTR_WATCH_FI);
TRANS(UI_TEXT_EXTR_ADVANCE_L_FI);
TRANS(UI_TEXT_EXTR_ADVANCE_K_FI);
TRANS(UI_TEXT_EXTR_MANAGER_FI);
TRANS(UI_TEXT_EXTR_PGAIN_FI);
TRANS(UI_TEXT_EXTR_DEADTIME_FI);
TRANS(UI_TEXT_EXTR_DMAX_DT_FI);
TRANS(UI_TEXT_EXTR_IGAIN_FI);
TRANS(UI_TEXT_EXTR_DGAIN_FI);
TRANS(UI_TEXT_EXTR_DMIN_FI);
TRANS(UI_TEXT_EXTR_DMAX_FI);
TRANS(UI_TEXT_EXTR_PMAX_FI);
TRANS(UI_TEXT_EXTR_XOFF_FI);
TRANS(UI_TEXT_EXTR_YOFF_FI);
TRANS(UI_TEXT_STRING_HM_BANGBANG_FI);
TRANS(UI_TEXT_STRING_HM_PID_FI);
TRANS(UI_TEXT_STRING_ACTION_FI);
TRANS(UI_TEXT_HEATING_EXTRUDER_FI);
TRANS(UI_TEXT_HEATING_BED_FI);
TRANS(UI_TEXT_KILLED_FI);
TRANS(UI_TEXT_STEPPER_DISABLED_FI);
TRANS(UI_TEXT_EEPROM_STOREDA_FI);
TRANS(UI_TEXT_EEPROM_STOREDB_FI);
TRANS(UI_TEXT_EEPROM_LOADEDA_FI);
TRANS(UI_TEXT_EEPROM_LOADEDB_FI);
TRANS(UI_TEXT_UPLOADING_FI);
TRANS(UI_TEXT_PAGE_BUFFER_FI);
TRANS(UI_TEXT_PAGE_EXTRUDER_FI);
TRANS(UI_TEXT_PAGE_EXTRUDER1_FI);
TRANS(UI_TEXT_PAGE_EXTRUDER2_FI);
TRANS(UI_TEXT_PAGE_EXTRUDER3_FI);
TRANS(UI_TEXT_PAGE_BED_FI);
TRANS(UI_TEXT_SPEED_MULTIPLY_FI);
TRANS(UI_TEXT_FLOW_MULTIPLY_FI);
TRANS(UI_TEXT_SHOW_MEASUREMENT_FI);
TRANS(UI_TEXT_RESET_MEASUREMENT_FI);
TRANS(UI_TEXT_SET_MEASURED_ORIGIN_FI);
TRANS(UI_TEXT_ZCALIB_FI);
TRANS(UI_TEXT_SET_P1_FI);
TRANS(UI_TEXT_SET_P2_FI);
TRANS(UI_TEXT_SET_P3_FI);
TRANS(UI_TEXT_CALCULATE_LEVELING_FI);
TRANS(UI_TEXT_LEVEL_FI);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_TEMP_FI);
TRANS(UI_TEXT_EXTR_WAIT_RETRACT_UNITS_FI);
TRANS(UI_TEXT_SD_REMOVED_FI);
TRANS(UI_TEXT_SD_INSERTED_FI);
TRANS(UI_TEXT_PRINTER_READY_FI);
TRANS(UI_TEXT_PRINTTIME_DAYS_FI);
TRANS(UI_TEXT_PRINTTIME_HOURS_FI);
TRANS(UI_TEXT_PRINTTIME_MINUTES_FI);
TRANS(UI_TEXT_PRINT_TIME_FI);
TRANS(UI_TEXT_PRINT_FILAMENT_FI);
TRANS(UI_TEXT_PRINTED_FI);
TRANS(UI_TEXT_POWER_FI);
TRANS(UI_TEXT_STRING_HM_DEADTIME_FI);
TRANS(UI_TEXT_STRING_HM_SLOWBANG_FI);
TRANS(UI_TEXT_STOP_PRINT_FI);
TRANS(UI_TEXT_Z_BABYSTEPPING_FI);
TRANS(UI_TEXT_CHANGE_FILAMENT_FI);
TRANS(UI_TEXT_WIZ_CH_FILAMENT1_FI);
TRANS(UI_TEXT_WIZ_CH_FILAMENT2_FI);
TRANS(UI_TEXT_WIZ_CH_FILAMENT3_FI);
TRANS(UI_TEXT_CLICK_DONE_FI);
TRANS(UI_TEXT_AUTOLEVEL_ONOFF_FI);
TRANS(UI_TEXT_SERVOPOS_FI);
TRANS(UI_TEXT_IGNORE_M106_FI);
TRANS(UI_TEXT_WIZ_REHEAT1_FI);
TRANS(UI_TEXT_WIZ_REHEAT2_FI);
TRANS(UI_TEXT_WIZ_WAITTEMP1_FI);
TRANS(UI_TEXT_WIZ_WAITTEMP2_FI);
TRANS(UI_TEXT_EXTRUDER_JAM_FI);
TRANS(UI_TEXT_STANDBY_FI);
TRANS(UI_TEXT_BED_COATING_FI);
TRANS(UI_TEXT_BED_COATING_SET1_FI);
TRANS(UI_TEXT_BED_COATING_SET2_FI);
TRANS(UI_TEXT_NOCOATING_FI);
TRANS(UI_TEXT_BUILDTAK_FI);
TRANS(UI_TEXT_KAPTON_FI);
TRANS(UI_TEXT_BLUETAPE_FI);
TRANS(UI_TEXT_PETTAPE_FI);
TRANS(UI_TEXT_GLUESTICK_FI);
TRANS(UI_TEXT_CUSTOM_FI);
TRANS(UI_TEXT_COATING_CUSTOM_FI);
TRANS(UI_TEXT_LANGUAGE_FI);
TRANS(UI_TEXT_MAINPAGE6_1_FI);
TRANS(UI_TEXT_MAINPAGE6_2_FI);
TRANS(UI_TEXT_MAINPAGE6_3_FI);
TRANS(UI_TEXT_MAINPAGE6_4_FI);
TRANS(UI_TEXT_MAINPAGE6_5_FI);
TRANS(UI_TEXT_MAINPAGE6_6_FI);
TRANS(UI_TEXT_MAINPAGE_TEMP_BED_FI);
TRANS(UI_TEXT_MAINPAGE_BED_FI);
TRANS(UI_TEXT_MAINPAGE_Z_BUF_FI);
TRANS(UI_TEXT_MAINPAGE_MUL_EUSAGE_FI);
TRANS(UI_TEXT_MAINPAGE_XY_FI);
TRANS(UI_TEXT_PRINT_TIME_VALUE_FI);
TRANS(UI_TEXT_PRINT_FILAMENT_VALUE_FI);
TRANS(UI_TEXT_METER_PRINTED_FI);
TRANS(UI_TEXT_STATUS_FI);
TRANS(UI_TEXT_EMPTY_FI);
TRANS(UI_TEXT_TEMP_SET_FI);
TRANS(UI_TEXT_CURRENT_TEMP_FI);
TRANS(UI_TEXT_COATING_THICKNESS_FI);
TRANS(UI_TEXT_EXTR3_TEMP_FI);
TRANS(UI_TEXT_EXTR4_TEMP_FI);
TRANS(UI_TEXT_EXTR5_TEMP_FI);
TRANS(UI_TEXT_EXTR3_OFF_FI);
TRANS(UI_TEXT_EXTR4_OFF_FI);
TRANS(UI_TEXT_EXTR5_OFF_FI);
TRANS(UI_TEXT_EXTR3_SELECT_FI);
TRANS(UI_TEXT_EXTR4_SELECT_FI);
TRANS(UI_TEXT_EXTR5_SELECT_FI);
TRANS(UI_TEXT_DITTO_0_FI);
TRANS(UI_TEXT_DITTO_1_FI);
TRANS(UI_TEXT_DITTO_2_FI);
TRANS(UI_TEXT_DITTO_3_FI);
TRANS(UI_TEXT_ZPROBE_HEIGHT_FI);
TRANS(UI_TEXT_OFFSETS_FI);
TRANS(UI_TEXT_X_OFFSET_FI);
TRANS(UI_TEXT_Y_OFFSET_FI);
TRANS(UI_TEXT_Z_OFFSET_FI);


PGM_P const translations_FI[NUM_TRANSLATED_WORDS] PROGMEM = {
	FUI_TEXT_ON_FI,
	FUI_TEXT_OFF_FI,
	FUI_TEXT_NA_FI,
	FUI_TEXT_YES_FI,
	FUI_TEXT_NO_FI,
	FUI_TEXT_PRINT_POS_FI,
	FUI_TEXT_PRINTING_FI,
	FUI_TEXT_IDLE_FI,
	FUI_TEXT_NOSDCARD_FI,
	FUI_TEXT_ERROR_FI,
	FUI_TEXT_BACK_FI,
	FUI_TEXT_QUICK_SETTINGS_FI,
	FUI_TEXT_ERRORMSG_FI,
	FUI_TEXT_CONFIGURATION_FI,
	FUI_TEXT_POSITION_FI,
	FUI_TEXT_EXTRUDER_FI,
	FUI_TEXT_SD_CARD_FI,
	FUI_TEXT_DEBUGGING_FI,
	FUI_TEXT_HOME_DELTA_FI,
	FUI_TEXT_HOME_ALL_FI,
	FUI_TEXT_HOME_X_FI,
	FUI_TEXT_HOME_Y_FI,
	FUI_TEXT_HOME_Z_FI,
	FUI_TEXT_PREHEAT_PLA_FI,
	FUI_TEXT_PREHEAT_ABS_FI,
	FUI_TEXT_LIGHTS_ONOFF_FI,
	FUI_TEXT_COOLDOWN_FI,
	FUI_TEXT_SET_TO_ORIGIN_FI,
	FUI_TEXT_DISABLE_STEPPER_FI,
	FUI_TEXT_X_POSITION_FI,
	FUI_TEXT_X_POS_FAST_FI,
	FUI_TEXT_Y_POSITION_FI,
	FUI_TEXT_Y_POS_FAST_FI,
	FUI_TEXT_Z_POSITION_FI,
	FUI_TEXT_Z_POS_FAST_FI,
	FUI_TEXT_E_POSITION_FI,
	FUI_TEXT_BED_TEMP_FI,
	FUI_TEXT_EXTR0_TEMP_FI,
	FUI_TEXT_EXTR1_TEMP_FI,
	FUI_TEXT_EXTR2_TEMP_FI,
	FUI_TEXT_EXTR0_OFF_FI,
	FUI_TEXT_EXTR1_OFF_FI,
	FUI_TEXT_EXTR2_OFF_FI,
	FUI_TEXT_EXTR0_SELECT_FI,
	FUI_TEXT_EXTR1_SELECT_FI,
	FUI_TEXT_EXTR2_SELECT_FI,
	FUI_TEXT_EXTR_ORIGIN_FI,
	FUI_TEXT_PRINT_X_FI,
	FUI_TEXT_PRINT_Y_FI,
	FUI_TEXT_PRINT_Z_FI,
	FUI_TEXT_PRINT_Z_DELTA_FI,
	FUI_TEXT_MOVE_X_FI,
	FUI_TEXT_MOVE_Y_FI,
	FUI_TEXT_MOVE_Z_FI,
	FUI_TEXT_MOVE_Z_DELTA_FI,
	FUI_TEXT_JERK_FI,
	FUI_TEXT_ZJERK_FI,
	FUI_TEXT_ACCELERATION_FI,
	FUI_TEXT_STORE_TO_EEPROM_FI,
	FUI_TEXT_LOAD_EEPROM_FI,
	FUI_TEXT_DBG_ECHO_FI,
	FUI_TEXT_DBG_INFO_FI,
	FUI_TEXT_DBG_ERROR_FI,
	FUI_TEXT_DBG_DRYRUN_FI,
	FUI_TEXT_OPS_OFF_FI,
	FUI_TEXT_OPS_CLASSIC_FI,
	FUI_TEXT_OPS_FAST_FI,
	FUI_TEXT_OPS_RETRACT_FI,
	FUI_TEXT_OPS_BACKSLASH_FI,
	FUI_TEXT_OPS_MINDIST_FI,
	FUI_TEXT_OPS_MOVE_AFTER_FI,
	FUI_TEXT_ANTI_OOZE_FI,
	FUI_TEXT_PRINT_FILE_FI,
	FUI_TEXT_PAUSE_PRINT_FI,
	FUI_TEXT_CONTINUE_PRINT_FI,
	FUI_TEXT_UNMOUNT_CARD_FI,
	FUI_TEXT_MOUNT_CARD_FI,
	FUI_TEXT_DELETE_FILE_FI,
	FUI_TEXT_FEEDRATE_FI,
	FUI_TEXT_FEED_MAX_X_FI,
	FUI_TEXT_FEED_MAX_Y_FI,
	FUI_TEXT_FEED_MAX_Z_FI,
	FUI_TEXT_FEED_MAX_Z_DELTA_FI,
	FUI_TEXT_FEED_HOME_X_FI,
	FUI_TEXT_FEED_HOME_Y_FI,
	FUI_TEXT_FEED_HOME_Z_FI,
	FUI_TEXT_FEED_HOME_Z_DELTA_FI,
	FUI_TEXT_ACTION_XPOSITION4A_FI,
	FUI_TEXT_ACTION_XPOSITION4B_FI,
	FUI_TEXT_ACTION_XPOSITION4C_FI,
	FUI_TEXT_ACTION_XPOSITION4D_FI,
	FUI_TEXT_ACTION_YPOSITION4A_FI,
	FUI_TEXT_ACTION_YPOSITION4B_FI,
	FUI_TEXT_ACTION_YPOSITION4C_FI,
	FUI_TEXT_ACTION_YPOSITION4D_FI,
	FUI_TEXT_ACTION_ZPOSITION4A_FI,
	FUI_TEXT_ACTION_ZPOSITION4B_FI,
	FUI_TEXT_ACTION_ZPOSITION4C_FI,
	FUI_TEXT_ACTION_ZPOSITION4D_FI,
	FUI_TEXT_ACTION_XPOSITION_FAST4A_FI,
	FUI_TEXT_ACTION_XPOSITION_FAST4B_FI,
	FUI_TEXT_ACTION_XPOSITION_FAST4C_FI,
	FUI_TEXT_ACTION_XPOSITION_FAST4D_FI,
	FUI_TEXT_ACTION_YPOSITION_FAST4A_FI,
	FUI_TEXT_ACTION_YPOSITION_FAST4B_FI,
	FUI_TEXT_ACTION_YPOSITION_FAST4C_FI,
	FUI_TEXT_ACTION_YPOSITION_FAST4D_FI,
	FUI_TEXT_ACTION_ZPOSITION_FAST4A_FI,
	FUI_TEXT_ACTION_ZPOSITION_FAST4B_FI,
	FUI_TEXT_ACTION_ZPOSITION_FAST4C_FI,
	FUI_TEXT_ACTION_ZPOSITION_FAST4D_FI,
	FUI_TEXT_ACTION_EPOSITION_FAST2A_FI,
	FUI_TEXT_ACTION_EPOSITION_FAST2B_FI,
	FUI_TEXT_ACTION_XPOSITION2A_FI,
	FUI_TEXT_ACTION_XPOSITION2B_FI,
	FUI_TEXT_ACTION_YPOSITION2A_FI,
	FUI_TEXT_ACTION_YPOSITION2B_FI,
	FUI_TEXT_ACTION_ZPOSITION2A_FI,
	FUI_TEXT_ACTION_ZPOSITION2B_FI,
	FUI_TEXT_ACTION_XPOSITION_FAST2A_FI,
	FUI_TEXT_ACTION_XPOSITION_FAST2B_FI,
	FUI_TEXT_ACTION_YPOSITION_FAST2A_FI,
	FUI_TEXT_ACTION_YPOSITION_FAST2B_FI,
	FUI_TEXT_ACTION_ZPOSITION_FAST2A_FI,
	FUI_TEXT_ACTION_ZPOSITION_FAST2B_FI,
	FUI_TEXT_FANSPEED_FI,
	FUI_TEXT_ACTION_FANSPEED_FI,
	FUI_TEXT_FAN_OFF_FI,
	FUI_TEXT_FAN_25_FI,
	FUI_TEXT_FAN_50_FI,
	FUI_TEXT_FAN_75_FI,
	FUI_TEXT_FAN_FULL_FI,
	FUI_TEXT_STEPPER_INACTIVE_FI,
	FUI_TEXT_STEPPER_INACTIVE2A_FI,
	FUI_TEXT_STEPPER_INACTIVE2B_FI,
	FUI_TEXT_POWER_INACTIVE_FI,
	FUI_TEXT_POWER_INACTIVE2A_FI,
	FUI_TEXT_POWER_INACTIVE2B_FI,
	FUI_TEXT_GENERAL_FI,
	FUI_TEXT_BAUDRATE_FI,
	FUI_TEXT_EXTR_STEPS_FI,
	FUI_TEXT_EXTR_START_FEED_FI,
	FUI_TEXT_EXTR_MAX_FEED_FI,
	FUI_TEXT_EXTR_ACCEL_FI,
	FUI_TEXT_EXTR_WATCH_FI,
	FUI_TEXT_EXTR_ADVANCE_L_FI,
	FUI_TEXT_EXTR_ADVANCE_K_FI,
	FUI_TEXT_EXTR_MANAGER_FI,
	FUI_TEXT_EXTR_PGAIN_FI,
	FUI_TEXT_EXTR_DEADTIME_FI,
	FUI_TEXT_EXTR_DMAX_DT_FI,
	FUI_TEXT_EXTR_IGAIN_FI,
	FUI_TEXT_EXTR_DGAIN_FI,
	FUI_TEXT_EXTR_DMIN_FI,
	FUI_TEXT_EXTR_DMAX_FI,
	FUI_TEXT_EXTR_PMAX_FI,
	FUI_TEXT_EXTR_XOFF_FI,
	FUI_TEXT_EXTR_YOFF_FI,
	FUI_TEXT_STRING_HM_BANGBANG_FI,
	FUI_TEXT_STRING_HM_PID_FI,
	FUI_TEXT_STRING_ACTION_FI,
	FUI_TEXT_HEATING_EXTRUDER_FI,
	FUI_TEXT_HEATING_BED_FI,
	FUI_TEXT_KILLED_FI,
	FUI_TEXT_STEPPER_DISABLED_FI,
	FUI_TEXT_EEPROM_STOREDA_FI,
	FUI_TEXT_EEPROM_STOREDB_FI,
	FUI_TEXT_EEPROM_LOADEDA_FI,
	FUI_TEXT_EEPROM_LOADEDB_FI,
	FUI_TEXT_UPLOADING_FI,
	FUI_TEXT_PAGE_BUFFER_FI,
	FUI_TEXT_PAGE_EXTRUDER_FI,
	FUI_TEXT_PAGE_EXTRUDER1_FI,
	FUI_TEXT_PAGE_EXTRUDER2_FI,
	FUI_TEXT_PAGE_EXTRUDER3_FI,
	FUI_TEXT_PAGE_BED_FI,
	FUI_TEXT_SPEED_MULTIPLY_FI,
	FUI_TEXT_FLOW_MULTIPLY_FI,
	FUI_TEXT_SHOW_MEASUREMENT_FI,
	FUI_TEXT_RESET_MEASUREMENT_FI,
	FUI_TEXT_SET_MEASURED_ORIGIN_FI,
	FUI_TEXT_ZCALIB_FI,
	FUI_TEXT_SET_P1_FI,
	FUI_TEXT_SET_P2_FI,
	FUI_TEXT_SET_P3_FI,
	FUI_TEXT_CALCULATE_LEVELING_FI,
	FUI_TEXT_LEVEL_FI,
	FUI_TEXT_EXTR_WAIT_RETRACT_TEMP_FI,
	FUI_TEXT_EXTR_WAIT_RETRACT_UNITS_FI,
	FUI_TEXT_SD_REMOVED_FI,
	FUI_TEXT_SD_INSERTED_FI,
	FUI_TEXT_PRINTER_READY_FI,
	FUI_TEXT_PRINTTIME_DAYS_FI,
	FUI_TEXT_PRINTTIME_HOURS_FI,
	FUI_TEXT_PRINTTIME_MINUTES_FI,
	FUI_TEXT_PRINT_TIME_FI,
	FUI_TEXT_PRINT_FILAMENT_FI,
	FUI_TEXT_PRINTED_FI,
	FUI_TEXT_POWER_FI,
	FUI_TEXT_STRING_HM_DEADTIME_FI,
	FUI_TEXT_STRING_HM_SLOWBANG_FI,
	FUI_TEXT_STOP_PRINT_FI,
	FUI_TEXT_Z_BABYSTEPPING_FI,
	FUI_TEXT_CHANGE_FILAMENT_FI,
	FUI_TEXT_WIZ_CH_FILAMENT1_FI,
	FUI_TEXT_WIZ_CH_FILAMENT2_FI,
	FUI_TEXT_WIZ_CH_FILAMENT3_FI,
	FUI_TEXT_CLICK_DONE_FI,
	FUI_TEXT_AUTOLEVEL_ONOFF_FI,
	FUI_TEXT_SERVOPOS_FI,
	FUI_TEXT_IGNORE_M106_FI,
	FUI_TEXT_WIZ_REHEAT1_FI,
	FUI_TEXT_WIZ_REHEAT2_FI,
	FUI_TEXT_WIZ_WAITTEMP1_FI,
	FUI_TEXT_WIZ_WAITTEMP2_FI,
	FUI_TEXT_EXTRUDER_JAM_FI,
	FUI_TEXT_STANDBY_FI,
	FUI_TEXT_BED_COATING_FI,
	FUI_TEXT_BED_COATING_SET1_FI,
	FUI_TEXT_BED_COATING_SET2_FI,
	FUI_TEXT_NOCOATING_FI,
	FUI_TEXT_BUILDTAK_FI,
	FUI_TEXT_KAPTON_FI,
	FUI_TEXT_BLUETAPE_FI,
	FUI_TEXT_PETTAPE_FI,
	FUI_TEXT_GLUESTICK_FI,
	FUI_TEXT_CUSTOM_FI,
	FUI_TEXT_COATING_CUSTOM_FI,
	FUI_TEXT_LANGUAGE_FI,
	FUI_TEXT_MAINPAGE6_1_FI,
	FUI_TEXT_MAINPAGE6_2_FI,
	FUI_TEXT_MAINPAGE6_3_FI,
	FUI_TEXT_MAINPAGE6_4_FI,
	FUI_TEXT_MAINPAGE6_5_FI,
	FUI_TEXT_MAINPAGE6_6_FI,
	FUI_TEXT_MAINPAGE_TEMP_BED_FI,
	FUI_TEXT_MAINPAGE_BED_FI,
	FUI_TEXT_MAINPAGE_Z_BUF_FI,
	FUI_TEXT_MAINPAGE_MUL_EUSAGE_FI,
	FUI_TEXT_MAINPAGE_XY_FI,
	FUI_TEXT_PRINT_TIME_VALUE_FI,
	FUI_TEXT_PRINT_FILAMENT_VALUE_FI,
	FUI_TEXT_METER_PRINTED_FI,
	FUI_TEXT_STATUS_FI,
	FUI_TEXT_EMPTY_FI,
	FUI_TEXT_TEMP_SET_FI,
	FUI_TEXT_CURRENT_TEMP_FI,
	FUI_TEXT_COATING_THICKNESS_FI,
	FUI_TEXT_EXTR3_TEMP_FI,
	FUI_TEXT_EXTR4_TEMP_FI,
	FUI_TEXT_EXTR5_TEMP_FI,
	FUI_TEXT_EXTR3_OFF_FI,
	FUI_TEXT_EXTR4_OFF_FI,
	FUI_TEXT_EXTR5_OFF_FI,
	FUI_TEXT_EXTR3_SELECT_FI,
	FUI_TEXT_EXTR4_SELECT_FI,
	FUI_TEXT_EXTR5_SELECT_FI,
	FUI_TEXT_DITTO_0_FI,
	FUI_TEXT_DITTO_1_FI,
	FUI_TEXT_DITTO_2_FI,
	FUI_TEXT_DITTO_3_FI,
	FUI_TEXT_ZPROBE_HEIGHT_FI,
	FUI_TEXT_OFFSETS_FI,
	FUI_TEXT_X_OFFSET_FI,
	FUI_TEXT_Y_OFFSET_FI,
	FUI_TEXT_Z_OFFSET_FI,
  FUI_TEXT_DBG_ENDSTOP_FI
};
#define LANG_FI_TABLE translations_FI
#else
#define LANG_FI_TABLE NULL
#endif // LANGUAGE_FI_ACTIVE

// References to the possible languages

PGM_P const * const translations[NUM_LANGUAGES_KNOWN] PROGMEM = {
  LANG_EN_TABLE,
  LANG_DE_TABLE,
  LANG_NL_TABLE,
  LANG_PT_TABLE,
  LANG_IT_TABLE,
  LANG_ES_TABLE,
  LANG_SE_TABLE,
  LANG_FR_TABLE,
  LANG_CZ_TABLE,
  LANG_PL_TABLE,
	LANG_TR_TABLE,
	LANG_FI_TABLE
};

// Array in flash to select only valid languages

const uint8_t availableLanguages[] PROGMEM = {
#if LANGUAGE_EN_ACTIVE
    0,
#endif // LANGUAGE_EN_ACTIVE
#if LANGUAGE_DE_ACTIVE
    1,
#endif // LANGUAGE_DE_ACTIVE
#if LANGUAGE_NL_ACTIVE
    2,
#endif // LANGUAGE_NL_ACTIVE
#if LANGUAGE_PT_ACTIVE
    3,
#endif // LANGUAGE_PT_ACTIVE
#if LANGUAGE_IT_ACTIVE
    4,
#endif // LANGUAGE_IT_ACTIVE
#if LANGUAGE_ES_ACTIVE
    5,
#endif // LANGUAGE_ES_ACTIVE
#if LANGUAGE_SE_ACTIVE
    6,
#endif // LANGUAGE_SE_ACTIVE
#if LANGUAGE_FR_ACTIVE
    7,
#endif // LANGUAGE_FR_ACTIVE
#if LANGUAGE_CZ_ACTIVE
    8,
#endif // LANGUAGE_CZ_ACTIVE
#if LANGUAGE_PL_ACTIVE
    9,
#endif // LANGUAGE_PL_ACTIVE
#if LANGUAGE_TR_ACTIVE
	10,
#endif // LANGUAGE_TR_ACTIVE
#if LANGUAGE_FI_ACTIVE
	11,
#endif // LANGUAGE_FI_ACTIVE
    255
};

void Com::selectLanguage(fast8_t lang) {
    unsigned int pos = (unsigned int)&availableLanguages;
    uint8_t best = 255,cur;
    while((cur = HAL::readFlashByte((PGM_P)pos)) != 255) {
        if(best == 255 || cur == lang)
            best = cur;
        pos++;
    }
    Com::selectedLanguage = best;
}

const char* Com::translatedF(int textId) {
    PGM_P *adr = (PGM_P*)pgm_read_word(&translations[selectedLanguage]);
    return (const char *)pgm_read_word(&adr[textId]);
}

#endif
