/*
    This file is part of Repetier-Firmware.

    Repetier-Firmware is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Repetier-Firmware is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Repetier-Firmware.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined(UI_DISPLAY_CHARSET) || UI_DISPLAY_CHARSET>3
#define UI_DISPLAY_CHARSET 1
#endif

#if UI_DISPLAY_CHARSET==0 // ASCII fallback
#define CHAR_RIGHT '-'
#define CHAR_SELECTOR '>'
#define CHAR_SELECTED '*'
#define STR_auml "ae"
#define STR_Auml "Ae"
#define STR_uuml "ue"
#define STR_Uuml "Ue"
#define STR_ouml "oe"
#define STR_Ouml "Oe"
#define STR_szlig "ss"
#endif

#if UI_DISPLAY_CHARSET==1 // HD44870 charset with knji chars
#define CHAR_RIGHT 0x7e
#define CHAR_SELECTOR '>'
#define CHAR_SELECTED '*'
#define STR_auml "\xe1"
#define STR_Auml "Ae"
#define STR_uuml "\365"
#define STR_Uuml "Ue"
#define STR_ouml "\357"
#define STR_Ouml "Oe"
#define STR_szlig "\342"
#endif

#if UI_DISPLAY_CHARSET==2 // Western charset
#define CHAR_RIGHT 0xbc
#define CHAR_SELECTOR 0xf6
#define CHAR_SELECTED '*'
#define STR_auml "\204"
#define STR_Auml "\216"
#define STR_uuml "\201"
#define STR_Uuml "\212"
#define STR_ouml "\204"
#define STR_Ouml "\211"
#define STR_szlig "160"
#endif


#if UI_DISPLAY_CHARSET==3 // U8glib
#define CHAR_RIGHT 187 //>>
#define CHAR_SELECTOR 255 //'>'
#define CHAR_SELECTED 254 //'*'
#define STR_auml "\344"
#define STR_Auml "\304"
#define STR_uuml "\374"
#define STR_Uuml "\334"
#define STR_ouml "\366"
#define STR_Ouml "\326"
#define STR_szlig "\337"
#endif
#define TEST176 "176\260\261\262\263\264\265\266\267\270\271\272\273\274\275\276\277"
#define TEST192 "192\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317"
#define TEST208 "208\320\321\322\323\324\325\326\327\330\331\332\333\334\335\336\337"
#define TEST224 "224\340\341\342\343\344\345\346\347\350\351\352\353\354\355\356\357"


// At first all terms in english are defined. After that the selected language
// can overwrite the definition. That way new strings are at least in english
// available.

#define UI_TEXT_ON               "On"
#define UI_TEXT_OFF              "Off"
#define UI_TEXT_NA               "N/A" // Output for not available
#define UI_TEXT_YES              "Yes"
#define UI_TEXT_NO               "No"
#define UI_TEXT_SEL              "\003"
#define UI_TEXT_NOSEL            "\004"
#define UI_TEXT_PRINT_POS        "Printing..."
#define UI_TEXT_PRINTING         "Printing"
#define UI_TEXT_IDLE             "Idle"
#define UI_TEXT_NOSDCARD         "No SD Card"
#define UI_TEXT_ERROR            "**** ERROR ****"
#define UI_TEXT_BACK             "Back \001"
#define UI_TEXT_QUICK_SETTINGS   "Quick Settings"
#define UI_TEXT_CONFIGURATION    "Configuration"
#define UI_TEXT_POSITION         "Position"
#define UI_TEXT_EXTRUDER         "Extruder"
#define UI_TEXT_SD_CARD          "SD Card"
#define UI_TEXT_DEBUGGING        "Debugging"
#define UI_TEXT_HOME_DELTA       "Home Delta"
#define UI_TEXT_HOME_ALL         "Home All"
#define UI_TEXT_HOME_X           "Home X"
#define UI_TEXT_HOME_Y           "Home Y"
#define UI_TEXT_HOME_Z           "Home Z"
#define UI_TEXT_PREHEAT_PLA      "Preheat PLA"
#define UI_TEXT_PREHEAT_ABS      "Preheat ABS"
#define UI_TEXT_LIGHTS_ONOFF     "Lights :%lo"
#define UI_TEXT_COOLDOWN         "Cooldown"
#define UI_TEXT_SET_TO_ORIGIN    "Set to Origin"
#define UI_TEXT_DISABLE_STEPPER  "Disable stepper"
#define UI_TEXT_X_POSITION       "X Position"
#define UI_TEXT_X_POS_FAST       "X Pos. Fast"
#define UI_TEXT_Y_POSITION       "Y Position"
#define UI_TEXT_Y_POS_FAST       "Y Pos. Fast"
#define UI_TEXT_Z_POSITION       "Z Position"
#define UI_TEXT_Z_POS_FAST       "Z Pos. Fast"
#define UI_TEXT_E_POSITION       "Extr. position"
#define UI_TEXT_BED_TEMP         "Bed Temp.:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0  :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1  :%E1\002C"
#define UI_TEXT_EXTR2_TEMP       "Temp. 2  :%E2\002C"
#define UI_TEXT_EXTR0_OFF        "Extruder 0 Off"
#define UI_TEXT_EXTR1_OFF        "Extruder 1 Off"
#define UI_TEXT_EXTR2_OFF        "Extruder 2 Off"
#define UI_TEXT_EXTR0_SELECT     "%X0 Select Extr.0"
#define UI_TEXT_EXTR1_SELECT     "%X1 Select Extr.1"
#define UI_TEXT_EXTR2_SELECT     "%X2 Select Extr.2"
#define UI_TEXT_EXTR_ORIGIN      "Set Origin"
#define UI_TEXT_PRINT_X          "Print X:%ax"
#define UI_TEXT_PRINT_Y          "Print Y:%ay"
#define UI_TEXT_PRINT_Z          "Print Z:%az"
#define UI_TEXT_PRINT_Z_DELTA    "Print:%az"
#define UI_TEXT_MOVE_X           "Move X :%aX"
#define UI_TEXT_MOVE_Y           "Move Y :%aY"
#define UI_TEXT_MOVE_Z           "Move Z :%aZ"
#define UI_TEXT_MOVE_Z_DELTA     "Move:%aZ"
#define UI_TEXT_JERK             "Jerk   :%aj"
#define UI_TEXT_ZJERK            "Z-Jerk :%aJ"
#define UI_TEXT_ACCELERATION     "Acceleration"
#define UI_TEXT_STORE_TO_EEPROM  "Store to EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Load f. EEPROM"
#define UI_TEXT_DBG_ECHO         "Echo   :%do"
#define UI_TEXT_DBG_INFO         "Info   :%di"
#define UI_TEXT_DBG_ERROR        "Errors :%de"
#define UI_TEXT_DBG_DRYRUN       "Dry run:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Off"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Classic"
#define UI_TEXT_OPS_FAST         "%O2 OPS Fast"
#define UI_TEXT_OPS_RETRACT      "Retract   :%Or"
#define UI_TEXT_OPS_BACKSLASH    "Backsl.   :%Ob"
#define UI_TEXT_OPS_MINDIST      "Min.dist  :%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Move after:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti Ooze"
#define UI_TEXT_PRINT_FILE       "Print file"
#define UI_TEXT_PAUSE_PRINT      "Pause Print"
#define UI_TEXT_CONTINUE_PRINT   "Continue Print"
#define UI_TEXT_UNMOUNT_CARD     "Unmount Card"
#define UI_TEXT_MOUNT_CARD       "Mount Card"
#define UI_TEXT_DELETE_FILE      "Delete file"
#define UI_TEXT_FEEDRATE         "Feedrate"
#define UI_TEXT_FEED_MAX_X       "Max X:%fx"
#define UI_TEXT_FEED_MAX_Y       "Max Y:%fy"
#define UI_TEXT_FEED_MAX_Z       "Max Z:%fz"
#define UI_TEXT_FEED_MAX_Z_DELTA "Max:%fz"
#define UI_TEXT_FEED_HOME_X      "Home X:%fX"
#define UI_TEXT_FEED_HOME_Y      "Home Y:%fY"
#define UI_TEXT_FEED_HOME_Z      "Home Z:%fZ"
#define UI_TEXT_FEED_HOME_Z_DELTA "Home:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Min endstop:%sx","Max endstop:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Min endstop:%sy","Max endstop:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Min endstop:%sz","Max endstop:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Min endstop:%sx","Max endstop:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Min endstop:%sy","Max endstop:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Min endstop:%sz","Max endstop:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 click = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "Fan speed"
#define UI_TEXT_ACTION_FANSPEED   "Fan speed:%Fs%%%"
#define UI_TEXT_FAN_OFF           "Turn Fan Off"
#define UI_TEXT_FAN_25            "Set Fan 25%%%"
#define UI_TEXT_FAN_50            "Set Fan 50%%%"
#define UI_TEXT_FAN_75            "Set Fan 75%%%"
#define UI_TEXT_FAN_FULL          "Set Fan Full"
#define UI_TEXT_STEPPER_INACTIVE  "Stepper Inactive"
#define UI_TEXT_STEPPER_INACTIVE2 "Dis. After:%is","[s] 0=Off"
#define UI_TEXT_POWER_INACTIVE    "Max. Inactive"
#define UI_TEXT_POWER_INACTIVE2   "Dis. After:%ip","[s] 0=Off"
#define UI_TEXT_GENERAL           "General"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Steps/MM:%Se"
#define UI_TEXT_EXTR_START_FEED   "Start FR:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Max FR:%XF"
#define UI_TEXT_EXTR_ACCEL        "Accel:%XA"
#define UI_TEXT_EXTR_WATCH        "Stab.Time:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Advance lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Advance quad:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Control:%Xh"
#define UI_TEXT_EXTR_PGAIN        "DT/PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "X-Offset:%Xx"
#define UI_TEXT_EXTR_YOFF         "Y-Offset:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Action:%la"
#define UI_TEXT_HEATING_EXTRUDER  "Heating Extruder"
#define UI_TEXT_HEATING_BED       "Heating Bed"
#define UI_TEXT_KILLED            "Killed"
#define UI_TEXT_STEPPER_DISABLED  "Stepper Disabled"
#define UI_TEXT_EEPROM_STORED     "Configuration","stored in EEPROM"
#define UI_TEXT_EEPROM_LOADED     "Configuration","loaded f. EEPROM"
#define UI_TEXT_UPLOADING         "Uploading..."
#define UI_TEXT_PAGE_BUFFER       "Buffer:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "B:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Speed Mul.:%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Flow Mul. :%of%%%"
#define UI_TEXT_SHOW_MEASUREMENT  "Show meas."
#define UI_TEXT_RESET_MEASUREMENT "Reset meas."
#define UI_TEXT_SET_MEASURED_ORIGIN "Set Z=0"
#define UI_TEXT_ZCALIB             "Z Calib."
#define UI_TEXT_SET_P1            "Set P1"
#define UI_TEXT_SET_P2            "Set P2"
#define UI_TEXT_SET_P3	          "Set P3"
#define UI_TEXT_CALCULATE_LEVELING "Calculate Leveling"
#define UI_TEXT_LEVEL             "Level delta"
#define UI_TEXT_EXTR_WAIT_RETRACT_TEMP "Wait Temp. %XT\002C"
#define UI_TEXT_EXTR_WAIT_RETRACT_UNITS "Wait Units: %XU mm"
#define UI_TEXT_SD_REMOVED       "SD Card removed"
#define UI_TEXT_SD_INSERTED      "SD Card inserted"
#define UI_TEXT_PRINTER_READY    "Printer ready."
// Printtime output gets aggregated like <Days_5gisgits>UI_TEXT_PRINTTIME_DAYS<Hours>UI_TEXT_PRINTTIME_HOURS<Minutes>UI_TEXT_PRINTTIME_MINUTES
// ___88 days 12:45
#define UI_TEXT_PRINTTIME_DAYS   " days "
#define UI_TEXT_PRINTTIME_HOURS  ":"
#define UI_TEXT_PRINTTIME_MINUTES ""
#define UI_TEXT_PRINT_TIME     "Printing time"
#define UI_TEXT_PRINT_FILAMENT "Filament printed"
#define UI_TEXT_POWER            "ATX power on/off"
#define UI_TEXT_STRING_HM_DEADTIME     "Dead Time"
#define UI_TEXT_STRING_HM_SLOWBANG     "SlowBang"
#define UI_TEXT_STOP_PRINT "Stop Print"
#define UI_TEXT_Z_BABYSTEPPING "Z Babystepping"

// *************** German translation ****************

#if UI_LANGUAGE==1

#define UI_TEXT_ON               "An"
#define UI_TEXT_OFF              "Aus"
#define UI_TEXT_NA               "nv"
#define UI_TEXT_YES              "Ja"
#define UI_TEXT_NO               "Nein"
#define UI_TEXT_PRINT_POS        "Drucke..."
#define UI_TEXT_PRINTING         "Drucken"
#define UI_TEXT_IDLE             "Leerlauf"
#define UI_TEXT_NOSDCARD         "Keine SD Karte"
#define UI_TEXT_ERROR            "**** FEHLER ****"
#define UI_TEXT_BACK             "Zur" STR_uuml "ck \001"
#define UI_TEXT_QUICK_SETTINGS   "Schnelleinst."
#define UI_TEXT_CONFIGURATION    "Konfiguration"
#define UI_TEXT_POSITION         "Position"
#define UI_TEXT_EXTRUDER         "Extruder"
#define UI_TEXT_SD_CARD          "SD Karte"
#define UI_TEXT_DEBUGGING        "Debugging"
#define UI_TEXT_HOME_ALL         "Home Alle"
#define UI_TEXT_HOME_X           "Home X"
#define UI_TEXT_HOME_Y           "Home Y"
#define UI_TEXT_HOME_Z           "Home Z"
#define UI_TEXT_PREHEAT_PLA      "Vorheizen PLA"
#define UI_TEXT_PREHEAT_ABS      "Vorheizen ABS"
#define UI_TEXT_LIGHTS_ONOFF     "Lampen: %lo"
#define UI_TEXT_COOLDOWN         "Abk" STR_uuml "hlen"
#define UI_TEXT_SET_TO_ORIGIN    "Setze Nullpunkt"
#define UI_TEXT_DISABLE_STEPPER  "Motoren Aussch."
#define UI_TEXT_X_POSITION       "X Position"
#define UI_TEXT_X_POS_FAST       "X Pos. Schnell"
#define UI_TEXT_Y_POSITION       "Y Position"
#define UI_TEXT_Y_POS_FAST       "Y Pos. Schnell"
#define UI_TEXT_Z_POSITION       "Z Position"
#define UI_TEXT_Z_POS_FAST       "Z Pos. Schnell"
#define UI_TEXT_E_POSITION       "Extr. Position"
#define UI_TEXT_BED_TEMP         "Bed Temp.:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0  :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1  :%E1\002C"
#define UI_TEXT_EXTR2_TEMP       "Temp. 2  :%E2\002C"
#define UI_TEXT_EXTR0_OFF        "Extruder 0 Aus"
#define UI_TEXT_EXTR1_OFF        "Extruder 1 Aus"
#define UI_TEXT_EXTR2_OFF        "Extruder 2 Aus"
#define UI_TEXT_EXTR0_SELECT     "W" STR_auml "hle Extr. 0"
#define UI_TEXT_EXTR1_SELECT     "W" STR_auml "hle Extr. 1"
#define UI_TEXT_EXTR2_SELECT     "W" STR_auml "hle Extr. 2"
#define UI_TEXT_EXTR_ORIGIN      "Setze Nullpunkt"
#define UI_TEXT_PRINT_X          "Drucken X:%ax"
#define UI_TEXT_PRINT_Y          "Drucken Y:%ay"
#define UI_TEXT_PRINT_Z          "Drucken Z:%az"
#define UI_TEXT_PRINT_Z_DELTA    "Drucken:%az"
#define UI_TEXT_MOVE_X           "Bewegen X:%aX"
#define UI_TEXT_MOVE_Y           "Bewegen Y:%aY"
#define UI_TEXT_MOVE_Z           "Bewegen Z:%aZ"
#define UI_TEXT_MOVE_Z_DELTA     "Bewegen:%aZ"
#define UI_TEXT_JERK             "Ruck     :%aj"
#define UI_TEXT_ZJERK            "Z-Ruck   :%aJ"
#define UI_TEXT_ACCELERATION     "Beschleunigung"
#define UI_TEXT_STORE_TO_EEPROM  "Sichere EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Lade vom EEPROM"
#define UI_TEXT_DBG_ECHO         "Echo       :%do"
#define UI_TEXT_DBG_INFO         "Info       :%di"
#define UI_TEXT_DBG_ERROR        "Fehler     :%de"
#define UI_TEXT_DBG_DRYRUN       "Trockenlauf:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Aus"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Klassisch"
#define UI_TEXT_OPS_FAST         "%O2 OPS Schnell"
#define UI_TEXT_OPS_RETRACT      "Einfahren :%Or"
#define UI_TEXT_OPS_BACKSLASH    "Backsl.   :%Ob"
#define UI_TEXT_OPS_MINDIST      "Min.Abst. :%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Start nach:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti Ooze"
#define UI_TEXT_PRINT_FILE       "Drucke Datei"
#define UI_TEXT_PAUSE_PRINT      "Druck Pausieren"
#define UI_TEXT_CONTINUE_PRINT   "Druck Forts."
#define UI_TEXT_UNMOUNT_CARD     "Unmount Karte"
#define UI_TEXT_MOUNT_CARD       "Mount Karte"
#define UI_TEXT_DELETE_FILE      "Datei l" STR_ouml "schen"
#define UI_TEXT_FEED_MAX_X       "Max X:%fx"
#define UI_TEXT_FEED_MAX_Y       "Max Y:%fy"
#define UI_TEXT_FEED_MAX_Z       "Max Z:%fz"
#define UI_TEXT_FEED_MAX_Z_DELTA "Max:%fz"
#define UI_TEXT_FEED_HOME_X      "Home X:%fX"
#define UI_TEXT_FEED_HOME_Y      "Home Y:%fY"
#define UI_TEXT_FEED_HOME_Z      "Home Z:%fZ"
#define UI_TEXT_FEED_HOME_Z_DELTA "Home:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Min Endstopp:%sx","Max Endstopp:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Min Endstopp:%sy","Max Endstopp:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Min Endstopp:%sz","Max Endstopp:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Min Endstopp:%sx","Max Endstopp:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Min Endstopp:%sy","Max Endstopp:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Min Endstopp:%sz","Max Endstopp:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 klick = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "L" STR_uuml "fter"
#define UI_TEXT_ACTION_FANSPEED   "L" STR_uuml "fter:%Fs%%%"
#define UI_TEXT_FAN_OFF           "L" STR_uuml "fter Aus"
#define UI_TEXT_FAN_25            "L" STR_uuml "fter auf 25%%%"
#define UI_TEXT_FAN_50            "L" STR_uuml "fter auf 50%%%"
#define UI_TEXT_FAN_75            "L" STR_uuml "fter auf 75%%%"
#define UI_TEXT_FAN_FULL          "L" STR_uuml "fter Voll"
#define UI_TEXT_STEPPER_INACTIVE  "Motor Inaktiv"
#define UI_TEXT_STEPPER_INACTIVE2 "Aus nach:%is","[s] 0=Aus"
#define UI_TEXT_POWER_INACTIVE    "Max. Inaktiv"
#define UI_TEXT_POWER_INACTIVE2   "Aus nach:%ip","[s] 0=Aus"
#define UI_TEXT_GENERAL           "Allgemein"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Schr/MM:%Se"
#define UI_TEXT_EXTR_START_FEED   "Start FR:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Max FR:%XF"
#define UI_TEXT_EXTR_ACCEL        "Beschl.:%XA"
#define UI_TEXT_EXTR_WATCH        "Stab.Zeit:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Advance lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Advance quad:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Regler:%Xh"
#define UI_TEXT_EXTR_PGAIN        "DT/PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "X-Offset:%Xx"
#define UI_TEXT_EXTR_YOFF         "Y-Offset:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Aktion:%la"
#define UI_TEXT_HEATING_EXTRUDER  "Heize Extruder"
#define UI_TEXT_HEATING_BED       "Heize Druckbett"
#define UI_TEXT_KILLED            "Angehalten"
#define UI_TEXT_STEPPER_DISABLED  "Motoren Aus"
#define UI_TEXT_EEPROM_STORED     "Konfiguration","gespeichert."
#define UI_TEXT_EEPROM_LOADED     "Konfiguration","geladen."
#define UI_TEXT_UPLOADING         "Hochladen..."
#define UI_TEXT_PAGE_BUFFER       "Puffer:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "B:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Geschw.Mul:%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Flow Mul.:%of%%%"
#define UI_TEXT_ADVANCE_L         "Advance lin:%Xl"
#define UI_TEXT_ADVANCE_K         "Advance quad:%Xa"
#define UI_TEXT_SHOW_MEASUREMENT  "Zeige Messung"
#define UI_TEXT_RESET_MEASUREMENT "Reset Messung"
#define UI_TEXT_SET_MEASURED_ORIGIN "Setze Z=0"
#define UI_TEXT_ZCALIB			  "Z Calib."
#define UI_TEXT_SET_P1			  "Setze P1"
#define UI_TEXT_SET_P2			  "Setze P2"
#define UI_TEXT_SET_P3			  "Setze P3"
#define UI_TEXT_CALCULATE_LEVELING "Berechne Leveling"
#define UI_TEXT_LEVEL			  "Level delta"
#define UI_TEXT_EXTR_WAIT_RETRACT_TEMP  "Wait Temp.%XT\002C"
#define UI_TEXT_EXTR_WAIT_RETRACT_UNITS "Wait Units:%XUmm"
#define UI_TEXT_SD_REMOVED       "Karte entfernt"
#define UI_TEXT_SD_INSERTED      "Karte eingelegt"
#define UI_TEXT_PRINTER_READY    "\007 %PN bereit."
// Printtime output gets aggregated like <Days_5gisgits>UI_TEXT_PRINTTIME_DAYS<Hours>UI_TEXT_PRINTTIME_HOURS<Minutes>UI_TEXT_PRINTTIME_MINUTES
// ___88 days 12:45
#define UI_TEXT_PRINTTIME_DAYS   " Tage "
#define UI_TEXT_PRINTTIME_HOURS  ":"
#define UI_TEXT_PRINTTIME_MINUTES ""
#define UI_TEXT_PRINT_TIME     "Ges. Druckzeit"
#define UI_TEXT_PRINT_FILAMENT "Filament gedruckt"
#define UI_TEXT_POWER            "ATX Netzteil an/aus"
#define UI_TEXT_STRING_HM_DEADTIME     "Totzeit"
#define UI_TEXT_STRING_HM_SLOWBANG     "Langs.BB"
#define UI_TEXT_STOP_PRINT "Druck abbrechen"
#define UI_TEXT_Z_BABYSTEPPING "Z Babyschritte"

#endif

// Dutch translation
#if UI_LANGUAGE==2

#define UI_TEXT_ON               "Aan"
#define UI_TEXT_OFF              "Uit"
#define UI_TEXT_NA               "N/A" // Output for not available
#define UI_TEXT_YES              "Ja"
#define UI_TEXT_NO               "Nee"
#define UI_TEXT_SEL              "\003"
#define UI_TEXT_NOSEL            "\004"
#define UI_TEXT_PRINT_POS        "Printen..."
#define UI_TEXT_PRINTING         "Printen"
#define UI_TEXT_IDLE             "Rust"
#define UI_TEXT_NOSDCARD         "Geen SD Kaart"
#define UI_TEXT_ERROR            "**** FOUT ****"
#define UI_TEXT_BACK             "Terug \001"
#define UI_TEXT_QUICK_SETTINGS   "Snel Instelling"
#define UI_TEXT_CONFIGURATION    "Configuratie"
#define UI_TEXT_POSITION         "Positie"
#define UI_TEXT_EXTRUDER         "Extruder"
#define UI_TEXT_SD_CARD          "SD Kaart"
#define UI_TEXT_DEBUGGING        "Debugging"
#define UI_TEXT_HOME_ALL         "Home Alles"
#define UI_TEXT_HOME_X           "Home X"
#define UI_TEXT_HOME_Y           "Home Y"
#define UI_TEXT_HOME_Z           "Home Z"
#define UI_TEXT_PREHEAT          "Voorverwarmen"
#define UI_TEXT_COOLDOWN         "Koelen"
#define UI_TEXT_SET_TO_ORIGIN    "Zet oorsprong"
#define UI_TEXT_DISABLE_STEPPER  "Zet motor uit"
#define UI_TEXT_X_POSITION       "X Positie"
#define UI_TEXT_X_POS_FAST       "X Pos. Snel"
#define UI_TEXT_Y_POSITION       "Y Positie"
#define UI_TEXT_Y_POS_FAST       "Y Pos. Snel"
#define UI_TEXT_Z_POSITION       "Z Positie"
#define UI_TEXT_Z_POS_FAST       "Z Pos. Snel"
#define UI_TEXT_E_POSITION       "Extr. positie"
#define UI_TEXT_BED_TEMP         "Bed Temp.:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0  :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1  :%E1\002C"
#define UI_TEXT_EXTR2_TEMP       "Temp. 2  :%E2\002C"
#define UI_TEXT_EXTR0_OFF        "Extruder 0 Uit"
#define UI_TEXT_EXTR1_OFF        "Extruder 1 Uit"
#define UI_TEXT_EXTR2_OFF        "Extruder 2 Uit"
#define UI_TEXT_EXTR0_SELECT     "%X0 Select Extr.0"
#define UI_TEXT_EXTR1_SELECT     "%X1 Select Extr.1"
#define UI_TEXT_EXTR2_SELECT     "%X2 Select Extr.2"
#define UI_TEXT_EXTR_ORIGIN      "Zet oorsprong"
#define UI_TEXT_PRINT_X          "Print X:%ax"
#define UI_TEXT_PRINT_Y          "Print Y:%ay"
#define UI_TEXT_PRINT_Z          "Print Z:%az"
#define UI_TEXT_PRINT_Z_DELTA    "Print:%az"
#define UI_TEXT_MOVE_X           "Beweeg X:%aX"
#define UI_TEXT_MOVE_Y           "Beweeg Y:%aY"
#define UI_TEXT_MOVE_Z           "Beweeg Z:%aZ"
#define UI_TEXT_MOVE_Z_DELTA     "Beweeg:%aZ"
#define UI_TEXT_JERK             "Ruk:%aj"
#define UI_TEXT_ZJERK            "Z-Ruk:%aJ"
#define UI_TEXT_ACCELERATION     "Acceleratie"
#define UI_TEXT_STORE_TO_EEPROM  "Opslaan n. EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Ladd f. EEPROM"
#define UI_TEXT_DBG_ECHO         "Echo     :%do"
#define UI_TEXT_DBG_INFO         "Info     :%di"
#define UI_TEXT_DBG_ERROR        "Fouten   :%de"
#define UI_TEXT_DBG_DRYRUN       "Droogloop:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Uit"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Klassiek"
#define UI_TEXT_OPS_FAST         "%O2 OPS Snel"
#define UI_TEXT_OPS_RETRACT      "Terugtrekken:%Or"
#define UI_TEXT_OPS_BACKSLASH    "Backsl. :%Ob"
#define UI_TEXT_OPS_MINDIST      "Min. afstand:%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Beweeg na:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti lekken"
#define UI_TEXT_PRINT_FILE       "Print bestand"
#define UI_TEXT_PAUSE_PRINT      "Pauzeer Print"
#define UI_TEXT_CONTINUE_PRINT   "Zet print voort"
#define UI_TEXT_UNMOUNT_CARD     "Ontkoppel Kaart"
#define UI_TEXT_MOUNT_CARD       "Koppel Kaart"
#define UI_TEXT_DELETE_FILE      "Verw. bestand"
#define UI_TEXT_FEEDRATE         "Beweeg snelheid"
#define UI_TEXT_FEED_MAX_X       "Max X:%fx"
#define UI_TEXT_FEED_MAX_Y       "Max Y:%fy"
#define UI_TEXT_FEED_MAX_Z       "Max Z:%fz"
#define UI_TEXT_FEED_MAX_Z_DELTA "Max:%fz"
#define UI_TEXT_FEED_HOME_X      "Home X:%fX"
#define UI_TEXT_FEED_HOME_Y      "Home Y:%fY"
#define UI_TEXT_FEED_HOME_Z      "Home Z:%fZ"
#define UI_TEXT_FEED_HOME_Z_DELTA "Home:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Min eindst.:%sx","Max eindst.:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Min eindst.:%sy","Max eindst.:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Min eindst.:%sz","Max eindst.:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Min eindst.:%sx","Max eindst.:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Min eindst.:%sy","Max eindst.:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Min eindst.:%sz","Max eindst.:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 klik = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "Fan snelheid"
#define UI_TEXT_FAN_OFF           "Zet Fan uit"
#define UI_TEXT_FAN_25            "Zet Fan 25%%%"
#define UI_TEXT_FAN_50            "Zet Fan 50%%%"
#define UI_TEXT_FAN_75            "Zet Fan 75%%%"
#define UI_TEXT_FAN_FULL          "Zet Fan Vol aan"
#define UI_TEXT_STEPPER_INACTIVE  "Motor Inactief"
#define UI_TEXT_STEPPER_INACTIVE2 "Uit na:%is","[s] 0=Off"
#define UI_TEXT_POWER_INACTIVE    "Max. Inactief"
#define UI_TEXT_POWER_INACTIVE2   "Zet uit na:%ip","[s] 0=Off"
#define UI_TEXT_GENERAL           "Algemeen"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Stappen/MM:%Se"
#define UI_TEXT_EXTR_START_FEED   "Start FR.:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Max FR.:%XF"
#define UI_TEXT_EXTR_ACCEL        "Accel:%XA"
#define UI_TEXT_EXTR_WATCH        "Stab.Tijd:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Advance lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Advance quad:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Control:%Xh"
#define UI_TEXT_EXTR_PGAIN        "DT/PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "X-Offset:%Xx"
#define UI_TEXT_EXTR_YOFF         "Y-Offset:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Action:%la"
#define UI_TEXT_HEATING_EXTRUDER  "Opwarmen Extru."
#define UI_TEXT_HEATING_BED       "Opwarmen Bed"
#define UI_TEXT_KILLED            "Uitgeschakeld"
#define UI_TEXT_STEPPER_DISABLED  "Motor uitgezet"
#define UI_TEXT_EEPROM_STORED     "Configuratie","saved. in EEPROM"
#define UI_TEXT_EEPROM_LOADED     "Configuratie","loaded f. EEPROM"
#define UI_TEXT_UPLOADING         "Uploaden..."
#define UI_TEXT_PAGE_BUFFER       "Buffer:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "B:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Snelh. Mul.:%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Flow Mul.:%of%%%"

#endif

// *************** Brazilian portuguese translation ****************

#if UI_LANGUAGE==3

#define UI_TEXT_ON               "On"
#define UI_TEXT_OFF              "Off"
#define UI_TEXT_NA               "N/A" // Output for not available
#define UI_TEXT_YES              "Sim"
#define UI_TEXT_NO               "Não"
#define UI_TEXT_SEL              "\003"
#define UI_TEXT_NOSEL            "\004"
#define UI_TEXT_PRINT_POS        "Imprimindo..."
#define UI_TEXT_PRINTING         "Imprimindo"
#define UI_TEXT_IDLE             "Ocioso"
#define UI_TEXT_NOSDCARD         "Nenhum cartao SD"
#define UI_TEXT_ERROR            "**** ERRO ****"
#define UI_TEXT_BACK             "Voltar \001"
#define UI_TEXT_QUICK_SETTINGS   "Configuracoes Rapidas"
#define UI_TEXT_CONFIGURATION    "Configuracao"
#define UI_TEXT_POSITION         "Posicao"
#define UI_TEXT_EXTRUDER         "Extrusor"
#define UI_TEXT_SD_CARD          "Cartao SD"
#define UI_TEXT_DEBUGGING        "Depuracao"
#define UI_TEXT_HOME_ALL         "Home Todos"
#define UI_TEXT_HOME_X           "Home X"
#define UI_TEXT_HOME_Y           "Home Y"
#define UI_TEXT_HOME_Z           "Home Z"
#define UI_TEXT_PREHEAT_PLA      "Pre-aquecer PLA"
#define UI_TEXT_PREHEAT_ABS      "Pre-aquecer ABS"
#define UI_TEXT_COOLDOWN         "Resfriar"
#define UI_TEXT_SET_TO_ORIGIN    "Definir como Origem"
#define UI_TEXT_DISABLE_STEPPER  "Desabilitar motor"
#define UI_TEXT_X_POSITION       "Posicao X"
#define UI_TEXT_X_POS_FAST       "Pos. Rapida X"
#define UI_TEXT_Y_POSITION       "Posicao Y"
#define UI_TEXT_Y_POS_FAST       "Pos. Rapida Y"
#define UI_TEXT_Z_POSITION       "Posicao Z"
#define UI_TEXT_Z_POS_FAST       "Pos. Rapida Z"
#define UI_TEXT_E_POSITION       "Posicao Extrusor"
#define UI_TEXT_BED_TEMP         "Temp. Cama:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0   :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1   :%E1\002C"
#define UI_TEXT_EXTR2_TEMP       "Temp. 2   :%E2\002C"
#define UI_TEXT_EXTR0_OFF        "Extrusor 0 Desligado"
#define UI_TEXT_EXTR1_OFF        "Extrusor 1 Desligado"
#define UI_TEXT_EXTR2_OFF        "Extrusor 2 Desligado"
#define UI_TEXT_EXTR0_SELECT     "%X0 Selecionar Extr.0"
#define UI_TEXT_EXTR1_SELECT     "%X1 Selecionar Extr.1"
#define UI_TEXT_EXTR2_SELECT     "%X2 Selecionar Extr.2"
#define UI_TEXT_EXTR_ORIGIN      "Definir Origem"
#define UI_TEXT_PRINT_X          "Imprimir X:%ax"
#define UI_TEXT_PRINT_Y          "Imprimir Y:%ay"
#define UI_TEXT_PRINT_Z          "Imprimir Z:%az"
#define UI_TEXT_PRINT_Z_DELTA    "Imprimir:%az"
#define UI_TEXT_MOVE_X           "Mover X:%aX"
#define UI_TEXT_MOVE_Y           "Mover Y:%aY"
#define UI_TEXT_MOVE_Z           "Mover Z:%aZ"
#define UI_TEXT_MOVE_Z_DELTA     "Mover:%aZ"
#define UI_TEXT_JERK             "Jerk:%aj"
#define UI_TEXT_ZJERK            "Z-Jerk:%aJ"
#define UI_TEXT_ACCELERATION     "Aceleracao"
#define UI_TEXT_STORE_TO_EEPROM  "Armazenar na EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Carregar da EEPROM"
#define UI_TEXT_DBG_ECHO         "Echo   :%do"
#define UI_TEXT_DBG_INFO         "Info   :%di"
#define UI_TEXT_DBG_ERROR        "Erros :%de"
#define UI_TEXT_DBG_DRYRUN       "Dry run:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Off"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Classic"
#define UI_TEXT_OPS_FAST         "%O2 OPS Fast"
#define UI_TEXT_OPS_RETRACT      "Retract :%Or"
#define UI_TEXT_OPS_BACKSLASH    "Backsl. :%Ob"
#define UI_TEXT_OPS_MINDIST      "Min.dist:%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Move after:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti Ooze"
#define UI_TEXT_PRINT_FILE       "Imprimir arquivo"
#define UI_TEXT_PAUSE_PRINT      "Pausar Impressao"
#define UI_TEXT_CONTINUE_PRINT   "Continuar Impressao"
#define UI_TEXT_UNMOUNT_CARD     "Desmontar Cartao"
#define UI_TEXT_MOUNT_CARD       "Montar Cartao"
#define UI_TEXT_DELETE_FILE      "Deletar arquivo"
#define UI_TEXT_FEEDRATE         "Feedrate"
#define UI_TEXT_FEED_MAX_X       "Max X:%fx"
#define UI_TEXT_FEED_MAX_Y       "Max Y:%fy"
#define UI_TEXT_FEED_MAX_Z       "Max Z:%fz"
#define UI_TEXT_FEED_MAX_Z_DELTA "Max:%fz"
#define UI_TEXT_FEED_HOME_X      "Home X:%fX"
#define UI_TEXT_FEED_HOME_Y      "Home Y:%fY"
#define UI_TEXT_FEED_HOME_Z      "Home Z:%fZ"
#define UI_TEXT_FEED_HOME_Z_DELTA "Home:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Min endstop:%sx","Max endstop:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Min endstop:%sy","Max endstop:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Min endstop:%sz","Max endstop:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Min endstop:%sx","Max endstop:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Min endstop:%sy","Max endstop:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Min endstop:%sz","Max endstop:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 click = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "Velocidade ventoinha"
#define UI_TEXT_FAN_OFF           "Desligar ventoinha"
#define UI_TEXT_FAN_25            "Def. ventoinha 25%%%"
#define UI_TEXT_FAN_50            "Def. ventoinha 50%%%"
#define UI_TEXT_FAN_75            "Def. ventoinha 75%%%"
#define UI_TEXT_FAN_FULL          "Def. ventoinha 100%%%"
#define UI_TEXT_STEPPER_INACTIVE  "Motor Inativo"
#define UI_TEXT_STEPPER_INACTIVE2 "Des. Depois:%is","[s] 0=Off"
#define UI_TEXT_POWER_INACTIVE    "Max. Inativo"
#define UI_TEXT_POWER_INACTIVE2   "Des. Depois:%ip","[s] 0=Off"
#define UI_TEXT_GENERAL           "Geral"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Passos/mm:%Se"
#define UI_TEXT_EXTR_START_FEED   "Iniciar FR:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Max FR:%XF"
#define UI_TEXT_EXTR_ACCEL        "Accel:%XA"
#define UI_TEXT_EXTR_WATCH        "Stab.Time:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Advance lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Advance quad:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Controle:%Xh"
#define UI_TEXT_EXTR_PGAIN        "DT/PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "Offset X:%Xx"
#define UI_TEXT_EXTR_YOFF         "Offset Y:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Acao:%la"
#define UI_TEXT_HEATING_EXTRUDER  "Aquecendo Extrusor"
#define UI_TEXT_HEATING_BED       "Aquecendo Cama"
#define UI_TEXT_KILLED            "Killed"
#define UI_TEXT_STEPPER_DISABLED  "Motor Desabilitado"
#define UI_TEXT_EEPROM_STORED     "Configuracao","armazenada na EEPROM"
#define UI_TEXT_EEPROM_LOADED     "Configuracao","carregada da EEPROM"
#define UI_TEXT_UPLOADING         "Enviando..."
#define UI_TEXT_PAGE_BUFFER       "Buffer:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "B:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Mult. Veloc.:%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Mult. Fluxo:%of%%%"
#define UI_TEXT_EXTR_WAIT_RETRACT_TEMP  "Aguardar Temp.%XT\002C"
#define UI_TEXT_EXTR_WAIT_RETRACT_UNITS "Aguardar Unidades:%XUmm"
#define UI_TEXT_PRINTER_READY    "Impressora pronta."

#endif

// *************** Italian translation ****************
#if UI_LANGUAGE==4

#define UI_TEXT_ON               "On"
#define UI_TEXT_OFF              "Off"
#define UI_TEXT_NA               "N/A" // Output for not available
#define UI_TEXT_YES              "Si"
#define UI_TEXT_NO               "No"
#define UI_TEXT_SEL              "\003"
#define UI_TEXT_NOSEL            "\004"
#define UI_TEXT_PRINT_POS        "Stampa..."
#define UI_TEXT_PRINTING         "Stampa"
#define UI_TEXT_IDLE             "Pausa"
#define UI_TEXT_NOSDCARD         "No Scheda SD"
#define UI_TEXT_ERROR            "**** ERRORE ****"
#define UI_TEXT_BACK             "Indietro \001"
#define UI_TEXT_QUICK_SETTINGS   "Impostazioni veloci"
#define UI_TEXT_CONFIGURATION    "Configurazione"
#define UI_TEXT_POSITION         "Posizione"
#define UI_TEXT_EXTRUDER         "Estrusore"
#define UI_TEXT_SD_CARD          "Scheda SD"
#define UI_TEXT_DEBUGGING        "Sviluppo"
#define UI_TEXT_HOME_ALL         "Origine Tutti"
#define UI_TEXT_HOME_X           "Origine X"
#define UI_TEXT_HOME_Y           "Origine Y"
#define UI_TEXT_HOME_Z           "Origine Z"
#define UI_TEXT_PREHEAT_PLA      "Presicaldamento PLA"
#define UI_TEXT_PREHEAT_ABS      "Presicaldamento ABS"
#define UI_TEXT_COOLDOWN         "Raffreddamento"
#define UI_TEXT_SET_TO_ORIGIN    "Imposta come Origine"
#define UI_TEXT_DISABLE_STEPPER  "Disabilita stepper"
#define UI_TEXT_X_POSITION       "Posizione X"
#define UI_TEXT_X_POS_FAST       "Pos. X Veloce"
#define UI_TEXT_Y_POSITION       "Posizione Y"
#define UI_TEXT_Y_POS_FAST       "Pos. Y Veloce"
#define UI_TEXT_Z_POSITION       "Posizione Z"
#define UI_TEXT_Z_POS_FAST       "Pos. Z Veloce"
#define UI_TEXT_E_POSITION       "Posizione Estrusore"
#define UI_TEXT_BED_TEMP         "Temp. Piatto:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0  :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1  :%E1\002C"
#define UI_TEXT_EXTR2_TEMP       "Temp. 2  :%E2\002C"
#define UI_TEXT_EXTR0_OFF        "Estrusore 0 Spento"
#define UI_TEXT_EXTR1_OFF        "Estrusore 1 Spento"
#define UI_TEXT_EXTR2_OFF        "Estrusore 2 Spento"
#define UI_TEXT_EXTR0_SELECT     "%X0 Seleziona Estr.0"
#define UI_TEXT_EXTR1_SELECT     "%X1 Seleziona Estr.1"
#define UI_TEXT_EXTR2_SELECT     "%X2 Seleziona Estr.2"
#define UI_TEXT_EXTR_ORIGIN      "Imposta Origine"
#define UI_TEXT_PRINT_X          "Stampa X:%ax"
#define UI_TEXT_PRINT_Y          "Stampa Y:%ay"
#define UI_TEXT_PRINT_Z          "Stampa Z:%az"
#define UI_TEXT_PRINT_Z_DELTA    "Stampa:%az"
#define UI_TEXT_MOVE_X           "Movimento X:%aX"
#define UI_TEXT_MOVE_Y           "Movimento Y:%aY"
#define UI_TEXT_MOVE_Z           "Movimento Z:%aZ"
#define UI_TEXT_MOVE_Z_DELTA     "Movimento:%aZ"
#define UI_TEXT_JERK             "Scatto:%aj"
#define UI_TEXT_ZJERK            "Scatto-Z:%aJ"
#define UI_TEXT_ACCELERATION     "Accelerazione"
#define UI_TEXT_STORE_TO_EEPROM  "Salva in EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Carica da EEPROM"
#define UI_TEXT_DBG_ECHO         "Eco   :%do"
#define UI_TEXT_DBG_INFO         "Info   :%di"
#define UI_TEXT_DBG_ERROR        "Errori :%de"
#define UI_TEXT_DBG_DRYRUN       "Simulazione:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Spento"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Classico"
#define UI_TEXT_OPS_FAST         "%O2 OPS Veloce"
#define UI_TEXT_OPS_RETRACT      "Ritiro :%Or"
#define UI_TEXT_OPS_BACKSLASH    "Gioco barra:%Ob"
#define UI_TEXT_OPS_MINDIST      "Distanza Min.:%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Movimento dopo:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti goccia"
#define UI_TEXT_PRINT_FILE       "Stampa file"
#define UI_TEXT_PAUSE_PRINT      "Pausa Stampa"
#define UI_TEXT_CONTINUE_PRINT   "Continua Stampa"
#define UI_TEXT_UNMOUNT_CARD     "Scarica Scheda"
#define UI_TEXT_MOUNT_CARD       "Carica Scheda"
#define UI_TEXT_DELETE_FILE      "Cancella file"
#define UI_TEXT_FEEDRATE         "Velocita'"
#define UI_TEXT_FEED_MAX_X       "Massimo X:%fx"
#define UI_TEXT_FEED_MAX_Y       "Massimo Y:%fy"
#define UI_TEXT_FEED_MAX_Z       "Massimo Z:%fz"
#define UI_TEXT_FEED_MAX_Z_DELTA "Massimo:%fz"
#define UI_TEXT_FEED_HOME_X      "Origine X:%fX"
#define UI_TEXT_FEED_HOME_Y      "Origine Y:%fY"
#define UI_TEXT_FEED_HOME_Z      "Origine Z:%fZ"
#define UI_TEXT_FEED_HOME_Z_DELTA "Origine:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Min finec.:%sx","Max finec.:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Min finec.:%sy","Max finec.:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Min finec.:%sz","Max finec.:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Min finec.:%sx","Max finec.:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Min finec.:%sy","Max finec.:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Min finec.:%sz","Max finec.:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 scatto = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "Velocita' Ventola"
#define UI_TEXT_FAN_OFF           "Spegnimento Ventola"
#define UI_TEXT_FAN_25            "Ventola al 25%%%"
#define UI_TEXT_FAN_50            "Ventola al%%%"
#define UI_TEXT_FAN_75            "Ventola al%%%"
#define UI_TEXT_FAN_FULL          "Ventola al massimo"
#define UI_TEXT_STEPPER_INACTIVE  "Stepper Inattivi"
#define UI_TEXT_STEPPER_INACTIVE2 "Dis. dopo:%is","[s] 0=Off"
#define UI_TEXT_POWER_INACTIVE    "Max. Inattivita'"
#define UI_TEXT_POWER_INACTIVE2   "Dis. After:%ip","[s] 0=Off"
#define UI_TEXT_GENERAL           "Generale"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Passi/mm:%Se"
#define UI_TEXT_EXTR_START_FEED   "Velocita' Avvio:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Velocita' Max:%XF"
#define UI_TEXT_EXTR_ACCEL        "Accel:%XA"
#define UI_TEXT_EXTR_WATCH        "Tempo Stab.:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Avanzamento lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Avanzamento espon:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Controllo:%Xh"
#define UI_TEXT_EXTR_PGAIN        "DT/PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "X-Offset:%Xx"
#define UI_TEXT_EXTR_YOFF         "Y-Offset:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Azione:%la"
#define UI_TEXT_HEATING_EXTRUDER  "Riscald. Estrusore"
#define UI_TEXT_HEATING_BED       "Riscald. Piatto"
#define UI_TEXT_KILLED            "Abortito"
#define UI_TEXT_STEPPER_DISABLED  "Stepper Disabilitato"
#define UI_TEXT_EEPROM_STORED     "Configurazione","Salvata in EEPROM"
#define UI_TEXT_EEPROM_LOADED     "Configurazione","Caricata da EEPROM"
#define UI_TEXT_UPLOADING         "Caricamento..."
#define UI_TEXT_PAGE_BUFFER       "Tampone:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "P:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Molt. Velocita':%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Molt. Flusso:%of%%%"
#define UI_TEXT_EXTR_WAIT_RETRACT_TEMP  "Attesa Temp.%XT\002C"
#define UI_TEXT_EXTR_WAIT_RETRACT_UNITS "Attesa Unita':%XUmm"
#define UI_TEXT_PRINTER_READY    "Stampante pronta."

#endif

#if UI_LANGUAGE==5  // Spanish translation

#define UI_TEXT_ON               "On"
#define UI_TEXT_OFF              "Off"
#define UI_TEXT_NA               "N/A" // Output for not available
#define UI_TEXT_YES              "Si"
#define UI_TEXT_NO               "No"
#define UI_TEXT_SEL              "\003"
#define UI_TEXT_NOSEL            "\004"
#define UI_TEXT_PRINT_POS        "Imprimiendo..."
#define UI_TEXT_PRINTING         "Imprimiendo"
#define UI_TEXT_IDLE             "Idle"
#define UI_TEXT_NOSDCARD         "Sin tarjeta SD"
#define UI_TEXT_ERROR            "**** ERROR ****"
#define UI_TEXT_BACK             "Atras \001"
#define UI_TEXT_QUICK_SETTINGS   "Configuracion Rapida"
#define UI_TEXT_CONFIGURATION    "Configuracion"
#define UI_TEXT_POSITION         "Posicion"
#define UI_TEXT_EXTRUDER         "Extrusor"
#define UI_TEXT_SD_CARD          "Tarjeta SD"
#define UI_TEXT_DEBUGGING        "Debugging"
#define UI_TEXT_HOME_ALL         "Todo Home"
#define UI_TEXT_HOME_X           "X Home"
#define UI_TEXT_HOME_Y           "Y Home"
#define UI_TEXT_HOME_Z           "Z Home"
#define UI_TEXT_PREHEAT_PLA      "Precalentar PLA"
#define UI_TEXT_PREHEAT_ABS      "Precalentar ABS"
#define UI_TEXT_COOLDOWN         "Enfriar"
#define UI_TEXT_SET_TO_ORIGIN    "Fija a origen"
#define UI_TEXT_DISABLE_STEPPER  "Desactiva motor"
#define UI_TEXT_X_POSITION       "Posicion X"
#define UI_TEXT_X_POS_FAST       "Pos. Rapida X"
#define UI_TEXT_Y_POSITION       "Posicion Y"
#define UI_TEXT_Y_POS_FAST       "Pos. Rapida Y"
#define UI_TEXT_Z_POSITION       "Posicion Z"
#define UI_TEXT_Z_POS_FAST       "Pos. Rapida Z"
#define UI_TEXT_E_POSITION       "Extr. Posicion"
#define UI_TEXT_BED_TEMP         "Temp. Cama:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0  :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1  :%E1\002C"
#define UI_TEXT_EXTR0_OFF        "Extrusor 0 Off"
#define UI_TEXT_EXTR1_OFF        "Extrusor 1 Off"
#define UI_TEXT_EXTR0_SELECT     "%X0 Select Extr.0"
#define UI_TEXT_EXTR1_SELECT     "%X1 Select Extr.1"
#define UI_TEXT_EXTR_ORIGIN      "Fija Originen"
#define UI_TEXT_PRINT_X          "Print X:%ax"
#define UI_TEXT_PRINT_Y          "Print Y:%ay"
#define UI_TEXT_PRINT_Z          "Print Z:%az"
#define UI_TEXT_PRINT_Z_DELTA    "Print:%az"
#define UI_TEXT_MOVE_X           "Mueve X:%aX"
#define UI_TEXT_MOVE_Y           "Mueve Y:%aY"
#define UI_TEXT_MOVE_Z           "Mueve Z:%aZ"
#define UI_TEXT_MOVE_Z_DELTA     "Mueve:%aZ"
#define UI_TEXT_JERK             "Jerk:%aj"
#define UI_TEXT_ZJERK            "Z-Jerk:%aJ"
#define UI_TEXT_ACCELERATION     "Aceleracion"
#define UI_TEXT_STORE_TO_EEPROM  "Almacena en EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Carga de EEPROM"
#define UI_TEXT_DBG_ECHO         "Echo   :%do"
#define UI_TEXT_DBG_INFO         "Info   :%di"
#define UI_TEXT_DBG_ERROR        "Errors :%de"
#define UI_TEXT_DBG_DRYRUN       "Ejecucion vacio:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Off"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Classica"
#define UI_TEXT_OPS_FAST         "%O2 OPS Rapida"
#define UI_TEXT_OPS_RETRACT      "Retraccion :%Or"
#define UI_TEXT_OPS_BACKSLASH    "Backsl. :%Ob"
#define UI_TEXT_OPS_MINDIST      "Min.dist:%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Move after:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti Ooze"
#define UI_TEXT_PRINT_FILE       "Imprimiendo fichero"
#define UI_TEXT_PAUSE_PRINT      "Pausando impresion"
#define UI_TEXT_CONTINUE_PRINT   "Continuando impresion"
#define UI_TEXT_UNMOUNT_CARD     "Desmontando Tarjeta"
#define UI_TEXT_MOUNT_CARD       "Montando Card"
#define UI_TEXT_DELETE_FILE      "Borrando fichero"
#define UI_TEXT_FEEDRATE         "Feedrate"
#define UI_TEXT_FEED_MAX_X       "X Max:%fx"
#define UI_TEXT_FEED_MAX_Y       "Y Max:%fy"
#define UI_TEXT_FEED_MAX_Z       "Z Max:%fz"
#define UI_TEXT_FEED_MAX_Z_DELTA "Max:%fz"
#define UI_TEXT_FEED_HOME_X      "X Home:%fX"
#define UI_TEXT_FEED_HOME_Y      "Y Home:%fY"
#define UI_TEXT_FEED_HOME_Z      "Z Home:%fZ"
#define UI_TEXT_FEED_HOME_Z_DELTA "Home:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Fin Carrera Min:%sx","Max:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Fin Carrera Min:%sy","Max:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Fin Carrera Min:%sz","Max:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Fin Carrera Min:%sx","Max:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Fin Carrera Min:%sy","Max:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Fin Carrera Min:%sz","Max:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 click = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "Velocida ventilador"
#define UI_TEXT_FAN_OFF           "Apaga ventilador"
#define UI_TEXT_FAN_25            "Ventilador al 25%%%"
#define UI_TEXT_FAN_50            "Ventilador al 50%%%"
#define UI_TEXT_FAN_75            "Ventilador al 75%%%"
#define UI_TEXT_FAN_FULL          "Ventilador al 100%%%"
#define UI_TEXT_STEPPER_INACTIVE  "Motor Inactivo"
#define UI_TEXT_STEPPER_INACTIVE2 "Dis. Despues:%is","[s] 0=Off"
#define UI_TEXT_POWER_INACTIVE    "Max. Inactivo"
#define UI_TEXT_POWER_INACTIVE2   "Dis. Despues:%ip","[s] 0=Off"
#define UI_TEXT_GENERAL           "General"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Pasos/MM:%Se"
#define UI_TEXT_EXTR_START_FEED   "Start FR:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Max FR:%XF"
#define UI_TEXT_EXTR_ACCEL        "Acel:%XA"
#define UI_TEXT_EXTR_WATCH        "Tiempo Estab.:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Advance lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Advance quad:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Control:%Xh"
#define UI_TEXT_EXTR_PGAIN        "DT/PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "X-Offset:%Xx"
#define UI_TEXT_EXTR_YOFF         "Y-Offset:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Accion:%la"
#define UI_TEXT_HEATING_EXTRUDER  "Calentando Extrusor"
#define UI_TEXT_HEATING_BED       "Calentando Cama"
#define UI_TEXT_KILLED            "Aborta"
#define UI_TEXT_STEPPER_DISABLED  "Deshabilita motor"
#define UI_TEXT_EEPROM_STORED     "Config.","almacenada en EEPROM"
#define UI_TEXT_EEPROM_LOADED     "Config.","cargada de EEPROM"
#define UI_TEXT_UPLOADING         "Actualizando..."
#define UI_TEXT_PAGE_BUFFER       "Buffer:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "B:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Mult. Velocidad.:%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Mult. Flujo.:%of%%%"
#define UI_TEXT_EXTR_WAIT_RETRACT_TEMP  "Esperando Temp.%XT\002C"
#define UI_TEXT_EXTR_WAIT_RETRACT_UNITS "Esperando Unidad:%XUmm"
#define UI_TEXT_PRINTER_READY    "Impresora Lista."

#endif

// *************** Swedish translation ****************
// By Daniel Tedenljung 2013-08-21
#if UI_LANGUAGE==6
#define UI_TEXT_ON               "P" STR_uuml ""
#define UI_TEXT_OFF              "Av"
#define UI_TEXT_NA               "N/A" // Output for not available
#define UI_TEXT_YES              "Ja"
#define UI_TEXT_NO               "Nej"
#define UI_TEXT_SEL              "\003"
#define UI_TEXT_NOSEL            "\004"
#define UI_TEXT_PRINT_POS        "Skriver ut..."
#define UI_TEXT_PRINTING         "Skriver"
#define UI_TEXT_IDLE             "Idle"
#define UI_TEXT_NOSDCARD         "Inget SD Kort"
#define UI_TEXT_ERROR            "**** ERROR ****"
#define UI_TEXT_BACK             "Tillbaka \001"
#define UI_TEXT_QUICK_SETTINGS   "Inst" STR_auml "llnigar"
#define UI_TEXT_CONFIGURATION    "Konfiguration"
#define UI_TEXT_POSITION         "Position"
#define UI_TEXT_EXTRUDER         "Extruder"
#define UI_TEXT_SD_CARD          "SD Kort"
#define UI_TEXT_DEBUGGING        "Debugging"
#define UI_TEXT_HOME_ALL         "K" STR_ouml "r hem alla"
#define UI_TEXT_HOME_X           "K" STR_ouml "r hem X"
#define UI_TEXT_HOME_Y           "K" STR_ouml "r hem Y"
#define UI_TEXT_HOME_Z           "K" STR_ouml "r hem Z"
#define UI_TEXT_PREHEAT_PLA      "F" STR_ouml "rv" STR_auml "rm f" STR_ouml "r PLA"
#define UI_TEXT_PREHEAT_ABS      "F" STR_ouml "rv" STR_auml "rm f" STR_ouml "r ABS"
#define UI_TEXT_COOLDOWN         "Kyl ner"
#define UI_TEXT_SET_TO_ORIGIN    "Set to Origin"
#define UI_TEXT_DISABLE_STEPPER  "St" STR_auml "ng av stegmotor"
#define UI_TEXT_X_POSITION       "X Position"
#define UI_TEXT_X_POS_FAST       "X Pos. Snabb"
#define UI_TEXT_Y_POSITION       "Y Position"
#define UI_TEXT_Y_POS_FAST       "Y Pos. Snabb"
#define UI_TEXT_Z_POSITION       "Z Position"
#define UI_TEXT_Z_POS_FAST       "Z Pos. Snabb"
#define UI_TEXT_E_POSITION       "Extr. position"
#define UI_TEXT_BED_TEMP         "Bord Temp.:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0  :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1  :%E1\002C"
#define UI_TEXT_EXTR0_OFF        "Extruder 0 Off"
#define UI_TEXT_EXTR1_OFF        "Extruder 1 Off"
#define UI_TEXT_EXTR0_SELECT     "%X0 V"STR_auml"lj Extr.0"
#define UI_TEXT_EXTR1_SELECT     "%X1 V"STR_auml"lj Extr.1"
#define UI_TEXT_EXTR_ORIGIN      "Set Origin"
#define UI_TEXT_PRINT_X          "Skriv X:%ax"
#define UI_TEXT_PRINT_Y          "Skriv Y:%ay"
#define UI_TEXT_PRINT_Z          "Skriv Z:%az"
#define UI_TEXT_MOVE_X           "Transp X:%aX"
#define UI_TEXT_MOVE_Y           "Transp Y:%aY"
#define UI_TEXT_MOVE_Z           "Transp. Z:%aZ"
#define UI_TEXT_JERK             "Jerk:%aj"
#define UI_TEXT_ZJERK            "Z-Jerk:%aJ"
#define UI_TEXT_ACCELERATION     "Acceleration"
#define UI_TEXT_STORE_TO_EEPROM  "Spara till EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Ladda f. EEPROM"
#define UI_TEXT_DBG_ECHO         "Eko   :%do"
#define UI_TEXT_DBG_INFO         "Info   :%di"
#define UI_TEXT_DBG_ERROR        "Errors :%de"
#define UI_TEXT_DBG_DRYRUN       "Torr k" STR_ouml "r:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Av"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Klassik"
#define UI_TEXT_OPS_FAST         "%O2 OPS Snabb"
#define UI_TEXT_OPS_RETRACT      "Dra tillbaka :%Or"
#define UI_TEXT_OPS_BACKSLASH    "Backsl. :%Ob"
#define UI_TEXT_OPS_MINDIST      "Min.dist:%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Flytta efter:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti Ooze"
#define UI_TEXT_PRINT_FILE       "Skriv ut fil"
#define UI_TEXT_PAUSE_PRINT      "Pausa utskrift"
#define UI_TEXT_CONTINUE_PRINT   "Forts" STR_auml "tt Utskrift"
#define UI_TEXT_UNMOUNT_CARD     "Avmontera Kort"
#define UI_TEXT_MOUNT_CARD       "Montera Kort"
#define UI_TEXT_DELETE_FILE      "Radera fil"
#define UI_TEXT_FEEDRATE         "Matning"
#define UI_TEXT_FEED_MAX_X       "Max X:%fx"
#define UI_TEXT_FEED_MAX_Y       "Max Y:%fy"
#define UI_TEXT_FEED_MAX_Z       "Max Z:%fz"
#define UI_TEXT_FEED_HOME_X      "Ref X:%fX"
#define UI_TEXT_FEED_HOME_Y      "Ref Y:%fY"
#define UI_TEXT_FEED_HOME_Z      "Ref Z:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Min " STR_auml "ndl" STR_auml "ge:%sx","Max " STR_auml "ndl" STR_auml "ge:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Min " STR_auml "ndl" STR_auml "ge:%sy","Max " STR_auml "ndl" STR_auml "ge:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Min " STR_auml "ndl" STR_auml "ge:%sz","Max " STR_auml "ndl" STR_auml "ge:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Min " STR_auml "ndl" STR_auml "ge:%sx","Max " STR_auml "ndl" STR_auml "ge:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Min " STR_auml "ndl" STR_auml "ge:%sy","Max " STR_auml "ndl" STR_auml "ge:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Min " STR_auml "ndl" STR_auml "ge:%sz","Max " STR_auml "ndl" STR_auml "ge:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 click = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "Fl" STR_auml "kt hast."
#define UI_TEXT_FAN_OFF           "St" STR_auml "ng av fl" STR_auml "kt"
#define UI_TEXT_FAN_25            "Fl" STR_auml "kt 25%%%"
#define UI_TEXT_FAN_50            "Fl" STR_auml "kt 50%%%"
#define UI_TEXT_FAN_75            "Fl" STR_auml "kt 75%%%"
#define UI_TEXT_FAN_FULL          "Full fl" STR_auml "kt"
#define UI_TEXT_STEPPER_INACTIVE  "Stegmotorer inakt."
#define UI_TEXT_STEPPER_INACTIVE2 "Inakt. Efter:%is","[s] 0=Off"
#define UI_TEXT_POWER_INACTIVE    "Max. Inaktiv"
#define UI_TEXT_POWER_INACTIVE2   "Inakt. Efter:%ip","[s] 0=Off"
#define UI_TEXT_GENERAL           "Generella"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Steg/MM:%Se"
#define UI_TEXT_EXTR_START_FEED   "Start FR:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Max FR:%XF"
#define UI_TEXT_EXTR_ACCEL        "Accel:%XA"
#define UI_TEXT_EXTR_WATCH        "Stab.Time:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Advance lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Advance quad:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Control:%Xh"
#define UI_TEXT_EXTR_PGAIN        "PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "X-Offset:%Xx"
#define UI_TEXT_EXTR_YOFF         "Y-Offset:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Action:%la"
#define UI_TEXT_HEATING_EXTRUDER  "V" STR_auml "rmer Extruder"
#define UI_TEXT_HEATING_BED       "V" STR_auml "rmer Bord"
#define UI_TEXT_KILLED            "Killed"
#define UI_TEXT_STEPPER_DISABLED  "Stegmotorer Av"
#define UI_TEXT_EEPROM_STORED     "Konfiguration","sparad i EEPROM"
#define UI_TEXT_EEPROM_LOADED     "Konfiguration","laddat fr EEPROM"
#define UI_TEXT_UPLOADING         "Uppladdning..."
#define UI_TEXT_PAGE_BUFFER       "Buffer:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "B:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Hast. Mul.:%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Fl" STR_ouml "de Mul.:%of%%%"
#define UI_TEXT_EXTR_WAIT_RETRACT_TEMP  "V" STR_auml "nta Temp.%XT\002C"
#define UI_TEXT_EXTR_WAIT_RETRACT_UNITS "V" STR_auml "nta Units:%XUmm"
#define UI_TEXT_PRINTER_READY    "Utskrift Klar."
#endif

// *************************************************************************************
//                             User defined language
//
// If you need a language not mentioned above, you can translate this dummy entry.
// If you want it added permanently to the distribution, spend it to the community under
// GPL V3. Only new and complete translations are put into the official distribution!
// *************************************************************************************

#if UI_LANGUAGE==1000

#define UI_TEXT_ON               "On"
#define UI_TEXT_OFF              "Off"
#define UI_TEXT_NA               "N/A" // Output for not available
#define UI_TEXT_YES              "Yes"
#define UI_TEXT_NO               "No"
#define UI_TEXT_SEL              "\003"
#define UI_TEXT_NOSEL            "\004"
#define UI_TEXT_PRINT_POS        "Printing..."
#define UI_TEXT_PRINTING         "Printing"
#define UI_TEXT_IDLE             "Idle"
#define UI_TEXT_NOSDCARD         "No SD Card"
#define UI_TEXT_ERROR            "**** ERROR ****"
#define UI_TEXT_BACK             "Back \001"
#define UI_TEXT_QUICK_SETTINGS   "Quick Settings"
#define UI_TEXT_CONFIGURATION    "Configuration"
#define UI_TEXT_POSITION         "Position"
#define UI_TEXT_EXTRUDER         "Extruder"
#define UI_TEXT_SD_CARD          "SD Card"
#define UI_TEXT_DEBUGGING        "Debugging"
#define UI_TEXT_HOME_ALL         "Home All"
#define UI_TEXT_HOME_X           "Home X"
#define UI_TEXT_HOME_Y           "Home Y"
#define UI_TEXT_HOME_Z           "Home Z"
#define UI_TEXT_PREHEAT_PLA      "Preheat PLA"
#define UI_TEXT_PREHEAT_ABS      "Preheat ABS"
#define UI_TEXT_COOLDOWN         "Cooldown"
#define UI_TEXT_SET_TO_ORIGIN    "Set to Origin"
#define UI_TEXT_DISABLE_STEPPER  "Disable stepper"
#define UI_TEXT_X_POSITION       "X Position"
#define UI_TEXT_X_POS_FAST       "X Pos. Fast"
#define UI_TEXT_Y_POSITION       "Y Position"
#define UI_TEXT_Y_POS_FAST       "Y Pos. Fast"
#define UI_TEXT_Z_POSITION       "Z Position"
#define UI_TEXT_Z_POS_FAST       "Z Pos. Fast"
#define UI_TEXT_E_POSITION       "Extr. position"
#define UI_TEXT_BED_TEMP         "Bed Temp.:%Eb\002C"
#define UI_TEXT_EXTR0_TEMP       "Temp. 0  :%E0\002C"
#define UI_TEXT_EXTR1_TEMP       "Temp. 1  :%E1\002C"
#define UI_TEXT_EXTR2_TEMP       "Temp. 2  :%E2\002C"
#define UI_TEXT_EXTR0_OFF        "Extruder 0 Off"
#define UI_TEXT_EXTR1_OFF        "Extruder 1 Off"
#define UI_TEXT_EXTR2_OFF        "Extruder 2 Off"
#define UI_TEXT_EXTR0_SELECT     "%X0 Select Extr.0"
#define UI_TEXT_EXTR1_SELECT     "%X1 Select Extr.1"
#define UI_TEXT_EXTR2_SELECT     "%X1 Select Extr.2"
#define UI_TEXT_EXTR_ORIGIN      "Set Origin"
#define UI_TEXT_PRINT_X          "Print X:%ax"
#define UI_TEXT_PRINT_Y          "Print Y:%ay"
#define UI_TEXT_PRINT_Z          "Print Z:%az"
#define UI_TEXT_PRINT_Z_DELTA    "Print:%az"
#define UI_TEXT_MOVE_X           "Move X:%aX"
#define UI_TEXT_MOVE_Y           "Move Y:%aY"
#define UI_TEXT_MOVE_Z           "Move Z:%aZ"
#define UI_TEXT_MOVE_Z_DELTA     "Move:%aZ"
#define UI_TEXT_JERK             "Jerk:%aj"
#define UI_TEXT_ZJERK            "Z-Jerk:%aJ"
#define UI_TEXT_ACCELERATION     "Acceleration"
#define UI_TEXT_STORE_TO_EEPROM  "Store to EEPROM"
#define UI_TEXT_LOAD_EEPROM      "Load f. EEPROM"
#define UI_TEXT_DBG_ECHO         "Echo   :%do"
#define UI_TEXT_DBG_INFO         "Info   :%di"
#define UI_TEXT_DBG_ERROR        "Errors :%de"
#define UI_TEXT_DBG_DRYRUN       "Dry run:%dd"
#define UI_TEXT_OPS_OFF          "%O0 OPS Off"
#define UI_TEXT_OPS_CLASSIC      "%O1 OPS Classic"
#define UI_TEXT_OPS_FAST         "%O2 OPS Fast"
#define UI_TEXT_OPS_RETRACT      "Retract :%Or"
#define UI_TEXT_OPS_BACKSLASH    "Backsl. :%Ob"
#define UI_TEXT_OPS_MINDIST      "Min.dist:%Od"
#define UI_TEXT_OPS_MOVE_AFTER   "Move after:%Oa"
#define UI_TEXT_ANTI_OOZE        "Anti Ooze"
#define UI_TEXT_PRINT_FILE       "Print file"
#define UI_TEXT_PAUSE_PRINT      "Pause Print"
#define UI_TEXT_CONTINUE_PRINT   "Continue Print"
#define UI_TEXT_UNMOUNT_CARD     "Unmount Card"
#define UI_TEXT_MOUNT_CARD       "Mount Card"
#define UI_TEXT_DELETE_FILE      "Delete file"
#define UI_TEXT_FEEDRATE         "Feedrate"
#define UI_TEXT_FEED_MAX_X       "Max X:%fx"
#define UI_TEXT_FEED_MAX_Y       "Max Y:%fy"
#define UI_TEXT_FEED_MAX_Z       "Max Z:%fz"
#define UI_TEXT_FEED_MAX_Z_DELTA "Max:%fz"
#define UI_TEXT_FEED_HOME_X      "Home X:%fX"
#define UI_TEXT_FEED_HOME_Y      "Home Y:%fY"
#define UI_TEXT_FEED_HOME_Z      "Home Z:%fZ"
#define UI_TEXT_FEED_HOME_Z_DELTA "Home:%fZ"
#define UI_TEXT_ACTION_XPOSITION4 "X:%x0 mm","Min endstop:%sx","Max endstop:%sX",""
#define UI_TEXT_ACTION_YPOSITION4 "Y:%x1 mm","Min endstop:%sy","Max endstop:%sY",""
#define UI_TEXT_ACTION_ZPOSITION4 "Z:%x2 mm","Min endstop:%sz","Max endstop:%sZ",""
#define UI_TEXT_ACTION_XPOSITION_FAST4 "X:%x0 mm","Min endstop:%sx","Max endstop:%sX",""
#define UI_TEXT_ACTION_YPOSITION_FAST4 "Y:%x1 mm","Min endstop:%sy","Max endstop:%sY",""
#define UI_TEXT_ACTION_ZPOSITION_FAST4 "Z:%x2 mm","Min endstop:%sz","Max endstop:%sZ",""
#define UI_TEXT_ACTION_EPOSITION_FAST2 "E:%x3 mm","1 click = 1 mm"
#define UI_TEXT_ACTION_XPOSITION2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_ACTION_XPOSITION_FAST2 "X:%x0 mm","Min:%sx Max:%sX"
#define UI_TEXT_ACTION_YPOSITION_FAST2 "Y:%x1 mm","Min:%sy Max:%sY"
#define UI_TEXT_ACTION_ZPOSITION_FAST2 "Z:%x2 mm","Min:%sz Max:%sZ"
#define UI_TEXT_FANSPEED          "Fan speed"
#define UI_TEXT_ACTION_FANSPEED   "Fan speed:%Fs%%%"
#define UI_TEXT_FAN_OFF           "Turn Fan Off"
#define UI_TEXT_FAN_25            "Set Fan 25%%%"
#define UI_TEXT_FAN_50            "Set Fan 50%%%"
#define UI_TEXT_FAN_75            "Set Fan 75%%%"
#define UI_TEXT_FAN_FULL          "Set Fan Full"
#define UI_TEXT_STEPPER_INACTIVE  "Stepper Inactive"
#define UI_TEXT_STEPPER_INACTIVE2 "Dis. After:%is","[s] 0=Off"
#define UI_TEXT_POWER_INACTIVE    "Max. Inactive"
#define UI_TEXT_POWER_INACTIVE2   "Dis. After:%ip","[s] 0=Off"
#define UI_TEXT_GENERAL           "General"
#define UI_TEXT_BAUDRATE          "Baudrate:%oc"
#define UI_TEXT_EXTR_STEPS        "Steps/MM:%Se"
#define UI_TEXT_EXTR_START_FEED   "Start FR:%Xf"
#define UI_TEXT_EXTR_MAX_FEED     "Max FR:%XF"
#define UI_TEXT_EXTR_ACCEL        "Accel:%XA"
#define UI_TEXT_EXTR_WATCH        "Stab.Time:%Xw"
#define UI_TEXT_EXTR_ADVANCE_L    "Advance lin:%Xl"
#define UI_TEXT_EXTR_ADVANCE_K    "Advance quad:%Xa"
#define UI_TEXT_EXTR_MANAGER      "Control:%Xh"
#define UI_TEXT_EXTR_PGAIN        "DT/PID P:%Xp"
#define UI_TEXT_EXTR_IGAIN        "PID I:%Xi"
#define UI_TEXT_EXTR_DGAIN        "PID D:%Xd"
#define UI_TEXT_EXTR_DMIN         "Drive Min:%Xm"
#define UI_TEXT_EXTR_DMAX         "Drive Max:%XM"
#define UI_TEXT_EXTR_PMAX         "PID Max:%XD"
#define UI_TEXT_EXTR_XOFF         "X-Offset:%Xx"
#define UI_TEXT_EXTR_YOFF         "Y-Offset:%Xy"
#define UI_TEXT_STRING_HM_BANGBANG "BangBang"
#define UI_TEXT_STRING_HM_PID     "PID"
#define UI_TEXT_STRING_ACTION     "Action:%la"
#define UI_TEXT_HEATING_EXTRUDER  "Heating Extruder"
#define UI_TEXT_HEATING_BED       "Heating Bed"
#define UI_TEXT_KILLED            "Killed"
#define UI_TEXT_STEPPER_DISABLED  "Stepper Disabled"
#define UI_TEXT_EEPROM_STORED     "Configuration","stored in EEPROM"
#define UI_TEXT_EEPROM_LOADED     "Configuration","loaded f. EEPROM"
#define UI_TEXT_UPLOADING         "Uploading..."
#define UI_TEXT_PAGE_BUFFER       "Buffer:%oB"
#define UI_TEXT_PAGE_EXTRUDER     "E:%ec/%Ec\002C\176%oC"
#define UI_TEXT_PAGE_EXTRUDER1     "E1:%e0/%E0\002C\176%o0"
#define UI_TEXT_PAGE_EXTRUDER2     "E2:%e1/%E1\002C\176%o1"
#define UI_TEXT_PAGE_BED          "B:%eb/%Eb\002C\176%ob"
#define UI_TEXT_SPEED_MULTIPLY    "Speed Mul.:%om%%%"
#define UI_TEXT_FLOW_MULTIPLY     "Flow Mul.:%of%%%"
#define UI_TEXT_EXTR_WAIT_RETRACT_TEMP  "Wait Temp.%XT\002C"
#define UI_TEXT_EXTR_WAIT_RETRACT_UNITS "Wait Units:%XUmm"
#define UI_TEXT_PRINTER_READY    "Printer ready."
// Printtime output gets aggregated like <Days_5gisgits>UI_TEXT_PRINTTIME_DAYS<Hours>UI_TEXT_PRINTTIME_HOURS<Minutes>UI_TEXT_PRINTTIME_MINUTES
// ___88 days 12:45
#define UI_TEXT_PRINTTIME_DAYS   " days "
#define UI_TEXT_PRINTTIME_HOURS  ":"
#define UI_TEXT_PRINTTIME_MINUTES ""
#define UI_TEXT_PRINT_TIME     "Printing time"
#define UI_TEXT_PRINT_FILAMENT "Filament printed"
#define UI_TEXT_POWER            "ATX power on/off"
#define UI_TEXT_STRING_HM_DEADTIME     "Dead Time"
#define UI_TEXT_STRING_HM_SLOWBANG     "SlowBang"
#define UI_TEXT_STOP_PRINT "Stop Print"

#endif
