#include <Servo.h>

/*#define lgrip //left arm gripper
#define llbow 9//left elbow
#define lshol 3//left shoulders

#define rgrip //right arm gripper
#define rlbow 10//right elbow
#define rshol 5//right shoulders

#define head 6
*/


/*

My servo values,different for different setup

            max  mid  min
Relbow      90   110  150
Lelbow      70   35     0
Rshoulder   0    95   180
Lshoulder   160  80    0  
Head         35  90  145

*/

#define en 3 //L293D Enable pin


Servo lshol;
Servo llbow;
Servo rshol;
Servo rlbow;
Servo head;

int echopin=12,i=0,j=0,spd=0;
int trigpin=13;

long duration, distance;

void setup(){
  Serial.begin(9600);
  
  pinMode(A2,OUTPUT);
  pinMode(A3,OUTPUT);
  pinMode(A4,OUTPUT);
  pinMode(A5,OUTPUT);
  
  lshol.attach(11);
  rshol.attach(5);
  llbow.attach(9);
  rlbow.attach(10);
  head.attach(6);
}

void loop(){
  
  lshol.write(0);
  rshol.write(180);
  llbow.write(50);
  rlbow.write(90);
  head.write(90);
  
 //  delay(50999);
   
  Serial.print(sensor(1));
  Serial.print("\t");
  Serial.print(sensor(2));
  Serial.print("\t");
  Serial.print(sensor(3));
  Serial.print("\n");
  
  move(90,30,150,60,90,10) ;   //head,lshol,rshol,llbow,rlbow,time
  
  while(1){
  start:
  forward(150);
  while(sensor(1) >= 20 && sensor(2)>=9 && sensor(3)>=9){
  }
  stop();
  
  move(160,30,150,60,90,10) ;
  
  if(sensor(1)>30 ){
  backward(200);
  move(160,30,80,60,70,10) ;   //head,lshol,rshol,llbow,rlbow,time
  delay(100);
  rturn(120);
  move(90,30,150,60,90,10) ;
  stop();
  goto start;
  }
    
  move(0,30,150,60,90,10) ;
  if(sensor(1)>30){
  backward(200);
  move(0,90,150,60,90,10) ;   //head,lshol,rshol,llbow,rlbow,time
  delay(100);
  lturn(120);
  move(90,30,150,60,90,10) ;
  stop();
  goto start;
  }
  
  else{
  backward(120);
  delay(300);
  rturn(100);
  move(90,30,150,60,90,10) ;
  delay(400);
  stop();
  goto start;
  }

}
  
  
  
  
  
  delay(50999);
  
  
  
}

void forward(int speed){

  digitalWrite(A2,LOW);
  digitalWrite(A3,HIGH);
  digitalWrite(A4,HIGH);
  digitalWrite(A5,LOW);
  
  analogWrite(en, speed);
}
void backward(int speed){

  digitalWrite(A2,HIGH);
  digitalWrite(A3,LOW);
  digitalWrite(A4,LOW);
  digitalWrite(A5,HIGH);
  
  analogWrite(en, speed);
}

void rturn(int speed){
  digitalWrite(A2,HIGH);
  digitalWrite(A3,LOW);
  digitalWrite(A4,HIGH);
  digitalWrite(A5,LOW);
  analogWrite(en, speed);
}

void lturn(int speed){
  digitalWrite(A2,LOW);
  digitalWrite(A3,HIGH);
  digitalWrite(A4,LOW);
  digitalWrite(A5,HIGH);
  analogWrite(en, speed);
}

void stop(){
  digitalWrite(A2,LOW);
  digitalWrite(A3,LOW);
  digitalWrite(A4,LOW);
  digitalWrite(A5,LOW);
}




int sensor(int x){  //sonar sensors function
  
  if(x==1){//head sensor
  echopin=12;
  trigpin=13;
  }
  else if(x==2){ //left arm sensor
  echopin=7;
  trigpin=8;
  }
  else if(x==3){ //right arm sensor
  echopin=4;
  trigpin=2;
  }
  
 pinMode(trigpin, OUTPUT);
 pinMode(echopin, INPUT);
 digitalWrite(trigpin, LOW); 
 delayMicroseconds(2); 

 digitalWrite(trigpin, HIGH);
 delayMicroseconds(10); 
 
 digitalWrite(trigpin, LOW);
 duration = pulseIn(echopin, HIGH);
 
 distance = duration/58.2;
 delay(50);
 return(distance);
 
 
}



void move(int a, int b,int c,int d,int l1,int e) {   //head,lshol,rshol,llbow,rlbow
  
  int headi=head.read();
  int lsholi=lshol.read();
  int rsholi=rshol.read();
  int llbowi=llbow.read();
  int rlbowi=rlbow.read();
  int headloop,rsholloop,lsholloop,llbowloop,rlbowloop;
  
  int he=a-headi;
  if(he>=0)
  headloop=1;
  else if(he<0)
  headloop=-1;
  
  int lsh=b-lsholi;
  if(lsh>=0)
  lsholloop=1;
  else if(lsh<0)
  lsholloop=-1;
  
  int rsh=c-rsholi;
  if(rsh>=0)
  rsholloop=1;
  else if(rsh<0)
  rsholloop=-1;
  
  int llb=d-llbowi;
  if(llb>=0)
  llbowloop=1;
  else if(llb<0)
  llbowloop=-1;
  
  int rlb=l1-rlbowi;
  if(rlb>=0)
  rlbowloop=1;
  else if(rlb<0)
  rlbowloop=-1;
  
  int increment=0;
  
     if( (fabs(he)>=fabs(lsh)) && (fabs(he)>=fabs(rsh)) && (fabs(he)>=fabs(llb)) && (fabs(he)>=fabs(rlb))) {
     increment=fabs(he);
     }
     else if( (fabs(lsh)>=fabs(he)) && (fabs(lsh)>=fabs(rsh)) && (fabs(lsh)>=fabs(llb)) && (fabs(lsh)>=fabs(rlb))) {
     increment=fabs(lsh);
     }
     else if( (fabs(rsh)>=fabs(he)) && (fabs(rsh)>=fabs(lsh)) && (fabs(rsh)>=fabs(llb)) && (fabs(rsh)>=fabs(rlb))) {
     increment=fabs(rsh);
     }
     else if( (fabs(llb)>=fabs(he)) && (fabs(llb)>=fabs(rsh)) && (fabs(llb)>=fabs(lsh)) && (fabs(llb)>=fabs(rlb))) {
     increment=fabs(llb);
     }
     else if( (fabs(rlb)>=fabs(he)) && (fabs(rlb)>=fabs(rsh)) && (fabs(rlb)>=fabs(lsh)) && (fabs(rlb)>=fabs(llb))) {
     increment=fabs(rlb);
     }
    
         
     for(j=0 ; j<=increment ; j=j+1 ) {
     
       if( fabs(headi-a)!=0 ){
       headi=headi+headloop;
       head.write(headi);
       }
       if( fabs(lsholi-b)!=0 ){
       lsholi=lsholi+lsholloop;
       lshol.write(lsholi);
       }
       if( fabs(rsholi-c)!=0 ){
       rsholi=rsholi+rsholloop;
       rshol.write(rsholi);
       }
       if( fabs(llbowi-d)!=0 ){
       llbowi=llbowi+llbowloop;
       llbow.write(llbowi);
       }
       if( fabs(rlbowi-l1)!=0 ){
       rlbowi=rlbowi+rlbowloop;
       rlbow.write(rlbowi);
       }

       
       

      delay(e);      
     }
     
  
}
