/*  

     SPhocsLock by gelstronic (gels2@gmx.de)



   Based on MORSE ENDECODER DEMO
    
    
    
    
  Copyright (C) 2010, 2012 raron
  
  GNU GPLv3 license:
  
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
   
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
   
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
   
  
  Contact: raronzen@gmail.com  (not checked too often..)
  Details: http://raronoff.wordpress.com/2010/12/16/morse-endecoder/
*/

#include <avr/pgmspace.h>
#include "MorseEnDecoder.h"


const byte morseInPin = 2;      
const byte DoorPin = 13;
const char password[ ] = "TEST";  // <----------------- Password
const long OpenTime = 1000 ;// in ms
const byte wpm = 50;
// Instantiate Morse objects

morseDecoder morseInput(morseInPin, MORSE_AUDIO, MORSE_ACTIVE_HIGH);

long lastTransmissionTime;
long currentTime;
boolean transmissionEnded = true; // Flag to mark old transmission is finished


const byte passwordLength = sizeof(password)-1;
char receivedMorse[passwordLength];


const long transmissionPaused   = 1000; // Suitable for 13 wpm?
long letterCount = 0 ;

void setup()
{
  //Serial.begin(9600);
  //Serial.println("Morse EnDecoder demo");
  
  // Setting Morse speed in wpm - words per minute

  morseInput.setspeed(wpm);
  //morseOutput.setspeed(13);
  pinMode(DoorPin, OUTPUT);  
  digitalWrite(DoorPin, LOW);
  lastTransmissionTime = (long)millis();
}



void loop()
{
  

  currentTime = (long)millis();
  
  
  // Needs to call these once per loop
  morseInput.decode();

  if (morseInput.available())
  {

   receivedMorse[letterCount++] = morseInput.read();
   
   // Serial.println(receivedMorse[letterCount-1]);
   // Serial.println(passwordLength);
   // Serial.println(letterCount);
   if (letterCount > passwordLength){letterCount = passwordLength;}

  }
  
  
  
  
 

  // Check if ongoing transmission (not yet transmission pause)
  if (morseInput.morseSignalState == true)
  {
    // reset last transmission timer and flag
    lastTransmissionTime = currentTime;
    transmissionEnded = false;
  }


  if ((currentTime - lastTransmissionTime) > transmissionPaused)
  {
    if (transmissionEnded == false)
    {
      
      letterCount = 0;
      if (array_cmp() == true){
            // Serial.println("ok");
             digitalWrite(DoorPin, HIGH);
             delay(OpenTime);
             digitalWrite(DoorPin, LOW);
      }
      // Finally set the flag to prevent continous carriage returns
      transmissionEnded = true;
    
    }
  }
}

boolean array_cmp()
{
      int n;

      
     

      // test each element to be the same. if not, return false
      for (n=0;n<passwordLength;n++) if (password[n]!=receivedMorse[n]) return false;

      //ok, if we have not returned yet, they are equal :)
      return true;
}
