// CODE EDITED AND PROVIDED BY ANDERS644PI
// https://www.instructables.com/member/Anders644PI/
// https://www.instagram.com/anders644pi/

#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <WebSocketsClient.h> //  https://github.com/kakopappa/sinric/wiki/How-to-add-dependency-libraries
#include <ArduinoJson.h> // https://github.com/kakopappa/sinric/wiki/How-to-add-dependency-libraries
#include <StreamString.h>
//#include <IRremote.h>
#include <IRremoteESP8266.h>
#include <IRsend.h>

const uint16_t kIrLed = D2;
IRsend irsend(kIrLed);

int khz = 38; // 38kHz carrier frequency for the NEC protocol

uint16_t power[67] = {INSERT_RAW_IR_SIGNAL_HERE}; // Raw IR Signal
//uint16_t source[67] = {INSERT_RAW_IR_SIGNAL_HERE};
//uint16_t okay[67] = {INSERT_RAW_IR_SIGNAL_HERE};

ESP8266WiFiMulti WiFiMulti;
WebSocketsClient webSocket;
WiFiClient client;

#define MyApiKey "YOUR_API_KEY" // Change to your sinric API Key. Your API Key is displayed on sinric.com dashboard
#define MySSID "YOUR_WIFI_SSID" // Change to your Wifi network SSID
#define MyWifiPassword "YOUR_WIFI_PASSWORD" // Change to your Wifi network password

#define HEARTBEAT_INTERVAL 300000 // 5 Minutes 

uint64_t heartbeatTimestamp = 0;
bool isConnected = false;

void setPowerStateOnServer(String deviceId, String value);
void setTargetTemperatureOnServer(String deviceId, String value, String scale);

// deviceId is the ID assgined to your smart-home-device in sinric.com dashboard. Copy it from dashboard and paste it here

void turnOn(String deviceId) {
  if (deviceId == "YOUR_DEVICE_ID") // Change to your Device ID of first device
  {
    digitalWrite(D1, HIGH);
    Serial.print("Turn on Device ID: ");
    Serial.println(deviceId);
    //digitalWrite(D1, LOW);
    delay(50);
    Serial.println("Power");
    irsend.sendRaw(power, 67, khz);
    delay(50);
    irsend.sendRaw(power, 67, khz);
    delay(50);
    digitalWrite(D1, LOW);
  }
  /* Uncomment to add device
    else if (deviceId == "YOUR_SECOND_DEVICE_ID") // Device ID of second device
    {
    digitalWrite(D1, HIGH);
    Serial.print("Turn on Device ID: ");
    Serial.println(deviceId);
    //digitalWrite(D2, LOW);
    delay(50);
    Serial.println("Source + Okay");
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(source, 67, khz);
    }
    delay(500);
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(source, 67, khz);
    }
    delay(500);
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(source, 67, khz);
    }
    delay(500);
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(source, 67, khz);
    }
    delay(500);
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(okay, 67, khz);
    }
    digitalWrite(D1, LOW);
    }
  */
  else {
    Serial.print("Turn on for unknown device id: ");
    Serial.println(deviceId);
  }
}

void turnOff(String deviceId) {
  if (deviceId == "YOUR_DEVICE_ID") // Device ID of first device
  {
    digitalWrite(D1, HIGH);
    Serial.print("Turn off Device ID: ");
    Serial.println(deviceId);
    //digitalWrite(D1, LOW);
    delay(50);
    Serial.println("Power");
    irsend.sendRaw(power, 67, khz);
    delay(50);
    irsend.sendRaw(power, 67, khz);
    delay(50);
    digitalWrite(D1, LOW);
  }
  /* Uncomment to add device
  else if (deviceId == "YOUR_SECOND_DEVICE_ID") // Device ID of second device
    {
    digitalWrite(D1, HIGH);
    Serial.print("Turn off Device ID: ");
    Serial.println(deviceId);
    //digitalWrite(D2, LOW);
    delay(50);
    Serial.println("ChangeToTV");
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(source, 67, khz);
    }
    delay(500);
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(source, 67, khz);
    }
    delay(500);
    for (int i = 0; i < 2; i++) {
      irsend.sendRaw(okay, 67, khz);
    }
    digitalWrite(D1, LOW);
    }
  */
  else {
    Serial.print("Turn off for unknown device id: ");
    Serial.println(deviceId);
  }
}

void webSocketEvent(WStype_t type, uint8_t * payload, size_t length) {
  switch (type) {
    case WStype_DISCONNECTED:
      isConnected = false;
      Serial.printf("[WSc] Webservice disconnected from sinric.com!\n");
      break;
    case WStype_CONNECTED: {
        isConnected = true;
        Serial.printf("[WSc] Service connected to sinric.com at url: %s\n", payload);
        Serial.printf("Waiting for commands from sinric.com ...\n");
        digitalWrite(D5, HIGH);
      }
      break;
    case WStype_TEXT: {
        Serial.printf("[WSc] get text: %s\n", payload);
        // Example payloads

        // For Switch or Light device types
        // {"deviceId": xxxx, "action": "setPowerState", value: "ON"} // https://developer.amazon.com/docs/device-apis/alexa-powercontroller.html

        // For Light device type
        // Look at the light example in github

        DynamicJsonBuffer jsonBuffer;
        JsonObject& json = jsonBuffer.parseObject((char*)payload);
        String deviceId = json ["deviceId"];
        String action = json ["action"];

        if (action == "setPowerState") { // Switch or Light
          String value = json ["value"];
          if (value == "ON") {
            turnOn(deviceId);
          } else {
            turnOff(deviceId);
          }
        }
        else if (action == "SetTargetTemperature") {
          String deviceId = json ["deviceId"];
          String action = json ["action"];
          String value = json ["value"];
        }
        else if (action == "test") {
          Serial.println("[WSc] received test command from sinric.com");
        }
      }
      break;
    case WStype_BIN:
      Serial.printf("[WSc] get binary length: %u\n", length);
      break;
  }
}

void setup() {
  pinMode(D5, OUTPUT);
  digitalWrite(D5, LOW);
  pinMode(D1, OUTPUT);
  digitalWrite(D1, LOW);

  irsend.begin();

  Serial.begin(115200);

  WiFiMulti.addAP(MySSID, MyWifiPassword);
  Serial.println();
  Serial.print("Connecting to Wifi: ");
  Serial.println(MySSID);

  // Waiting for Wifi connect
  while (WiFiMulti.run() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  if (WiFiMulti.run() == WL_CONNECTED) {
    Serial.println("");
    Serial.print("WiFi connected. ");
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());
  }

  // server address, port and URL
  webSocket.begin("iot.sinric.com", 80, "/");

  // event handler
  webSocket.onEvent(webSocketEvent);
  webSocket.setAuthorization("apikey", MyApiKey);

  // try again every 5000ms if connection has failed
  webSocket.setReconnectInterval(5000);   // If you see 'class WebSocketsClient' has no member named 'setReconnectInterval' error update arduinoWebSockets
}

void loop() {
  webSocket.loop();

  if (isConnected) {
    uint64_t now = millis();

    // Send heartbeat in order to avoid disconnections during ISP resetting IPs over night. Thanks @MacSass
    if ((now - heartbeatTimestamp) > HEARTBEAT_INTERVAL) {
      heartbeatTimestamp = now;
      webSocket.sendTXT("H");
    }
  }
}

// If you are going to use a push button to on/off the switch manually, use this function to update the status on the server
// so it will reflect on Alexa app.
// eg: setPowerStateOnServer("deviceid", "ON")
void setPowerStateOnServer(String deviceId, String value) {
  DynamicJsonBuffer jsonBuffer;
  JsonObject& root = jsonBuffer.createObject();
  root["deviceId"] = deviceId;
  root["action"] = "setPowerState";
  root["value"] = value;
  StreamString databuf;
  root.printTo(databuf);

  webSocket.sendTXT(databuf);
}

//eg: setPowerStateOnServer("deviceid", "CELSIUS", "25.0")
void setTargetTemperatureOnServer(String deviceId, String value, String scale) {
  DynamicJsonBuffer jsonBuffer;
  JsonObject& root = jsonBuffer.createObject();
  root["action"] = "SetTargetTemperature";
  root["deviceId"] = deviceId;

  JsonObject& valueObj = root.createNestedObject("value");
  JsonObject& targetSetpoint = valueObj.createNestedObject("targetSetpoint");
  targetSetpoint["value"] = value;
  targetSetpoint["scale"] = scale;

  StreamString databuf;
  root.printTo(databuf);

  webSocket.sendTXT(databuf);
}
