#include "Arduino.h"
#include "SpeechChip.h"

SpeechChip::SpeechChip(int ALD)
{
  pinMode(ALD, OUTPUT);
  digitalWrite(ALD, HIGH);
  DDRA = B11111111;
  _ALD = ALD;
}

int SpeechChip::AddressLoad(int delayTime){
  digitalWrite(_ALD, LOW);
  delay(1);
  digitalWrite(_ALD, HIGH);
  delay(delayTime);
}

void SpeechChip::OR(){
  PORTA = B00111010;
  AddressLoad(330);
}

void SpeechChip::HH2(){
  PORTA = B00111001;
  AddressLoad(180);
}

void SpeechChip::HH1(){
  PORTA = B00011011;
  AddressLoad(130);
}

void SpeechChip::EH(){
  PORTA = B00000111;
  AddressLoad(70);
}

void SpeechChip::EL(){
  PORTA = B00111111;
  AddressLoad(190);
}

void SpeechChip::LL(){
  PORTA = B00101101;
  AddressLoad(110);
}

void SpeechChip::OW(){
  PORTA = B00110101;
  AddressLoad(240);
}

void SpeechChip::PA5(){
  PORTA = B00000100;
  AddressLoad(200);
}

void SpeechChip::BB1(){
  PORTA = B00011100;
  AddressLoad(80); 
}

void SpeechChip::AX(){
  PORTA = B00001111;
  AddressLoad(70);
}

void SpeechChip::IY(){
  PORTA = B00010011;
  AddressLoad(250);
}

void SpeechChip::NN2(){
  PORTA = B00111000;
  AddressLoad(190);
}

void SpeechChip::ER1(){
  PORTA = B00110011;
  AddressLoad(160);
}

void SpeechChip::AE(){
  PORTA = B00011010;
  AddressLoad(120);
}

void SpeechChip::AA(){
  PORTA = B00011000;
  AddressLoad(100);
}

void SpeechChip::AY(){
  PORTA = B00000110;
  AddressLoad(260);
}

void SpeechChip::KK1(){
  PORTA = B00101010;
  AddressLoad(160);
}

void SpeechChip::AO(){
  PORTA = B00010111;
  AddressLoad(100);
}

void SpeechChip::S(){
  PORTA = B00110111;
  AddressLoad(90);
}

void SpeechChip::EY(){
  PORTA = B00010100;
  AddressLoad(280);
}

void SpeechChip::PA4(){
  PORTA = B00000011;
  AddressLoad(100);
}

void SpeechChip::PA3(){
  PORTA = B00000010;
  AddressLoad(50);
}

void SpeechChip::PA2(){
  PORTA = B00000001;
  AddressLoad(30);
}

void SpeechChip::PA1(){
  PORTA = 00000000;
  AddressLoad(10);
}

void SpeechChip::PP(){
  PORTA = B00001001;
  AddressLoad(210);
}

void SpeechChip::D1(){
  PORTA = B00010101;
  AddressLoad(70);
}

void SpeechChip::D2(){
  PORTA = B00100001;
  AddressLoad(160);
}

void SpeechChip::TT2(){
  PORTA = B00001101;
  AddressLoad(140);
}

void SpeechChip::UW1(){
  PORTA = B00010110;
  AddressLoad(100);
}

void SpeechChip::MM(){
  PORTA = B00010000;
  AddressLoad(180);
}

void SpeechChip::YY2(){
  PORTA = B00011001;
  AddressLoad(180);
}

void SpeechChip::IH(){
  PORTA = B00001100;
  AddressLoad(70);
}

void SpeechChip::TT1(){
  PORTA = B00010001;
  AddressLoad(100);
}

void SpeechChip::ZZ(){
  PORTA = B00101011;
  AddressLoad(210);
}

void SpeechChip::NG(){
  PORTA = B00101100;
  AddressLoad(220);
}

void SpeechChip::GG1(){
  PORTA = B00100100;
  AddressLoad(80);
}

void SpeechChip::GG2(){
  PORTA = B00111101;
  AddressLoad(40);
}

void SpeechChip::GG3(){
  PORTA = B00100010;
  AddressLoad(140);
}

void SpeechChip::FF(){
  PORTA = B00101000;
  AddressLoad(150);
}

void SpeechChip::KK2(){
  PORTA = B00101001;
  AddressLoad(190);
}

void SpeechChip::KK3(){
  PORTA = B00001000;
  AddressLoad(120);
}

void SpeechChip::CH(){
  PORTA = B00110010; 
  AddressLoad(190);
}

void SpeechChip::TH(){
  PORTA = B00011101;
  AddressLoad(180);
}

void SpeechChip::ZH(){
  PORTA = B00100110;
  AddressLoad(190);
}

void SpeechChip::RR1(){
  PORTA = B00001110;
  AddressLoad(170);
}

void SpeechChip::RR2(){
  PORTA = B00100111;
  AddressLoad(120);
}

void SpeechChip::OY(){
  PORTA = B00000101;
  AddressLoad(420);
}

void SpeechChip::JH(){
  PORTA = B00001010;
  AddressLoad(140);
}

void SpeechChip::DH1(){
  PORTA = B00010010;
  AddressLoad(290);
}

void SpeechChip::DH2(){
  PORTA = B00110110;
  AddressLoad(240);
}

void SpeechChip::UW2(){
  PORTA = B00011111;
  AddressLoad(290);
}

void SpeechChip::YY1(){
  PORTA = B00110001;
  AddressLoad(130);
}

void SpeechChip::BB2(){
  PORTA = B00111111;
  AddressLoad(50);
}

void SpeechChip::UH(){
  PORTA = B00011110;
  AddressLoad(100);
}

void SpeechChip::AW(){
  PORTA = B00100000;
  AddressLoad(370);
}

void SpeechChip::VV(){
  PORTA = B00100011;
  AddressLoad(190);
}

void SpeechChip::SH(){
  PORTA = B00100101;
  AddressLoad(160);
}

void SpeechChip::WW(){
  PORTA = B00101110;
  AddressLoad(180);
}

void SpeechChip::XR(){
  PORTA = B00101111;
  AddressLoad(360);
}

void SpeechChip::WH(){
  PORTA = B00110000;
  AddressLoad(200);
}

void SpeechChip::ER2(){
  PORTA = B00110100;
  AddressLoad(300);
}

void SpeechChip::AR(){
  PORTA = B00111011;
  AddressLoad(290);
}

void SpeechChip::YR(){
  PORTA = B00111100;
  AddressLoad(350);
}

void SpeechChip::NN1(){
  PORTA = B00001011;
  AddressLoad(140);
}