
// include SPI, MP3 and SD libraries
#include <SPI.h>
#include <Adafruit_VS1053.h>
#include <SD.h>




// These are the pins used for the music maker shield
#define SHIELD_RESET  -1      // VS1053 reset pin (unused!)
#define SHIELD_CS     7      // VS1053 chip select pin (output)
#define SHIELD_DCS    6      // VS1053 Data/command select pin (output)

// These are common pins between breakout and shield
#define CARDCS 4     // Card chip select pin
// DREQ should be an Int pin, see http://arduino.cc/en/Reference/attachInterrupt
#define DREQ 3       // VS1053 Data request, ideally an Interrupt pin

Adafruit_VS1053_FilePlayer musicPlayer = 

  // create shield-example object!
  Adafruit_VS1053_FilePlayer(SHIELD_RESET, SHIELD_CS, SHIELD_DCS, DREQ, CARDCS);



const int buttonPin = 2;     // the number of the pushbutton pin
int buttonState = 0;         // variable for reading the pushbutton status
unsigned long pressTime = 0;
unsigned long inactiveTime = 0;
unsigned long resetDelay = 30000;


    
void setup() {
  Serial.begin(9600);
//  Serial.println("Adafruit VS1053 Simple Test");



  // initialize the pushbutton pin as an input:
  pinMode(buttonPin, INPUT);
  
  
  if (! musicPlayer.begin()) { // initialise the music player
     Serial.println(F("Couldn't find VS1053, do you have the right pins defined?"));
     while (1);
  }
  Serial.println(F("VS1053 found"));
  
  SD.begin(CARDCS);    // initialise the SD card
  
  // Set volume for left, right channels. lower numbers == louder volume!
  musicPlayer.setVolume(20,20);

  // If DREQ is on an interrupt pin (on uno, #2 or #3) we can do background
  // audio playing
  musicPlayer.useInterrupt(VS1053_FILEPLAYER_PIN_INT);  // DREQ int
}




void loop() {



track1:

  buttonState = digitalRead(buttonPin);
  while(buttonState == 0)
  {
    buttonState = digitalRead(buttonPin);
  }
  pressTime = millis();
  Serial.println(F("Playing track1a"));
  musicPlayer.playFullFile("track1a.mp3");
  Serial.println(F("Playing track1b"));
  musicPlayer.playFullFile("track1b.mp3");
  Serial.println(F("Playing track1c"));
  musicPlayer.playFullFile("track1c.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track2;}
  }
  pressTime = millis();
  Serial.println(F("Playing track1d"));
  musicPlayer.playFullFile("track1d.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track2;}
  }
  pressTime = millis();
  Serial.println(F("Playing track1e"));
  musicPlayer.playFullFile("track1e.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track2;}
  }
  pressTime = millis();
  Serial.println(F("Playing track1f"));
  musicPlayer.playFullFile("track1f.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track2;}
  }
  pressTime = millis();
  Serial.println(F("Playing track1g"));
  musicPlayer.playFullFile("track1g.mp3");  



track2:

  buttonState = digitalRead(buttonPin);
  while(buttonState == 0)
  {
    buttonState = digitalRead(buttonPin);
  }
  pressTime = millis();
  Serial.println(F("Playing track2a"));
  musicPlayer.playFullFile("track2a.mp3");
  Serial.println(F("Playing track2b"));
  musicPlayer.playFullFile("track2b.mp3");
  Serial.println(F("Playing track2c"));
  musicPlayer.playFullFile("track2c.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track3;}
  }
  pressTime = millis();
  Serial.println(F("Playing track2d"));
  musicPlayer.playFullFile("track2d.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track3;}
  }
  pressTime = millis();
  Serial.println(F("Playing track2e"));
  musicPlayer.playFullFile("track2e.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track3;}
  }
  pressTime = millis();
  Serial.println(F("Playing track2f"));
  musicPlayer.playFullFile("track2f.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track3;}
  }
  pressTime = millis();
  Serial.println(F("Playing track2g"));
  musicPlayer.playFullFile("track2g.mp3");  

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track3;}
  }
  pressTime = millis();
  Serial.println(F("Playing track2h"));
  musicPlayer.playFullFile("track2h.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track3;}
  }
  pressTime = millis();
  Serial.println(F("Playing track2i"));
  musicPlayer.playFullFile("track2i.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track3;}
  }
  pressTime = millis();
  Serial.println(F("Playing track2j"));
  musicPlayer.playFullFile("track2j.mp3");  



track3:

  buttonState = digitalRead(buttonPin);
  while(buttonState == 0)
  {
    buttonState = digitalRead(buttonPin);
  }
  pressTime = millis();
  Serial.println(F("Playing track3a"));
  musicPlayer.playFullFile("track3a.mp3");
  Serial.println(F("Playing track3b"));
  musicPlayer.playFullFile("track3b.mp3");
  Serial.println(F("Playing track3c"));
  musicPlayer.playFullFile("track3c.mp3");
 
  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track4;}
  }
  pressTime = millis();
  Serial.println(F("Playing track3d"));
  musicPlayer.playFullFile("track3d.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track4;}
  }
  pressTime = millis();
  Serial.println(F("Playing track3e"));
  musicPlayer.playFullFile("track3e.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track4;}
  }
  pressTime = millis();
  Serial.println(F("Playing track3f"));
  musicPlayer.playFullFile("track3f.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track4;}
  }
  pressTime = millis();
  Serial.println(F("Playing track3g"));
  musicPlayer.playFullFile("track3g.mp3");  




track4:

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
  }
  pressTime = millis();
  Serial.println(F("Playing track4a"));
  musicPlayer.playFullFile("track4a.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track1;}
  }
  pressTime = millis();
  Serial.println(F("Playing track4b"));
  musicPlayer.playFullFile("track4b.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track1;}
  }
  pressTime = millis();
  Serial.println(F("Playing track4c"));
  musicPlayer.playFullFile("track4c.mp3");

  buttonState = digitalRead(buttonPin);
  while(buttonState ==0)
  {
    buttonState = digitalRead(buttonPin);
    inactiveTime = millis() - pressTime;
    if(inactiveTime > resetDelay){ goto track1;}
  } 
  pressTime = millis();
  Serial.println(F("Playing track4d"));
  musicPlayer.playFullFile("track4d.mp3");
  
  // File is playing in the background
  if (musicPlayer.stopped()) {
    Serial.println("Done playing music");
  }


  delay(1000);
}
