// 2017 Reichenstein7
// https://www.instructables.com/member/Reichenstein7/

// Temp Monitor: DS18B20 (digital)
// Fahrenheit Example.

// **WARNING**
// Configured for a Hot Water Boiler system, your configuration may vary
// Set to turn on the heater blower when the water is HOT
// I use a <  
// under "Check Temperature is in limit" below
// If turning on something such as an electric heater and monitoring an environment for cold
// use >

/********************************************************************/

// First we include the libraries
#include <OneWire.h> 
#include <DallasTemperature.h>
#include <LiquidCrystal.h>
/********************************************************************/

// Data wire is plugged into pin 13 on the Arduino 
#define ONE_WIRE_BUS 13 
/********************************************************************/

// Setup a oneWire instance to communicate with any OneWire devices  
// (not just Maxim/Dallas temperature ICs) 
OneWire oneWire(ONE_WIRE_BUS); 
/********************************************************************/

// Pass our oneWire reference to Dallas Temperature. 
DallasTemperature sensors(&oneWire);
/********************************************************************/ 

//Setup LCD
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);           // select the pins used on the LCD panel
/********************************************************************/

// define interface pins:
#define LED_GREEN 2 //Green LED
// LCD BackLight uses PIN 10
#define RELAY 12 //Lock Relay or motor
// Temp Sensor is on PIN 13
/********************************************************************/

// Value for Default Setpoint (temp for Relay) in Fahrenheit:
int SetPoint=75;
/********************************************************************/

// define some values used by the panel and buttons
int lcd_key     = 0;
int adc_key_in  = 0;

#define btnRIGHT  0
#define btnUP     1
#define btnDOWN   2
#define btnLEFT   3
#define btnSELECT 4
#define btnNONE   5

int read_LCD_buttons(){               // read the buttons
    adc_key_in = analogRead(0);       // read the value from the sensor 

    // my buttons when read are centered at these valies: 0, 144, 329, 504, 741
    // we add approx 50 to those values and check to see if we are close
    // We make this the 1st option for speed reasons since it will be the most likely result

    if (adc_key_in > 1000) return btnNONE; 

    // For V1.1 us this threshold
    if (adc_key_in < 50)   return btnRIGHT;  
    if (adc_key_in < 250)  return btnUP; 
    if (adc_key_in < 450)  return btnDOWN; 
    if (adc_key_in < 650)  return btnLEFT; 
    if (adc_key_in < 850)  return btnSELECT;   

    return btnNONE;                // when all others fail, return this.
}
/********************************************************************/
// only run once, after each powerup or reset of the Arduino board.
// (void) variables the ISR function takes no arguments & continues with it's next line after the interrupt occurs.
void setup(void) 
{ 

// Set outputs  
  pinMode(LED_GREEN,OUTPUT);  
  pinMode(RELAY,OUTPUT);

// Initialize Relay PIN so it stays inactive at reset 
  digitalWrite(RELAY,LOW);       //Turn off Relay 

// Initialize LED PIN so it stays inactive at reset 
  digitalWrite(LED_GREEN,LOW);  //Green LED Off
  
 // start serial port for debug change "lcd.print" to "Serial.print" 
 // and listen to COM port
 Serial.begin(9600); 
 // set up the LCD's number of columns and rows: 
   lcd.begin(16, 2);
   lcd.print("Heater Blower");
   lcd.setCursor(0,1); //Move coursor to second Line
   lcd.print("Controller");
   
delay (8000);
 lcd.clear();
 
 // Start up the library 
 sensors.begin(); 
} 
/********************************************************************/
void loop(void) 
{ 
 
 // call sensors.requestTemperatures() to issue a global temperature 
 // request to all devices on the bus 
   sensors.requestTemperatures(); // Send the command to get temperature readings 
   lcd.setCursor(0,0);
   lcd.print("Temp:");    //Do not display entered keys 
   lcd.print(sensors.getTempFByIndex(0));
   lcd.print((char)223); // Degree Symbol
   lcd.print("F   "); 
   // You can have more than one DS18B20 on the same bus.  
   // 0 refers to the first IC on the wire 

//Get user input for setpoints 
  if(read_LCD_buttons() == btnDOWN)
   {
    if(SetPoint>0)
    {
      SetPoint--;   
    }
  }
  if(read_LCD_buttons() == btnUP)
  {
    if(SetPoint<150)
    {
      SetPoint++;
    }
  }
/********************************************************************/

//Display Set point on LCD in Fahrenheit (F).
  lcd.setCursor(0,1);
  lcd.print("Set Point:");
  lcd.print(SetPoint);
  lcd.print((char)223);
  lcd.print("F   ");
/********************************************************************/

//Check Temperature is in limit:
// I am monitoring a Hot Water Boiler, I want to turn on the heater when the water is HOT
// I use a < 
// If turning on something such as an electric heater and monitoring an environment for cold
// use >
if((sensors.getTempFByIndex(0)) < SetPoint) 
{
   digitalWrite(RELAY,LOW);    //Turn off heater
   digitalWrite(LED_GREEN,LOW); // Turn off Green indicator light
   Serial.print("HEATER OFF"); // serial port for debug
}
else
{
  digitalWrite(RELAY,HIGH);    //Turn on heater
  digitalWrite(LED_GREEN,HIGH); // Turn on Green indicator light
  Serial.print("HEATER ON"); //serial port for debug
  
  lcd.clear(); // Clears the LCD Information
  
  lcd.setCursor(0,0); 
  lcd.print("Blower On");
  lcd.setCursor(0,1);
  lcd.print("2 Min Cycle"); // Change to amount of Delay if wanted.
  
  delay (120000); // Delay 2 minutes to keep relay from recycling until temp normalizes.
}
 /********************************************************************/     
      delay(100); //Update at every 100mSeconds
 
} 
