/*FUNCTIONS SUPPORTED
 * BouncingBalls(0xff,0,0, 3); 
 *        BouncingBalls(byte red, byte green, byte blue, int BallCount)
 *        Time to run: 
 * BouncingColoredBalls(3, colors);
 *        byte colors[3][3] = { {0xff,0,0},{0xff,0xff,0xff},{0,0,0xff} };
 *        BouncingColoredBalls(int BallCount, byte colors[][3])
 * RainbowCycle(20)
 *        void RainbowCycle(int SpeedDelay) 
 * RunningLights(0xff,0xff,0x00, 50);
 *        RunningLights(byte red, byte green, byte blue, int WaveDelay)
 * Fire(55,120,15)
 *       (int Cooling, int Sparking, int SpeedDelay)
 * ColorWipe(0x00,0xff,0x00, 50);
 *        void colorWipe(byte red, byte green, byte blue, int SpeedDelay)
 * SnowSparkle(0x10, 0x10, 0x10, 20, random(100,1000));       
 *        SnowSparkle(byte red, byte green, byte blue, int SparkleDelay, int SpeedDelay) 
 * TheaterChaseRainbow(50)
 *        theaterChaseRainbow(int SpeedDelay)
 * RGBLoop()
 * HalloweenEyes(0xff, 0x00, 0x00, 1, 4,true, random(5,50), random(50,150),random(1000, 10000));       
 *        HalloweenEyes(byte red, byte green, byte blue,int EyeWidth, int EyeSpace, 
 *                      boolean Fade, int Steps, int FadeDelay,int EndPause)
 * FadeInOut(0xff, 0x00, 0x00); // red
 * FadeInOut(0xff, 0xff, 0xff); // white 
 * FadeInOut(0x00, 0x00, 0xff); // blue
 *        FadeInOut(byte red, byte green, byte blue)
 * CylonBounce(0xff, 0, 0, 4, 10, 50);              
 *        CylonBounce(byte red, byte green, byte blue, int EyeSize, int SpeedDelay, int ReturnDelay)
 *               
 */

void FadeInOut(byte red, byte green, byte blue){
  float r, g, b;
      
  for(int k = 0; k < 256; k=k+2) { 
    r = (k/256.0)*red;
    g = (k/256.0)*green;
    b = (k/256.0)*blue;
    setAll(r,g,b);
    showStrip();
  }
     
  for(int k = 255; k >= 0; k=k-4) {
    r = (k/256.0)*red;
    g = (k/256.0)*green;
    b = (k/256.0)*blue;
    setAll(r,g,b);
    showStrip();
  }
}

void FadeInOutHTML(unsigned long exColor, byte SpeedDelay){
  loopStart = millis();
  while(animate){
  float r, g, b;
  byte red = ((exColor & 0xf00000)>>16)+16*(exColor & 0xf00000)>>20;
  byte green = (((exColor & 0xf000)>>8)+16*(exColor & 0xf000)>>12);
  byte blue = ((exColor & 0x0f)+((exColor & 0xf0)>>4)*16);
      
  for(int k = 0; k < 256; k=k+4) { 
    r = (k/256.0)*red;
    g = (k/256.0)*green;
    b = (k/256.0)*blue;
    setAll(r,g,b);
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();
    if(!animate) { break;}
    delay(SpeedDelay);
  }
     
  for(int k = 255; k >= 0; k=k-4) {
    r = (k/256.0)*red;
    g = (k/256.0)*green;
    b = (k/256.0)*blue;
    setAll(r,g,b);
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();
    if(!animate) { break;}
    delay(SpeedDelay);
  }
  }
}

void FadeInOutHTML(unsigned long exColor, byte SpeedDelay, int timeToRun){
  loopStart = millis();
  while(animate){
  float r, g, b;
  byte red = ((exColor & 0xf00000)>>16)+16*(exColor & 0xf00000)>>20;
  byte green = (((exColor & 0xf000)>>8)+16*(exColor & 0xf000)>>12);
  byte blue = ((exColor & 0x0f)+((exColor & 0xf0)>>4)*16);
      
  for(int k = 0; k < 256; k=k+4) { 
    r = (k/256.0)*red;
    g = (k/256.0)*green;
    b = (k/256.0)*blue;
    setAll(r,g,b);
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();
    if(millis()-loopStart>timeToRun) animate = false;
    if(!animate) { break;}
    delay(SpeedDelay);
  }
     
  for(int k = 255; k >= 0; k=k-4) {
    r = (k/256.0)*red;
    g = (k/256.0)*green;
    b = (k/256.0)*blue;
    setAll(r,g,b);
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();
    if(millis()-loopStart>timeToRun) animate = false;
    if(!animate) { break;}
    delay(SpeedDelay);
  }
  }
}

void CylonBounce(byte red, byte green, byte blue, int EyeSize, int SpeedDelay, int ReturnDelay){
  loopStart = millis();
  while(animate){
    
    
  for(int i = 0; i < NUM_LEDS-EyeSize-2; i++) {
    setAll(0,0,0);
    setPixel(i, red/10, green/10, blue/10);
    for(int j = 1; j <= EyeSize; j++) {
      setPixel(i+j, red, green, blue); 
    }
    setPixel(i+EyeSize+1, red/10, green/10, blue/10);
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();if(!animate) { break;}  
    delay(SpeedDelay);
  }

  delay(ReturnDelay);

  for(int i = NUM_LEDS-EyeSize-2; i > 0; i--) {
    setAll(0,0,0);
    setPixel(i, red/10, green/10, blue/10);
    for(int j = 1; j <= EyeSize; j++) {
      setPixel(i+j, red, green, blue); 
    }
    setPixel(i+EyeSize+1, red/10, green/10, blue/10);
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();if(!animate) { break;}  
    delay(SpeedDelay);
  }
  animationTimeout = millis()-loopStart; CheckInput();if(!animate) { break;}  
  Rest(ReturnDelay);
  red = random(255);
  green = random(255);
  blue = random(255);
  }
}

void BouncingBalls(byte red, byte green, byte blue, int BallCount) {
  loopStart = millis();
  while(animate){
  float Gravity = -9.81;
  int StartHeight = 1;
  long endTime2 = millis()+10000;
  float Height[BallCount];
  float ImpactVelocityStart = sqrt( -2 * Gravity * StartHeight );
  float ImpactVelocity[BallCount];
  float TimeSinceLastBounce[BallCount];
  int   Position[BallCount];
  long  ClockTimeSinceLastBounce[BallCount];
  float Dampening[BallCount];
  
  
  for (int i = 0 ; i < BallCount ; i++) {   
    ClockTimeSinceLastBounce[i] = millis();
    Height[i] = StartHeight;
    Position[i] = 0; 
    ImpactVelocity[i] = ImpactVelocityStart;
    TimeSinceLastBounce[i] = 0;
    Dampening[i] = 0.90 - float(i)/pow(BallCount,2); 
  }

  while (millis()<endTime2) {
    for (int i = 0 ; i < BallCount ; i++) {
      TimeSinceLastBounce[i] =  millis() - ClockTimeSinceLastBounce[i];
      Height[i] = 0.5 * Gravity * pow( TimeSinceLastBounce[i]/1000 , 2.0 ) + ImpactVelocity[i] * TimeSinceLastBounce[i]/1000;
  
      if ( Height[i] < 0 ) {                      
        Height[i] = 0;
        ImpactVelocity[i] = Dampening[i] * ImpactVelocity[i];
        ClockTimeSinceLastBounce[i] = millis();
  
        if ( ImpactVelocity[i] < 0.01 ) {
          ImpactVelocity[i] = ImpactVelocityStart;
        }
      }
      Position[i] = round( Height[i] * (NUM_LEDS - 1) / StartHeight);
      animationTimeout = millis()-loopStart; CheckInput(); if(!animate) { break;}
    }
  
    for (int i = 0 ; i < BallCount ; i++) {
      setPixel(Position[i],red,green,blue);
    }
    animationTimeout = millis()-loopStart; CheckInput(); if(!animate) { break;}
    showStrip();
    setAll(0,0,0);
  }
  animationTimeout = millis()-loopStart; CheckInput(); if(!animate) { break;}
}
}


void BouncingColoredBalls(int BallCount, byte colors[][3]) {
  float Gravity = -9.81;
  int StartHeight = 1;
  long endTime2 = millis()+10000;
  float Height[BallCount];
  float ImpactVelocityStart = sqrt( -2 * Gravity * StartHeight );
  float ImpactVelocity[BallCount];
  float TimeSinceLastBounce[BallCount];
  int   Position[BallCount];
  long  ClockTimeSinceLastBounce[BallCount];
  float Dampening[BallCount];
  
  for (int i = 0 ; i < BallCount ; i++) {   
    ClockTimeSinceLastBounce[i] = millis();
    Height[i] = StartHeight;
    Position[i] = 0; 
    ImpactVelocity[i] = ImpactVelocityStart;
    TimeSinceLastBounce[i] = 0;
    Dampening[i] = 0.90 - float(i)/pow(BallCount,2); 
  }

  while (millis()<endTime2) {
    for (int i = 0 ; i < BallCount ; i++) {
      TimeSinceLastBounce[i] =  millis() - ClockTimeSinceLastBounce[i];
      Height[i] = 0.5 * Gravity * pow( TimeSinceLastBounce[i]/1000 , 2.0 ) + ImpactVelocity[i] * TimeSinceLastBounce[i]/1000;
  
      if ( Height[i] < 0 ) {                      
        Height[i] = 0;
        ImpactVelocity[i] = Dampening[i] * ImpactVelocity[i];
        ClockTimeSinceLastBounce[i] = millis();
  
        if ( ImpactVelocity[i] < 0.01 ) {
          ImpactVelocity[i] = ImpactVelocityStart;
        }
      }
      Position[i] = round( Height[i] * (NUM_LEDS - 1) / StartHeight);
    }
  
    for (int i = 0 ; i < BallCount ; i++) {
      setPixel(Position[i],colors[i][0],colors[i][1],colors[i][2]);
    }
    
    showStrip();
    setAll(0,0,0);
  }
}

void RainbowCycle(int SpeedDelay) {
  Serial.println("Starting Rainbow Cycle");
  loopStart = millis();
  while(animate){
  byte *c;
  uint16_t i, j;

  for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
    for(i=0; i< NUM_LEDS; i++) {
      if(!animate) { break;}
      c=Wheel(((i * 256 / NUM_LEDS) + j) & 255);
      setPixel(i, *c, *(c+1), *(c+2));
      animationTimeout = millis()-loopStart; CheckInput();
    }
    if(!animate) { break;}
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();
    delay(SpeedDelay);
  }
}}
byte * Wheel(byte WheelPos) {
  static byte c[3];
  
  if(WheelPos < 85) {
   c[0]=WheelPos * 3;
   c[1]=255 - WheelPos * 3;
   c[2]=0;
  } else if(WheelPos < 170) {
   WheelPos -= 85;
   c[0]=255 - WheelPos * 3;
   c[1]=0;
   c[2]=WheelPos * 3;
  } else {
   WheelPos -= 170;
   c[0]=0;
   c[1]=WheelPos * 3;
   c[2]=255 - WheelPos * 3;
  }

  return c;
}

void RunningLights(byte red, byte green, byte blue, int WaveDelay) {
  int Position=0;
  
  for(int i=0; i<NUM_LEDS*2; i++)
  {
      Position++; // = 0; //Position + Rate;
      for(int i=0; i<NUM_LEDS; i++) {
        // sine wave, 3 offset waves make a rainbow!
        //float level = sin(i+Position) * 127 + 128;
        //setPixel(i,level,0,0);
        //float level = sin(i+Position) * 127 + 128;
        setPixel(i,((sin(i+Position) * 127 + 128)/255)*red,
                   ((sin(i+Position) * 127 + 128)/255)*green,
                   ((sin(i+Position) * 127 + 128)/255)*blue);
      }
      
      showStrip();
      delay(WaveDelay);
  }
}

void Fire(int Cooling, int Sparking, int SpeedDelay) {
  
  
  loopStart = millis();
  while(animate){
    static byte heat[NUM_LEDS];
    int cooldown;
    // Step 1.  Cool down every cell a little
    for( int i = 0; i < NUM_LEDS; i++) {
      cooldown = random(0, ((Cooling * 10) / NUM_LEDS) + 2);
      
      if(cooldown>heat[i]) {
        heat[i]=0;
      } else {
        heat[i]=heat[i]-cooldown;
      }
    }
    
    // Step 2.  Heat from each cell drifts 'up' and diffuses a little
    for( int k= NUM_LEDS - 1; k >= 2; k--) {
      heat[k] = (heat[k - 1] + heat[k - 2] + heat[k - 2]) / 3;
    }
      
    // Step 3.  Randomly ignite new 'sparks' near the bottom
    if( random(255) < Sparking ) {
      int y = random(7);
      heat[y] = heat[y] + random(160,255);
      //heat[y] = random(160,255);
    }
  
    // Step 4.  Convert heat to LED colors
    for( int j = 0; j < NUM_LEDS; j++) {
      SetPixelHeatColor(j, heat[j] );
    }
  
    showStrip();
    animationTimeout = millis()-loopStart; CheckInput();
    delay(SpeedDelay);
  }
}
void SetPixelHeatColor (int Pixel, byte temperature) {
  // Scale 'heat' down from 0-255 to 0-191
  byte t192 = round((temperature/255.0)*191);
 
  // calculate ramp up from
  byte heatramp = t192 & 0x3F; // 0..63
  heatramp <<= 2; // scale up to 0..252
 
  // figure out which third of the spectrum we're in:
  if( t192 > 0x80) {                     // hottest
    setPixel(Pixel, 255, 255, heatramp);
  } else if( t192 > 0x40 ) {             // middle
    setPixel(Pixel, 255, heatramp, 0);
  } else {                               // coolest
    setPixel(Pixel, heatramp, 0, 0);
  }
}

void ColorWipe(byte red, byte green, byte blue, int SpeedDelay) {
  for(uint16_t i=0; i<NUM_LEDS; i++) {
      setPixel(i, red, green, blue);
      showStrip();
      delay(SpeedDelay);
  }
}

void SnowSparkle(byte red, byte green, byte blue, int SparkleDelay, int SpeedDelay) {
  long loopStart = millis();
  while(animate){
  SpeedDelay = random(50,1500);
  
  setAll(red,green,blue);
  int Pixel = random(NUM_LEDS);
  setPixel(Pixel,0xff,0xff,0xff);
  showStrip();
  animationTimeout = millis()-loopStart; CheckInput(); if(!animate) {break;}
  Rest(SparkleDelay);
  setPixel(Pixel,red,green,blue);
  showStrip();
  animationTimeout = millis()-loopStart; CheckInput(); if(!animate) {break;}
  Rest(SpeedDelay);
  animationTimeout = millis()-loopStart; CheckInput(); if(!animate) {break;}
  }
}

void TheaterChaseRainbow(int SpeedDelay) {
  byte *c;
  
  for (int j=0; j < 256; j=j+3) {     // cycle all 256 colors in the wheel
    for (int q=0; q < 3; q++) {
        for (int i=0; i < NUM_LEDS; i=i+3) { 
          c = Wheel( (i+j) % 255);
          setPixel(i+q, *c, *(c+1), *(c+2));    //turn every third pixel on
        }
        showStrip();
       
        delay(SpeedDelay);
       
        for (int i=0; i < NUM_LEDS; i=i+3) {
          setPixel(i+q, 0,0,0);        //turn every third pixel off
        }
    }
  }
}

void TheaterChaseRainbow2(int SpeedDelay) {
  byte *c;
  
  for (int j=256; j >0; j=j-3) {     // cycle all 256 colors in the wheel
    for (int q=0; q < 3; q++) {
        for (int i=0; i < NUM_LEDS; i=i+3) { 
          c = Wheel( (i+j) % 255);
          setPixel(i+q, *c, *(c+1), *(c+2));    //turn every third pixel on
        }
        showStrip();
       
        delay(SpeedDelay);
       
        for (int i=0; i < NUM_LEDS; i=i+3) {
          setPixel(i+q, 0,0,0);        //turn every third pixel off
        }
    }
  }
}

void RGBLoop(){
  loopStart = millis();
  while(animate){
  for(int j = 0; j < 3; j++ ) { 
    // Fade IN
    for(int k = 0; k < 256; k+=4) { 
      switch(j) { 
        case 0: setAll(k,0,0); break;
        case 1: setAll(0,k,0); break;
        case 2: setAll(0,0,k); break;
      }
      showStrip();
      animationTimeout = millis()-loopStart; CheckInput();if(!animate) { break;}      
      delay(fadeSpeedDelay/10);
    }
    // Fade OUT
    for(int k = 255; k >= 0; k-=4) { 
      switch(j) { 
        case 0: setAll(k,0,0); break;
        case 1: setAll(0,k,0); break;
        case 2: setAll(0,0,k); break;
      }
      showStrip();
      animationTimeout = millis()-loopStart; CheckInput();if(!animate) { break;} 
      delay(fadeSpeedDelay/10);
    }
  }
  animationTimeout = millis()-loopStart; CheckInput();if(!animate) { break;} 
}
}

void HalloweenEyes(byte red, byte green, byte blue,int EyeWidth, int EyeSpace,boolean Fade, int Steps, int FadeDelay,int EndPause){
  randomSeed(analogRead(0));
  
  int i;
  int StartPoint  = random( 0, NUM_LEDS - (2*EyeWidth) - EyeSpace );
  int Start2ndEye = StartPoint + EyeWidth + EyeSpace;
  
  for(i = 0; i < EyeWidth; i++) {
    setPixel(StartPoint + i, red, green, blue);
    setPixel(Start2ndEye + i, red, green, blue);
  }
  
  showStrip();
  
  if(Fade==true) {
    float r, g, b;
  
    for(int j = Steps; j >= 0; j--) {
      r = j*(red/Steps);
      g = j*(green/Steps);
      b = j*(blue/Steps);
      
      for(i = 0; i < EyeWidth; i++) {
        setPixel(StartPoint + i, r, g, b);
        setPixel(Start2ndEye + i, r, g, b);
      }
      
      showStrip();
      delay(FadeDelay);
    }
  }
  
  setAll(0,0,0); // Set all black
  
  Rest(EndPause);
}

void showStrip() {
   FastLED.show();
}
void setPixel(int Pixel, byte red, byte green, byte blue) {
   // FastLED
   leds[Pixel].r = red;
   leds[Pixel].g = green;
   leds[Pixel].b = blue;
}
void setAll(byte red, byte green, byte blue) {
  for(int i = 0; i < NUM_LEDS; i++ ) {
    setPixel(i, red, green, blue); 
  }
  showStrip();
}


