void SoundReactive()
{
  maxEverSound = 1;
  topLitPixel = 1;
  micMillis = millis();
  int thisColorCode2 = random(0,colorArraySize);
  Serial.print("colorCode"); Serial.print("\t\t"); 
  thisColorCode2 = colorHexArray[thisColorCode2];
  Serial.println("colorCode");
  loopStart = millis();
  unsigned long resetMaxMillis = millis();
    
  while(animate) {
    
  currentSound = GetSoundLevel();
    //Turn on lights
    if(currentSound > (prevSound+1))
    { int tempSound = currentSound;
      if(currentSound > 196) currentSound = 208; //if it's going to light up one acrylic, light up all of them. 
      for(int i = 0; i< (currentSound); i++)
      {
        leds[i] = thisColorCode2;
      }
      if(currentSound>topLitPixel) topLitPixel = currentSound;
      FastLED.show();
      currentSound = tempSound;
    }
    else 
    {//Fade off some lights
      for(int i = NUM_LEDS-1; i > topLitPixel; i--)
      {
        leds[i].fadeToBlackBy(32);
      }
      topLitPixel -= 4;
      if(topLitPixel >NUM_LEDS) topLitPixel = 0;
      FastLED.show();
    }
    prevSound = currentSound;
    animationTimeout = millis()-loopStart; 
    CheckInput();
     if(!animate) { break;}
    if (millis()-resetMaxMillis >2000)
    {
      resetMaxMillis = millis();
      if(maxEverSound>1) maxEverSound *= 0.75;
      Serial.print("Reset maxEverSound to ");
      Serial.println(maxEverSound);
    }
  }
}

void SoundReactive(unsigned long thisColorCode2)
{
  maxEverSound = 1;
  topLitPixel = 1;
  micMillis = millis();
  loopStart = millis();
  unsigned long resetMaxMillis = millis();
  while(animate)
  {
   
    currentSound = GetSoundLevel();
    //Turn on lights
    if(currentSound > (prevSound+1))
    { int tempSound = currentSound;
      if(currentSound > 196){ currentSound = 208; maxEverSound *= 0.96;} //if it's going to light up one acrylic, light up all of them. 
      for(int i = 0; i< (currentSound); i++)
      {
        leds[i] = thisColorCode2;
      }
      if(currentSound>topLitPixel) topLitPixel = currentSound;
      FastLED.show();
      currentSound = tempSound;
    }
    else 
    {//Fade off some lights
      for(int i = NUM_LEDS-1; i > topLitPixel; i--)
      {
        leds[i].fadeToBlackBy(32);
      }
      topLitPixel -= 4;
      if(topLitPixel >NUM_LEDS) topLitPixel = 0;
      FastLED.show();
    }
    prevSound = currentSound;
    animationTimeout = millis()-loopStart; 
    CheckInput();
     if(!animate) { break;}
    if (millis()-resetMaxMillis >2000)
    {
      resetMaxMillis = millis();
      maxEverSound *= 0.75;
      Serial.print("Reset maxEverSound to ");
      Serial.println(maxEverSound);
    }
  }
}

void SoundReactiveRainbow()
{
  maxEverSound = 1;
  topLitPixel = 1;
  micMillis = millis();
  loopStart = millis();
  unsigned long resetMaxMillis = millis();
  int r,g,b, fadeState;
  r = 255; g = 0; b = 0; fadeState = 1;
  while(animate) {
    //Fade some colors
    if(fadeSpeedDelay <= 0) fadeSpeedDelay = 5;
    byte myFadeColorVal = (35-fadeSpeedDelay)/5;
    //Serial.print("fadeColor: "); Serial.print(myFadeColorVal);
    //Serial.print("\tr:"); Serial.print(r);
    //Serial.print("\tg:"); Serial.print(g);
    //Serial.print("\tb:"); Serial.println(b);
    switch(fadeState)
    {
      case 1: g += myFadeColorVal; if(g>=255) {g=255;  fadeState++;} break;
      case 2: r -= myFadeColorVal; if(r<=0){ r=0;      fadeState++;} break;
      case 3: b += myFadeColorVal; if(b>=255) {b=255;  fadeState++; }break;
      case 4: g -= myFadeColorVal; if(g<=0) {g=0;      fadeState++;} break;
      case 5: r += myFadeColorVal; if(r>=255){ r=255; fadeState++; }break;
      case 6: b -= myFadeColorVal; if(b<=0) {b=0;      fadeState = 1;}break;
    }
    
    currentSound = GetSoundLevel();
    //Turn on lights
    if(currentSound > (prevSound+1))
    { int tempSound = currentSound;
      if(currentSound > 196) { currentSound = 208; maxEverSound *= 0.92;} //if it's going to light up one acrylic, light up all of them. 
      for(int i = 0; i< (currentSound); i++)
      {
        leds[i] = CRGB(r,g,b);
      }
      if(currentSound>topLitPixel) topLitPixel = currentSound;
      FastLED.show();
      currentSound = tempSound;
    }
    else 
    {//Fade off some lights
      for(int i = NUM_LEDS-1; i > topLitPixel; i--)
      {
        leds[i].fadeToBlackBy(32);
      }
      topLitPixel -= 4;
      if(topLitPixel >NUM_LEDS) topLitPixel = 0;
      FastLED.show();
    }
    prevSound = currentSound;
    animationTimeout = millis()-loopStart; 
    CheckInput();
    if(!animate) { break;}
    if (millis()-resetMaxMillis >2000)
    {
      resetMaxMillis = millis();
      if(maxEverSound>1) maxEverSound *= 0.75;
      Serial.print("Reset maxEverSound to ");
      Serial.println(maxEverSound);
    }
  }
}

void SoundPulseRainbow()
{
  maxEverSound = 1;
  topLitPixel = 1;
  micMillis = millis();
  loopStart = millis();
  unsigned long resetMaxMillis = millis();
  int theseLEDS = 196;
  int r,g,b, fadeState;
  r = 255; g = 0; b = 0; fadeState = 1;
  
  while(animate) {
    
  if(fadeSpeedDelay == 0) fadeSpeedDelay = 5;
    byte myFadeColorVal = (35-fadeSpeedDelay)/5;
    //Serial.print("fadeColor: "); Serial.print(myFadeColorVal);
    //Serial.print("\tr:"); Serial.print(r);
    //Serial.print("\tg:"); Serial.print(g);
    //Serial.print("\tb:"); Serial.println(b);
    switch(fadeState)
    {
      case 1: g += myFadeColorVal; if(g>=255) {g=255;  fadeState++;} break;
      case 2: r -= myFadeColorVal; if(r<=0){ r=0;      fadeState++;} break;
      case 3: b += myFadeColorVal; if(b>=255) {b=255;  fadeState++; }break;
      case 4: g -= myFadeColorVal; if(g<=0) {g=0;      fadeState++;} break;
      case 5: r += myFadeColorVal; if(r>=255){ r=255; fadeState++; }break;
      case 6: b -= myFadeColorVal; if(b<=0) {b=0;      fadeState = 1;}break;
    }
    

     //currentSound = GetSoundLevel()*1.224; //GetSoundLevel is 0-208, so 1.224*208 = 255. 
     currentSound = map(GetSoundLevel(),0,208,0,255);
    //Turn on lights
    Serial.print("_");
    Serial.print(currentSound);
    Serial.println("_");
    //delay(50);

    if(currentSound > 220) { //For loud noises, also light up Acrylic
         //maxEverSound *= 0.96; 
         theseLEDS = 208;  } 
    else {
         theseLEDS = 196;
          }
 
      
    if(currentSound > (prevSound+50))
    { int tempSound = currentSound;
      Serial.print("Ran1\t\t");
      for(int i = 0; i< (theseLEDS); i++)
      {leds[i] = CRGB(r,g,b);}
      
      FastLED.setBrightness(currentSound);
      FastLED.show();
      prevSound = currentSound;
    }
//    else if (currentSound <40){ //if it's kinda quiet
//      Serial.print("Ran2\t\t");
//        FastLED.setBrightness(15);
//        for(int i = 196; i<= 208; i++)
//          {
//            leds[i] = CRGB(0,0,0); //Turn off acrylic lights 
//          }
//        FastLED.show();
//    }
    else 
    {//Fade the acrylic, dim everything else
      Serial.print("Ran3\t\t");
      if(prevSound > 0) prevSound -=1;  //dim by 1 (of 255)
      for(int i = 196; i <=208; i++)
      {
        leds[i].fadeToBlackBy(2); //Acrylic
      }

      for(int i = 0; i< (theseLEDS); i++)
      {leds[i].fadeToBlackBy(8);}//The rest of the lights
      
      //FastLED.setBrightness(prevSound);
      FastLED.show();
    }
    
    prevSound = currentSound;
    animationTimeout = millis()-loopStart; 
    CheckInput();
    if (millis()-resetMaxMillis >5000)
    {
      resetMaxMillis = millis();
      if(maxEverSound>1) maxEverSound *= 0.75;
      Serial.print("\tResetMaxTo:");
      Serial.print(maxEverSound);
      Serial.print("\t\t");
    }
  }
  FastLED.setBrightness(brightLevel);
  
}

unsigned int GetSoundLevel()
{
  micMillis = millis();
  peakToPeak = 0;
  signalMax = 0;
  signalMin = 1024;
  while (millis() - micMillis < sampleWindow)
   {
      sample = analogRead(inputPin);
      if (sample < 1024)  // toss out spurious readings
      {
         if (sample > signalMax)
         {
            signalMax = sample;  // save just the max levels
         }
         else if (sample < signalMin)
         {
            signalMin = sample;  // save just the min levels
         }
      }
   }
    
  peakToPeak = signalMax - signalMin;  // max - min = peak-peak amplitude
  if(peakToPeak > maxEverSound)
    maxEverSound = peakToPeak;
  if(peakToPeak < minEverSound)
    minEverSound = peakToPeak;
  //peakToPeak = map(peakToPeak,1,maxEverSound,0,104); //Make sure peakToPeak doesn't exceed 104 (half the # lights)
  //peakToPeak = map(peakToPeak,minEverSound,maxEverSound,0,208); //Make sure peakToPeak doesn't exceed 208 (# of lights)
  peakToPeak = map(peakToPeak,0,maxEverSound,0,208); //Make sure peakToPeak doesn't exceed 208 (# of lights)
  return peakToPeak;
}
