/*Use this file for testing new functions with the paw
 * 
 * 
 */

#include <FastLED.h>
#define NUM_LEDS 209  //Important!
#define PIN 6    //Also important.  Needs to be a PWM pin.
CRGB leds[NUM_LEDS];  

//Various custom setup
byte command = 25;
byte prevCommand = 33;
volatile boolean animate = true;
volatile long animationTimeout, restTimeout;
byte commandArray[2] = {0,0};
byte brightLevel = 105;
byte maxNumColorModes = 5;
int colorMode = 1;
byte fadeSpeedDelay = 20; //range of 0 to 35
unsigned long loopStart = millis();

//Color reference setup
String colorArray[] = {"Red","Green","Blue","White","Indigo","Yellow","DarkOrange","ClemsonOrange","ClemsonPurple",
  "Aquamarine","Cyan","DodgerBlue","DeepPink","HotPink","Teal","MediumSeaGreen","Crimson","Orange"};
unsigned long colorHexArray[] = {0xFF0000,0x008000,0x0000FF,0xFFFFFF,0x4B0082,0xFFFF00,0xFF8C00,0xFF4500,0x8A2BE2,
      0x7FFFD4,0x00FFFF,0x1E90FF,0xFF1493,0xFF69B4,0x008080,0x3CB371,0xDC143C,0xFFA500};
String currentColorName = "Red";
String prevColorName = "a";
unsigned long thisColorCode = 0x008000;
byte colorArraySize = 18;

//Sets of lights for Clemson, Tigers, and acrylic parts
byte lightsClemson[] = {170,171,172,173,174,175,176,177,178,179,180,181,182,183,184};
byte lightsTigers[] = {185,186,187,188,189,190,191,192,193,194,195,196};
byte lightsAllAcrylic[] = {197,198,199,200,201,202,203,204,205,206,207,208};
byte lightsAcrylic1[] = {197,198,199};
byte lightsAcrylic2[] = {200,201,202};
byte lightsAcrylic3[] = {203,204,205};
byte lightsAcrylic4[] = {206,207,208};


//Microphone setup
const int sampleWindow = 10;  // Sample window width in mS (50 mS = 20Hz)
#define inputPin 2            //7 is MEMS, 2 is the other
unsigned int sample, peakToPeak, signalMax, signalMin, currentSound, prevMax, prevMin, prevSound;
unsigned long micMillis = millis();
unsigned int maxEverSound = 1;
unsigned int minEverSound = 1000;
unsigned int topLitPixel = 1;

void setup() 
{
 Serial.begin(115200);
 //Serial.println("Starting...");
 FastLED.addLeds<NEOPIXEL, PIN> (leds, NUM_LEDS);
 FastLED.setCorrection(TypicalLEDStrip);
 //FastLED.setMaxPowerInVoltsAndMilliamps(5,maxMilliamps);
FastLED.setBrightness(105);
for(int i = 0; i<NUM_LEDS; i++)
{
  leds[i]= CRGB::OrangeRed;
  FastLED.show();
}
delay(200);
 
 FastLED.setBrightness(brightLevel); //get rid of this if you want to be blinded on startup 
 //setAll(0,0,0);
 TurnOff();
 Serial.println("Ran Setup");
 Serial.print("  ");
 Serial.println(colorArraySize);
    
}

void loop() {
    
  animate = true;
  animationTimeout = 0;
  
  switch(command){
    case 1: //Increase brightness
    if(brightLevel<255) brightLevel+=25;
    FastLED.setBrightness(brightLevel);
    //showStrip();
    command = prevCommand;
    colorMode--;
    break;
    
    case 2: //decrease brightness
    if(brightLevel>5) brightLevel-=25;
    FastLED.setBrightness(brightLevel);
    //showStrip();
    command = prevCommand;
    colorMode--;
    break;

    case 32: 
    if(fadeSpeedDelay<40) fadeSpeedDelay+=5;
    showStrip();
    command = prevCommand;
    colorMode--;
    break;

    case 28: 
    if(fadeSpeedDelay>0) fadeSpeedDelay-=5;
    showStrip();
    command = prevCommand;
    colorMode--;
    break;
    
  }
  
  prevCommand = command;
  switch(command){
    //case 1
    //case 2
    case 3: AutoMode(); break;
    case 4: TurnOff(); break;
    case 5: currentColorName = "Red"; FillColor();  break;
    case 6: currentColorName = "Green"; FillColor();  break;
    case 7: currentColorName = "Blue"; FillColor(); break;
    case 8: currentColorName = "White"; FillColor(); break;
    case 9: currentColorName = "ClemsonOrange"; FillColor();   break;//ClemsonOrange = OrangeRed
    case 10: currentColorName = "Aquamarine"; FillColor();  break;
    case 11: currentColorName = "DodgerBlue"; FillColor();   break;
    case 12: currentColorName = "HotPink"; FillColor();   break;
    case 13: currentColorName = "DarkOrange"; FillColor();  break;
    case 14: currentColorName = "MediumSeaGreen"; FillColor();   break;
    case 15: currentColorName = "ClemsonPurple"; FillColor(); break;
    case 16: currentColorName = "Crimson"; FillColor();   break;
    case 17: currentColorName = "Orange"; FillColor();   break;
    case 18: currentColorName = "Teal"; FillColor();   break;
    case 19: currentColorName = "Indigo"; FillColor();  break;
    case 20: currentColorName = "Cyan"; FillColor();   break;
    case 21: currentColorName = "Yellow"; FillColor();   break;
    case 22: currentColorName = "Alternate22"; BouncingBalls(0,0,0xff, 3);   break;
    case 23: currentColorName = "DeepPink"; FillColor();   break;
    case 24:   Rest();  break;
    case 25: currentColorName = "Alternate25"; AlternateColors("ClemsonOrange","Indigo");   break;
    case 26: currentColorName = "Alternate26"; AlternateColors("Green","Red");   break;
    case 27: currentColorName = "Alternate27"; AlternateColors("Blue","Orange");   break;

    case 29: currentColorName = "Alternate29"; AlternateColors("Red","White");    break;
    case 30: currentColorName = "Alternate30"; AlternateColors("Green","White");   break;
    case 31: currentColorName = "Alternate31"; AlternateColors("Blue","White");   break;

    case 33:  currentColorName = "Alternate31"; AlternateColors("ClemsonOrange","White");   break;
    case 34:  currentColorName = "Alternate34"; CylonBounce(random(255), random(255), random(255), random(15,40), fadeSpeedDelay/2, 50);     break;
    case 35:  SoundReactive();  break;
    case 36:  SoundReactiveRainbow();   break;
    case 37:  Rest();   break;
    case 38:  Rest();   break;
    case 39:  Rest();   break;
    case 40:  currentColorName = "Alternate40"; SnowSparkle(0x10, 0x10, 0x10, 40, random(50,1200));   break;
    case 41:  currentColorName = "Alternate41"; RGBLoop();  break; //
    case 42:  Fire(55,120,5);  break;
    case 43:  SoundPulseRainbow(); break;
    case 44:  RainbowCycle(fadeSpeedDelay); break;

    default:
    animationTimeout=0;
    Rest();
    break;
  }
}
void CheckInput()
{
  if(animationTimeout > 100){
    if(Serial.available()>0){
      Serial.readBytes(commandArray,2);
      byte dig1 = commandArray[0];
      byte dig2 = commandArray[1];
      command = dig1*10+dig2;
      Serial.print("\n\nGot command: ");
      Serial.println(int(command));
      animate = false;
    }
  }
}

void Rest()
{
  loopStart = millis();
  while(animate)
  {
    animationTimeout = millis()-loopStart;
    CheckInput();
  }
}

void Rest(int restTime)
{
  loopStart = millis();
  while(animate)
  {
    
    animationTimeout = millis()-loopStart;
    restTimeout = millis()-loopStart;
    CheckInput();
    if(restTimeout>restTime)
      break;
  }
}

void AutoMode()
{
  int autoChangingDelay = fadeSpeedDelay*150;
  long loopStart = millis();
  unsigned long loopStart1 = millis();
  Serial.print("colorArraySize = "); Serial.println(colorArraySize);
  if(autoChangingDelay<500) autoChangingDelay = 500;
  while(animate)
  {
    byte runThing = random(1,7);
    byte solidFillCaseNum = random(1,6);
    int array1Spot = random(0,colorArraySize);
    int array2Spot = random(0,colorArraySize);
    bool runThisSub = true;
    Serial.print("runThing = "); Serial.println(runThing);
    switch(runThing)
    {
      case 1: case 2: case 3: //one of the single color ones
        Serial.print("Array1Spot:");
        Serial.print(array1Spot);
        Serial.print("    ");
        Serial.print("solidFillCaseNum:"); Serial.println(solidFillCaseNum);
        currentColorName = colorArray[array1Spot];
        for (int i = 0; i< sizeof(colorArray); i++)//Get the color code
         {if(colorArray[i] == currentColorName)
            {thisColorCode = colorHexArray[i]; //get the Hex code for the color
          }}
          
       switch(solidFillCaseNum)//solid color setting
          {
            case 1: //Fill all
            fill_solid(leds,NUM_LEDS,thisColorCode);
            FastLED.show();
            Rest(autoChangingDelay);
            break;
            
            case 2: //Clemson+tigers+acrylics
            fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black  
            for(int i = 0; i<sizeof(lightsClemson); i++)
              leds[lightsClemson[i]] = thisColorCode;
            for(int i = 0; i<sizeof(lightsTigers); i++)
              leds[lightsTigers[i]] = thisColorCode;
            for(int i = 0; i<sizeof(lightsAllAcrylic); i++)
              leds[lightsAllAcrylic[i]] = thisColorCode;
            FastLED.show();
            Rest(autoChangingDelay);
            break;
            
            case 4: //Clemson+tigers
            fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black 
            for(int i = 0; i<sizeof(lightsClemson); i++)
              leds[lightsClemson[i]] = thisColorCode;
            for(int i = 0; i<sizeof(lightsTigers); i++)
              leds[lightsTigers[i]] = thisColorCode;
            FastLED.show();
            Rest(autoChangingDelay);
            break;
      
            case 5: //acrylic only
            fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black 
            for(int i = 0; i<sizeof(lightsAllAcrylic); i++)
              leds[lightsAllAcrylic[i]] = thisColorCode;
            FastLED.show();
            Rest(autoChangingDelay);
            break;
      
            case 3: 
            FadeInOutHTML(thisColorCode,fadeSpeedDelay, autoChangingDelay*2);
            break;
          }
       CheckInput();
      break;    
        
    case 4: //fading rainbow
    loopStart1 = millis();
      while(animate && runThisSub){
        byte *c;
        uint16_t i, j;
      
        for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
          for(i=0; i< NUM_LEDS; i++) {
            if(!animate) { break;}
            c=Wheel(((i * 256 / NUM_LEDS) + j) & 255);
            setPixel(i, *c, *(c+1), *(c+2));
            animationTimeout = millis()-loopStart; CheckInput();
            if(millis()-loopStart1>autoChangingDelay*2) {runThisSub = false; break;}
          }
          if(!animate) { break;}
           if(millis()-loopStart1>autoChangingDelay*2) {runThisSub = false; break;}
          showStrip();
          animationTimeout = millis()-loopStart1; CheckInput();
          delay(fadeSpeedDelay);
        }}
      break;
    

    case 5: case 6: //two colors
      String color11 = colorArray[array1Spot];
      String color22 = colorArray[array2Spot];
      SetAlternateColors(color11, color22);
      Rest(autoChangingDelay);
    break;
    }
  }
}

void SetAlternateColors(String color1, String color2)
{
  byte colorMode = random(1,7);
  if(colorMode >6)
    colorMode = 1;
  unsigned long color1Code = GetHexCode(color1);
  unsigned long color2Code = GetHexCode(color2);
  
    currentColorName = "Alternate";
     switch(colorMode)
     {
      case 1: 
      fill_solid(leds,NUM_LEDS,color1Code);
      FillSet(lightsClemson,color2,sizeof(lightsClemson));
      FillSet(lightsTigers,color2,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color2,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;

      case 2: 
      fill_solid(leds,NUM_LEDS,color2Code);
      FillSet(lightsClemson,color1,sizeof(lightsClemson));
      FillSet(lightsTigers,color1,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color1,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;
      
      case 3: 
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color1,sizeof(lightsClemson));
      FillSet(lightsTigers,color1,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color2,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;

      case 4: //Fill all
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color2,sizeof(lightsClemson));
      FillSet(lightsTigers,color2,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color1,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;

      case 5: //Alternate clemson/tigers and all acrylic colors
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color1,sizeof(lightsClemson));
      FillSet(lightsTigers,color2,sizeof(lightsTigers));
      FillSet(lightsAcrylic1,color1,sizeof(lightsAcrylic1));
      FillSet(lightsAcrylic2,color2,sizeof(lightsAcrylic2));
      FillSet(lightsAcrylic3,color1,sizeof(lightsAcrylic3));
      FillSet(lightsAcrylic4,color2,sizeof(lightsAcrylic4));
      FastLED.show();
      break;

      case 6: //Alternate clemson/tigers and all acrylic colors
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color2,sizeof(lightsClemson));
      FillSet(lightsTigers,color1,sizeof(lightsTigers));
      FillSet(lightsAcrylic1,color2,sizeof(lightsAcrylic1));
      FillSet(lightsAcrylic2,color1,sizeof(lightsAcrylic2));
      FillSet(lightsAcrylic3,color2,sizeof(lightsAcrylic3));
      FillSet(lightsAcrylic4,color1,sizeof(lightsAcrylic4));
      FastLED.show();
      break;

    }
}

  


void AlternateColors(String color1, String color2)
{
  Serial.print("PrevColorName = ");
  Serial.println(prevColorName);
  if(currentColorName == prevColorName)
    colorMode++;
  else
    colorMode = 1;
  if(colorMode >6)
    colorMode = 1;
  prevColorName = currentColorName;
  Serial.print("currentColorNAame: ");
  Serial.println(currentColorName);
  Serial.print("colorMode = ");
  Serial.println(colorMode);
  unsigned long color1Code = GetHexCode(color1);
  unsigned long color2Code = GetHexCode(color2);
  
  loopStart = millis();
  while(animate)
  {
    currentColorName = "Alternate";
     switch(colorMode)
     {
      case 1: 
      fill_solid(leds,NUM_LEDS,color1Code);
      FillSet(lightsClemson,color2,sizeof(lightsClemson));
      FillSet(lightsTigers,color2,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color2,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;

      case 2: 
      fill_solid(leds,NUM_LEDS,color2Code);
      FillSet(lightsClemson,color1,sizeof(lightsClemson));
      FillSet(lightsTigers,color1,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color1,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;
      
      case 3: 
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color1,sizeof(lightsClemson));
      FillSet(lightsTigers,color1,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color2,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;

      case 4: //Fill all
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color2,sizeof(lightsClemson));
      FillSet(lightsTigers,color2,sizeof(lightsTigers));
      FillSet(lightsAllAcrylic,color1,sizeof(lightsAllAcrylic));
      FastLED.show();
      break;

      case 5: //Alternate clemson/tigers and all acrylic colors
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color1,sizeof(lightsClemson));
      FillSet(lightsTigers,color2,sizeof(lightsTigers));
      FillSet(lightsAcrylic1,color1,sizeof(lightsAcrylic1));
      FillSet(lightsAcrylic2,color2,sizeof(lightsAcrylic2));
      FillSet(lightsAcrylic3,color1,sizeof(lightsAcrylic3));
      FillSet(lightsAcrylic4,color2,sizeof(lightsAcrylic4));
      FastLED.show();
      break;

      case 6: //Alternate clemson/tigers and all acrylic colors
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black
      FillSet(lightsClemson,color2,sizeof(lightsClemson));
      FillSet(lightsTigers,color1,sizeof(lightsTigers));
      FillSet(lightsAcrylic1,color2,sizeof(lightsAcrylic1));
      FillSet(lightsAcrylic2,color1,sizeof(lightsAcrylic2));
      FillSet(lightsAcrylic3,color2,sizeof(lightsAcrylic3));
      FillSet(lightsAcrylic4,color1,sizeof(lightsAcrylic4));
      FastLED.show();
      break;

    }
  
    animationTimeout = millis()-loopStart;
    CheckInput();
  }
}

void FillSet(byte* thisSetArray, String colorName, int thisArrayLength)
{
  unsigned long colorCode;
  for (int i = 0; i< sizeof(colorArray); i++)
      {
        if(colorArray[i] == colorName)
        {
          colorCode = colorHexArray[i]; //get the Hex code for the color
        }
      }
  for(int i = 0; i<thisArrayLength; i++)
    leds[thisSetArray[i]] = colorCode;
}

unsigned long GetHexCode(String colorName)
{
  unsigned long colorCode;
  for (int i = 0; i< sizeof(colorArray); i++)
      {
        if(colorArray[i] == colorName)
        {
          colorCode = colorHexArray[i]; //get the Hex code for the color
        }
      }
      return colorCode;
}

void FillColor()
{
  Serial.print("PrevColorName = ");
  Serial.println(prevColorName);
  if(currentColorName == prevColorName)
    colorMode++;
  else
    colorMode = 1;
  if(colorMode >maxNumColorModes)
    colorMode = 1;
  prevColorName = currentColorName;
  Serial.print("Searching for: ");
  Serial.println(currentColorName);
  Serial.print("colorMode = ");
  Serial.println(colorMode);
  
  for (int i = 0; i< sizeof(colorArray); i++)
      {
        if(colorArray[i] == currentColorName)
        {
          thisColorCode = colorHexArray[i]; //get the Hex code for the color
          Serial.print("Got color: ");
          Serial.println(thisColorCode,HEX);
        }
      }
  
  unsigned long loopStart = millis();
  while(animate)
  {
     switch(colorMode)
     {
      case 1: //Fill all
      fill_solid(leds,NUM_LEDS,thisColorCode);
      FastLED.show();
      //Serial.println("    Ran Case 1");
      break;
      
      case 2: //Clemson+tigers+acrylics
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black  
      for(int i = 0; i<sizeof(lightsClemson); i++)
        leds[lightsClemson[i]] = thisColorCode;
      for(int i = 0; i<sizeof(lightsTigers); i++)
        leds[lightsTigers[i]] = thisColorCode;
      for(int i = 0; i<sizeof(lightsAllAcrylic); i++)
        leds[lightsAllAcrylic[i]] = thisColorCode;
      FastLED.show();
      //Serial.println("    Ran Case 2");
      break;
      
//      case 4: //Clemson+tigers
//      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black 
//      for(int i = 0; i<sizeof(lightsClemson); i++)
//        leds[lightsClemson[i]] = thisColorCode;
//      for(int i = 0; i<sizeof(lightsTigers); i++)
//        leds[lightsTigers[i]] = thisColorCode;
//      FastLED.show();
//      //Serial.println("    Ran Case 3");
//      break;

      case 4: //Sound reactive
      SoundReactive(thisColorCode);
      break;

      case 5: //acrylic only
      fill_solid(leds,NUM_LEDS,CRGB::Black); //set them all to black 
      for(int i = 0; i<sizeof(lightsAllAcrylic); i++)
        leds[lightsAllAcrylic[i]] = thisColorCode;
      FastLED.show();
      //Serial.println("    Ran Case 4");
      break;

      case 3: 
      FadeInOutHTML(thisColorCode,fadeSpeedDelay);
      break;

    }
  
    animationTimeout = millis()-loopStart;
    CheckInput();
  }
}

void TurnOff()
{
  colorMode--;
  loopStart = millis();
  while(animate)
  {
    setAll(0,0,0);
    animationTimeout = millis()-loopStart;
    CheckInput();
  }
}

void OrangePawWhiteAcrylic()
{
  loopStart = millis();
  while(animate)
  {
    for(int i=0; i<197; i++)
    {
      leds[i] = CRGB::OrangeRed;
    }
    for(int i = 197; i<209; i++)
    {
      leds[i] = CRGB::White;
    }
    
    FastLED.show();
    animationTimeout = millis()-loopStart;
    CheckInput();
  }
}

