/*
 * Decompiled with CFR 0.152.
 */
package peasy.org.apache.commons.math.geometry;

import java.io.Serializable;
import peasy.org.apache.commons.math.geometry.CardanEulerSingularityException;
import peasy.org.apache.commons.math.geometry.NotARotationMatrixException;
import peasy.org.apache.commons.math.geometry.RotationOrder;
import peasy.org.apache.commons.math.geometry.Vector3D;

public class Rotation
implements Serializable {
    private final double q0;
    private final double q1;
    private final double q2;
    private final double q3;
    private static final long serialVersionUID = 8225864499430109352L;

    public Rotation() {
        this.q0 = 1.0;
        this.q1 = 0.0;
        this.q2 = 0.0;
        this.q3 = 0.0;
    }

    public Rotation(double d, double d2, double d3, double d4, boolean bl) {
        if (bl) {
            double d5 = 1.0 / Math.sqrt(d * d + d2 * d2 + d3 * d3 + d4 * d4);
            d *= d5;
            d2 *= d5;
            d3 *= d5;
            d4 *= d5;
        }
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
    }

    public Rotation(Vector3D vector3D, double d) {
        double d2 = vector3D.getNorm();
        if (d2 == 0.0) {
            throw new ArithmeticException("zero norm for rotation axis");
        }
        double d3 = -0.5 * d;
        double d4 = Math.sin(d3) / d2;
        this.q0 = Math.cos(d3);
        this.q1 = d4 * vector3D.getX();
        this.q2 = d4 * vector3D.getY();
        this.q3 = d4 * vector3D.getZ();
    }

    public Rotation(double[][] dArray, double d) throws NotARotationMatrixException {
        if (dArray.length != 3 || dArray[0].length != 3 || dArray[1].length != 3 || dArray[2].length != 3) {
            throw new NotARotationMatrixException("a {0}x{1} matrix cannot be a rotation matrix", new Object[]{Integer.toString(dArray.length), Integer.toString(dArray[0].length)});
        }
        double[][] dArray2 = this.orthogonalizeMatrix(dArray, d);
        double d2 = dArray2[0][0] * (dArray2[1][1] * dArray2[2][2] - dArray2[2][1] * dArray2[1][2]) - dArray2[1][0] * (dArray2[0][1] * dArray2[2][2] - dArray2[2][1] * dArray2[0][2]) + dArray2[2][0] * (dArray2[0][1] * dArray2[1][2] - dArray2[1][1] * dArray2[0][2]);
        if (d2 < 0.0) {
            throw new NotARotationMatrixException("the closest orthogonal matrix has a negative determinant {0}", new Object[]{Double.toString(d2)});
        }
        double d3 = dArray2[0][0] + dArray2[1][1] + dArray2[2][2];
        if (d3 > -0.19) {
            this.q0 = 0.5 * Math.sqrt(d3 + 1.0);
            double d4 = 0.25 / this.q0;
            this.q1 = d4 * (dArray2[1][2] - dArray2[2][1]);
            this.q2 = d4 * (dArray2[2][0] - dArray2[0][2]);
            this.q3 = d4 * (dArray2[0][1] - dArray2[1][0]);
        } else {
            d3 = dArray2[0][0] - dArray2[1][1] - dArray2[2][2];
            if (d3 > -0.19) {
                this.q1 = 0.5 * Math.sqrt(d3 + 1.0);
                double d5 = 0.25 / this.q1;
                this.q0 = d5 * (dArray2[1][2] - dArray2[2][1]);
                this.q2 = d5 * (dArray2[0][1] + dArray2[1][0]);
                this.q3 = d5 * (dArray2[0][2] + dArray2[2][0]);
            } else {
                d3 = dArray2[1][1] - dArray2[0][0] - dArray2[2][2];
                if (d3 > -0.19) {
                    this.q2 = 0.5 * Math.sqrt(d3 + 1.0);
                    double d6 = 0.25 / this.q2;
                    this.q0 = d6 * (dArray2[2][0] - dArray2[0][2]);
                    this.q1 = d6 * (dArray2[0][1] + dArray2[1][0]);
                    this.q3 = d6 * (dArray2[2][1] + dArray2[1][2]);
                } else {
                    d3 = dArray2[2][2] - dArray2[0][0] - dArray2[1][1];
                    this.q3 = 0.5 * Math.sqrt(d3 + 1.0);
                    double d7 = 0.25 / this.q3;
                    this.q0 = d7 * (dArray2[0][1] - dArray2[1][0]);
                    this.q1 = d7 * (dArray2[0][2] + dArray2[2][0]);
                    this.q2 = d7 * (dArray2[2][1] + dArray2[1][2]);
                }
            }
        }
    }

    public Rotation(Vector3D vector3D, Vector3D vector3D2, Vector3D vector3D3, Vector3D vector3D4) {
        double d = Vector3D.dotProduct(vector3D, vector3D);
        double d2 = Vector3D.dotProduct(vector3D2, vector3D2);
        double d3 = Vector3D.dotProduct(vector3D3, vector3D3);
        double d4 = Vector3D.dotProduct(vector3D4, vector3D4);
        if (d == 0.0 || d2 == 0.0 || d3 == 0.0 || d4 == 0.0) {
            throw new IllegalArgumentException("zero norm for rotation defining vector");
        }
        double d5 = vector3D.getX();
        double d6 = vector3D.getY();
        double d7 = vector3D.getZ();
        double d8 = vector3D2.getX();
        double d9 = vector3D2.getY();
        double d10 = vector3D2.getZ();
        double d11 = Math.sqrt(d / d3);
        double d12 = d11 * vector3D3.getX();
        double d13 = d11 * vector3D3.getY();
        double d14 = d11 * vector3D3.getZ();
        vector3D3 = new Vector3D(d12, d13, d14);
        double d15 = Vector3D.dotProduct(vector3D, vector3D2);
        double d16 = Vector3D.dotProduct(vector3D3, vector3D4);
        double d17 = d15 / d;
        double d18 = d16 / d;
        double d19 = Math.sqrt((d2 - d15 * d17) / (d4 - d16 * d18));
        double d20 = d17 - d19 * d18;
        double d21 = d20 * d12 + d19 * vector3D4.getX();
        double d22 = d20 * d13 + d19 * vector3D4.getY();
        double d23 = d20 * d14 + d19 * vector3D4.getZ();
        vector3D4 = new Vector3D(d21, d22, d23);
        Vector3D vector3D5 = vector3D;
        Vector3D vector3D6 = vector3D3;
        double d24 = d12 - vector3D.getX();
        double d25 = d13 - vector3D.getY();
        double d26 = d14 - vector3D.getZ();
        double d27 = d21 - vector3D2.getX();
        double d28 = d22 - vector3D2.getY();
        double d29 = d23 - vector3D2.getZ();
        Vector3D vector3D7 = new Vector3D(d25 * d29 - d26 * d28, d26 * d27 - d24 * d29, d24 * d28 - d25 * d27);
        double d30 = vector3D7.getX() * (d6 * d10 - d7 * d9) + vector3D7.getY() * (d7 * d8 - d5 * d10) + vector3D7.getZ() * (d5 * d9 - d6 * d8);
        if (d30 == 0.0) {
            double d31;
            double d32;
            Vector3D vector3D8 = Vector3D.crossProduct(vector3D, vector3D2);
            Vector3D vector3D9 = Vector3D.crossProduct(vector3D3, vector3D4);
            double d33 = vector3D8.getX();
            double d34 = vector3D8.getY();
            double d35 = vector3D8.getZ();
            double d36 = vector3D9.getX();
            double d37 = vector3D9.getY();
            double d38 = vector3D9.getZ();
            double d39 = d38 - d35;
            vector3D7 = new Vector3D(d25 * d39 - d26 * (d32 = d37 - d34), d26 * (d31 = d36 - d33) - d24 * d39, d24 * d32 - d25 * d31);
            d30 = vector3D7.getX() * (d6 * d35 - d7 * d34) + vector3D7.getY() * (d7 * d33 - d5 * d35) + vector3D7.getZ() * (d5 * d34 - d6 * d33);
            if (d30 == 0.0) {
                vector3D7 = new Vector3D(d28 * d39 - d29 * d32, d29 * d31 - d27 * d39, d27 * d32 - d28 * d31);
                d30 = vector3D7.getX() * (d9 * d35 - d10 * d34) + vector3D7.getY() * (d10 * d33 - d8 * d35) + vector3D7.getZ() * (d8 * d34 - d9 * d33);
                if (d30 == 0.0) {
                    this.q0 = 1.0;
                    this.q1 = 0.0;
                    this.q2 = 0.0;
                    this.q3 = 0.0;
                    return;
                }
                vector3D5 = vector3D2;
                vector3D6 = vector3D4;
            }
        }
        d30 = Math.sqrt(d30);
        double d40 = 1.0 / (d30 + d30);
        this.q1 = d40 * vector3D7.getX();
        this.q2 = d40 * vector3D7.getY();
        this.q3 = d40 * vector3D7.getZ();
        vector3D7 = new Vector3D(vector3D5.getY() * this.q3 - vector3D5.getZ() * this.q2, vector3D5.getZ() * this.q1 - vector3D5.getX() * this.q3, vector3D5.getX() * this.q2 - vector3D5.getY() * this.q1);
        d30 = Vector3D.dotProduct(vector3D7, vector3D7);
        this.q0 = Vector3D.dotProduct(vector3D6, vector3D7) / (d30 + d30);
    }

    public Rotation(Vector3D vector3D, Vector3D vector3D2) {
        double d = vector3D.getNorm() * vector3D2.getNorm();
        if (d == 0.0) {
            throw new IllegalArgumentException("zero norm for rotation defining vector");
        }
        double d2 = Vector3D.dotProduct(vector3D, vector3D2);
        if (d2 < -0.999999999999998 * d) {
            Vector3D vector3D3 = vector3D.orthogonal();
            this.q0 = 0.0;
            this.q1 = -vector3D3.getX();
            this.q2 = -vector3D3.getY();
            this.q3 = -vector3D3.getZ();
        } else {
            this.q0 = Math.sqrt(0.5 * (1.0 + d2 / d));
            double d3 = 1.0 / (2.0 * this.q0 * d);
            this.q1 = d3 * (vector3D2.getY() * vector3D.getZ() - vector3D2.getZ() * vector3D.getY());
            this.q2 = d3 * (vector3D2.getZ() * vector3D.getX() - vector3D2.getX() * vector3D.getZ());
            this.q3 = d3 * (vector3D2.getX() * vector3D.getY() - vector3D2.getY() * vector3D.getX());
        }
    }

    public Rotation(RotationOrder rotationOrder, double d, double d2, double d3) {
        Rotation rotation = new Rotation(rotationOrder.getA1(), d);
        Rotation rotation2 = new Rotation(rotationOrder.getA2(), d2);
        Rotation rotation3 = new Rotation(rotationOrder.getA3(), d3);
        Rotation rotation4 = rotation.applyTo(rotation2.applyTo(rotation3));
        this.q0 = rotation4.q0;
        this.q1 = rotation4.q1;
        this.q2 = rotation4.q2;
        this.q3 = rotation4.q3;
    }

    public Rotation revert() {
        return new Rotation(-this.q0, this.q1, this.q2, this.q3, false);
    }

    public double getQ0() {
        return this.q0;
    }

    public double getQ1() {
        return this.q1;
    }

    public double getQ2() {
        return this.q2;
    }

    public double getQ3() {
        return this.q3;
    }

    public Vector3D getAxis() {
        double d = this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (d == 0.0) {
            return new Vector3D(1.0, 0.0, 0.0);
        }
        if (this.q0 < 0.0) {
            double d2 = 1.0 / Math.sqrt(d);
            return new Vector3D(this.q1 * d2, this.q2 * d2, this.q3 * d2);
        }
        double d3 = -1.0 / Math.sqrt(d);
        return new Vector3D(this.q1 * d3, this.q2 * d3, this.q3 * d3);
    }

    public double getAngle() {
        if (this.q0 < -0.1 || this.q0 > 0.1) {
            return 2.0 * Math.asin(Math.sqrt(this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3));
        }
        if (this.q0 < 0.0) {
            return 2.0 * Math.acos(-this.q0);
        }
        return 2.0 * Math.acos(this.q0);
    }

    public double[] getAngles(RotationOrder rotationOrder) throws CardanEulerSingularityException {
        if (rotationOrder == RotationOrder.XYZ) {
            Vector3D vector3D = this.applyTo(Vector3D.plusK);
            Vector3D vector3D2 = this.applyInverseTo(Vector3D.plusI);
            if (vector3D2.getZ() < -0.9999999999 || vector3D2.getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{Math.atan2(-vector3D.getY(), vector3D.getZ()), Math.asin(vector3D2.getZ()), Math.atan2(-vector3D2.getY(), vector3D2.getX())};
        }
        if (rotationOrder == RotationOrder.XZY) {
            Vector3D vector3D = this.applyTo(Vector3D.plusJ);
            Vector3D vector3D3 = this.applyInverseTo(Vector3D.plusI);
            if (vector3D3.getY() < -0.9999999999 || vector3D3.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{Math.atan2(vector3D.getZ(), vector3D.getY()), -Math.asin(vector3D3.getY()), Math.atan2(vector3D3.getZ(), vector3D3.getX())};
        }
        if (rotationOrder == RotationOrder.YXZ) {
            Vector3D vector3D = this.applyTo(Vector3D.plusK);
            Vector3D vector3D4 = this.applyInverseTo(Vector3D.plusJ);
            if (vector3D4.getZ() < -0.9999999999 || vector3D4.getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{Math.atan2(vector3D.getX(), vector3D.getZ()), -Math.asin(vector3D4.getZ()), Math.atan2(vector3D4.getX(), vector3D4.getY())};
        }
        if (rotationOrder == RotationOrder.YZX) {
            Vector3D vector3D = this.applyTo(Vector3D.plusI);
            Vector3D vector3D5 = this.applyInverseTo(Vector3D.plusJ);
            if (vector3D5.getX() < -0.9999999999 || vector3D5.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{Math.atan2(-vector3D.getZ(), vector3D.getX()), Math.asin(vector3D5.getX()), Math.atan2(-vector3D5.getZ(), vector3D5.getY())};
        }
        if (rotationOrder == RotationOrder.ZXY) {
            Vector3D vector3D = this.applyTo(Vector3D.plusJ);
            Vector3D vector3D6 = this.applyInverseTo(Vector3D.plusK);
            if (vector3D6.getY() < -0.9999999999 || vector3D6.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{Math.atan2(-vector3D.getX(), vector3D.getY()), Math.asin(vector3D6.getY()), Math.atan2(-vector3D6.getX(), vector3D6.getZ())};
        }
        if (rotationOrder == RotationOrder.ZYX) {
            Vector3D vector3D = this.applyTo(Vector3D.plusI);
            Vector3D vector3D7 = this.applyInverseTo(Vector3D.plusK);
            if (vector3D7.getX() < -0.9999999999 || vector3D7.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(true);
            }
            return new double[]{Math.atan2(vector3D.getY(), vector3D.getX()), -Math.asin(vector3D7.getX()), Math.atan2(vector3D7.getY(), vector3D7.getZ())};
        }
        if (rotationOrder == RotationOrder.XYX) {
            Vector3D vector3D = this.applyTo(Vector3D.plusI);
            Vector3D vector3D8 = this.applyInverseTo(Vector3D.plusI);
            if (vector3D8.getX() < -0.9999999999 || vector3D8.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{Math.atan2(vector3D.getY(), -vector3D.getZ()), Math.acos(vector3D8.getX()), Math.atan2(vector3D8.getY(), vector3D8.getZ())};
        }
        if (rotationOrder == RotationOrder.XZX) {
            Vector3D vector3D = this.applyTo(Vector3D.plusI);
            Vector3D vector3D9 = this.applyInverseTo(Vector3D.plusI);
            if (vector3D9.getX() < -0.9999999999 || vector3D9.getX() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{Math.atan2(vector3D.getZ(), vector3D.getY()), Math.acos(vector3D9.getX()), Math.atan2(vector3D9.getZ(), -vector3D9.getY())};
        }
        if (rotationOrder == RotationOrder.YXY) {
            Vector3D vector3D = this.applyTo(Vector3D.plusJ);
            Vector3D vector3D10 = this.applyInverseTo(Vector3D.plusJ);
            if (vector3D10.getY() < -0.9999999999 || vector3D10.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{Math.atan2(vector3D.getX(), vector3D.getZ()), Math.acos(vector3D10.getY()), Math.atan2(vector3D10.getX(), -vector3D10.getZ())};
        }
        if (rotationOrder == RotationOrder.YZY) {
            Vector3D vector3D = this.applyTo(Vector3D.plusJ);
            Vector3D vector3D11 = this.applyInverseTo(Vector3D.plusJ);
            if (vector3D11.getY() < -0.9999999999 || vector3D11.getY() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{Math.atan2(vector3D.getZ(), -vector3D.getX()), Math.acos(vector3D11.getY()), Math.atan2(vector3D11.getZ(), vector3D11.getX())};
        }
        if (rotationOrder == RotationOrder.ZXZ) {
            Vector3D vector3D = this.applyTo(Vector3D.plusK);
            Vector3D vector3D12 = this.applyInverseTo(Vector3D.plusK);
            if (vector3D12.getZ() < -0.9999999999 || vector3D12.getZ() > 0.9999999999) {
                throw new CardanEulerSingularityException(false);
            }
            return new double[]{Math.atan2(vector3D.getX(), -vector3D.getY()), Math.acos(vector3D12.getZ()), Math.atan2(vector3D12.getX(), vector3D12.getY())};
        }
        Vector3D vector3D = this.applyTo(Vector3D.plusK);
        Vector3D vector3D13 = this.applyInverseTo(Vector3D.plusK);
        if (vector3D13.getZ() < -0.9999999999 || vector3D13.getZ() > 0.9999999999) {
            throw new CardanEulerSingularityException(false);
        }
        return new double[]{Math.atan2(vector3D.getY(), vector3D.getX()), Math.acos(vector3D13.getZ()), Math.atan2(vector3D13.getY(), -vector3D13.getX())};
    }

    public double[][] getMatrix() {
        double d = this.q0 * this.q0;
        double d2 = this.q0 * this.q1;
        double d3 = this.q0 * this.q2;
        double d4 = this.q0 * this.q3;
        double d5 = this.q1 * this.q1;
        double d6 = this.q1 * this.q2;
        double d7 = this.q1 * this.q3;
        double d8 = this.q2 * this.q2;
        double d9 = this.q2 * this.q3;
        double d10 = this.q3 * this.q3;
        double[][] dArrayArray = new double[][]{new double[3], new double[3], new double[3]};
        dArrayArray[0][0] = 2.0 * (d + d5) - 1.0;
        dArrayArray[1][0] = 2.0 * (d6 - d4);
        dArrayArray[2][0] = 2.0 * (d7 + d3);
        dArrayArray[0][1] = 2.0 * (d6 + d4);
        dArrayArray[1][1] = 2.0 * (d + d8) - 1.0;
        dArrayArray[2][1] = 2.0 * (d9 - d2);
        dArrayArray[0][2] = 2.0 * (d7 - d3);
        dArrayArray[1][2] = 2.0 * (d9 + d2);
        dArrayArray[2][2] = 2.0 * (d + d10) - 1.0;
        return dArrayArray;
    }

    public Vector3D applyTo(Vector3D vector3D) {
        double d = vector3D.getX();
        double d2 = vector3D.getY();
        double d3 = vector3D.getZ();
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        return new Vector3D(2.0 * (this.q0 * (d * this.q0 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d, 2.0 * (this.q0 * (d2 * this.q0 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2, 2.0 * (this.q0 * (d3 * this.q0 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3);
    }

    public Vector3D applyInverseTo(Vector3D vector3D) {
        double d = vector3D.getX();
        double d2 = vector3D.getY();
        double d3 = vector3D.getZ();
        double d4 = this.q1 * d + this.q2 * d2 + this.q3 * d3;
        double d5 = -this.q0;
        return new Vector3D(2.0 * (d5 * (d * d5 - (this.q2 * d3 - this.q3 * d2)) + d4 * this.q1) - d, 2.0 * (d5 * (d2 * d5 - (this.q3 * d - this.q1 * d3)) + d4 * this.q2) - d2, 2.0 * (d5 * (d3 * d5 - (this.q1 * d2 - this.q2 * d)) + d4 * this.q3) - d3);
    }

    public Rotation applyTo(Rotation rotation) {
        return new Rotation(rotation.q0 * this.q0 - (rotation.q1 * this.q1 + rotation.q2 * this.q2 + rotation.q3 * this.q3), rotation.q1 * this.q0 + rotation.q0 * this.q1 + (rotation.q2 * this.q3 - rotation.q3 * this.q2), rotation.q2 * this.q0 + rotation.q0 * this.q2 + (rotation.q3 * this.q1 - rotation.q1 * this.q3), rotation.q3 * this.q0 + rotation.q0 * this.q3 + (rotation.q1 * this.q2 - rotation.q2 * this.q1), false);
    }

    public Rotation applyInverseTo(Rotation rotation) {
        return new Rotation(-rotation.q0 * this.q0 - (rotation.q1 * this.q1 + rotation.q2 * this.q2 + rotation.q3 * this.q3), -rotation.q1 * this.q0 + rotation.q0 * this.q1 + (rotation.q2 * this.q3 - rotation.q3 * this.q2), -rotation.q2 * this.q0 + rotation.q0 * this.q2 + (rotation.q3 * this.q1 - rotation.q1 * this.q3), -rotation.q3 * this.q0 + rotation.q0 * this.q3 + (rotation.q1 * this.q2 - rotation.q2 * this.q1), false);
    }

    private double[][] orthogonalizeMatrix(double[][] dArray, double d) throws NotARotationMatrixException {
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        double[] dArray4 = dArray[2];
        double d2 = dArray2[0];
        double d3 = dArray2[1];
        double d4 = dArray2[2];
        double d5 = dArray3[0];
        double d6 = dArray3[1];
        double d7 = dArray3[2];
        double d8 = dArray4[0];
        double d9 = dArray4[1];
        double d10 = dArray4[2];
        double d11 = 0.0;
        double[][] dArray5 = new double[3][3];
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        double[] dArray8 = dArray5[2];
        int n = 0;
        while (++n < 11) {
            double d12 = dArray2[0] * d2 + dArray3[0] * d5 + dArray4[0] * d8;
            double d13 = dArray2[1] * d2 + dArray3[1] * d5 + dArray4[1] * d8;
            double d14 = dArray2[2] * d2 + dArray3[2] * d5 + dArray4[2] * d8;
            double d15 = dArray2[0] * d3 + dArray3[0] * d6 + dArray4[0] * d9;
            double d16 = dArray2[1] * d3 + dArray3[1] * d6 + dArray4[1] * d9;
            double d17 = dArray2[2] * d3 + dArray3[2] * d6 + dArray4[2] * d9;
            double d18 = dArray2[0] * d4 + dArray3[0] * d7 + dArray4[0] * d10;
            double d19 = dArray2[1] * d4 + dArray3[1] * d7 + dArray4[1] * d10;
            double d20 = dArray2[2] * d4 + dArray3[2] * d7 + dArray4[2] * d10;
            dArray6[0] = d2 - 0.5 * (d2 * d12 + d3 * d13 + d4 * d14 - dArray2[0]);
            dArray6[1] = d3 - 0.5 * (d2 * d15 + d3 * d16 + d4 * d17 - dArray2[1]);
            dArray6[2] = d4 - 0.5 * (d2 * d18 + d3 * d19 + d4 * d20 - dArray2[2]);
            dArray7[0] = d5 - 0.5 * (d5 * d12 + d6 * d13 + d7 * d14 - dArray3[0]);
            dArray7[1] = d6 - 0.5 * (d5 * d15 + d6 * d16 + d7 * d17 - dArray3[1]);
            dArray7[2] = d7 - 0.5 * (d5 * d18 + d6 * d19 + d7 * d20 - dArray3[2]);
            dArray8[0] = d8 - 0.5 * (d8 * d12 + d9 * d13 + d10 * d14 - dArray4[0]);
            dArray8[1] = d9 - 0.5 * (d8 * d15 + d9 * d16 + d10 * d17 - dArray4[1]);
            dArray8[2] = d10 - 0.5 * (d8 * d18 + d9 * d19 + d10 * d20 - dArray4[2]);
            double d21 = dArray6[0] - dArray2[0];
            double d22 = dArray6[1] - dArray2[1];
            double d23 = dArray6[2] - dArray2[2];
            double d24 = dArray7[0] - dArray3[0];
            double d25 = dArray7[1] - dArray3[1];
            double d26 = dArray7[2] - dArray3[2];
            double d27 = dArray8[0] - dArray4[0];
            double d28 = dArray8[1] - dArray4[1];
            double d29 = dArray8[2] - dArray4[2];
            double d30 = d21 * d21 + d22 * d22 + d23 * d23 + d24 * d24 + d25 * d25 + d26 * d26 + d27 * d27 + d28 * d28 + d29 * d29;
            if (Math.abs(d30 - d11) <= d) {
                return dArray5;
            }
            d2 = dArray6[0];
            d3 = dArray6[1];
            d4 = dArray6[2];
            d5 = dArray7[0];
            d6 = dArray7[1];
            d7 = dArray7[2];
            d8 = dArray8[0];
            d9 = dArray8[1];
            d10 = dArray8[2];
            d11 = d30;
        }
        throw new NotARotationMatrixException("unable to orthogonalize matrix in {0} iterations", new Object[]{Integer.toString(n - 1)});
    }
}

