/*
 * Decompiled with CFR 0.152.
 */
package peasy.org.apache.commons.math.geometry;

import java.io.Serializable;

public class Vector3D
implements Serializable {
    public static final Vector3D plusI = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D minusI = new Vector3D(-1.0, 0.0, 0.0);
    public static final Vector3D plusJ = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D minusJ = new Vector3D(0.0, -1.0, 0.0);
    public static final Vector3D plusK = new Vector3D(0.0, 0.0, 1.0);
    public static final Vector3D minusK = new Vector3D(0.0, 0.0, -1.0);
    public static final Vector3D zero = new Vector3D(0.0, 0.0, 0.0);
    private final double x;
    private final double y;
    private final double z;
    private static final long serialVersionUID = -5721105387745193385L;

    public Vector3D() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3D(double d, double d2) {
        double d3 = Math.cos(d2);
        this.x = Math.cos(d) * d3;
        this.y = Math.sin(d) * d3;
        this.z = Math.sin(d2);
    }

    public Vector3D(double d, Vector3D vector3D) {
        this.x = d * vector3D.x;
        this.y = d * vector3D.y;
        this.z = d * vector3D.z;
    }

    public Vector3D(double d, Vector3D vector3D, double d2, Vector3D vector3D2) {
        this.x = d * vector3D.x + d2 * vector3D2.x;
        this.y = d * vector3D.y + d2 * vector3D2.y;
        this.z = d * vector3D.z + d2 * vector3D2.z;
    }

    public Vector3D(double d, Vector3D vector3D, double d2, Vector3D vector3D2, double d3, Vector3D vector3D3) {
        this.x = d * vector3D.x + d2 * vector3D2.x + d3 * vector3D3.x;
        this.y = d * vector3D.y + d2 * vector3D2.y + d3 * vector3D3.y;
        this.z = d * vector3D.z + d2 * vector3D2.z + d3 * vector3D3.z;
    }

    public Vector3D(double d, Vector3D vector3D, double d2, Vector3D vector3D2, double d3, Vector3D vector3D3, double d4, Vector3D vector3D4) {
        this.x = d * vector3D.x + d2 * vector3D2.x + d3 * vector3D3.x + d4 * vector3D4.x;
        this.y = d * vector3D.y + d2 * vector3D2.y + d3 * vector3D3.y + d4 * vector3D4.y;
        this.z = d * vector3D.z + d2 * vector3D2.z + d3 * vector3D3.z + d4 * vector3D4.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getNorm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double getAlpha() {
        return Math.atan2(this.y, this.x);
    }

    public double getDelta() {
        return Math.asin(this.z / this.getNorm());
    }

    public Vector3D add(Vector3D vector3D) {
        return new Vector3D(this.x + vector3D.x, this.y + vector3D.y, this.z + vector3D.z);
    }

    public Vector3D add(double d, Vector3D vector3D) {
        return new Vector3D(this.x + d * vector3D.x, this.y + d * vector3D.y, this.z + d * vector3D.z);
    }

    public Vector3D subtract(Vector3D vector3D) {
        return new Vector3D(this.x - vector3D.x, this.y - vector3D.y, this.z - vector3D.z);
    }

    public Vector3D subtract(double d, Vector3D vector3D) {
        return new Vector3D(this.x - d * vector3D.x, this.y - d * vector3D.y, this.z - d * vector3D.z);
    }

    public Vector3D normalize() {
        double d = this.getNorm();
        if (d == 0.0) {
            throw new ArithmeticException("cannot normalize a zero norm vector");
        }
        return this.scalarMultiply(1.0 / d);
    }

    public Vector3D orthogonal() {
        double d = 0.6 * this.getNorm();
        if (d == 0.0) {
            throw new ArithmeticException("null norm");
        }
        if (this.x >= -d && this.x <= d) {
            double d2 = 1.0 / Math.sqrt(this.y * this.y + this.z * this.z);
            return new Vector3D(0.0, d2 * this.z, -d2 * this.y);
        }
        if (this.y >= -d && this.y <= d) {
            double d3 = 1.0 / Math.sqrt(this.x * this.x + this.z * this.z);
            return new Vector3D(-d3 * this.z, 0.0, d3 * this.x);
        }
        double d4 = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        return new Vector3D(d4 * this.y, -d4 * this.x, 0.0);
    }

    public static double angle(Vector3D vector3D, Vector3D vector3D2) {
        double d;
        double d2 = vector3D.getNorm() * vector3D2.getNorm();
        if (d2 == 0.0) {
            throw new ArithmeticException("null norm");
        }
        double d3 = Vector3D.dotProduct(vector3D, vector3D2);
        if (d3 < -(d = d2 * 0.9999) || d3 > d) {
            Vector3D vector3D3 = Vector3D.crossProduct(vector3D, vector3D2);
            if (d3 >= 0.0) {
                return Math.asin(vector3D3.getNorm() / d2);
            }
            return Math.PI - Math.asin(vector3D3.getNorm() / d2);
        }
        return Math.acos(d3 / d2);
    }

    public Vector3D negate() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D scalarMultiply(double d) {
        return new Vector3D(d * this.x, d * this.y, d * this.z);
    }

    public static double dotProduct(Vector3D vector3D, Vector3D vector3D2) {
        return vector3D.x * vector3D2.x + vector3D.y * vector3D2.y + vector3D.z * vector3D2.z;
    }

    public static Vector3D crossProduct(Vector3D vector3D, Vector3D vector3D2) {
        return new Vector3D(vector3D.y * vector3D2.z - vector3D.z * vector3D2.y, vector3D.z * vector3D2.x - vector3D.x * vector3D2.z, vector3D.x * vector3D2.y - vector3D.y * vector3D2.x);
    }
}

