/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import sun.org.mozilla.javascript.internal.BaseFunction;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.IdScriptableObject;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.NativeCall;
import sun.org.mozilla.javascript.internal.NativeFunction;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.UniqueTag;

final class Arguments
extends IdScriptableObject {
    private static final String FTAG = "Arguments";
    private static final int Id_callee = 1;
    private static final int Id_length = 2;
    private static final int Id_caller = 3;
    private static final int Id_constructor = 4;
    private static final int MAX_INSTANCE_ID = 4;
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private Object constructor;
    private NativeCall activation;
    private BaseFunction objectCtor;
    private Object[] args;

    public Arguments(NativeCall nativeCall) {
        this.activation = nativeCall;
        Scriptable scriptable = nativeCall.getParentScope();
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.args = nativeCall.originalArgs;
        this.lengthObj = this.args.length;
        NativeFunction nativeFunction = nativeCall.function;
        this.calleeObj = nativeFunction;
        Scriptable scriptable2 = Arguments.getTopLevelScope(scriptable);
        this.objectCtor = (BaseFunction)Arguments.getProperty(scriptable2, "Object");
        this.constructor = this.objectCtor;
        int n = nativeFunction.getLanguageVersion();
        this.callerObj = n <= 130 && n != 0 ? null : NOT_FOUND;
    }

    @Override
    public String getClassName() {
        return FTAG;
    }

    private Object arg(int n) {
        if (n < 0 || this.args.length <= n) {
            return NOT_FOUND;
        }
        return this.args[n];
    }

    private void putIntoActivation(int n, Object object) {
        String string = this.activation.function.getParamOrVarName(n);
        this.activation.put(string, (Scriptable)this.activation, object);
    }

    private Object getFromActivation(int n) {
        String string = this.activation.function.getParamOrVarName(n);
        return this.activation.get(string, (Scriptable)this.activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceArg(int n, Object object) {
        if (this.sharedWithActivation(n)) {
            this.putIntoActivation(n, object);
        }
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.args == this.activation.originalArgs) {
                this.args = (Object[])this.args.clone();
            }
            this.args[n] = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArg(int n) {
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.args[n] != NOT_FOUND) {
                if (this.args == this.activation.originalArgs) {
                    this.args = (Object[])this.args.clone();
                }
                this.args[n] = NOT_FOUND;
            }
        }
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (this.arg(n) != NOT_FOUND) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Object object = this.arg(n);
        if (object == NOT_FOUND) {
            return super.get(n, scriptable);
        }
        if (this.sharedWithActivation(n)) {
            return this.getFromActivation(n);
        }
        return object;
    }

    private boolean sharedWithActivation(int n) {
        NativeFunction nativeFunction = this.activation.function;
        int n2 = nativeFunction.getParamCount();
        if (n < n2) {
            if (n < n2 - 1) {
                String string = nativeFunction.getParamOrVarName(n);
                for (int i = n + 1; i < n2; ++i) {
                    if (!string.equals(nativeFunction.getParamOrVarName(i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (this.arg(n) == NOT_FOUND) {
            super.put(n, scriptable, object);
        } else {
            this.replaceArg(n, object);
        }
    }

    @Override
    public void delete(int n) {
        if (0 <= n && n < this.args.length) {
            this.removeArg(n);
        }
        super.delete(n);
    }

    @Override
    protected int getMaxInstanceId() {
        return 4;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        int n3 = string.length();
        if (n3 == 6) {
            char c = string.charAt(5);
            if (c == 'e') {
                string2 = "callee";
                n2 = 1;
            } else if (c == 'h') {
                string2 = "length";
                n2 = 2;
            } else if (c == 'r') {
                string2 = "caller";
                n2 = 3;
            }
        } else if (n3 == 11) {
            string2 = "constructor";
            n2 = 4;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n = 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Arguments.instanceIdInfo(n, n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
            case 4: {
                return "constructor";
            }
        }
        return null;
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                NativeCall nativeCall;
                Object object = this.callerObj;
                if (object == UniqueTag.NULL_VALUE) {
                    object = null;
                } else if (object == null && (nativeCall = this.activation.parentActivationCall) != null) {
                    object = nativeCall.get("arguments", (Scriptable)nativeCall);
                }
                return object;
            }
            case 4: {
                return this.constructor;
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        switch (n) {
            case 1: {
                this.calleeObj = object;
                return;
            }
            case 2: {
                this.lengthObj = object;
                return;
            }
            case 3: {
                this.callerObj = object != null ? object : UniqueTag.NULL_VALUE;
                return;
            }
            case 4: {
                this.constructor = object;
                return;
            }
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    Object[] getIds(boolean bl) {
        Object[] objectArray = super.getIds(bl);
        if (this.args.length != 0) {
            int n;
            int n2;
            boolean[] blArray = new boolean[this.args.length];
            int n3 = this.args.length;
            for (n2 = 0; n2 != objectArray.length; ++n2) {
                Object object = objectArray[n2];
                if (!(object instanceof Integer) || 0 > (n = ((Integer)object).intValue()) || n >= this.args.length || blArray[n]) continue;
                blArray[n] = true;
                --n3;
            }
            if (!bl) {
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    if (blArray[n2] || !super.has(n2, (Scriptable)this)) continue;
                    blArray[n2] = true;
                    --n3;
                }
            }
            if (n3 != 0) {
                Object[] objectArray2 = new Object[n3 + objectArray.length];
                System.arraycopy(objectArray, 0, objectArray2, n3, objectArray.length);
                objectArray = objectArray2;
                int n4 = 0;
                for (n = 0; n != this.args.length; ++n) {
                    if (blArray != null && blArray[n]) continue;
                    objectArray[n4] = n;
                    ++n4;
                }
                if (n4 != n3) {
                    Kit.codeBug();
                }
            }
        }
        return objectArray;
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        int n;
        double d = ScriptRuntime.toNumber(object);
        if (d != (double)(n = (int)d)) {
            return super.getOwnPropertyDescriptor(context, object);
        }
        Object object2 = this.arg(n);
        if (object2 == NOT_FOUND) {
            return super.getOwnPropertyDescriptor(context, object);
        }
        if (this.sharedWithActivation(n)) {
            object2 = this.getFromActivation(n);
        }
        if (super.has(n, (Scriptable)this)) {
            ScriptableObject scriptableObject = super.getOwnPropertyDescriptor(context, object);
            scriptableObject.put("value", (Scriptable)scriptableObject, object2);
            return scriptableObject;
        }
        Scriptable scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable = this;
        }
        return Arguments.buildDataDescriptor(scriptable, object2, 0);
    }

    @Override
    public void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject) {
        super.defineOwnProperty(context, object, scriptableObject);
        double d = ScriptRuntime.toNumber(object);
        int n = (int)d;
        if (d != (double)n) {
            return;
        }
        Object object2 = this.arg(n);
        if (object2 == NOT_FOUND) {
            return;
        }
        if (this.isAccessorDescriptor(scriptableObject)) {
            this.removeArg(n);
            return;
        }
        Object object3 = Arguments.getProperty((Scriptable)scriptableObject, "value");
        if (object3 == NOT_FOUND) {
            return;
        }
        this.replaceArg(n, object3);
        if (Arguments.isFalse(Arguments.getProperty((Scriptable)scriptableObject, "writable"))) {
            this.removeArg(n);
        }
    }
}

