void displayStatus(int state) {
  unsigned long previousMillis = 0;
  unsigned long pm = millis();
  int ledState = LOW;
  systemStatus = state;
  int x=0;
  switch (state) {
    case 1: //Initializing State 'Blue'
      digitalWrite(ciLedRedPin, LOW);
      digitalWrite(ciLedGreenPin, LOW);
      digitalWrite(ciLedBluePin, HIGH);
      break;
    case 2: //Run State 'Green'
      digitalWrite(ciLedRedPin, LOW);
      digitalWrite(ciLedGreenPin, HIGH);
      digitalWrite(ciLedBluePin, LOW);
      break;
    case 3: //Fatal Error on Initialization 'Blinking Blue'
      Serial.println("error");
      digitalWrite(ciLedRedPin, LOW);
      digitalWrite(ciLedGreenPin, LOW);
      digitalWrite(ciLedBluePin, HIGH);
      while(x==0){
        unsigned long currentMillis = millis();
        if(currentMillis - previousMillis >= blinkRate) {
          // reset the previous timer variable to the current time for the next loop around 
          previousMillis = currentMillis;
          
          // set the ledState variable to the opposite of whatever value it currently is
          if (ledState == HIGH)
            ledState = LOW;
          else
            ledState = HIGH;
      
          // set the LED with the ledState of the variable:
          digitalWrite(ciLedBluePin, ledState);
        } // Put controller into endless loop until reset
      }
      break;
    case 4: //Run State Temporary Error - 'Yellow'
      Serial.println("Temp Error");
      digitalWrite(ciLedRedPin, HIGH);
      digitalWrite(ciLedGreenPin, HIGH);
      digitalWrite(ciLedBluePin, LOW);
      while(x==0){
        unsigned long currentMillis = millis();
        if(currentMillis - previousMillis >= blinkRate) {
          // reset the previous timer variable to the current time for the next loop around 
          previousMillis = currentMillis;
          
          // set the ledState variable to the opposite of whatever value it currently is
          if (ledState == HIGH)
            ledState = LOW;
          else
            ledState = HIGH;
      
          // set the LED with the ledState of the variable:
          digitalWrite(ciLedRedPin, ledState);
          digitalWrite(ciLedGreenPin, ledState);
        } 
        //Serial.println(clDBReconnectPause - (currentMillis - pm));
        if(currentMillis - pm >= clDBReconnectPause) {
          break;
        }
      }
      break;
    case 5: //Run State Fatal Error 'Blinking Red'
      Serial.println("error");
      digitalWrite(ciLedRedPin, HIGH);
      digitalWrite(ciLedGreenPin, LOW);
      digitalWrite(ciLedBluePin, LOW);
      while(x==0){
        unsigned long currentMillis = millis();
        if(currentMillis - previousMillis >= blinkRate) {
          // reset the previous timer variable to the current time for the next loop around 
          previousMillis = currentMillis;
          
          // set the ledState variable to the opposite of whatever value it currently is
          if (ledState == HIGH)
            ledState = LOW;
          else
            ledState = HIGH;
      
          // set the LED with the ledState of the variable:
          digitalWrite(ciLedRedPin, ledState);
        } // Put controller into endless loop until reset
      }
      break;
  }
}
