#ifndef USERCONFIG_H
#define USERCONFIG_H

// constant conversion factors
const float cfRainBucketsToInches = 0.014;                          // multiply bucket tips by this for inches 
const int TEMPTYPE = 1;        // Use Fahrenheit (0 for celsius)

const long blinkRate = 250;
const long pollPeriod = 10000;
const unsigned long dataRecordPeriod = 120000;
const unsigned long dataOverduePeriod = 360000;

// ethernet interface mac address, must be unique on the LAN
const byte baEthMACAddress[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
IPAddress oMySQLServerAddress;  
const char mySQL_server[] = "mysqlserver.internal.local";   // this is a place holder - change to your internal server name
IPAddress oMQTTServerAddress;
const char mqtt_server[] = "mqttserver.internal.local";     // this is a place holder - change to your internal server name
IPAddress oFallbackIP(192, 168, 1, 21);
const char user[] = "my-mysql-db-user-name";                // this is a place holder - change to your mysql account name
const char password[] = "my-mysql-db-user-password";        // this is a place holder - change to your mysql account password
const String dbIntervalDataTableName = "weather.interval_readings";
const String dbSystemDataTableName = "weather.system_readings";

const char* mqtt_pub_topic = "weatherStation";              // this is a place holder - change to your mqtt weather topic
const char* mqtt_user = "my-mqtt-user-name";                // this is a place holder - change to your mqtt account name
const char* mqtt_pass = "my-mqtt-user-password";            // this is a place holder - change to your mqtt account password
const char* mqtt_sub_date = "environment/edate";
const char* mqtt_sub_time = "environment/mtime";
const char* mqtt_pub_temperature = "weather/temperature";
const char* mqtt_pub_humidity = "weather/humidity";
const char* mqtt_pub_dewpoint = "weather/dewpoint";
const char* mqtt_pub_feelslike = "weather/feelslike";
const char* mqtt_pub_pressure = "weather/pressure";
const char* mqtt_pub_windspeed = "weather/windSpeed";
const char* mqtt_pub_winddirection = "weather/windDirection";
const char* mqtt_pub_windordinaldirection = "weather/windOrdinalDirection";
const char* mqtt_pub_raining = "weather/raining";
const char* mqtt_pub_rainfall = "weather/rainfall";
const char* mqtt_pub_lightning = "weather/lightning";
const char* mqtt_pub_lightningdisturber = "weather/lightningdisturber";
const char* mqtt_pub_gusts = "weather/gusts";
const char* mqtt_pub_lux = "weather/lux";
const char* mqtt_pub_uva = "weather/uva";
const char* mqtt_pub_uvb = "weather/uvb";
const char* mqtt_pub_uvindex = "weather/uvindex";

#endif
