int speedPot = 0;
int linkageServoLeftPin = 2;
int linkageServoRightPin = 3;
int receiverPin = 4;
int emitterPin = 5;
int red = 9;
int green = 10;
int blue = 11;

int speed = 1;
//int upperLimit = 2500;
//int lowerLimit = 500;
int boundary = 0;
int upperLimit = 2500 - boundary;
int lowerLimit = 500 + boundary;
int maximumRGBIntensity = 255;
int swingTime = upperLimit - lowerLimit;
boolean position = LOW;
boolean outOfPosition = LOW;

void setup(){
	Serial.begin(9600);
	Serial.println("System Running");
	pinMode(linkageServoLeftPin, OUTPUT);
	pinMode(linkageServoRightPin, OUTPUT);
	pinMode(emitterPin, OUTPUT);
	pinMode(receiverPin, INPUT);
	pinMode(red, OUTPUT);
	pinMode(green, OUTPUT);
	pinMode(blue, OUTPUT);
	digitalWrite(blue, HIGH);
}

void loop(){
	// If the hand sensor is activated invert the position bit.
	if (checkObstruction(emitterPin, receiverPin, 90, 100)){
		position = !position;
		outOfPosition = HIGH;
		digitalWrite(blue, LOW);
	}
	if (outOfPosition){
		updateSpeed();
		if (position){
			movePositive();
			outOfPosition = LOW;
		}
		if (!position){
			moveNegative();
			outOfPosition = LOW;
		}
	}else{
//		int delayTime = map(analogRead(speedPot), 0, 1023, 20, 50);
//		Serial.print("Delay Time:\t");
//		Serial.println(delayTime);
//		if (millis() % delayTime == 0){
		if (HIGH){
			if (position){
				for (int i=0; i < 10; i++){
					maximumSwing();
					delay(20);
				}
			}
			if (!position){
				minimumSwing();
				for (int i=0; i < 10; i++){
					minimumSwing();
					delay(20);
				}
			}
//			delay(18);
		}
	}
}

boolean checkObstruction(int functionEmitterPin, int functionReceiverPin, int functionAcceptableValue, int functionChecksToPerform){
	int functionCount = 0;
	for (int i = 0; i < functionChecksToPerform; i++){
		if (checkPulse(functionEmitterPin, functionReceiverPin)){
			functionCount++;
			if (functionCount > functionAcceptableValue-1){
				Serial.print("Count:\t");
				Serial.println(functionCount);
				return true;
			}
		}
	}
	Serial.print("Count:\t");
	Serial.println(functionCount);
	return false;
}

boolean checkPulse(int pulseGeneratorPin, int pulseReceiverPin){
	digitalWrite(pulseGeneratorPin, HIGH);
	delayMicroseconds(5);
	boolean functionSensorState = !digitalRead(pulseReceiverPin);
	digitalWrite(pulseGeneratorPin, LOW);
	delayMicroseconds(5);
	return functionSensorState;
}

void updateSpeed(){
	speed = map(analogRead(speedPot), 0, 1023, 150, 10);
}

void minimumSwing(){
	digitalWrite(linkageServoLeftPin, HIGH);
	delayMicroseconds(lowerLimit);
	digitalWrite(linkageServoLeftPin, LOW);
	digitalWrite(linkageServoRightPin, HIGH);
	delayMicroseconds(upperLimit);
	digitalWrite(linkageServoRightPin, LOW);
}

void maximumSwing(){
	digitalWrite(linkageServoLeftPin, HIGH);
	delayMicroseconds(upperLimit);
	digitalWrite(linkageServoLeftPin, LOW);
	digitalWrite(linkageServoRightPin, HIGH);
	delayMicroseconds(lowerLimit);
	digitalWrite(linkageServoRightPin, LOW);
}

void movePositive(){
	digitalWrite(linkageServoLeftPin, LOW);
	digitalWrite(linkageServoRightPin, LOW);
	delay(18);
	for (int i=0; i<swingTime; i=i+speed){
		digitalWrite(linkageServoLeftPin, HIGH);
		delayMicroseconds(lowerLimit + i);
		digitalWrite(linkageServoLeftPin, LOW);
		digitalWrite(linkageServoRightPin, HIGH);
		delayMicroseconds(upperLimit - i);
		digitalWrite(linkageServoRightPin, LOW);
		delay(18);
		int light1Intensity = map(i, 0, swingTime, 0, maximumRGBIntensity);
		int light2Intensity = map(i, 0, swingTime, maximumRGBIntensity, 0);
		analogWrite(green, light1Intensity);
		analogWrite(red, light2Intensity);
	}
	digitalWrite(green, HIGH);
	digitalWrite(red, LOW);
	for (int i=0; i < 10; i++){
		maximumSwing();
	}
}

void moveNegative(){
	digitalWrite(linkageServoLeftPin, LOW);
	digitalWrite(linkageServoRightPin, LOW);
	delay(18);
	for (int i=swingTime; i>0; i=i-speed){
		digitalWrite(linkageServoLeftPin, HIGH);
		delayMicroseconds(lowerLimit + i);
		digitalWrite(linkageServoLeftPin, LOW);
		digitalWrite(linkageServoRightPin, HIGH);
		delayMicroseconds(upperLimit - i);
		digitalWrite(linkageServoRightPin, LOW);
		delay(18);
		int light1Intensity = map(i, 0, swingTime, 0, maximumRGBIntensity);
		int light2Intensity = map(i, 0, swingTime, maximumRGBIntensity, 0);
		analogWrite(green, light1Intensity);
		analogWrite(red, light2Intensity);
	}
	digitalWrite(green, LOW);
	digitalWrite(red, HIGH);
	for (int i=0; i < 10; i++){
		minimumSwing();
	}
}