package com.ardu.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.sun.jna.Platform;

public class ActivePorts {

  private List<String> portsAsList;
  private String portsAsString;
  private String[] portsAsArray;



  public ActivePorts() {
    super();

    List<String> ports = new ArrayList<>();
    try {
      if (Platform.isLinux()) {
        ProcessBuilder pb = new ProcessBuilder("ls");
        pb.directory(new File("/dev"));
        Process p = pb.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String port = null;
        while ((port = input.readLine()) != null) {
          if (port.matches("^(ttyACM|ttyUSB).+$")) {
            ports.add("/dev/" + port.trim());
          }
        }
        p.waitFor();

        portsAsList = ports;
        portsAsString = ports.stream().map(Object::toString).collect(Collectors.joining(":"));
        portsAsArray = ports.stream().toArray(String[]::new);

      } else if (Platform.isWindows()) {
        Runtime rt = Runtime.getRuntime();
        Process pr = rt.exec("wmic path Win32_SerialPort Get DeviceID");
        BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        String port = null;

        while ((port = input.readLine()) != null) {
          if (port.startsWith("COM")) {
            ports.add(port.trim());
          }
        }
        pr.waitFor();

        portsAsList = ports;
        portsAsString = ports.stream().map(Object::toString).collect(Collectors.joining(";"));
        portsAsArray = ports.stream().toArray(String[]::new);
      }


    } catch (Exception e) {
      e.printStackTrace();
    }



  }

  public List<String> getPortsAsList() {
    return portsAsList;
  }

  public String getPortsAsString() {
    return portsAsString;
  }

  public String[] getPortsAsArray() {
    return portsAsArray;
  }

  public static void main(String args[]) {


    ActivePorts ap = new ActivePorts();
    System.out.println(ap.getPortsAsString());

  }

}
