package com.ardu.tools;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

/**
 * The Class JarLoader.
 */
public class JarLoader {

  /** The cargador JVM. */
  public static URLClassLoader cargadorJVM = (URLClassLoader) ClassLoader.getSystemClassLoader();

  // public static final String Package = Loader.class.getPackage().getName();


  /**
   * Load.
   *
   * @param libFolder the lib folder
   * @throws IOException Signals that an I/O exception has occurred.
   */
  public static void load(final String libFolder) throws IOException {
    final Class<URLClassLoader> claseJVM = URLClassLoader.class;
    final Class<?>[] params = new Class[] {URL.class};
    File files[] = null;

    try {
      final File objFile = new File(libFolder);
      final Method metodo = claseJVM.getDeclaredMethod("addURL", params);
      // esta linea es para volver accesible el m�todo
      metodo.setAccessible(true);

      files = objFile.listFiles();
      System.out.println("PATH: " + objFile.getAbsolutePath().toString());
      for (int i = 0; i < files.length; i++) {

        if (files[i].getName().endsWith(".jar")) {
          final URL objUrl = files[i].toURI().toURL();
          metodo.invoke(cargadorJVM, new Object[] {objUrl});
          // System.out.print("Cargando jar: "+objUrl.toString()+"\n");
        }

      }

    } catch (final Throwable th) {

      // th.printStackTrace();
      // System.out.print(files.length);
      throw new IOException("Error al cargar librerias");
    }
  }
}
