/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import processing.app.Preferences;
import processing.app.SerialException;
import processing.app.SerialNotFoundException;
import processing.app.debug.MessageConsumer;

public class Serial
implements SerialPortEventListener {
    SerialPort port;
    int rate;
    int parity;
    int databits;
    int stopbits;
    boolean monitor = false;
    InputStream input;
    OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    MessageConsumer consumer;

    public Serial(boolean monitor) throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
        this.monitor = monitor;
    }

    public Serial() throws SerialException {
        this(Preferences.get("serial.port"), Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(int irate) throws SerialException {
        this(Preferences.get("serial.port"), irate, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String iname, int irate) throws SerialException {
        this(iname, irate, Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String iname) throws SerialException {
        this(iname, Preferences.getInteger("serial.debug_rate"), Preferences.get("serial.parity").charAt(0), Preferences.getInteger("serial.databits"), new Float(Preferences.get("serial.stopbits")).floatValue());
    }

    public Serial(String iname, int irate, char iparity, int idatabits, float istopbits) throws SerialException {
        this.rate = irate;
        this.parity = 0;
        if (iparity == 'E') {
            this.parity = 2;
        }
        if (iparity == 'O') {
            this.parity = 1;
        }
        this.databits = idatabits;
        this.stopbits = 1;
        if (istopbits == 1.5f) {
            this.stopbits = 3;
        }
        if (istopbits == 2.0f) {
            this.stopbits = 2;
        }
        try {
            this.port = null;
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || !portId.getName().equals(iname)) continue;
                this.port = (SerialPort)portId.open("serial madness", 2000);
                this.input = this.port.getInputStream();
                this.output = this.port.getOutputStream();
                this.port.setSerialPortParams(this.rate, this.databits, this.stopbits, this.parity);
                this.port.addEventListener((SerialPortEventListener)this);
                this.port.notifyOnDataAvailable(true);
            }
        }
        catch (PortInUseException e) {
            throw new SerialException("Serial port '" + iname + "' already in use.  Try quiting any programs that may be using it.");
        }
        catch (Exception e) {
            throw new SerialException("Error opening serial port '" + iname + "'.", e);
        }
        if (this.port == null) {
            throw new SerialNotFoundException("Serial port '" + iname + "' not found.  Did you select the right one from the Tools > Serial Port menu?");
        }
    }

    public void setup() {
    }

    public void dispose() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.input = null;
        this.output = null;
        try {
            if (this.port != null) {
                this.port.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.port = null;
    }

    public void addListener(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void serialEvent(SerialPortEvent serialEvent) {
        if (serialEvent.getEventType() != 1) return;
        try {
            while (this.input.available() > 0) {
                byte[] byArray = this.buffer;
                // MONITORENTER : this.buffer
                if (this.bufferLast == this.buffer.length) {
                    byte[] temp = new byte[this.bufferLast << 1];
                    System.arraycopy(this.buffer, 0, temp, 0, this.bufferLast);
                    this.buffer = temp;
                }
                if (this.monitor) {
                    System.out.print((char)this.input.read());
                }
                if (this.consumer != null) {
                    this.consumer.message("" + (char)this.input.read());
                }
                // MONITOREXIT : byArray
            }
            return;
        }
        catch (IOException e) {
            Serial.errorMessage("serialEvent", e);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int outgoing = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outgoing;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length = this.bufferLast - this.bufferIndex;
            byte[] outgoing = new byte[length];
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] outgoing) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length = this.bufferLast - this.bufferIndex;
            if (length > outgoing.length) {
                length = outgoing.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int interesting) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte what = (byte)interesting;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int found = -1;
            for (int k = this.bufferIndex; k < this.bufferLast; ++k) {
                if (this.buffer[k] != what) continue;
                found = k;
                break;
            }
            if (found == -1) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            int length = found - this.bufferIndex + 1;
            byte[] outgoing = new byte[length];
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int interesting, byte[] outgoing) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte what = (byte)interesting;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int found = -1;
            for (int k = this.bufferIndex; k < this.bufferLast; ++k) {
                if (this.buffer[k] != what) continue;
                found = k;
                break;
            }
            if (found == -1) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return 0;
            }
            int length = found - this.bufferIndex + 1;
            if (length > outgoing.length) {
                System.err.println("readBytesUntil() byte buffer is too small for the " + length + " bytes up to and including char " + interesting);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return length;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int interesting) {
        byte[] b = this.readBytesUntil(interesting);
        if (b == null) {
            return null;
        }
        return new String(b);
    }

    public void write(int what) {
        try {
            this.output.write(what & 0xFF);
            this.output.flush();
        }
        catch (Exception e) {
            Serial.errorMessage("write", e);
        }
    }

    public void write(byte[] bytes) {
        try {
            this.output.write(bytes);
            this.output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(String what) {
        this.write(what.getBytes());
    }

    public void setDTR(boolean state) {
        this.port.setDTR(state);
    }

    public void setRTS(boolean state) {
        this.port.setRTS(state);
    }

    public static String[] list() {
        Vector<String> list = new Vector<String>();
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1) continue;
                String name = portId.getName();
                list.addElement(name);
            }
        }
        catch (UnsatisfiedLinkError e) {
            Serial.errorMessage("ports", e);
        }
        catch (Exception e) {
            Serial.errorMessage("ports", e);
        }
        Object[] outgoing = new String[list.size()];
        list.copyInto(outgoing);
        return outgoing;
    }

    public static void errorMessage(String where, Throwable e) {
        System.err.println("Error inside Serial." + where + "()");
        e.printStackTrace();
    }
}

