/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.SerialNotFoundException;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.RunnerException;

public abstract class Uploader
implements MessageConsumer {
    static final String BUGS_URL = "https://developer.berlios.de/bugs/?group_id=3590";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to https://developer.berlios.de/bugs/?group_id=3590";
    RunnerException exception;
    static InputStream serialInput;
    static OutputStream serialOutput;
    boolean verbose;
    boolean firstErrorFound;
    boolean secondErrorFound;
    boolean notFoundError;

    public abstract boolean uploadUsingPreferences(String var1, String var2, boolean var3) throws RunnerException, SerialException;

    public abstract boolean burnBootloader(String var1, String var2) throws RunnerException;

    protected void flushSerialBuffer() throws RunnerException, SerialException {
        try {
            Serial serialPort = new Serial();
            while (serialPort.available() > 0) {
                byte[] readBuffer = serialPort.readBytes();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            serialPort.setDTR(false);
            serialPort.setRTS(false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            serialPort.setDTR(true);
            serialPort.setRTS(true);
            serialPort.dispose();
        }
        catch (SerialNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RunnerException(e.getMessage());
        }
    }

    protected boolean executeUploadCommand(Collection commandDownloader) throws RunnerException {
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        this.notFoundError = false;
        int result = 0;
        String userdir = System.getProperty("user.dir") + File.separator;
        try {
            String[] commandArray = new String[commandDownloader.size()];
            commandDownloader.toArray(commandArray);
            String avrBasePath = Base.isLinux() ? new String(Base.getHardwarePath() + "/tools/") : new String(Base.getHardwarePath() + "/tools/avr/bin/");
            commandArray[0] = avrBasePath + commandArray[0];
            if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                for (int i = 0; i < commandArray.length; ++i) {
                    System.out.print(commandArray[i] + " ");
                }
                System.out.println();
            }
            Process process = Runtime.getRuntime().exec(commandArray);
            new MessageSiphon(process.getInputStream(), this);
            new MessageSiphon(process.getErrorStream(), this);
            boolean compiling = true;
            while (compiling) {
                try {
                    result = process.waitFor();
                    compiling = false;
                }
                catch (InterruptedException intExc) {}
            }
            if (this.exception != null) {
                this.exception.hideStackTrace();
                throw this.exception;
            }
            if (result != 0) {
                return false;
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("uisp: not found") != -1 && msg.indexOf("avrdude: not found") != -1) {
                return false;
            }
            e.printStackTrace();
            result = -1;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result != 0 && result != 1) {
            this.exception = new RunnerException(SUPER_BADNESS);
        }
        return result == 0;
    }

    public void message(String s) {
        System.err.print(s);
        if (s.indexOf("Error") != -1) {
            this.notFoundError = true;
            return;
        }
        if (this.notFoundError) {
            this.exception = new RunnerException("the selected serial port " + s + " does not exist or your board is not connected");
            return;
        }
        if (s.indexOf("Device is not responding") != -1) {
            this.exception = new RunnerException("Device is not responding, check the right serial port is selected or RESET the board right before exporting");
            return;
        }
        if (s.indexOf("Programmer is not responding") != -1 || s.indexOf("programmer is not responding") != -1 || s.indexOf("protocol error") != -1) {
            this.exception = new RunnerException("Problem uploading to board.  See http://www.arduino.cc/en/Guide/Troubleshooting#upload for suggestions.");
            return;
        }
        if (s.indexOf("Expected signature") != -1) {
            this.exception = new RunnerException("Wrong microcontroller found.  Did you select the right board from the Tools > Board menu?");
            return;
        }
    }
}

