/*
 * Decompiled with CFR 0.152.
 */
package processing.app.preproc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdePreprocessor {
    public int prototypeCount = 0;
    public int headerCount = 1;
    List<String> prototypes;
    List<String> programImports;
    List<String> codeFolderImports;
    String indent;
    PrintStream stream;
    String program;
    String buildPath;
    String name;

    public PdePreprocessor() {
        int tabSize = Preferences.getInteger("editor.tabs.size");
        char[] indentChars = new char[tabSize];
        Arrays.fill(indentChars, ' ');
        this.indent = new String(indentChars);
    }

    public int writePrefix(String program, String buildPath, String sketchName, String[] codeFolderPackages) throws FileNotFoundException {
        this.buildPath = buildPath;
        this.name = sketchName;
        program = program + "\n";
        Sketch.scrubComments(program);
        if (Preferences.getBoolean("preproc.substitute_unicode")) {
            program = PdePreprocessor.substituteUnicode(program);
        }
        String importRegexp = "^\\s*#include\\s+[<\"](\\S+)[\">]";
        this.programImports = new ArrayList<String>();
        String[][] pieces = PApplet.matchAll((String)program, (String)importRegexp);
        if (pieces != null) {
            for (int i = 0; i < pieces.length; ++i) {
                this.programImports.add(pieces[i][1]);
            }
        }
        this.codeFolderImports = new ArrayList<String>();
        this.prototypes = this.prototypes(program);
        this.prototypeCount = this.prototypes.size();
        this.program = program;
        File streamFile = new File(buildPath, this.name + ".cpp");
        this.stream = new PrintStream(new FileOutputStream(streamFile));
        return this.headerCount + this.prototypeCount;
    }

    static String substituteUnicode(String program) {
        char[] p = program.toCharArray();
        int unicodeCount = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] <= '\u007f') continue;
            ++unicodeCount;
        }
        if (unicodeCount != 0) {
            int index = 0;
            char[] p2 = new char[p.length + unicodeCount * 5];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] < '\u0080') {
                    p2[index++] = p[i];
                    continue;
                }
                if (p[i] == '\u00a0') {
                    p2[index++] = 32;
                    continue;
                }
                char c = p[i];
                p2[index++] = 92;
                p2[index++] = 117;
                char[] str = Integer.toHexString(c).toCharArray();
                for (int m = 0; m < 4 - str.length; ++m) {
                    p2[index++] = 48;
                }
                System.arraycopy(str, 0, p2, index, str.length);
                index += str.length;
            }
            program = new String(p2, 0, index);
        }
        return program;
    }

    public String write() throws Exception {
        this.writeProgram(this.stream, this.program, this.prototypes);
        this.writeFooter(this.stream);
        this.stream.close();
        return this.name;
    }

    protected void writeProgram(PrintStream out, String program, List<String> prototypes) {
        int prototypeInsertionPoint = this.firstStatement(program);
        out.print(program.substring(0, prototypeInsertionPoint));
        out.print("#include \"WProgram.h\"\n");
        for (int i = 0; i < prototypes.size(); ++i) {
            out.print(prototypes.get(i) + "\n");
        }
        out.print(program.substring(prototypeInsertionPoint));
    }

    protected void writeFooter(PrintStream out) throws Exception {
    }

    public List<String> getExtraImports() {
        return this.programImports;
    }

    public int firstStatement(String in) {
        String p = "\\s+";
        p = p + "|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)|(//.*?$)";
        p = p + "|(#(?:\\\\\\n|.)*)";
        Pattern pattern = Pattern.compile(p, 8);
        Matcher matcher = pattern.matcher(in);
        int i = 0;
        while (matcher.find() && matcher.start() == i) {
            i = matcher.end();
        }
        return i;
    }

    public String strip(String in) {
        String p = "('.')";
        p = p + "|(\"(?:[^\"\\\\]|\\\\.)*\")";
        p = p + "|(//.*?$)|(/\\*[^*]*(?:\\*(?!/)[^*]*)*\\*/)";
        p = p + "|(^\\s*#.*?$)";
        Pattern pattern = Pattern.compile(p, 8);
        Matcher matcher = pattern.matcher(in);
        return matcher.replaceAll(" ");
    }

    private String collapseBraces(String in) {
        StringBuffer buffer = new StringBuffer();
        int nesting = 0;
        int start = 0;
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) == '{') {
                if (nesting == 0) {
                    buffer.append(in.substring(start, i + 1));
                }
                ++nesting;
            }
            if (in.charAt(i) != '}' || --nesting != 0) continue;
            start = i;
        }
        buffer.append(in.substring(start));
        return buffer.toString();
    }

    public ArrayList<String> prototypes(String in) {
        in = this.collapseBraces(this.strip(in));
        Pattern pattern = Pattern.compile("[\\w\\[\\]\\*]+\\s+[&\\[\\]\\*\\w\\s]+\\([&,\\[\\]\\*\\w\\s]*\\)(?=\\s*\\{)");
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = pattern.matcher(in);
        while (matcher.find()) {
            matches.add(matcher.group(0) + ";");
        }
        return matches;
    }
}

