/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.Dialog;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.WindowPeer;
import java.util.ArrayList;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WWindowPeer;
import sun.java2d.d3d.D3DContext;
import sun.java2d.d3d.D3DGraphicsConfig;
import sun.java2d.d3d.D3DRenderQueue;
import sun.java2d.pipe.RenderQueue;
import sun.java2d.pipe.hw.ContextCapabilities;
import sun.java2d.windows.WindowsFlags;

public class D3DGraphicsDevice
extends Win32GraphicsDevice {
    private D3DContext context;
    private static boolean d3dAvailable;
    private ContextCapabilities d3dCaps;
    private boolean fsStatus;
    private Rectangle ownerOrigBounds = null;
    private boolean ownerWasVisible;
    private Window realFSWindow;
    private WindowListener fsWindowListener;
    private boolean fsWindowWasAlwaysOnTop;

    private static native boolean initD3D();

    public static D3DGraphicsDevice createDevice(int n) {
        if (!d3dAvailable) {
            return null;
        }
        ContextCapabilities contextCapabilities = D3DGraphicsDevice.getDeviceCaps(n);
        if ((contextCapabilities.getCaps() & 0x40000) == 0) {
            if (WindowsFlags.isD3DVerbose()) {
                System.out.println("Could not enable Direct3D pipeline on screen " + n);
            }
            return null;
        }
        if (WindowsFlags.isD3DVerbose()) {
            System.out.println("Direct3D pipeline enabled on screen " + n);
        }
        D3DGraphicsDevice d3DGraphicsDevice = new D3DGraphicsDevice(n, contextCapabilities);
        return d3DGraphicsDevice;
    }

    private static native int getDeviceCapsNative(int var0);

    private static native String getDeviceIdNative(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContextCapabilities getDeviceCaps(final int n) {
        D3DContext.D3DContextCaps d3DContextCaps = null;
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            class Result {
                int caps;
                String id;

                Result() {
                }
            }
            final Result result = new Result();
            d3DRenderQueue.flushAndInvokeNow(new Runnable(){
                {
                }

                public void run() {
                    result.caps = D3DGraphicsDevice.getDeviceCapsNative(n);
                    result.id = D3DGraphicsDevice.getDeviceIdNative(n);
                }
            });
            d3DContextCaps = new D3DContext.D3DContextCaps(result.caps, result.id);
        }
        finally {
            d3DRenderQueue.unlock();
        }
        return d3DContextCaps != null ? d3DContextCaps : new D3DContext.D3DContextCaps(0, null);
    }

    public final boolean isCapPresent(int n) {
        return (this.d3dCaps.getCaps() & n) != 0;
    }

    private D3DGraphicsDevice(int n, ContextCapabilities contextCapabilities) {
        super(n);
        this.descString = "D3DGraphicsDevice[screen=" + n;
        this.d3dCaps = contextCapabilities;
        this.context = new D3DContext(D3DRenderQueue.getInstance(), this);
    }

    public boolean isD3DEnabledOnDevice() {
        return this.isValid() && this.isCapPresent(262144);
    }

    public static boolean isD3DAvailable() {
        return d3dAvailable;
    }

    private Frame getToplevelOwner(Window window) {
        Window window2 = window;
        while (window2 != null) {
            if (!((window2 = window2.getOwner()) instanceof Frame)) continue;
            return (Frame)window2;
        }
        return null;
    }

    private static native boolean enterFullScreenExclusiveNative(int var0, long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enterFullScreenExclusive(final int n, WindowPeer windowPeer) {
        final WWindowPeer wWindowPeer = (WWindowPeer)this.realFSWindow.getPeer();
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            d3DRenderQueue.flushAndInvokeNow(new Runnable(){

                public void run() {
                    long l = wWindowPeer.getHWnd();
                    if (l == 0L) {
                        D3DGraphicsDevice.this.fsStatus = false;
                        return;
                    }
                    D3DGraphicsDevice.this.fsStatus = D3DGraphicsDevice.enterFullScreenExclusiveNative(n, l);
                }
            });
        }
        finally {
            d3DRenderQueue.unlock();
        }
        if (!this.fsStatus) {
            super.enterFullScreenExclusive(n, windowPeer);
        }
    }

    private static native boolean exitFullScreenExclusiveNative(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitFullScreenExclusive(final int n, WindowPeer windowPeer) {
        if (this.fsStatus) {
            D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
            d3DRenderQueue.lock();
            try {
                d3DRenderQueue.flushAndInvokeNow(new Runnable(){

                    public void run() {
                        D3DGraphicsDevice.exitFullScreenExclusiveNative(n);
                    }
                });
            }
            finally {
                d3DRenderQueue.unlock();
            }
        } else {
            super.exitFullScreenExclusive(n, windowPeer);
        }
    }

    protected void addFSWindowListener(Window window) {
        if (!(window instanceof Frame) && !(window instanceof Dialog) && (this.realFSWindow = this.getToplevelOwner(window)) != null) {
            this.ownerOrigBounds = this.realFSWindow.getBounds();
            WWindowPeer wWindowPeer = (WWindowPeer)this.realFSWindow.getPeer();
            this.ownerWasVisible = this.realFSWindow.isVisible();
            Rectangle rectangle = window.getBounds();
            wWindowPeer.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            wWindowPeer.setVisible(true);
        } else {
            this.realFSWindow = window;
        }
        this.fsWindowWasAlwaysOnTop = this.realFSWindow.isAlwaysOnTop();
        ((WWindowPeer)this.realFSWindow.getPeer()).setAlwaysOnTop(true);
        this.fsWindowListener = new D3DFSWindowAdapter();
        this.realFSWindow.addWindowListener(this.fsWindowListener);
    }

    protected void removeFSWindowListener(Window window) {
        this.realFSWindow.removeWindowListener(this.fsWindowListener);
        this.fsWindowListener = null;
        WWindowPeer wWindowPeer = (WWindowPeer)this.realFSWindow.getPeer();
        if (wWindowPeer != null) {
            if (this.ownerOrigBounds != null) {
                if (this.ownerOrigBounds.width == 0) {
                    this.ownerOrigBounds.width = 1;
                }
                if (this.ownerOrigBounds.height == 0) {
                    this.ownerOrigBounds.height = 1;
                }
                wWindowPeer.reshape(this.ownerOrigBounds.x, this.ownerOrigBounds.y, this.ownerOrigBounds.width, this.ownerOrigBounds.height);
                if (!this.ownerWasVisible) {
                    wWindowPeer.setVisible(false);
                }
                this.ownerOrigBounds = null;
            }
            if (!this.fsWindowWasAlwaysOnTop) {
                wWindowPeer.setAlwaysOnTop(false);
            }
        }
        this.realFSWindow = null;
    }

    private static native DisplayMode getCurrentDisplayModeNative(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DisplayMode getCurrentDisplayMode(final int n) {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            class Result {
                DisplayMode dm = null;

                Result() {
                }
            }
            final Result result = new Result();
            d3DRenderQueue.flushAndInvokeNow(new Runnable(){
                {
                }

                public void run() {
                    result.dm = D3DGraphicsDevice.getCurrentDisplayModeNative(n);
                }
            });
            if (result.dm == null) {
                DisplayMode displayMode = super.getCurrentDisplayMode(n);
                return displayMode;
            }
            DisplayMode displayMode = result.dm;
            return displayMode;
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    private static native void configDisplayModeNative(int var0, long var1, int var3, int var4, int var5, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDisplayMode(final int n, WindowPeer windowPeer, final int n2, final int n3, final int n4, final int n5) {
        Object object;
        if (!this.fsStatus) {
            super.configDisplayMode(n, windowPeer, n2, n3, n4, n5);
            return;
        }
        final WWindowPeer wWindowPeer = (WWindowPeer)this.realFSWindow.getPeer();
        if (this.getFullScreenWindow() != this.realFSWindow) {
            object = this.getDefaultConfiguration().getBounds();
            wWindowPeer.reshape(((Rectangle)object).x, ((Rectangle)object).y, n2, n3);
        }
        object = D3DRenderQueue.getInstance();
        ((RenderQueue)object).lock();
        try {
            ((D3DRenderQueue)object).flushAndInvokeNow(new Runnable(){

                public void run() {
                    long l = wWindowPeer.getHWnd();
                    if (l == 0L) {
                        return;
                    }
                    D3DGraphicsDevice.configDisplayModeNative(n, l, n2, n3, n4, n5);
                }
            });
        }
        finally {
            ((RenderQueue)object).unlock();
        }
    }

    private static native void enumDisplayModesNative(int var0, ArrayList var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumDisplayModes(final int n, final ArrayList arrayList) {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            d3DRenderQueue.flushAndInvokeNow(new Runnable(){

                public void run() {
                    D3DGraphicsDevice.enumDisplayModesNative(n, arrayList);
                }
            });
            if (arrayList.size() == 0) {
                arrayList.add(D3DGraphicsDevice.getCurrentDisplayModeNative(n));
            }
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    private static native long getAvailableAcceleratedMemoryNative(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableAcceleratedMemory() {
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            class Result {
                long mem = 0L;

                Result() {
                }
            }
            final Result result = new Result();
            d3DRenderQueue.flushAndInvokeNow(new Runnable(){
                {
                }

                public void run() {
                    result.mem = D3DGraphicsDevice.getAvailableAcceleratedMemoryNative(D3DGraphicsDevice.this.getScreen());
                }
            });
            int n = (int)result.mem;
            return n;
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null && this.isD3DEnabledOnDevice()) {
            this.defaultConfig = this.getDefaultConfiguration();
            if (this.defaultConfig != null) {
                this.configs = new GraphicsConfiguration[1];
                this.configs[0] = this.defaultConfig;
                return this.configs;
            }
        }
        return super.getConfigurations();
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            this.defaultConfig = this.isD3DEnabledOnDevice() ? new D3DGraphicsConfig(this) : super.getDefaultConfiguration();
        }
        return this.defaultConfig;
    }

    private static native boolean isD3DAvailableOnDeviceNative(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isD3DAvailableOnDevice(final int n) {
        if (!d3dAvailable) {
            return false;
        }
        D3DRenderQueue d3DRenderQueue = D3DRenderQueue.getInstance();
        d3DRenderQueue.lock();
        try {
            class Result {
                boolean avail = false;

                Result() {
                }
            }
            final Result result = new Result();
            d3DRenderQueue.flushAndInvokeNow(new Runnable(){
                {
                }

                public void run() {
                    result.avail = D3DGraphicsDevice.isD3DAvailableOnDeviceNative(n);
                }
            });
            boolean bl = result.avail;
            return bl;
        }
        finally {
            d3DRenderQueue.unlock();
        }
    }

    D3DContext getContext() {
        return this.context;
    }

    ContextCapabilities getContextCapabilities() {
        return this.d3dCaps;
    }

    public void displayChanged() {
        super.displayChanged();
        if (d3dAvailable) {
            this.d3dCaps = D3DGraphicsDevice.getDeviceCaps(this.getScreen());
        }
    }

    protected void invalidate(int n) {
        super.invalidate(n);
        this.d3dCaps = new D3DContext.D3DContextCaps(0, null);
    }

    static {
        Toolkit.getDefaultToolkit();
        d3dAvailable = D3DGraphicsDevice.initD3D();
        if (d3dAvailable) {
            pfDisabled = true;
        }
    }

    private static class D3DFSWindowAdapter
    extends WindowAdapter {
        private D3DFSWindowAdapter() {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            D3DRenderQueue.getInstance();
            D3DRenderQueue.restoreDevices();
        }

        public void windowActivated(WindowEvent windowEvent) {
            D3DRenderQueue.getInstance();
            D3DRenderQueue.restoreDevices();
        }
    }
}

