/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.util.Arrays;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphicsAndroid3D;
import processing.core.PTexture;

class PFontTexture
implements PConstants {
    protected PApplet parent;
    protected PGraphicsAndroid3D a3d;
    protected PFont font;
    protected int maxTexWidth;
    protected int maxTexHeight;
    protected int offsetX;
    protected int offsetY;
    protected int lineHeight;
    protected PTexture[] textures = null;
    protected int currentTex;
    protected int lastTex;
    protected TextureInfo[] glyphTexinfos;
    protected HashMap<PFont.Glyph, TextureInfo> texinfoMap;

    public PFontTexture(PApplet pApplet, PFont pFont, int n, int n2) {
        this.parent = pApplet;
        this.font = pFont;
        this.a3d = (PGraphicsAndroid3D)pApplet.g;
        this.a3d.registerPGLObject(this);
        this.initTexture(n, n2);
    }

    public void delete() {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i].delete();
        }
        this.a3d.unregisterPGLObject(this);
    }

    public void backup() {
    }

    public void restore() {
        for (int i = 0; i < PApplet.min(this.font.getGlyphCount(), this.glyphTexinfos.length); ++i) {
            TextureInfo textureInfo = this.glyphTexinfos[i];
            this.textures[textureInfo.texIndex].bind();
            textureInfo.updateTex();
            this.textures[textureInfo.texIndex].unbind();
        }
    }

    protected void allocate() {
    }

    protected void initTexture(int n, int n2) {
        this.maxTexWidth = n;
        this.maxTexHeight = n2;
        this.currentTex = -1;
        this.lastTex = -1;
        this.addTexture();
        this.offsetX = 0;
        this.offsetY = 0;
        this.lineHeight = 0;
        this.texinfoMap = new HashMap();
        this.glyphTexinfos = new TextureInfo[this.font.getGlyphCount()];
        this.addAllGlyphsToTexture();
    }

    public boolean addTexture() {
        boolean bl;
        int n;
        int n2 = this.maxTexWidth;
        if (-1 < this.currentTex && this.textures[this.currentTex].glHeight < this.maxTexHeight) {
            n = PApplet.min(2 * this.textures[this.currentTex].glHeight, this.maxTexHeight);
            bl = true;
        } else {
            n = PApplet.min(PGraphicsAndroid3D.maxTextureSize, this.font.size * 2, this.maxTexHeight / 4);
            bl = false;
        }
        PTexture pTexture = new PTexture(this.parent, n2, n, new PTexture.Parameters(2, 3));
        if (this.textures == null) {
            this.textures = new PTexture[1];
            this.textures[0] = pTexture;
            this.currentTex = 0;
        } else if (bl) {
            PTexture pTexture2 = this.textures[this.currentTex];
            pTexture.put(pTexture2);
            this.textures[this.currentTex] = pTexture;
            pTexture2.delete();
        } else {
            PTexture[] pTextureArray = this.textures;
            this.textures = new PTexture[this.textures.length + 1];
            PApplet.arrayCopy(pTextureArray, this.textures, pTextureArray.length);
            this.textures[pTextureArray.length] = pTexture;
            this.currentTex = this.textures.length - 1;
        }
        this.lastTex = this.currentTex;
        pTexture.bind();
        return bl;
    }

    public void setFirstTexture() {
        this.setTexture(0);
    }

    public void setTexture(int n) {
        if (0 <= n && n < this.textures.length) {
            this.currentTex = n;
            this.textures[this.currentTex].bind();
        }
    }

    public void addAllGlyphsToTexture() {
        for (int i = 0; i < this.font.getGlyphCount(); ++i) {
            this.addToTexture(i, this.font.getGlyph(i));
        }
    }

    public void updateGlyphsTexCoords() {
        for (int i = 0; i < this.font.getGlyphCount(); ++i) {
            TextureInfo textureInfo = this.glyphTexinfos[i];
            if (textureInfo == null || textureInfo.texIndex != this.currentTex) continue;
            textureInfo.updateUV();
        }
    }

    public TextureInfo getTexInfo(PFont.Glyph glyph) {
        TextureInfo textureInfo = this.texinfoMap.get(glyph);
        return textureInfo;
    }

    public TextureInfo addToTexture(PFont.Glyph glyph) {
        int n = this.glyphTexinfos.length;
        if (n == 0) {
            this.glyphTexinfos = new TextureInfo[1];
        }
        this.addToTexture(n, glyph);
        return this.glyphTexinfos[n];
    }

    protected void addToTexture(int n, PFont.Glyph glyph) {
        int n2;
        int n3;
        int n4 = 1 + glyph.width + 1;
        int n5 = 1 + glyph.height + 1;
        int[] nArray = new int[n4 * n5];
        int n6 = 0;
        int n7 = 0;
        if (PGraphicsAndroid3D.BIG_ENDIAN) {
            Arrays.fill(nArray, 0, n4, -256);
            n6 = n4;
            for (n3 = 0; n3 < glyph.height; ++n3) {
                nArray[n6++] = -256;
                for (n2 = 0; n2 < glyph.width; ++n2) {
                    nArray[n6++] = 0xFFFFFF00 | glyph.image.pixels[n7++];
                }
                nArray[n6++] = -256;
            }
            Arrays.fill(nArray, (n5 - 1) * n4, n5 * n4, -256);
        } else {
            Arrays.fill(nArray, 0, n4, 0xFFFFFF);
            n6 = n4;
            for (n3 = 0; n3 < glyph.height; ++n3) {
                nArray[n6++] = 0xFFFFFF;
                for (n2 = 0; n2 < glyph.width; ++n2) {
                    nArray[n6++] = glyph.image.pixels[n7++] << 24 | 0xFFFFFF;
                }
                nArray[n6++] = 0xFFFFFF;
            }
            Arrays.fill(nArray, (n5 - 1) * n4, n5 * n4, 0xFFFFFF);
        }
        if (this.offsetX + n4 > this.textures[this.currentTex].glWidth) {
            this.offsetX = 0;
            this.offsetY += this.lineHeight;
            this.lineHeight = 0;
        }
        this.lineHeight = Math.max(this.lineHeight, n5);
        n3 = 0;
        if (this.offsetY + this.lineHeight > this.textures[this.currentTex].glHeight) {
            n3 = this.addTexture() ? 1 : 0;
            if (n3 != 0) {
                this.updateGlyphsTexCoords();
            } else {
                this.offsetX = 0;
                this.offsetY = 0;
                this.lineHeight = 0;
            }
        }
        if (this.lastTex == -1) {
            this.lastTex = 0;
        }
        if (this.currentTex != this.lastTex || n3 != 0) {
            this.setTexture(this.lastTex);
        }
        TextureInfo textureInfo = new TextureInfo(this.currentTex, this.offsetX, this.offsetY, n4, n5, nArray);
        this.offsetX += n4;
        if (n == this.glyphTexinfos.length) {
            TextureInfo[] textureInfoArray = new TextureInfo[this.glyphTexinfos.length + 1];
            System.arraycopy(this.glyphTexinfos, 0, textureInfoArray, 0, this.glyphTexinfos.length);
            this.glyphTexinfos = textureInfoArray;
        }
        this.glyphTexinfos[n] = textureInfo;
        this.texinfoMap.put(glyph, textureInfo);
    }

    public class TextureInfo {
        public int texIndex;
        public int width;
        public int height;
        public int[] crop;
        public float u0;
        public float u1;
        public float v0;
        public float v1;
        public int[] pixels;

        public TextureInfo(int n, int n2, int n3, int n4, int n5, int[] nArray) {
            this.texIndex = n;
            this.crop = new int[4];
            this.crop[0] = n2 + 1;
            this.crop[1] = n3 + 1 + n5 - 2;
            this.crop[2] = n4 - 2;
            this.crop[3] = -n5 + 2;
            this.pixels = nArray;
            this.updateUV();
            this.updateTex();
        }

        void updateUV() {
            this.width = PFontTexture.this.textures[this.texIndex].glWidth;
            this.height = PFontTexture.this.textures[this.texIndex].glHeight;
            this.u0 = (float)this.crop[0] / (float)this.width;
            this.u1 = this.u0 + (float)this.crop[2] / (float)this.width;
            this.v0 = (float)(this.crop[1] + this.crop[3]) / (float)this.height;
            this.v1 = this.v0 - (float)this.crop[3] / (float)this.height;
        }

        void updateTex() {
            PFontTexture.this.textures[this.texIndex].setTexels(PFontTexture.this.offsetX, this.crop[0] - 1, this.crop[1] + this.crop[3] - 1, this.crop[2] + 2, -this.crop[3] + 2, this.pixels);
        }
    }
}

