/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11ExtensionPack;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphicsAndroid3D;
import processing.core.PTexture;

public class PFramebuffer
implements PConstants {
    protected PApplet parent;
    protected PGraphicsAndroid3D a3d;
    public int glFboID;
    public int glDepthBufferID;
    public int glStencilBufferID;
    public int width;
    public int height;
    protected int depthBits;
    protected int stencilBits;
    protected int numColorBuffers;
    protected int[] colorBufferAttchPoints;
    protected PTexture[] colorBufferTex;
    protected boolean screenFb;
    protected boolean noDepth;
    protected boolean fboMode;
    protected PTexture backupTexture;
    protected IntBuffer pixelBuffer;

    PFramebuffer(PApplet pApplet) {
        this(pApplet, 0, 0, false);
    }

    PFramebuffer(PApplet pApplet, int n, int n2) {
        this(pApplet, n, n2, 1, 1, 0, 0, false);
    }

    PFramebuffer(PApplet pApplet, int n, int n2, boolean bl) {
        this(pApplet, n, n2, 1, 1, 0, 0, bl);
    }

    PFramebuffer(PApplet pApplet, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.parent = pApplet;
        this.a3d = (PGraphicsAndroid3D)pApplet.g;
        if (this.a3d.gl11xp == null) {
            throw new RuntimeException("PFramebuffer: OpenGL ES 1.1 Extension Pack required");
        }
        this.a3d.registerPGLObject(this);
        this.glFboID = 0;
        this.glDepthBufferID = 0;
        this.glStencilBufferID = 0;
        this.fboMode = PGraphicsAndroid3D.fboSupported;
        if (bl) {
            n4 = 0;
            n3 = 0;
            n6 = 0;
            n5 = 0;
        }
        this.width = n;
        this.height = n2;
        this.numColorBuffers = n4;
        this.colorBufferAttchPoints = new int[this.numColorBuffers];
        this.colorBufferTex = new PTexture[this.numColorBuffers];
        for (int i = 0; i < this.numColorBuffers; ++i) {
            this.colorBufferAttchPoints[i] = 36064 + i;
            this.colorBufferTex[i] = null;
        }
        if (n5 < 1 && n6 < 1) {
            this.depthBits = 0;
            this.stencilBits = 0;
        } else {
            this.depthBits = n5;
            this.stencilBits = n6;
        }
        this.screenFb = bl;
        this.allocate();
        this.noDepth = false;
        this.pixelBuffer = null;
        if (!this.screenFb && !this.fboMode) {
            this.backupTexture = new PTexture(pApplet, this.width, this.height, new PTexture.Parameters(2, 2));
        }
    }

    public void delete() {
        this.release();
        for (int i = 0; i < this.numColorBuffers; ++i) {
            this.colorBufferTex[i] = null;
        }
        this.a3d.unregisterPGLObject(this);
    }

    public void backup() {
    }

    public void restore() {
        this.setColorBuffers((PTexture[])this.colorBufferTex.clone(), this.colorBufferTex.length);
    }

    public void clear() {
        this.a3d.pushFramebuffer();
        this.a3d.setFramebuffer(this);
        this.getGl().glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.getGl().glClear(17664);
        this.a3d.popFramebuffer();
    }

    public void bind() {
        if (this.screenFb) {
            if (PGraphicsAndroid3D.fboSupported) {
                this.getGlx().glBindFramebufferOES(36160, 0);
            }
        } else if (this.fboMode) {
            this.getGlx().glBindFramebufferOES(36160, this.glFboID);
        } else {
            this.backupScreen();
            if (this.noDepth) {
                this.getGl().glDisable(2929);
            }
        }
    }

    public void disableDepthTest() {
        this.noDepth = true;
    }

    public void finish() {
        if (this.noDepth) {
            if (this.a3d.hints[4]) {
                this.getGl().glDisable(2929);
            } else {
                this.getGl().glEnable(2929);
            }
        }
        if (!this.screenFb && !this.fboMode) {
            this.copyToColorBuffers();
            this.restoreBackup();
            if (!this.noDepth) {
                this.getGl().glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                this.getGl().glClear(256);
            }
        }
    }

    public void backupScreen() {
        if (this.pixelBuffer == null) {
            this.createPixelBuffer();
        }
        this.getGl().glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
        this.copyToTexture(this.pixelBuffer, this.backupTexture.glID, this.backupTexture.glTarget);
    }

    public void restoreBackup() {
        this.a3d.drawTexture(this.backupTexture, 0, 0, this.width, this.height, 0, 0, this.width, this.height);
    }

    public void copyToColorBuffers() {
        if (this.pixelBuffer == null) {
            this.createPixelBuffer();
        }
        this.getGl().glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
        for (int i = 0; i < this.numColorBuffers; ++i) {
            this.copyToTexture(this.pixelBuffer, this.colorBufferTex[i].glID, this.colorBufferTex[i].glTarget);
        }
    }

    public void readPixels() {
        if (this.pixelBuffer == null) {
            this.createPixelBuffer();
        }
        this.getGl().glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
    }

    public void getPixels(int[] nArray) {
        if (this.pixelBuffer != null) {
            this.pixelBuffer.get(nArray);
            this.pixelBuffer.rewind();
        }
    }

    public IntBuffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public boolean hasDepthBuffer() {
        return 0 < this.depthBits;
    }

    public boolean hasStencilBuffer() {
        return 0 < this.stencilBits;
    }

    public void setColorBuffer(PTexture pTexture) {
        this.setColorBuffers(new PTexture[]{pTexture}, 1);
    }

    public void setColorBuffers(PTexture[] pTextureArray) {
        this.setColorBuffers(pTextureArray, pTextureArray.length);
    }

    public void setColorBuffers(PTexture[] pTextureArray, int n) {
        int n2;
        if (this.screenFb) {
            return;
        }
        if (this.numColorBuffers != PApplet.min(n, pTextureArray.length)) {
            throw new RuntimeException("Wrong number of textures to set the color buffers.");
        }
        for (n2 = 0; n2 < this.numColorBuffers; ++n2) {
            this.colorBufferTex[n2] = pTextureArray[n2];
        }
        if (this.fboMode) {
            this.a3d.pushFramebuffer();
            this.a3d.setFramebuffer(this);
            for (n2 = 0; n2 < this.numColorBuffers; ++n2) {
                this.getGlx().glFramebufferTexture2DOES(36160, 36064 + n2, 3553, 0, 0);
            }
            for (n2 = 0; n2 < this.numColorBuffers; ++n2) {
                this.getGlx().glFramebufferTexture2DOES(36160, this.colorBufferAttchPoints[n2], this.colorBufferTex[n2].glTarget, this.colorBufferTex[n2].glID, 0);
            }
            this.validateFbo();
            this.a3d.popFramebuffer();
        }
    }

    protected void allocate() {
        this.release();
        this.glFboID = this.screenFb ? 0 : (this.fboMode ? this.a3d.createGLResource(2) : 0);
        if (0 < this.depthBits) {
            this.createDepthBuffer();
        }
        if (0 < this.stencilBits) {
            this.createStencilBuffer();
        }
    }

    protected void release() {
        this.deleteFbo();
        this.deleteDepthBuffer();
        this.deleteStencilBuffer();
    }

    protected void deleteFbo() {
        if (this.glFboID != 0) {
            this.a3d.deleteGLResource(this.glFboID, 2);
            this.glFboID = 0;
        }
    }

    protected void deleteDepthBuffer() {
        if (this.glDepthBufferID != 0) {
            this.a3d.deleteGLResource(this.glDepthBufferID, 3);
            this.glDepthBufferID = 0;
        }
    }

    protected void deleteStencilBuffer() {
        if (this.glStencilBufferID != 0) {
            this.a3d.deleteGLResource(this.glStencilBufferID, 3);
            this.glStencilBufferID = 0;
        }
    }

    protected void createDepthBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        if (this.fboMode) {
            this.a3d.pushFramebuffer();
            this.a3d.setFramebuffer(this);
            this.glDepthBufferID = this.a3d.createGLResource(3);
            this.getGlx().glBindRenderbufferOES(36161, this.glDepthBufferID);
            int n = 33189;
            if (this.depthBits == 16) {
                n = 33189;
            } else if (this.depthBits == 24) {
                n = 33190;
            } else if (this.depthBits == 32) {
                n = 33191;
            }
            this.getGlx().glRenderbufferStorageOES(36161, n, this.width, this.height);
            this.getGlx().glFramebufferRenderbufferOES(36160, 36096, 36161, this.glDepthBufferID);
            this.a3d.popFramebuffer();
        }
    }

    protected void createStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        if (this.fboMode) {
            this.a3d.pushFramebuffer();
            this.a3d.setFramebuffer(this);
            this.glStencilBufferID = this.a3d.createGLResource(3);
            this.getGlx().glBindRenderbufferOES(36161, this.glStencilBufferID);
            int n = 36166;
            if (this.stencilBits == 1) {
                n = 36166;
            } else if (this.stencilBits == 4) {
                n = 36167;
            } else if (this.stencilBits == 8) {
                n = 36168;
            }
            this.getGlx().glRenderbufferStorageOES(36161, n, this.width, this.height);
            this.getGlx().glFramebufferRenderbufferOES(36160, 36128, 36161, this.glStencilBufferID);
            this.a3d.popFramebuffer();
        }
    }

    protected void createPixelBuffer() {
        this.pixelBuffer = IntBuffer.allocate(this.width * this.height);
        this.pixelBuffer.rewind();
    }

    protected void copyToTexture(IntBuffer intBuffer, int n, int n2) {
        this.getGl().glEnable(n2);
        this.getGl().glBindTexture(n2, n);
        this.getGl().glTexSubImage2D(n2, 0, 0, 0, this.width, this.height, 6408, 5121, (Buffer)intBuffer);
        this.getGl().glBindTexture(n2, 0);
        this.getGl().glDisable(n2);
    }

    public boolean validateFbo() {
        int n = this.getGlx().glCheckFramebufferStatusOES(36160);
        if (n == 36053) {
            return true;
        }
        if (n == 36054) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES (" + Integer.toHexString(n) + ")");
        }
        if (n == 36055) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES (" + Integer.toHexString(n) + ")");
        }
        if (n == 36057) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES (" + Integer.toHexString(n) + ")");
        }
        if (n == 36058) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES (" + Integer.toHexString(n) + ")");
        }
        if (n == 36059) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES (" + Integer.toHexString(n) + ")");
        }
        if (n == 36060) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES (" + Integer.toHexString(n) + ")");
        }
        if (n == 36061) {
            throw new RuntimeException("PFramebuffer: GL_FRAMEBUFFER_UNSUPPORTED_OES" + Integer.toHexString(n));
        }
        throw new RuntimeException("PFramebuffer: unknown framebuffer error (" + Integer.toHexString(n) + ")");
    }

    protected GL10 getGl() {
        return this.a3d.gl;
    }

    protected GL11ExtensionPack getGlx() {
        return this.a3d.gl11xp;
    }
}

