/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import android.view.SurfaceHolder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;
import javax.microedition.khronos.opengles.GL11Ext;
import javax.microedition.khronos.opengles.GL11ExtensionPack;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PFontTexture;
import processing.core.PFramebuffer;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShape3D;
import processing.core.PTexture;
import processing.core.PVector;

public class PGraphicsAndroid3D
extends PGraphics {
    public GL10 gl;
    public GL11 gl11;
    public GL11Ext gl11x;
    public GL11ExtensionPack gl11xp;
    protected PGraphicsAndroid3D a3d;
    protected SurfaceHolder holder;
    protected A3DRenderer renderer;
    protected static boolean glParamsRead = false;
    public static boolean npotTexSupported;
    public static boolean mipmapGeneration;
    public static boolean matrixGetSupported;
    public static boolean vboSupported;
    public static boolean fboSupported;
    public static boolean blendEqSupported;
    public static boolean texenvCrossbarSupported;
    public static int maxTextureSize;
    public static float maxPointSize;
    public static float maxLineWidth;
    public static int maxTextureUnits;
    public static String OPENGL_VENDOR;
    public static String OPENGL_RENDERER;
    public static String OPENGL_VERSION;
    public static String OPENGL_EXTENSIONS;
    protected static final int GL_TEXTURE_OBJECT = 0;
    protected static final int GL_VERTEX_BUFFER = 1;
    protected static final int GL_FRAME_BUFFER = 2;
    protected static final int GL_RENDER_BUFFER = 3;
    protected static Set<PGraphicsAndroid3D> pGraphicsAndroid3DObjects;
    protected static Set<PTexture> pTextureObjects;
    protected static Set<PFramebuffer> pFramebufferObjects;
    protected static Set<PShape3D> pShape3DObjects;
    protected static Set<PFontTexture> pFontTextureObjects;
    protected static Set<Integer> glTextureObjects;
    protected static Set<Integer> glVertexBuffers;
    protected static Set<Integer> glFrameBuffers;
    protected static Set<Integer> glRenderBuffers;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    protected boolean manipulatingCamera;
    protected boolean scalingDuringCamManip;
    protected float[] glmodelview;
    protected float[] glmodelviewInv;
    protected float[] glprojection;
    protected float[] pcamera;
    protected float[] pcameraInv;
    protected float[] pprojection;
    protected float[] gltemp;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    public PMatrix3D projection;
    public PMatrix3D camera;
    public PMatrix3D cameraInv;
    protected boolean sizeChanged;
    protected boolean modelviewUpdated;
    protected boolean projectionUpdated;
    protected int matrixMode = 1;
    protected boolean matricesAllocated = false;
    protected static boolean usingGLMatrixStack;
    protected static GLMatrixStack modelviewStack;
    protected static GLMatrixStack projectionStack;
    public static final int MAX_LIGHTS = 8;
    public boolean lights;
    public int lightCount = 0;
    public int[] lightType;
    public float[][] lightPosition;
    public float[][] lightNormal;
    public float[] lightFalloffConstant;
    public float[] lightFalloffLinear;
    public float[] lightFalloffQuadratic;
    public float[] lightSpotAngle;
    public float[] lightSpotAngleCos;
    public float[] lightSpotConcentration;
    public float[][] lightDiffuse;
    public float[][] lightSpecular;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    public float[] zeroLight = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public float[] baseLight = new float[]{0.05f, 0.05f, 0.05f, 1.0f};
    protected boolean lightsAllocated = false;
    protected static final int VERTEX1 = 0;
    protected static final int VERTEX2 = 1;
    protected static final int VERTEX3 = 2;
    protected static final int POINT_FIELD_COUNT = 1;
    protected static final int LINE_FIELD_COUNT = 2;
    protected static final int TRIANGLE_FIELD_COUNT = 3;
    public static final int DEFAULT_POINTS = 512;
    protected int pointCount;
    protected int[][] points = new int[512][1];
    public static final int DEFAULT_LINES = 512;
    protected int lineCount;
    protected int[][] lines = new int[512][2];
    public static final int DEFAULT_TRIANGLES = 256;
    protected int triangleCount;
    protected int[][] triangles = new int[256][3];
    public static final int DEFAULT_BUFFER_SIZE = 512;
    protected IntBuffer vertexBuffer;
    protected IntBuffer colorBuffer;
    protected IntBuffer normalBuffer;
    protected IntBuffer[] texCoordBuffer;
    protected int[] vertexArray;
    protected int[] colorArray;
    protected int[] normalArray;
    protected int[][] texCoordArray;
    protected boolean geometryAllocated = false;
    protected int shapeFirst;
    protected int shapeLast;
    protected int[] vertexOrder = new int[512];
    public static final int DEFAULT_PATHS = 64;
    protected int pathCount;
    protected int[] pathOffset = new int[64];
    protected int[] pathLength = new int[64];
    public static final int DEFAULT_FACES = 64;
    protected int faceCount;
    protected int[] faceOffset = new int[64];
    protected int[] faceLength = new int[64];
    protected int[] faceMinIndex = new int[64];
    protected int[] faceMaxIndex = new int[64];
    protected PImage[][] faceTextures = new PImage[64][2];
    public GeometryBuffer geoBuffer;
    public boolean USE_GEO_BUFFER = false;
    public boolean GEO_BUFFER_ACCUM_ALL = true;
    public boolean UPDATE_GEO_BUFFER_MATRIX_STACK = true;
    public boolean UPDATE_GL_MATRIX_STACK = true;
    public int GEO_BUFFER_COUNT;
    public float GEO_BUFFER_SIZE;
    public int GEO_BUFFER_MAXSIZE = 0;
    public static final int MAX_TEXTURES = 2;
    protected int numTextures;
    protected int shapeTextures;
    protected int numTexBuffers;
    protected int texBlendMode;
    protected PTexture[] renderTextures = new PTexture[2];
    protected PImage[] textureImages = new PImage[2];
    protected PImage[] textureImages0 = new PImage[2];
    protected float[] texturesU = new float[2];
    protected float[] texturesV = new float[2];
    protected float[][] vertexU = new float[512][1];
    protected float[][] vertexV = new float[512][1];
    protected PImage[][] vertexTex = new PImage[512][1];
    protected float[] renderUa = new float[2];
    protected float[] renderVa = new float[2];
    protected float[] renderUb = new float[2];
    protected float[] renderVb = new float[2];
    protected float[] renderUc = new float[2];
    protected float[] renderVc = new float[2];
    int screenBlendMode;
    PFontTexture textTex;
    protected IntBuffer textVertexBuffer = null;
    protected IntBuffer textTexCoordBuffer = null;
    protected int[] textVertexArray = null;
    protected int[] textTexCoordArray = null;
    protected int textVertexCount = 0;
    protected boolean textBlockMode = false;
    protected int textBlockTex;
    protected static Stack<PFramebuffer> fbStack;
    protected static PFramebuffer screenFramebuffer;
    protected static PFramebuffer currentFramebuffer;
    protected PFramebuffer offscreenFramebuffer;
    protected PImage[] offscreenImages;
    protected PTexture[] offscreenTextures;
    protected PTexture.Parameters[] offscreenParams;
    protected int offscreenIndex;
    protected int[] offscreenTexCrop;
    public int offscreenDepthBits = 16;
    public int offscreenStencilBits = 0;
    protected boolean recordingShape;
    protected int recTexturesCount = 0;
    protected boolean mergeRecShapes = false;
    protected String recShapeName;
    protected PShape3D recordedShape = null;
    protected ArrayList<PVector> recordedVertices = null;
    protected ArrayList<float[]> recordedColors = null;
    protected ArrayList<PVector> recordedNormals = null;
    protected ArrayList<PVector>[] recordedTexCoords = null;
    protected ArrayList<PShape3D> recordedChildren = null;
    protected ArrayList<Short> recordedIndices = null;
    protected PTexture texture;
    protected int[] texCrop;
    protected boolean clearColorBuffer;
    protected boolean clearColorBuffer0;
    protected IntBuffer pixelBuffer;
    protected IntBuffer getsetBuffer;
    protected PTexture getsetTexture;
    protected DrawingState drawState;
    protected float[] colorFloats;
    protected int[] viewport = new int[]{0, 0, 0, 0};
    public static boolean BIG_ENDIAN;
    protected static final int SIZEOF_SHORT = 2;
    protected static final int SIZEOF_INT = 4;
    protected static final int SIZEOF_FLOAT = 4;

    public PGraphicsAndroid3D() {
        this.renderer = new A3DRenderer();
    }

    public void setPrimary(boolean bl) {
        super.setPrimary(bl);
        this.format = 2;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
        this.vertexCheck();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.sizeChanged = true;
    }

    protected void allocate() {
        super.allocate();
        if (!this.matricesAllocated) {
            this.glprojection = new float[16];
            this.glmodelview = new float[16];
            this.glmodelviewInv = new float[16];
            this.pcamera = new float[16];
            this.pcameraInv = new float[16];
            this.pprojection = new float[16];
            this.gltemp = new float[16];
            this.projection = new PMatrix3D();
            this.modelview = new PMatrix3D();
            this.modelviewInv = new PMatrix3D();
            this.camera = new PMatrix3D();
            this.cameraInv = new PMatrix3D();
            this.matricesAllocated = true;
        }
        if (!this.lightsAllocated) {
            this.lightType = new int[8];
            this.lightPosition = new float[8][4];
            this.lightNormal = new float[8][4];
            this.lightDiffuse = new float[8][4];
            this.lightSpecular = new float[8][4];
            this.lightFalloffConstant = new float[8];
            this.lightFalloffLinear = new float[8];
            this.lightFalloffQuadratic = new float[8];
            this.lightSpotAngle = new float[8];
            this.lightSpotAngleCos = new float[8];
            this.lightSpotConcentration = new float[8];
            this.currentLightSpecular = new float[4];
            this.lightsAllocated = true;
        }
        if (!this.geometryAllocated) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(6144);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.vertexBuffer = byteBuffer.asIntBuffer();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(8192);
            byteBuffer2.order(ByteOrder.nativeOrder());
            this.colorBuffer = byteBuffer2.asIntBuffer();
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(6144);
            byteBuffer3.order(ByteOrder.nativeOrder());
            this.normalBuffer = byteBuffer3.asIntBuffer();
            this.texCoordBuffer = new IntBuffer[2];
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(4096);
            byteBuffer4.order(ByteOrder.nativeOrder());
            this.texCoordBuffer[0] = byteBuffer4.asIntBuffer();
            this.vertexArray = new int[1536];
            this.colorArray = new int[2048];
            this.normalArray = new int[1536];
            this.texCoordArray = new int[1][1024];
            this.numTexBuffers = 1;
            this.geometryAllocated = true;
        }
        if (this.primarySurface) {
            this.a3d = this;
        } else {
            if (this.a3d == null) {
                this.registerPGLObject(this);
            }
            this.a3d = (PGraphicsAndroid3D)this.parent.g;
        }
    }

    public void delete() {
        if (this.primarySurface) {
            PGraphics.showWarning("You cannot delete the primary rendering surface!");
        } else {
            super.delete();
            if (this.offscreenFramebuffer != null) {
                this.offscreenFramebuffer.delete();
            }
            this.unregisterPGLObject(this);
        }
    }

    public void dispose() {
        super.dispose();
        this.deleteAllGLResources();
    }

    protected void allocatePGLObjects() {
        PConstants pConstants;
        int n;
        Object[] objectArray;
        if (!pGraphicsAndroid3DObjects.isEmpty()) {
            objectArray = pGraphicsAndroid3DObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PGraphicsAndroid3D)objectArray[n];
                ((PGraphicsAndroid3D)pConstants).allocate();
            }
        }
        if (!pTextureObjects.isEmpty()) {
            objectArray = pTextureObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PTexture)objectArray[n];
                ((PTexture)pConstants).allocate();
            }
        }
        if (!pFramebufferObjects.isEmpty()) {
            objectArray = pFramebufferObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PFramebuffer)objectArray[n];
                ((PFramebuffer)pConstants).allocate();
            }
        }
        if (!pShape3DObjects.isEmpty()) {
            objectArray = pShape3DObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PShape3D)objectArray[n];
                ((PShape3D)pConstants).allocate();
            }
        }
        if (!pFontTextureObjects.isEmpty()) {
            objectArray = pFontTextureObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PFontTexture)objectArray[n];
                ((PFontTexture)pConstants).allocate();
            }
        }
    }

    protected void backupPGLObjects() {
        PConstants pConstants;
        int n;
        Object[] objectArray;
        if (!pTextureObjects.isEmpty()) {
            objectArray = pTextureObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PTexture)objectArray[n];
                ((PTexture)pConstants).backup();
            }
        }
        if (!pFramebufferObjects.isEmpty()) {
            objectArray = pFramebufferObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PFramebuffer)objectArray[n];
                ((PFramebuffer)pConstants).backup();
            }
        }
        if (!pShape3DObjects.isEmpty()) {
            objectArray = pShape3DObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PShape3D)objectArray[n];
                ((PShape3D)pConstants).backup();
            }
        }
        if (!pFontTextureObjects.isEmpty()) {
            objectArray = pFontTextureObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PFontTexture)objectArray[n];
                ((PFontTexture)pConstants).backup();
            }
        }
    }

    protected void clearPGLFramebuffers() {
        if (!pFramebufferObjects.isEmpty()) {
            Object[] objectArray = pFramebufferObjects.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                PFramebuffer pFramebuffer = (PFramebuffer)objectArray[i];
                pFramebuffer.clear();
            }
        }
    }

    protected void restorePGLObjects() {
        PConstants pConstants;
        int n;
        Object[] objectArray;
        if (!pTextureObjects.isEmpty()) {
            objectArray = pTextureObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PTexture)objectArray[n];
                ((PTexture)pConstants).restore();
            }
        }
        if (!pFramebufferObjects.isEmpty()) {
            objectArray = pFramebufferObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PFramebuffer)objectArray[n];
                ((PFramebuffer)pConstants).restore();
            }
        }
        if (!pShape3DObjects.isEmpty()) {
            objectArray = pShape3DObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PShape3D)objectArray[n];
                ((PShape3D)pConstants).restore();
            }
        }
        if (!pFontTextureObjects.isEmpty()) {
            objectArray = pFontTextureObjects.toArray();
            for (n = 0; n < objectArray.length; ++n) {
                pConstants = (PFontTexture)objectArray[n];
                ((PFontTexture)pConstants).restore();
            }
        }
    }

    protected void registerPGLObject(Object object) {
        if (object instanceof PGraphicsAndroid3D) {
            pGraphicsAndroid3DObjects.add((PGraphicsAndroid3D)object);
        } else if (object instanceof PTexture) {
            pTextureObjects.add((PTexture)object);
        } else if (object instanceof PFramebuffer) {
            pFramebufferObjects.add((PFramebuffer)object);
        } else if (object instanceof PShape3D) {
            pShape3DObjects.add((PShape3D)object);
        } else if (object instanceof PFontTexture) {
            pFontTextureObjects.add((PFontTexture)object);
        }
    }

    protected void unregisterPGLObject(Object object) {
        if (object instanceof PGraphicsAndroid3D) {
            pGraphicsAndroid3DObjects.remove(object);
        } else if (object instanceof PTexture) {
            pTextureObjects.remove(object);
        } else if (object instanceof PFramebuffer) {
            pFramebufferObjects.remove(object);
        } else if (object instanceof PShape3D) {
            pShape3DObjects.remove(object);
        } else if (object instanceof PFontTexture) {
            pFontTextureObjects.remove(object);
        }
    }

    protected int createGLResource(int n) {
        int n2 = 0;
        if (n == 0) {
            int[] nArray = new int[1];
            this.gl.glGenTextures(1, nArray, 0);
            n2 = nArray[0];
            glTextureObjects.add(n2);
        } else if (n == 1) {
            int[] nArray = new int[1];
            this.gl11.glGenBuffers(1, nArray, 0);
            n2 = nArray[0];
            glVertexBuffers.add(n2);
        } else if (n == 2) {
            int[] nArray = new int[1];
            this.gl11xp.glGenFramebuffersOES(1, nArray, 0);
            n2 = nArray[0];
            glFrameBuffers.add(n2);
        } else if (n == 3) {
            int[] nArray = new int[1];
            this.gl11xp.glGenRenderbuffersOES(1, nArray, 0);
            n2 = nArray[0];
            glRenderBuffers.add(n2);
        }
        return n2;
    }

    protected void deleteGLResource(int n, int n2) {
        if (n2 == 0) {
            if (glTextureObjects.contains(n)) {
                int[] nArray = new int[]{n};
                this.gl.glDeleteTextures(1, nArray, 0);
                glTextureObjects.remove(n);
            }
        } else if (n2 == 1) {
            if (glVertexBuffers.contains(n)) {
                int[] nArray = new int[]{n};
                this.gl11.glDeleteBuffers(1, nArray, 0);
                glVertexBuffers.remove(n);
            }
        } else if (n2 == 2) {
            if (glFrameBuffers.contains(n)) {
                int[] nArray = new int[]{n};
                this.gl11xp.glDeleteFramebuffersOES(1, nArray, 0);
                glFrameBuffers.remove(n);
            }
        } else if (n2 == 3 && glRenderBuffers.contains(n)) {
            int[] nArray = new int[]{n};
            this.gl11xp.glDeleteRenderbuffersOES(1, nArray, 0);
            glRenderBuffers.remove(n);
        }
    }

    protected void deleteAllGLResources() {
        int[] nArray;
        int n;
        int n2;
        Object[] objectArray;
        super.delete();
        if (!glTextureObjects.isEmpty()) {
            objectArray = glTextureObjects.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                this.gl.glDeleteTextures(1, nArray, 0);
            }
            glTextureObjects.clear();
        }
        if (!glVertexBuffers.isEmpty()) {
            objectArray = glVertexBuffers.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                this.gl11.glDeleteBuffers(1, nArray, 0);
            }
            glVertexBuffers.clear();
        }
        if (!glFrameBuffers.isEmpty()) {
            objectArray = glFrameBuffers.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                this.gl11xp.glDeleteFramebuffersOES(1, nArray, 0);
            }
            glFrameBuffers.clear();
        }
        if (!glRenderBuffers.isEmpty()) {
            objectArray = glRenderBuffers.toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = (Integer)objectArray[n2];
                nArray = new int[]{n};
                this.gl11xp.glDeleteRenderbuffersOES(1, nArray, 0);
            }
            glRenderBuffers.clear();
        }
    }

    public void pushFramebuffer() {
        fbStack.push(currentFramebuffer);
    }

    public void setFramebuffer(PFramebuffer pFramebuffer) {
        currentFramebuffer = pFramebuffer;
        currentFramebuffer.bind();
    }

    public void popFramebuffer() {
        try {
            currentFramebuffer.finish();
            currentFramebuffer = fbStack.pop();
            currentFramebuffer.bind();
        }
        catch (EmptyStackException emptyStackException) {
            PGraphics.showWarning("A3D: Empty framebuffer stack");
        }
    }

    public void setSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.holder = surfaceHolder;
    }

    public SurfaceHolder GetSurfaceHolder() {
        return this.holder;
    }

    public void requestDraw() {
        if (this.parent.looping) {
            ((GLSurfaceView)this.parent.surfaceView).requestRender();
        }
    }

    public void beginDraw() {
        if (!this.primarySurface) {
            this.a3d.saveGLState();
            this.gl = this.a3d.gl;
            this.gl11 = this.a3d.gl11;
            this.gl11x = this.a3d.gl11x;
            this.gl11xp = this.a3d.gl11xp;
            this.a3d.disableLights();
        }
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        this.report("top beginDraw()");
        this.vertexBuffer.rewind();
        this.colorBuffer.rewind();
        this.normalBuffer.rewind();
        for (int i = 0; i < this.numTexBuffers; ++i) {
            this.texCoordBuffer[i].rewind();
        }
        if (this.USE_GEO_BUFFER) {
            if (this.geoBuffer == null) {
                this.geoBuffer = new GeometryBuffer();
            }
            if (this.GEO_BUFFER_ACCUM_ALL) {
                this.geoBuffer.init(9);
            }
            this.GEO_BUFFER_COUNT = 0;
            this.GEO_BUFFER_SIZE = 0.0f;
        }
        this.noTexture();
        this.screenBlend(1);
        this.textureBlend(1);
        if (this.hints[4]) {
            this.gl.glDisable(2929);
        } else {
            this.gl.glEnable(2929);
        }
        this.gl.glDepthFunc(515);
        if (this.hints[8]) {
            this.gl.glDepthMask(false);
        } else {
            this.gl.glDepthMask(true);
        }
        this.gl.glGetIntegerv(2978, this.viewport, 0);
        this.gl.glViewport(0, 0, this.width, this.height);
        if (this.sizeChanged) {
            this.camera();
            this.perspective();
            this.sizeChanged = false;
        } else {
            this.restoreCamera();
            this.restoreProjection();
        }
        this.noLights();
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.gl.glFrontFace(2304);
        this.setSurfaceParams();
        this.shapeFirst = 0;
        this.normalZ = 0.0f;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        if (this.primarySurface) {
            this.initPrimary();
        } else {
            this.initOffscreen();
        }
        this.clearColorBuffer0 = this.clearColorBuffer;
        this.report("bot beginDraw()");
    }

    public void endDraw() {
        this.report("top endDraw()");
        this.gl.glViewport(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
        if (this.USE_GEO_BUFFER && this.GEO_BUFFER_ACCUM_ALL && this.geoBuffer != null && 0 < this.geoBuffer.vertCount) {
            this.geoBuffer.pre();
            this.geoBuffer.render();
            this.geoBuffer.post();
        }
        if (this.primarySurface) {
            if (!this.clearColorBuffer0) {
                if (fboSupported) {
                    if (this.offscreenFramebuffer != null) {
                        this.popFramebuffer();
                        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                        this.gl.glClear(16640);
                        this.drawOffscreenTexture(this.offscreenIndex);
                        this.swapOffscreenIndex();
                    }
                } else if (this.texture != null) {
                    this.copyFrameToTexture();
                }
            }
            this.gl.glFlush();
        } else {
            if (this.offscreenFramebuffer != null) {
                this.popFramebuffer();
                this.swapOffscreenIndex();
            }
            this.a3d.restoreGLState();
        }
        this.report("bot endDraw()");
    }

    public GL10 beginGL() {
        this.saveGLState();
        return this.gl;
    }

    public void endGL() {
        this.restoreGLState();
    }

    public void allocateGL() {
        this.allocatePGLObjects();
    }

    public void backupGL() {
        this.backupPGLObjects();
    }

    public void restoreGL() {
        this.clearPGLFramebuffers();
        this.restorePGLObjects();
    }

    protected void saveGLState() {
        this.saveGLMatrices();
    }

    protected void restoreGLState() {
        this.gl.glViewport(0, 0, this.width, this.height);
        this.restoreGLMatrices();
        if (this.hints[4]) {
            this.gl.glDisable(2929);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(256);
        } else {
            this.gl.glEnable(2929);
        }
        if (this.hints[8]) {
            this.gl.glDepthMask(false);
        } else {
            this.gl.glDepthMask(true);
        }
        this.screenBlend(this.screenBlendMode);
        if (this.fill) {
            this.calcR = this.fillR;
            this.calcG = this.fillG;
            this.calcB = this.fillB;
            this.calcA = this.fillA;
            this.fillFromCalc();
        }
        this.calcR = this.ambientR;
        this.calcG = this.ambientG;
        this.calcB = this.ambientB;
        this.ambientFromCalc();
        this.calcR = this.specularR;
        this.calcG = this.specularG;
        this.calcB = this.specularB;
        this.specularFromCalc();
        this.shininess(this.shininess);
        this.calcR = this.emissiveR;
        this.calcG = this.emissiveG;
        this.calcB = this.emissiveB;
        this.emissiveFromCalc();
        if (this.lights) {
            this.lights();
            for (int i = 0; i < this.lightCount; ++i) {
                this.lightEnable(i);
                if (this.lightType[i] == 0) {
                    this.lightEnable(i);
                    this.lightAmbient(i);
                    this.lightPosition(i);
                    this.lightFalloff(i);
                    this.lightNoSpot(i);
                    this.lightNoDiffuse(i);
                    this.lightNoSpecular(i);
                    continue;
                }
                if (this.lightType[i] == 1) {
                    this.lightEnable(i);
                    this.lightNoAmbient(i);
                    this.lightDirection(i);
                    this.lightDiffuse(i);
                    this.lightSpecular(i);
                    this.lightFalloff(i);
                    this.lightNoSpot(i);
                    continue;
                }
                if (this.lightType[i] == 2) {
                    this.lightEnable(i);
                    this.lightNoAmbient(i);
                    this.lightPosition(i);
                    this.lightDiffuse(i);
                    this.lightSpecular(i);
                    this.lightFalloff(i);
                    this.lightNoSpot(i);
                    continue;
                }
                if (this.lightType[i] != 3) continue;
                this.lightEnable(i);
                this.lightNoAmbient(i);
                this.lightPosition(i);
                this.lightDirection(i);
                this.lightDiffuse(i);
                this.lightSpecular(i);
                this.lightFalloff(i);
                this.lightSpotAngle(i);
                this.lightSpotConcentration(i);
            }
        } else {
            this.noLights();
        }
        this.gl.glFrontFace(2304);
        this.gl.glDepthFunc(515);
        this.setSurfaceParams();
    }

    protected void saveDrawingState() {
        if (this.drawState == null) {
            this.drawState = new DrawingState();
        }
        this.drawState.save();
    }

    protected void restoreDrawingState() {
        this.drawState.restore();
    }

    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.scalingDuringCamManip = false;
        this.clearColorBuffer = false;
        if (fbStack == null) {
            fbStack = new Stack();
            screenFramebuffer = new PFramebuffer(this.parent, this.width, this.height, true);
            this.setFramebuffer(screenFramebuffer);
        }
        if (usingGLMatrixStack) {
            if (modelviewStack == null) {
                modelviewStack = new GLMatrixStack();
            }
            if (projectionStack == null) {
                projectionStack = new GLMatrixStack();
            }
        }
        this.textureMode(2);
    }

    public void hint(int n) {
        super.hint(n);
        if (n == 4) {
            this.gl.glDisable(2929);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(256);
        } else if (n == -4) {
            this.gl.glEnable(2929);
        } else if (n == 8) {
            this.gl.glDepthMask(false);
        } else if (n == -8) {
            this.gl.glDepthMask(true);
        } else if (n == 1 || n == -1 || n == 2) {
            // empty if block
        }
    }

    public PShape3D beginRecord() {
        if (this.recordingShape) {
            System.err.println("A3D: Already recording.");
            return this.recordedShape;
        }
        if (this.USE_GEO_BUFFER) {
            if (this.geoBuffer != null && 0 < this.geoBuffer.vertCount) {
                this.geoBuffer.pre();
                this.geoBuffer.render();
                this.geoBuffer.post();
            }
            if (this.geoBuffer == null) {
                this.geoBuffer = new GeometryBuffer();
            }
        }
        this.recordedShape = new PShape3D(this.parent);
        this.beginShapeRecorderImpl();
        return this.recordedShape;
    }

    public void beginRecord(PShape3D pShape3D) {
        if (this.recordingShape) {
            System.err.println("A3D: Already recording.");
        } else {
            if (this.USE_GEO_BUFFER) {
                if (this.geoBuffer != null && 0 < this.geoBuffer.vertCount) {
                    this.geoBuffer.pre();
                    this.geoBuffer.render();
                    this.geoBuffer.post();
                }
                if (this.geoBuffer == null) {
                    this.geoBuffer = new GeometryBuffer();
                }
            }
            this.recordedShape = pShape3D;
            this.beginShapeRecorderImpl();
        }
    }

    public boolean isRecordingShape() {
        return this.recordingShape;
    }

    protected void beginShapeRecorder() {
        this.beginShapeRecorder(20);
    }

    protected void beginShapeRecorder(int n) {
        this.beginShapeRecorderImpl();
        this.beginShape(n);
    }

    protected void beginShapesRecorder() {
        if (this.recordingShape) {
            System.err.println("Already recording shapes. Recording cannot be nested");
        } else {
            this.beginShapeRecorderImpl();
        }
    }

    protected void beginShapeRecorderImpl() {
        this.recordingShape = true;
        this.recShapeName = "";
        if (this.recordedVertices == null) {
            this.recordedVertices = new ArrayList(this.vertexBuffer.capacity() / 3);
        } else {
            this.recordedVertices.ensureCapacity(this.vertexBuffer.capacity() / 3);
        }
        if (this.recordedColors == null) {
            this.recordedColors = new ArrayList(this.colorBuffer.capacity() / 4);
        } else {
            this.recordedColors.ensureCapacity(this.colorBuffer.capacity() / 4);
        }
        if (this.recordedNormals == null) {
            this.recordedNormals = new ArrayList(this.normalBuffer.capacity() / 3);
        } else {
            this.recordedNormals.ensureCapacity(this.normalBuffer.capacity() / 3);
        }
        int n = this.texCoordBuffer[0].capacity() / 2;
        if (this.recordedTexCoords == null) {
            this.recordedTexCoords = new ArrayList[2];
            for (int i = 0; i < maxTextureUnits; ++i) {
                this.recordedTexCoords[i] = new ArrayList(n);
            }
        } else {
            for (int i = 0; i < maxTextureUnits; ++i) {
                this.recordedTexCoords[i].ensureCapacity(n);
            }
        }
        if (this.USE_GEO_BUFFER) {
            if (this.recordedIndices == null) {
                this.recordedIndices = new ArrayList(this.vertexBuffer.capacity() / 3);
            } else {
                this.recordedIndices.ensureCapacity(this.vertexBuffer.capacity() / 3);
            }
        } else {
            this.recordedIndices = null;
        }
        this.recTexturesCount = 0;
        this.recordedChildren = new ArrayList(PApplet.max(64, 64));
    }

    public void beginShape(int n) {
        this.shape = n;
        if (this.hints[5]) {
            this.shapeFirst = this.vertexCount;
            this.shapeLast = 0;
        } else {
            this.vertexCount = 0;
            this.pathCount = 0;
            this.faceCount = 0;
            this.pointCount = 0;
            this.lineCount = 0;
            this.triangleCount = 0;
        }
        this.shapeTextures = 0;
        this.noTexture();
    }

    public void mergeShapes(boolean bl) {
        this.mergeRecShapes = bl;
    }

    public void shapeName(String string) {
        this.recShapeName = string;
    }

    public void texture(PImage pImage) {
        super.texture(pImage);
        this.textureImages[0] = pImage;
        Arrays.fill(this.textureImages, 1, maxTextureUnits, null);
        this.numTextures = 1;
        ++this.shapeTextures;
    }

    public void texture(PImage ... pImageArray) {
        int n = pImageArray.length;
        if (n <= maxTextureUnits) {
            super.texture(pImageArray[0]);
            PApplet.arrayCopy(pImageArray, 0, this.textureImages, 0, n);
            Arrays.fill(this.textureImages, n, maxTextureUnits, null);
            this.numTextures = n;
            if (this.numTexBuffers < n) {
                this.addTexBuffers(n - this.numTexBuffers);
            }
            this.shapeTextures += n;
        } else {
            System.err.println("A3D: insufficient texture units.");
        }
    }

    public void noTexture() {
        super.noTexture();
        this.numTextures = 0;
        this.clearTextures();
        this.clearTextures0();
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.vertexTexture(f3, f4, 0);
        this.vertex(f, f2);
        int n = this.vertexCount - 1;
        for (int i = 0; i < this.numTextures; ++i) {
            this.vertexTex[n][i] = this.textureImages[i];
            this.vertexU[n][i] = this.texturesU[0];
            this.vertexV[n][i] = this.texturesV[0];
        }
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.vertexTexture(f4, f5, 0);
        this.vertex(f, f2, f3);
        int n = this.vertexCount - 1;
        for (int i = 0; i < this.numTextures; ++i) {
            this.vertexTex[n][i] = this.textureImages[i];
            this.vertexU[n][i] = this.texturesU[0];
            this.vertexV[n][i] = this.texturesV[0];
        }
    }

    public void vertex(float ... fArray) {
        int n = fArray.length;
        if (n < 2) {
            System.err.println("A3D: call vertex() with at least 2 parameters.");
            return;
        }
        int n2 = n % 2 == 0 ? 2 : 3;
        int n3 = (n - n2) / 2;
        if (n3 <= maxTextureUnits) {
            for (int i = 0; i < n3; ++i) {
                float f = fArray[n2 + 2 * i];
                float f2 = fArray[n2 + 2 * i + 1];
                this.vertexTexture(f, f2, i);
            }
            if (n2 == 2) {
                this.vertex(fArray[0], fArray[1]);
            } else {
                this.vertex(fArray[0], fArray[1], fArray[2]);
            }
            this.setTextureData(n3);
        } else {
            System.err.println("A3D: insufficient texture units.");
        }
    }

    protected void vertexCheck() {
        super.vertexCheck();
        if (this.vertexCount == this.vertexTex.length) {
            float[][] fArray = new float[this.vertexCount << 1][this.numTexBuffers];
            float[][] fArray2 = new float[this.vertexCount << 1][this.numTexBuffers];
            PImage[][] pImageArray = new PImage[this.vertexCount << 1][this.numTexBuffers];
            for (int i = 0; i < this.vertexCount; ++i) {
                PApplet.arrayCopy(this.vertexU[i], 0, fArray[i], 0, this.numTexBuffers);
                PApplet.arrayCopy(this.vertexV[i], 0, fArray2[i], 0, this.numTexBuffers);
                PApplet.arrayCopy(this.vertexTex[i], 0, pImageArray[i], 0, this.numTexBuffers);
            }
            this.vertexU = fArray;
            this.vertexV = fArray2;
            this.vertexTex = pImageArray;
        }
    }

    protected void clearTextures() {
        Arrays.fill(this.textureImages, null);
    }

    protected void clearTextures0() {
        Arrays.fill(this.textureImages0, null);
    }

    protected boolean diffFromTextures0(PImage[] pImageArray) {
        if (1 < this.numTextures) {
            for (int i = 0; i < this.numTextures; ++i) {
                if (this.textureImages0[i] == pImageArray[i]) continue;
                return true;
            }
            return false;
        }
        if (0 < this.numTextures) {
            return this.textureImages0[0] != pImageArray[0];
        }
        return this.textureImages0[0] != null;
    }

    protected void setTextures0(PImage[] pImageArray) {
        if (1 < this.numTextures) {
            PApplet.arrayCopy(pImageArray, 0, this.textureImages0, 0, this.numTextures);
        } else {
            this.textureImages0[0] = 0 < this.numTextures ? pImageArray[0] : null;
        }
    }

    protected void vertexTexture(float f, float f2, int n) {
        if (n == 0) {
            super.vertexTexture(f, f2);
            this.texturesU[0] = this.textureU;
            this.texturesV[0] = this.textureV;
        } else {
            PImage pImage = this.textureImages[n];
            if (pImage == null) {
                throw new RuntimeException("You must first call texture() before using u and v coordinates with vertex()");
            }
            if (this.textureMode == 2) {
                f /= (float)pImage.width;
                f2 /= (float)pImage.height;
            }
            this.texturesU[n] = f;
            this.texturesV[n] = f2;
        }
    }

    protected void addTexBuffers(int n) {
        Object object;
        int n2 = this.texCoordBuffer[this.numTexBuffers - 1].capacity();
        for (int i = 0; i < n; ++i) {
            object = ByteBuffer.allocateDirect(n2 * 4);
            ((ByteBuffer)object).order(ByteOrder.nativeOrder());
            this.texCoordBuffer[this.numTexBuffers + i] = ((ByteBuffer)object).asIntBuffer();
        }
        this.texCoordArray = new int[this.numTexBuffers + n][n2];
        n2 = this.vertexTex.length;
        float[][] fArray = new float[n2][this.numTexBuffers + n];
        object = new float[n2][this.numTexBuffers + n];
        PImage[][] pImageArray = new PImage[n2][this.numTexBuffers + n];
        for (int i = 0; i < n2; ++i) {
            PApplet.arrayCopy(this.vertexU[i], 0, fArray[i], 0, this.numTexBuffers);
            PApplet.arrayCopy(this.vertexV[i], 0, object[i], 0, this.numTexBuffers);
            PApplet.arrayCopy(this.vertexTex[i], 0, pImageArray[i], 0, this.numTexBuffers);
        }
        this.vertexU = fArray;
        this.vertexV = (float[][])object;
        this.vertexTex = pImageArray;
        this.numTexBuffers += n;
        this.gl.glActiveTexture(33984 + this.numTexBuffers - 1);
    }

    protected void setTextureData(int n) {
        if (this.numTexBuffers < n) {
            this.addTexBuffers(n - this.numTexBuffers);
        }
        int n2 = this.vertexCount - 1;
        PApplet.arrayCopy(this.texturesU, 0, this.vertexU[n2], 0, n);
        PApplet.arrayCopy(this.texturesV, 0, this.vertexV[n2], 0, n);
        PApplet.arrayCopy(this.textureImages, 0, this.vertexTex[n2], 0, n);
    }

    public void endShape(int n) {
        this.shapeLast = this.vertexCount;
        if (this.vertexCount == 0) {
            this.shape = 0;
            return;
        }
        if (this.stroke) {
            this.endShapeStroke(n);
        }
        if (this.fill || 0 < this.shapeTextures) {
            this.endShapeFill();
        }
        if (!this.hints[5]) {
            if (this.fill || 0 < this.shapeTextures) {
                this.renderTriangles(0, this.faceCount);
                if (this.raw != null) {
                    // empty if block
                }
                this.vertexCount = 0;
                this.triangleCount = 0;
                this.shapeTextures = 0;
            }
            if (this.stroke) {
                if (this.pointCount > 0) {
                    this.renderPoints(0, this.pointCount);
                    if (this.raw != null) {
                        // empty if block
                    }
                    this.pointCount = 0;
                }
                this.renderLines(0, this.pathCount);
                if (this.raw != null) {
                    // empty if block
                }
                this.lineCount = 0;
            }
            this.pathCount = 0;
            this.faceCount = 0;
        }
        this.shape = 0;
    }

    protected void endShapeStroke(int n) {
        switch (this.shape) {
            case 2: {
                int n2 = this.shapeLast;
                for (int i = this.shapeFirst; i < n2; ++i) {
                    this.addPoint(i);
                }
                break;
            }
            case 4: {
                int n3 = this.lineCount;
                int n4 = this.shapeLast - 1;
                if (this.shape != 4) {
                    this.addLineBreak();
                }
                for (int i = this.shapeFirst; i < n4; i += 2) {
                    if (this.shape == 4) {
                        this.addLineBreak();
                    }
                    this.addLine(i, i + 1);
                }
                if (n != 2) break;
                this.addLine(n4, this.lines[n3][0]);
                break;
            }
            case 9: {
                for (int i = this.shapeFirst; i < this.shapeLast - 2; i += 3) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 0);
                }
                break;
            }
            case 10: {
                int n5;
                int n6 = this.shapeLast - 1;
                this.addLineBreak();
                for (n5 = this.shapeFirst; n5 < n6; ++n5) {
                    this.addLine(n5, n5 + 1);
                }
                n6 = this.shapeLast - 2;
                for (n5 = this.shapeFirst; n5 < n6; ++n5) {
                    this.addLineBreak();
                    this.addLine(n5, n5 + 2);
                }
                break;
            }
            case 11: {
                int n7;
                for (n7 = this.shapeFirst + 1; n7 < this.shapeLast; ++n7) {
                    this.addLineBreak();
                    this.addLine(this.shapeFirst, n7);
                }
                this.addLineBreak();
                for (n7 = this.shapeFirst + 1; n7 < this.shapeLast - 1; ++n7) {
                    this.addLine(n7, n7 + 1);
                }
                this.addLine(this.shapeLast - 1, this.shapeFirst + 1);
                break;
            }
            case 16: {
                for (int i = this.shapeFirst; i < this.shapeLast; i += 4) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 1);
                    this.addLine(i + 1, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 0);
                }
                break;
            }
            case 17: {
                for (int i = this.shapeFirst; i < this.shapeLast - 3; i += 2) {
                    this.addLineBreak();
                    this.addLine(i + 0, i + 2);
                    this.addLine(i + 2, i + 3);
                    this.addLine(i + 3, i + 1);
                    this.addLine(i + 1, i + 0);
                }
                break;
            }
            case 20: {
                int n8 = this.shapeLast - 1;
                this.addLineBreak();
                for (int i = this.shapeFirst; i < n8; ++i) {
                    this.addLine(i, i + 1);
                }
                if (n != 2) break;
                this.addLine(n8, this.shapeFirst);
            }
        }
    }

    protected void endShapeFill() {
        switch (this.shape) {
            case 11: {
                int n = this.shapeLast - 1;
                for (int i = this.shapeFirst + 1; i < n; ++i) {
                    this.addTriangle(this.shapeFirst, i, i + 1);
                }
                break;
            }
            case 9: {
                int n = this.shapeLast - 2;
                for (int i = this.shapeFirst; i < n; i += 3) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                        continue;
                    }
                    this.addTriangle(i, i + 1, i + 2);
                }
                break;
            }
            case 10: {
                int n = this.shapeLast - 2;
                for (int i = this.shapeFirst; i < n; ++i) {
                    if (i % 2 == 0) {
                        this.addTriangle(i, i + 2, i + 1);
                        continue;
                    }
                    this.addTriangle(i, i + 1, i + 2);
                }
                break;
            }
            case 16: {
                int n = this.vertexCount - 3;
                for (int i = this.shapeFirst; i < n; i += 4) {
                    this.addTriangle(i, i + 1, i + 2);
                    this.addTriangle(i, i + 2, i + 3);
                }
                break;
            }
            case 17: {
                int n = this.vertexCount - 3;
                for (int i = this.shapeFirst; i < n; i += 2) {
                    this.addTriangle(i + 0, i + 2, i + 1);
                    this.addTriangle(i + 2, i + 3, i + 1);
                }
                break;
            }
            case 20: {
                this.addPolygonTriangles();
            }
        }
    }

    public void endRecord() {
        if (this.recordingShape) {
            if (this.USE_GEO_BUFFER && 0 < this.geoBuffer.vertCount) {
                this.geoBuffer.record();
                this.geoBuffer.init(9);
            }
            if (0 < this.recordedVertices.size()) {
                this.recordedShape.initShape(this.recordedVertices.size());
            }
            this.endShapeRecorderImpl(this.recordedShape);
            this.recordedShape = null;
        } else {
            System.err.println("A3D: Start recording with beginRecord().");
        }
    }

    protected PShape3D endShapeRecorder() {
        return this.endShapeRecorder(1);
    }

    protected PShape3D endShapeRecorder(int n) {
        this.endShape(n);
        PShape3D pShape3D = null;
        if (0 < this.recordedVertices.size()) {
            pShape3D = new PShape3D(this.parent, this.recordedVertices.size());
        }
        this.endShapeRecorderImpl(pShape3D);
        return pShape3D;
    }

    public PShape3D endShapesRecorder() {
        if (this.recordingShape) {
            PShape3D pShape3D = null;
            if (0 < this.recordedVertices.size()) {
                pShape3D = new PShape3D(this.parent, this.recordedVertices.size());
            }
            this.endShapeRecorderImpl(pShape3D);
            return pShape3D;
        }
        System.err.println("A3D: Start recording with beginShapesRecorder().");
        return null;
    }

    protected void endShapeRecorderImpl(PShape3D pShape3D) {
        this.recordingShape = false;
        if (0 < this.recordedVertices.size() && pShape3D != null) {
            int n;
            pShape3D.setVertices(this.recordedVertices);
            pShape3D.setColors(this.recordedColors);
            pShape3D.setNormals(this.recordedNormals);
            if (this.recordedIndices != null) {
                pShape3D.initIndices(this.recordedIndices.size());
                pShape3D.setIndices(this.recordedIndices);
            }
            pShape3D.optimizeChildren(this.recordedChildren);
            pShape3D.setChildren(this.recordedChildren);
            for (n = 0; n < this.recTexturesCount; ++n) {
                pShape3D.setTexcoords(n, this.recordedTexCoords[n]);
            }
            this.recordedVertices.clear();
            this.recordedColors.clear();
            this.recordedNormals.clear();
            for (n = 0; n < maxTextureUnits; ++n) {
                this.recordedTexCoords[n].clear();
            }
            if (this.recordedIndices != null) {
                this.recordedIndices.clear();
            }
            this.recordedChildren.clear();
        }
    }

    public void shape(PShape pShape, float f, float f2, float f3) {
        if (pShape.isVisible()) {
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - pShape.getWidth() / 2.0f, f2 - pShape.getHeight() / 2.0f, f3 - pShape.getDepth() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(f, f2, f3);
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    public void shape(PShape pShape, float f, float f2, float f3, float f4, float f5, float f6) {
        if (pShape.isVisible()) {
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - f4 / 2.0f, f2 - f5 / 2.0f, f3 - f6 / 2.0f);
                this.scale(f4 / pShape.getWidth(), f5 / pShape.getHeight(), f6 / pShape.getDepth());
            } else if (this.shapeMode == 0) {
                this.translate(f, f2, f3);
                this.scale(f4 / pShape.getWidth(), f5 / pShape.getHeight(), f6 / pShape.getDepth());
            } else if (this.shapeMode == 1) {
                this.translate(f, f2, f3);
                this.scale((f4 -= f) / pShape.getWidth(), (f5 -= f2) / pShape.getHeight(), (f6 -= f3) / pShape.getDepth());
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    protected void addPoint(int n) {
        if (this.pointCount == this.points.length) {
            int[][] nArray = new int[this.pointCount << 1][1];
            System.arraycopy(this.points, 0, nArray, 0, this.pointCount);
            this.points = nArray;
        }
        this.points[this.pointCount][0] = n;
        ++this.pointCount;
    }

    protected void renderPoints(int n, int n2) {
        this.gl.glEnableClientState(32884);
        this.gl.glEnableClientState(32886);
        int n3 = 3 * (n2 - n);
        while (this.vertexBuffer.capacity() / 3 < n3) {
            this.expandBuffers();
        }
        float f = this.vertices[this.points[n][0]][17];
        if (f > 0.0f) {
            this.gl.glPointSize(f);
            this.vertexBuffer.position(0);
            this.colorBuffer.position(0);
            int n4 = 0;
            for (int i = n; i < n2; ++i) {
                float[] fArray = this.vertices[this.points[i][0]];
                this.vertexArray[3 * n4 + 0] = PGraphicsAndroid3D.toFixed32(fArray[0]);
                this.vertexArray[3 * n4 + 1] = PGraphicsAndroid3D.toFixed32(fArray[1]);
                this.vertexArray[3 * n4 + 2] = PGraphicsAndroid3D.toFixed32(fArray[2]);
                this.colorArray[4 * n4 + 0] = PGraphicsAndroid3D.toFixed32(fArray[13]);
                this.colorArray[4 * n4 + 1] = PGraphicsAndroid3D.toFixed32(fArray[14]);
                this.colorArray[4 * n4 + 2] = PGraphicsAndroid3D.toFixed32(fArray[15]);
                this.colorArray[4 * n4 + 3] = PGraphicsAndroid3D.toFixed32(fArray[16]);
                ++n4;
            }
            this.vertexBuffer.put(this.vertexArray);
            this.colorBuffer.put(this.colorArray);
            this.vertexBuffer.position(0);
            this.colorBuffer.position(0);
            this.gl.glVertexPointer(3, 5132, 0, (Buffer)this.vertexBuffer);
            this.gl.glColorPointer(4, 5132, 0, (Buffer)this.colorBuffer);
            this.gl.glDrawArrays(0, n, n2 - n);
        }
        this.gl.glDisableClientState(32884);
        this.gl.glDisableClientState(32886);
    }

    protected void addLineBreak() {
        if (this.pathCount == this.pathOffset.length) {
            this.pathOffset = PApplet.expand(this.pathOffset);
            this.pathLength = PApplet.expand(this.pathLength);
        }
        this.pathOffset[this.pathCount] = this.lineCount;
        this.pathLength[this.pathCount] = 0;
        ++this.pathCount;
    }

    protected void addLine(int n, int n2) {
        if (this.lineCount == this.lines.length) {
            int[][] nArray = new int[this.lineCount << 1][2];
            PApplet.arrayCopy(this.lines, 0, nArray, 0, this.lineCount);
            this.lines = nArray;
        }
        this.lines[this.lineCount][0] = n;
        this.lines[this.lineCount][1] = n2;
        ++this.lineCount;
        int n3 = this.pathCount - 1;
        this.pathLength[n3] = this.pathLength[n3] + 1;
    }

    protected void renderLines(int n, int n2) {
        this.report("render_lines in");
        float f = 0.0f;
        this.gl.glEnableClientState(32884);
        this.gl.glEnableClientState(32886);
        for (int i = n; i < n2; ++i) {
            Object object;
            int n3;
            int n4;
            int n5 = this.pathOffset[i];
            float f2 = this.vertices[this.lines[n5][0]][17];
            if (!(f2 > 0.0f)) continue;
            this.gl.glLineWidth(f2);
            if (f != f2 && this.recordingShape) {
                n4 = this.recordedVertices.size();
                n3 = n4 + this.pathLength[i];
                object = "shape";
                object = this.mergeRecShapes ? "shape" : (this.recShapeName.equals("") ? "shape:" + this.recordedChildren.size() : this.recShapeName);
                PShape3D pShape3D = (PShape3D)PShape3D.createChild((String)object, n4, n3, 50, f2, null);
                this.recordedChildren.add(pShape3D);
            }
            n4 = 3 * (this.pathLength[i] + 1);
            while (this.vertexBuffer.capacity() / 3 < n4) {
                this.expandBuffers();
            }
            this.vertexBuffer.position(0);
            this.colorBuffer.position(0);
            n3 = 0;
            object = this.vertices[this.lines[n5][0]];
            if (this.recordingShape) {
                this.recordedVertices.add(new PVector((float)object[0], (float)object[1], (float)object[2]));
                this.recordedColors.add(new float[]{(float)object[13], (float)object[14], (float)object[15], (float)object[16]});
                this.recordedNormals.add(new PVector(0.0f, 0.0f, 0.0f));
                for (int j = 0; j < maxTextureUnits; ++j) {
                    this.recordedTexCoords[j].add(new PVector(0.0f, 0.0f, 0.0f));
                }
            } else {
                this.vertexArray[3 * n3 + 0] = PGraphicsAndroid3D.toFixed32((float)object[0]);
                this.vertexArray[3 * n3 + 1] = PGraphicsAndroid3D.toFixed32((float)object[1]);
                this.vertexArray[3 * n3 + 2] = PGraphicsAndroid3D.toFixed32((float)object[2]);
                this.colorArray[4 * n3 + 0] = PGraphicsAndroid3D.toFixed32((float)object[13]);
                this.colorArray[4 * n3 + 1] = PGraphicsAndroid3D.toFixed32((float)object[14]);
                this.colorArray[4 * n3 + 2] = PGraphicsAndroid3D.toFixed32((float)object[15]);
                this.colorArray[4 * n3 + 3] = PGraphicsAndroid3D.toFixed32((float)object[16]);
                ++n3;
            }
            for (int j = 0; j < this.pathLength[i]; ++j) {
                float[] fArray = this.vertices[this.lines[n5][1]];
                if (this.recordingShape) {
                    this.recordedVertices.add(new PVector(fArray[0], fArray[1], fArray[2]));
                    this.recordedColors.add(new float[]{fArray[13], fArray[14], fArray[15], fArray[16]});
                    this.recordedNormals.add(new PVector(0.0f, 0.0f, 0.0f));
                    for (int k = 0; k < maxTextureUnits; ++k) {
                        this.recordedTexCoords[k].add(new PVector(0.0f, 0.0f, 0.0f));
                    }
                } else {
                    this.vertexArray[3 * n3 + 0] = PGraphicsAndroid3D.toFixed32(fArray[0]);
                    this.vertexArray[3 * n3 + 1] = PGraphicsAndroid3D.toFixed32(fArray[1]);
                    this.vertexArray[3 * n3 + 2] = PGraphicsAndroid3D.toFixed32(fArray[2]);
                    this.colorArray[4 * n3 + 0] = PGraphicsAndroid3D.toFixed32(fArray[13]);
                    this.colorArray[4 * n3 + 1] = PGraphicsAndroid3D.toFixed32(fArray[14]);
                    this.colorArray[4 * n3 + 2] = PGraphicsAndroid3D.toFixed32(fArray[15]);
                    this.colorArray[4 * n3 + 3] = PGraphicsAndroid3D.toFixed32(fArray[16]);
                    ++n3;
                }
                ++n5;
            }
            if (this.recordingShape) continue;
            this.vertexBuffer.put(this.vertexArray);
            this.colorBuffer.put(this.colorArray);
            this.vertexBuffer.position(0);
            this.colorBuffer.position(0);
            this.gl.glVertexPointer(3, 5132, 0, (Buffer)this.vertexBuffer);
            this.gl.glColorPointer(4, 5132, 0, (Buffer)this.colorBuffer);
            this.gl.glDrawArrays(3, 0, this.pathLength[i] + 1);
        }
        this.gl.glDisableClientState(32884);
        this.gl.glDisableClientState(32886);
        this.report("render_lines out");
    }

    protected void addTriangle(int n, int n2, int n3) {
        boolean bl;
        if (this.triangleCount == this.triangles.length) {
            int[][] nArray = new int[this.triangleCount << 1][3];
            PApplet.arrayCopy(this.triangles, 0, nArray, 0, this.triangleCount);
            this.triangles = nArray;
        }
        this.triangles[this.triangleCount][0] = n;
        this.triangles[this.triangleCount][1] = n2;
        this.triangles[this.triangleCount][2] = n3;
        int n4 = PApplet.min(n, n2, n3);
        int n5 = PApplet.max(n, n2, n3);
        PImage[] pImageArray = this.vertexTex[n];
        boolean bl2 = bl = this.triangleCount == 0;
        if (this.diffFromTextures0(pImageArray) || bl) {
            this.addNewFace(bl, pImageArray);
            this.faceMinIndex[this.faceCount - 1] = n4;
            this.faceMaxIndex[this.faceCount - 1] = n5;
        } else {
            int n6 = this.faceCount - 1;
            this.faceLength[n6] = this.faceLength[n6] + 1;
            this.faceMinIndex[this.faceCount - 1] = PApplet.min(this.faceMinIndex[this.faceCount - 1], n4);
            this.faceMaxIndex[this.faceCount - 1] = PApplet.max(this.faceMaxIndex[this.faceCount - 1], n5);
        }
        ++this.triangleCount;
        this.setTextures0(pImageArray);
    }

    protected void addNewFace(boolean bl, PImage[] pImageArray) {
        Object[] objectArray;
        if (this.faceCount == this.faceOffset.length) {
            this.faceOffset = PApplet.expand(this.faceOffset);
            this.faceLength = PApplet.expand(this.faceLength);
            this.faceMinIndex = PApplet.expand(this.faceMinIndex);
            this.faceMaxIndex = PApplet.expand(this.faceMaxIndex);
            objectArray = new PImage[this.faceCount << 1][2];
            PApplet.arrayCopy(this.faceTextures, 0, objectArray, 0, this.faceCount);
            this.faceTextures = objectArray;
        }
        this.faceOffset[this.faceCount] = bl ? 0 : this.triangleCount;
        this.faceLength[this.faceCount] = 1;
        objectArray = this.faceTextures[this.faceCount];
        if (1 < this.numTextures) {
            PApplet.arrayCopy(pImageArray, 0, objectArray, 0, this.numTextures);
        }
        objectArray[0] = 0 < this.numTextures ? pImageArray[0] : null;
        Arrays.fill(objectArray, this.numTextures, maxTextureUnits, null);
        ++this.faceCount;
    }

    protected void renderTriangles(int n, int n2) {
        this.report("render_triangles in");
        int n3 = 0;
        this.gl.glEnableClientState(32884);
        this.gl.glEnableClientState(32886);
        this.gl.glEnableClientState(32885);
        for (int i = n; i < n2; ++i) {
            int n4;
            PTexture pTexture;
            PTexture pTexture2;
            int n5;
            int n6 = this.faceOffset[i];
            PImage[] pImageArray = this.faceTextures[i];
            if (1 < this.numTextures) {
                for (n5 = 0; n5 < this.numTextures && pImageArray[n5] != null && (pTexture2 = this.getTexture(pImageArray[n5])) != null; ++n5) {
                    this.gl.glEnable(pTexture2.glTarget);
                    this.gl.glActiveTexture(33984 + n5);
                    this.gl.glBindTexture(pTexture2.glTarget, pTexture2.glID);
                    this.renderTextures[n3] = pTexture2;
                    ++n3;
                }
            } else if (pImageArray[0] != null && (pTexture = this.getTexture(pImageArray[0])) != null) {
                this.gl.glEnable(pTexture.glTarget);
                this.gl.glActiveTexture(33984);
                this.gl.glBindTexture(pTexture.glTarget, pTexture.glID);
                this.renderTextures[0] = pTexture;
                n3 = 1;
            }
            if (0 < n3) {
                if (this.numTexBuffers < n3) {
                    this.addTexBuffers(n3 - this.numTexBuffers);
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    this.gl.glClientActiveTexture(33984 + n5);
                    this.gl.glEnableClientState(32888);
                }
                if (1 < n3) {
                    this.setTextureBlend(this.renderTextures, n3);
                }
            }
            if (this.USE_GEO_BUFFER) {
                if (this.recordingShape) {
                    this.recTexturesCount = PApplet.max(this.recTexturesCount, n3);
                    n5 = this.recordedIndices.size() + this.geoBuffer.idxCount;
                    int n7 = n5 + 3 * this.faceLength[i] - 1;
                    n4 = this.recordedVertices.size() + this.geoBuffer.vertCount;
                    int n8 = n4 + this.faceMaxIndex[i] - this.faceMinIndex[i];
                    String string = "shape";
                    string = this.mergeRecShapes ? "shape" : (this.recShapeName.equals("") ? "shape:" + this.recordedChildren.size() : this.recShapeName);
                    PShape3D pShape3D = (PShape3D)PShape3D.createChild(string, n4, n8, n5, n7, 9, 0.0f, pImageArray);
                    this.recordedChildren.add(pShape3D);
                }
                if (this.GEO_BUFFER_ACCUM_ALL) {
                    if (this.geoBuffer.newTextures(this.renderTextures, n3)) {
                        if (0 < this.geoBuffer.vertCount) {
                            if (this.recordingShape) {
                                this.geoBuffer.record();
                            } else {
                                this.geoBuffer.render();
                            }
                            ++this.GEO_BUFFER_COUNT;
                            this.geoBuffer.init(9, this.renderTextures, n3);
                        } else {
                            this.geoBuffer.setTextures(this.renderTextures, n3);
                        }
                    }
                } else {
                    this.geoBuffer.init(9, this.renderTextures, n3);
                }
                this.geoBuffer.add(this.triangles, n6, n6 + this.faceLength[i] - 1, this.vertices, this.faceMinIndex[i], this.faceMaxIndex[i]);
                if (this.GEO_BUFFER_ACCUM_ALL) {
                    if (0 < this.GEO_BUFFER_MAXSIZE && this.GEO_BUFFER_MAXSIZE < this.geoBuffer.vertCount) {
                        if (this.recordingShape) {
                            this.geoBuffer.record();
                        } else {
                            this.geoBuffer.render();
                        }
                        ++this.GEO_BUFFER_COUNT;
                        this.geoBuffer.init(9, this.renderTextures, n3);
                    }
                } else {
                    if (this.recordingShape) {
                        this.geoBuffer.record();
                    } else {
                        this.geoBuffer.render();
                    }
                    ++this.GEO_BUFFER_COUNT;
                    this.geoBuffer.init(9);
                }
            } else {
                int n9;
                if (this.recordingShape) {
                    this.recTexturesCount = PApplet.max(this.recTexturesCount, n3);
                    n5 = this.recordedVertices.size();
                    int n10 = n5 + 3 * this.faceLength[i] - 1;
                    String string = "shape";
                    string = this.mergeRecShapes ? "shape" : (this.recShapeName.equals("") ? "shape:" + this.recordedChildren.size() : this.recShapeName);
                    PShape3D pShape3D = (PShape3D)PShape3D.createChild(string, n5, n10, 9, 0.0f, pImageArray);
                    this.recordedChildren.add(pShape3D);
                }
                n5 = 3 * this.faceLength[i];
                while (this.vertexBuffer.capacity() / 3 < n5) {
                    this.expandBuffers();
                }
                this.vertexBuffer.position(0);
                this.colorBuffer.position(0);
                this.normalBuffer.position(0);
                for (n9 = 0; n9 < n3; ++n9) {
                    this.texCoordBuffer[n9].position(0);
                }
                n9 = 0;
                for (n4 = 0; n4 < this.faceLength[i]; ++n4) {
                    int n11;
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    float f6;
                    float f7;
                    int n12 = this.triangles[n6][0];
                    int n13 = this.triangles[n6][1];
                    int n14 = this.triangles[n6][2];
                    float[] fArray = this.vertices[n12];
                    float[] fArray2 = this.vertices[n13];
                    float[] fArray3 = this.vertices[n14];
                    if (this.autoNormal && (fArray[18] == 0.0f || fArray2[18] == 0.0f || fArray3[18] == 0.0f)) {
                        f7 = fArray2[0] - fArray[0];
                        f6 = fArray2[1] - fArray[1];
                        f5 = fArray2[2] - fArray[2];
                        f4 = fArray2[0] - fArray3[0];
                        f3 = fArray2[1] - fArray3[1];
                        f2 = fArray2[2] - fArray3[2];
                        f = f6 * f2 - f3 * f5;
                        float f8 = f5 * f4 - f2 * f7;
                        float f9 = f7 * f3 - f4 * f6;
                        float f10 = PApplet.sqrt(f * f + f8 * f8 + f9 * f9);
                        fArray2[9] = fArray3[9] = (f /= f10);
                        fArray[9] = fArray3[9];
                        fArray2[10] = fArray3[10] = (f8 /= f10);
                        fArray[10] = fArray3[10];
                        fArray2[11] = fArray3[11] = (f9 /= f10);
                        fArray[11] = fArray3[11];
                        fArray3[18] = 1.0f;
                        fArray2[18] = 1.0f;
                        fArray[18] = 1.0f;
                    }
                    if (n3 == 1) {
                        f7 = 1.0f;
                        f6 = 1.0f;
                        f5 = 0.0f;
                        f4 = 1.0f;
                        f3 = 0.0f;
                        f2 = 1.0f;
                        PTexture pTexture3 = this.renderTextures[0];
                        f7 *= pTexture3.getMaxTexCoordU();
                        f6 *= pTexture3.getMaxTexCoordV();
                        if (pTexture3.isFlippedX()) {
                            f5 = 1.0f;
                            f4 = -1.0f;
                        }
                        if (pTexture3.isFlippedY()) {
                            f3 = 1.0f;
                            f2 = -1.0f;
                        }
                        this.renderUa[0] = (f5 + f4 * fArray[7]) * f7;
                        this.renderVa[0] = (f3 + f2 * fArray[8]) * f6;
                        this.renderUb[0] = (f5 + f4 * fArray2[7]) * f7;
                        this.renderVb[0] = (f3 + f2 * fArray2[8]) * f6;
                        this.renderUc[0] = (f5 + f4 * fArray3[7]) * f7;
                        this.renderVc[0] = (f3 + f2 * fArray3[8]) * f6;
                    } else if (1 < n3) {
                        for (int j = 0; j < n3; ++j) {
                            f6 = 1.0f;
                            f5 = 1.0f;
                            f4 = 0.0f;
                            f3 = 1.0f;
                            f2 = 0.0f;
                            f = 1.0f;
                            PTexture pTexture4 = this.renderTextures[j];
                            f6 *= pTexture4.getMaxTexCoordU();
                            f5 *= pTexture4.getMaxTexCoordV();
                            if (pTexture4.isFlippedX()) {
                                f4 = 1.0f;
                                f3 = -1.0f;
                            }
                            if (pTexture4.isFlippedY()) {
                                f2 = 1.0f;
                                f = -1.0f;
                            }
                            this.renderUa[j] = (f4 + f3 * this.vertexU[n12][j]) * f6;
                            this.renderVa[j] = (f2 + f * this.vertexV[n12][j]) * f5;
                            this.renderUb[j] = (f4 + f3 * this.vertexU[n13][j]) * f6;
                            this.renderVb[j] = (f2 + f * this.vertexV[n13][j]) * f5;
                            this.renderUc[j] = (f4 + f3 * this.vertexU[n14][j]) * f6;
                            this.renderVc[j] = (f2 + f * this.vertexV[n14][j]) * f5;
                        }
                    }
                    if (this.recordingShape) {
                        this.recordedVertices.add(new PVector(fArray[0], fArray[1], fArray[2]));
                        this.recordedColors.add(new float[]{fArray[3], fArray[4], fArray[5], fArray[6]});
                        this.recordedNormals.add(new PVector(fArray[9], fArray[10], fArray[11]));
                        for (n11 = 0; n11 < n3; ++n11) {
                            this.recordedTexCoords[n11].add(new PVector(this.vertexU[n12][n11], this.vertexV[n12][n11], 0.0f));
                        }
                        for (n11 = n3; n11 < maxTextureUnits; ++n11) {
                            this.recordedTexCoords[n11].add(new PVector(0.0f, 0.0f, 0.0f));
                        }
                    } else {
                        this.vertexArray[3 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray[0]);
                        this.vertexArray[3 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray[1]);
                        this.vertexArray[3 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray[2]);
                        this.colorArray[4 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray[3]);
                        this.colorArray[4 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray[4]);
                        this.colorArray[4 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray[5]);
                        this.colorArray[4 * n9 + 3] = PGraphicsAndroid3D.toFixed32(fArray[6]);
                        this.normalArray[3 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray[9]);
                        this.normalArray[3 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray[10]);
                        this.normalArray[3 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray[11]);
                        for (n11 = 0; n11 < n3; ++n11) {
                            this.texCoordArray[n11][2 * n9 + 0] = PGraphicsAndroid3D.toFixed32(this.renderUa[n11]);
                            this.texCoordArray[n11][2 * n9 + 1] = PGraphicsAndroid3D.toFixed32(this.renderVa[n11]);
                        }
                        ++n9;
                    }
                    if (this.recordingShape) {
                        this.recordedVertices.add(new PVector(fArray2[0], fArray2[1], fArray2[2]));
                        this.recordedColors.add(new float[]{fArray2[3], fArray2[4], fArray2[5], fArray2[6]});
                        this.recordedNormals.add(new PVector(fArray2[9], fArray2[10], fArray2[11]));
                        for (n11 = 0; n11 < n3; ++n11) {
                            this.recordedTexCoords[n11].add(new PVector(this.vertexU[n13][n11], this.vertexV[n13][n11], 0.0f));
                        }
                        for (n11 = n3; n11 < maxTextureUnits; ++n11) {
                            this.recordedTexCoords[n11].add(new PVector(0.0f, 0.0f, 0.0f));
                        }
                    } else {
                        this.vertexArray[3 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray2[0]);
                        this.vertexArray[3 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray2[1]);
                        this.vertexArray[3 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray2[2]);
                        this.colorArray[4 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray2[3]);
                        this.colorArray[4 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray2[4]);
                        this.colorArray[4 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray2[5]);
                        this.colorArray[4 * n9 + 3] = PGraphicsAndroid3D.toFixed32(fArray2[6]);
                        this.normalArray[3 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray2[9]);
                        this.normalArray[3 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray2[10]);
                        this.normalArray[3 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray2[11]);
                        for (n11 = 0; n11 < n3; ++n11) {
                            this.texCoordArray[n11][2 * n9 + 0] = PGraphicsAndroid3D.toFixed32(this.renderUb[n11]);
                            this.texCoordArray[n11][2 * n9 + 1] = PGraphicsAndroid3D.toFixed32(this.renderVb[n11]);
                        }
                        ++n9;
                    }
                    if (this.recordingShape) {
                        this.recordedVertices.add(new PVector(fArray3[0], fArray3[1], fArray3[2]));
                        this.recordedColors.add(new float[]{fArray3[3], fArray3[4], fArray3[5], fArray3[6]});
                        this.recordedNormals.add(new PVector(fArray3[9], fArray3[10], fArray3[11]));
                        for (n11 = 0; n11 < n3; ++n11) {
                            this.recordedTexCoords[n11].add(new PVector(this.vertexU[n14][n11], this.vertexV[n14][n11], 0.0f));
                        }
                        for (n11 = n3; n11 < maxTextureUnits; ++n11) {
                            this.recordedTexCoords[n11].add(new PVector(0.0f, 0.0f, 0.0f));
                        }
                    } else {
                        this.vertexArray[3 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray3[0]);
                        this.vertexArray[3 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray3[1]);
                        this.vertexArray[3 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray3[2]);
                        this.colorArray[4 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray3[3]);
                        this.colorArray[4 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray3[4]);
                        this.colorArray[4 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray3[5]);
                        this.colorArray[4 * n9 + 3] = PGraphicsAndroid3D.toFixed32(fArray3[6]);
                        this.normalArray[3 * n9 + 0] = PGraphicsAndroid3D.toFixed32(fArray3[9]);
                        this.normalArray[3 * n9 + 1] = PGraphicsAndroid3D.toFixed32(fArray3[10]);
                        this.normalArray[3 * n9 + 2] = PGraphicsAndroid3D.toFixed32(fArray3[11]);
                        for (n11 = 0; n11 < n3; ++n11) {
                            this.texCoordArray[n11][2 * n9 + 0] = PGraphicsAndroid3D.toFixed32(this.renderUc[n11]);
                            this.texCoordArray[n11][2 * n9 + 1] = PGraphicsAndroid3D.toFixed32(this.renderVc[n11]);
                        }
                        ++n9;
                    }
                    ++n6;
                }
                if (!this.recordingShape) {
                    this.vertexBuffer.put(this.vertexArray);
                    this.colorBuffer.put(this.colorArray);
                    this.normalBuffer.put(this.normalArray);
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.texCoordBuffer[n4].put(this.texCoordArray[n4]);
                    }
                    this.vertexBuffer.position(0);
                    this.colorBuffer.position(0);
                    this.normalBuffer.position(0);
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.texCoordBuffer[n4].position(0);
                    }
                    this.gl.glVertexPointer(3, 5132, 0, (Buffer)this.vertexBuffer);
                    this.gl.glColorPointer(4, 5132, 0, (Buffer)this.colorBuffer);
                    this.gl.glNormalPointer(5132, 0, (Buffer)this.normalBuffer);
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.gl.glClientActiveTexture(33984 + n4);
                        this.gl.glTexCoordPointer(2, 5132, 0, (Buffer)this.texCoordBuffer[n4]);
                    }
                    this.gl.glDrawArrays(4, 0, 3 * this.faceLength[i]);
                }
            }
            if (0 >= n3) continue;
            if (1 < n3) {
                this.cleanupTextureBlend(n3);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                pTexture2 = this.renderTextures[n5];
                this.gl.glActiveTexture(33984 + n5);
                this.gl.glBindTexture(pTexture2.glTarget, 0);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                pTexture2 = this.renderTextures[n5];
                this.gl.glDisable(pTexture2.glTarget);
            }
            for (n5 = 0; n5 < n3; ++n5) {
                this.gl.glClientActiveTexture(33984 + n5);
                this.gl.glDisableClientState(32888);
            }
        }
        this.gl.glDisableClientState(32885);
        this.gl.glDisableClientState(32886);
        this.gl.glDisableClientState(32884);
        this.report("render_triangles out");
    }

    protected void addPolygonTriangles() {
        float[] fArray;
        float[] fArray2;
        int n;
        int n2;
        if (this.vertexOrder.length != this.vertices.length) {
            int[] nArray = new int[this.vertices.length];
            PApplet.arrayCopy(this.vertexOrder, nArray, this.vertexCount);
            this.vertexOrder = nArray;
        }
        int n3 = 0;
        int n4 = 1;
        float f = 0.0f;
        int n5 = this.shapeLast - 1;
        int n6 = this.shapeFirst;
        while (n6 < this.shapeLast) {
            f += this.vertices[n6][n3] * this.vertices[n5][n4] - this.vertices[n5][n3] * this.vertices[n6][n4];
            n5 = n6++;
        }
        if (f == 0.0f) {
            n5 = 0;
            n6 = 0;
            for (n2 = this.shapeFirst; n2 < this.shapeLast; ++n2) {
                for (n = n2; n < this.shapeLast; ++n) {
                    if (this.vertices[n2][0] != this.vertices[n][0]) {
                        n5 = 1;
                    }
                    if (this.vertices[n2][1] == this.vertices[n][1]) continue;
                    n6 = 1;
                }
            }
            if (n5 != 0) {
                n4 = 2;
            } else if (n6 != 0) {
                n3 = 1;
                n4 = 2;
            } else {
                return;
            }
            n2 = this.shapeLast - 1;
            n = this.shapeFirst;
            while (n < this.shapeLast) {
                f += this.vertices[n][n3] * this.vertices[n2][n4] - this.vertices[n2][n3] * this.vertices[n][n4];
                n2 = n++;
            }
        }
        if (PApplet.abs((fArray2 = this.vertices[this.shapeFirst])[0] - (fArray = this.vertices[this.shapeLast - 1])[0]) < 1.0E-4f && PApplet.abs(fArray2[1] - fArray[1]) < 1.0E-4f && PApplet.abs(fArray2[2] - fArray[2]) < 1.0E-4f) {
            --this.shapeLast;
        }
        n2 = 0;
        if (f > 0.0f) {
            n = this.shapeFirst;
            while (n < this.shapeLast) {
                n2 = n - this.shapeFirst;
                this.vertexOrder[n2] = n++;
            }
        } else {
            for (n = this.shapeFirst; n < this.shapeLast; ++n) {
                n2 = n - this.shapeFirst;
                this.vertexOrder[n2] = this.shapeLast - 1 - n2;
            }
        }
        n = this.shapeLast - this.shapeFirst;
        int n7 = 2 * n;
        int n8 = 0;
        int n9 = n - 1;
        while (n > 2) {
            int n10;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            int n11;
            boolean bl = true;
            if (0 >= n7--) break;
            int n12 = n9;
            if (n <= n12) {
                n12 = 0;
            }
            if (n <= (n9 = n12 + 1)) {
                n9 = 0;
            }
            if (n <= (n11 = n9 + 1)) {
                n11 = 0;
            }
            if ((double)1.0E-4f > ((d6 = (double)(-10.0f * this.vertices[this.vertexOrder[n9]][n3])) - (d5 = (double)(-10.0f * this.vertices[this.vertexOrder[n12]][n3]))) * ((d4 = (double)(10.0f * this.vertices[this.vertexOrder[n11]][n4])) - (d3 = (double)(10.0f * this.vertices[this.vertexOrder[n12]][n4]))) - ((d2 = (double)(10.0f * this.vertices[this.vertexOrder[n9]][n4])) - d3) * ((d = (double)(-10.0f * this.vertices[this.vertexOrder[n11]][n3])) - d5)) continue;
            for (n10 = 0; n10 < n; ++n10) {
                if (n10 == n12 || n10 == n9 || n10 == n11) continue;
                double d7 = -10.0f * this.vertices[this.vertexOrder[n10]][n3];
                double d8 = 10.0f * this.vertices[this.vertexOrder[n10]][n4];
                double d9 = d - d6;
                double d10 = d4 - d2;
                double d11 = d5 - d;
                double d12 = d3 - d4;
                double d13 = d6 - d5;
                double d14 = d2 - d3;
                double d15 = d7 - d5;
                double d16 = d8 - d3;
                double d17 = d7 - d6;
                double d18 = d8 - d2;
                double d19 = d7 - d;
                double d20 = d8 - d4;
                double d21 = d9 * d18 - d10 * d17;
                double d22 = d13 * d16 - d14 * d15;
                double d23 = d11 * d20 - d12 * d19;
                if (!(d21 >= 0.0) || !(d23 >= 0.0) || !(d22 >= 0.0)) continue;
                bl = false;
            }
            if (!bl) continue;
            this.addTriangle(this.vertexOrder[n12], this.vertexOrder[n9], this.vertexOrder[n11]);
            ++n8;
            n10 = n9;
            for (int i = n9 + 1; i < n; ++i) {
                this.vertexOrder[n10] = this.vertexOrder[i];
                ++n10;
            }
            n7 = 2 * --n;
        }
    }

    protected void expandBuffers() {
        int n;
        int n2 = this.vertexBuffer.capacity() / 3 << 1;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * 3 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n2 * 4 * 4);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.colorBuffer = byteBuffer2.asIntBuffer();
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(n2 * 3 * 4);
        byteBuffer3.order(ByteOrder.nativeOrder());
        this.normalBuffer = byteBuffer3.asIntBuffer();
        for (n = 0; n < this.numTexBuffers; ++n) {
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(n2 * 2 * 4);
            byteBuffer4.order(ByteOrder.nativeOrder());
            this.texCoordBuffer[n] = byteBuffer4.asIntBuffer();
        }
        this.vertexArray = new int[n2 * 3];
        this.colorArray = new int[n2 * 4];
        this.normalArray = new int[n2 * 3];
        for (n = 0; n < this.numTexBuffers; ++n) {
            this.texCoordArray[n] = new int[n2 * 2];
        }
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        int n;
        boolean bl;
        float f5;
        float f6;
        int n2;
        float f7 = f3 / 2.0f;
        float f8 = f4 / 2.0f;
        float f9 = f + f7;
        float f10 = f2 + f8;
        float f11 = this.screenX(f, f2);
        float f12 = this.screenY(f, f2);
        float f13 = this.screenX(f + f3, f2 + f4);
        float f14 = this.screenY(f + f3, f2 + f4);
        if (this.fill) {
            n2 = (int)((float)Math.PI * 2 * PApplet.dist(f11, f12, f13, f14) / 20.0f);
            if (n2 < 6) {
                n2 = 6;
            }
            f6 = 720.0f / (float)n2;
            f5 = 0.0f;
            bl = this.stroke;
            this.stroke = false;
            n = this.smooth;
            if (this.smooth && this.stroke) {
                this.smooth = false;
            }
            this.beginShape(11);
            this.normal(0.0f, 0.0f, 1.0f);
            this.vertex(f9, f10);
            for (int i = 0; i < n2; ++i) {
                this.vertex(f9 + cosLUT[(int)f5] * f7, f10 + sinLUT[(int)f5] * f8);
                f5 = (f5 + f6) % 720.0f;
            }
            this.vertex(f9 + cosLUT[0] * f7, f10 + sinLUT[0] * f8);
            this.endShape();
            this.stroke = bl;
            this.smooth = n;
        }
        if (this.stroke) {
            n2 = (int)((float)Math.PI * 2 * PApplet.dist(f11, f12, f13, f14) / 8.0f);
            if (n2 < 6) {
                n2 = 6;
            }
            f6 = 720.0f / (float)n2;
            f5 = 0.0f;
            bl = this.fill;
            this.fill = false;
            f5 = 0.0f;
            this.beginShape();
            for (n = 0; n < n2; ++n) {
                this.vertex(f9 + cosLUT[(int)f5] * f7, f10 + sinLUT[(int)f5] * f8);
                f5 = (f5 + f6) % 720.0f;
            }
            this.endShape(2);
            this.fill = bl;
        }
    }

    public void smooth() {
        this.smooth = true;
        if (this.hints[1]) {
            this.gl.glEnable(2832);
            this.gl.glEnable(2848);
        }
    }

    public void noSmooth() {
        this.smooth = false;
        if (this.hints[1]) {
            this.gl.glDisable(2832);
            this.gl.glDisable(2848);
        }
    }

    public void shape(PShape3D pShape3D) {
        pShape3D.draw(this);
    }

    public void shape(PShape3D pShape3D, float f, float f2) {
        this.shape(pShape3D, f, f2, 0.0f);
    }

    public void shape(PShape3D pShape3D, float f, float f2, float f3) {
        this.pushMatrix();
        this.translate(f, f2, f3);
        pShape3D.draw(this);
        this.popMatrix();
    }

    public void beginText() {
        if (this.textMode == 4) {
            this.textBlockMode = true;
            this.textVertexCount = 0;
        }
    }

    public void endText() {
        if (this.textBlockMode) {
            this.textBlockMode = false;
            if (0 < this.textVertexCount) {
                if (this.screenBlendMode != 1) {
                    this.gl.glEnable(3042);
                    if (blendEqSupported) {
                        this.gl11xp.glBlendEquation(32774);
                    }
                    this.gl.glBlendFunc(770, 771);
                }
                this.textTex.setTexture(this.textBlockTex);
                this.renderTextModel();
                this.screenBlend(this.screenBlendMode);
                this.gl.glBindTexture(3553, 0);
                this.gl.glDisable(3553);
            }
        }
    }

    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        if (this.gl11 == null || this.gl11x == null) {
            throw new RuntimeException("A3D: Text rendering requires OpenGL ES 1.1");
        }
        this.gl.glEnable(3553);
        if (this.screenBlendMode != 1) {
            this.gl.glEnable(3042);
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(770, 771);
        }
        this.textTex = (PFontTexture)this.textFont.getCache(this.a3d);
        if (this.textTex == null) {
            this.textTex = new PFontTexture(this.parent, this.textFont, maxTextureSize, maxTextureSize);
            this.textFont.setCache(this, this.textTex);
        }
        this.textTex.setFirstTexture();
        this.setFillColor();
        if (this.textMode == 4) {
            if (this.textVertexBuffer == null) {
                this.allocateTextModel();
            }
            this.setDefNormals(0.0f, 0.0f, 1.0f);
            if (!this.textBlockMode) {
                this.textVertexCount = 0;
            }
        }
        super.textLineImpl(cArray, n, n2, f, f2);
        if (this.textMode == 4 && 0 < this.textVertexCount) {
            if (!this.textBlockMode) {
                this.renderTextModel();
            } else {
                this.textBlockTex = this.textTex.currentTex;
            }
        }
        this.screenBlend(this.screenBlendMode);
        this.gl.glBindTexture(3553, 0);
        this.gl.glDisable(3553);
    }

    protected void textCharImpl(char c, float f, float f2) {
        PFont.Glyph glyph = this.textFont.getGlyph(c);
        if (glyph != null) {
            PFontTexture.TextureInfo textureInfo = this.textTex.getTexInfo(glyph);
            if (textureInfo == null) {
                textureInfo = this.textTex.addToTexture(glyph);
            }
            if (this.textMode == 4) {
                float f3 = (float)glyph.height / (float)this.textFont.size;
                float f4 = (float)glyph.width / (float)this.textFont.size;
                float f5 = (float)glyph.leftExtent / (float)this.textFont.size;
                float f6 = (float)glyph.topExtent / (float)this.textFont.size;
                float f7 = f + f5 * this.textSize;
                float f8 = f2 - f6 * this.textSize;
                float f9 = f7 + f4 * this.textSize;
                float f10 = f8 + f3 * this.textSize;
                this.textCharModelImpl(textureInfo, f7, f8, f9, f10);
            }
        }
    }

    protected void textCharModelImpl(PFontTexture.TextureInfo textureInfo, float f, float f2, float f3, float f4) {
        if (this.textTex.currentTex != textureInfo.texIndex || this.textBlockMode && this.textBlockTex != textureInfo.texIndex) {
            if (0 < this.textVertexCount) {
                this.renderTextModel();
                this.textVertexCount = 0;
            }
            this.textTex.setTexture(textureInfo.texIndex);
        }
        if (this.textVertexBuffer.capacity() / 3 < this.textVertexCount + 6) {
            this.expandTextBuffers();
        }
        int n = this.textVertexCount;
        this.textVertexArray[3 * n + 0] = PGraphicsAndroid3D.toFixed32(f);
        this.textVertexArray[3 * n + 1] = PGraphicsAndroid3D.toFixed32(f2);
        this.textVertexArray[3 * n + 2] = PGraphicsAndroid3D.toFixed32(0.0f);
        this.textTexCoordArray[2 * n + 0] = PGraphicsAndroid3D.toFixed32(textureInfo.u0);
        this.textTexCoordArray[2 * n + 1] = PGraphicsAndroid3D.toFixed32(textureInfo.v0);
        this.textVertexArray[3 * ++n + 0] = PGraphicsAndroid3D.toFixed32(f3);
        this.textVertexArray[3 * n + 1] = PGraphicsAndroid3D.toFixed32(f4);
        this.textVertexArray[3 * n + 2] = PGraphicsAndroid3D.toFixed32(0.0f);
        this.textTexCoordArray[2 * n + 0] = PGraphicsAndroid3D.toFixed32(textureInfo.u1);
        this.textTexCoordArray[2 * n + 1] = PGraphicsAndroid3D.toFixed32(textureInfo.v1);
        this.textVertexArray[3 * ++n + 0] = PGraphicsAndroid3D.toFixed32(f);
        this.textVertexArray[3 * n + 1] = PGraphicsAndroid3D.toFixed32(f4);
        this.textVertexArray[3 * n + 2] = PGraphicsAndroid3D.toFixed32(0.0f);
        this.textTexCoordArray[2 * n + 0] = PGraphicsAndroid3D.toFixed32(textureInfo.u0);
        this.textTexCoordArray[2 * n + 1] = PGraphicsAndroid3D.toFixed32(textureInfo.v1);
        this.textVertexArray[3 * ++n + 0] = PGraphicsAndroid3D.toFixed32(f);
        this.textVertexArray[3 * n + 1] = PGraphicsAndroid3D.toFixed32(f2);
        this.textVertexArray[3 * n + 2] = PGraphicsAndroid3D.toFixed32(0.0f);
        this.textTexCoordArray[2 * n + 0] = PGraphicsAndroid3D.toFixed32(textureInfo.u0);
        this.textTexCoordArray[2 * n + 1] = PGraphicsAndroid3D.toFixed32(textureInfo.v0);
        this.textVertexArray[3 * ++n + 0] = PGraphicsAndroid3D.toFixed32(f3);
        this.textVertexArray[3 * n + 1] = PGraphicsAndroid3D.toFixed32(f2);
        this.textVertexArray[3 * n + 2] = PGraphicsAndroid3D.toFixed32(0.0f);
        this.textTexCoordArray[2 * n + 0] = PGraphicsAndroid3D.toFixed32(textureInfo.u1);
        this.textTexCoordArray[2 * n + 1] = PGraphicsAndroid3D.toFixed32(textureInfo.v0);
        this.textVertexArray[3 * ++n + 0] = PGraphicsAndroid3D.toFixed32(f3);
        this.textVertexArray[3 * n + 1] = PGraphicsAndroid3D.toFixed32(f4);
        this.textVertexArray[3 * n + 2] = PGraphicsAndroid3D.toFixed32(0.0f);
        this.textTexCoordArray[2 * n + 0] = PGraphicsAndroid3D.toFixed32(textureInfo.u1);
        this.textTexCoordArray[2 * n + 1] = PGraphicsAndroid3D.toFixed32(textureInfo.v1);
        this.textVertexCount = ++n;
    }

    protected void allocateTextModel() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(6144);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.textVertexBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(4096);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.textTexCoordBuffer = byteBuffer2.asIntBuffer();
        this.textVertexArray = new int[1536];
        this.textTexCoordArray = new int[1024];
    }

    protected void renderTextModel() {
        this.textVertexBuffer.position(0);
        this.textTexCoordBuffer.position(0);
        this.textVertexBuffer.put(this.textVertexArray);
        this.textTexCoordBuffer.put(this.textTexCoordArray);
        this.gl.glEnableClientState(32884);
        this.gl.glEnableClientState(32888);
        this.textVertexBuffer.position(0);
        this.textTexCoordBuffer.position(0);
        this.gl.glVertexPointer(3, 5132, 0, (Buffer)this.textVertexBuffer);
        this.gl.glTexCoordPointer(2, 5132, 0, (Buffer)this.textTexCoordBuffer);
        this.gl.glDrawArrays(4, 0, this.textVertexCount);
        this.gl.glDisableClientState(32888);
        this.gl.glDisableClientState(32884);
    }

    protected void expandTextBuffers() {
        int n = this.textVertexBuffer.capacity() / 3 << 1;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 3 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.textVertexBuffer = byteBuffer.asIntBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n * 2 * 4);
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.textTexCoordBuffer = byteBuffer2.asIntBuffer();
        this.textVertexArray = new int[n * 3];
        this.textTexCoordArray = new int[n * 2];
    }

    public void pushMatrix() {
        if (this.USE_GEO_BUFFER && this.GEO_BUFFER_ACCUM_ALL && this.UPDATE_GEO_BUFFER_MATRIX_STACK) {
            this.geoBuffer.stack.push();
            if (!this.UPDATE_GL_MATRIX_STACK) {
                return;
            }
        }
        this.gl.glPushMatrix();
        if (usingGLMatrixStack) {
            if (this.matrixMode == 0) {
                projectionStack.push();
            } else {
                modelviewStack.push();
            }
        }
    }

    public void popMatrix() {
        if (this.USE_GEO_BUFFER && this.GEO_BUFFER_ACCUM_ALL && this.UPDATE_GEO_BUFFER_MATRIX_STACK) {
            this.geoBuffer.stack.pop();
            if (!this.UPDATE_GL_MATRIX_STACK) {
                return;
            }
        }
        this.gl.glPopMatrix();
        if (usingGLMatrixStack) {
            if (this.matrixMode == 0) {
                projectionStack.pop();
                this.projectionUpdated = false;
            } else {
                modelviewStack.pop();
                this.modelviewUpdated = false;
            }
        }
    }

    public void translate(float f, float f2) {
        this.translate(f, f2, 0.0f);
    }

    public void translate(float f, float f2, float f3) {
        if (this.USE_GEO_BUFFER && this.GEO_BUFFER_ACCUM_ALL && this.UPDATE_GEO_BUFFER_MATRIX_STACK) {
            this.geoBuffer.stack.translate(f, f2, f3);
            if (!this.UPDATE_GL_MATRIX_STACK) {
                return;
            }
        }
        this.gl.glTranslatef(f, f2, f3);
        if (usingGLMatrixStack) {
            if (this.matrixMode == 0) {
                projectionStack.translate(f, f2, f3);
                this.projectionUpdated = false;
            } else {
                modelviewStack.translate(f, f2, f3);
                this.modelviewUpdated = false;
            }
        }
    }

    public void rotate(float f) {
        this.rotateZ(f);
    }

    public void rotateX(float f) {
        this.rotate(f, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float f) {
        this.rotate(f, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float f) {
        this.rotate(f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        if (this.USE_GEO_BUFFER && this.GEO_BUFFER_ACCUM_ALL && this.UPDATE_GEO_BUFFER_MATRIX_STACK) {
            this.geoBuffer.stack.rotate(f, f2, f3, f4);
            if (!this.UPDATE_GL_MATRIX_STACK) {
                return;
            }
        }
        this.gl.glRotatef(PApplet.degrees(f), f2, f3, f4);
        if (usingGLMatrixStack) {
            if (this.matrixMode == 0) {
                projectionStack.rotate(f, f2, f3, f4);
                this.projectionUpdated = false;
            } else {
                modelviewStack.rotate(f, f2, f3, f4);
                this.modelviewUpdated = false;
            }
        }
    }

    public void scale(float f) {
        this.scale(f, f, f);
    }

    public void scale(float f, float f2) {
        this.scale(f, f2, 1.0f);
    }

    public void scale(float f, float f2, float f3) {
        if (this.USE_GEO_BUFFER && this.GEO_BUFFER_ACCUM_ALL && this.UPDATE_GEO_BUFFER_MATRIX_STACK) {
            this.geoBuffer.stack.scale(f, f2, f3);
            if (!this.UPDATE_GL_MATRIX_STACK) {
                return;
            }
        }
        if (this.manipulatingCamera) {
            this.scalingDuringCamManip = true;
        }
        this.gl.glScalef(f, f2, f3);
        if (usingGLMatrixStack) {
            if (this.matrixMode == 0) {
                projectionStack.scale(f, f2, f3);
                this.projectionUpdated = false;
            } else {
                modelviewStack.scale(f, f2, f3);
                this.modelviewUpdated = false;
            }
        }
    }

    public void shearX(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrix(1.0f, f2, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void shearY(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrix(1.0f, 0.0f, 0.0f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void matrixMode(int n) {
        if (n == 0) {
            this.gl.glMatrixMode(5889);
            this.matrixMode = 0;
        } else if (n == 1) {
            this.gl.glMatrixMode(5888);
            this.matrixMode = 1;
        } else {
            System.err.println("A3D: incorrect matrix mode.");
        }
    }

    public void resetMatrix() {
        this.gl.glLoadIdentity();
        if (usingGLMatrixStack) {
            if (this.matrixMode == 0) {
                projectionStack.setIdentity();
                this.projectionUpdated = false;
            } else {
                modelviewStack.setIdentity();
                this.modelviewUpdated = false;
            }
        }
    }

    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.applyMatrix(pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, pMatrix2D.m12);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.applyMatrix(f, f2, f3, 0.0f, f4, f5, f6, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(PMatrix3D pMatrix3D) {
        this.applyMatrix(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.gltemp[0] = f;
        this.gltemp[1] = f5;
        this.gltemp[2] = f9;
        this.gltemp[3] = f13;
        this.gltemp[4] = f2;
        this.gltemp[5] = f6;
        this.gltemp[6] = f10;
        this.gltemp[7] = f14;
        this.gltemp[8] = f3;
        this.gltemp[9] = f7;
        this.gltemp[10] = f11;
        this.gltemp[11] = f15;
        this.gltemp[12] = f4;
        this.gltemp[13] = f8;
        this.gltemp[14] = f12;
        this.gltemp[15] = f16;
        this.gl.glMultMatrixf(this.gltemp, 0);
        if (usingGLMatrixStack) {
            if (this.matrixMode == 0) {
                projectionStack.mult(this.gltemp);
                this.projectionUpdated = false;
            } else {
                modelviewStack.mult(this.gltemp);
                this.modelviewUpdated = false;
            }
        }
    }

    public void updateModelview() {
        this.updateModelview(true);
    }

    public void updateModelview(boolean bl) {
        this.copyPMatrixToGLArray(this.modelview, this.glmodelview);
        if (bl) {
            this.calculateModelviewInverse();
        } else {
            this.copyPMatrixToGLArray(this.modelviewInv, this.glmodelviewInv);
        }
        this.gl.glLoadMatrixf(this.glmodelview, 0);
        if (usingGLMatrixStack) {
            modelviewStack.set(this.glmodelview);
        }
        this.modelviewUpdated = true;
    }

    public void updateCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call updateCamera() without first calling beginCamera()");
        }
        this.copyPMatrixToGLArray(this.camera, this.glmodelview);
        this.gl.glLoadMatrixf(this.glmodelview, 0);
        if (usingGLMatrixStack) {
            modelviewStack.set(this.glmodelview);
        }
        this.scalingDuringCamManip = true;
        this.modelviewUpdated = true;
    }

    protected void copyPMatrixToGLArray(PMatrix3D pMatrix3D, float[] fArray) {
        fArray[0] = pMatrix3D.m00;
        fArray[1] = pMatrix3D.m10;
        fArray[2] = pMatrix3D.m20;
        fArray[3] = pMatrix3D.m30;
        fArray[4] = pMatrix3D.m01;
        fArray[5] = pMatrix3D.m11;
        fArray[6] = pMatrix3D.m21;
        fArray[7] = pMatrix3D.m31;
        fArray[8] = pMatrix3D.m02;
        fArray[9] = pMatrix3D.m12;
        fArray[10] = pMatrix3D.m22;
        fArray[11] = pMatrix3D.m32;
        fArray[12] = pMatrix3D.m03;
        fArray[13] = pMatrix3D.m13;
        fArray[14] = pMatrix3D.m23;
        fArray[15] = pMatrix3D.m33;
    }

    protected void copyGLArrayToPMatrix(float[] fArray, PMatrix3D pMatrix3D) {
        pMatrix3D.m00 = fArray[0];
        pMatrix3D.m10 = fArray[1];
        pMatrix3D.m20 = fArray[2];
        pMatrix3D.m30 = fArray[3];
        pMatrix3D.m01 = fArray[4];
        pMatrix3D.m11 = fArray[5];
        pMatrix3D.m21 = fArray[6];
        pMatrix3D.m31 = fArray[7];
        pMatrix3D.m02 = fArray[8];
        pMatrix3D.m12 = fArray[9];
        pMatrix3D.m22 = fArray[10];
        pMatrix3D.m32 = fArray[11];
        pMatrix3D.m03 = fArray[12];
        pMatrix3D.m13 = fArray[13];
        pMatrix3D.m23 = fArray[14];
        pMatrix3D.m33 = fArray[15];
    }

    public PMatrix getMatrix() {
        if (this.matrixMode == 0) {
            if (!this.projectionUpdated) {
                this.getProjectionMatrix();
            }
            return this.projection.get();
        }
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        return this.modelview.get();
    }

    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        if (pMatrix3D == null) {
            pMatrix3D = new PMatrix3D();
        }
        if (this.matrixMode == 0) {
            if (!this.projectionUpdated) {
                this.getProjectionMatrix();
            }
            pMatrix3D.set(this.projection);
        } else {
            if (!this.modelviewUpdated) {
                this.getModelviewMatrix();
            }
            pMatrix3D.set(this.modelview);
        }
        return pMatrix3D;
    }

    public void setMatrix(PMatrix2D pMatrix2D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix2D);
    }

    public void setMatrix(PMatrix3D pMatrix3D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix3D);
    }

    public void printMatrix() {
        if (this.matrixMode == 0) {
            if (!this.projectionUpdated) {
                this.getProjectionMatrix();
            }
            this.projection.print();
        } else {
            if (!this.modelviewUpdated) {
                this.getModelviewMatrix();
            }
            this.modelview.print();
        }
    }

    protected void getProjectionMatrix() {
        if (usingGLMatrixStack) {
            projectionStack.get(this.glprojection);
        } else {
            this.gl11.glGetFloatv(2983, this.glprojection, 0);
        }
        this.copyGLArrayToPMatrix(this.glprojection, this.projection);
        this.projectionUpdated = true;
    }

    public void updateProjection() {
        this.copyPMatrixToGLArray(this.projection, this.glprojection);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadMatrixf(this.glprojection, 0);
        if (this.matrixMode == 1) {
            this.gl.glMatrixMode(5888);
        }
        if (usingGLMatrixStack) {
            projectionStack.set(this.glprojection);
        }
        this.projectionUpdated = true;
    }

    public void restoreProjection() {
        PApplet.arrayCopy(this.pprojection, this.glprojection);
        this.copyGLArrayToPMatrix(this.pprojection, this.projection);
        this.gl.glMatrixMode(5889);
        this.gl.glLoadMatrixf(this.glprojection, 0);
        if (this.matrixMode == 1) {
            this.gl.glMatrixMode(5888);
        }
        if (usingGLMatrixStack) {
            projectionStack.set(this.glprojection);
        }
        this.projectionUpdated = true;
    }

    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
        this.scalingDuringCamManip = false;
    }

    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.getModelviewMatrix();
        if (this.scalingDuringCamManip) {
            this.calculateModelviewInverse();
        } else {
            this.calculateModelviewInvNoScaling();
        }
        PApplet.arrayCopy(this.glmodelview, this.pcamera);
        PApplet.arrayCopy(this.glmodelviewInv, this.pcameraInv);
        this.copyGLArrayToPMatrix(this.pcamera, this.camera);
        this.copyGLArrayToPMatrix(this.pcameraInv, this.cameraInv);
        this.manipulatingCamera = false;
        this.scalingDuringCamManip = false;
    }

    protected void getModelviewMatrix() {
        if (usingGLMatrixStack) {
            modelviewStack.get(this.glmodelview);
        } else {
            this.gl11.glGetFloatv(2982, this.glmodelview, 0);
        }
        this.copyGLArrayToPMatrix(this.glmodelview, this.modelview);
        this.modelviewUpdated = true;
    }

    protected void calculateModelviewInverse() {
        float[] fArray = this.glmodelview;
        float[] fArray2 = this.glmodelviewInv;
        float f = fArray[0] * fArray[5] - fArray[1] * fArray[4];
        float f2 = fArray[10] * fArray[15] - fArray[11] * fArray[14];
        float f3 = fArray[0] * fArray[6] - fArray[2] * fArray[4];
        float f4 = fArray[9] * fArray[15] - fArray[11] * fArray[13];
        float f5 = fArray[0] * fArray[7] - fArray[3] * fArray[4];
        float f6 = fArray[9] * fArray[14] - fArray[10] * fArray[13];
        float f7 = fArray[1] * fArray[6] - fArray[2] * fArray[5];
        float f8 = fArray[8] * fArray[15] - fArray[11] * fArray[12];
        float f9 = fArray[1] * fArray[7] - fArray[3] * fArray[5];
        float f10 = fArray[8] * fArray[14] - fArray[10] * fArray[12];
        float f11 = fArray[2] * fArray[7] - fArray[3] * fArray[6];
        float f12 = fArray[8] * fArray[13] - fArray[9] * fArray[12];
        float f13 = f * f2 - f3 * f4 + f5 * f6 + f7 * f8 - f9 * f10 + f11 * f12;
        if (PApplet.abs(f13) > 0.0f) {
            fArray2[0] = fArray[5] * f2 - fArray[6] * f4 + fArray[7] * f6;
            fArray2[4] = -fArray[4] * f2 + fArray[6] * f8 - fArray[7] * f10;
            fArray2[8] = fArray[4] * f4 - fArray[5] * f8 + fArray[7] * f12;
            fArray2[12] = -fArray[4] * f6 + fArray[5] * f10 - fArray[6] * f12;
            fArray2[1] = -fArray[1] * f2 + fArray[2] * f4 - fArray[3] * f6;
            fArray2[5] = fArray[0] * f2 - fArray[2] * f8 + fArray[3] * f10;
            fArray2[9] = -fArray[0] * f4 + fArray[1] * f8 - fArray[3] * f12;
            fArray2[13] = fArray[0] * f6 - fArray[1] * f10 + fArray[2] * f12;
            fArray2[2] = fArray[13] * f11 - fArray[14] * f9 + fArray[15] * f7;
            fArray2[6] = -fArray[12] * f11 + fArray[14] * f5 - fArray[15] * f3;
            fArray2[10] = fArray[12] * f9 - fArray[13] * f5 + fArray[15] * f;
            fArray2[14] = -fArray[12] * f7 + fArray[13] * f3 - fArray[14] * f;
            fArray2[3] = -fArray[9] * f11 + fArray[10] * f9 - fArray[11] * f7;
            fArray2[7] = fArray[8] * f11 - fArray[10] * f5 + fArray[11] * f3;
            fArray2[11] = -fArray[8] * f9 + fArray[9] * f5 - fArray[11] * f;
            fArray2[15] = fArray[8] * f7 - fArray[9] * f3 + fArray[10] * f;
            float f14 = 1.0f / f13;
            fArray2[0] = fArray2[0] * f14;
            fArray2[1] = fArray2[1] * f14;
            fArray2[2] = fArray2[2] * f14;
            fArray2[3] = fArray2[3] * f14;
            fArray2[4] = fArray2[4] * f14;
            fArray2[5] = fArray2[5] * f14;
            fArray2[6] = fArray2[6] * f14;
            fArray2[7] = fArray2[7] * f14;
            fArray2[8] = fArray2[8] * f14;
            fArray2[9] = fArray2[9] * f14;
            fArray2[10] = fArray2[10] * f14;
            fArray2[11] = fArray2[11] * f14;
            fArray2[12] = fArray2[12] * f14;
            fArray2[13] = fArray2[13] * f14;
            fArray2[14] = fArray2[14] * f14;
            fArray2[15] = fArray2[15] * f14;
            this.copyGLArrayToPMatrix(fArray2, this.modelviewInv);
        }
    }

    protected void calculateModelviewInvNoScaling() {
        float[] fArray = this.glmodelview;
        float[] fArray2 = this.glmodelviewInv;
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[4];
        float f5 = fArray[5];
        float f6 = fArray[6];
        float f7 = fArray[8];
        float f8 = fArray[9];
        float f9 = fArray[10];
        float f10 = fArray[12];
        float f11 = fArray[13];
        float f12 = fArray[14];
        fArray2[0] = f;
        fArray2[1] = f4;
        fArray2[2] = f7;
        fArray2[3] = 0.0f;
        fArray2[4] = f2;
        fArray2[5] = f5;
        fArray2[6] = f8;
        fArray2[7] = 0.0f;
        fArray2[8] = f3;
        fArray2[9] = f6;
        fArray2[10] = f9;
        fArray2[11] = 0.0f;
        fArray2[12] = -(f * f10 + f2 * f11 + f3 * f12);
        fArray2[13] = -(f4 * f10 + f5 * f11 + f6 * f12);
        fArray2[14] = -(f7 * f10 + f8 * f11 + f9 * f12);
        fArray2[15] = 1.0f;
        this.copyGLArrayToPMatrix(fArray2, this.modelviewInv);
    }

    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f - f4;
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = PApplet.sqrt(f10 * f10 + f11 * f11 + f12 * f12);
        if (f13 != 0.0f) {
            f10 /= f13;
            f11 /= f13;
            f12 /= f13;
        }
        float f14 = f7;
        float f15 = f8;
        float f16 = f9;
        float f17 = f15 * f12 - f16 * f11;
        float f18 = -f14 * f12 + f16 * f10;
        float f19 = f14 * f11 - f15 * f10;
        f14 = f11 * f19 - f12 * f18;
        f15 = -f10 * f19 + f12 * f17;
        f16 = f10 * f18 - f11 * f17;
        f13 = PApplet.sqrt(f17 * f17 + f18 * f18 + f19 * f19);
        if (f13 != 0.0f) {
            f17 /= f13;
            f18 /= f13;
            f19 /= f13;
        }
        if ((f13 = PApplet.sqrt(f14 * f14 + f15 * f15 + f16 * f16)) != 0.0f) {
            f14 /= f13;
            f15 /= f13;
            f16 /= f13;
        }
        float[] fArray = this.glmodelview;
        fArray[0] = f17;
        fArray[1] = f14;
        fArray[2] = f10;
        fArray[3] = 0.0f;
        fArray[4] = f18;
        fArray[5] = f15;
        fArray[6] = f11;
        fArray[7] = 0.0f;
        fArray[8] = f19;
        fArray[9] = f16;
        fArray[10] = f12;
        fArray[11] = 0.0f;
        fArray[12] = 0.0f;
        fArray[13] = 0.0f;
        fArray[14] = 0.0f;
        fArray[15] = 1.0f;
        float f20 = -f;
        float f21 = -f2;
        float f22 = -f3;
        fArray[12] = fArray[12] + (f20 * fArray[0] + f21 * fArray[4] + f22 * fArray[8]);
        fArray[13] = fArray[13] + (f20 * fArray[1] + f21 * fArray[5] + f22 * fArray[9]);
        fArray[14] = fArray[14] + (f20 * fArray[2] + f21 * fArray[6] + f22 * fArray[10]);
        fArray[15] = fArray[15] + (f20 * fArray[3] + f21 * fArray[7] + f22 * fArray[11]);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadMatrixf(this.glmodelview, 0);
        if (usingGLMatrixStack) {
            modelviewStack.set(this.glmodelview);
        }
        this.copyGLArrayToPMatrix(this.glmodelview, this.modelview);
        this.modelviewUpdated = true;
        this.calculateModelviewInvNoScaling();
        PApplet.arrayCopy(this.glmodelview, this.pcamera);
        PApplet.arrayCopy(this.glmodelviewInv, this.pcameraInv);
        this.copyGLArrayToPMatrix(this.pcamera, this.camera);
        this.copyGLArrayToPMatrix(this.pcameraInv, this.cameraInv);
    }

    public void restoreCamera() {
        PApplet.arrayCopy(this.pcamera, this.glmodelview);
        PApplet.arrayCopy(this.pcameraInv, this.glmodelviewInv);
        this.copyGLArrayToPMatrix(this.pcamera, this.camera);
        this.copyGLArrayToPMatrix(this.pcameraInv, this.cameraInv);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadMatrixf(this.glmodelview, 0);
        if (usingGLMatrixStack) {
            modelviewStack.set(this.glmodelview);
        }
        this.copyGLArrayToPMatrix(this.glmodelview, this.modelview);
        this.modelviewUpdated = true;
    }

    public void printCamera() {
        PMatrix3D pMatrix3D = new PMatrix3D();
        this.copyGLArrayToPMatrix(this.pcamera, pMatrix3D);
        pMatrix3D.print();
    }

    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, this.cameraNear, this.cameraFar);
    }

    public void ortho(float f, float f2, float f3, float f4) {
        this.ortho(f, f2, f3, f4, this.cameraNear, this.cameraFar);
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 2.0f / ((f2 -= (float)(this.width / 2)) - (f -= (float)(this.width / 2)));
        float f8 = 2.0f / ((f4 -= (float)(this.height / 2)) - (f3 -= (float)(this.height / 2)));
        float f9 = -2.0f / (f6 - f5);
        float f10 = -(f2 + f) / (f2 - f);
        float f11 = -(f4 + f3) / (f4 - f3);
        float f12 = -(f6 + f5) / (f6 - f5);
        this.glprojection[0] = f7;
        this.glprojection[1] = 0.0f;
        this.glprojection[2] = 0.0f;
        this.glprojection[3] = 0.0f;
        this.glprojection[4] = 0.0f;
        this.glprojection[5] = -f8;
        this.glprojection[6] = 0.0f;
        this.glprojection[7] = 0.0f;
        this.glprojection[8] = 0.0f;
        this.glprojection[9] = 0.0f;
        this.glprojection[10] = f9;
        this.glprojection[11] = 0.0f;
        this.glprojection[12] = f10;
        this.glprojection[13] = f11;
        this.glprojection[14] = f12;
        this.glprojection[15] = 1.0f;
        this.gl.glMatrixMode(5889);
        this.gl.glLoadMatrixf(this.glprojection, 0);
        this.copyGLArrayToPMatrix(this.glprojection, this.projection);
        this.projectionUpdated = true;
        this.gl.glMatrixMode(5888);
    }

    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    public void perspective(float f, float f2, float f3, float f4) {
        float f5 = f3 * (float)Math.tan(f / 2.0f);
        float f6 = -f5;
        float f7 = f6 * f2;
        float f8 = f5 * f2;
        this.frustum(f7, f8, f6, f5, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        this.glprojection[0] = f7 / f8;
        this.glprojection[1] = 0.0f;
        this.glprojection[2] = 0.0f;
        this.glprojection[3] = 0.0f;
        this.glprojection[4] = 0.0f;
        this.glprojection[5] = -f7 / f9;
        this.glprojection[6] = 0.0f;
        this.glprojection[7] = 0.0f;
        this.glprojection[8] = (f2 + f) / f8;
        this.glprojection[9] = (f4 + f3) / f9;
        this.glprojection[10] = (-f6 - f5) / f10;
        this.glprojection[11] = -1.0f;
        this.glprojection[12] = 0.0f;
        this.glprojection[13] = 0.0f;
        this.glprojection[14] = -f7 * f6 / f10;
        this.glprojection[15] = 0.0f;
        this.gl.glMatrixMode(5889);
        this.gl.glLoadMatrixf(this.glprojection, 0);
        this.copyGLArrayToPMatrix(this.glprojection, this.projection);
        this.projectionUpdated = true;
        PApplet.arrayCopy(this.glprojection, this.pprojection);
        this.gl.glMatrixMode(5888);
    }

    public void printProjection() {
        if (!this.projectionUpdated) {
            this.getProjectionMatrix();
        }
        this.projection.print();
    }

    public float screenX(float f, float f2) {
        return this.screenX(f, f2, 0.0f);
    }

    public float screenY(float f, float f2) {
        return this.screenY(f, f2, 0.0f);
    }

    public float screenX(float f, float f2, float f3) {
        f2 = -1.0f * f2;
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        if (!this.projectionUpdated) {
            this.getProjectionMatrix();
        }
        float f4 = this.glmodelview[0] * f + this.glmodelview[4] * f2 + this.glmodelview[8] * f3 + this.glmodelview[12];
        float f5 = this.glmodelview[1] * f + this.glmodelview[5] * f2 + this.glmodelview[9] * f3 + this.glmodelview[13];
        float f6 = this.glmodelview[2] * f + this.glmodelview[6] * f2 + this.glmodelview[10] * f3 + this.glmodelview[14];
        float f7 = this.glmodelview[3] * f + this.glmodelview[7] * f2 + this.glmodelview[11] * f3 + this.glmodelview[15];
        float f8 = this.glprojection[0] * f4 + this.glprojection[4] * f5 + this.glprojection[8] * f6 + this.glprojection[12] * f7;
        float f9 = this.glprojection[3] * f4 + this.glprojection[7] * f5 + this.glprojection[11] * f6 + this.glprojection[15] * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (float)this.width * (1.0f + f8) / 2.0f;
    }

    public float screenY(float f, float f2, float f3) {
        f2 = -1.0f * f2;
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        if (!this.projectionUpdated) {
            this.getProjectionMatrix();
        }
        float f4 = this.glmodelview[0] * f + this.glmodelview[4] * f2 + this.glmodelview[8] * f3 + this.glmodelview[12];
        float f5 = this.glmodelview[1] * f + this.glmodelview[5] * f2 + this.glmodelview[9] * f3 + this.glmodelview[13];
        float f6 = this.glmodelview[2] * f + this.glmodelview[6] * f2 + this.glmodelview[10] * f3 + this.glmodelview[14];
        float f7 = this.glmodelview[3] * f + this.glmodelview[7] * f2 + this.glmodelview[11] * f3 + this.glmodelview[15];
        float f8 = this.glprojection[1] * f4 + this.glprojection[5] * f5 + this.glprojection[9] * f6 + this.glprojection[13] * f7;
        float f9 = this.glprojection[3] * f4 + this.glprojection[7] * f5 + this.glprojection[11] * f6 + this.glprojection[15] * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (float)this.height * (1.0f + f8) / 2.0f;
    }

    public float screenZ(float f, float f2, float f3) {
        f2 = -1.0f * f2;
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        if (!this.projectionUpdated) {
            this.getProjectionMatrix();
        }
        float f4 = this.glmodelview[0] * f + this.glmodelview[4] * f2 + this.glmodelview[8] * f3 + this.glmodelview[12];
        float f5 = this.glmodelview[1] * f + this.glmodelview[5] * f2 + this.glmodelview[9] * f3 + this.glmodelview[13];
        float f6 = this.glmodelview[2] * f + this.glmodelview[6] * f2 + this.glmodelview[10] * f3 + this.glmodelview[14];
        float f7 = this.glmodelview[3] * f + this.glmodelview[7] * f2 + this.glmodelview[11] * f3 + this.glmodelview[15];
        float f8 = this.glprojection[2] * f4 + this.glprojection[6] * f5 + this.glprojection[10] * f6 + this.glprojection[14] * f7;
        float f9 = this.glprojection[3] * f4 + this.glprojection[7] * f5 + this.glprojection[11] * f6 + this.glprojection[15] * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (f8 + 1.0f) / 2.0f;
    }

    public float modelX(float f, float f2, float f3) {
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        float f4 = this.glmodelview[0] * f + this.glmodelview[4] * f2 + this.glmodelview[8] * f3 + this.glmodelview[12];
        float f5 = this.glmodelview[1] * f + this.glmodelview[5] * f2 + this.glmodelview[9] * f3 + this.glmodelview[13];
        float f6 = this.glmodelview[2] * f + this.glmodelview[6] * f2 + this.glmodelview[10] * f3 + this.glmodelview[14];
        float f7 = this.glmodelview[3] * f + this.glmodelview[7] * f2 + this.glmodelview[11] * f3 + this.glmodelview[15];
        float f8 = this.pcameraInv[0] * f4 + this.pcameraInv[4] * f5 + this.pcameraInv[8] * f6 + this.pcameraInv[12] * f7;
        float f9 = this.pcameraInv[3] * f4 + this.pcameraInv[7] * f5 + this.pcameraInv[11] * f6 + this.pcameraInv[15] * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public float modelY(float f, float f2, float f3) {
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        float f4 = this.glmodelview[0] * f + this.glmodelview[4] * f2 + this.glmodelview[8] * f3 + this.glmodelview[12];
        float f5 = this.glmodelview[1] * f + this.glmodelview[5] * f2 + this.glmodelview[9] * f3 + this.glmodelview[13];
        float f6 = this.glmodelview[2] * f + this.glmodelview[6] * f2 + this.glmodelview[10] * f3 + this.glmodelview[14];
        float f7 = this.glmodelview[3] * f + this.glmodelview[7] * f2 + this.glmodelview[11] * f3 + this.glmodelview[15];
        float f8 = this.pcameraInv[1] * f4 + this.pcameraInv[5] * f5 + this.pcameraInv[9] * f6 + this.pcameraInv[13] * f7;
        float f9 = this.pcameraInv[3] * f4 + this.pcameraInv[7] * f5 + this.pcameraInv[11] * f6 + this.pcameraInv[15] * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public float modelZ(float f, float f2, float f3) {
        if (!this.modelviewUpdated) {
            this.getModelviewMatrix();
        }
        float f4 = this.glmodelview[0] * f + this.glmodelview[4] * f2 + this.glmodelview[8] * f3 + this.glmodelview[12];
        float f5 = this.glmodelview[1] * f + this.glmodelview[5] * f2 + this.glmodelview[9] * f3 + this.glmodelview[13];
        float f6 = this.glmodelview[2] * f + this.glmodelview[6] * f2 + this.glmodelview[10] * f3 + this.glmodelview[14];
        float f7 = this.glmodelview[3] * f + this.glmodelview[7] * f2 + this.glmodelview[11] * f3 + this.glmodelview[15];
        float f8 = this.pcameraInv[2] * f4 + this.pcameraInv[6] * f5 + this.pcameraInv[10] * f6 + this.pcameraInv[14] * f7;
        float f9 = this.pcameraInv[3] * f4 + this.pcameraInv[7] * f5 + this.pcameraInv[11] * f6 + this.pcameraInv[15] * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public void strokeWeight(float f) {
        this.strokeWeight = f;
    }

    public void strokeJoin(int n) {
        if (n != 8) {
            PGraphicsAndroid3D.showMethodWarning("strokeJoin");
        }
    }

    public void strokeCap(int n) {
        if (n != 2) {
            PGraphicsAndroid3D.showMethodWarning("strokeCap");
        }
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.calcColorBuffer();
    }

    protected void setFillColor() {
        this.gl.glColor4f(this.fillR, this.fillG, this.fillB, this.fillA);
    }

    protected void setTintColor() {
        this.gl.glColor4f(this.tintR, this.tintG, this.tintB, this.tintA);
    }

    protected void ambientFromCalc() {
        super.ambientFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4608, this.colorFloats, 0);
    }

    protected void specularFromCalc() {
        super.specularFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorFloats, 0);
    }

    public void shininess(float f) {
        super.shininess(f);
        this.gl.glMaterialf(1032, 5633, f);
    }

    protected void emissiveFromCalc() {
        super.emissiveFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5632, this.colorFloats, 0);
    }

    public void lights() {
        this.enableLighting();
        int n = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = n;
    }

    public void noLights() {
        this.disableLighting();
        this.lightCount = 0;
    }

    public void ambientLight(float f, float f2, float f3) {
        this.ambientLight(f, f2, f3, 0.0f, 0.0f, 0.0f);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 0;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightPosition[this.lightCount][0] = f4;
        this.lightPosition[this.lightCount][1] = f5;
        this.lightPosition[this.lightCount][2] = f6;
        this.lightPosition[this.lightCount][3] = 1.0f;
        this.lightEnable(this.lightCount);
        this.lightAmbient(this.lightCount);
        this.lightPosition(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightNoSpot(this.lightCount);
        this.lightNoDiffuse(this.lightCount);
        this.lightNoSpecular(this.lightCount);
        ++this.lightCount;
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 1;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightSpecular[this.lightCount][3] = this.currentLightSpecular[3];
        this.lightNormal[this.lightCount][0] = -f4;
        this.lightNormal[this.lightCount][1] = -f5;
        this.lightNormal[this.lightCount][2] = -f6;
        this.lightNormal[this.lightCount][3] = 0.0f;
        this.lightEnable(this.lightCount);
        this.lightNoAmbient(this.lightCount);
        this.lightDirection(this.lightCount);
        this.lightDiffuse(this.lightCount);
        this.lightSpecular(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightNoSpot(this.lightCount);
        ++this.lightCount;
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 2;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition[this.lightCount][0] = f4;
        this.lightPosition[this.lightCount][1] = f5;
        this.lightPosition[this.lightCount][2] = f6;
        this.lightPosition[this.lightCount][3] = 1.0f;
        this.lightEnable(this.lightCount);
        this.lightNoAmbient(this.lightCount);
        this.lightPosition(this.lightCount);
        this.lightDiffuse(this.lightCount);
        this.lightSpecular(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightNoSpot(this.lightCount);
        ++this.lightCount;
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (!this.lights) {
            this.enableLighting();
        }
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightDiffuse[this.lightCount][3] = 1.0f;
        this.lightType[this.lightCount] = 3;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition[this.lightCount][0] = f4;
        this.lightPosition[this.lightCount][1] = f5;
        this.lightPosition[this.lightCount][2] = f6;
        this.lightPosition[this.lightCount][3] = 1.0f;
        float f12 = 1.0f / PApplet.dist(0.0f, 0.0f, 0.0f, f7, f8, f9);
        this.lightNormal[this.lightCount][0] = f12 * f7;
        this.lightNormal[this.lightCount][1] = f12 * f8;
        this.lightNormal[this.lightCount][2] = f12 * f9;
        this.lightNormal[this.lightCount][3] = 0.0f;
        this.lightSpotAngle[this.lightCount] = PApplet.degrees(f10);
        this.lightSpotAngleCos[this.lightCount] = Math.max(0.0f, (float)Math.cos(f10));
        this.lightSpotConcentration[this.lightCount] = f11;
        this.lightEnable(this.lightCount);
        this.lightNoAmbient(this.lightCount);
        this.lightPosition(this.lightCount);
        this.lightDirection(this.lightCount);
        this.lightDiffuse(this.lightCount);
        this.lightSpecular(this.lightCount);
        this.lightFalloff(this.lightCount);
        this.lightSpotAngle(this.lightCount);
        this.lightSpotConcentration(this.lightCount);
        ++this.lightCount;
    }

    public void lightFalloff(float f, float f2, float f3) {
        this.currentLightFalloffConstant = f;
        this.currentLightFalloffLinear = f2;
        this.currentLightFalloffQuadratic = f3;
    }

    public void lightSpecular(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
        this.currentLightSpecular[3] = 1.0f;
    }

    protected void enableLights() {
        for (int i = 0; i < this.lightCount; ++i) {
            this.lightEnable(i);
        }
    }

    protected void disableLights() {
        for (int i = 0; i < this.lightCount; ++i) {
            this.lightDisable(i);
        }
    }

    protected void enableLighting() {
        this.lights = true;
        this.gl.glEnable(2896);
    }

    protected void disableLighting() {
        this.lights = false;
        this.gl.glDisable(2896);
    }

    protected void lightAmbient(int n) {
        this.gl.glLightfv(16384 + n, 4608, this.lightDiffuse[n], 0);
    }

    protected void lightNoAmbient(int n) {
        this.gl.glLightfv(16384 + n, 4608, this.zeroLight, 0);
    }

    protected void lightNoSpot(int n) {
        this.gl.glLightf(16384 + n, 4614, 180.0f);
        this.gl.glLightf(16384 + n, 4613, 0.0f);
    }

    protected void lightDiffuse(int n) {
        this.gl.glLightfv(16384 + n, 4609, this.lightDiffuse[n], 0);
    }

    protected void lightNoDiffuse(int n) {
        this.gl.glLightfv(16384 + n, 4609, this.zeroLight, 0);
    }

    protected void lightDirection(int n) {
        if (this.lightType[n] == 1) {
            this.gl.glLightfv(16384 + n, 4611, this.lightNormal[n], 0);
        } else {
            this.gl.glLightfv(16384 + n, 4612, this.lightNormal[n], 0);
        }
    }

    protected void lightEnable(int n) {
        this.gl.glEnable(16384 + n);
    }

    protected void lightDisable(int n) {
        this.gl.glDisable(16384 + n);
    }

    protected void lightFalloff(int n) {
        this.gl.glLightf(16384 + n, 4615, this.lightFalloffConstant[n]);
        this.gl.glLightf(16384 + n, 4616, this.lightFalloffLinear[n]);
        this.gl.glLightf(16384 + n, 4617, this.lightFalloffQuadratic[n]);
    }

    protected void lightPosition(int n) {
        this.gl.glLightfv(16384 + n, 4611, this.lightPosition[n], 0);
    }

    protected void lightSpecular(int n) {
        this.gl.glLightfv(16384 + n, 4610, this.lightSpecular[n], 0);
    }

    protected void lightNoSpecular(int n) {
        this.gl.glLightfv(16384 + n, 4610, this.zeroLight, 0);
    }

    protected void lightSpotAngle(int n) {
        this.gl.glLightf(16384 + n, 4614, this.lightSpotAngle[n]);
    }

    protected void lightSpotConcentration(int n) {
        this.gl.glLightf(16384 + n, 4613, this.lightSpotConcentration[n]);
    }

    protected void backgroundImpl(PImage pImage) {
        this.backgroundImpl();
        this.set(0, 0, pImage);
    }

    protected void backgroundImpl() {
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.gl.glClear(256);
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16384);
        if (0 < this.parent.frameCount) {
            this.clearColorBuffer = true;
        }
    }

    protected final void calcColorBuffer() {
        if (this.colorFloats == null) {
            this.colorFloats = new float[4];
        }
        this.colorFloats[0] = this.calcR;
        this.colorFloats[1] = this.calcG;
        this.colorFloats[2] = this.calcB;
        this.colorFloats[3] = this.calcA;
    }

    public void report(String string) {
        int n;
        if (!this.hints[6] && (n = this.gl.glGetError()) != 0) {
            String string2 = GLU.gluErrorString((int)n);
            String string3 = "OpenGL error " + n + " at " + string + ": " + string2;
            PGraphics.showWarning(string3);
        }
    }

    public boolean is2D() {
        return true;
    }

    public boolean is3D() {
        return true;
    }

    public void loadPixels() {
        int n;
        boolean bl;
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
            this.pixelBuffer = IntBuffer.allocate(this.pixels.length);
            this.pixelBuffer.rewind();
        }
        boolean bl2 = bl = !this.primarySurface && this.offscreenFramebuffer != currentFramebuffer;
        if (bl) {
            this.pushFramebuffer();
            this.setFramebuffer(this.offscreenFramebuffer);
        }
        this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
        if (bl) {
            this.popFramebuffer();
        }
        this.pixelBuffer.get(this.pixels);
        this.pixelBuffer.rewind();
        int n2 = 0;
        int n3 = (this.height - 1) * this.width;
        for (n = 0; n < this.height / 2; ++n) {
            int n4;
            int n5;
            if (BIG_ENDIAN) {
                for (n5 = 0; n5 < this.width; ++n5) {
                    n4 = this.pixels[n2];
                    this.pixels[n2] = 0xFF000000 | this.pixels[n3] >> 8 & 0xFFFFFF;
                    this.pixels[n3] = 0xFF000000 | n4 >> 8 & 0xFFFFFF;
                    ++n2;
                    ++n3;
                }
            } else {
                for (n5 = 0; n5 < this.width; ++n5) {
                    n4 = this.pixels[n2];
                    this.pixels[n2] = 0xFF000000 | this.pixels[n3] << 16 & 0xFF0000 | this.pixels[n3] & 0xFF00 | this.pixels[n3] >> 16 & 0xFF;
                    this.pixels[n3] = 0xFF000000 | n4 << 16 & 0xFF0000 | n4 & 0xFF00 | n4 >> 16 & 0xFF;
                    ++n2;
                    ++n3;
                }
            }
            n3 -= this.width * 2;
        }
        if (this.height % 2 == 1) {
            n2 = this.height / 2 * this.width;
            if (BIG_ENDIAN) {
                for (n = 0; n < this.width; ++n) {
                    this.pixels[n2] = 0xFF000000 | this.pixels[n2] >> 8 & 0xFFFFFF;
                }
            } else {
                for (n = 0; n < this.width; ++n) {
                    this.pixels[n2] = 0xFF000000 | this.pixels[n2] << 16 & 0xFF0000 | this.pixels[n2] & 0xFF00 | this.pixels[n2] >> 16 & 0xFF;
                }
            }
        }
        if (this.primarySurface && !fboSupported) {
            this.loadTextureImpl(2);
            this.pixelsToTexture();
        }
    }

    static void nativeToJavaRGB(PImage pImage) {
        int n = 0;
        int n2 = (pImage.height - 1) * pImage.width;
        for (int i = 0; i < pImage.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = 0xFF000000 | pImage.pixels[n2] >> 8 & 0xFFFFFF;
                    pImage.pixels[n2] = 0xFF000000 | n3 >> 8 & 0xFFFFFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = 0xFF000000 | pImage.pixels[n2] << 16 & 0xFF0000 | pImage.pixels[n2] & 0xFF00 | pImage.pixels[n2] >> 16 & 0xFF;
                    pImage.pixels[n2] = 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= pImage.width * 2;
        }
    }

    static void nativeToJavaARGB(PImage pImage) {
        int n = 0;
        int n2 = (pImage.height - 1) * pImage.width;
        for (int i = 0; i < pImage.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = pImage.pixels[n2] & 0xFF000000 | pImage.pixels[n2] >> 8 & 0xFFFFFF;
                    pImage.pixels[n2] = n3 & 0xFF000000 | n3 >> 8 & 0xFFFFFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = pImage.pixels[n2] & 0xFF000000 | pImage.pixels[n2] << 16 & 0xFF0000 | pImage.pixels[n2] & 0xFF00 | pImage.pixels[n2] >> 16 & 0xFF;
                    pImage.pixels[n2] = n3 & 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= pImage.width * 2;
        }
    }

    static void javaToNativeRGB(PImage pImage) {
        int n = pImage.width;
        int n2 = pImage.height;
        int[] nArray = pImage.pixels;
        int n3 = 0;
        int n4 = (n2 - 1) * n;
        for (int i = 0; i < n2 / 2; ++i) {
            int n5;
            int n6;
            if (BIG_ENDIAN) {
                for (n6 = 0; n6 < pImage.width; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] << 8 & 0xFFFFFF00 | 0xFF;
                    nArray[n4] = n5 << 8 & 0xFFFFFF00 | 0xFF;
                    ++n3;
                    ++n4;
                }
            } else {
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    nArray[n4] = 0xFF000000 | n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF;
                    ++n3;
                    ++n4;
                }
            }
            n4 -= n * 2;
        }
    }

    static void javaToNativeARGB(PImage pImage) {
        int n = pImage.width;
        int n2 = pImage.height;
        int[] nArray = pImage.pixels;
        int n3 = 0;
        int n4 = (n2 - 1) * n;
        for (int i = 0; i < n2 / 2; ++i) {
            int n5;
            int n6;
            if (BIG_ENDIAN) {
                for (n6 = 0; n6 < pImage.width; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] >> 24 & 0xFF | nArray[n4] << 8 & 0xFFFFFF00;
                    nArray[n4] = n5 >> 24 & 0xFF | n5 << 8 & 0xFFFFFF00;
                    ++n3;
                    ++n4;
                }
            } else {
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] & 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    nArray[n4] = nArray[n4] & 0xFF000000 | n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF;
                    ++n3;
                    ++n4;
                }
            }
            n4 -= n * 2;
        }
    }

    public void updatePixels() {
        int n;
        int n2 = 0;
        int n3 = (this.height - 1) * this.width;
        for (n = 0; n < this.height / 2; ++n) {
            int n4;
            int n5;
            if (BIG_ENDIAN) {
                for (n5 = 0; n5 < this.width; ++n5) {
                    n4 = this.pixels[n2];
                    this.pixels[n2] = this.pixels[n3] << 8 & 0xFFFFFF00 | 0xFF;
                    this.pixels[n3] = n4 << 8 & 0xFFFFFF00 | 0xFF;
                    ++n2;
                    ++n3;
                }
            } else {
                for (n5 = 0; n5 < this.width; ++n5) {
                    n4 = this.pixels[n2];
                    this.pixels[n2] = 0xFF000000 | this.pixels[n3] << 16 & 0xFF0000 | this.pixels[n3] & 0xFF00 | this.pixels[n3] >> 16 & 0xFF;
                    this.pixels[n3] = 0xFF000000 | n4 << 16 & 0xFF0000 | n4 & 0xFF00 | n4 >> 16 & 0xFF;
                    ++n2;
                    ++n3;
                }
            }
            n3 -= this.width * 2;
        }
        this.pixelBuffer.put(this.pixels);
        this.pixelBuffer.rewind();
        this.copyToTexture(this.pixelBuffer);
        int n6 = n = !this.primarySurface && this.offscreenFramebuffer != currentFramebuffer ? 1 : 0;
        if (n != 0) {
            this.pushFramebuffer();
            this.setFramebuffer(this.offscreenFramebuffer);
        }
        this.drawTexture();
        if (n != 0) {
            this.popFramebuffer();
        }
    }

    public void loadTexture() {
        if (this.primarySurface && !fboSupported) {
            this.loadTextureImpl(2);
            this.loadPixels();
            this.pixelsToTexture();
        }
    }

    protected void loadTextureImpl(int n) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.texture == null) {
            PTexture.Parameters parameters = PTexture.newParameters(2, n);
            this.texture = new PTexture(this.parent, this.width, this.height, parameters);
            this.texture.setFlippedY(true);
            this.setCache(this.a3d, this.texture);
            this.setParams(this.a3d, parameters);
            this.texCrop = new int[4];
            this.texCrop[0] = 0;
            this.texCrop[1] = this.height;
            this.texCrop[2] = this.width;
            this.texCrop[3] = -this.height;
        }
    }

    public void updateTexture() {
        boolean bl;
        boolean bl2 = bl = !this.primarySurface && this.offscreenFramebuffer != currentFramebuffer;
        if (bl) {
            this.pushFramebuffer();
            this.setFramebuffer(this.offscreenFramebuffer);
        }
        this.drawTexture();
        if (bl) {
            this.popFramebuffer();
        }
    }

    protected void drawTexture() {
        this.drawTexture(this.texture, this.texCrop, 0, 0, this.width, this.height);
    }

    protected void copyToTexture(IntBuffer intBuffer) {
        this.copyToTexture(this.texture, intBuffer, 0, 0, this.width, this.height);
    }

    protected void copyFrameToTexture() {
        this.gl.glFinish();
        this.loadTexture();
    }

    protected void pixelsToTexture() {
        this.texture.set(this.pixels);
    }

    protected void textureToPixels() {
        this.texture.get(this.pixels);
    }

    public void resize(int n, int n2) {
        PGraphics.showMethodWarning("resize");
    }

    public int get(int n, int n2) {
        boolean bl;
        if (this.getsetBuffer == null) {
            this.getsetBuffer = IntBuffer.allocate(1);
            this.getsetBuffer.rewind();
        }
        boolean bl2 = bl = !this.primarySurface && this.offscreenFramebuffer != currentFramebuffer;
        if (bl) {
            this.pushFramebuffer();
            this.setFramebuffer(this.offscreenFramebuffer);
        }
        this.gl.glReadPixels(n, this.height - n2 - 1, 1, 1, 6408, 5121, (Buffer)this.getsetBuffer);
        if (bl) {
            this.popFramebuffer();
        }
        int n3 = this.getsetBuffer.get(0);
        if (BIG_ENDIAN) {
            return 0xFF000000 | n3 >> 8 & 0xFFFFFF;
        }
        return 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
    }

    protected PImage getImpl(int n, int n2, int n3, int n4) {
        boolean bl;
        PImage pImage = this.parent.createImage(n3, n4, 2);
        PTexture pTexture = this.addTexture(pImage);
        IntBuffer intBuffer = IntBuffer.allocate(n3 * n4);
        boolean bl2 = bl = !this.primarySurface && this.offscreenFramebuffer != currentFramebuffer;
        if (bl) {
            this.pushFramebuffer();
            this.setFramebuffer(this.offscreenFramebuffer);
        }
        this.gl.glReadPixels(n, this.height - n2 - n4, n3, n4, 6408, 5121, (Buffer)intBuffer);
        if (bl) {
            this.popFramebuffer();
        }
        this.copyToTexture(pTexture, intBuffer, 0, 0, n3, n4);
        pImage.loadPixels();
        pTexture.flippedY = true;
        pTexture.get(pImage.pixels);
        return pImage;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int n, int n2, int n3) {
        boolean bl;
        int n4 = 0;
        n4 = BIG_ENDIAN ? n3 << 8 | 0xFF : n3 & 0xFF00FF00 | n3 << 16 & 0xFF0000 | n3 >> 16 & 0xFF;
        if (this.getsetBuffer == null) {
            this.getsetBuffer = IntBuffer.allocate(1);
            this.getsetBuffer.rewind();
        }
        this.getsetBuffer.put(0, n4);
        this.getsetBuffer.rewind();
        if (this.getsetTexture == null) {
            this.getsetTexture = new PTexture(this.parent, 1, 1, new PTexture.Parameters(2, 2));
        }
        this.copyToTexture(this.getsetTexture, this.getsetBuffer, 0, 0, 1, 1);
        boolean bl2 = bl = !this.primarySurface && this.offscreenFramebuffer != currentFramebuffer;
        if (bl) {
            this.pushFramebuffer();
            this.setFramebuffer(this.offscreenFramebuffer);
        }
        this.drawTexture(this.getsetTexture, 0, 0, 1, 1, n, this.height - n2, 1, 1);
        if (bl) {
            this.popFramebuffer();
        }
    }

    public void set(int n, int n2, PImage pImage) {
        PTexture pTexture = (PTexture)pImage.getCache(this.a3d);
        if (pTexture != null) {
            boolean bl;
            int n3 = pImage.width;
            int n4 = pImage.height;
            boolean bl2 = bl = !this.primarySurface && this.offscreenFramebuffer != currentFramebuffer;
            if (bl) {
                this.pushFramebuffer();
                this.setFramebuffer(this.offscreenFramebuffer);
            }
            this.drawTexture(pTexture, 0, n4, n3, -n4, n, this.height - n2, n3, n4);
            if (bl) {
                this.popFramebuffer();
            }
        }
    }

    public void mask(int[] nArray) {
        PGraphics.showMethodWarning("mask");
    }

    public void mask(PImage pImage) {
        PGraphics.showMethodWarning("mask");
    }

    public void filter(int n) {
        PImage pImage = this.get();
        pImage.filter(n);
        this.set(0, 0, pImage);
    }

    public void filter(int n, float f) {
        PImage pImage = this.get();
        pImage.filter(n, f);
        this.set(0, 0, pImage);
    }

    public void screenBlend(int n) {
        this.screenBlendMode = n;
        this.gl.glEnable(3042);
        if (n == 0) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(1, 0);
        } else if (n == 1) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(770, 771);
        } else if (n == 2) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(770, 1);
        } else if (n == 4) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(775, 0);
        } else if (n == 8) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32776);
                this.gl.glBlendFunc(770, 772);
            } else {
                this.showBlendWarning("LIGHTEST");
            }
        } else if (n == 16) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32775);
                this.gl.glBlendFunc(770, 772);
            } else {
                this.showBlendWarning("DARKEST");
            }
        } else if (n == 32) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32779);
                this.gl.glBlendFunc(1, 1);
            } else {
                this.showBlendWarning("DIFFERENCE");
            }
        } else if (n == 64) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(775, 769);
        } else if (n == 128) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(774, 768);
        } else if (n == 256) {
            if (blendEqSupported) {
                this.gl11xp.glBlendEquation(32774);
            }
            this.gl.glBlendFunc(775, 1);
        }
    }

    void showBlendWarning(String string) {
        PGraphicsAndroid3D.showWarning("blendMode(" + string + ") is unsupported by this OpenGL implementation.");
    }

    public void textureBlend(int n) {
        this.texBlendMode = n;
    }

    protected void setTextureBlend(PTexture[] pTextureArray, int n) {
        if (2 < n) {
            PGraphics.showWarning("A3D: multitexture blending currently supports only two textures.");
            return;
        }
        if (!texenvCrossbarSupported) {
            PGraphics.showWarning("A3D: Texture environment crossbar not supported, so the textures won't be affected by tint or light.");
            if (this.texBlendMode == 0) {
                this.gl11.glActiveTexture(33984);
                this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
                this.gl11.glTexEnvi(8960, 8704, 7681);
                this.gl11.glActiveTexture(33985);
                this.gl11.glBindTexture(pTextureArray[1].glTarget, pTextureArray[1].glID);
                this.gl11.glTexEnvi(8960, 8704, 7681);
            } else if (this.texBlendMode == 1) {
                this.gl11.glActiveTexture(33984);
                this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
                this.gl11.glTexEnvi(8960, 8704, 7681);
                this.gl11.glActiveTexture(33985);
                this.gl11.glBindTexture(pTextureArray[1].glTarget, pTextureArray[1].glID);
                this.gl11.glTexEnvi(8960, 8704, 34160);
                this.gl11.glTexEnvi(8960, 34161, 34165);
                this.gl11.glTexEnvi(8960, 34176, 34168);
                this.gl11.glTexEnvi(8960, 34177, 5890);
                this.gl11.glTexEnvi(8960, 34178, 5890);
                this.gl11.glTexEnvi(8960, 34192, 768);
                this.gl11.glTexEnvi(8960, 34193, 768);
                this.gl11.glTexEnvi(8960, 34194, 771);
                this.gl11.glTexEnvi(8960, 34162, 34165);
                this.gl11.glTexEnvi(8960, 34184, 34168);
                this.gl11.glTexEnvi(8960, 34185, 5890);
                this.gl11.glTexEnvi(8960, 34186, 5890);
                this.gl11.glTexEnvi(8960, 34200, 770);
                this.gl11.glTexEnvi(8960, 34201, 770);
                this.gl11.glTexEnvi(8960, 34202, 771);
            } else if (this.texBlendMode == 128) {
                this.gl11.glActiveTexture(33984);
                this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
                this.gl11.glTexEnvi(8960, 8704, 7681);
                this.gl11.glActiveTexture(33985);
                this.gl11.glBindTexture(pTextureArray[1].glTarget, pTextureArray[1].glID);
                this.gl11.glTexEnvi(8960, 8704, 34160);
                this.gl11.glTexEnvi(8960, 34161, 8448);
                this.gl11.glTexEnvi(8960, 34176, 34168);
                this.gl11.glTexEnvi(8960, 34177, 5890);
                this.gl11.glTexEnvi(8960, 34192, 768);
                this.gl11.glTexEnvi(8960, 34193, 768);
                this.gl11.glTexEnvi(8960, 34162, 8448);
                this.gl11.glTexEnvi(8960, 34184, 34168);
                this.gl11.glTexEnvi(8960, 34185, 5890);
                this.gl11.glTexEnvi(8960, 34200, 770);
                this.gl11.glTexEnvi(8960, 34201, 770);
            } else if (this.texBlendMode == 2) {
                this.gl11.glActiveTexture(33984);
                this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
                this.gl11.glTexEnvi(8960, 8704, 7681);
                this.gl11.glActiveTexture(33985);
                this.gl11.glBindTexture(pTextureArray[1].glTarget, pTextureArray[1].glID);
                this.gl11.glTexEnvi(8960, 8704, 34160);
                this.gl11.glTexEnvi(8960, 34161, 260);
                this.gl11.glTexEnvi(8960, 34176, 34168);
                this.gl11.glTexEnvi(8960, 34177, 5890);
                this.gl11.glTexEnvi(8960, 34192, 768);
                this.gl11.glTexEnvi(8960, 34193, 768);
                this.gl11.glTexEnvi(8960, 34162, 260);
                this.gl11.glTexEnvi(8960, 34184, 34168);
                this.gl11.glTexEnvi(8960, 34185, 5890);
                this.gl11.glTexEnvi(8960, 34200, 770);
                this.gl11.glTexEnvi(8960, 34201, 770);
            } else if (this.texBlendMode == 4) {
                this.gl11.glActiveTexture(33984);
                this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
                this.gl11.glTexEnvi(8960, 8704, 7681);
                this.gl11.glActiveTexture(33985);
                this.gl11.glBindTexture(pTextureArray[1].glTarget, pTextureArray[1].glID);
                this.gl11.glTexEnvi(8960, 8704, 34160);
                this.gl11.glTexEnvi(8960, 34161, 34023);
                this.gl11.glTexEnvi(8960, 34176, 34168);
                this.gl11.glTexEnvi(8960, 34177, 5890);
                this.gl11.glTexEnvi(8960, 34192, 768);
                this.gl11.glTexEnvi(8960, 34193, 768);
                this.gl11.glTexEnvi(8960, 34162, 260);
                this.gl11.glTexEnvi(8960, 34184, 34168);
                this.gl11.glTexEnvi(8960, 34185, 5890);
                this.gl11.glTexEnvi(8960, 34200, 770);
                this.gl11.glTexEnvi(8960, 34201, 770);
            } else {
                PGraphics.showWarning("A3D: This blend mode is currently unsupported in multitexture mode.");
            }
        } else if (this.texBlendMode == 0) {
            this.gl11.glActiveTexture(33984);
            this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
            this.gl11.glTexEnvi(8960, 8704, 34160);
            this.gl11.glTexEnvi(8960, 34161, 7681);
            this.gl11.glTexEnvi(8960, 34176, 33985);
            this.gl11.glTexEnvi(8960, 34192, 768);
            this.gl11.glTexEnvi(8960, 34162, 7681);
            this.gl11.glTexEnvi(8960, 34184, 33985);
            this.gl11.glTexEnvi(8960, 34200, 770);
            this.modulateWithPrimaryColor(1, pTextureArray[1]);
        } else if (this.texBlendMode == 1) {
            this.gl11.glActiveTexture(33984);
            this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
            this.gl11.glTexEnvi(8960, 8704, 34160);
            this.gl11.glTexEnvi(8960, 34161, 34165);
            this.gl11.glTexEnvi(8960, 34176, 33984);
            this.gl11.glTexEnvi(8960, 34177, 33985);
            this.gl11.glTexEnvi(8960, 34178, 33985);
            this.gl11.glTexEnvi(8960, 34192, 768);
            this.gl11.glTexEnvi(8960, 34193, 768);
            this.gl11.glTexEnvi(8960, 34194, 771);
            this.gl11.glTexEnvi(8960, 34162, 34165);
            this.gl11.glTexEnvi(8960, 34184, 33984);
            this.gl11.glTexEnvi(8960, 34185, 33985);
            this.gl11.glTexEnvi(8960, 34186, 33985);
            this.gl11.glTexEnvi(8960, 34200, 770);
            this.gl11.glTexEnvi(8960, 34201, 770);
            this.gl11.glTexEnvi(8960, 34202, 771);
            this.modulateWithPrimaryColor(1, pTextureArray[1]);
        } else if (this.texBlendMode == 128) {
            this.gl11.glActiveTexture(33984);
            this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
            this.gl11.glTexEnvi(8960, 8704, 34160);
            this.gl11.glTexEnvi(8960, 34161, 8448);
            this.gl11.glTexEnvi(8960, 34176, 33984);
            this.gl11.glTexEnvi(8960, 34177, 33985);
            this.gl11.glTexEnvi(8960, 34192, 768);
            this.gl11.glTexEnvi(8960, 34193, 768);
            this.gl11.glTexEnvi(8960, 34162, 8448);
            this.gl11.glTexEnvi(8960, 34184, 33984);
            this.gl11.glTexEnvi(8960, 34185, 33985);
            this.gl11.glTexEnvi(8960, 34200, 770);
            this.gl11.glTexEnvi(8960, 34201, 770);
            this.modulateWithPrimaryColor(1, pTextureArray[1]);
        } else if (this.texBlendMode == 2) {
            this.gl11.glActiveTexture(33984);
            this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
            this.gl11.glTexEnvi(8960, 8704, 34160);
            this.gl11.glTexEnvi(8960, 34161, 260);
            this.gl11.glTexEnvi(8960, 34176, 33984);
            this.gl11.glTexEnvi(8960, 34177, 33985);
            this.gl11.glTexEnvi(8960, 34192, 768);
            this.gl11.glTexEnvi(8960, 34193, 768);
            this.gl11.glTexEnvi(8960, 34162, 260);
            this.gl11.glTexEnvi(8960, 34184, 33984);
            this.gl11.glTexEnvi(8960, 34185, 33985);
            this.gl11.glTexEnvi(8960, 34200, 770);
            this.gl11.glTexEnvi(8960, 34201, 770);
            this.modulateWithPrimaryColor(1, pTextureArray[1]);
        } else if (this.texBlendMode == 4) {
            this.gl11.glActiveTexture(33984);
            this.gl11.glBindTexture(pTextureArray[0].glTarget, pTextureArray[0].glID);
            this.gl11.glTexEnvi(8960, 8704, 34160);
            this.gl11.glTexEnvi(8960, 34161, 34023);
            this.gl11.glTexEnvi(8960, 34176, 33984);
            this.gl11.glTexEnvi(8960, 34177, 33985);
            this.gl11.glTexEnvi(8960, 34192, 768);
            this.gl11.glTexEnvi(8960, 34193, 768);
            this.gl11.glTexEnvi(8960, 34162, 34023);
            this.gl11.glTexEnvi(8960, 34184, 33984);
            this.gl11.glTexEnvi(8960, 34185, 33985);
            this.gl11.glTexEnvi(8960, 34200, 770);
            this.gl11.glTexEnvi(8960, 34201, 770);
            this.modulateWithPrimaryColor(1, pTextureArray[1]);
        } else {
            PGraphics.showWarning("A3D: This blend mode is currently unsupported in multitexture mode.");
        }
        this.gl.glDisable(3042);
    }

    protected void modulateWithPrimaryColor(int n, PTexture pTexture) {
        this.gl11.glActiveTexture(33984 + n);
        this.gl11.glBindTexture(pTexture.glTarget, pTexture.glID);
        this.gl11.glTexEnvi(8960, 8704, 34160);
        this.gl11.glTexEnvi(8960, 34161, 8448);
        this.gl11.glTexEnvi(8960, 34176, 34168);
        this.gl11.glTexEnvi(8960, 34177, 34167);
        this.gl11.glTexEnvi(8960, 34192, 768);
        this.gl11.glTexEnvi(8960, 34193, 768);
        this.gl11.glTexEnvi(8960, 34162, 7681);
        this.gl11.glTexEnvi(8960, 34184, 34168);
        this.gl11.glTexEnvi(8960, 34200, 770);
    }

    protected void cleanupTextureBlend(int n) {
        for (int i = 0; i < n; ++i) {
            this.gl11.glActiveTexture(33984 + i);
            this.gl11.glTexEnvi(8960, 8704, 8448);
        }
        this.screenBlend(this.screenBlendMode);
    }

    protected String[] getSupportedShapeFormats() {
        return new String[]{"obj"};
    }

    protected PShape loadShape(String string, Object object) {
        return new PShape3D(this.parent, string, (PShape3D.Parameters)object);
    }

    protected PShape createShape(int n, Object object) {
        return new PShape3D(this.parent, n, (PShape3D.Parameters)object);
    }

    void createOffscreenFramebuffer() {
        this.offscreenTexCrop = new int[4];
        this.offscreenTexCrop[0] = 0;
        this.offscreenTexCrop[1] = 0;
        this.offscreenTexCrop[2] = this.width;
        this.offscreenTexCrop[3] = this.height;
        this.offscreenImages = new PImage[2];
        this.offscreenParams = new PTexture.Parameters[2];
        if (this.primarySurface) {
            this.offscreenParams[0] = new PTexture.Parameters(2, 2);
            this.offscreenParams[1] = new PTexture.Parameters(2, 2);
            this.offscreenImages[0] = this.parent.createImage(this.width, this.height, 2, this.offscreenParams[0]);
            this.offscreenImages[1] = this.parent.createImage(this.width, this.height, 2, this.offscreenParams[1]);
        } else {
            this.offscreenParams[0] = new PTexture.Parameters(2, 3);
            this.offscreenParams[1] = new PTexture.Parameters(2, 3);
            this.offscreenImages[0] = this.parent.createImage(this.width, this.height, 2, this.offscreenParams[0]);
            this.offscreenImages[1] = this.parent.createImage(this.width, this.height, 2, this.offscreenParams[1]);
        }
        this.offscreenTextures = new PTexture[2];
        this.offscreenTextures[0] = this.addTexture(this.offscreenImages[0]);
        this.offscreenTextures[1] = this.addTexture(this.offscreenImages[1]);
        this.offscreenTextures[0].setFlippedY(true);
        this.offscreenTextures[1].setFlippedY(true);
        this.offscreenIndex = 0;
        this.offscreenFramebuffer = new PFramebuffer(this.parent, this.offscreenTextures[0].glWidth, this.offscreenTextures[0].glHeight, 1, 1, this.offscreenDepthBits, this.offscreenStencilBits, false);
        this.texture = this.offscreenTextures[this.offscreenIndex];
        this.setCache(this.a3d, this.offscreenTextures[this.offscreenIndex]);
        this.setParams(this.a3d, this.offscreenParams[this.offscreenIndex]);
    }

    protected void drawOffscreenTexture(int n) {
        this.drawTexture(this.offscreenTextures[n], this.offscreenTexCrop, 0, 0, this.width, this.height);
    }

    protected void swapOffscreenIndex() {
        this.offscreenIndex = (this.offscreenIndex + 1) % 2;
        this.texture = this.offscreenTextures[this.offscreenIndex];
        this.setCache(this.a3d, this.offscreenTextures[this.offscreenIndex]);
        this.setParams(this.a3d, this.offscreenParams[this.offscreenIndex]);
    }

    public PTexture getTexture() {
        this.loadTexture();
        return this.texture;
    }

    public PTexture getTexture(PImage pImage) {
        PTexture pTexture = (PTexture)pImage.getCache(this.a3d);
        if (pTexture == null) {
            pTexture = this.addTexture(pImage);
        } else if (pImage.isModified()) {
            this.updateTexture(pImage, pTexture);
        }
        return pTexture;
    }

    protected PTexture addTexture(PImage pImage) {
        PTexture.Parameters parameters = (PTexture.Parameters)pImage.getParams(this.a3d);
        if (parameters == null) {
            parameters = PTexture.newParameters();
            pImage.setParams(this.a3d, parameters);
        }
        PTexture pTexture = new PTexture(pImage.parent, pImage.width, pImage.height, parameters);
        if (pImage.pixels == null) {
            pImage.loadPixels();
        }
        pTexture.set(pImage.pixels);
        pImage.setCache(this.a3d, pTexture);
        return pTexture;
    }

    protected void updateTexture(PImage pImage, PTexture pTexture) {
        if (pTexture != null) {
            int n = pImage.getModifiedX1();
            int n2 = pImage.getModifiedY1();
            int n3 = pImage.getModifiedX2() - n;
            int n4 = pImage.getModifiedY2() - n2;
            pTexture.set(pImage.pixels, n, n2, n3, n4, pImage.format);
        }
        pImage.setModified(false);
    }

    protected void drawTexture(PTexture pTexture, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int[] nArray = new int[]{n, n2, n3, n4};
        this.drawTexture(pTexture, nArray, n5, n6, n7, n8);
    }

    protected void drawTexture(PTexture pTexture, int[] nArray, int n, int n2, int n3, int n4) {
        this.drawTexture(pTexture.glTarget, pTexture.glID, nArray, n, n2, n3, n4);
    }

    protected void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int[] nArray = new int[]{n3, n4, n5, n6};
        this.drawTexture(n, n2, nArray, n7, n8, n9, n10);
    }

    protected void drawTexture(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6) {
        this.gl.glEnable(n);
        this.gl.glBindTexture(n, n2);
        this.gl.glDisable(3042);
        this.gl.glTexEnvf(8960, 8704, 7681.0f);
        this.drawTexture(nArray, n3, n4, n5, n6);
        this.gl.glTexEnvf(8960, 8704, 8448.0f);
        this.gl.glBindTexture(n, 0);
        this.gl.glDisable(n);
        this.screenBlend(this.screenBlendMode);
    }

    protected void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int[] nArray = new int[]{n, n2, n3, n4};
        this.drawTexture(nArray, n5, n6, n7, n8);
    }

    protected void drawTexture(int[] nArray, int n, int n2, int n3, int n4) {
        this.gl.glDepthMask(false);
        this.gl11.glTexParameteriv(3553, 35741, nArray, 0);
        this.gl11x.glDrawTexiOES(n, n2, 0, n3, n4);
        if (this.hints[8]) {
            this.gl.glDepthMask(false);
        } else {
            this.gl.glDepthMask(true);
        }
    }

    protected void copyToTexture(PTexture pTexture, IntBuffer intBuffer, int n, int n2, int n3, int n4) {
        this.gl.glEnable(pTexture.glTarget);
        this.gl.glBindTexture(pTexture.glTarget, pTexture.glID);
        this.gl.glTexSubImage2D(pTexture.glTarget, 0, n, n2, n3, n4, 6408, 5121, (Buffer)intBuffer);
        this.gl.glBindTexture(pTexture.glTarget, 0);
        this.gl.glDisable(pTexture.glTarget);
    }

    protected void setSurfaceParams() {
        this.gl.glShadeModel(7425);
        this.gl.glEnable(2903);
        this.gl.glEnable(2977);
        this.gl.glEnable(32826);
        this.gl.glLightModelfv(2899, this.baseLight, 0);
        this.gl.glLightModelx(2898, 0);
    }

    protected void saveGLMatrices() {
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
    }

    protected void restoreGLMatrices() {
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
    }

    protected void setDefNormals(float f, float f2, float f3) {
        this.gl.glNormal3f(f, f2, f3);
    }

    protected void initPrimary() {
        if (this.parent.frameCount == 0) {
            if (fboSupported) {
                if (this.offscreenFramebuffer == null) {
                    this.createOffscreenFramebuffer();
                }
            } else {
                if (this.gl11 == null || this.gl11x == null) {
                    throw new RuntimeException("A3D: no clear mode without FBOs requires OpenGL ES 1.1");
                }
                if (this.texture == null) {
                    this.loadTextureImpl(2);
                }
            }
        }
        if (this.clearColorBuffer) {
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(16640);
        } else if (fboSupported) {
            if (this.offscreenFramebuffer != null) {
                this.pushFramebuffer();
                this.setFramebuffer(this.offscreenFramebuffer);
                this.offscreenFramebuffer.setColorBuffer(this.offscreenTextures[this.offscreenIndex]);
                this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                if (this.parent.frameCount == 0) {
                    this.gl.glClear(16640);
                } else {
                    this.gl.glClear(256);
                    this.drawOffscreenTexture((this.offscreenIndex + 1) % 2);
                }
            }
        } else if (this.texture != null) {
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.gl.glClear(16640);
            if (0 < this.parent.frameCount) {
                this.drawTexture();
            }
        }
    }

    protected void initOffscreen() {
        if (this.offscreenFramebuffer == null) {
            this.createOffscreenFramebuffer();
        }
        this.pushFramebuffer();
        this.setFramebuffer(this.offscreenFramebuffer);
        this.offscreenFramebuffer.setColorBuffer(this.offscreenTextures[this.offscreenIndex]);
        this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.clearColorBuffer || this.parent.frameCount == 0) {
            this.gl.glClear(16640);
        } else {
            this.gl.glClear(256);
            this.drawOffscreenTexture((this.offscreenIndex + 1) % 2);
        }
    }

    public static int toFixed32(float f) {
        return (int)(f * 65536.0f);
    }

    public static int toFixed16(float f) {
        return (int)(f * 4096.0f);
    }

    public static float toFloat32(int n) {
        return (float)n / 65536.0f;
    }

    public static float toFloat16(int n) {
        return (float)n / 4096.0f;
    }

    public GLSurfaceView.Renderer getRenderer() {
        return this.renderer;
    }

    public GLSurfaceView.EGLConfigChooser getConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        A3DConfigChooser a3DConfigChooser = new A3DConfigChooser(n, n2, n3, n4, n5, n6);
        return a3DConfigChooser;
    }

    public GLSurfaceView.EGLContextFactory getContextFactory() {
        A3DContextFactory a3DContextFactory = new A3DContextFactory();
        return a3DContextFactory;
    }

    static {
        pGraphicsAndroid3DObjects = new HashSet<PGraphicsAndroid3D>();
        pTextureObjects = new HashSet<PTexture>();
        pFramebufferObjects = new HashSet<PFramebuffer>();
        pShape3DObjects = new HashSet<PShape3D>();
        pFontTextureObjects = new HashSet<PFontTexture>();
        glTextureObjects = new HashSet<Integer>();
        glVertexBuffers = new HashSet<Integer>();
        glFrameBuffers = new HashSet<Integer>();
        glRenderBuffers = new HashSet<Integer>();
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    public class A3DContextFactory
    implements GLSurfaceView.EGLContextFactory {
        public int EGL_CONTEXT_CLIENT_VERSION = 12440;

        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, 1, 12344};
            EGLContext eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray);
            return eGLContext;
        }

        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            eGL10.eglDestroyContext(eGLDisplay, eGLContext);
        }
    }

    public class A3DConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        public int redTarget;
        public int greenTarget;
        public int blueTarget;
        public int alphaTarget;
        public int depthTarget;
        public int stencilTarget;
        public int redBits;
        public int greenBits;
        public int blueBits;
        public int alphaBits;
        public int depthBits;
        public int stencilBits;
        public int[] tempValue = new int[1];
        private int EGL_OPENGL_ES_BIT = 1;
        private int[] configAttribsGL = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, this.EGL_OPENGL_ES_BIT, 12344};

        public A3DConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            this.redTarget = n;
            this.greenTarget = n2;
            this.blueTarget = n3;
            this.alphaTarget = n4;
            this.depthTarget = n5;
            this.stencilTarget = n6;
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, this.configAttribsGL, null, 0, nArray);
            int n = nArray[0];
            if (n <= 0) {
                throw new IllegalArgumentException("No EGL configs match configSpec");
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            eGL10.eglChooseConfig(eGLDisplay, this.configAttribsGL, eGLConfigArray, n, nArray);
            return this.chooseBestConfig(eGL10, eGLDisplay, eGLConfigArray);
        }

        public EGLConfig chooseBestConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            EGLConfig eGLConfig = null;
            float f = 1000.0f;
            for (EGLConfig eGLConfig2 : eGLConfigArray) {
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12325, 0);
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12326, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12324, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12323, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12322, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12321, 0);
                float f2 = 0.2f * (float)PApplet.abs(n3 - this.redTarget) + 0.2f * (float)PApplet.abs(n4 - this.greenTarget) + 0.2f * (float)PApplet.abs(n5 - this.blueTarget) + 0.15f * (float)PApplet.abs(n6 - this.blueTarget) + 0.15f * (float)PApplet.abs(n - this.depthTarget) + 0.1f * (float)PApplet.abs(n2 - this.stencilTarget);
                if (!(f2 < f)) continue;
                eGLConfig = eGLConfig2;
                f = f2;
                this.redBits = n3;
                this.greenBits = n4;
                this.blueBits = n5;
                this.alphaBits = n6;
                this.depthBits = n;
                this.stencilBits = n2;
                PGraphicsAndroid3D.this.offscreenDepthBits = n;
                PGraphicsAndroid3D.this.offscreenStencilBits = n2;
            }
            return eGLConfig;
        }

        protected String printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
            int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
            int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
            int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
            int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
            int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
            int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12352, 0);
            int n8 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12333, 0);
            int n9 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12320, 0);
            int n10 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12422, 0);
            return String.format("EGLConfig rgba=%d%d%d%d depth=%d stencil=%d", n, n2, n3, n4, n5, n6) + " type=" + n7 + " native=" + n8 + " buffer size=" + n9 + " buffer surface=" + n10 + String.format(" caveat=0x%04x", this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12327, 0));
        }

        protected int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.tempValue)) {
                return this.tempValue[0];
            }
            return n2;
        }
    }

    public class A3DRenderer
    implements GLSurfaceView.Renderer {
        public void onDrawFrame(GL10 gL10) {
            PGraphicsAndroid3D.this.gl = gL10;
            try {
                PGraphicsAndroid3D.this.gl11 = (GL11)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11 = null;
            }
            try {
                PGraphicsAndroid3D.this.gl11x = (GL11Ext)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11x = null;
            }
            try {
                PGraphicsAndroid3D.this.gl11xp = (GL11ExtensionPack)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11xp = null;
            }
            PGraphicsAndroid3D.this.parent.handleDraw();
        }

        public void onSurfaceChanged(GL10 gL10, int n, int n2) {
            PGraphicsAndroid3D.this.gl = gL10;
            try {
                PGraphicsAndroid3D.this.gl11 = (GL11)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11 = null;
            }
            try {
                PGraphicsAndroid3D.this.gl11x = (GL11Ext)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11x = null;
            }
            try {
                PGraphicsAndroid3D.this.gl11xp = (GL11ExtensionPack)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11xp = null;
            }
            PGraphicsAndroid3D.this.setSize(n, n2);
        }

        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            PGraphicsAndroid3D.this.gl = gL10;
            try {
                PGraphicsAndroid3D.this.gl11 = (GL11)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11 = null;
            }
            try {
                PGraphicsAndroid3D.this.gl11x = (GL11Ext)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11x = null;
            }
            try {
                PGraphicsAndroid3D.this.gl11xp = (GL11ExtensionPack)PGraphicsAndroid3D.this.gl;
            }
            catch (ClassCastException classCastException) {
                PGraphicsAndroid3D.this.gl11xp = null;
            }
            if (!glParamsRead) {
                this.getGLParameters();
            }
        }

        protected void getGLParameters() {
            OPENGL_VENDOR = PGraphicsAndroid3D.this.gl.glGetString(7936);
            OPENGL_RENDERER = PGraphicsAndroid3D.this.gl.glGetString(7937);
            OPENGL_VERSION = PGraphicsAndroid3D.this.gl.glGetString(7938);
            npotTexSupported = false;
            mipmapGeneration = false;
            matrixGetSupported = false;
            texenvCrossbarSupported = false;
            vboSupported = false;
            fboSupported = false;
            OPENGL_EXTENSIONS = PGraphicsAndroid3D.this.gl.glGetString(7939);
            if (-1 < OPENGL_EXTENSIONS.indexOf("texture_non_power_of_two")) {
                npotTexSupported = true;
            }
            if (-1 < OPENGL_EXTENSIONS.indexOf("generate_mipmap")) {
                mipmapGeneration = true;
            }
            if (-1 < OPENGL_EXTENSIONS.indexOf("matrix_get")) {
                matrixGetSupported = true;
            }
            if (-1 < OPENGL_EXTENSIONS.indexOf("texture_env_crossbar")) {
                texenvCrossbarSupported = true;
            }
            if (-1 < OPENGL_EXTENSIONS.indexOf("vertex_buffer_object") || -1 < OPENGL_VERSION.indexOf("1.1") || -1 < OPENGL_VERSION.indexOf("2.")) {
                vboSupported = true;
            }
            if (-1 < OPENGL_EXTENSIONS.indexOf("framebuffer_object") && PGraphicsAndroid3D.this.gl11xp != null) {
                try {
                    PGraphicsAndroid3D.this.gl11xp.glCheckFramebufferStatusOES(36160);
                    fboSupported = true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    fboSupported = false;
                }
            }
            if (PGraphicsAndroid3D.this.gl11xp != null) {
                try {
                    PGraphicsAndroid3D.this.gl11xp.glBlendEquation(32774);
                    blendEqSupported = true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    blendEqSupported = false;
                }
            } else {
                blendEqSupported = false;
            }
            usingGLMatrixStack = PGraphicsAndroid3D.this.gl11 == null || !matrixGetSupported;
            int[] nArray = new int[2];
            PGraphicsAndroid3D.this.gl.glGetIntegerv(3379, nArray, 0);
            maxTextureSize = nArray[0];
            PGraphicsAndroid3D.this.gl.glGetIntegerv(33902, nArray, 0);
            maxLineWidth = nArray[1];
            PGraphicsAndroid3D.this.gl.glGetIntegerv(33901, nArray, 0);
            maxPointSize = nArray[1];
            PGraphicsAndroid3D.this.gl.glGetIntegerv(34018, nArray, 0);
            maxTextureUnits = PApplet.min(2, nArray[0]);
            glParamsRead = true;
        }
    }

    protected class GLMatrixStack {
        protected Stack<float[]> matrixStack = new Stack();
        protected float[] current = new float[16];

        public GLMatrixStack() {
            this.setIdentity();
        }

        public void setIdentity() {
            this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        public void push() {
            float[] fArray = new float[16];
            PApplet.arrayCopy(this.current, fArray);
            this.matrixStack.push(fArray);
        }

        public void pop() {
            try {
                float[] fArray = this.matrixStack.pop();
                PApplet.arrayCopy(fArray, this.current);
            }
            catch (EmptyStackException emptyStackException) {
                PGraphics.showWarning("A3D: Empty modelview stack");
            }
        }

        public void mult(float[] fArray) {
            this.mult(fArray[0], fArray[4], fArray[8], fArray[12], fArray[1], fArray[5], fArray[9], fArray[13], fArray[2], fArray[6], fArray[10], fArray[14], fArray[3], fArray[7], fArray[11], fArray[15]);
        }

        public void mult(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
            float f17 = this.current[0] * f + this.current[4] * f5 + this.current[8] * f9 + this.current[12] * f13;
            float f18 = this.current[0] * f2 + this.current[4] * f6 + this.current[8] * f10 + this.current[12] * f14;
            float f19 = this.current[0] * f3 + this.current[4] * f7 + this.current[8] * f11 + this.current[12] * f15;
            float f20 = this.current[0] * f4 + this.current[4] * f8 + this.current[8] * f12 + this.current[12] * f16;
            float f21 = this.current[1] * f + this.current[5] * f5 + this.current[9] * f9 + this.current[13] * f13;
            float f22 = this.current[1] * f2 + this.current[5] * f6 + this.current[9] * f10 + this.current[13] * f14;
            float f23 = this.current[1] * f3 + this.current[5] * f7 + this.current[9] * f11 + this.current[13] * f15;
            float f24 = this.current[1] * f4 + this.current[5] * f8 + this.current[9] * f12 + this.current[13] * f16;
            float f25 = this.current[2] * f + this.current[6] * f5 + this.current[10] * f9 + this.current[14] * f13;
            float f26 = this.current[2] * f2 + this.current[6] * f6 + this.current[10] * f10 + this.current[14] * f14;
            float f27 = this.current[2] * f3 + this.current[6] * f7 + this.current[10] * f11 + this.current[14] * f15;
            float f28 = this.current[2] * f4 + this.current[6] * f8 + this.current[10] * f12 + this.current[14] * f16;
            float f29 = this.current[3] * f + this.current[7] * f5 + this.current[11] * f9 + this.current[15] * f13;
            float f30 = this.current[3] * f2 + this.current[7] * f6 + this.current[11] * f10 + this.current[15] * f14;
            float f31 = this.current[3] * f3 + this.current[7] * f7 + this.current[11] * f11 + this.current[15] * f15;
            float f32 = this.current[3] * f4 + this.current[7] * f8 + this.current[11] * f12 + this.current[15] * f16;
            this.current[0] = f17;
            this.current[4] = f18;
            this.current[8] = f19;
            this.current[12] = f20;
            this.current[1] = f21;
            this.current[5] = f22;
            this.current[9] = f23;
            this.current[13] = f24;
            this.current[2] = f25;
            this.current[6] = f26;
            this.current[10] = f27;
            this.current[14] = f28;
            this.current[3] = f29;
            this.current[7] = f30;
            this.current[11] = f31;
            this.current[15] = f32;
        }

        public void get(float[] fArray) {
            PApplet.arrayCopy(this.current, fArray);
        }

        public void set(float[] fArray) {
            PApplet.arrayCopy(fArray, this.current);
        }

        public void set(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
            this.current[0] = f;
            this.current[4] = f2;
            this.current[8] = f3;
            this.current[12] = f4;
            this.current[1] = f5;
            this.current[5] = f6;
            this.current[9] = f7;
            this.current[13] = f8;
            this.current[2] = f9;
            this.current[6] = f10;
            this.current[10] = f11;
            this.current[14] = f12;
            this.current[3] = f13;
            this.current[7] = f14;
            this.current[11] = f15;
            this.current[15] = f16;
        }

        public void translate(float f, float f2, float f3) {
            this.current[12] = this.current[12] + (f * this.current[0] + f2 * this.current[4] + f3 * this.current[8]);
            this.current[13] = this.current[13] + (f * this.current[1] + f2 * this.current[5] + f3 * this.current[9]);
            this.current[14] = this.current[14] + (f * this.current[2] + f2 * this.current[6] + f3 * this.current[10]);
            this.current[15] = this.current[15] + (f * this.current[3] + f2 * this.current[7] + f3 * this.current[11]);
        }

        public void rotate(float f, float f2, float f3, float f4) {
            float f5 = PApplet.cos(f);
            float f6 = PApplet.sin(f);
            float f7 = 1.0f - f5;
            this.mult(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }

        public void scale(float f, float f2, float f3) {
            this.current[0] = this.current[0] * f;
            this.current[4] = this.current[4] * f2;
            this.current[8] = this.current[8] * f3;
            this.current[1] = this.current[1] * f;
            this.current[5] = this.current[5] * f2;
            this.current[9] = this.current[9] * f3;
            this.current[2] = this.current[2] * f;
            this.current[6] = this.current[6] * f2;
            this.current[10] = this.current[10] * f3;
            this.current[3] = this.current[3] * f;
            this.current[7] = this.current[7] * f2;
            this.current[11] = this.current[11] * f3;
        }
    }

    protected class DrawingState {
        int tMode0;
        boolean auto0;
        boolean stroke0;
        int cMode0;
        boolean merge0;
        float specularR0;
        float specularG0;
        float specularB0;
        float ambientR0;
        float ambientG0;
        float ambientB0;
        boolean fill0;
        float fillR0;
        float fillG0;
        float fillB0;
        float fillA0;
        int fillRi0;
        int fillGi0;
        int fillBi0;
        int fillAi0;
        int fillColor0;
        boolean fillAlpha0;
        boolean tint0;
        float tintR0;
        float tintG0;
        float tintB0;
        float tintA0;
        int tintRi0;
        int tintGi0;
        int tintBi0;
        int tintAi0;
        int tintColor0;
        boolean tintAlpha0;
        float shininess0;

        DrawingState() {
        }

        void save() {
            this.tMode0 = PGraphicsAndroid3D.this.textureMode;
            this.auto0 = PGraphicsAndroid3D.this.autoNormal;
            this.stroke0 = PGraphicsAndroid3D.this.stroke;
            this.cMode0 = PGraphicsAndroid3D.this.colorMode;
            this.merge0 = PGraphicsAndroid3D.this.mergeRecShapes;
            this.specularR0 = PGraphicsAndroid3D.this.specularR;
            this.specularG0 = PGraphicsAndroid3D.this.specularG;
            this.specularB0 = PGraphicsAndroid3D.this.specularB;
            this.ambientR0 = PGraphicsAndroid3D.this.ambientR;
            this.ambientG0 = PGraphicsAndroid3D.this.ambientG;
            this.ambientB0 = PGraphicsAndroid3D.this.ambientB;
            this.fill0 = PGraphicsAndroid3D.this.fill;
            this.fillR0 = PGraphicsAndroid3D.this.fillR;
            this.fillG0 = PGraphicsAndroid3D.this.fillG;
            this.fillB0 = PGraphicsAndroid3D.this.fillB;
            this.fillA0 = PGraphicsAndroid3D.this.fillA;
            this.fillRi0 = PGraphicsAndroid3D.this.fillRi;
            this.fillGi0 = PGraphicsAndroid3D.this.fillGi;
            this.fillBi0 = PGraphicsAndroid3D.this.fillBi;
            this.fillAi0 = PGraphicsAndroid3D.this.fillAi;
            this.fillColor0 = PGraphicsAndroid3D.this.fillColor;
            this.fillAlpha0 = PGraphicsAndroid3D.this.fillAlpha;
            this.tint0 = PGraphicsAndroid3D.this.tint;
            this.tintR0 = PGraphicsAndroid3D.this.tintR;
            this.tintG0 = PGraphicsAndroid3D.this.tintG;
            this.tintB0 = PGraphicsAndroid3D.this.tintB;
            this.tintA0 = PGraphicsAndroid3D.this.tintA;
            this.tintRi0 = PGraphicsAndroid3D.this.tintRi;
            this.tintGi0 = PGraphicsAndroid3D.this.tintGi;
            this.tintBi0 = PGraphicsAndroid3D.this.tintBi;
            this.tintAi0 = PGraphicsAndroid3D.this.tintAi;
            this.tintColor0 = PGraphicsAndroid3D.this.tintColor;
            this.tintAlpha0 = PGraphicsAndroid3D.this.tintAlpha;
            this.shininess0 = PGraphicsAndroid3D.this.shininess;
        }

        void restore() {
            PGraphicsAndroid3D.this.textureMode = this.tMode0;
            PGraphicsAndroid3D.this.colorMode = this.cMode0;
            PGraphicsAndroid3D.this.autoNormal = this.auto0;
            PGraphicsAndroid3D.this.stroke = this.stroke0;
            PGraphicsAndroid3D.this.mergeRecShapes = this.merge0;
            PGraphicsAndroid3D.this.calcR = this.specularR0;
            PGraphicsAndroid3D.this.calcG = this.specularG0;
            PGraphicsAndroid3D.this.calcB = this.specularB0;
            PGraphicsAndroid3D.this.specularFromCalc();
            PGraphicsAndroid3D.this.calcR = this.ambientR0;
            PGraphicsAndroid3D.this.calcG = this.ambientG0;
            PGraphicsAndroid3D.this.calcB = this.ambientB0;
            PGraphicsAndroid3D.this.ambientFromCalc();
            if (!this.fill0) {
                PGraphicsAndroid3D.this.noFill();
            } else {
                PGraphicsAndroid3D.this.calcR = this.fillR0;
                PGraphicsAndroid3D.this.calcG = this.fillG0;
                PGraphicsAndroid3D.this.calcB = this.fillB0;
                PGraphicsAndroid3D.this.calcA = this.fillA0;
                PGraphicsAndroid3D.this.calcRi = this.fillRi0;
                PGraphicsAndroid3D.this.calcGi = this.fillGi0;
                PGraphicsAndroid3D.this.calcBi = this.fillBi0;
                PGraphicsAndroid3D.this.calcAi = this.fillAi0;
                PGraphicsAndroid3D.this.calcColor = this.fillColor0;
                PGraphicsAndroid3D.this.calcAlpha = this.fillAlpha0;
                PGraphicsAndroid3D.this.fillFromCalc();
            }
            if (!this.tint0) {
                PGraphicsAndroid3D.this.noTint();
            } else {
                PGraphicsAndroid3D.this.calcR = this.tintR0;
                PGraphicsAndroid3D.this.calcG = this.tintG0;
                PGraphicsAndroid3D.this.calcB = this.tintB0;
                PGraphicsAndroid3D.this.calcA = this.tintA0;
                PGraphicsAndroid3D.this.calcRi = this.tintRi0;
                PGraphicsAndroid3D.this.calcGi = this.tintGi0;
                PGraphicsAndroid3D.this.calcBi = this.tintBi0;
                PGraphicsAndroid3D.this.calcAi = this.tintAi0;
                PGraphicsAndroid3D.this.calcColor = this.tintColor0;
                PGraphicsAndroid3D.this.calcAlpha = this.tintAlpha0;
                PGraphicsAndroid3D.this.tintFromCalc();
            }
            PGraphicsAndroid3D.this.shininess(this.shininess0);
        }
    }

    protected class GeometryBuffer {
        int mode;
        int idxCount;
        int vertCount;
        int texCount;
        short[] indicesArray;
        int[] verticesArray;
        int[] normalsArray;
        int[] colorsArray;
        int[][] texcoordsArray;
        PTexture[] texturesArray;
        int minVertIndex;
        int maxVertIndex;
        int size;
        GLMatrixStack stack;
        ShortBuffer indicesBuffer;
        IntBuffer verticesBuffer;
        IntBuffer normalsBuffer;
        IntBuffer colorsBuffer;
        IntBuffer[] texcoordsBuffer;
        int allocTexStorage;

        GeometryBuffer() {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.indicesBuffer = byteBuffer.asShortBuffer();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(6144);
            byteBuffer2.order(ByteOrder.nativeOrder());
            this.verticesBuffer = byteBuffer2.asIntBuffer();
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(8192);
            byteBuffer3.order(ByteOrder.nativeOrder());
            this.colorsBuffer = byteBuffer3.asIntBuffer();
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(6144);
            byteBuffer4.order(ByteOrder.nativeOrder());
            this.normalsBuffer = byteBuffer4.asIntBuffer();
            this.texcoordsBuffer = new IntBuffer[2];
            ByteBuffer byteBuffer5 = ByteBuffer.allocateDirect(4096);
            byteBuffer5.order(ByteOrder.nativeOrder());
            this.texcoordsBuffer[0] = byteBuffer5.asIntBuffer();
            this.indicesArray = new short[256];
            this.verticesArray = new int[1536];
            this.colorsArray = new int[2048];
            this.normalsArray = new int[1536];
            this.texcoordsArray = new int[1][1024];
            this.texturesArray = new PTexture[2];
            this.allocTexStorage = 1;
            this.stack = new GLMatrixStack();
            this.idxCount = 0;
            this.vertCount = 0;
            this.texCount = 0;
        }

        void init(int n) {
            this.init(n, null, 0);
        }

        void init(int n, PTexture[] pTextureArray, int n2) {
            this.setTextures(pTextureArray, n2);
            this.indicesBuffer.rewind();
            this.verticesBuffer.rewind();
            this.colorsBuffer.rewind();
            this.normalsBuffer.rewind();
            for (int i = 0; i < this.texCount; ++i) {
                this.texcoordsBuffer[i].rewind();
            }
            this.idxCount = 0;
            this.vertCount = 0;
            this.minVertIndex = 100000;
            this.maxVertIndex = 0;
            this.stack.setIdentity();
        }

        boolean newTextures(PTexture[] pTextureArray, int n) {
            if (n == this.texCount) {
                for (int i = 0; i < this.texCount; ++i) {
                    if (pTextureArray[i] == this.texturesArray[i]) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        void setTextures(PTexture[] pTextureArray, int n) {
            if (pTextureArray == null || n == 0) {
                this.texCount = 0;
            } else {
                this.texCount = n;
                PApplet.arrayCopy(pTextureArray, this.texturesArray, n);
            }
            if (this.allocTexStorage < this.texCount) {
                int n2 = this.texCount - this.allocTexStorage;
                int n3 = this.texcoordsBuffer[this.allocTexStorage - 1].capacity();
                for (int i = 0; i < n2; ++i) {
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3 * 4);
                    byteBuffer.order(ByteOrder.nativeOrder());
                    this.texcoordsBuffer[this.allocTexStorage + i] = byteBuffer.asIntBuffer();
                }
                this.texcoordsArray = new int[this.allocTexStorage + n2][n3];
                this.allocTexStorage += n2;
            }
        }

        void add(int[][] nArray, int n, int n2, float[][] fArray, int n3, int n4) {
            this.add(nArray, n, n2, fArray, n3, n4, this.stack.current);
        }

        void add(int[][] nArray, int n, int n2, float[][] fArray, int n3, int n4, float[] fArray2) {
            int n5;
            int n6;
            int n7;
            int n8;
            Buffer buffer;
            int n9 = n2 - n + 1;
            int n10 = n4 - n3 + 1;
            int n11 = 0;
            ShortBuffer shortBuffer = this.indicesBuffer;
            while (this.indicesBuffer.capacity() < this.idxCount + 3 * n9) {
                int n12 = this.indicesBuffer.capacity() << 1;
                buffer = ByteBuffer.allocateDirect(n12 * 4);
                ((ByteBuffer)buffer).order(ByteOrder.nativeOrder());
                this.indicesBuffer = ((ByteBuffer)buffer).asShortBuffer();
                this.indicesArray = new short[n12];
                ++n11;
            }
            if (0 < n11) {
                shortBuffer.position(0);
                this.indicesBuffer.position(0);
                this.indicesBuffer.put(shortBuffer);
                this.indicesBuffer.position(this.idxCount);
                shortBuffer = null;
            }
            n11 = 0;
            IntBuffer intBuffer = this.verticesBuffer;
            buffer = this.colorsBuffer;
            IntBuffer intBuffer2 = this.normalsBuffer;
            IntBuffer[] intBufferArray = new IntBuffer[this.texCount];
            for (n8 = 0; n8 < this.texCount; ++n8) {
                intBufferArray[n8] = this.texcoordsBuffer[n8];
            }
            while (this.verticesBuffer.capacity() / 3 < this.vertCount + n10) {
                n8 = this.verticesBuffer.capacity() / 3 << 1;
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n8 * 3 * 4);
                byteBuffer.order(ByteOrder.nativeOrder());
                this.verticesBuffer = byteBuffer.asIntBuffer();
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n8 * 4 * 4);
                byteBuffer2.order(ByteOrder.nativeOrder());
                this.colorsBuffer = byteBuffer2.asIntBuffer();
                ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(n8 * 3 * 4);
                byteBuffer3.order(ByteOrder.nativeOrder());
                this.normalsBuffer = byteBuffer3.asIntBuffer();
                for (n7 = 0; n7 < this.texCount; ++n7) {
                    ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(n8 * 2 * 4);
                    byteBuffer4.order(ByteOrder.nativeOrder());
                    this.texcoordsBuffer[n7] = byteBuffer4.asIntBuffer();
                }
                this.verticesArray = new int[n8 * 3];
                this.colorsArray = new int[n8 * 4];
                this.normalsArray = new int[n8 * 3];
                for (n7 = 0; n7 < this.texCount; ++n7) {
                    this.texcoordsArray[n7] = new int[n8 * 2];
                }
                ++n11;
            }
            if (0 < n11) {
                intBuffer.position(0);
                this.verticesBuffer.position(0);
                this.verticesBuffer.put(intBuffer);
                intBuffer = null;
                this.verticesBuffer.position(3 * this.vertCount);
                ((IntBuffer)buffer).position(0);
                this.colorsBuffer.position(0);
                this.colorsBuffer.put((IntBuffer)buffer);
                buffer = null;
                this.colorsBuffer.position(4 * this.vertCount);
                intBuffer2.position(0);
                this.normalsBuffer.position(0);
                this.normalsBuffer.put(intBuffer2);
                intBuffer2 = null;
                this.normalsBuffer.position(3 * this.vertCount);
                for (n8 = 0; n8 < this.texCount; ++n8) {
                    intBufferArray[n8].position(0);
                    this.texcoordsBuffer[n8].position(0);
                    this.texcoordsBuffer[n8].put(intBufferArray[n8]);
                    intBufferArray[n8] = null;
                    this.texcoordsBuffer[n8].position(3 * this.vertCount);
                }
            }
            n8 = 0;
            for (n6 = n; n6 <= n2; ++n6) {
                this.indicesArray[n8++] = (short)(this.vertCount + nArray[n6][0] - n3);
                this.indicesArray[n8++] = (short)(this.vertCount + nArray[n6][1] - n3);
                this.indicesArray[n8++] = (short)(this.vertCount + nArray[n6][2] - n3);
            }
            this.minVertIndex = this.vertCount;
            this.maxVertIndex = this.vertCount + n4 - n3;
            n6 = 0;
            int n13 = 0;
            int n14 = 0;
            n7 = 0;
            for (n5 = n3; n5 <= n4; ++n5) {
                float[] fArray3 = fArray[n5];
                float f = fArray3[0];
                float f2 = fArray3[1];
                float f3 = fArray3[2];
                float f4 = fArray3[9];
                float f5 = fArray3[10];
                float f6 = fArray3[11];
                if (fArray2 == null) {
                    this.verticesArray[n6++] = PGraphicsAndroid3D.toFixed32(f);
                    this.verticesArray[n6++] = PGraphicsAndroid3D.toFixed32(f2);
                    this.verticesArray[n6++] = PGraphicsAndroid3D.toFixed32(f3);
                    this.normalsArray[n13++] = PGraphicsAndroid3D.toFixed32(f4);
                    this.normalsArray[n13++] = PGraphicsAndroid3D.toFixed32(f5);
                    this.normalsArray[n13++] = PGraphicsAndroid3D.toFixed32(f6);
                } else {
                    this.verticesArray[n6++] = PGraphicsAndroid3D.toFixed32(f * fArray2[0] + f2 * fArray2[4] + f3 * fArray2[8] + fArray2[12]);
                    this.verticesArray[n6++] = PGraphicsAndroid3D.toFixed32(f * fArray2[1] + f2 * fArray2[5] + f3 * fArray2[9] + fArray2[13]);
                    this.verticesArray[n6++] = PGraphicsAndroid3D.toFixed32(f * fArray2[2] + f2 * fArray2[6] + f3 * fArray2[10] + fArray2[14]);
                    this.normalsArray[n13++] = PGraphicsAndroid3D.toFixed32(f4 + fArray2[12]);
                    this.normalsArray[n13++] = PGraphicsAndroid3D.toFixed32(f5 + fArray2[13]);
                    this.normalsArray[n13++] = PGraphicsAndroid3D.toFixed32(f6 + fArray2[14]);
                }
                this.colorsArray[n14++] = PGraphicsAndroid3D.toFixed32(fArray3[3]);
                this.colorsArray[n14++] = PGraphicsAndroid3D.toFixed32(fArray3[4]);
                this.colorsArray[n14++] = PGraphicsAndroid3D.toFixed32(fArray3[5]);
                this.colorsArray[n14++] = PGraphicsAndroid3D.toFixed32(fArray3[6]);
                if (0 >= this.texCount) continue;
                float[] fArray4 = PGraphicsAndroid3D.this.vertexU[n5];
                float[] fArray5 = PGraphicsAndroid3D.this.vertexV[n5];
                for (int i = 0; i < this.texCount; ++i) {
                    float f7 = 1.0f;
                    float f8 = 1.0f;
                    float f9 = 0.0f;
                    float f10 = 1.0f;
                    float f11 = 0.0f;
                    float f12 = 1.0f;
                    PTexture pTexture = this.texturesArray[i];
                    f7 *= pTexture.getMaxTexCoordU();
                    f8 *= pTexture.getMaxTexCoordV();
                    if (pTexture.isFlippedX()) {
                        f9 = 1.0f;
                        f10 = -1.0f;
                    }
                    if (pTexture.isFlippedY()) {
                        f11 = 1.0f;
                        f12 = -1.0f;
                    }
                    this.texcoordsArray[i][n7++] = PGraphicsAndroid3D.toFixed32((f9 + f10 * fArray4[i]) * f7);
                    this.texcoordsArray[i][n7++] = PGraphicsAndroid3D.toFixed32((f11 + f12 * fArray5[i]) * f8);
                }
            }
            this.indicesBuffer.put(this.indicesArray, 0, 3 * n9);
            this.verticesBuffer.put(this.verticesArray, 0, 3 * n10);
            this.normalsBuffer.put(this.normalsArray, 0, 3 * n10);
            this.colorsBuffer.put(this.colorsArray, 0, 4 * n10);
            for (n5 = 0; n5 < this.texCount; ++n5) {
                this.texcoordsBuffer[n5].put(this.texcoordsArray[n5], 0, 2 * n10);
            }
            this.idxCount += 3 * n9;
            this.vertCount += n10;
            PGraphicsAndroid3D.this.GEO_BUFFER_SIZE += (float)n10;
        }

        void pre() {
            PGraphicsAndroid3D.this.gl.glEnableClientState(32884);
            PGraphicsAndroid3D.this.gl.glEnableClientState(32886);
            PGraphicsAndroid3D.this.gl.glEnableClientState(32885);
            if (0 < this.texCount) {
                for (int i = 0; i < this.texCount; ++i) {
                    PTexture pTexture = this.texturesArray[i];
                    PGraphicsAndroid3D.this.gl.glEnable(pTexture.glTarget);
                    PGraphicsAndroid3D.this.gl.glActiveTexture(33984 + i);
                    PGraphicsAndroid3D.this.gl.glBindTexture(pTexture.glTarget, pTexture.glID);
                    PGraphicsAndroid3D.this.gl.glClientActiveTexture(33984 + i);
                    PGraphicsAndroid3D.this.gl.glEnableClientState(32888);
                }
            }
        }

        void post() {
            if (0 < this.texCount) {
                PTexture pTexture;
                int n;
                for (n = 0; n < this.texCount; ++n) {
                    pTexture = this.texturesArray[n];
                    PGraphicsAndroid3D.this.gl.glActiveTexture(33984 + n);
                    PGraphicsAndroid3D.this.gl.glBindTexture(pTexture.glTarget, 0);
                    PGraphicsAndroid3D.this.gl.glClientActiveTexture(33984 + n);
                    PGraphicsAndroid3D.this.gl.glDisableClientState(32888);
                }
                for (n = 0; n < this.texCount; ++n) {
                    pTexture = this.texturesArray[n];
                    PGraphicsAndroid3D.this.gl.glDisable(pTexture.glTarget);
                }
            }
            PGraphicsAndroid3D.this.gl.glDisableClientState(32885);
            PGraphicsAndroid3D.this.gl.glDisableClientState(32886);
            PGraphicsAndroid3D.this.gl.glDisableClientState(32884);
        }

        void render() {
            int n;
            if (PGraphicsAndroid3D.this.GEO_BUFFER_ACCUM_ALL && PGraphicsAndroid3D.this.UPDATE_GEO_BUFFER_MATRIX_STACK && PGraphicsAndroid3D.this.UPDATE_GL_MATRIX_STACK) {
                PGraphicsAndroid3D.this.pushMatrix();
                PGraphicsAndroid3D.this.gltemp[0] = PGraphicsAndroid3D.this.camera.m00;
                PGraphicsAndroid3D.this.gltemp[1] = PGraphicsAndroid3D.this.camera.m10;
                PGraphicsAndroid3D.this.gltemp[2] = PGraphicsAndroid3D.this.camera.m20;
                PGraphicsAndroid3D.this.gltemp[3] = PGraphicsAndroid3D.this.camera.m30;
                PGraphicsAndroid3D.this.gltemp[4] = PGraphicsAndroid3D.this.camera.m01;
                PGraphicsAndroid3D.this.gltemp[5] = PGraphicsAndroid3D.this.camera.m11;
                PGraphicsAndroid3D.this.gltemp[6] = PGraphicsAndroid3D.this.camera.m21;
                PGraphicsAndroid3D.this.gltemp[7] = PGraphicsAndroid3D.this.camera.m31;
                PGraphicsAndroid3D.this.gltemp[8] = PGraphicsAndroid3D.this.camera.m02;
                PGraphicsAndroid3D.this.gltemp[9] = PGraphicsAndroid3D.this.camera.m12;
                PGraphicsAndroid3D.this.gltemp[10] = PGraphicsAndroid3D.this.camera.m22;
                PGraphicsAndroid3D.this.gltemp[11] = PGraphicsAndroid3D.this.camera.m32;
                PGraphicsAndroid3D.this.gltemp[12] = PGraphicsAndroid3D.this.camera.m03;
                PGraphicsAndroid3D.this.gltemp[13] = PGraphicsAndroid3D.this.camera.m13;
                PGraphicsAndroid3D.this.gltemp[14] = PGraphicsAndroid3D.this.camera.m23;
                PGraphicsAndroid3D.this.gltemp[15] = PGraphicsAndroid3D.this.camera.m33;
                PGraphicsAndroid3D.this.gl.glLoadMatrixf(PGraphicsAndroid3D.this.gltemp, 0);
            }
            this.indicesBuffer.position(0);
            this.verticesBuffer.position(0);
            this.colorsBuffer.position(0);
            this.normalsBuffer.position(0);
            for (n = 0; n < this.texCount; ++n) {
                this.texcoordsBuffer[n].position(0);
            }
            PGraphicsAndroid3D.this.gl.glVertexPointer(3, 5132, 0, (Buffer)this.verticesBuffer);
            PGraphicsAndroid3D.this.gl.glColorPointer(4, 5132, 0, (Buffer)this.colorsBuffer);
            PGraphicsAndroid3D.this.gl.glNormalPointer(5132, 0, (Buffer)this.normalsBuffer);
            for (n = 0; n < this.texCount; ++n) {
                PGraphicsAndroid3D.this.gl.glClientActiveTexture(33984 + n);
                PGraphicsAndroid3D.this.gl.glTexCoordPointer(2, 5132, 0, (Buffer)this.texcoordsBuffer[n]);
            }
            PGraphicsAndroid3D.this.gl.glDrawElements(4, this.idxCount, 5123, (Buffer)this.indicesBuffer);
            if (PGraphicsAndroid3D.this.GEO_BUFFER_ACCUM_ALL && PGraphicsAndroid3D.this.UPDATE_GEO_BUFFER_MATRIX_STACK && PGraphicsAndroid3D.this.UPDATE_GL_MATRIX_STACK) {
                PGraphicsAndroid3D.this.popMatrix();
            }
        }

        void record() {
            int n;
            this.indicesBuffer.position(0);
            this.verticesBuffer.position(0);
            this.colorsBuffer.position(0);
            this.normalsBuffer.position(0);
            for (n = 0; n < this.texCount; ++n) {
                this.texcoordsBuffer[n].position(0);
            }
            n = PGraphicsAndroid3D.this.recordedVertices.size();
            for (int i = 0; i < this.idxCount; ++i) {
                Short s = new Short((short)(n + this.indicesBuffer.get()));
                PGraphicsAndroid3D.this.recordedIndices.add(s);
            }
            for (int i = 0; i < this.vertCount; ++i) {
                float f = PGraphicsAndroid3D.toFloat32(this.verticesBuffer.get());
                float f2 = PGraphicsAndroid3D.toFloat32(this.verticesBuffer.get());
                float f3 = PGraphicsAndroid3D.toFloat32(this.verticesBuffer.get());
                PGraphicsAndroid3D.this.recordedVertices.add(new PVector(f, f2, f3));
                float f4 = PGraphicsAndroid3D.toFloat32(this.normalsBuffer.get());
                float f5 = PGraphicsAndroid3D.toFloat32(this.normalsBuffer.get());
                float f6 = PGraphicsAndroid3D.toFloat32(this.normalsBuffer.get());
                PGraphicsAndroid3D.this.recordedNormals.add(new PVector(f4, f5, f6));
                float[] fArray = new float[]{PGraphicsAndroid3D.toFloat32(this.colorsBuffer.get()), PGraphicsAndroid3D.toFloat32(this.colorsBuffer.get()), PGraphicsAndroid3D.toFloat32(this.colorsBuffer.get()), PGraphicsAndroid3D.toFloat32(this.colorsBuffer.get())};
                PGraphicsAndroid3D.this.recordedColors.add(fArray);
                for (int j = 0; j < this.texCount; ++j) {
                    float f7 = PGraphicsAndroid3D.toFloat32(this.texcoordsBuffer[j].get());
                    float f8 = PGraphicsAndroid3D.toFloat32(this.texcoordsBuffer[j].get());
                    PGraphicsAndroid3D.this.recordedTexCoords[j].add(new PVector(f7, f8));
                }
            }
        }
    }
}

