/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import processing.core.PApplet;

public class PNode
implements Serializable {
    protected Node node;
    protected String name;
    protected PNode parent;
    protected PNode[] children;

    protected PNode() {
    }

    public PNode(PApplet pApplet, String string) {
        this(pApplet.createReader(string));
    }

    public PNode(Reader reader) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            this.node = document.getDocumentElement();
            this.name = this.node.getNodeName();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    public PNode(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            this.node = document.createElement(string);
            this.name = string;
            this.parent = null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    protected PNode(PNode pNode, Node node) {
        this.node = node;
        this.parent = pNode;
        if (node.getNodeType() == 1) {
            this.name = node.getNodeName();
        }
    }

    public static PNode parse(String string) {
        return new PNode(new StringReader(string));
    }

    public PNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    protected void checkChildren() {
        if (this.children == null) {
            NodeList nodeList = this.node.getChildNodes();
            int n = nodeList.getLength();
            this.children = new PNode[n];
            for (int i = 0; i < n; ++i) {
                this.children[i] = new PNode(this, nodeList.item(i));
            }
        }
    }

    public int getChildCount() {
        this.checkChildren();
        return this.children.length;
    }

    public String[] listChildren() {
        this.checkChildren();
        String[] stringArray = new String[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            stringArray[i] = this.children[i].getName();
        }
        return stringArray;
    }

    public PNode[] getChildren() {
        this.checkChildren();
        return this.children;
    }

    public PNode getChild(int n) {
        this.checkChildren();
        return this.children[n];
    }

    public PNode getChild(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildRecursive(PApplet.split(string, '/'), 0);
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            PNode pNode = this.getChild(i);
            String string2 = pNode.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return pNode;
        }
        return null;
    }

    protected PNode getChildRecursive(String[] stringArray, int n) {
        if (Character.isDigit(stringArray[n].charAt(0))) {
            PNode pNode = this.getChild(Integer.parseInt(stringArray[n]));
            if (n == stringArray.length - 1) {
                return pNode;
            }
            return pNode.getChildRecursive(stringArray, n + 1);
        }
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            PNode pNode = this.getChild(i);
            String string = pNode.getName();
            if (string == null || !string.equals(stringArray[n])) continue;
            if (n == stringArray.length - 1) {
                return pNode;
            }
            return pNode.getChildRecursive(stringArray, n + 1);
        }
        return null;
    }

    public PNode[] getChildren(String string) {
        if (string.indexOf(47) != -1) {
            return this.getChildrenRecursive(PApplet.split(string, '/'), 0);
        }
        if (Character.isDigit(string.charAt(0))) {
            return new PNode[]{this.getChild(Integer.parseInt(string))};
        }
        int n = this.getChildCount();
        PNode[] pNodeArray = new PNode[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PNode pNode = this.getChild(i);
            String string2 = pNode.getName();
            if (string2 == null || !string2.equals(string)) continue;
            pNodeArray[n2++] = pNode;
        }
        return (PNode[])PApplet.subset(pNodeArray, 0, n2);
    }

    protected PNode[] getChildrenRecursive(String[] stringArray, int n) {
        if (n == stringArray.length - 1) {
            return this.getChildren(stringArray[n]);
        }
        PNode[] pNodeArray = this.getChildren(stringArray[n]);
        PNode[] pNodeArray2 = new PNode[]{};
        for (int i = 0; i < pNodeArray.length; ++i) {
            PNode[] pNodeArray3 = pNodeArray[i].getChildrenRecursive(stringArray, n + 1);
            pNodeArray2 = (PNode[])PApplet.concat(pNodeArray2, pNodeArray3);
        }
        return pNodeArray2;
    }

    public PNode addChild(String string) {
        Document document = this.node.getOwnerDocument();
        Element element = document.createElement(string);
        this.node.appendChild(element);
        PNode pNode = new PNode(this, element);
        if (this.children != null) {
            this.children = (PNode[])PApplet.concat(this.children, new PNode[]{pNode});
        }
        return pNode;
    }

    public void removeChild(PNode pNode) {
        this.node.removeChild(pNode.node);
        this.children = null;
    }

    public int getAttributeCount() {
        return this.node.getAttributes().getLength();
    }

    public String[] listAttributes() {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        String[] stringArray = new String[namedNodeMap.getLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = namedNodeMap.item(i).getNodeName();
        }
        return stringArray;
    }

    public boolean hasAttribute(String string) {
        return this.node.getAttributes().getNamedItem(string) != null;
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Node node = this.node.getAttributes().getNamedItem(string);
        return node == null ? string2 : node.getNodeValue();
    }

    public void setString(String string, String string2) {
        ((Element)this.node).setAttribute(string, string2);
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public void setInt(String string, int n) {
        this.setString(string, String.valueOf(n));
    }

    public int getInt(String string, int n) {
        String string2 = this.getString(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        String string2 = this.getString(string);
        return string2 == null ? f : Float.parseFloat(string2);
    }

    public void setFloat(String string, float f) {
        this.setString(string, String.valueOf(f));
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        String string2 = this.getString(string);
        return string2 == null ? d : Double.parseDouble(string2);
    }

    public void setDouble(String string, double d) {
        this.setString(string, String.valueOf(d));
    }

    public String getContent() {
        StringBuilder stringBuilder = new StringBuilder();
        NodeList nodeList = this.node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            stringBuilder.append(node.getNodeValue());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int n) {
        return super.toString();
    }
}

