/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;

public class PShape
implements PConstants {
    protected String name;
    protected HashMap<String, PShape> nameTable;
    public static final int GROUP = 0;
    public static final int PRIMITIVE = 1;
    public static final int PATH = 2;
    public static final int GEOMETRY = 3;
    protected int family;
    protected int primitive;
    protected PMatrix matrix;
    protected PImage image;
    public float width;
    public float height;
    public float depth;
    protected boolean visible = true;
    protected boolean stroke;
    protected int strokeColor;
    protected float strokeWeight;
    protected int strokeCap;
    protected int strokeJoin;
    protected boolean fill;
    protected int fillColor;
    protected boolean style = true;
    protected float[] params;
    protected int vertexCount;
    protected float[][] vertices;
    public static final int VERTEX = 0;
    public static final int BEZIER_VERTEX = 1;
    public static final int QUAD_BEZIER_VERTEX = 2;
    public static final int CURVE_VERTEX = 3;
    public static final int BREAK = 4;
    protected int vertexCodeCount;
    protected int[] vertexCodes;
    protected boolean close;
    protected PShape parent;
    protected int childCount;
    protected PShape[] children;

    public PShape() {
        this.family = 0;
    }

    public PShape(int n) {
        this.family = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void disableStyle() {
        this.style = false;
        for (int i = 0; i < this.childCount; ++i) {
            this.children[i].disableStyle();
        }
    }

    public void enableStyle() {
        this.style = true;
        for (int i = 0; i < this.childCount; ++i) {
            this.children[i].enableStyle();
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getDepth() {
        return this.depth;
    }

    public boolean is3D() {
        return false;
    }

    protected void pre(PGraphics pGraphics) {
        if (this.matrix != null) {
            pGraphics.pushMatrix();
            pGraphics.applyMatrix(this.matrix);
        }
        if (this.style) {
            pGraphics.pushStyle();
            this.styles(pGraphics);
        }
    }

    protected void styles(PGraphics pGraphics) {
        if (this.stroke) {
            pGraphics.stroke(this.strokeColor);
            pGraphics.strokeWeight(this.strokeWeight);
            pGraphics.strokeCap(this.strokeCap);
            pGraphics.strokeJoin(this.strokeJoin);
        } else {
            pGraphics.noStroke();
        }
        if (this.fill) {
            pGraphics.fill(this.fillColor);
        } else {
            pGraphics.noFill();
        }
    }

    public void post(PGraphics pGraphics) {
        if (this.matrix != null) {
            pGraphics.popMatrix();
        }
        if (this.style) {
            pGraphics.popStyle();
        }
    }

    public void draw(PGraphics pGraphics) {
        if (this.visible) {
            this.pre(pGraphics);
            this.drawImpl(pGraphics);
            this.post(pGraphics);
        }
    }

    public void drawImpl(PGraphics pGraphics) {
        if (this.family == 0) {
            this.drawGroup(pGraphics);
        } else if (this.family == 1) {
            this.drawPrimitive(pGraphics);
        } else if (this.family == 3) {
            this.drawGeometry(pGraphics);
        } else if (this.family == 2) {
            this.drawPath(pGraphics);
        }
    }

    protected void drawGroup(PGraphics pGraphics) {
        for (int i = 0; i < this.childCount; ++i) {
            this.children[i].draw(pGraphics);
        }
    }

    protected void drawPrimitive(PGraphics pGraphics) {
        if (this.primitive == 2) {
            pGraphics.point(this.params[0], this.params[1]);
        } else if (this.primitive == 4) {
            if (this.params.length == 4) {
                pGraphics.line(this.params[0], this.params[1], this.params[2], this.params[3]);
            } else {
                pGraphics.line(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
            }
        } else if (this.primitive == 8) {
            pGraphics.triangle(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
        } else if (this.primitive == 16) {
            pGraphics.quad(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5], this.params[6], this.params[7]);
        } else if (this.primitive == 30) {
            if (this.image != null) {
                pGraphics.imageMode(0);
                pGraphics.image(this.image, this.params[0], this.params[1], this.params[2], this.params[3]);
            } else {
                pGraphics.rectMode(0);
                pGraphics.rect(this.params[0], this.params[1], this.params[2], this.params[3]);
            }
        } else if (this.primitive == 31) {
            pGraphics.ellipseMode(0);
            pGraphics.ellipse(this.params[0], this.params[1], this.params[2], this.params[3]);
        } else if (this.primitive == 32) {
            pGraphics.ellipseMode(0);
            pGraphics.arc(this.params[0], this.params[1], this.params[2], this.params[3], this.params[4], this.params[5]);
        } else if (this.primitive == 41) {
            if (this.params.length == 1) {
                pGraphics.box(this.params[0]);
            } else {
                pGraphics.box(this.params[0], this.params[1], this.params[2]);
            }
        } else if (this.primitive == 40) {
            pGraphics.sphere(this.params[0]);
        }
    }

    protected void drawGeometry(PGraphics pGraphics) {
        pGraphics.beginShape(this.primitive);
        if (this.style) {
            for (int i = 0; i < this.vertexCount; ++i) {
                pGraphics.vertex(this.vertices[i]);
            }
        } else {
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] fArray = this.vertices[i];
                if (fArray[2] == 0.0f) {
                    pGraphics.vertex(fArray[0], fArray[1]);
                    continue;
                }
                pGraphics.vertex(fArray[0], fArray[1], fArray[2]);
            }
        }
        pGraphics.endShape();
    }

    protected void drawPath(PGraphics pGraphics) {
        if (this.vertices == null) {
            return;
        }
        pGraphics.beginShape();
        if (this.vertexCodeCount == 0) {
            if (this.vertices[0].length == 2) {
                for (int i = 0; i < this.vertexCount; ++i) {
                    pGraphics.vertex(this.vertices[i][0], this.vertices[i][1]);
                }
            } else {
                for (int i = 0; i < this.vertexCount; ++i) {
                    pGraphics.vertex(this.vertices[i][0], this.vertices[i][1], this.vertices[i][2]);
                }
            }
        } else {
            int n = 0;
            if (this.vertices[0].length == 2) {
                block16: for (int i = 0; i < this.vertexCodeCount; ++i) {
                    switch (this.vertexCodes[i]) {
                        case 0: {
                            pGraphics.vertex(this.vertices[n][0], this.vertices[n][1]);
                            ++n;
                            continue block16;
                        }
                        case 2: {
                            pGraphics.quadraticVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 1][0], this.vertices[n + 1][1]);
                            n += 2;
                            continue block16;
                        }
                        case 1: {
                            pGraphics.bezierVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 1][0], this.vertices[n + 1][1], this.vertices[n + 2][0], this.vertices[n + 2][1]);
                            n += 3;
                            continue block16;
                        }
                        case 3: {
                            pGraphics.curveVertex(this.vertices[n][0], this.vertices[n][1]);
                            ++n;
                        }
                        case 4: {
                            pGraphics.breakShape();
                        }
                    }
                }
            } else {
                block17: for (int i = 0; i < this.vertexCodeCount; ++i) {
                    switch (this.vertexCodes[i]) {
                        case 0: {
                            pGraphics.vertex(this.vertices[n][0], this.vertices[n][1], this.vertices[n][2]);
                            ++n;
                            continue block17;
                        }
                        case 2: {
                            pGraphics.quadraticVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 0][2], this.vertices[n + 1][0], this.vertices[n + 1][1], this.vertices[n + 0][2]);
                            n += 2;
                            continue block17;
                        }
                        case 1: {
                            pGraphics.bezierVertex(this.vertices[n + 0][0], this.vertices[n + 0][1], this.vertices[n + 0][2], this.vertices[n + 1][0], this.vertices[n + 1][1], this.vertices[n + 1][2], this.vertices[n + 2][0], this.vertices[n + 2][1], this.vertices[n + 2][2]);
                            n += 3;
                            continue block17;
                        }
                        case 3: {
                            pGraphics.curveVertex(this.vertices[n][0], this.vertices[n][1], this.vertices[n][2]);
                            ++n;
                        }
                        case 4: {
                            pGraphics.breakShape();
                        }
                    }
                }
            }
        }
        pGraphics.endShape(this.close ? 2 : 1);
    }

    public PShape getParent() {
        return this.parent;
    }

    public int getChildCount() {
        return this.childCount;
    }

    public PShape[] getChildren() {
        return this.children;
    }

    public PShape getChild(int n) {
        return this.children[n];
    }

    public PShape getChild(String string) {
        PShape pShape;
        if (this.name != null && this.name.equals(string)) {
            return this;
        }
        if (this.nameTable != null && (pShape = this.nameTable.get(string)) != null) {
            return pShape;
        }
        for (int i = 0; i < this.childCount; ++i) {
            PShape pShape2 = this.children[i].getChild(string);
            if (pShape2 == null) continue;
            return pShape2;
        }
        return null;
    }

    public PShape findChild(String string) {
        if (this.parent == null) {
            return this.getChild(string);
        }
        return this.parent.findChild(string);
    }

    public void addChild(PShape pShape) {
        if (this.children == null) {
            this.children = new PShape[1];
        }
        if (this.childCount == this.children.length) {
            this.children = (PShape[])PApplet.expand(this.children);
        }
        this.children[this.childCount++] = pShape;
        pShape.parent = this;
        if (pShape.getName() != null) {
            this.addName(pShape.getName(), pShape);
        }
    }

    public void addChild(PShape pShape, int n) {
        if (n < this.childCount) {
            if (this.childCount == this.children.length) {
                this.children = (PShape[])PApplet.expand(this.children);
            }
            for (int i = this.childCount - 1; i >= n; --i) {
                this.children[i + 1] = this.children[i];
            }
            ++this.childCount;
            this.children[n] = pShape;
            pShape.parent = this;
            if (pShape.getName() != null) {
                this.addName(pShape.getName(), pShape);
            }
        }
    }

    public void removeChild(int n) {
        if (n < this.childCount) {
            PShape pShape = this.children[n];
            for (int i = n; i < this.childCount - 1; ++i) {
                this.children[i] = this.children[i + 1];
            }
            --this.childCount;
            if (pShape.getName() != null && this.nameTable != null) {
                this.nameTable.remove(pShape.getName());
            }
        }
    }

    public void addName(String string, PShape pShape) {
        if (this.parent != null) {
            this.parent.addName(string, pShape);
        } else {
            if (this.nameTable == null) {
                this.nameTable = new HashMap();
            }
            this.nameTable.put(string, pShape);
        }
    }

    public int getChildIndex(PShape pShape) {
        for (int i = 0; i < this.childCount; ++i) {
            if (this.children[i] != pShape) continue;
            return i;
        }
        return -1;
    }

    public int getFamily() {
        return this.family;
    }

    public int getPrimitive() {
        return this.primitive;
    }

    public float[] getParams() {
        return this.getParams(null);
    }

    public float[] getParams(float[] fArray) {
        if (fArray == null || fArray.length != this.params.length) {
            fArray = new float[this.params.length];
        }
        PApplet.arrayCopy(this.params, fArray);
        return fArray;
    }

    public float getParam(int n) {
        return this.params[n];
    }

    public int getVertexCount() {
        return this.vertexCount;
    }

    public float[] getVertex(int n) {
        if (n < 0 || n >= this.vertexCount) {
            String string = "No vertex " + n + " for this shape, " + "only vertices 0 through " + (this.vertexCount - 1) + ".";
            throw new IllegalArgumentException(string);
        }
        return this.vertices[n];
    }

    public float getVertexX(int n) {
        return this.vertices[n][0];
    }

    public float getVertexY(int n) {
        return this.vertices[n][1];
    }

    public float getVertexZ(int n) {
        return this.vertices[n][2];
    }

    public int[] getVertexCodes() {
        if (this.vertexCodes == null) {
            return null;
        }
        if (this.vertexCodes.length != this.vertexCodeCount) {
            this.vertexCodes = PApplet.subset(this.vertexCodes, 0, this.vertexCodeCount);
        }
        return this.vertexCodes;
    }

    public int getVertexCodeCount() {
        return this.vertexCodeCount;
    }

    public int getVertexCode(int n) {
        return this.vertexCodes[n];
    }

    public boolean isClosed() {
        return this.close;
    }

    public boolean contains(float f, float f2) {
        if (this.family == 2) {
            boolean bl = false;
            int n = 0;
            int n2 = this.vertexCount - 1;
            while (n < this.vertexCount) {
                if (this.vertices[n][1] > f2 != this.vertices[n2][1] > f2 && f < (this.vertices[n2][0] - this.vertices[n][0]) * (f2 - this.vertices[n][1]) / (this.vertices[n2][1] - this.vertices[n][1]) + this.vertices[n][0]) {
                    bl = !bl;
                }
                n2 = n++;
            }
            return bl;
        }
        throw new IllegalArgumentException("The contains() method is only implemented for paths.");
    }

    public void translate(float f, float f2) {
        this.checkMatrix(2);
        this.matrix.translate(f, f2);
    }

    public void translate(float f, float f2, float f3) {
        this.checkMatrix(3);
        this.matrix.translate(f, f2, f3);
    }

    public void rotateX(float f) {
        this.rotate(f, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float f) {
        this.rotate(f, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float f) {
        this.rotate(f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float f) {
        this.checkMatrix(2);
        this.matrix.rotate(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.checkMatrix(3);
        this.matrix.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        this.checkMatrix(2);
        this.matrix.scale(f);
    }

    public void scale(float f, float f2) {
        this.checkMatrix(2);
        this.matrix.scale(f, f2);
    }

    public void scale(float f, float f2, float f3) {
        this.checkMatrix(3);
        this.matrix.scale(f, f2, f3);
    }

    public void centerAt(float f, float f2, float f3) {
    }

    public void resetMatrix() {
        this.checkMatrix(2);
        this.matrix.reset();
    }

    public void applyMatrix(PMatrix pMatrix) {
        if (pMatrix instanceof PMatrix2D) {
            this.applyMatrix((PMatrix2D)pMatrix);
        } else if (pMatrix instanceof PMatrix3D) {
            this.applyMatrix((PMatrix3D)pMatrix);
        }
    }

    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.applyMatrix(pMatrix2D.m00, pMatrix2D.m01, 0.0f, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, 0.0f, pMatrix2D.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.checkMatrix(2);
        this.matrix.apply(f, f2, f3, 0.0f, f4, f5, f6, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void apply(PMatrix3D pMatrix3D) {
        this.applyMatrix(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.checkMatrix(3);
        this.matrix.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    protected void checkMatrix(int n) {
        if (this.matrix == null) {
            this.matrix = n == 2 ? new PMatrix2D() : new PMatrix3D();
        } else if (n == 3 && this.matrix instanceof PMatrix2D) {
            this.matrix = new PMatrix3D(this.matrix);
        }
    }
}

