/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.BufferedReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import javax.microedition.khronos.opengles.GL11;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PGraphicsAndroid3D;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PTexture;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PShape3D
extends PShape
implements PConstants {
    protected PApplet papplet;
    protected PGraphicsAndroid3D a3d;
    protected static final int VERTICES = 0;
    protected static final int NORMALS = 1;
    protected static final int COLORS = 2;
    protected static final int TEXCOORDS = 3;
    protected int numTexBuffers;
    protected int glUsage;
    public int glVertexBufferID;
    public int glColorBufferID;
    public int glNormalBufferID;
    public int[] glTexCoordBufferID;
    protected FloatBuffer vertexBuffer;
    protected FloatBuffer colorBuffer;
    protected FloatBuffer normalBuffer;
    protected FloatBuffer texCoordBuffer;
    public float[] vertices;
    public float[] colors;
    public float[] normals;
    public float[] texcoords;
    protected int glIndexBufferID = 0;
    protected ShortBuffer indexBuffer = null;
    protected int indexCount = 0;
    protected short[] indices;
    protected boolean useIndices;
    protected float[] convTexcoords;
    protected float[][] allTexcoords;
    protected PShape3D[] vertexChild;
    protected boolean[] texCoordSet;
    protected boolean autoBounds = true;
    boolean readFromOBJ = false;
    ArrayList<PVector> objVertices;
    ArrayList<PVector> objNormal;
    ArrayList<PVector> objTexCoords;
    ArrayList<OBJFace> objFaces;
    ArrayList<OBJMaterial> objMaterials;
    protected int glMode;
    protected boolean pointSprites;
    protected PImage[] textures;
    protected float maxSpriteSize = PGraphicsAndroid3D.maxPointSize;
    protected float[] spriteDistAtt = new float[]{1.0f, 0.0f, 0.0f};
    protected PTexture[] renderTextures;
    protected PShape3D root;
    protected int updateElement;
    protected int updateTexunit;
    protected int firstUpdateIdx;
    protected int lastUpdateIdx;
    protected int firstVertex;
    protected int lastVertex;
    protected int firstIndex;
    protected int lastIndex;
    public float xmin;
    public float xmax;
    public float ymin;
    public float ymax;
    public float zmin;
    public float zmax;

    public PShape3D() {
        this.papplet = null;
        this.a3d = null;
        this.glVertexBufferID = 0;
        this.glColorBufferID = 0;
        this.glNormalBufferID = 0;
        this.glTexCoordBufferID = null;
    }

    public PShape3D(PApplet pApplet) {
        this();
        this.papplet = pApplet;
        this.a3d = (PGraphicsAndroid3D)pApplet.g;
        this.family = 0;
        this.name = "root";
        this.root = this;
    }

    public PShape3D(PApplet pApplet, int n) {
        this(pApplet, n, new Parameters());
    }

    public PShape3D(PApplet pApplet, String string, Parameters parameters) {
        this.papplet = pApplet;
        this.a3d = (PGraphicsAndroid3D)pApplet.g;
        this.family = 0;
        this.name = "root";
        this.root = this;
        this.glVertexBufferID = 0;
        this.glColorBufferID = 0;
        this.glNormalBufferID = 0;
        this.glTexCoordBufferID = null;
        this.updateElement = -1;
        this.initShapeOBJ(string, parameters);
    }

    public PShape3D(PApplet pApplet, int n, Parameters parameters) {
        this.papplet = pApplet;
        this.a3d = (PGraphicsAndroid3D)pApplet.g;
        this.family = 0;
        this.name = "root";
        this.root = this;
        this.glVertexBufferID = 0;
        this.glColorBufferID = 0;
        this.glNormalBufferID = 0;
        this.glTexCoordBufferID = null;
        this.updateElement = -1;
        this.initShape(n, parameters);
    }

    public void delete() {
        if (this.root != this) {
            return;
        }
        this.release();
        this.a3d.unregisterPGLObject(this);
        this.deleteVertexBuffer();
        this.deleteColorBuffer();
        this.deleteTexCoordBuffer();
        this.deleteNormalBuffer();
        this.deleteIndexBuffer();
    }

    public void backup() {
    }

    public void restore() {
        if (this.root != this) {
            return;
        }
        this.loadVertices();
        this.updateVertices();
        this.loadColors();
        this.updateColors();
        this.loadNormals();
        this.updateNormals();
        for (int i = 0; i < this.numTexBuffers; ++i) {
            this.loadTexcoords(i);
            this.updateTexcoords();
        }
    }

    public void beginRecord() {
        this.a3d.beginRecord(this);
    }

    public void endRecord() {
        this.a3d.endRecord();
    }

    public void beginShape(int n) {
        this.a3d.beginShape(n);
    }

    public void endShape() {
        this.a3d.endShape();
    }

    public void endShape(int n) {
        this.a3d.endShape(n);
    }

    public void shapeName(String string) {
        this.a3d.shapeName(string);
    }

    public void mergeShapes(boolean bl) {
        this.a3d.mergeShapes(bl);
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.a3d.vertex(f, f2, f3, f4);
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.a3d.vertex(f, f2, f3, f4, f5);
    }

    public void vertex(float ... fArray) {
        this.a3d.vertex(fArray);
    }

    public void normal(float f, float f2, float f3) {
        this.a3d.normal(f, f2, f3);
    }

    public void texture(PImage pImage) {
        this.a3d.texture(pImage);
    }

    public void texture(PImage ... pImageArray) {
        this.a3d.texture(pImageArray);
    }

    public void sphereDetail(int n) {
        this.a3d.sphereDetail(n);
    }

    public void sphereDetail(int n, int n2) {
        this.a3d.sphereDetail(n, n2);
    }

    public void sphere(float f) {
        this.a3d.sphere(f);
    }

    public void box(float f) {
        this.a3d.box(f);
    }

    public void box(float f, float f2, float f3) {
        this.a3d.box(f, f2, f3);
    }

    public void noFill() {
        this.a3d.saveDrawingState();
        this.a3d.noFill();
        this.a3d.restoreDrawingState();
    }

    public void fill(int n) {
        this.a3d.saveDrawingState();
        this.a3d.fill(n);
        this.a3d.restoreDrawingState();
    }

    public void fill(int n, float f) {
        this.a3d.saveDrawingState();
        this.a3d.fill(n, f);
        this.a3d.restoreDrawingState();
    }

    public void fill(float f) {
        this.a3d.saveDrawingState();
        this.a3d.fill(f);
        this.a3d.restoreDrawingState();
    }

    public void fill(float f, float f2) {
        this.a3d.saveDrawingState();
        this.a3d.fill(f, f2);
        this.a3d.restoreDrawingState();
    }

    public void fill(float f, float f2, float f3) {
        this.a3d.saveDrawingState();
        this.a3d.fill(f, f2, f3);
        this.a3d.restoreDrawingState();
    }

    public void fill(float f, float f2, float f3, float f4) {
        this.a3d.saveDrawingState();
        this.a3d.fill(f, f2, f3, f4);
        this.a3d.restoreDrawingState();
    }

    public void noStroke() {
        this.a3d.saveDrawingState();
        this.a3d.noStroke();
        this.a3d.restoreDrawingState();
    }

    public void stroke(int n) {
        this.a3d.saveDrawingState();
        this.a3d.stroke(n);
        this.a3d.restoreDrawingState();
    }

    public void stroke(int n, float f) {
        this.a3d.saveDrawingState();
        this.a3d.stroke(n, f);
        this.a3d.restoreDrawingState();
    }

    public void stroke(float f) {
        this.a3d.saveDrawingState();
        this.a3d.stroke(f);
        this.a3d.restoreDrawingState();
    }

    public void stroke(float f, float f2) {
        this.a3d.saveDrawingState();
        this.a3d.stroke(f, f2);
        this.a3d.restoreDrawingState();
    }

    public void stroke(float f, float f2, float f3) {
        this.a3d.saveDrawingState();
        this.a3d.stroke(f, f2, f3);
        this.a3d.restoreDrawingState();
    }

    public void stroke(float f, float f2, float f3, float f4) {
        this.a3d.saveDrawingState();
        this.a3d.stroke(f, f2, f3, f4);
        this.a3d.restoreDrawingState();
    }

    public void loadVertices() {
        this.loadVertices(this.firstVertex, this.lastVertex);
    }

    public void loadVertices(int n, int n2) {
        if (n2 < n || n < this.firstVertex || this.lastVertex < n2) {
            PGraphics.showWarning("PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning("PShape3D: can load only one type of data at the time");
            return;
        }
        this.updateElement = 0;
        this.firstUpdateIdx = n;
        this.lastUpdateIdx = n2;
        this.getGl().glBindBuffer(34962, this.glVertexBufferID);
    }

    public void updateVertices() {
        if (this.updateElement == 0) {
            int n = this.firstUpdateIdx * 3;
            int n2 = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 3;
            if (this.root.autoBounds) {
                this.updateBounds(this.firstUpdateIdx, this.lastUpdateIdx);
            }
            this.vertexBuffer.position(0);
            this.vertexBuffer.put(this.vertices, n, n2);
            this.vertexBuffer.flip();
            this.getGl().glBufferSubData(34962, n * 4, n2 * 4, (Buffer)this.vertexBuffer);
            this.getGl().glBindBuffer(34962, 0);
            this.updateElement = -1;
        } else {
            PGraphics.showWarning("PShape3D: need to call loadVertices() first");
        }
    }

    public void loadColors() {
        this.loadColors(this.firstVertex, this.lastVertex);
    }

    public void loadColors(int n, int n2) {
        if (n2 < n || n < this.firstVertex || this.lastVertex < n2) {
            PGraphics.showWarning("PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning("PShape3D: can load only one type of data at the time");
            return;
        }
        this.updateElement = 2;
        this.firstUpdateIdx = n;
        this.lastUpdateIdx = n2;
        this.getGl().glBindBuffer(34962, this.glColorBufferID);
    }

    public void updateColors() {
        if (this.updateElement == 2) {
            int n = this.firstUpdateIdx * 4;
            int n2 = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 4;
            this.colorBuffer.position(0);
            this.colorBuffer.put(this.colors, n, n2);
            this.colorBuffer.flip();
            this.getGl().glBufferSubData(34962, n * 4, n2 * 4, (Buffer)this.colorBuffer);
            this.getGl().glBindBuffer(34962, 0);
            this.updateElement = -1;
        } else {
            PGraphics.showWarning("PShape3D: need to call loadColors() first");
        }
    }

    public void loadNormals() {
        this.loadNormals(this.firstVertex, this.lastVertex);
    }

    public void loadNormals(int n, int n2) {
        if (n2 < n || n < this.firstVertex || this.lastVertex < n2) {
            PGraphics.showWarning("PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning("PShape3D: can load only one type of data at the time");
            return;
        }
        this.updateElement = 1;
        this.firstUpdateIdx = n;
        this.lastUpdateIdx = n2;
        this.getGl().glBindBuffer(34962, this.glNormalBufferID);
    }

    public void updateNormals() {
        if (this.updateElement == 1) {
            int n = this.firstUpdateIdx * 3;
            int n2 = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 3;
            this.normalBuffer.position(0);
            this.normalBuffer.put(this.normals, n, n2);
            this.normalBuffer.flip();
            this.getGl().glBufferSubData(34962, n * 4, n2 * 4, (Buffer)this.normalBuffer);
            this.getGl().glBindBuffer(34962, 0);
            this.updateElement = -1;
        } else {
            PGraphics.showWarning("PShape3D: need to call loadNormals() first");
        }
    }

    public void loadTexcoords() {
        this.loadTexcoords(0);
    }

    public void loadTexcoords(int n) {
        this.loadTexcoords(n, this.firstVertex, this.lastVertex);
    }

    protected void loadTexcoords(int n, int n2, int n3) {
        if (n3 < n2 || n2 < this.firstVertex || this.lastVertex < n3) {
            PGraphics.showWarning("PShape3D: wrong vertex index");
            this.updateElement = -1;
            return;
        }
        if (this.updateElement != -1) {
            PGraphics.showWarning("PShape3D: can load only one type of data at the time");
            return;
        }
        if (PGraphicsAndroid3D.maxTextureUnits <= n) {
            PGraphics.showWarning("PShape3D: wrong texture unit");
            return;
        }
        this.updateElement = 3;
        this.firstUpdateIdx = n2;
        this.lastUpdateIdx = n3;
        this.updateTexunit = n;
        if (this.numTexBuffers <= n) {
            this.addTexBuffers(n - this.numTexBuffers + 1);
        }
        this.getGl().glBindBuffer(34962, this.glTexCoordBufferID[n]);
        this.texcoords = this.allTexcoords[n];
    }

    public void updateTexcoords() {
        if (this.updateElement == 3) {
            int n = this.firstUpdateIdx * 2;
            int n2 = (this.lastUpdateIdx - this.firstUpdateIdx + 1) * 2;
            this.convertTexcoords();
            this.texCoordBuffer.position(0);
            this.texCoordBuffer.put(this.convTexcoords, n, n2);
            this.texCoordBuffer.flip();
            this.getGl().glBufferSubData(34962, n * 4, n2 * 4, (Buffer)this.texCoordBuffer);
            this.getGl().glBindBuffer(34962, 0);
            this.texCoordSet[this.updateTexunit] = true;
            this.updateElement = -1;
        } else {
            PGraphics.showWarning("PShape3D: need to call loadTexcoords() first");
        }
    }

    public float[] get(int n) {
        float[] fArray = null;
        if (this.updateElement == 0) {
            fArray = new float[3];
            PApplet.arrayCopy(this.vertices, 3 * n, fArray, 0, 3);
        } else if (this.updateElement == 2) {
            fArray = new float[4];
            PApplet.arrayCopy(this.colors, 4 * n, fArray, 0, 4);
        } else if (this.updateElement == 1) {
            fArray = new float[3];
            PApplet.arrayCopy(this.normals, 3 * n, fArray, 0, 3);
        } else if (this.updateElement == 3) {
            fArray = new float[2];
            PApplet.arrayCopy(this.texcoords, 2 * n, fArray, 0, 2);
        }
        return fArray;
    }

    public void set(int n, float[] fArray) {
        if (this.updateElement == 0) {
            PApplet.arrayCopy(fArray, 0, this.vertices, 3 * n, 3);
        } else if (this.updateElement == 2) {
            PApplet.arrayCopy(fArray, 0, this.colors, 4 * n, 4);
        } else if (this.updateElement == 1) {
            PApplet.arrayCopy(fArray, 0, this.normals, 3 * n, 3);
        } else if (this.updateElement == 3) {
            PApplet.arrayCopy(fArray, 0, this.texcoords, 2 * n, 2);
        }
    }

    public void set(int n, int n2) {
        this.set(n, PShape3D.rgba(n2));
    }

    public void set(int n, float f, float f2) {
        if (this.updateElement == 0) {
            this.set(n, new float[]{f, f2, 0.0f});
        } else if (this.updateElement == 3) {
            this.set(n, new float[]{f, f2});
        }
    }

    public void set(int n, float f, float f2, float f3) {
        if (this.updateElement == 0) {
            this.set(n, new float[]{f, f2, f3});
        } else if (this.updateElement == 1) {
            this.set(n, new float[]{f, f2, f3});
        } else if (this.updateElement == 2) {
            this.set(n, new float[]{f, f2, f3, 1.0f});
        }
    }

    public void set(int n, float f, float f2, float f3, float f4) {
        if (this.updateElement == 2) {
            this.set(n, new float[]{f, f2, f3, f4});
        }
    }

    public static int color(float[] fArray) {
        int n = (int)(fArray[0] * 255.0f);
        int n2 = (int)(fArray[1] * 255.0f);
        int n3 = (int)(fArray[2] * 255.0f);
        int n4 = (int)(fArray[3] * 255.0f);
        return n4 << 24 | n << 16 | n2 << 8 | n3;
    }

    public static float[] rgba(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        float[] fArray = new float[]{(float)n3 / 255.0f, (float)n4 / 255.0f, (float)n5 / 255.0f, (float)n2 / 255.0f};
        return fArray;
    }

    public void autoBounds(boolean bl) {
        this.root.autoBounds = bl;
    }

    public void updateBounds() {
        this.updateBounds(this.firstVertex, this.lastVertex);
    }

    protected void updateBounds(int n, int n2) {
        if (n <= this.firstVertex && this.lastVertex <= n2) {
            this.resetBounds();
        }
        if (this.family == 0) {
            if (this.root == this && this.childCount == 0) {
                for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
                    this.updateBounds(this.vertices[3 * i + 0], this.vertices[3 * i + 1], this.vertices[3 * i + 2]);
                }
            } else {
                for (int i = 0; i < this.childCount; ++i) {
                    PShape3D pShape3D = (PShape3D)this.children[i];
                    pShape3D.updateBounds(n, n2);
                    this.xmin = PApplet.min(this.xmin, pShape3D.xmin);
                    this.xmax = PApplet.max(this.xmax, pShape3D.xmax);
                    this.ymin = PApplet.min(this.ymin, pShape3D.ymin);
                    this.ymax = PApplet.max(this.ymax, pShape3D.ymax);
                    this.zmin = PApplet.min(this.zmin, pShape3D.zmin);
                    this.zmax = PApplet.max(this.zmax, pShape3D.zmax);
                    this.width = this.xmax - this.xmin;
                    this.height = this.ymax - this.ymin;
                    this.depth = this.zmax - this.zmin;
                }
            }
        } else {
            int n3 = PApplet.max(n, this.firstVertex);
            int n4 = PApplet.min(n2, this.lastVertex);
            for (int i = n3; i <= n4; ++i) {
                this.updateBounds(this.vertices[3 * i + 0], this.vertices[3 * i + 1], this.vertices[3 * i + 2]);
            }
        }
    }

    protected void resetBounds() {
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                ((PShape3D)this.children[i]).resetBounds();
            }
        }
        this.depth = 0.0f;
        this.height = 0.0f;
        this.width = 0.0f;
        this.zmin = 10000.0f;
        this.ymin = 10000.0f;
        this.xmin = 10000.0f;
        this.zmax = -10000.0f;
        this.ymax = -10000.0f;
        this.xmax = -10000.0f;
    }

    protected void updateBounds(float f, float f2, float f3) {
        this.xmin = PApplet.min(this.xmin, f);
        this.xmax = PApplet.max(this.xmax, f);
        this.ymin = PApplet.min(this.ymin, f2);
        this.ymax = PApplet.max(this.ymax, f2);
        this.zmin = PApplet.min(this.zmin, f3);
        this.zmax = PApplet.max(this.zmax, f3);
        this.width = this.xmax - this.xmin;
        this.height = this.ymax - this.ymin;
        this.depth = this.zmax - this.zmin;
    }

    protected void convertTexcoords() {
        PTexture pTexture = null;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        for (int i = this.firstUpdateIdx; i <= this.lastUpdateIdx; ++i) {
            if (this.vertexChild[i] == null || this.vertexChild[i].textures[this.updateTexunit] == null) continue;
            PImage pImage = this.vertexChild[i].textures[this.updateTexunit];
            PTexture pTexture2 = this.a3d.getTexture(pImage);
            if (pTexture2 != pTexture) {
                f = 1.0f;
                f2 = 1.0f;
                f3 = 0.0f;
                f4 = 1.0f;
                f5 = 0.0f;
                f6 = 1.0f;
                if (pTexture2 != null) {
                    if (pTexture2.isFlippedX()) {
                        f3 = 1.0f;
                        f4 = -1.0f;
                    }
                    if (pTexture2.isFlippedY()) {
                        f5 = 1.0f;
                        f6 = -1.0f;
                    }
                    f *= pTexture2.getMaxTexCoordU();
                    f2 *= pTexture2.getMaxTexCoordV();
                }
                pTexture = pTexture2;
            }
            float f7 = this.texcoords[2 * i + 0];
            float f8 = this.texcoords[2 * i + 1];
            f7 = (f3 + f4 * f7) * f;
            f8 = (f5 + f6 * f8) * f2;
            this.convTexcoords[2 * i + 0] = f7;
            this.convTexcoords[2 * i + 1] = f8;
        }
    }

    public static PShape createChild(int n, int n2) {
        return PShape3D.createChild(null, n, n2, 2, 0.0f, null);
    }

    public static PShape createChild(String string, int n, int n2) {
        return PShape3D.createChild(string, n, n2, 2, 0.0f, null);
    }

    public static PShape createChild(String string, int n, int n2, int n3) {
        return PShape3D.createChild(string, n, n2, n3, 0.0f, null);
    }

    public static PShape createChild(String string, int n, int n2, int n3, float f) {
        return PShape3D.createChild(string, n, n2, n3, f, null);
    }

    public static PShape createChild(String string, int n, int n2, int n3, int n4, int n5, float f, PImage[] pImageArray) {
        PShape3D pShape3D = (PShape3D)PShape3D.createChild(string, n, n2, n5, f, pImageArray);
        pShape3D.firstIndex = n3;
        pShape3D.lastIndex = n4;
        return pShape3D;
    }

    public static PShape createChild(String string, int n, int n2, int n3, float f, PImage[] pImageArray) {
        PShape3D pShape3D = new PShape3D();
        pShape3D.family = 3;
        pShape3D.name = string;
        pShape3D.firstVertex = n;
        pShape3D.lastVertex = n2;
        pShape3D.setDrawModeImpl(n3);
        pShape3D.strokeWeight = f;
        pShape3D.textures = new PImage[2];
        pShape3D.renderTextures = new PTexture[2];
        Arrays.fill(pShape3D.textures, null);
        if (pImageArray != null) {
            int n4 = PApplet.min(pImageArray.length, pShape3D.textures.length);
            PApplet.arrayCopy(pImageArray, 0, pShape3D.textures, 0, n4);
        }
        return pShape3D;
    }

    public void addChild(String string, int n, int n2) {
        PShape pShape = PShape3D.createChild(string, n, n2, this.getDrawModeImpl());
        this.addChild(pShape);
    }

    public void addChild(String string, int n, int n2, int n3) {
        PShape pShape = PShape3D.createChild(string, n, n2, n3);
        this.addChild(pShape);
    }

    public void addChild(String string, int n, int n2, int n3, float f) {
        PShape pShape = PShape3D.createChild(string, n, n2, n3, f);
        this.addChild(pShape);
    }

    public void addChild(String string, int n, int n2, int n3, float f, PImage[] pImageArray) {
        PShape pShape = PShape3D.createChild(string, n, n2, n3, f, pImageArray);
        this.addChild(pShape);
    }

    @Override
    public void addChild(PShape pShape) {
        this.addChildImpl(pShape, true);
    }

    protected void addChildImpl(PShape pShape, boolean bl) {
        if (this.family == 0) {
            super.addChild(pShape);
            if (bl) {
                int n;
                PShape3D pShape3D = (PShape3D)pShape;
                pShape3D.papplet = this.papplet;
                pShape3D.a3d = this.a3d;
                pShape3D.root = this.root;
                pShape3D.numTexBuffers = this.root.numTexBuffers;
                pShape3D.glVertexBufferID = this.root.glVertexBufferID;
                pShape3D.glColorBufferID = this.root.glColorBufferID;
                pShape3D.glNormalBufferID = this.root.glNormalBufferID;
                pShape3D.glTexCoordBufferID = this.root.glTexCoordBufferID;
                pShape3D.glIndexBufferID = this.root.glIndexBufferID;
                pShape3D.vertexBuffer = this.root.vertexBuffer;
                pShape3D.colorBuffer = this.root.colorBuffer;
                pShape3D.normalBuffer = this.root.normalBuffer;
                pShape3D.texCoordBuffer = this.root.texCoordBuffer;
                pShape3D.vertices = this.root.vertices;
                pShape3D.colors = this.root.colors;
                pShape3D.normals = this.root.normals;
                pShape3D.texcoords = this.root.texcoords;
                pShape3D.convTexcoords = this.root.convTexcoords;
                pShape3D.allTexcoords = this.root.allTexcoords;
                pShape3D.vertexChild = this.root.vertexChild;
                pShape3D.texCoordSet = this.root.texCoordSet;
                pShape3D.style = this.root.style;
                for (n = pShape3D.firstVertex; n <= pShape3D.lastVertex; ++n) {
                    pShape3D.vertexChild[n] = pShape3D;
                }
                for (n = 0; n < pShape3D.textures.length; ++n) {
                    if (pShape3D.textures[n] == null || !pShape3D.texCoordSet[n]) continue;
                    pShape3D.loadTexcoords(n);
                    pShape3D.updateTexcoords();
                }
            }
        } else {
            PGraphics.showWarning("PShape3D: Child shapes can only be added to a group shape.");
        }
    }

    @Override
    public void addName(String string, PShape pShape) {
        if (this.nameTable == null) {
            this.nameTable = new HashMap();
        }
        this.nameTable.put(string, pShape);
    }

    protected void addDefaultChild() {
        PShape pShape = PShape3D.createChild("geometry", 0, this.vertexCount - 1, this.getDrawModeImpl(), 0.0f, null);
        this.addChild(pShape);
    }

    public PShape groupChildren(int n, int n2, String string) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new int[]{n, n2}, string);
    }

    public PShape groupChildren(int n, int n2, int n3, String string) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new int[]{n, n2, n3}, string);
    }

    public PShape groupChildren(int[] nArray, String string) {
        if (this.family != 0) {
            return null;
        }
        PShape[] pShapeArray = new PShape[nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            PShape pShape = this.getChild(nArray[i]);
            if (pShape == null) continue;
            pShapeArray[n] = pShape;
            ++n;
        }
        PShape[] pShapeArray2 = new PShape[n];
        PApplet.arrayCopy(pShapeArray, pShapeArray2, n);
        return this.groupChildren(pShapeArray2, string);
    }

    public PShape groupChildren(String string, String string2, String string3) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new String[]{string, string2}, string3);
    }

    public PShape groupChildren(String string, String string2, String string3, String string4) {
        if (this.family != 0) {
            return null;
        }
        return this.groupChildren(new String[]{string, string2, string3}, string4);
    }

    public PShape groupChildren(String[] stringArray, String string) {
        if (this.family != 0) {
            return null;
        }
        PShape[] pShapeArray = new PShape[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            PShape pShape = this.getChild(stringArray[i]);
            if (pShape == null) continue;
            pShapeArray[n] = pShape;
            ++n;
        }
        PShape[] pShapeArray2 = new PShape[n];
        PApplet.arrayCopy(pShapeArray, pShapeArray2, n);
        return this.groupChildren(pShapeArray2, string);
    }

    public PShape groupChildren(PShape[] pShapeArray, String string) {
        int n;
        int n2;
        if (this.family != 0) {
            return null;
        }
        PShape3D pShape3D = new PShape3D();
        pShape3D.family = 0;
        pShape3D.name = string;
        pShape3D.papplet = this.papplet;
        pShape3D.a3d = this.a3d;
        pShape3D.root = this.root;
        PShape pShape = pShapeArray[0];
        PShape pShape2 = pShape.parent;
        if (pShape2 != null) {
            n2 = pShape2.getChildIndex(pShape);
            if (n2 < 0) {
                n2 = 0;
            }
        } else {
            pShape2 = this;
            n2 = 0;
        }
        pShape2.addChild(pShape3D, n2);
        for (n = 0; n < pShapeArray.length; ++n) {
            pShape = pShapeArray[n];
            pShape2 = pShape.parent;
            if (pShape2 == null || -1 >= (n2 = pShape2.getChildIndex(pShape))) continue;
            pShape2.removeChild(n2);
        }
        pShape3D.firstVertex = this.root.vertexCount;
        pShape3D.lastVertex = 0;
        for (n = 0; n < pShapeArray.length; ++n) {
            pShape3D.firstVertex = PApplet.min(pShape3D.firstVertex, ((PShape3D)pShapeArray[n]).firstVertex);
            pShape3D.lastVertex = PApplet.max(pShape3D.lastVertex, ((PShape3D)pShapeArray[n]).lastVertex);
        }
        for (n = 0; n < pShapeArray.length; ++n) {
            pShape3D.addChildImpl(pShapeArray[n], false);
        }
        return pShape3D;
    }

    public int getFirstVertex() {
        return this.firstVertex;
    }

    public int getFirstVertex(int n) {
        if (0 <= n && n < this.childCount) {
            return ((PShape3D)this.children[n]).getFirstVertex();
        }
        return -1;
    }

    public void setFirstVertex(int n) {
        this.firstVertex = n;
    }

    public void setFirstVertex(int n, int n2) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setFirstVertex(n2);
        }
    }

    public int getLastVertex() {
        return this.lastVertex;
    }

    public int getLastVertex(int n) {
        if (0 <= n && n < this.childCount) {
            return ((PShape3D)this.children[n]).getLastVertex();
        }
        return -1;
    }

    public void setLastVertex(int n) {
        this.lastVertex = n;
    }

    public void setLastVertex(int n, int n2) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setLastVertex(n2);
        }
    }

    public void setDrawMode(int n) {
        if (this.family == 0) {
            this.init();
            this.setDrawModeImpl(n);
            for (int i = 0; i < this.childCount; ++i) {
                this.setDrawMode(i, n);
            }
        } else {
            this.setDrawModeImpl(n);
        }
    }

    public void setDrawMode(int n, int n2) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setDrawMode(n2);
        }
    }

    protected void setDrawModeImpl(int n) {
        this.pointSprites = false;
        if (n == 2) {
            this.glMode = 0;
        } else if (n == 52) {
            this.glMode = 0;
            this.pointSprites = true;
        } else if (n == 4) {
            this.glMode = 1;
        } else if (n == 50) {
            this.glMode = 3;
        } else if (n == 51) {
            this.glMode = 2;
        } else if (n == 9) {
            this.glMode = 4;
        } else if (n == 11) {
            this.glMode = 6;
        } else if (n == 10) {
            this.glMode = 5;
        } else {
            throw new RuntimeException("PShape3D: Unknown draw mode");
        }
    }

    protected boolean isTexturable() {
        return this.glMode == 4 || this.glMode == 6 || this.glMode == 5 || this.pointSprites;
    }

    public int getDrawMode() {
        if (this.family == 0) {
            this.init();
            return this.getDrawMode(0);
        }
        return this.getDrawModeImpl();
    }

    public int getDrawMode(int n) {
        if (0 <= n && n < this.childCount) {
            return ((PShape3D)this.children[n]).getDrawMode();
        }
        return -1;
    }

    protected int getDrawModeImpl() {
        if (this.glMode == 0) {
            if (this.pointSprites) {
                return 52;
            }
            return 2;
        }
        if (this.glMode == 1) {
            return 4;
        }
        if (this.glMode == 3) {
            return 50;
        }
        if (this.glMode == 2) {
            return 51;
        }
        if (this.glMode == 4) {
            return 9;
        }
        if (this.glMode == 6) {
            return 11;
        }
        if (this.glMode == 5) {
            return 10;
        }
        return -1;
    }

    public void setTexture(PImage pImage) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setTexture(i, pImage);
            }
        } else {
            this.setTextureImpl(pImage, 0);
        }
    }

    public void setTexture(PImage pImage, PImage pImage2) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setTexture(i, pImage, pImage2);
            }
        } else {
            this.setTextureImpl(pImage, 0);
            this.setTextureImpl(pImage2, 1);
        }
    }

    public void setTexture(PImage pImage, PImage pImage2, PImage pImage3) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setTexture(i, pImage, pImage2, pImage3);
            }
        } else {
            this.setTextureImpl(pImage, 0);
            this.setTextureImpl(pImage2, 1);
            this.setTextureImpl(pImage3, 2);
        }
    }

    public void setTexture(PImage pImage, PImage pImage2, PImage pImage3, PImage pImage4) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setTexture(i, pImage, pImage2, pImage3, pImage4);
            }
        } else {
            this.setTextureImpl(pImage, 0);
            this.setTextureImpl(pImage2, 1);
            this.setTextureImpl(pImage3, 2);
            this.setTextureImpl(pImage4, 3);
        }
    }

    public void setTexture(PImage[] pImageArray) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setTexture(i, pImageArray);
            }
        } else {
            for (int i = 0; i < pImageArray.length; ++i) {
                this.setTextureImpl(pImageArray[i], i);
            }
        }
    }

    public void setTexture(int n, PImage pImage) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setTexture(pImage);
        }
    }

    public void setTexture(int n, PImage pImage, PImage pImage2) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setTexture(pImage, pImage2);
        }
    }

    public void setTexture(int n, PImage pImage, PImage pImage2, PImage pImage3) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setTexture(pImage, pImage2, pImage3);
        }
    }

    public void setTexture(int n, PImage pImage, PImage pImage2, PImage pImage3, PImage pImage4) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setTexture(pImage, pImage2, pImage3, pImage4);
        }
    }

    public void setTexture(int n, PImage[] pImageArray) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setTexture(pImageArray);
        }
    }

    protected void setTextureImpl(PImage pImage, int n) {
        if (n < 0 || PGraphicsAndroid3D.maxTextureUnits <= n) {
            System.err.println("PShape3D: Wrong texture unit.");
            return;
        }
        if (this.numTexBuffers <= n) {
            this.root.addTexBuffers(n - this.numTexBuffers + 1);
        }
        if (pImage == null) {
            throw new RuntimeException("PShape3D: trying to set null texture.");
        }
        if (this.texCoordSet[n] && this.isTexturable()) {
            this.loadTexcoords(n);
            this.textures[n] = pImage;
            this.updateTexcoords();
        } else {
            this.textures[n] = pImage;
        }
    }

    public PImage[] getTexture() {
        if (this.family == 0) {
            this.init();
            return this.getTexture(0);
        }
        return this.textures;
    }

    public PImage[] getTexture(int n) {
        if (0 <= n && n < this.childCount) {
            return ((PShape3D)this.children[n]).getTexture();
        }
        return null;
    }

    public float getStrokeWeight() {
        if (this.family == 0) {
            this.init();
            return this.getStrokeWeight(0);
        }
        return this.strokeWeight;
    }

    public float getStrokeWeight(int n) {
        if (0 <= n && n < this.childCount) {
            return ((PShape3D)this.children[n]).getStrokeWeight();
        }
        return 0.0f;
    }

    public void setStrokeWeight(float f) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setStrokeWeight(i, f);
            }
        } else {
            this.strokeWeight = f;
        }
    }

    public void setStrokeWeight(int n, float f) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setStrokeWeight(f);
        }
    }

    public float getMaxSpriteSize() {
        if (this.family == 0) {
            this.init();
            return this.getMaxSpriteSize(0);
        }
        return this.maxSpriteSize;
    }

    public float getMaxSpriteSize(int n) {
        if (0 <= n && n < this.childCount) {
            return ((PShape3D)this.children[n]).getMaxSpriteSize();
        }
        return 0.0f;
    }

    public void setMaxSpriteSize(float f) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setMaxSpriteSize(i, f);
            }
        } else {
            this.setMaxSpriteSizeImpl(f);
        }
    }

    public void setMaxSpriteSize(int n, float f) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setMaxSpriteSize(f);
        }
    }

    protected void setMaxSpriteSizeImpl(float f) {
        this.maxSpriteSize = PApplet.min(f, PGraphicsAndroid3D.maxPointSize);
    }

    public void setSpriteSize(float f) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setSpriteSize(i, f);
            }
        } else {
            this.setSpriteSizeImpl(f);
        }
    }

    public void setSpriteSize(float f, float f2, int n) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setSpriteSize(i, f, f2, n);
            }
        } else {
            this.setSpriteSizeImpl(f, f2, n);
        }
    }

    public void setSpriteSize(int n, float f) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setSpriteSize(f);
        }
    }

    public void setSpriteSize(int n, float f, float f2, int n2) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setSpriteSize(f, f2, n2);
        }
    }

    protected void setSpriteSizeImpl(float f, float f2, int n) {
        float f3 = this.maxSpriteSize;
        if (n == 0) {
            this.spriteDistAtt[1] = (f3 - f) / (f2 * f);
            this.spriteDistAtt[2] = 0.0f;
        } else if (n == 1) {
            this.spriteDistAtt[1] = 0.0f;
            this.spriteDistAtt[2] = (f3 - f) / (f2 * f2 * f);
        } else {
            PGraphics.showWarning("Invalid point sprite mode");
        }
    }

    protected void setSpriteSizeImpl(float f) {
        this.setMaxSpriteSizeImpl(f);
        this.spriteDistAtt[1] = 0.0f;
        this.spriteDistAtt[2] = 0.0f;
    }

    public void setColor(int n) {
        this.setColor(PShape3D.rgba(n));
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.setColor(new float[]{f, f2, f3, f4});
    }

    public void setColor(float[] fArray) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setColor(i, fArray);
            }
        } else {
            this.setColorImpl(fArray);
        }
    }

    public void setColor(int n, int n2) {
        this.setColor(n, PShape3D.rgba(n2));
    }

    public void setColor(int n, float f, float f2, float f3, float f4) {
        this.setColor(n, new float[]{f, f2, f3, f4});
    }

    public void setColor(int n, float[] fArray) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setColor(fArray);
        }
    }

    protected void setColorImpl(float[] fArray) {
        PShape3D pShape3D = this.root;
        pShape3D.loadColors();
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            pShape3D.set(i, fArray);
        }
        pShape3D.updateColors();
    }

    public void setNormal(float f, float f2, float f3) {
        this.setNormal(new float[]{f, f2, f3});
    }

    public void setNormal(float[] fArray) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.setNormal(i, fArray);
            }
        } else {
            this.setNormalImpl(fArray);
        }
    }

    public void setNormal(int n, float f, float f2, float f3) {
        this.setNormal(n, new float[]{f, f2, f3});
    }

    public void setNormal(int n, float[] fArray) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).setNormal(fArray);
        }
    }

    protected void setNormalImpl(float[] fArray) {
        PShape3D pShape3D = this.root;
        pShape3D.loadNormals();
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            pShape3D.set(i, fArray);
        }
        pShape3D.updateNormals();
    }

    protected void optimizeChildren(ArrayList<PShape3D> arrayList) {
        int n;
        PShape3D pShape3D;
        int n2;
        PShape3D pShape3D2 = arrayList.get(0);
        for (n2 = 1; n2 < arrayList.size(); ++n2) {
            pShape3D = arrayList.get(n2);
            if (pShape3D2.equalTo(pShape3D, false)) {
                pShape3D2.lastVertex = pShape3D.lastVertex;
                pShape3D2.lastIndex = pShape3D.lastIndex;
                for (n = pShape3D2.firstVertex; n <= pShape3D2.lastVertex; ++n) {
                    this.vertexChild[n] = pShape3D2;
                }
                pShape3D.lastVertex = -1;
                pShape3D.firstVertex = -1;
                continue;
            }
            pShape3D2 = pShape3D;
        }
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            if (arrayList.get((int)n2).lastVertex != -1) continue;
            arrayList.remove(n2);
        }
        for (n2 = 1; n2 < arrayList.size(); ++n2) {
            pShape3D = arrayList.get(n2);
            for (n = n2 - 1; n >= 0; --n) {
                pShape3D2 = arrayList.get(n);
                if (!pShape3D.name.equals(pShape3D2.name)) continue;
                int n3 = pShape3D2.name.indexOf(58);
                if (-1 < n3) {
                    String string = pShape3D2.name.substring(n3 + 1);
                    int n4 = 1;
                    try {
                        n4 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        pShape3D2.name = pShape3D2.name + ":1";
                    }
                    pShape3D.name = pShape3D.name + ":" + (n4 + 1);
                    continue;
                }
                pShape3D2.name = pShape3D2.name + ":1";
                pShape3D.name = pShape3D.name + ":2";
            }
        }
    }

    protected boolean equalTo(PShape3D pShape3D, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.family == pShape3D.family && this.glMode == pShape3D.glMode && this.strokeWeight == pShape3D.strokeWeight && (bl || this.name.equals(pShape3D.name));
        if (!bl2) {
            return false;
        }
        for (int i = 0; i < this.textures.length; ++i) {
            if (this.textures[i] == pShape3D.textures[i]) continue;
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public void resetMatrix() {
        this.checkMatrix(3);
        this.matrix.reset();
    }

    @Override
    public void translate(float f, float f2) {
        this.checkMatrix(3);
        this.matrix.translate(f, f2, 0.0f);
    }

    @Override
    public void rotate(float f) {
        this.checkMatrix(3);
        this.matrix.rotate(f);
    }

    @Override
    public void scale(float f) {
        this.checkMatrix(3);
        this.matrix.scale(f);
    }

    @Override
    public void scale(float f, float f2) {
        this.checkMatrix(3);
        this.matrix.scale(f, f2);
    }

    @Override
    public void centerAt(float f, float f2, float f3) {
        float f4 = f - 0.5f * (this.xmin + this.xmax);
        float f5 = f2 - 0.5f * (this.ymin + this.ymax);
        float f6 = f3 - 0.5f * (this.zmin + this.zmax);
        this.loadVertices();
        for (int i = 0; i < this.vertexCount; ++i) {
            int n = 3 * i + 0;
            this.vertices[n] = this.vertices[n] + f4;
            int n2 = 3 * i + 1;
            this.vertices[n2] = this.vertices[n2] + f5;
            int n3 = 3 * i + 2;
            this.vertices[n3] = this.vertices[n3] + f6;
        }
        this.updateVertices();
    }

    public void setVertices(ArrayList<PVector> arrayList) {
        this.setVertices(arrayList, 0);
    }

    public void setVertices(ArrayList<PVector> arrayList, int n) {
        this.loadVertices();
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            PVector pVector = arrayList.get(i - this.firstVertex + n);
            this.set(i, pVector.x, pVector.y, pVector.z);
        }
        this.updateVertices();
    }

    public void setColors(ArrayList<float[]> arrayList) {
        this.setColors(arrayList, 0);
    }

    public void setColors(ArrayList<float[]> arrayList, int n) {
        this.loadColors();
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            float[] fArray = arrayList.get(i - this.firstVertex + n);
            this.set(i, fArray);
        }
        this.updateColors();
    }

    public void setNormals(ArrayList<PVector> arrayList) {
        this.setNormals(arrayList, 0);
    }

    public void setNormals(ArrayList<PVector> arrayList, int n) {
        this.loadNormals();
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            PVector pVector = arrayList.get(i - this.firstVertex + n);
            this.set(i, pVector.x, pVector.y, pVector.z);
        }
        this.updateNormals();
    }

    public void setTexcoords(ArrayList<PVector> arrayList) {
        this.setTexcoords(arrayList, 0);
    }

    public void setTexcoords(ArrayList<PVector> arrayList, int n) {
        this.setTexcoords(0, arrayList, n);
    }

    public void setTexcoords(int n, ArrayList<PVector> arrayList) {
        this.setTexcoords(n, arrayList, 0);
    }

    public void setTexcoords(int n, ArrayList<PVector> arrayList, int n2) {
        this.loadTexcoords(n);
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            PVector pVector = arrayList.get(i - this.firstVertex + n2);
            this.set(i, pVector.x, pVector.y);
        }
        this.updateTexcoords();
    }

    public void setChildren(ArrayList<PShape3D> arrayList) {
        if (this.family != 0) {
            return;
        }
        this.childCount = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            PShape pShape = arrayList.get(i);
            this.addChild(pShape);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mergeChildren() {
        if (this.family != 0) {
            return;
        }
        if (this.children == null) {
            if (this.root != this) return;
            this.addDefaultChild();
            return;
        } else {
            int n;
            PShape3D pShape3D;
            int n2;
            int n3 = 1;
            int n4 = 0;
            PShape3D pShape3D2 = null;
            for (n2 = 0; n2 < this.childCount; ++n2) {
                pShape3D2 = (PShape3D)this.children[n2];
                if (pShape3D2.family != 0) {
                    n4 = n2 + 1;
                    break;
                }
                pShape3D2.mergeChildren();
            }
            if (n4 == 0) {
                return;
            }
            for (n2 = n4; n2 < this.childCount; ++n2) {
                pShape3D = (PShape3D)this.children[n2];
                if (pShape3D.family == 0) {
                    pShape3D.mergeChildren();
                    continue;
                }
                if (pShape3D2.equalTo(pShape3D, true)) {
                    pShape3D2.lastVertex = pShape3D.lastVertex;
                    for (n = pShape3D2.firstVertex; n <= pShape3D2.lastVertex; ++n) {
                        this.vertexChild[n] = pShape3D2;
                    }
                    pShape3D.lastVertex = -1;
                    pShape3D.firstVertex = -1;
                    continue;
                }
                pShape3D2 = pShape3D;
                ++n3;
            }
            PShape[] pShapeArray = new PShape[n3];
            n = 0;
            for (int i = 0; i < this.childCount; ++i) {
                pShape3D = (PShape3D)this.children[i];
                if (pShape3D.family == 3 && pShape3D.lastVertex == -1 && pShape3D.getName() != null && this.nameTable != null) {
                    this.nameTable.remove(pShape3D.getName());
                    continue;
                }
                pShapeArray[n++] = pShape3D;
            }
            this.children = pShapeArray;
            this.childCount = n3;
        }
    }

    public void translateVertices(float f, float f2) {
        this.translateVertices(f, f2, 0.0f);
    }

    public void translateVertices(float f, float f2, float f3) {
        this.init();
        this.loadVertices();
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            int n = 3 * i + 0;
            this.vertices[n] = this.vertices[n] + f;
            int n2 = 3 * i + 1;
            this.vertices[n2] = this.vertices[n2] + -f2;
            int n3 = 3 * i + 2;
            this.vertices[n3] = this.vertices[n3] + f3;
        }
        this.updateVertices();
    }

    public void rotateVerticesX(float f) {
        this.rotateVertices(f, 1.0f, 0.0f, 0.0f);
    }

    public void rotateVerticesY(float f) {
        this.rotateVertices(f, 0.0f, 1.0f, 0.0f);
    }

    public void rotateVerticesZ(float f) {
        this.rotateVertices(f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateVertices(float f) {
        this.rotateVertices(f, 0.0f, 0.0f, 1.0f);
    }

    public void rotateVertices(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        int n;
        float f8;
        this.init();
        float f9 = f2 * f2 + f3 * f3 + f4 * f4;
        if (Math.abs(f9 - 1.0f) > 1.0E-4f) {
            f8 = PApplet.sqrt(f9);
            f2 /= f8;
            f3 /= f8;
            f4 /= f8;
        }
        f8 = 0.5f * (this.xmin + this.xmax);
        float f10 = 0.5f * (this.ymin + this.ymax);
        float f11 = 0.5f * (this.zmin + this.zmax);
        float f12 = PApplet.cos(f);
        float f13 = PApplet.sin(f);
        float f14 = 1.0f - f12;
        float[] fArray = new float[]{f14 * f2 * f2 + f12, f14 * f2 * f3 - f13 * f4, f14 * f2 * f4 + f13 * f3, f14 * f2 * f3 + f13 * f4, f14 * f3 * f3 + f12, f14 * f3 * f4 - f13 * f2, f14 * f2 * f4 - f13 * f3, f14 * f3 * f4 + f13 * f2, f14 * f4 * f4 + f12};
        this.loadVertices();
        for (n = this.firstVertex; n <= this.lastVertex; ++n) {
            f7 = this.vertices[3 * n + 0] - f8;
            f6 = this.vertices[3 * n + 1] - f10;
            f5 = this.vertices[3 * n + 2] - f11;
            this.vertices[3 * n + 0] = fArray[0] * f7 + fArray[1] * f6 + fArray[2] * f5 + f8;
            this.vertices[3 * n + 1] = fArray[3] * f7 + fArray[4] * f6 + fArray[5] * f5 + f10;
            this.vertices[3 * n + 2] = fArray[6] * f7 + fArray[7] * f6 + fArray[8] * f5 + f11;
        }
        this.updateVertices();
        this.centerAt(f8, f10, f11);
        this.loadNormals();
        for (n = this.firstVertex; n <= this.lastVertex; ++n) {
            f7 = this.normals[3 * n + 0];
            f6 = this.normals[3 * n + 1];
            f5 = this.normals[3 * n + 2];
            this.normals[3 * n + 0] = fArray[0] * f7 + fArray[1] * f6 + fArray[2] * f5 + f8;
            this.normals[3 * n + 1] = fArray[3] * f7 + fArray[4] * f6 + fArray[5] * f5 + f10;
            this.normals[3 * n + 2] = fArray[6] * f7 + fArray[7] * f6 + fArray[8] * f5 + f11;
        }
        this.updateNormals();
    }

    public void scaleVertices(float f) {
        this.scaleVertices(f, f, f);
    }

    public void scaleVertices(float f, float f2) {
        this.scaleVertices(f, f2, 1.0f);
    }

    public void scaleVertices(float f, float f2, float f3) {
        this.init();
        this.loadVertices();
        for (int i = this.firstVertex; i <= this.lastVertex; ++i) {
            int n = 3 * i + 0;
            this.vertices[n] = this.vertices[n] * f;
            int n2 = 3 * i + 1;
            this.vertices[n2] = this.vertices[n2] * f2;
            int n3 = 3 * i + 2;
            this.vertices[n3] = this.vertices[n3] * f3;
        }
        this.updateVertices();
    }

    public Parameters getParameters() {
        if (this.root != this) {
            return null;
        }
        Parameters parameters = new Parameters();
        parameters.drawMode = this.getDrawModeImpl();
        if (this.glUsage == 35044) {
            parameters.updateMode = 0;
        } else if (this.glUsage == 35048) {
            parameters.updateMode = 1;
        }
        return parameters;
    }

    protected void setParameters(Parameters parameters) {
        if (this.root != this) {
            return;
        }
        this.setDrawModeImpl(parameters.drawMode);
        if (parameters.updateMode == 0) {
            this.glUsage = 35044;
        } else if (parameters.updateMode == 1) {
            this.glUsage = 35048;
        } else {
            throw new RuntimeException("PShape3D: Unknown update mode");
        }
    }

    public void initIndices(int n) {
        this.indexCount = n;
        this.glIndexBufferID = this.a3d.createGLResource(1);
        this.getGl().glBindBuffer(34962, this.glIndexBufferID);
        int n2 = this.indexCount * 4;
        this.getGl().glBufferData(34962, n2, null, 35044);
        this.getGl().glBindBuffer(34962, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.indexCount * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.indexBuffer = byteBuffer.asShortBuffer();
        this.indices = new short[this.indexCount];
        this.useIndices = true;
    }

    public void setIndices(ArrayList<Short> arrayList) {
        this.getGl().glBindBuffer(34963, this.glIndexBufferID);
        for (int i = 0; i < this.indexCount; ++i) {
            this.indices[i] = arrayList.get(i);
        }
        this.indexBuffer.position(0);
        this.indexBuffer.put(this.indices);
        this.indexBuffer.flip();
        this.getGl().glBufferSubData(34963, 0, this.indexCount * 2, (Buffer)this.indexBuffer);
        this.getGl().glBindBuffer(34963, 0);
    }

    public void setIndices(int[] nArray) {
        this.getGl().glBindBuffer(34963, this.glIndexBufferID);
        PApplet.arrayCopy(nArray, this.indices);
        this.indexBuffer.position(0);
        this.indexBuffer.put(this.indices);
        this.indexBuffer.flip();
        this.getGl().glBufferSubData(34963, 0, this.indexCount * 2, (Buffer)this.indexBuffer);
        this.getGl().glBindBuffer(34963, 0);
    }

    public void useIndices(boolean bl) {
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.useIndices(i, bl);
            }
        } else {
            this.useIndices = bl;
        }
    }

    public void useIndices(int n, boolean bl) {
        if (0 <= n && n < this.childCount) {
            ((PShape3D)this.children[n]).useIndices = bl;
            ((PShape3D)this.children[n]).firstIndex = 0;
            ((PShape3D)this.children[n]).lastIndex = this.indexCount - 1;
        }
    }

    public void init() {
        if (this.root != this) {
            return;
        }
        if (this.readFromOBJ) {
            this.recordOBJ();
            this.centerAt(0.0f, 0.0f, 0.0f);
        }
        if (this.children == null) {
            this.addDefaultChild();
        }
    }

    protected void initShape(int n) {
        this.initShape(n, new Parameters());
    }

    protected void initShape(int n, Parameters parameters) {
        if (this.a3d.gl11 == null) {
            throw new RuntimeException("PShape3D: OpenGL ES 1.1 required");
        }
        if (!PGraphicsAndroid3D.vboSupported) {
            throw new RuntimeException("PShape3D: Vertex Buffer Objects are not available");
        }
        this.setParameters(parameters);
        this.setSize(n);
        this.allocate();
        this.initChildrenData();
        this.updateElement = -1;
        this.resetBounds();
    }

    protected void initShapeOBJ(String string, Parameters parameters) {
        if (this.a3d.gl11 == null) {
            throw new RuntimeException("PShape3D: OpenGL ES 1.1 required");
        }
        if (!PGraphicsAndroid3D.vboSupported) {
            throw new RuntimeException("PShape3D: Vertex Buffer Objects are not available");
        }
        this.readFromOBJ = true;
        this.objVertices = new ArrayList();
        this.objNormal = new ArrayList();
        this.objTexCoords = new ArrayList();
        this.objFaces = new ArrayList();
        this.objMaterials = new ArrayList();
        BufferedReader bufferedReader = this.getBufferedReader(string);
        if (bufferedReader == null) {
            throw new RuntimeException("PShape3D: Cannot read source file");
        }
        if (parameters == null) {
            parameters = PShape3D.newParameters(9, 0);
        } else {
            parameters.drawMode = 9;
        }
        this.setParameters(parameters);
        this.parseOBJ(bufferedReader, this.objVertices, this.objNormal, this.objTexCoords, this.objFaces, this.objMaterials);
        this.vertexCount = this.objVertices.size();
    }

    protected void setSize(int n) {
        this.vertexCount = n;
        this.numTexBuffers = 1;
        this.firstVertex = 0;
        this.lastVertex = n - 1;
        this.initVertexData();
        this.initColorData();
        this.initNormalData();
        this.initTexCoordData();
    }

    protected void allocate() {
        this.release();
        this.createVertexBuffer();
        this.createColorBuffer();
        this.createNormalBuffer();
        this.createTexCoordBuffer();
    }

    protected void release() {
        this.deleteVertexBuffer();
        this.deleteColorBuffer();
        this.deleteTexCoordBuffer();
        this.deleteNormalBuffer();
        this.deleteIndexBuffer();
    }

    protected void initVertexData() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.vertexCount * 3 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertices = new float[this.vertexCount * 3];
        this.vertexBuffer.put(this.vertices);
        this.vertexBuffer.flip();
    }

    protected void createVertexBuffer() {
        this.glVertexBufferID = this.a3d.createGLResource(1);
        this.getGl().glBindBuffer(34962, this.glVertexBufferID);
        int n = this.vertexBuffer.capacity() * 4;
        this.getGl().glBufferData(34962, n, (Buffer)this.vertexBuffer, this.glUsage);
        this.getGl().glBindBuffer(34962, 0);
    }

    protected void initColorData() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.vertexCount * 4 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.colorBuffer = byteBuffer.asFloatBuffer();
        this.colors = new float[this.vertexCount * 4];
        Arrays.fill(this.colors, 1.0f);
        this.colorBuffer.put(this.colors);
        this.colorBuffer.flip();
    }

    protected void createColorBuffer() {
        this.glColorBufferID = this.a3d.createGLResource(1);
        this.getGl().glBindBuffer(34962, this.glColorBufferID);
        int n = this.colorBuffer.capacity() * 4;
        this.getGl().glBufferData(34962, n, (Buffer)this.colorBuffer, this.glUsage);
        this.getGl().glBindBuffer(34962, 0);
    }

    protected void initNormalData() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.vertexCount * 3 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.normalBuffer = byteBuffer.asFloatBuffer();
        this.normals = new float[this.vertexCount * 3];
        this.normalBuffer.put(this.normals);
        this.normalBuffer.flip();
    }

    protected void createNormalBuffer() {
        this.glNormalBufferID = this.a3d.createGLResource(1);
        this.getGl().glBindBuffer(34962, this.glNormalBufferID);
        int n = this.normalBuffer.capacity() * 4;
        this.getGl().glBufferData(34962, n, (Buffer)this.normalBuffer, this.glUsage);
        this.getGl().glBindBuffer(34962, 0);
    }

    protected void initTexCoordData() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.vertexCount * 2 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.texCoordBuffer = byteBuffer.asFloatBuffer();
        this.allTexcoords = new float[1][this.vertexCount * 2];
        this.texcoords = this.allTexcoords[0];
        this.convTexcoords = new float[this.vertexCount * 2];
        this.texCoordBuffer.put(this.convTexcoords);
        this.texCoordBuffer.flip();
        this.texCoordSet = new boolean[2];
    }

    protected void createTexCoordBuffer() {
        if (this.glTexCoordBufferID == null) {
            this.glTexCoordBufferID = new int[2];
            Arrays.fill(this.glTexCoordBufferID, 0);
        }
        this.glTexCoordBufferID[0] = this.a3d.createGLResource(1);
        this.getGl().glBindBuffer(34962, this.glTexCoordBufferID[0]);
        int n = this.texCoordBuffer.capacity() * 4;
        this.getGl().glBufferData(34962, n, (Buffer)this.texCoordBuffer, this.glUsage);
        this.getGl().glBindBuffer(34962, 0);
    }

    protected void addTexBuffers(int n) {
        int n2;
        for (int i = 0; i < n; ++i) {
            n2 = this.numTexBuffers + i;
            this.deleteTexCoordBuffer(n2);
            this.glTexCoordBufferID[n2] = this.a3d.createGLResource(1);
            this.getGl().glBindBuffer(34962, this.glTexCoordBufferID[n2]);
            int n3 = this.texCoordBuffer.capacity() * 4;
            this.getGl().glBufferData(34962, n3, (Buffer)this.texCoordBuffer, this.glUsage);
            this.getGl().glBindBuffer(34962, 0);
        }
        float[][] fArray = new float[this.numTexBuffers + n][this.vertexCount * 2];
        for (n2 = 0; n2 < this.numTexBuffers; ++n2) {
            PApplet.arrayCopy(this.allTexcoords[n2], fArray[n2]);
        }
        this.allTexcoords = fArray;
        this.texcoords = this.allTexcoords[0];
        this.numTexBuffers += n;
        this.updateTexBuffers();
    }

    protected void updateTexBuffers() {
        if (this.family == 0) {
            for (int i = 0; i < this.childCount; ++i) {
                ((PShape3D)this.children[i]).updateTexBuffers();
            }
        } else {
            this.numTexBuffers = this.root.numTexBuffers;
            this.allTexcoords = this.root.allTexcoords;
            this.texcoords = this.allTexcoords[0];
        }
    }

    protected void deleteVertexBuffer() {
        if (this.glVertexBufferID != 0) {
            this.a3d.deleteGLResource(this.glVertexBufferID, 1);
            this.glVertexBufferID = 0;
        }
    }

    protected void deleteColorBuffer() {
        if (this.glColorBufferID != 0) {
            this.a3d.deleteGLResource(this.glColorBufferID, 1);
            this.glColorBufferID = 0;
        }
    }

    protected void deleteNormalBuffer() {
        if (this.glNormalBufferID != 0) {
            this.a3d.deleteGLResource(this.glNormalBufferID, 1);
            this.glNormalBufferID = 0;
        }
    }

    protected void deleteIndexBuffer() {
        if (this.glIndexBufferID != 0) {
            this.a3d.deleteGLResource(this.glIndexBufferID, 1);
            this.glIndexBufferID = 0;
        }
    }

    protected void deleteTexCoordBuffer() {
        if (this.glTexCoordBufferID != null) {
            for (int i = 0; i < this.glTexCoordBufferID.length; ++i) {
                this.deleteTexCoordBuffer(i);
            }
        }
    }

    protected void deleteTexCoordBuffer(int n) {
        if (this.glTexCoordBufferID[n] != 0) {
            this.a3d.deleteGLResource(this.glTexCoordBufferID[n], 1);
            this.glTexCoordBufferID[n] = 0;
        }
    }

    protected void initChildrenData() {
        this.children = null;
        this.vertexChild = new PShape3D[this.vertexCount];
    }

    @Override
    public float[] getVertex(int n) {
        PGraphics.showMethodWarning("getVertex");
        return null;
    }

    @Override
    public float getVertexX(int n) {
        PGraphics.showMethodWarning("getVertexX");
        return 0.0f;
    }

    @Override
    public float getVertexY(int n) {
        PGraphics.showMethodWarning("getVertexY");
        return 0.0f;
    }

    @Override
    public float getVertexZ(int n) {
        PGraphics.showMethodWarning("getVertexZ");
        return 0.0f;
    }

    @Override
    public int[] getVertexCodes() {
        PGraphics.showMethodWarning("getVertexCodes");
        return null;
    }

    @Override
    public int getVertexCodeCount() {
        PGraphics.showMethodWarning("getVertexCodeCount");
        return 0;
    }

    @Override
    public int getVertexCode(int n) {
        PGraphics.showMethodWarning("getVertexCode");
        return 0;
    }

    @Override
    public void disableStyle() {
        this.style = false;
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.children[i].disableStyle();
            }
        }
    }

    @Override
    public void enableStyle() {
        this.style = true;
        if (this.family == 0) {
            this.init();
            for (int i = 0; i < this.childCount; ++i) {
                this.children[i].enableStyle();
            }
        }
    }

    @Override
    protected void styles(PGraphics pGraphics) {
    }

    @Override
    public boolean is3D() {
        return true;
    }

    public void draw() {
        this.draw(this.a3d);
    }

    @Override
    public void draw(PGraphics pGraphics) {
        if (this.visible) {
            if (this.matrix != null) {
                pGraphics.pushMatrix();
                pGraphics.applyMatrix(this.matrix);
            }
            if (this.family == 0) {
                this.init();
                for (int i = 0; i < this.childCount; ++i) {
                    ((PShape3D)this.children[i]).draw(pGraphics);
                }
            } else {
                this.drawGeometry(pGraphics);
            }
            if (this.matrix != null) {
                pGraphics.popMatrix();
            }
        }
    }

    @Override
    protected void pre(PGraphics pGraphics) {
        if (this.matrix != null) {
            pGraphics.pushMatrix();
            pGraphics.applyMatrix(this.matrix);
        }
    }

    @Override
    public void post(PGraphics pGraphics) {
        if (this.matrix != null) {
            pGraphics.popMatrix();
        }
    }

    @Override
    public void drawImpl(PGraphics pGraphics) {
        if (this.family == 0) {
            this.drawGroup(pGraphics);
        } else {
            this.drawGeometry(pGraphics);
        }
    }

    @Override
    protected void drawGroup(PGraphics pGraphics) {
        this.init();
        for (int i = 0; i < this.childCount; ++i) {
            this.children[i].draw(pGraphics);
        }
    }

    @Override
    protected void drawGeometry(PGraphics pGraphics) {
        int n;
        float f;
        if (0.0f < this.strokeWeight && this.style) {
            this.getGl().glLineWidth(this.strokeWeight);
            f = PApplet.min(this.strokeWeight, PGraphicsAndroid3D.maxPointSize);
        } else {
            this.getGl().glLineWidth(pGraphics.strokeWeight);
            f = PApplet.min(pGraphics.strokeWeight, PGraphicsAndroid3D.maxPointSize);
        }
        if (!this.pointSprites) {
            this.getGl().glPointSize(f);
        }
        this.getGl().glEnableClientState(32885);
        this.getGl().glBindBuffer(34962, this.glNormalBufferID);
        this.getGl().glNormalPointer(5126, 0, 0);
        if (this.style) {
            this.getGl().glEnableClientState(32886);
            this.getGl().glBindBuffer(34962, this.glColorBufferID);
            this.getGl().glColorPointer(4, 5126, 0, 0);
        }
        this.getGl().glEnableClientState(32884);
        this.getGl().glBindBuffer(34962, this.glVertexBufferID);
        this.getGl().glVertexPointer(3, 5126, 0, 0);
        int n2 = 0;
        if (this.style) {
            for (n = 0; n < this.textures.length && this.textures[n] != null; ++n) {
                PTexture pTexture = (PTexture)this.textures[n].getCache(this.a3d);
                pTexture = this.a3d.getTexture(this.textures[n]);
                if (pTexture == null) break;
                this.getGl().glEnable(pTexture.glTarget);
                this.getGl().glActiveTexture(33984 + n);
                this.getGl().glBindTexture(pTexture.glTarget, pTexture.glID);
                this.renderTextures[n2] = pTexture;
                ++n2;
            }
        }
        if (0 < n2) {
            if (this.pointSprites) {
                this.getGl().glPointParameterf(33064, 0.6f * this.maxSpriteSize);
                this.getGl().glPointParameterf(33062, 1.0f);
                this.getGl().glPointParameterf(33063, this.maxSpriteSize);
                this.getGl().glPointSize(this.maxSpriteSize);
                this.getGl().glPointParameterfv(33065, this.spriteDistAtt, 0);
                this.getGl().glTexEnvf(34913, 34914, 1.0f);
                this.getGl().glEnable(34913);
            } else {
                for (n = 0; n < n2; ++n) {
                    this.getGl().glClientActiveTexture(33984 + n);
                    this.getGl().glEnableClientState(32888);
                    this.getGl().glBindBuffer(34962, this.glTexCoordBufferID[n]);
                    this.getGl().glTexCoordPointer(2, 5126, 0, 0);
                }
                if (1 < n2) {
                    this.a3d.setTextureBlend(this.renderTextures, n2);
                }
            }
        }
        if (!this.style) {
            if (0 < n2) {
                if (pGraphics.tint) {
                    this.getGl().glColor4f(pGraphics.tintR, pGraphics.tintG, pGraphics.tintB, pGraphics.tintA);
                } else {
                    this.getGl().glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.getGl().glColor4f(pGraphics.fillR, pGraphics.fillG, pGraphics.fillB, pGraphics.fillA);
            }
        }
        if (this.glIndexBufferID != 0 && this.useIndices) {
            this.getGl().glBindBuffer(34963, this.glIndexBufferID);
            n = this.lastIndex;
            int n3 = this.firstIndex;
            this.getGl().glDrawElements(this.glMode, n - n3 + 1, 5123, n3 * 2);
            this.getGl().glBindBuffer(34963, 0);
        } else {
            this.getGl().glDrawArrays(this.glMode, this.firstVertex, this.lastVertex - this.firstVertex + 1);
        }
        if (0 < n2) {
            for (n = 0; n < n2; ++n) {
                PTexture pTexture = this.renderTextures[n];
                this.getGl().glActiveTexture(33984 + n);
                this.getGl().glBindTexture(pTexture.glTarget, 0);
            }
            for (n = 0; n < n2; ++n) {
                PTexture pTexture = this.renderTextures[n];
                this.getGl().glDisable(pTexture.glTarget);
            }
            if (this.pointSprites) {
                this.getGl().glDisable(34913);
            } else {
                for (n = 0; n < n2; ++n) {
                    this.getGl().glClientActiveTexture(33984 + n);
                    this.getGl().glDisableClientState(32888);
                }
                if (1 < n2) {
                    this.a3d.cleanupTextureBlend(n2);
                }
            }
        }
        this.getGl().glBindBuffer(34962, 0);
        this.getGl().glDisableClientState(32884);
        this.getGl().glDisableClientState(32886);
        this.getGl().glDisableClientState(32885);
    }

    protected GL11 getGl() {
        return this.a3d.gl11;
    }

    public static Parameters newParameters() {
        return new Parameters();
    }

    public static Parameters newParameters(int n) {
        return new Parameters(n);
    }

    public static Parameters newParameters(int n, int n2) {
        return new Parameters(n, n2);
    }

    protected BufferedReader getBufferedReader(String string) {
        BufferedReader bufferedReader = this.papplet.createReader(string);
        if (bufferedReader != null) {
            return bufferedReader;
        }
        PApplet.println("Could not find this file " + string);
        return null;
    }

    protected void parseOBJ(BufferedReader bufferedReader, ArrayList<PVector> arrayList, ArrayList<PVector> arrayList2, ArrayList<PVector> arrayList3, ArrayList<OBJFace> arrayList4, ArrayList<OBJMaterial> arrayList5) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n = -1;
        try {
            Object object;
            String string;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = "object";
            while ((string = bufferedReader.readLine()) != null) {
                Object object2;
                while (string.contains("\\")) {
                    string = string.split("\\\\")[0];
                    object = bufferedReader.readLine();
                    if (object == null) continue;
                    string = string + (String)object;
                }
                object = string.split("\\s+");
                if (((String[])object).length <= 0) continue;
                if (object[0].equals("v")) {
                    object2 = new PVector(Float.valueOf(object[1]).floatValue(), Float.valueOf(object[2]).floatValue(), Float.valueOf(object[3]).floatValue());
                    arrayList.add((PVector)object2);
                    bl3 = true;
                    continue;
                }
                if (object[0].equals("vn")) {
                    object2 = new PVector(Float.valueOf(object[1]).floatValue(), Float.valueOf(object[2]).floatValue(), Float.valueOf(object[3]).floatValue());
                    arrayList2.add((PVector)object2);
                    bl2 = true;
                    continue;
                }
                if (object[0].equals("vt")) {
                    object2 = new PVector(Float.valueOf(object[1]).floatValue(), Float.valueOf(object[2]).floatValue());
                    arrayList3.add((PVector)object2);
                    bl = true;
                    continue;
                }
                if (object[0].equals("o")) continue;
                if (object[0].equals("mtllib")) {
                    if (object[1] == null) continue;
                    this.parseMTL(this.getBufferedReader(object[1]), arrayList5, hashtable);
                    continue;
                }
                if (object[0].equals("g")) {
                    string2 = object[1];
                    continue;
                }
                if (object[0].equals("usemtl")) {
                    if (object[1] == null) continue;
                    object2 = object[1];
                    if (hashtable.containsKey(object2)) {
                        Integer n2 = hashtable.get(object2);
                        n = n2;
                        continue;
                    }
                    n = -1;
                    continue;
                }
                if (!object[0].equals("f")) continue;
                object2 = new OBJFace();
                ((OBJFace)object2).matIdx = n;
                ((OBJFace)object2).name = string2;
                for (int i = 1; i < ((String[])object).length; ++i) {
                    String string3 = object[i];
                    if (string3.indexOf("/") > 0) {
                        String[] stringArray = string3.split("/");
                        if (stringArray.length > 2) {
                            if (stringArray[0].length() > 0 && bl3) {
                                ((OBJFace)object2).vertIdx.add(Integer.valueOf(stringArray[0]));
                            }
                            if (stringArray[1].length() > 0 && bl) {
                                ((OBJFace)object2).texIdx.add(Integer.valueOf(stringArray[1]));
                            }
                            if (stringArray[2].length() <= 0 || !bl2) continue;
                            ((OBJFace)object2).normIdx.add(Integer.valueOf(stringArray[2]));
                            continue;
                        }
                        if (stringArray.length > 1) {
                            if (stringArray[0].length() > 0 && bl3) {
                                ((OBJFace)object2).vertIdx.add(Integer.valueOf(stringArray[0]));
                            }
                            if (stringArray[1].length() <= 0) continue;
                            if (bl) {
                                ((OBJFace)object2).texIdx.add(Integer.valueOf(stringArray[1]));
                                continue;
                            }
                            if (!bl2) continue;
                            ((OBJFace)object2).normIdx.add(Integer.valueOf(stringArray[1]));
                            continue;
                        }
                        if (stringArray.length <= 0 || stringArray[0].length() <= 0 || !bl3) continue;
                        ((OBJFace)object2).vertIdx.add(Integer.valueOf(stringArray[0]));
                        continue;
                    }
                    if (string3.length() <= 0 || !bl3) continue;
                    ((OBJFace)object2).vertIdx.add(Integer.valueOf(string3));
                }
                arrayList4.add((OBJFace)object2);
            }
            if (arrayList5.size() == 0) {
                object = new OBJMaterial();
                arrayList5.add((OBJMaterial)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void parseMTL(BufferedReader bufferedReader, ArrayList<OBJMaterial> arrayList, Hashtable<String, Integer> hashtable) {
        try {
            String string;
            OBJMaterial oBJMaterial = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                String[] stringArray = (string = string.trim()).split("\\s+");
                if (stringArray.length <= 0) continue;
                if (stringArray[0].equals("newmtl")) {
                    string2 = stringArray[1];
                    oBJMaterial = new OBJMaterial(string2);
                    hashtable.put(string2, new Integer(arrayList.size()));
                    arrayList.add(oBJMaterial);
                    continue;
                }
                if (stringArray[0].equals("map_Kd") && stringArray.length > 1) {
                    string2 = stringArray[1];
                    oBJMaterial.kdMap = this.papplet.loadImage(string2);
                    continue;
                }
                if (stringArray[0].equals("Ka") && stringArray.length > 3) {
                    oBJMaterial.ka.x = Float.valueOf(stringArray[1]).floatValue();
                    oBJMaterial.ka.y = Float.valueOf(stringArray[2]).floatValue();
                    oBJMaterial.ka.z = Float.valueOf(stringArray[3]).floatValue();
                    continue;
                }
                if (stringArray[0].equals("Kd") && stringArray.length > 3) {
                    oBJMaterial.kd.x = Float.valueOf(stringArray[1]).floatValue();
                    oBJMaterial.kd.y = Float.valueOf(stringArray[2]).floatValue();
                    oBJMaterial.kd.z = Float.valueOf(stringArray[3]).floatValue();
                    continue;
                }
                if (stringArray[0].equals("Ks") && stringArray.length > 3) {
                    oBJMaterial.ks.x = Float.valueOf(stringArray[1]).floatValue();
                    oBJMaterial.ks.y = Float.valueOf(stringArray[2]).floatValue();
                    oBJMaterial.ks.z = Float.valueOf(stringArray[3]).floatValue();
                    continue;
                }
                if ((stringArray[0].equals("d") || stringArray[0].equals("Tr")) && stringArray.length > 1) {
                    oBJMaterial.d = Float.valueOf(stringArray[1]).floatValue();
                    continue;
                }
                if (!stringArray[0].equals("Ns") || stringArray.length <= 1) continue;
                oBJMaterial.ns = Float.valueOf(stringArray[1]).floatValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void recordOBJ() {
        this.recordOBJ(this.objVertices, this.objNormal, this.objTexCoords, this.objFaces, this.objMaterials);
        this.objVertices = null;
        this.objNormal = null;
        this.objTexCoords = null;
        this.objFaces = null;
        this.objMaterials = null;
        this.readFromOBJ = false;
    }

    protected void recordOBJ(ArrayList<PVector> arrayList, ArrayList<PVector> arrayList2, ArrayList<PVector> arrayList3, ArrayList<OBJFace> arrayList4, ArrayList<OBJMaterial> arrayList5) {
        int n = -1;
        OBJMaterial oBJMaterial = null;
        this.a3d.saveDrawingState();
        this.a3d.mergeRecShapes = false;
        this.a3d.colorMode = 1;
        this.a3d.stroke = false;
        this.a3d.autoNormal(true);
        this.a3d.textureMode = 1;
        this.a3d.beginShapeRecorderImpl();
        for (int i = 0; i < arrayList4.size(); ++i) {
            OBJFace oBJFace = arrayList4.get(i);
            if (n != oBJFace.matIdx) {
                n = PApplet.max(0, oBJFace.matIdx);
                oBJMaterial = arrayList5.get(n);
                this.a3d.specular(oBJMaterial.ks.x * 255.0f, oBJMaterial.ks.y * 255.0f, oBJMaterial.ks.z * 255.0f);
                this.a3d.ambient(oBJMaterial.ka.x * 255.0f, oBJMaterial.ka.y * 255.0f, oBJMaterial.ka.z * 255.0f);
                if (this.a3d.fill) {
                    this.a3d.fill(oBJMaterial.kd.x * 255.0f, oBJMaterial.kd.y * 255.0f, oBJMaterial.kd.z * 255.0f, oBJMaterial.d * 255.0f);
                }
                this.a3d.shininess(oBJMaterial.ns);
                if (this.a3d.tint && oBJMaterial.kdMap != null) {
                    this.a3d.tint(oBJMaterial.kd.x * 255.0f, oBJMaterial.kd.y * 255.0f, oBJMaterial.kd.z * 255.0f, oBJMaterial.d * 255.0f);
                }
            }
            if (oBJFace.vertIdx.size() == 3) {
                this.a3d.beginShape(9);
            } else if (oBJFace.vertIdx.size() == 4) {
                this.a3d.beginShape(16);
            } else {
                this.a3d.beginShape();
            }
            this.a3d.shapeName(oBJFace.name);
            for (int j = 0; j < oBJFace.vertIdx.size(); ++j) {
                int n2;
                PVector pVector = null;
                PVector pVector2 = null;
                int n3 = oBJFace.vertIdx.get(j) - 1;
                pVector2 = arrayList.get(n3);
                if (j < oBJFace.normIdx.size() && -1 < (n2 = oBJFace.normIdx.get(j) - 1)) {
                    pVector = arrayList2.get(n2);
                }
                if (oBJMaterial != null && oBJMaterial.kdMap != null) {
                    PTexture pTexture;
                    int n4;
                    PVector pVector3 = null;
                    if (j < oBJFace.texIdx.size() && -1 < (n4 = oBJFace.texIdx.get(j) - 1)) {
                        pVector3 = arrayList3.get(n4);
                    }
                    if ((pTexture = (PTexture)oBJMaterial.kdMap.getCache(this.a3d)) != null) {
                        pTexture.setFlippedY(true);
                    }
                    this.a3d.texture(oBJMaterial.kdMap);
                    if (pVector != null) {
                        this.a3d.normal(pVector.x, pVector.y, pVector.z);
                    }
                    if (pVector3 != null) {
                        this.a3d.vertex(pVector2.x, pVector2.y, pVector2.z, pVector3.x, pVector3.y);
                        continue;
                    }
                    this.a3d.vertex(pVector2.x, pVector2.y, pVector2.z);
                    continue;
                }
                if (pVector != null) {
                    this.a3d.normal(pVector.x, pVector.y, pVector.z);
                }
                this.a3d.vertex(pVector2.x, pVector2.y, pVector2.z);
            }
            this.a3d.endShape(2);
        }
        this.setSize(this.a3d.recordedVertices.size());
        this.allocate();
        this.initChildrenData();
        this.updateElement = -1;
        this.depth = 0.0f;
        this.height = 0.0f;
        this.width = 0.0f;
        this.zmin = 10000.0f;
        this.ymin = 10000.0f;
        this.xmin = 10000.0f;
        this.zmax = -10000.0f;
        this.ymax = -10000.0f;
        this.xmax = -10000.0f;
        this.a3d.endShapeRecorderImpl(this);
        this.a3d.restoreDrawingState();
    }

    protected class OBJMaterial {
        String name;
        PVector ka;
        PVector kd;
        PVector ks;
        float d;
        float ns;
        PImage kdMap;

        OBJMaterial() {
            this("default");
        }

        OBJMaterial(String string) {
            this.name = string;
            this.ka = new PVector(0.5f, 0.5f, 0.5f);
            this.kd = new PVector(0.5f, 0.5f, 0.5f);
            this.ks = new PVector(0.5f, 0.5f, 0.5f);
            this.d = 1.0f;
            this.ns = 0.0f;
            this.kdMap = null;
        }
    }

    protected class OBJFace {
        ArrayList<Integer> vertIdx = new ArrayList();
        ArrayList<Integer> texIdx = new ArrayList();
        ArrayList<Integer> normIdx = new ArrayList();
        int matIdx = -1;
        String name = "";

        OBJFace() {
        }
    }

    public static class Parameters {
        public int drawMode;
        public int updateMode;

        public Parameters() {
            this.drawMode = 2;
            this.updateMode = 0;
        }

        public Parameters(int n) {
            this.drawMode = n;
            this.updateMode = 0;
        }

        public Parameters(int n, int n2) {
            this.drawMode = n;
            this.updateMode = n2;
        }

        public Parameters(Parameters parameters) {
            this.drawMode = parameters.drawMode;
            this.updateMode = parameters.updateMode;
        }
    }
}

