/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.graphics.Bitmap;
import android.opengl.GLUtils;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.microedition.khronos.opengles.GL10;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFramebuffer;
import processing.core.PGraphicsAndroid3D;
import processing.core.PImage;

public class PTexture
implements PConstants {
    public int width;
    public int height;
    protected PApplet parent;
    protected PGraphicsAndroid3D a3d;
    protected PImage img;
    public int glID;
    public int glTarget;
    public int glFormat;
    public int glMinFilter;
    public int glMagFilter;
    public int glWrapS;
    public int glWrapT;
    public int glWidth;
    public int glHeight;
    protected boolean usingMipmaps;
    protected float maxTexCoordU;
    protected float maxTexCoordV;
    protected boolean flippedX;
    protected boolean flippedY;
    protected int[] tempPixels = null;
    protected PFramebuffer tempFbo = null;

    public PTexture(PApplet pApplet, int n, int n2) {
        this(pApplet, n, n2, new Parameters());
    }

    public PTexture(PApplet pApplet, int n, int n2, Parameters parameters) {
        this.parent = pApplet;
        this.width = n;
        this.height = n2;
        this.a3d = (PGraphicsAndroid3D)pApplet.g;
        this.a3d.registerPGLObject(this);
        this.glID = 0;
        this.init(n, n2, parameters);
    }

    public void delete() {
        this.release();
        this.img = null;
        this.a3d.unregisterPGLObject(this);
    }

    public void backup() {
        if (this.img != null) {
            this.img.loadPixels();
            if (this.img.pixels != null && this.img instanceof PGraphicsAndroid3D) {
                this.get(this.img.pixels);
            }
        }
    }

    public void restore() {
        if (this.img != null && this.img.pixels != null) {
            this.set(this.img.pixels);
        }
    }

    public void init(int n, int n2) {
        Parameters parameters = 0 < this.glID ? this.getParameters() : new Parameters();
        this.init(n, n2, parameters);
    }

    public void init(int n, int n2, Parameters parameters) {
        this.setParameters(parameters);
        this.setSize(n, n2);
        this.allocate();
    }

    public void resize(int n, int n2) {
        PTexture pTexture = new PTexture(this.parent, n, n2, this.getParameters());
        pTexture.set(this);
        this.delete();
        this.copyObject(pTexture);
        this.tempPixels = null;
        this.tempFbo = null;
    }

    public boolean available() {
        return 0 < this.glID;
    }

    public void set(PImage pImage) {
        PTexture pTexture = (PTexture)pImage.getCache(this.a3d);
        this.set(pTexture);
    }

    public void set(PImage pImage, int n, int n2, int n3, int n4) {
        PTexture pTexture = (PTexture)pImage.getCache(this.a3d);
        this.set(pTexture, n, n2, n3, n4);
    }

    public void set(PTexture pTexture) {
        this.copyTexels(pTexture, 0, 0, pTexture.width, pTexture.height, true);
    }

    public void set(PTexture pTexture, int n, int n2, int n3, int n4) {
        this.copyTexels(pTexture, n, n2, n3, n4, true);
    }

    public void set(int[] nArray) {
        this.set(nArray, 0, 0, this.width, this.height, 2);
    }

    public void set(int[] nArray, int n) {
        this.set(nArray, 0, 0, this.width, this.height, n);
    }

    public void set(int[] nArray, int n, int n2, int n3, int n4) {
        this.set(nArray, n, n2, n3, n4, 2);
    }

    public void set(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (nArray == null) {
            throw new RuntimeException("PTexture: null pixels array");
        }
        if (nArray.length != n3 * n4) {
            throw new RuntimeException("PTexture: wrong length of pixels array");
        }
        this.getGl().glEnable(this.glTarget);
        this.getGl().glBindTexture(this.glTarget, this.glID);
        if (this.usingMipmaps) {
            if (this.a3d.gl11 != null && PGraphicsAndroid3D.mipmapGeneration) {
                int[] nArray2 = new int[n3 * n4];
                this.convertToRGBA(nArray, nArray2, n5, n3, n4);
                this.getGl().glTexParameterf(3553, 33169, 1.0f);
                this.setTexels(n, n2, n3, n4, nArray2);
                nArray2 = null;
            } else {
                if (n3 != this.width || n4 != this.height) {
                    System.err.println("Sorry but I don't know how to generate mipmaps for a subregion.");
                    return;
                }
                int n6 = this.glWidth;
                int n7 = this.glHeight;
                int[] nArray3 = new int[n6 * n7];
                this.convertToARGB(nArray, nArray3, n5);
                int n8 = 0;
                int n9 = 1;
                Bitmap bitmap = Bitmap.createBitmap((int)n6, (int)n7, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap.setPixels(nArray3, 0, n6, 0, 0, n6, n7);
                while (n6 >= 1 || n7 >= 1) {
                    GLUtils.texImage2D((int)this.glTarget, (int)n8, (Bitmap)bitmap, (int)0);
                    if (n6 == 1 && n7 == 1) break;
                    ++n8;
                    n6 = PApplet.max(1, PApplet.floor((float)this.glWidth / (float)(n9 *= 2)));
                    n7 = PApplet.max(1, PApplet.floor((float)this.glHeight / (float)n9));
                    Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n6, (int)n7, (boolean)true);
                    bitmap.recycle();
                    bitmap = bitmap2;
                    bitmap2 = null;
                }
                nArray3 = null;
                bitmap = null;
            }
        } else {
            int[] nArray4 = new int[n3 * n4];
            this.convertToRGBA(nArray, nArray4, n5, n3, n4);
            this.setTexels(n, n2, n3, n4, nArray4);
            nArray4 = null;
        }
        this.getGl().glBindTexture(this.glTarget, 0);
        this.getGl().glDisable(this.glTarget);
    }

    public void get(int[] nArray) {
        if (nArray == null || nArray.length != this.width * this.height) {
            nArray = new int[this.width * this.height];
        }
        int n = this.glWidth * this.glHeight;
        if (this.tempFbo == null) {
            this.tempFbo = new PFramebuffer(this.parent, this.glWidth, this.glHeight);
        }
        if (PGraphicsAndroid3D.fboSupported) {
            this.tempFbo.setColorBuffer(this);
            this.a3d.pushFramebuffer();
            this.a3d.setFramebuffer(this.tempFbo);
            this.tempFbo.readPixels();
            this.a3d.popFramebuffer();
        } else {
            this.a3d.pushFramebuffer();
            this.a3d.setFramebuffer(this.tempFbo);
            this.a3d.drawTexture(this, 0, 0, this.glWidth, this.glHeight, 0, 0, this.glWidth, this.glHeight);
            this.tempFbo.readPixels();
            this.a3d.popFramebuffer();
        }
        if (this.tempPixels == null) {
            this.tempPixels = new int[n];
        }
        this.tempFbo.getPixels(this.tempPixels);
        this.convertToARGB(this.tempPixels, nArray);
        if (this.flippedX) {
            this.flipArrayOnX(nArray, 1);
        }
        if (this.flippedY) {
            this.flipArrayOnY(nArray, 1);
        }
    }

    public void put(PTexture pTexture) {
        this.copyTexels(pTexture, 0, 0, pTexture.width, pTexture.height, false);
    }

    public void put(PTexture pTexture, int n, int n2, int n3, int n4) {
        this.copyTexels(pTexture, n, n2, n3, n4, false);
    }

    public boolean usingMipmaps() {
        return this.usingMipmaps;
    }

    public float getMaxTexCoordU() {
        return this.maxTexCoordU;
    }

    public float getMaxTexCoordV() {
        return this.maxTexCoordV;
    }

    public boolean isFlippedX() {
        return this.flippedX;
    }

    public void setFlippedX(boolean bl) {
        this.flippedX = bl;
    }

    public boolean isFlippedY() {
        return this.flippedY;
    }

    public void setFlippedY(boolean bl) {
        this.flippedY = bl;
    }

    public void bind() {
        this.getGl().glEnable(this.glTarget);
        this.getGl().glBindTexture(this.glTarget, this.glID);
    }

    public void unbind() {
        this.getGl().glEnable(this.glTarget);
        this.getGl().glBindTexture(this.glTarget, 0);
    }

    protected int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    protected void flipArrayOnX(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n * (this.width - 1);
        for (int i = 0; i < this.width / 2; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int n4 = n2 + n * j * this.width;
                int n5 = n3 + n * j * this.width;
                for (int k = 0; k < n; ++k) {
                    int n6 = nArray[n4];
                    nArray[n4] = nArray[n5];
                    nArray[n5] = n6;
                    ++n4;
                    ++n5;
                }
            }
            n2 += n;
            n3 -= n;
        }
    }

    protected void flipArrayOnY(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n * (this.height - 1) * this.width;
        for (int i = 0; i < this.height / 2; ++i) {
            for (int j = 0; j < n * this.width; ++j) {
                int n4 = nArray[n2];
                nArray[n2] = nArray[n3];
                nArray[n3] = n4;
                ++n2;
                ++n3;
            }
            n3 -= n * this.width * 2;
        }
    }

    protected void convertToRGBA(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        block45: {
            block44: {
                if (!PGraphicsAndroid3D.BIG_ENDIAN) break block44;
                switch (n) {
                    case 4: {
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray2[i] = 0xFFFFFF00 | nArray[i];
                        }
                        break block45;
                    }
                    case 1: {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n4 = nArray[i];
                            nArray2[i] = n4 << 8 | 0xFF;
                        }
                        break block45;
                    }
                    case 2: {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n5 = nArray[i];
                            nArray2[i] = n5 << 8 | n5 >> 24 & 0xFF;
                        }
                        break block45;
                    }
                    case 6: {
                        int n6 = n2 * n3;
                        int n7 = 0;
                        for (int i = 0; i < n3; ++i) {
                            int n8 = n6 + (i >> 1) * n2;
                            int n9 = 0;
                            int n10 = 0;
                            int n11 = 0;
                            while (n11 < n2) {
                                int n12 = (0xFF & nArray[n7]) - 16;
                                if (n12 < 0) {
                                    n12 = 0;
                                }
                                if ((n11 & 1) == 0) {
                                    n10 = (0xFF & nArray[n8++]) - 128;
                                    n9 = (0xFF & nArray[n8++]) - 128;
                                }
                                int n13 = 1192 * n12;
                                int n14 = n13 + 1634 * n10;
                                int n15 = n13 - 833 * n10 - 400 * n9;
                                int n16 = n13 + 2066 * n9;
                                if (n14 < 0) {
                                    n14 = 0;
                                } else if (n14 > 262143) {
                                    n14 = 262143;
                                }
                                if (n15 < 0) {
                                    n15 = 0;
                                } else if (n15 > 262143) {
                                    n15 = 262143;
                                }
                                if (n16 < 0) {
                                    n16 = 0;
                                } else if (n16 > 262143) {
                                    n16 = 262143;
                                }
                                nArray2[n7] = n14 << 6 & 0xFF000000 | n15 >> 2 & 0xFF0000 | n16 >> 10 & 0xFF00 | 0xFF;
                                ++n11;
                                ++n7;
                            }
                        }
                        break;
                    }
                }
                break block45;
            }
            switch (n) {
                case 4: {
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray2[i] = nArray[i] << 24 | 0xFFFFFF;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n17 = nArray[i];
                        nArray2[i] = 0xFF000000 | (n17 & 0xFF) << 16 | (n17 & 0xFF0000) >> 16 | n17 & 0xFF00;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n18 = nArray[i];
                        nArray2[i] = (n18 & 0xFF) << 16 | (n18 & 0xFF0000) >> 16 | n18 & 0xFF00FF00;
                    }
                    break;
                }
                case 6: {
                    int n19 = n2 * n3;
                    int n20 = 0;
                    for (int i = 0; i < n3; ++i) {
                        int n21 = n19 + (i >> 1) * n2;
                        int n22 = 0;
                        int n23 = 0;
                        int n24 = 0;
                        while (n24 < n2) {
                            int n25 = (0xFF & nArray[n20]) - 16;
                            if (n25 < 0) {
                                n25 = 0;
                            }
                            if ((n24 & 1) == 0) {
                                n23 = (0xFF & nArray[n21++]) - 128;
                                n22 = (0xFF & nArray[n21++]) - 128;
                            }
                            int n26 = 1192 * n25;
                            int n27 = n26 + 1634 * n23;
                            int n28 = n26 - 833 * n23 - 400 * n22;
                            int n29 = n26 + 2066 * n22;
                            if (n27 < 0) {
                                n27 = 0;
                            } else if (n27 > 262143) {
                                n27 = 262143;
                            }
                            if (n28 < 0) {
                                n28 = 0;
                            } else if (n28 > 262143) {
                                n28 = 262143;
                            }
                            if (n29 < 0) {
                                n29 = 0;
                            } else if (n29 > 262143) {
                                n29 = 262143;
                            }
                            nArray2[n20] = 0xFF000000 | n29 << 6 & 0xFF0000 | n28 >> 2 & 0xFF00 | n27 >> 10 & 0xFF;
                            ++n24;
                            ++n20;
                        }
                    }
                    break;
                }
            }
        }
    }

    protected void convertToARGB(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 4: {
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int n4 = nArray[n3++];
                        nArray2[n2++] = n4 << 24 & 0xFF000000;
                    }
                    n2 += this.glWidth - this.width;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int n5 = nArray[n3++];
                        nArray2[n2++] = n5 | 0xFF000000;
                    }
                    n2 += this.glWidth - this.width;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.height; ++i) {
                    PApplet.arrayCopy(nArray, this.width * i, nArray2, this.glWidth * i, this.width);
                }
                break;
            }
            case 6: {
                int n6 = this.width * this.height;
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; i < this.height; ++i) {
                    int n9 = n6 + (i >> 1) * this.width;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    while (n12 < this.width) {
                        int n13 = (0xFF & nArray[n7]) - 16;
                        if (n13 < 0) {
                            n13 = 0;
                        }
                        if ((n12 & 1) == 0) {
                            n11 = (0xFF & nArray[n9++]) - 128;
                            n10 = (0xFF & nArray[n9++]) - 128;
                        }
                        int n14 = 1192 * n13;
                        int n15 = n14 + 1634 * n11;
                        int n16 = n14 - 833 * n11 - 400 * n10;
                        int n17 = n14 + 2066 * n10;
                        if (n15 < 0) {
                            n15 = 0;
                        } else if (n15 > 262143) {
                            n15 = 262143;
                        }
                        if (n16 < 0) {
                            n16 = 0;
                        } else if (n16 > 262143) {
                            n16 = 262143;
                        }
                        if (n17 < 0) {
                            n17 = 0;
                        } else if (n17 > 262143) {
                            n17 = 262143;
                        }
                        nArray2[n8++] = 0xFF000000 | n15 << 6 & 0xFF0000 | n16 >> 2 & 0xFF00 | n17 >> 10 & 0xFF;
                        ++n12;
                        ++n7;
                    }
                    n8 += this.glWidth - this.width;
                }
                break;
            }
        }
    }

    protected void convertToARGB(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        if (PGraphicsAndroid3D.BIG_ENDIAN) {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n3 = nArray[n2++];
                    nArray2[n++] = n3 >> 8 | n3 << 24 & 0xFF000000;
                }
                n2 += this.glWidth - this.width;
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n4 = nArray[n2++];
                    nArray2[n++] = (n4 & 0xFF) << 16 | (n4 & 0xFF0000) >> 16 | n4 & 0xFF00FF00;
                }
                n2 += this.glWidth - this.width;
            }
        }
    }

    protected void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (PGraphicsAndroid3D.npotTexSupported) {
            this.glWidth = n;
            this.glHeight = n2;
        } else {
            this.glWidth = this.nextPowerOfTwo(n);
            this.glHeight = this.nextPowerOfTwo(n2);
        }
        if (this.glWidth > PGraphicsAndroid3D.maxTextureSize || this.glHeight > PGraphicsAndroid3D.maxTextureSize) {
            this.glHeight = 0;
            this.glWidth = 0;
            throw new RuntimeException("Image width and height cannot be larger than " + PGraphicsAndroid3D.maxTextureSize + " with this graphics card.");
        }
        this.maxTexCoordU = (float)n / (float)this.glWidth;
        this.maxTexCoordV = (float)n2 / (float)this.glHeight;
    }

    protected void allocate() {
        this.release();
        this.getGl().glEnable(this.glTarget);
        this.glID = this.a3d.createGLResource(0);
        this.getGl().glBindTexture(this.glTarget, this.glID);
        this.getGl().glTexParameterf(this.glTarget, 10241, (float)this.glMinFilter);
        this.getGl().glTexParameterf(this.glTarget, 10240, (float)this.glMagFilter);
        this.getGl().glTexParameterf(this.glTarget, 10242, (float)this.glWrapS);
        this.getGl().glTexParameterf(this.glTarget, 10243, (float)this.glWrapT);
        this.getGl().glTexImage2D(this.glTarget, 0, this.glFormat, this.glWidth, this.glHeight, 0, 6408, 5121, null);
        int[] nArray = new int[this.width * this.height];
        Arrays.fill(nArray, 0, this.width * this.height, 0);
        this.setTexels(0, 0, this.width, this.height, nArray);
        nArray = null;
        this.getGl().glBindTexture(this.glTarget, 0);
        this.getGl().glDisable(this.glTarget);
    }

    protected void release() {
        if (this.glID != 0) {
            this.a3d.deleteGLResource(this.glID, 0);
            this.glID = 0;
        }
    }

    protected void copyTexels(PTexture pTexture, int n, int n2, int n3, int n4, boolean bl) {
        if (pTexture == null) {
            throw new RuntimeException("PTexture: source texture is null");
        }
        if (this.tempFbo == null) {
            this.tempFbo = new PFramebuffer(this.parent, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.tempFbo.disableDepthTest();
        this.a3d.pushFramebuffer();
        this.a3d.setFramebuffer(this.tempFbo);
        if (bl) {
            this.a3d.drawTexture(pTexture, n, n2, n3, n4, 0, 0, this.width, this.height);
        } else {
            this.a3d.drawTexture(pTexture, n, n2, n3, n4, n, n2, n3, n4);
        }
        this.a3d.popFramebuffer();
    }

    protected void setTexels(int n, int n2, int n3, int n4, int[] nArray) {
        this.setTexels(0, n, n2, n3, n4, nArray);
    }

    protected void setTexels(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.getGl().glTexSubImage2D(this.glTarget, 0, n2, n3, n4, n5, 6408, 5121, (Buffer)IntBuffer.wrap(nArray));
    }

    protected void copyObject(PTexture pTexture) {
        this.release();
        this.width = pTexture.width;
        this.height = pTexture.height;
        this.parent = pTexture.parent;
        this.a3d = pTexture.a3d;
        this.glID = pTexture.glID;
        this.glTarget = pTexture.glTarget;
        this.glFormat = pTexture.glFormat;
        this.glMinFilter = pTexture.glMinFilter;
        this.glMagFilter = pTexture.glMagFilter;
        this.glWidth = pTexture.glWidth;
        this.glHeight = pTexture.glHeight;
        this.usingMipmaps = pTexture.usingMipmaps;
        this.maxTexCoordU = pTexture.maxTexCoordU;
        this.maxTexCoordV = pTexture.maxTexCoordV;
        this.flippedX = pTexture.flippedX;
        this.flippedY = pTexture.flippedY;
    }

    public Parameters getParameters() {
        Parameters parameters = new Parameters();
        if (this.glTarget == 3553) {
            parameters.target = 0;
        }
        if (this.glFormat == 6407) {
            parameters.format = 1;
        } else if (this.glFormat == 6408) {
            parameters.format = 2;
        } else if (this.glFormat == 6406) {
            parameters.format = 4;
        }
        if (this.glMinFilter == 9728) {
            parameters.sampling = 2;
        } else if (this.glMinFilter == 9729) {
            parameters.sampling = 3;
        } else if (this.glMinFilter == 9987) {
            parameters.sampling = 4;
        }
        if (this.glWrapS == 33071) {
            parameters.wrapU = 0;
        } else if (this.glWrapS == 10497) {
            parameters.wrapU = 1;
        }
        if (this.glWrapT == 33071) {
            parameters.wrapV = 0;
        } else if (this.glWrapT == 10497) {
            parameters.wrapV = 1;
        }
        return parameters;
    }

    protected void setParameters(Parameters parameters) {
        if (parameters.target != 0) {
            throw new RuntimeException("A3D: Unknown texture target");
        }
        this.glTarget = 3553;
        if (parameters.format == 1) {
            this.glFormat = 6407;
        } else if (parameters.format == 2) {
            this.glFormat = 6408;
        } else if (parameters.format == 4) {
            this.glFormat = 6406;
        } else {
            throw new RuntimeException("A3D: Unknown texture format");
        }
        if (parameters.sampling == 2) {
            this.glMagFilter = 9728;
            this.glMinFilter = 9728;
        } else if (parameters.sampling == 3) {
            this.glMagFilter = 9729;
            this.glMinFilter = 9729;
        } else if (parameters.sampling == 4) {
            this.glMagFilter = 9729;
            this.glMinFilter = 9987;
        } else {
            throw new RuntimeException("A3D: Unknown texture filtering mode");
        }
        if (parameters.wrapU == 0) {
            this.glWrapS = 33071;
        } else if (parameters.wrapU == 1) {
            this.glWrapS = 10497;
        } else {
            throw new RuntimeException("A3D: Unknown wrapping mode");
        }
        if (parameters.wrapV == 0) {
            this.glWrapT = 33071;
        } else if (parameters.wrapV == 1) {
            this.glWrapT = 10497;
        } else {
            throw new RuntimeException("A3D: Unknown wrapping mode");
        }
        this.usingMipmaps = this.glMinFilter == 9987;
        this.flippedX = false;
        this.flippedY = false;
    }

    protected GL10 getGl() {
        return this.a3d.gl;
    }

    public static Parameters newParameters() {
        return new Parameters();
    }

    public static Parameters newParameters(int n) {
        return new Parameters(n);
    }

    public static Parameters newParameters(int n, int n2) {
        return new Parameters(n, n2);
    }

    public static Parameters newParameters(Parameters parameters) {
        return new Parameters(parameters);
    }

    public static class Parameters {
        public int target;
        public int format;
        public int sampling;
        public int wrapU;
        public int wrapV;

        public Parameters() {
            this.target = 0;
            this.format = 2;
            this.sampling = 3;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int n) {
            this.target = 0;
            this.format = n;
            this.sampling = 3;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int n, int n2) {
            this.target = 0;
            this.format = n;
            this.sampling = n2;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(Parameters parameters) {
            this.target = parameters.target;
            this.format = parameters.format;
            this.sampling = parameters.sampling;
            this.wrapU = parameters.wrapU;
            this.wrapV = parameters.wrapV;
        }

        public void set(int n) {
            this.format = n;
        }

        public void set(int n, int n2) {
            this.format = n;
            this.sampling = n2;
        }

        public void set(Parameters parameters) {
            this.target = parameters.target;
            this.format = parameters.format;
            this.sampling = parameters.sampling;
            this.wrapU = parameters.wrapU;
            this.wrapV = parameters.wrapV;
        }
    }
}

