// Lego Dart Shooter Droid

// Language: Processing
// dartShooterProcessing.pde
// by Sam Thongrong (Sath02)

// Jun 22, 2013

// load the serial library for Processing
import processing.serial.*; 
// instance of the serial class
Serial port;

// control commands array
// (Pause, Torso Left, Torso Right, Shoot Angle 1, Shoot Angle 2, Shoot Angle 3, 
//  Shoot Angle 4, Shoot Angle 5, Shoot, Forward, Backward, Left, Right)
int[] controls = new int[] { 
  0x47, 0x67, 0x57, 0x77, 0x45, 0x65, 
  0x53, 0x73, 0x42, 0x62, 0x4c, 0x6c, 0x2c, 0x58
};

// Image button. 
// Loading images and using them to create a button. 

ImageButtons Shoot;

ImageButtons ShootAng01;
ImageButtons ShootAng02;
ImageButtons ShootAng03;
ImageButtons ShootAng04;
ImageButtons ShootAng05;

//Palm Arduino V3 Control
ImageButtons TorsoLeft;
ImageButtons TorsoRight;
ImageButtons Pause;

// Direction Buttons
ImageButtons Forward;
ImageButtons Backward;
ImageButtons TurnLeft;
ImageButtons TurnRight;

// background
PImage bg;

// set the font
PFont myFont;

void controlGUI()
{
  bg = loadImage("dartShooterBG.png");
  background(bg);

  // buttonSize = 44
  PImage selected = loadImage("controlSel.png");

  //Pause
  PImage pauseImage = loadImage("controlStop.png");
  PImage pauseOver = loadImage("controlStopOver.png");
  Pause = new ImageButtons(285, 450, 44, 44, 
  pauseImage, pauseOver, selected);

  //Torso Left
  PImage torsoLeftImage = loadImage("controlCW.png");
  PImage torsoLeftOver = loadImage("controlCWOver.png");
  TorsoLeft = new ImageButtons(255, 298, 44, 44, 
  torsoLeftImage, torsoLeftOver, selected);
  
                            
   //Torso Right
   PImage torsoRightImage = loadImage("controlCCW.png");
   PImage torsoRightOver = loadImage("controlCCWOver.png");
   TorsoRight = new ImageButtons(315, 298, 44, 44, 
   torsoRightImage, torsoRightOver, selected);
   
   // Shooter Arm Angles
   // 43 x 40
   PImage angSelected = loadImage("numSelected.png");
   
   // Shooter Angle01
   PImage shootAng01Image = loadImage("num1.png");
   PImage shootAng01Over = loadImage("num1over.png");
   ShootAng01 = new ImageButtons(120, 311, 43, 40, 
   shootAng01Image, shootAng01Over, angSelected);
   
   // Shooter Angle02
   PImage shootAng02Image = loadImage("num2.png");
   PImage shootAng02Over = loadImage("num2over.png");
   ShootAng02 = new ImageButtons(73, 279, 43, 40, 
   shootAng02Image, shootAng02Over, angSelected);
   
   // Shooter Angle03
   PImage shootAng03Image = loadImage("num3.png");
   PImage shootAng03Over = loadImage("num3over.png");
   ShootAng03 = new ImageButtons(53, 220, 43, 40, 
   shootAng03Image, shootAng03Over, angSelected);

   // Shooter Angle04
   PImage shootAng04Image = loadImage("num4.png");
   PImage shootAng04Over = loadImage("num4over.png");
   ShootAng04 = new ImageButtons(73, 166, 43, 40, 
   shootAng04Image, shootAng04Over, angSelected);

   // Shooter Angle05
   PImage shootAng05Image = loadImage("num5.png");
   PImage shootAng05Over = loadImage("num5over.png");
   ShootAng05 = new ImageButtons(120, 126, 43, 40, 
   shootAng05Image, shootAng05Over, angSelected);
   
   // Shoot Button
   PImage shootSelected = loadImage("shootSelected.png");
   PImage shootImage = loadImage("shoot.png");
   PImage shootOver = loadImage("shootOver.png");
   Shoot = new ImageButtons(143, 207, 120, 80, 
   shootImage, shootOver, shootSelected);
  
   // Direction buttons
   //Forward 100x29
   PImage forwardSelected = loadImage("forwardSelected.png");
   PImage forwardImage = loadImage("forwardButton.png");
   PImage forwardOver = loadImage("forwardButtonOver.png");
   Forward = new ImageButtons(256, 498, 100, 29, 
   forwardImage, forwardOver, forwardSelected);

   //Backward 116x29
   PImage backSelected = loadImage("backButtonSelected.png");
   PImage backImage = loadImage("backButton.png");
   PImage backOver = loadImage("backButtonOver.png");
   Backward = new ImageButtons(250, 410, 116, 29, 
   backImage, backOver, backSelected);
   
   //Turn Left 100x28
   PImage leftSelected = loadImage("LeftButtonSelected.png");
   PImage leftImage = loadImage("LeftButton.png");
   PImage leftOver = loadImage("LeftButtonOver.png");
   TurnLeft = new ImageButtons(156, 455, 100, 28, 
   leftImage, leftOver, leftSelected);
   
   //Turn Right 100x28
   PImage rightSelected = loadImage("rightButtonSelected.png");
   PImage rightImage = loadImage("rightButton.png");
   PImage rightOver = loadImage("rightButtonOver.png");
   TurnRight = new ImageButtons(349, 455, 100, 28, 
   rightImage, rightOver, rightSelected);
}

void setup() {
  // List all the available serial ports in the output pane. 
  // You will need to choose the port that the Arduino board is 
  // connected to from this list. The first port in the list is 
  // port #0.
  // Mac OS
  //port = new Serial(this, Serial.list()[0], 38400); 

  // Windows  
  // Change "COM6" to your "COMx" port used.
  port = new Serial(this, "COM6", 38400);

  // screen size of the program
  size(500, 600);
  smooth();

  // test ellipse
  ellipseMode(RADIUS);
  textFont(createFont("Verdana", 14));

  controlGUI();
}

void updateDisplay() {

  Pause.update();
  Pause.display();

  TorsoLeft.update();
  TorsoLeft.display();
  
  TorsoRight.update();
  TorsoRight.display();
  
  ShootAng01.update();
  ShootAng01.display();
  
  ShootAng02.update();
  ShootAng02.display();

  ShootAng03.update();
  ShootAng03.display();
  
  ShootAng04.update();
  ShootAng04.display();
  
  ShootAng05.update();
  ShootAng05.display();
  
  Shoot.update();
  Shoot.display();
  
  Forward.update();
  Forward.display();
  
  Backward.update();
  Backward.display();
  
  TurnLeft.update();
  TurnLeft.display();
  
  TurnRight.update();
  TurnRight.display();
}

//Send Commands 
void sendCommands() {

  // Pause
  if (Pause.pressed) {
    port.write(controls[0]);
    //println("Pause: " + (char)controls[0]);
  }

   if(TorsoLeft.pressed) {
   port.write(controls[1]);
   //println("Torso Left: " + (char)controls[1]);
   }
   
   if(TorsoRight.pressed) {
   port.write(controls[2]);
   //println("Torso Right: " + (char)controls[2]);
   }
   
   if(ShootAng01.pressed) {
   port.write(controls[3]);
   //println("Shoot Angle 1: " + (char)controls[3]);
   }

   if(ShootAng02.pressed) {
   port.write(controls[4]);
   //println("Shoot Angle 2: " + (char)controls[4]);
   }  
   
   if(ShootAng03.pressed) {
   port.write(controls[5]);
   //println("Shoot Angle 3: " + (char)controls[5]);
   } 

   if(ShootAng04.pressed) {
   port.write(controls[6]);
   //println("Shoot Angle 4: " + (char)controls[6]);
   } 
   
   if(ShootAng05.pressed) {
   port.write(controls[7]);
   //println("Shoot Angle 5: " + (char)controls[7]);
   }
   
   if(Shoot.pressed) {
   port.write(controls[8]);
   //println("Shoot: " + (char)controls[8]);
   }
 
   if(Forward.pressed) {
   port.write(controls[9]);
   //println("Forward: " + (char)controls[9]);
   }

   if(Backward.pressed) {
   port.write(controls[10]);
   //println("Backward: " + (char)controls[10]);
   }

   if(TurnLeft.pressed) {
   port.write(controls[11]);
   //println("Turn Left: " + (char)controls[11]);
   }

   if(TurnRight.pressed) {
   port.write(controls[12]);
   //println("Turn Right: " + (char)controls[12]);
   }
}

void draw()
{
  updateDisplay();

  sendCommands();
}

// Button & ImageButtons Classes
class Button
{
  int x, y;
  int w, h;
  color basecolor, highlightcolor;
  color currentcolor;
  boolean over = false;
  boolean pressed = false;   

  void pressed() {
    if (over && mousePressed) {
      pressed = true;
    } 
    else {
      pressed = false;
    }
  }

  boolean overRect(int x, int y, int width, int height) {
    if (mouseX >= x && mouseX <= x+width && 
      mouseY >= y && mouseY <= y+height) {
      return true;
    } 
    else {
      return false;
    }
  }
}

class ImageButtons extends Button 
{
  PImage base;
  PImage roll;
  PImage down;
  PImage currentimage;

  ImageButtons(int ix, int iy, int iw, int ih, 
  PImage ibase, PImage iroll, PImage idown) 
  {
    x = ix;
    y = iy;
    w = iw;
    h = ih;
    base = ibase;
    roll = iroll;
    down = idown;
    currentimage = base;
  }

  void update() 
  {
    over();
    pressed();
    if (pressed) {
      currentimage = down;
    } 
    else if (over) {
      currentimage = roll;
    } 
    else {
      currentimage = base;
    }
  }

  void over() 
  {
    if ( overRect(x, y, w, h) ) {
      over = true;
    } 
    else {
      over = false;
    }
  }

  void display() 
  {
    image(currentimage, x, y);
  }
}

