
// Lego Dart Shooter Droid

// Language: Arduino Sketch
// I2C Receiver (Slave): palmArduinoV3
// by Sam Thongrong (Sath02)
// Jun 22, 2013

#include <Wire.h>

#include <Servo.h>

#define ServoPin 10

#define MOT1_EN 9
#define MOT1_A  8
#define MOT1_B  7

#define MOT2_EN 6
#define MOT2_A  5
#define MOT2_B  4

// control commands array
// (Pause, Torso Left, Torso Right, Shoot Angle 1, Shoot Angle 2, Shoot Angle 3, 
//  Shoot Angle 4, Shoot Angle 5, Shoot, Forward, Backward, Left, Right)
int controls[14] = {0x47, 0x67, 0x57, 0x77, 0x45, 0x65, 0x53, 
                    0x73, 0x42, 0x62, 0x4c, 0x6c, 0x2c, 0x58};

int incomingByte;

//I2C
byte i2cVal = 0;

Servo servoTorso;
int angle = 0;
int lastAngle;

void forward(){
  // move forward
  digitalWrite(MOT2_B, HIGH);
  digitalWrite(MOT2_A, LOW);
  
  digitalWrite(MOT1_B, HIGH);
  digitalWrite(MOT1_A, LOW);
  
}
void backward(){ 
  // move backward
  digitalWrite(MOT2_B, LOW);
  digitalWrite(MOT2_A, HIGH);
  
  digitalWrite(MOT1_B, LOW);
  digitalWrite(MOT1_A, HIGH);
}

void left() {
  // left turn
  digitalWrite(MOT2_B, HIGH);
  digitalWrite(MOT2_A, LOW);
  
  digitalWrite(MOT1_B, LOW);
  digitalWrite(MOT1_A, HIGH);  
}

void right(){
  // right turn
  digitalWrite(MOT2_B, LOW);
  digitalWrite(MOT2_A, HIGH);
  
  digitalWrite(MOT1_B, HIGH);
  digitalWrite(MOT1_A, LOW);  
}

void pause(){
  digitalWrite(MOT2_B, LOW);
  digitalWrite(MOT2_A, LOW);
  
  digitalWrite(MOT1_B, LOW);
  digitalWrite(MOT1_A, LOW);  
}

//I2C Receive Event
void receiveEvent(int howMany)
{
  if(Wire.available())
  {
    incomingByte = Wire.read();
    
    if(incomingByte == controls[0]){
        // pause motor
        pause();   
        //servoTorso.write(90); 
        //delay(20); 
    }
    else if(incomingByte == controls[1]){
        // torso Left
        rotateTorsoLeft();
        //servoTorso.write(130);
        //delay(20);
        
    }
    else if(incomingByte == controls[2]){
        // Torso Right
        rotateTorsoRight();
        //servoTorso.write(20);
        //delay(20);
    }
    else if(incomingByte == controls[9]){
        // Forward
        forward();
    }
    else if(incomingByte == controls[10]){
        // Backward
        backward();
    }
      
    else if(incomingByte == controls[11]){
        // Turn Left
        left();
    }
    else if(incomingByte == controls[12]){
        // Turn Right
        right();
    }
  }
}
void rotateTorsoLeft(){
  lastAngle = angle + 1;
  if(lastAngle > 175)
    lastAngle = 175; 
  servoTorso.write(lastAngle);               
  delay(15);                       
  angle = lastAngle;
}

void rotateTorsoRight(){
  lastAngle = angle - 1;
  if(lastAngle < 5)
    lastAngle = 5;
   
  servoTorso.write(lastAngle);               
  delay(15);                       
  angle = lastAngle; 
}

void setup(){
  Wire.begin(7); // I'm a receiver, with the ID = 7
  Wire.onReceive(receiveEvent);
  
  
  servoTorso.attach(ServoPin);
  
  angle = 90;
  servoTorso.write(angle);
  delay(20);
  
  pinMode(MOT2_B, OUTPUT); // Motor1_A
  pinMode(MOT2_A, OUTPUT); // Motor1_B
  pinMode(MOT2_EN, OUTPUT); // Motor1_EN
  
  pinMode(MOT1_B, OUTPUT); // Motor B2
  pinMode(MOT1_A, OUTPUT); // Motor B2
  pinMode(MOT2_EN, OUTPUT); // Motor B1
  
  digitalWrite(MOT2_EN, HIGH);
  digitalWrite(MOT1_EN, HIGH);
}

void loop(){
  delay(100);
}

