#include <Encoder.h>
#include <Servo.h> 
#include <Wire.h>
Servo motor;
Encoder myEnc(2, 3);
const int easing = 3200;
const int tolerance = 100;
const int potPin = 2; //A2
int potVal = 0; // 0-1023
int currentPosition = 0;
const int analogInputMax = 833;//1023
const int analogInputMin = 102;//0
const int speedMax = 2000;//2000
const int speedMin = 1000;//1000
const int stopSpeed = 1500;
int speed = stopSpeed;
const int Apin = 5;
const int Bpin = 7;
const int ledPin =  13; 
int Astate = 0;
int Bstate = 0;
long Aposition;
long Bposition;
long target;

void setup() {
  Serial.begin(9600);
  motor.attach(9,1000,2000);
  motor.writeMicroseconds(stopSpeed);
  pinMode(Apin, INPUT);     
  pinMode(Bpin, INPUT);
  pinMode(ledPin, OUTPUT);
  calibrateStroke();
}

void loop() {
  potVal = analogRead(potPin);
  currentPosition = myEnc.read();  
  long smallestEndpoint = Aposition < Bposition ? Aposition : Bposition;
  long largestEndpoint = Aposition > Bposition ? Aposition : Bposition;
	
  target = map(potVal, analogInputMin, analogInputMax, smallestEndpoint, largestEndpoint);
  long stroke = abs(largestEndpoint - smallestEndpoint);
  long distanceToTarget = abs(currentPosition - target);
  
  if(currentPosition < target - tolerance){
    speed = distanceToTarget > easing ? speedMax : map(distanceToTarget, 0, easing, stopSpeed + (speedMax*0.05) , speedMax);
  }else if(currentPosition > target + tolerance){
    speed = distanceToTarget > easing ? speedMin : map(distanceToTarget, 0, easing, stopSpeed - (speedMax*0.05), speedMin);
  }else{
    speed = stopSpeed;
  }
  
  Serial.print("potVal: ");
  Serial.print(potVal);
  Serial.print(" | currentPosition: ");
  Serial.print(currentPosition);
  Serial.print(" | speed: ");
  Serial.println(speed);
  
  motor.writeMicroseconds(speed);
  
  delay(5);
}

void calibrateStroke(){
  //A == Yellow 
  // B == Green
  // + = forward
  delay(50);
  Astate = digitalRead(Apin);
  Bstate = digitalRead(Bpin);
  if(Astate == LOW){
    Aposition =  myEnc.read();
    Serial.print("Position A Found: ");
    Serial.println(Aposition);
  }
  if(Bstate == LOW){
    Bposition =  myEnc.read(); 
    Serial.print("Position B Found: ");
    Serial.println(Bposition);
  }
    
  while(!Aposition && !Bposition){  
    motor.writeMicroseconds(stopSpeed + 150);  
    Astate = digitalRead(Apin);
    Bstate = digitalRead(Bpin);
    if(Astate == LOW){
      Aposition =  myEnc.read();
      Serial.print("Position A Found: ");
      Serial.println(Aposition);
    }
    if(Bstate == LOW){
      Bposition =  myEnc.read(); 
      Serial.print("Position B Found: ");
      Serial.println(Bposition);
    }
  }//end while
  
  while(!Aposition){
    motor.writeMicroseconds(stopSpeed - 150);
    Astate = digitalRead(Apin);
    if(Astate == LOW){
      Aposition =  myEnc.read(); 
      Serial.print("Position A Found: ");
      Serial.println(Aposition);
    }
  }//end while
  
  while(!Bposition){
    motor.writeMicroseconds(stopSpeed + 150);
    Bstate = digitalRead(Bpin);
    if(Bstate == LOW){
      Bposition =  myEnc.read(); 
      Serial.print("Position B Found: ");
      Serial.println(Bposition);
    }
  }//end while
  
  motor.writeMicroseconds(stopSpeed);
  digitalWrite(ledPin, HIGH);
}
