#include "Arduino.h"
#include "config.h"
class Motor{
 private:
 short int motorA;
 short int motorB;
 short int motorC;
 short int motorD;
 float motor_position;
 
 

public: 
 float target_position;
 //delay between each step in microseconds
 int delay_between_steps;
long last_step_microseconds;
 
Motor(short int _PINA, short int _PINB, short int _PINC, short int _PIND){
  motorA = _PINA;
  motorB = _PINB;
  motorC = _PINC;
  motorD = _PIND;
  motor_position = 0;

  pinMode(motorA, OUTPUT);
  pinMode(motorB, OUTPUT);
  pinMode(motorC, OUTPUT);
  pinMode(motorD, OUTPUT);
  
}


// true = right false = left
// function for moving motor left or right just one step;
int motor_step_number = 0;
int total_motor_steps = 0;

void oneStep(bool dir){
  if(dir){
    motor_position += MOTOR_X_MM_STEP;
  if(motor_step_number == 0){
  digitalWrite(motorA, HIGH);
  digitalWrite(motorB, HIGH);
  digitalWrite(motorC, LOW);
  digitalWrite(motorD, LOW);
}

if(motor_step_number == 1){
  digitalWrite(motorA, LOW);
  digitalWrite(motorB, HIGH);
  digitalWrite(motorC, HIGH);
  digitalWrite(motorD, LOW);
}

if(motor_step_number == 2){
  digitalWrite(motorA, LOW);
  digitalWrite(motorB, LOW);
  digitalWrite(motorC, HIGH);
  digitalWrite(motorD, HIGH);
}

if(motor_step_number == 3){
  digitalWrite(motorA, HIGH);
  digitalWrite(motorB, LOW);
  digitalWrite(motorC, LOW);
  digitalWrite(motorD, HIGH);
}



}else{
  motor_position -= MOTOR_X_MM_STEP;
  if(motor_step_number == 3){
  digitalWrite(motorA, HIGH);
  digitalWrite(motorB, HIGH);
  digitalWrite(motorC, LOW);
  digitalWrite(motorD, LOW);
}

if(motor_step_number == 2){
  digitalWrite(motorA, LOW);
  digitalWrite(motorB, HIGH);
  digitalWrite(motorC, HIGH);
  digitalWrite(motorD, LOW);
}

if(motor_step_number == 1){
  digitalWrite(motorA, LOW);
  digitalWrite(motorB, LOW);
  digitalWrite(motorC, HIGH);
  digitalWrite(motorD, HIGH);
}

if(motor_step_number == 0){
  digitalWrite(motorA, HIGH);
  digitalWrite(motorB, LOW);
  digitalWrite(motorC, LOW);
  digitalWrite(motorD, HIGH);
}
}
motor_step_number++;
total_motor_steps++;
if(motor_step_number >= 4){
  motor_step_number = 0;
}
}


float getMotorPosition(){
  return motor_position;
}

void setMotorPosition(float pos){
   motor_position = pos;
}


void disableCoils(){
  digitalWrite(motorA, LOW);
  digitalWrite(motorB, LOW);
  digitalWrite(motorC, LOW);
  digitalWrite(motorD, LOW);
}

  
};

