# How to update files inside html folder?
The files related to the Frontend of ESP8266_Deauther are inside html folder.
To reflect on the firmware it needs to be: minified, converted to hex and updated on data.h on esp8266_deauther folder on the root of this project.

The following process can be used:
## Script Mode (Linux/Mac)

**1** Update the desired files on ./html folder
**2** at the command line run the shell script: ./convert_all.sh
**3** open the generated file "data_h_temp" and copy the content (CTRL+C)
**4** Go to data.h and replace the content between the comments like below:
```c
/* constants generated by convert_all.sh - start */
const char data_apscanHTML[] PROGMEM = {0x3c,0x21,0x44,0x4f,0x43...
const char data_attackHTML[] PROGMEM = {0x3c,0x21,0x44,0x4f,0x43...
const char data_errorHTML[] PROGMEM = {0x3c,0x21,0x44,0x4f,0x43,...
const char data_indexHTML[] PROGMEM = {0x3c,0x21,0x44,0x4f,0x43,...
const char data_infoHTML[] PROGMEM = {0x3c,0x21,0x44,0x4f,0x43,0...
const char data_js_apscanJS[] PROGMEM = {0x66,0x75,0x6e,0x63,0x7...
const char data_js_attackJS[] PROGMEM = {0x66,0x75,0x6e,0x63,0x7...
const char data_js_functionsJS[] PROGMEM = {0x66,0x75,0x6e,0x63,...
const char data_js_settingsJS[] PROGMEM = {0x66,0x75,0x6e,0x63,0...
const char data_js_stationsJS[] PROGMEM = {0x66,0x75,0x6e,0x63,0...
const char data_license[] PROGMEM = {0x43,0x6f,0x70,0x79,0x72,0x...
const char data_settingsHTML[] PROGMEM = {0x3c,0x21,0x44,0x4f,0x...
const char data_stationsHTML[] PROGMEM = {0x3c,0x21,0x44,0x4f,0x...
const char data_styleCSS[] PROGMEM = {0x2f,0x2a,0x20,0x47,0x6c,0...
/* constants generated by convert_all.sh - end */
```

## Manual mode

**1** Use a minifier (e.g. htmlcompressor.com) to get your files as small as possible  
**2** Open converter.html  
**3** Paste the code in the left textfield  
**4** Press Convert  
**5** Copy the results from the right textfield  
**6** Go to data.h and replace the array of the changed file with the copied bytes  

**Now compile and upload your new sketch :)**
