#include "Arduino.h"
#include "SolarPanel.h"
SolarPanel::SolarPanel(){};
SolarPanel::SolarPanel(int VSensePin, double VSenseFactor, int ISensePin, double ISenseFactor)
{
  _VSensePin = VSensePin;
  _ISensePin = ISensePin;
  _VSenseFactor = VSenseFactor;
  _ISenseFactor = ISenseFactor;
}

double SolarPanel::voltage()
{
  return abs(double(analogRead(_VSensePin)) *0.037236842);
}

double SolarPanel::current()
{
  //y = 0,05019x - 25,86022

  return abs(double(analogRead(_ISensePin)) * 0.05019 - 25.86022);
  
}

double SolarPanel::power() {
  return abs(double(SolarPanel::voltage()) * double(SolarPanel::current()));
}

void SolarPanel::VSensPin(int pin) {
  _VSensePin = pin;
}
void SolarPanel::ISensPin(int pin) {
  _ISensePin = pin;
}
void SolarPanel::VSenseFactor(double factor) {
  _VSenseFactor = factor;
}
void SolarPanel::ISenseFactor(double factor) {
  _ISenseFactor = factor;
}

