/*
 * Created 2016
 * By Bruce Helsen
 * 
 * If you want to use this code you should have a look at:
 *  - EnergyMonConnections.h  //connections for the energy measurement
 *  - solartrackerdefines.h   //settings and conenctions for the LDRs and solar tracker
 *  - solarPanel.h            //to set the formulas right for the calculations of the ADC
 *  - internet.h              // set wifi name and password aswell as api key
*/

#include <SoftwareSerial.h>
#include "EnergyMonConnections.h"
#include "SolarPanel.h"
#include "EnergyMonitor.h"
#include "solartrackerdefines.h"
#include "solartracker.h" //dit importeerd een paar vooraf gedefinierde namen zoals LEFT en RIGHT, en het meeste van het programma
#include "internet.h"
#include <LiquidCrystal.h>
LiquidCrystal lcd(4, 3, 5, 6, 7, 8);
EnergyMonitor SolarTrackerMonitor;
void setup() {
  lcd.begin(16, 2);
  Serial.begin(9600);
  module.begin( 19200 );

  pinMode(motor[PAN][PIN_0], OUTPUT);
  pinMode(motor[PAN][PIN_1], OUTPUT);
  pinMode(motor[TILT][PIN_0], OUTPUT);
  pinMode(motor[TILT][PIN_1], OUTPUT);
  pinMode(PAN_ENDLIMIT_PIN, INPUT_PULLUP); //enables the internal pullup resistor
  readLDRVal();
  
  noInterrupts();           // disable all interrupts
  TCCR1A = 0; //counter
  TCCR1B = 0; //counter
  TCNT1  = 0; //counter

  OCR1A = 6250;            // compare match register 16MHz/256/10Hz
  TCCR1B |= (1 << WGM12);   // CTC mode = clear timer in compare match
  TCCR1B |= (1 << CS12);    // 256 prescaler
  TIMSK1 |= (1 << OCIE1A);  // enable timer compare interrupt
  interrupts();             // enable all interrupts

  sendDebug("AT");
  delay(5000);
  if (module.find("OK"))
  {
    //Serial.println("RECEIVED: OK\nData ready to sent!");
    connectWiFi();
  }


}
double counter = 0;
void loop() {

  printEnergyMonitorData();

  //readValues();

  String voltage = String(SolarTrackerMonitor.voltage(0)); // turn integer to string
  String current = String(SolarTrackerMonitor.current(0) + SolarTrackerMonitor.current(1)); // turn integer to string
  String power = String(SolarTrackerMonitor.power()); // turn integer to string
  updateTS(voltage, current , power);
  delay(15000);
}


ISR(TIMER1_COMPA_vect)          // timer compare interrupt service routine
{
  static byte count = 0;

  if (count >= 10) {
    lcd.clear();
    lcd.print("U=");
    lcd.print(SolarTrackerMonitor.voltage(0));
    lcd.print("V; ");
    lcd.print("I=");
    lcd.print(SolarTrackerMonitor.current(0) + SolarTrackerMonitor.current(1));
    lcd.print("A; ");
    lcd.setCursor(0, 1);
    lcd.print("P=");
    lcd.print(SolarTrackerMonitor.power());
    lcd.print("W;");
    count = 0;
  } else {
    count++;
  }

  if  (digitalRead(PAN_ENDLIMIT_PIN) == HIGH) {
    stopMotor(PAN);
  }

  SolarTrackerMonitor.ISRupdate();

  readLDRVal(); //Updates the values to every sensor
  // Serial.println();
  //These functions can control one motor by comparing two values and depending on the value give a certain comand to the motor

  turnToLight(TILT, AVERAGE_UP, AVERAGE_DOWN, UP, DOWN);
  turnToLight(PAN, AVERAGE_LEFT, AVERAGE_RIGHT, LEFT, RIGHT);
}

void printEnergyMonitorData() {
  String outputText = "";
  for (int i = 0; i < 2; i++) {
    outputText += String("Panel" + String(i + 1) + ": U=" + String(SolarTrackerMonitor.voltage(i), 4) + "V, I=" + String(SolarTrackerMonitor.current(i), 4) + "A, P=" + String(SolarTrackerMonitor.power(i), 4) + "W, W=" + String(SolarTrackerMonitor.energyWS(i), 4) + "Ws");
    outputText += "\t\t";
  }
  /* Serial.print(millis() / 1000);
   Serial.print("\t");
   Serial.println(outputText);*/
}
