int lightSensor = 3;     // pin that the lightSensor is attached to
int tempSensor = 4;     // pin that the tempSensor is attached to
int accelSensorX = 0;     // pin that the accellSensorX is attached to
int accelSensorY = 1;     // pin that the accellSensorY is attached to
int accelSensorZ = 2;     // pin that the accellSensorZ is attached to


int ledPin1 = 5;
int ledPin2 = 6;
int ledPin3 = 7;
int ground = 8;

int redPin = 11;  	// R petal on RGB LED module connected to digital pin 11
int greenPin = 9; 	// G petal on RGB LED module connected to digital pin 9
int bluePin = 10; 	// B petal on RGB LED module connected to digital pin 10

int sensorValue;                   //variable to hold accelerometer data
int accelero = 1;                  //analogue pin that acclerometer is tied to

int buzzerPin = 2;
int buttonPin = 4;

int sensorMax = 0;
int sensorMin = 0;

void setup() {
  // turn on LED to signal the start of the calibration period:
  pinMode(13, OUTPUT);
  digitalWrite(13, HIGH);
  pinMode(ledPin1, OUTPUT);
  pinMode(ledPin2, OUTPUT);
  pinMode(ledPin3, OUTPUT);
  pinMode(ground, OUTPUT);
  digitalWrite(ground, LOW);

  pinMode(buzzerPin, OUTPUT);

  pinMode(buttonPin,INPUT);
  digitalWrite(buttonPin,HIGH);

  Serial.begin(9600);
  initializeRGB();                  //initialize the RGB LED pins and color (see RGB_lib)
  setGradient(200,300,500);         //set gradient (see RGB_lib)
  // 1st number is the lowest value you get from your sensor
  // 2nd is approximate midpoint

  // calibrate during the first five seconds 
  // turn on LED to signal the start of the calibration period:
  pinMode(13, OUTPUT);
  digitalWrite(13, HIGH);

  while (millis() < 5000) {
    sensorValue = analogRead(tempSensor);

    // record the maximum sensor value
    if (sensorValue > sensorMax) {
      sensorMax = sensorValue;
    }

    // record the minimum sensor value
    if (sensorValue < sensorMin) {
      sensorMin = sensorValue;
    }
  }
    digitalWrite(13, LOW);

}

void loop() {
  sensorValue = analogRead(accelero);        // read accelereometer data
  //Serial.println(sensorValue);               // send the sensor data to the computer so you can calibrate RGB LED display
  //delay(100);                                // delay so computer can display data
  // NOTE: remove the delay for your final version
  // once you've figured out what your gradient values are
  // this will make your color transitions nice & smooth
  simpleColor(sensorValue);                  // display sensor value in the RGB LED (see RGB_lib)

  int buttonState = digitalRead(buttonPin);
  if (buttonState == LOW) {     
    flash3Leds();
  }

  int lightValue = analogRead(lightSensor);
  Serial.print("Light Value: ");
  Serial.println(lightValue);

  if(lightValue < 30) {
    playTI();
  }

  int tempValue = analogRead(tempSensor);
  Serial.print("Temp Value: ");
  Serial.print(tempValue);
  Serial.print(" Temp Value Max: ");
  Serial.print(s);
  delay(10);


  if(tempValue > sensorMax) {
    buzzer();
  }
  delay(10);

  //int accelSensorXValue = analogRead(accelSensorX);
  //Serial.print("Accel X Value: ");
  //Serial.println(accelSensorXValue);

  //int accelSensorYValue = analogRead(accelSensorY);
  //Serial.print("Accel Y Value: ");
  //Serial.println(accelSensorYValue);

  //int accelSensorZValue = analogRead(accelSensorZ);
  //Serial.print("Accel Z Value: ");
  //Serial.println(accelSensorZValue);
  delay(10);
}

void flash3Leds() {
  int timeDelay = 20;
  for(int i = ledPin1; i <= ledPin3+1; i++) {
    digitalWrite(i,HIGH);
    delay(timeDelay);
    digitalWrite(i,LOW);
    delay(timeDelay);
  }
}

void buzzer() {
  int timeDelay = 200;
  for(int i = 0; i < 5; i++ ) {
    digitalWrite(buzzerPin,HIGH);
    delay(timeDelay);
    digitalWrite(buzzerPin,LOW);
  }
}
