/****************************************************************************
Reads in distance from ultrasonic range sensor and if there is an object (ideally your hand) within 8 inches
of the sensor it moves the fist out and back

(base of code is from http://blog.radioshack.com/2013/07/find-your-way-with-the-ultrasonic-range-sensor/ )

created 5/5/14
*****************************************************************************/
#include "Arduino.h"
#include <Servo.h>

class Ultrasonic // create class of objects called "Ultrasonic"
{                // create various functions and variables to be called through the class
	public:
		Ultrasonic(int pin);
        void DistanceMeasure(void);
		long microsecondsToCentimeters(void);
		long microsecondsToInches(void);
	private:
		int _pin;//pin number of Arduino that is connected with SIG pin of Ultrasonic Ranger.
        long duration;// the Pulse time received;
};
Ultrasonic::Ultrasonic(int pin) // define function
{
	_pin = pin;
}
/*Begin the detection and get the pulse back signal*/
void Ultrasonic::DistanceMeasure(void) // define function
{
    pinMode(_pin, OUTPUT);
	digitalWrite(_pin, LOW);
	delayMicroseconds(2);
	digitalWrite(_pin, HIGH);
	delayMicroseconds(5);
	digitalWrite(_pin,LOW);
	pinMode(_pin,INPUT);
	duration = pulseIn(_pin,HIGH);
}
/*The measured distance from the range 0 to 400 Centimeters*/
long Ultrasonic::microsecondsToCentimeters(void) // define variable
{
	return duration/29/2;	
}
/*The measured distance from the range 0 to 157 Inches*/
long Ultrasonic::microsecondsToInches(void) // define variable
{
	return duration/74/2;	
}

Ultrasonic ultrasonic(7); // set input signal pin

Servo myservo; // create servo object
int pos = 180; // set initial position variable


void setup()
{
	Serial.begin(9600); // start serial communications
        myservo.attach(8, 600, 2300); // attach servo to pin 8, limits are calibrated for specific servo
        myservo.write(pos); // set servo to initial position
}
void loop()
{
	long RangeInInches;
	ultrasonic.DistanceMeasure();// get the current signal time;
        RangeInInches = ultrasonic.microsecondsToInches();//convert the time to inches;
	Serial.print(RangeInInches);//0~157 inches is the range
	Serial.println(" inch");


        if (RangeInInches < 8){ // if there is something within 8 inches of the sensor
            fistBump(myservo, pos); // go through fist bump motions
            delay(3000); // delay 
        }
	delay(100);
}

void fistBump(Servo myservo, int pos){ // function for fist bump motion
  // move forward
  for(pos = 180; pos>=20; pos-=1)     // goes from 180 degrees to 20 degrees 
  {                                
    myservo.write(pos);              // tell servo to go to position in variable 'pos' 
    delay(15);                       // waits 15ms for the servo to reach the position 
  } 
  // wait a second
  delay(1000);
  
  // move back
  for(pos = 20; pos < 180; pos += 1)  // goes from 20 degrees to 180 degrees 
  {                                  
    myservo.write(pos);              
    delay(15);                       
  } 

}
