#ifndef _DISPLAY_H_
#define _DISPLAY_H_

#define LED_ON 1
#define LED_OFF 0
#define DISP_RANDOM 0
#define DISP_LINEAR 1
//Index into tris/port arrays for all LEDS off
#define ALL_OFF 30
#define NUM_LEDS 30
#define MAX_DUTY 8
#define MAX_DIMNESS 256
#define AMBIENT_PIN 0
#define AMB_MIN 220
#define AMB_MAX 240

unsigned char get_led(unsigned char nLed);
void led_on(unsigned char nLed);
void led_off(unsigned char nLed);
void update_display(void);
void led_test(void);
void init_display(void);
void show_time(unsigned char nMode);
void calc_time();
void flash_display();
void flash_group(unsigned char nGroup);
void display_wipe(void);
void display_random(void);
void display_bar(void);
void display_timer(void);
void set_brightness(unsigned int Brightness);
void adjust_brightness(void);
void set_transition(void);
void set_notransition(void);
#endif
