//*****************************************
// Microdot V1
// Copyright 2006 Philip Pulle
//                RGB Sunset Productions
// For private use only, not for commercial
// use. 
// ****************************************


#include <system.h>
#include "holoclock.h"
#include "display.h"
#include "t1rtc.h"
#include "control.h"

// Set configuration word 20MHz external clock

#ifdef _PIC16
	#pragma DATA _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _HS_OSC
	#pragma DATA _CONFIG2, _IESO_OFF & _FCMEN_OFF 
#endif //_PIC16
#pragma CLOCK_FREQ 20000000


void main()
{

	t1con = 0;			//disable T1 external oscillator as quickly as possible for ICSP

	//setup peripherals
	porta = 0;
	portb = 0;
	cmcon = 0x07;		//disable comparator output, do now to set trisa properly
	trisa = 0xff;		//all input
	trisb = 0xff;		//all input
	ansel = 0x00;		//no analog inputs
	
	delay_s(2);			//allow programmer time to do stuff at startup
	
	led_test();			//cycle through all LEDs seperately
	
	init_display();		//startup the display interrupt
	init_rtc();			//startup the RTC
	RTCTick(1);			//reset the RTC timer variable
	set_notransition();
	calc_time();
	show_time(DISP_RANDOM);

	//Main loop
	while(1)
	{
		scan_switches();	//always check the switches for input
		adjust_brightness();
		if (RTCTick(0))
		{
			//The RTC Tick variable has ticked down, so update the display to show the time
			calc_time();
			show_time(DISP_RANDOM);
			set_transition();
			
			RTCTick(5);	//reset the tick to another 15 seconds
		}

	}
}
