/*
This sketch lets you make custom moves for the icbob robot.
First enter the home positions you got from icbob_home_calibration
Try to load and run the preloaded forward walk sequence
Then customize the mv array to make your own great moves

Written by The Bridgeville Delaware Public Library Teen Imagineering Club
This code is in the public domain
*/
#include <VarSpeedServo.h>  //include the VarSpeedServo library

VarSpeedServo RH;  //create 4 VarSpeedServo objects for the 4 servos
VarSpeedServo RA;
VarSpeedServo LH;
VarSpeedServo LA;

const int svsp = 10;  //speed setting for VarSpeedServo SlowMove
const int framedelay = 750;  //frame delay to allow servo movement

//set the members for the array hm to the home positions for your robot
//they can be found by using the icbob_home_calibration sketch
const int hm[4] = {95,95,85,90};  //array to hold home position for each servo RH,RA,LH,LA

//mv array data. Each line is a 'frame' or position set for the 4 servos
//Multiple lines create a group of movements that can be looped to
//create walking, turning, dance or other movements
const int mvct = 6;  //Make this number equal to the number of lines in the array
const int mv[mvct][4] =  
{
  {0,-40,0,-20},        //These preloaded numbers should give a forward walk
  {30,-40,30,-20},
  {30,0,30,0},
  {0,20,0,40},
  {-30,20,-30,40},
  {-30,0,-30,0},
};

void setup()  //setup runs one time
{
  RH.attach(9);   //attach the 4 servo objects to the corresponding pins
  RA.attach(10);  //Robot's right and left when viewed from behind
  LH.attach(11);  //Not with the robot facing you!
  LA.attach(12);
  
  //home servos for 2 seconds to stabilize
  RH.slowmove (hm[0] , svsp);
  RA.slowmove (hm[1] , svsp);
  LH.slowmove (hm[2] , svsp);
  LA.slowmove (hm[3] , svsp);
  delay(2000);
}

void loop()  //loop repeats forever
{ 
  // Do move sequence 
  for(int x=0; x<mvct; x++) {                   //cycle through the number of
    RH.slowmove (hm[0] + mv[x][0] , svsp);      //lines 'frames' in the array
    RA.slowmove (hm[1] + mv[x][1] , svsp);
    LH.slowmove (hm[2] + mv[x][2] , svsp);
    LA.slowmove (hm[3] + mv[x][3] , svsp);
    delay(framedelay);
  }
}
