/*
This sketch programs the icbob robot to move forward until the sonar
detects an obstacle. Then it does a 90 deg turn and continues forward

Written by The Bridgeville Delaware Public Library Teen Imagineering Club
This code is in the public domain
*/
#include <VarSpeedServo.h>  //include the VarSpeedServo library
#include <NewPing.h>        //include the NewPing library

VarSpeedServo RH;  //create 4 VarSpeedServo objects for the 4 servos
VarSpeedServo RA;
VarSpeedServo LH;
VarSpeedServo LA;

NewPing sonar(13,3,200);  //create a NewPing object. (trigger pin, echo pin, max distance cm)

const int svsp = 10;  //speed setting for VarSpeedServo SlowMove
const int framedelay = 750;  //delay between frames to allow servo movement

//set the members for the hm array to the home positions for your robot
//they can be found by using the icbob_home_calibration sketch
const int hm[4] = {95,95,85,90};  //array to hold home position for each servo RH,RA,LH,LA

//forward array data
const int fwdmvct = 6;  //Make this number equal to the number of lines in the array
const int fwdmv[fwdmvct][4] =  
{
  {0,-40,0,-20},        //walk forward move frames
  {30,-40,30,-20},
  {30,0,30,0},
  {0,20,0,40},
  {-30,20,-30,40},
  {-30,0,-30,0},
};

//turn array data
const int trnmvct = 5;  //Make this number equal to the number of lines in the array
const int trnmv[trnmvct][4] =  
{
  {-40,0,-20,0},        //turn move frames
  {-40,30,-20,30},
  {0,30,0,30},
  {30,0,30,0},
  {0,0,0,0},
};

void setup()  //setup runs one time
{
  RH.attach(9);   //attach the 4 servo objects to the corresponding pins
  RA.attach(10);  //Robot's right and left when viewed from behind
  LH.attach(11);  //Not with the robot facing you!
  LA.attach(12);
  
  //home servos for 2 seconds to stabilize
  RH.slowmove (hm[0] , svsp);
  RA.slowmove (hm[1] , svsp);
  LH.slowmove (hm[2] , svsp);
  LA.slowmove (hm[3] , svsp);
  delay(2000);
}

void loop()  //loop repeats forever
{ 
  //Ping sonar for close encounter
  int tooclose = 0;
  for(int a=0; a<5; a++) {   //Ping 5 times to get a good sample
    delay(50);
    int din = sonar.ping_in();
    if (din < 7 && din > 0) tooclose++;
  }
  if (tooclose < 5)  //If less than 5 (all) positive readings move forward - Else turn
    {
      // Do forward move sequence 
      for(int x=0; x<fwdmvct; x++) {                     //cycle through the number of
        RH.slowmove (hm[0] + fwdmv[x][0] , svsp);        //lines 'frames' in the array
        RA.slowmove (hm[1] + fwdmv[x][1] , svsp);
        LH.slowmove (hm[2] + fwdmv[x][2] , svsp);
        LA.slowmove (hm[3] + fwdmv[x][3] , svsp);
        delay(framedelay);
      }
    }
  else
    {
      //Do turn sequence
      for(int z=0; z<4; z++) {      //repeat sequence 4 times for quarter turn
        for(int y=0; y<trnmvct; y++) {                   //cycle through the number of
          RH.slowmove (hm[0] + trnmv[y][0] , svsp);      //lines 'frames' in the array
          RA.slowmove (hm[1] + trnmv[y][1] , svsp);
          LH.slowmove (hm[2] + trnmv[y][2] , svsp);
          LA.slowmove (hm[3] + trnmv[y][3] , svsp);
          delay(framedelay); 
        }
      }
    }
}
