# -*- coding: utf-8 -*-

import  sys
import  glob
import  os
import  wx


# https://stackoverflow.com/questions/5374451/importerror-cannot-import-name-publisher

# this is for publish and subscribe pattern, with an update
# from wx.lib.pubsub import Publisher

from wx.lib.pubsub import setuparg1 
from wx.lib.pubsub import pub as Publisher
# and replace any occurence of "Publisher()." by "Publisher."

import image_edit     # the controller
import file_info      # useful file information on files to view 

class GUI( wx.Frame ):


    def __init__( self, aController, aApp, ):
        """Constructor"""
        
        self.myController   = aController
        self.myParameters   = aController.myParameters
        
        wx.Frame.__init__(self, None, title="")    # ?? title?
        
        self.folderPath     = ""
        #self.fileInfo      = None        
        self.position       = ( self.myParameters.xPosition   , self.myParameters.yPosition )
        
        Publisher.subscribe(self.resizeFrame, ("resize"))
             
        self.viewer_ix_max      = self.myParameters.viewers   # ?? move to parameters
        self.viewers            = []        
        
        self.buildGui( )
        
        self.initToolbar()
        
        self.SetSizer(self.sizer)
        
        self.Show()
        self.sizer.Fit(self)
        self.Center() 
        #self.s
    
    #----------------------------------------------------------------------        
    def buildGui( self ):
        
        """
        get n image viewers
        seems fine
        ?? move to init ??
        """

        self.sizer = wx.BoxSizer(wx.HORIZONTAL)

        for ix in range( self.viewer_ix_max ):
        
            self.viewers.append( ViewerPanel( self ) )
            self.sizer.Add( self.viewers[ix], 1, wx.EXPAND )        

    #----------------------------------------------------------------------
    def setSizePosition(self, ):
        """
        last thing to do prior to showing, name is not great
        """
                        
        self.myGui.Move( self.position )     # flags=SIZE_USE_EXISTING)
        self.myGui.Show()

    #----------------------------------------------------------------------
    def resizeFrame(self, msg):
        """"""
        self.sizer.Fit(self)

    #----------------------------------------------------------------------
    def initToolbar(self):
        """
        Initialize the toolbar
        """
        
        self.toolbar = self.CreateToolBar()
        self.toolbar.SetToolBitmapSize((16,16))
        
        open_ico = wx.ArtProvider.GetBitmap(wx.ART_FILE_OPEN, wx.ART_TOOLBAR, (16,16))
        openTool = self.toolbar.AddSimpleTool(wx.ID_ANY, open_ico, "Open an Image Directory", "Open an Image Directory")
        self.Bind(wx.EVT_MENU, self.onOpenDirectory, openTool)
        
#==============================================================================
#         next_ico = wx.ArtProvider.GetBitmap(wx.ART_FILE_OPEN, wx.ART_TOOLBAR, (16,16))
#         openTool = self.toolbar.AddSimpleTool(wx.ID_ANY, open_ico, "Next", "Next Image")
#         self.Bind(wx.EVT_MENU, self.myController.showNextImage, openTool )
#==============================================================================
        
        self.toolbar.Realize()

    #----------------------------------------------------------------------
    def onOpenDirectory(self, event):
        """
        Opens a DirDialog to allow the user to open a folder with pictures
        """
        
        # content moved to controller
        
        self.myController.updateImages( "junk" )   # delete junk and dead code
        
        return
        
     #----------------------------------------------------------------------
    def deletAdd(self,):
        """
        test on rearranging image containing widgets
        """
        
        print "deleteAdd"
        ret = self.sizer.Detach( self.viewers[2] )
        #ret = self.sizer.Remove( self.viewers[2] )
        print ret
        #Add( self.viewers[2], 1, wx.EXPAND ) 
        self.sizer.Add( self.viewers[2], 1, wx.EXPAND )  

        #self.Show()
        self.sizer.Layout( )
        self.sizer.Fit(self)
        self.Center()      
        self.Show() 
          
        return
        
 
#----------------------------------------------------------------------

class ViewerPanel( wx.Panel ):
    """
    all the vieweres
    """

    #----------------------------------------------------------------------
    def __init__(self, parent):
        """
        Constructor
        style=wx.RAISED_BORDER)
        """
        
        wx.Panel.__init__(self, parent, style=wx.RAISED_BORDER)   
        
        width, height = wx.DisplaySize()
        self.picPaths = []          # list of all file, may be obsolete as may be some of this other stuff 
        self.currentPicture = 0
        self.totalPictures  = 0
        self.controller     = self.GetParent( ).myController
        self.parameters     = self.GetParent( ).myParameters   # better get from controller 
       
        # ??make parameter 
        self.photoMaxSize = height - 550  # may want in parameters 
        
        self.fileInfo    = None
        
        #Publisher.subscribe(self.updateImages, ("update images"))

        #self.slideTimer = wx.Timer(None)
        #self.slideTimer.Bind(wx.EVT_TIMER, self.update)
        
        self.layout()
        
        #self.Cursor
        
        #self.SetCursor
        
        #self.
        
    #----------------------------------------------------------------------
    def layout(self):
        """
        Layout the widgets on the panel
        """
        
        self.mainSizer = wx.BoxSizer(wx.VERTICAL)
        #btnSizer = wx.BoxSizer( wx.HORIZONTAL )
        btnSizer = wx.GridSizer( 3,3,1,1 )
        
        # ========= IMAGE WAS ABOVE HERE 
        
#==============================================================================
#         btnData = [("Previous",   btnSizer, self.onPrevious),
#                    ("Slide Show", btnSizer, self.onSlideShow),
#                    ("Next",       btnSizer, self.onNext),
#                    ("del",        btnSizer, self.deleteImage) ]
#==============================================================================
                   
                  
                   
        btnData = [ (self.parameters.butZeroLabel,   btnSizer,  self.onZero),
                    (self.parameters.butOneLabel,    btnSizer,  self.onOne ),                 
                    (self.parameters.butTwoLabel,    btnSizer,  self.onTwo ), 
                    ("RR" ,    btnSizer,  self.rr      ), 
                    ("RL" ,    btnSizer,  self.rl      ), 
                    ("USD" ,   btnSizer,  self.usd      ), 
                    # ("Tst" ,   btnSizer,  self.tst      ),  # for testing new funcions
                   ]
                   
                   
        for data in btnData:
            label, sizer, handler = data
            self.btnBuilder(label, sizer, handler)
            
        self.mainSizer.Add(btnSizer, 0, wx.CENTER)
        
        #----------- MOVE IMAGE HERE 
        img = wx.EmptyImage(self.photoMaxSize,self.photoMaxSize)
        self.imageCtrl = wx.StaticBitmap(self, wx.ID_ANY, 
                                         wx.BitmapFromImage(img))
        self.mainSizer.Add(self.imageCtrl, 0, wx.ALL|wx.CENTER, 5)
        self.imageLabel = wx.StaticText(self, label="")
        self.mainSizer.Add(self.imageLabel, 0, wx.ALL|wx.CENTER, 5)
   
        # ------------------        
        
        self.SetSizer(self.mainSizer)
            
    #----------------------------------------------------------------------
    def btnBuilder(self, label, sizer, handler):
        """
        Builds a button, binds it to an event handler and adds it to a sizer
           
        """
        
        btn = wx.Button(self, label=label)
        btn.Bind(wx.EVT_BUTTON, handler)
        
        #sizer.Add(btn, 0, wx.ALL|wx.CENTER, 5)   # for box
        sizer.Add(btn, )   # for grid?
        
    #----------------------------------------------------------------------
    def loadImage(self, image):
        """"""
        
        image_name = os.path.basename(image)
        img = wx.Image(image, wx.BITMAP_TYPE_ANY)
        # scale the image, preserving the aspect ratio
        W = img.GetWidth()
        H = img.GetHeight()
        if W > H:
            NewW = self.photoMaxSize
            NewH = self.photoMaxSize * H / W
        else:
            NewH = self.photoMaxSize
            NewW = self.photoMaxSize * W / H
        # see also  http://ubuntuforums.org/showthread.php?t=1188248 
        img = img.Scale(NewW,NewH)

        self.imageCtrl.SetBitmap(wx.BitmapFromImage(img))
        self.imageLabel.SetLabel(image_name)
        self.Refresh()
        Publisher.sendMessage("resize", "")
        
   
    #----------------------------------------------------------------------
    def setFileInfo( self, fileInfo ):
        
        """
        sets the fileInfo and displays the image 
        ?? move loadImage here?
        """
        
        self.fileInfo    = fileInfo
        self.loadImage( self.fileInfo.fullname )
        

        
    #----------------------------------------------------------------------
    def updateImagesxxxxx(self, msg):
        """
        Updates the picPaths list to contain the current folder's images
        called by publish/subscribe
        """
        
        #print "gui.py just got the message"
        self.picPaths = msg.data
        self.totalPictures = len(self.picPaths)
        #self.loadImage(self.picPaths[0])
        
    #----------------------------------------------------------------------
    def deleteImagexxxx(self, event):
        """
        dead code now, probably forever
        """            
        
        self.controller.deleteImage( self )
        
    #----------------------------------------------------------------------
    def onZero( self, event ):
        """
        
        """
        self.controller.classify( self, 0 )
    
    def onOne( self, event ):
        """
        
        """
        self.controller.classify( self, 1 )

    def onTwo( self, event ):
        """
        
        """
        self.controller.classify( self, 2 )
        
    #----------------------------------------------------------------------
    def rr( self, event ):  
        """
        rotate right
        """      
        #print self
        #print self.fileInfo
        self.controller.rotate( self, "rr" )
        
    #----------------------------------------------------------------------    
    def rl( self, event ):  
        """
        rotate left
        """      
        self.controller.rotate( self, "rl" )
        
    #----------------------------------------------------------------------       
    def usd( self, event ):  
        """
        rotate up side down
        """     
        
        self.controller.rotate( self, "usd" )
        
            #----------------------------------------------------------------------       
    def tst( self, event ):  
        """
        rotate up side down
        """     
        
        self.controller.tst( self, event )


#   ========================= eof ============================



