# -*- coding: utf-8 -*-

"""
Overview:
    This program is designed to help the user quickly sort images into 3 classes,
    typically keep, keep as duplicated, and delete.
    Since incorrect rotation is so often a issue you can also rotate either left
    right or upside down.
    Details:
        Sort Order:

        File handling:
              to be written
        File dates:
              to be written
        Parameters:
              to be written
    Author:  russ_hensel, see:  http:www.opencircuits.com/User:Russ_hensel
    Download:

Environment:
    Tested in:
        OS:        Win 7
        IDE:       Spyder 2.3.1
        Language:  Python 2.7
     Should run in any Python 2.7 envoroment on any OS
     this file image_edit.py
Reminders, notes:
    .....

Status/history:

    working, beta

    enhancements ! = in process, * = done
    * initial load of eof
    * make sure eof is not processed like a pic
    * can we move the images to make faster  ??
    * rotates
    * better size positon
    ! title with directory displayed
    ! help and about
    ! ini in text file 
    !* clean up dead code ??
    ! wait cursor ??
    ! get file name function ? into copy paste
    ! more info function ?
    ! blow up one or two pics ?
    * add border
    * removed simpleApp

"""

import file_info
import logger
import parameters
import gui

import shutil
import glob
import os
import os.path
import wx
import sys
import time

from pprint import pprint
from PIL import Image

from wx.lib.pubsub import setuparg1
from wx.lib.pubsub import pub as Publisher

# https://stackoverflow.com/questions/5374451/importerror-cannot-import-name-publisher

# from wx.lib.pubsub import Publisher
# and replace any occurence of "Publisher()." by "Publisher."

class MyApp:

    def __init__(self,  ):
        
        self.myName         = "MyApp for image_edit"
        
        self.titlePrefix    = "Image Sorter:  "
        self.version        = "2015 June 12.1"

        self.myParameters   = parameters.Parameters( self ) # open early may effect other

        self.myLogger       = logger.Logger( self )
        self.myLogger.open()  # later should get file from parameters??

        self.imageIx        = 0
        self.maxImageIx     = 0   # for the array of fileInfos

        self.fileInfoEof    = file_info.FileInfo( "eof.jpg"  )
        self.fileInfoEof.ixfilelist  = -1    # -1 indicated not in sorted directory list
        self.fileInfoEof.ixSort      = -1
        


        self.fileInfos      = None     # list of all files, in sort order

        self.folderPath     = None     # directory for images  ?? may not be needed at object level
        self.picPaths       = None     # listr images or pictures  ?? may not be needed at object level
        self.dirOne         = None     # directory for next best
        self.dirTwo         = None     # directory for "delete"

        self.dirBack        = None     # directory for backup when editing
        self.ixMaxImage     = None     # index of the right most picture

        self.prog_info()

        Publisher.subscribe(self.updateImages, ("update images"))   #subscribe for event

        #self.app = wx.PySimpleApp()
        
        self.app = wx.App()     # try this to bring up to date     
        

        self.myGui          = gui.GUI( self, self.app,  )  # create the gui or view part of the program
        
        self.myGui.SetTitle( self.titlePrefix + "no directory seleted" )

        self.normCursor     = self.myGui.GetCursor()
        self.waitCursor     =  wx.StockCursor( wx.CURSOR_WAIT )
        
        self.myGui.SetCursor( self.waitCursor   )   # self.waitCursor
        
        self.allEof( )

        self.myGui.SetCursor( self.normCursor   )   # self.waitCursor

        self.app.MainLoop()
        return

    # ----------------------------------------------------------------------
    def allEof( self, ):
        """
        initial all Eof.jpg

        """

        for ixViewer in ( range( self.myGui.viewer_ix_max ) ):
            self.myGui.viewers[ixViewer].setFileInfo( self.fileInfoEof )

    # ----------------------------------------------------------------------
    def showIntImage( self, ):
        """
        initial display left to right after a directory is chosen
        still in use - yes
        """

        #print "showIntImage"
        for ixViewer in ( range( self.myGui.viewer_ix_max ) ):
            print "showIntImage", ixViewer
            ixImage = ixViewer
            #self.myGui.viewers[ix].loadImage(self.picPaths[ self.imageIx + ix])
            if  ixImage < len( self.fileInfos ):
                fileInfo             = self.fileInfos[ ixImage ]
                self.ixMaxImage      = ixImage
            else:
                fileInfo             = self.fileInfoEof
                self.ixMaxImage      = -1

            fileInfo.ixfilelist  = ixImage   # what does this do, does this var exist??
            self.myGui.viewers[ixViewer].setFileInfo( fileInfo )

    # ----------------------------------------------------------------------
    def makeDir( self, dir ):
        #result_dir   = r"d:\temp\delete_me"
        if not os.path.exists(dir):
            #print "make it"
            os.makedirs(dir)
        #else:
            #print "dir exists"


    #----------------------------------------------------------------------
    def updateImages(self, msg):
        """
        Updates the picPaths list to contain the current folder's images as list
        will build the master list and sort
        this is a subscriber -- may drop and call from gui
        """

        dlg = wx.DirDialog( self.myGui, "Choose a directory for pictures", style=wx.DD_DEFAULT_STYLE)

        if dlg.ShowModal() == wx.ID_OK:
            self.folderPath = dlg.GetPath()
            print "user opened folderPath " + self.folderPath
            # can we extend to more file types, need to i think
            self.picPaths = glob.glob(self.folderPath + "\\*.jpg")

            #print picPaths
        else:
            return
        # next may be wrong if user did not pick a directory

        #print "image_edit just got the message"
        #self.picPaths = msg.data
        #self.totalPictures = len(self.picPaths)
        #self.loadImage(self.picPaths[0])
        # print  "self.picPaths",
        #print   self.picPaths

        self.myGui.SetCursor( self.waitCursor   )   # self.waitCursor
        
        self.myGui.SetTitle( self.titlePrefix + self.folderPath )

        self.fileInfos = []
        for item in self.picPaths:
            self.fileInfos.append( file_info.FileInfo( item ) )
            #print item
            #print self.fileInfos[ -1 ]
        # sort by some criteria, now say size just as a test
        self.fileInfos.sort( key = self.getKey  )
        #pprint( self.fileInfos )

        #lf.maxImageIx     = 0
        # put in sort order do not have to maintain untill new directory
        for ix, ifileInfo in enumerate( self.fileInfos ):
            ifileInfo.ixSort = ix

        self.dirOne      = os.path.join( self.folderPath, self.myParameters.subOne, "" )
        self.makeDir( self.dirOne )

        self.dirTwo      = os.path.join( self.folderPath, self.myParameters.subTwo, "" )
        self.makeDir( self.dirTwo )

        self.dirBack     = os.path.join( self.folderPath, self.myParameters.subBack    , "" )
        self.makeDir( self.dirBack )

        self.showIntImage()
        
        
        self.myGui.SetCursor( self.normCursor   )   # self.waitCursor

    #----------------------------------------------------------------------
    def getKey( self, item ):
        """
        key for sort, this is kind of basic
        item returned will be the sort key
        """

        #return item.size
        return  item.fullname

    #----------------------------------------------------------------------
    def loadImage( ixFileInfo, ixViewer ):
        """
        load image by index into viewer by index
        """
        #could of course be done in one line
        fileInfo             = self.fileInfos[ ixImage ]
        #file_info.ixfilelist  = ixImage
        self.myGui.viewers[ixViewer].setFileInfo( fileInfo )

    #----------------------------------------------------------------------
    def findNextImage( self, prior ):
        """
        prior is ix of the prior fileInfos
        return ix of next valid fileInfos or -1 if no valid ix
        this is overdone because I currently do not back up just go forwardd
        """
        ix         = -1
        ixImage    = prior
        done       = False   # break might do as well
        if ixImage == -1:     # already past end -- may need a before end flag as well
            return ixImage

        while done == False:
            ixImage  += 1
            # may have a variable that keeps the length ??
            if ixImage >= len( self.fileInfos ):
                    done   = True
                    ix     = -1
            elif not( self.fileInfos[ixImage].processed):
                    done   = True
                    ix     = ixImage
        return ix

    #----------------------------------------------------------------------
    def showNextImage( self, ignore ):
        print "showNextImage is dead??"

        #ixImage = self.imageIx   # try next ( could get a few from next controlls )


        for ix_viewer in reversed( range( self.myGui.viewer_ix_max ) ):

            ixImage  = self.findNextImage( self.myGui.viewers[ix_viewer].file_info.ixfilelist )
            if ixImage <> -1:
                file_info             = self.fileInfos[ ixImage ]
                # file_info.ixfilelist  = ixImage
                self.myGui.viewers[ix_viewer].setFileInfo( file_info )
            else:
                self.myGui.viewers[ix_viewer].setFileInfo( self.fileInfoEof )

            return

    #----------------------------------------------------------------------
    def getViewerIx( self, viewer ):
        """
        determine the index of the viewer
        may need update for moving viewers
        """
        for ixViewer in ( range( self.myGui.viewer_ix_max ) ):
            #  = self.fileInfos[ ixImage ]
            if self.myGui.viewers[ ixViewer ]  ==  viewer:
                #print " viewer is", ixViewer
                break

        return ixViewer

    #----------------------------------------------------------------------

    def rotate( self, viewer, action ):
        """
        rotate the image, replace file
        make a backup unless already made
        **manage dates  ?? test looks like done

        """
        print "rotate"

        #ixViewer  = self.getViewerIx( viewer )   # we have the viewer do we need the ix
        #viewer    = self.myGui.viewers[ ixViewer ]  # do not need
        fileInfo  = viewer.fileInfo

        if fileInfo.ixSort == -1:   # no rotation for eof
            return
            
            
        #cursor  = wx.wxCursor( wx.CURSOR_WAIT )
        #oldCursor = self.myGui.GetCursor()
        #cursor  =  wx.StockCursor( wx.CURSOR_WAIT )
        #self.myGui.
        
        #self.myGui.viewers[0].BeginBusyCursor( cursor   )
        #self.myGui.viewers[0].SetCursor( cursor   )
        self.myGui.SetCursor( self.waitCursor   )
        
        #.wxBeginBusyCursor( cursor   )   #Cursor *cursor = wxHOURGLASS_CURSOR)

        fn        = fileInfo.fullname
        fbn       = os.path.basename( fn )
        dest      = os.path.join( self.dirBack, fbn )
        print  time.time(), fileInfo.modify_date

        if os.path.isfile( dest ):
            im   = Image.open( fn )  # this grabs onto the file may have to use a temp
            # still need to do dates
        else:
            print "moving"
            #viewer.loadImage( "eof.jpg" )
            shutil.move( fn, dest )     # move changes the modified date
            im   = Image.open( dest )  # this grabs onto the file may have to use a temp

            os.utime( dest, ( time.time(), fileInfo.modify_date ))   # (accesstime, modifiedtime).

        if  action == "rr":
            im = im.transpose( Image.ROTATE_270 )
        elif action == "rl":
            im = im.transpose( Image.ROTATE_90 )
        else:
            im = im.transpose( Image.ROTATE_180 )

        # we are saving under same name, overwrite, or need to erase?
        im.save( fn, )   # only for jpg so far

        viewer.setFileInfo( fileInfo  )  # reseting same one to reload

        os.utime( fn, ( time.time(), fileInfo.modify_date ))   # (accesstime, modifiedtime).
        
        self.myGui.SetCursor( self.normCursor   )   # self.waitCursor
        #im_rr.save( fn1, "JPEG")

   #----------------------------------------------------------------------
    def tst( self, viewer, event ):
        """
        place for test routine

        """
        print " tst"

    #----------------------------------------------------------------------
    def classify( self, viewer, action ):
        """
        now new classify
        and move to next pic
        """

        print " classify"


        fileInfo = viewer.fileInfo

        if fileInfo.ixSort == -1:   # no processing for eof
            return
            
        self.myGui.SetCursor( self.waitCursor   )   # self.waitCursor

        # use this guy to process the file related to this viewer
        src   = fileInfo.fullname
        # need to extract name from full name then build dest
        dest   = os.path.basename( src )

        #action determines if needs to be copied and if so where
        if   action == 0:
            #fileInfo.processed   = True
            destDir              = self.folderPath

        elif action == 1:
            destDir              = self.dirOne

        else:
            destDir              = self.dirTwo

        dest   = os.path.join( destDir, dest )
        fileInfo.processed   = True
        fileInfo.newname     = dest

        if action <> 0:
           shutil.move( src, dest )

        # ========= move deleted to the end and reload

        #print "deleteAdd"
        ret = self.myGui.sizer.Detach( viewer )
        #ret = self.sizer.Remove( self.viewers[2] )
        #print ret
        #Add( self.viewers[2], 1, wx.EXPAND )
        self.myGui.sizer.Add( viewer, 1, wx.EXPAND )

        #self.Show()
        # some of this might go over to the gui
        self.myGui.sizer.Layout( )
        self.myGui.sizer.Fit( self.myGui )
        #self.myGui.Center()
        #self.myGui.Show()

        ix_next  = self.findNextImage( self.ixMaxImage )
        self.ixMaxImage  = ix_next
        if ix_next >= 0:
            viewer.setFileInfo( self.fileInfos[ ix_next ] )
            pass
        else:
            viewer.setFileInfo( self.fileInfoEof )
            
        self.myGui.SetCursor( self.normCursor   )   # self.waitCursor
            
#==============================================================================
#         self.myGui.Move( (100, 100) )     # flags=SIZE_USE_EXISTING)
#         self.myGui.Show()
#==============================================================================
        self.myGui.setSizePosition

    #----------------------------------------------------------------------
    def rotatedeleteme( self, viewer, action ):
        """
        rotate the image, replace file
        make a backup unless already made
        **manage dates  ?? test looks like done

        """
        print "rotate test"
        self.myGui.deletAdd( )
        # viewer.


    #----------------------------------------------------------------------
    def zeroTwo( self, viewer, action ):
        """
        replaCED By classify this loads all the picks to add one new at end
        sort the file into correct directory
        delete from viewer and bring in the next, supseeeeds show next
        image? no
        viewer the Viewer whose button was pressed
        action 0....2

        """

        # need to find the viewer ?

        print "zeroTwo"
        ixViewer  = self.getViewerIx( viewer )   # DO WE    need this?

        # need to work on dates still need to check

        fileInfo = self.myGui.viewers[ ixViewer ].fileInfo   # could directly get from viewer

        if fileInfo.ixSort == -1:   # no processing for eof
            return

        # use this guy to process the file related to this viewer
        src   = fileInfo.fullname
        # need to extract name from full name then build dest
        dest   = os.path.basename( src )

        #action determines if needs to be copied and if so where
        if   action == 0:
            #fileInfo.processed   = True
            destDir              = self.folderPath

        elif action == 1:
            destDir              = self.dirOne

        else:
            destDir              = self.dirTwo

        dest   = os.path.join( destDir, dest )
        fileInfo.processed   = True
        fileInfo.newname     = dest

        if action <> 0:
           shutil.move( src, dest )

        # now manage the gui to bring up the next image -- could be done in the gui??
        ixLowViewer = ixViewer
        for ixViewer in ( range( ixLowViewer, self.myGui.viewer_ix_max ) ):
#==============================================================================
#             if   ixViewer == self.myGui.viewer_ix_max -1:
#==============================================================================
                ix_next  = self.findNextImage( self.myGui.viewers[ixViewer].fileInfo.ixSort )
                self.ixMaxImage = ix_next
                if ix_next >= 0:
                    self.myGui.viewers[ixViewer].setFileInfo( self.fileInfos[ ix_next ] )
                    pass
                else:
                    self.myGui.viewers[ixViewer].setFileInfo( self.fileInfoEof )
#==============================================================================
#             else:
#                 self.myGui.viewers[ixViewer].setFileInfo(   self.fileInfos[  self.myGui.viewers[ixViewer + 1 ].fileInfo.ixSort ] )
#==============================================================================


#==============================================================================
#             if ix_viewer == 0:              # advance if first viewer
#                 self.imageIx = ixImage
#
#
#             if ixImage <> - 1:
#                 file_info  = self.fileInfos[ imageIx ]
#                 self.myGui.viewers[ix_viewer].setFileInfo( file_info )
#==============================================================================


    #----------------------------------------------------------------------

    def prog_info( self ):
        """
        log info about program and its argument/enviroment
        nice to have system time and date
        """

        self.logit( "" )
        self.logit( "============================" )
        self.logit( "" )

        self.logit( "Running image_edit version = " + self.version  )
        self.logit( "" )
        #  data_dir=russ_data  graph_type=graph_tot
        if len( sys.argv ) == 0:
            logit( "no command line arg " )
        else:
            ix_arg = 0
            for aArg in  sys.argv:

                self.logit( "command line arg " + str( ix_arg ) + " = " + sys.argv[ix_arg])
                ix_arg += 1

        self.logit( "current directory " +  os.getcwd() )
        return

    # ----------------------------------------------------------------------
    def logit( self, adata ):
        """
        for compatability with old code
        # self.logit( str( self.task_tick )  )   # self.logit( "msg"  )
        """
        self.log( adata, "logit" )
        return

    # ----------------------------------------------------------------------
    def log( self, adata, ato ):
        """
        just a call to logger
        is this needed/used, can component
        call directly?

        """
        self.myLogger.log( adata, ato )
        return

# ----------------------------------------------------------------------
if __name__ == "__main__":

        aApp = MyApp(  )
        # clean up, might be nice to get up into the app
        #aApp.myDriver.close()
        aApp.logit( "image_edit all done" )
        aApp.myLogger.close()


