// IoT Valentine project code by Becky Stern
// full tutorial: http://www.instructables.com/id/Internet-Valentine
//
// based on examples from Adafruit IO Arduino Library:
// https://github.com/adafruit/Adafruit_IO_Arduino
//
// Adafruit invests time and resources providing this open source code.
// Please support Adafruit and open source hardware by purchasing
// products from Adafruit!
//
// Written by Todd Treece for Adafruit Industries
// Copyright (c) 2016 Adafruit Industries
// Licensed under the MIT license.
//
// All text above must be included in any redistribution.

/************************** Configuration ***********************************/

// edit the config.h tab and enter your Adafruit IO credentials
// and any additional configuration needed for WiFi, cellular,
// or ethernet clients.
#include "config.h"

/************************ Code Starts Here *******************************/

#include <ESP8266WiFi.h>
#include <AdafruitIO.h>
#include <Adafruit_MQTT.h>

#define LED_PIN 15
#define BUTTON1_PIN 4
#define BUTTON2_PIN 14
#define MOTOR_PIN 5 // this pin needs PWM capability

// button state
int current = 0;
int last = 0;

// set up the 'digital' feed
AdafruitIO_Feed *command = io.feed("command");

void setup() {

  // set button pins as inputs with internal pull-up resistor
  pinMode(BUTTON1_PIN, INPUT_PULLUP);
  pinMode(BUTTON2_PIN, INPUT_PULLUP);
  // set led pin and motor pin as a digital outputs
  pinMode(MOTOR_PIN, OUTPUT);
  pinMode(LED_PIN, OUTPUT);

  // start the serial connection
  Serial.begin(115200);

  // connect to io.adafruit.com
  Serial.print("Connecting to Adafruit IO");
  io.connect();
  
  // set up a message handler for the 'command' feed.
  // the handleMessage function (defined below)
  // will be called whenever a message is
  // received from adafruit io.
  command->onMessage(handleMessage);

  // wait for a connection
  while(io.status() < AIO_CONNECTED) {
    Serial.print(".");
    delay(500);
  }

  // we are connected
  Serial.println();
  Serial.println(io.statusText());

}

void loop() {

  // io.run(); is required for all sketches.
  // it should always be present at the top of your loop
  // function. it keeps the client connected to
  // io.adafruit.com, and processes any incoming data.
  io.run();

  // grab the current state of the button.
  // we have to flip the logic because we are
  // using INPUT_PULLUP.
  if(digitalRead(BUTTON1_PIN) == LOW)
    current = 1;
  if (digitalRead(BUTTON2_PIN) == LOW)
    current = 2;
  if (digitalRead(BUTTON2_PIN) == HIGH && digitalRead(BUTTON1_PIN) == HIGH)
    current = 0;

  // return if the value hasn't changed
  if(current == last)
    return;

  // save the current state to the 'digital' feed on adafruit io
  Serial.print("sending button -> ");
  Serial.println(current);
  command->save(current);

  // store last button state
  last = current;

}

// this function is called whenever a 'command' message
// is received from Adafruit IO. it was attached to
// the command feed in the setup() function above.
void handleMessage(AdafruitIO_Data *data) {

  int command = data->toInt();

  if (command == 1){ //move the motor
    Serial.print("received <- ");
    Serial.println(command);
     analogWrite(MOTOR_PIN, 900);
     delay(500);
     analogWrite(MOTOR_PIN, 0);
  } else if (command == 2) {
    Serial.print("received <- ");
    Serial.println(command);
    digitalWrite(LED_PIN, HIGH);
    delay(500);
    digitalWrite(LED_PIN, LOW);
  } else {
    Serial.print("received <- ");
    Serial.println(command);
  }
}
