import Leap, sys, thread, time, serial
from spyrk import SparkCloud
from Leap import CircleGesture, KeyTapGesture, ScreenTapGesture, SwipeGesture

#variables
serDataL = "0"
serDataR = "0"
serDataOld = "00"
file = []

#get Photon connection data from config
fileGet = open("config/leapPhoton.txt", "r")
for line in fileGet:
    line = line.replace("\n", "")
    file.append(line)
fileGet.close()

#save Photon connection data
username = file[0]
pwd = file[1]
device = file[2]

#connect to Particle cloud
particle = SparkCloud(username, pwd)

print("\nConnected to Particle cloud, scanning for device '" + device + "'...")

class LeapMotionListener(Leap.Listener):
    fingerNames = ["Thumb", "Index", "Middle", "Ring", "Pinky"]
    boneNames = ["Metacarpal", "Proximal", "Intermediate", "Distal"]
    stateNames = ["STATE_INVALID", "STATE_START", "STATE_UPDATE", "STATE_END"]

    def on_init(self, controller):
        print("Initialized Leap Motion libraries...")
        
    def on_connect(self, controller):
        print("Leap Motion sensor connected...")
            
        controller.enable_gesture(Leap.Gesture.TYPE_CIRCLE);
        controller.enable_gesture(Leap.Gesture.TYPE_KEY_TAP);
        controller.enable_gesture(Leap.Gesture.TYPE_SCREEN_TAP);
        controller.enable_gesture(Leap.Gesture.TYPE_SWIPE);

    def on_disconnect(self, controller):
        print("Leap Motion sensor disconnected.")

    def on_exit(self, controller):
        #stop motors, then close program
        if serDataOld != "00":
            print "00   0"
        particle.devices[device].updateMotors("0")
        print("Done.")

    def on_frame(self, controller):
        frame = controller.frame()

        if not len(frame.hands) < 1:
            for hand in frame.hands:
                global serDataL, serDataR, serDataOld

                #is hand left or right?
                handType = "Left Hand" if hand.is_left else "Right Hand"

                #define normal, direction, pitch, roll, and yaw
                normal = hand.palm_normal
                direction = hand.direction
                pitch = (direction.pitch + Leap.RAD_TO_DEG)
                roll = (direction.roll + Leap.RAD_TO_DEG)
                yaw = (direction.yaw + Leap.RAD_TO_DEG)

                if hand.is_left:
                    #middle position
                    if pitch <= 57.7 and pitch >= 57.2:
                        serDataL = "0"
                    #forward position
                    elif pitch <= 57.2:
                        serDataL = "1"
                    #back position
                    elif pitch >= 57.7:
                        serDataL = "2"
                else:
                    #middle position
                    if pitch <= 57.7 and pitch >= 57.2:
                        serDataR = "0"
                    #forward position
                    elif pitch <= 57.2:
                        serDataR = "1"
                    #back position
                    elif pitch >= 57.7:
                        serDataR = "2"

                #decipher positions, then construct data packet
                serData = serDataL + serDataR
                if serData != serDataOld:
                    if serData == "00":
                        serDC = "0"
                        
                    elif serData == "10":
                        serDC = "1"
                        
                    elif serData == "20":
                        serDC = "2"
                        
                    elif serData == "01":
                        serDC = "3"

                    elif serData == "02":
                        serDC = "4"
                        
                    elif serData == "11":
                        serDC = "5"
                        
                    elif serData == "21":
                        serDC = "6"
                        
                    elif serData == "12":
                        serDC = "7"
                        
                    elif serData == "22":
                        serDC = "8"

                    #print data and send to Photon   
                    print serData + "   " + serDC
                    particle.devices[device].updateMotors(serDC)
                    serDataOld = serData

        #if there aren't any visible hands, stop motors
        elif len(frame.hands) < 1:
            if not serDataOld == "00":
                particle.devices[device].updateMotors("0")
                print "00   0"
                serDataOld = "00"

def main():

    #create Leap Motion controller and listener objects
    listener = LeapMotionListener()
    controller =  Leap.Controller()
    
    try:
        #only continue if the device is online
        if particle.devices[device].connected:
            print("\nDevice '" + device + "' found, proceeding.")

            #begin listening for Leap Motion data
            controller.add_listener(listener)

            print("\nPress ENTER to quit\n")
            
            sys.stdin.readline()
        else:
            print("\nQuitting because device '" + device + "' is offline.")
        
    except KeyboardInterrupt:
        pass
    
    finally:
        controller.remove_listener(listener)

if __name__ == "__main__":
    main()
