#define LCD_CS A3    
#define LCD_CD A2    
#define LCD_WR A1   
#define LCD_RD A0    
#define LCD_RESET A4

#define	BLACK           0x0000
#define	BLUE            0x001F
#define	RED             0xF800
#define	GREEN           0x07E0
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0 
#define WHITE           0xFFFF

#include "TFTLCD7781.h"
#include <SD.h>
const int chipSelect = 10;
byte count;

TFTLCD7781 tft(LCD_CS, LCD_CD, LCD_WR, LCD_RD, LCD_RESET);

void setup(void) 
{
  Serial.begin(9600);
  Serial.println("8 Bit LCD test!");
  Serial.print("Initializing SD card...");
  
  if (!SD.begin(chipSelect)) {
  Serial.println("Card failed, or not present");
  
  tft.reset();
  tft.initDisplay();
  carderror(RED);
  delay(2000);
  return;
  }
    Serial.println("card initialized.");
  tft.reset();
  tft.initDisplay();
  testtext(GREEN);
  delay(2000);
}

void loop(void) {
  String dataString = "";
  for (int analogPin = 0; analogPin < 5; analogPin++) {
    int sensor = analogRead(analogPin);
    dataString += String(sensor);
    if (analogPin < 4) {
      dataString += ","; 
    }
  }
  File dataFile = SD.open("datalog.txt", FILE_WRITE);
  if (dataFile) {    
    dataFile.println(dataString);
    dataFile.close();
    Serial.println(dataString); 
       
       if(count > 32 ){
       count = 0;
       testtext(RED);
       delay(2000);
       }
       else{
         
       delay(100);
       tft.setTextSize(1);
       tft.setTextColor(GREEN);
       tft.println(dataString);
       delay(100);
       count++;
       } 
    
     }

  else {
    Serial.println("error opening datalog.txt");
  }  
}
void testtext(uint16_t color) {
  tft.fillScreen(BLACK);
  tft.setCursor(85,0);
  tft.setTextColor(RED);
  tft.setTextSize(4);
  tft.println("S");
  tft.setCursor(110,0);
  tft.setTextColor(BLUE);
  tft.println("PS");
  tft.setTextSize(2);
  tft.setTextColor(GREEN);
  tft.println(" www.spelecshop.com");
}
void carderror(uint16_t color) {
  tft.fillScreen(BLACK);
  tft.setCursor(2,95);
  tft.setTextColor(RED);
  tft.setTextSize(4);
  tft.println("CARD ERROR");
}






