
;--------------------------------------------
;	Author: Paul Dack - 2011
;	micro Solar POV display
;	uses PIC10F206 and HEF4794 display driver
;
    #include <p10F206.inc> 

    errorlevel  -302      ; suppress message 302 (BANKSEL) 

    __CONFIG   _CP_OFF & _MCLRE_OFF & _WDT_OFF 

;--------------------------------------------

datapin EQU	0	;GP0 is datapin pin of shift register
strobe	EQU	1	;GP1 is strobe pin of shift register
clock	EQU	2	;GP2 is clock pin of shift register
w_store	EQU	08h	;temporary storage for 'w' when updating display 
del1	EQU	09h	;delay variable 1
del2	EQU	0Ah	;delay variable 2
del3	EQU	0Bh ;delay variable 3
count1	EQU	0Ch	;storage byte for line number remaining
;--------------------------------------------

    org     0x00 			; start location

    andlw    0xFE          	; ensures, that bit 0 = 0 
    movwf    OSCCAL        	; load the factory oscillator calibration value 
    movlw    b'11011111'    ; clear OPTION,5 - GPIO2 as normal I/O not T0CKl 
    OPTION 

    movlw    b'01110001' 	;	Disable comparator and use GP2 as standard I/O
    movwf    CMCON0 

    movlw    b'00001000'        ; GP3 Input, GP2:GP0 Outputs 
    tris    GPIO 

    clrw
    bsf		GPIO,strobe
    goto	main_rtn
;--------------------------------------------

Delay						;adjust delay time to suit
			;1993 cycles
	movlw	0x8E
	movwf	del1
	movlw	0x02
	movwf	del2
Delay_0
	decfsz	del1, f
	goto	$+2
	decfsz	del2, f
	goto	Delay_0

			;3 cycles
	goto	$+1
	nop

			;4 cycles (including call)
	return

main_rtn
		movlw	D'18'			;enter number of lines here (in decimal)
		movwf	count1			;save to count1 variable
line_fetch
		clrw					;clear W register of junk
		addwf   count1,0		;retrieve current line number
		call	Lookup			;retrieve current line data from lookup table
		call	write_to_shift	;write current line to LEDs
		call	Delay			;wait for a bit
		decfsz	count1			;reduce line number by 1 and check:
		goto	line_fetch		;if lines >1 then move to next line
  		goto	main_rtn		;if lines = 0 then start again



Lookup   ADDWF PCL              ; Jump to entry specified by w.
	     RETLW B'00000000'		; Data lines: 1 = LED on, 0 = LED off		
	     RETLW B'00000000'		; don't forget to change line number above
	     RETLW B'00001110'		; when modifying the display data!
	     RETLW B'00011111'
         RETLW B'00111111'
	     RETLW B'01111111'
	     RETLW B'11111110'
	     RETLW B'11111110'
	     RETLW B'01111111'
         RETLW B'00111111'
	     RETLW B'00011111'
	     RETLW B'00001110'
         RETLW B'00000000'
	     RETLW B'00000000'
	     RETLW B'00000000'
	     RETLW B'00000000'
         RETLW B'00000000'
	     RETLW B'00000000'		;last official line, the rest for overshoot
	     RETLW B'00000000'
	     RETLW B'00000000'






write_to_shift	
	movwf	w_store			;save line from W register to examine

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,0		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,1		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,2		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,3		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,4		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,5		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,6		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe

	bsf		GPIO,datapin	;set data high in readiness
	btfss	w_store,7		;check if current pixel is illuminated
	bcf		GPIO,datapin	;if not turn data off
	bsf		GPIO,clock		;toggle clock and strobe to increment shift register by one
	bsf		GPIO,strobe
	bcf		GPIO,clock
	bcf		GPIO,strobe
	return

	end


